/*
 * Decompiled with CFR 0.152.
 */
package ucar.coord;

import java.util.List;
import ucar.coord.Coordinate;
import ucar.nc2.time.Calendar;
import ucar.nc2.time.CalendarDate;
import ucar.nc2.time.CalendarDateRange;
import ucar.nc2.time.CalendarPeriod;

public abstract class CoordinateTimeAbstract
implements Coordinate {
    public static final String MIXED_INTERVALS = "Mixed_intervals";
    protected final int code;
    protected final CalendarPeriod timeUnit;
    protected String periodName;
    protected CalendarDate refDate;
    protected String name = "time";

    CoordinateTimeAbstract(int code, CalendarPeriod timeUnit, CalendarDate refDate) {
        this.code = code;
        this.timeUnit = timeUnit;
        this.refDate = refDate;
        CalendarPeriod.Field cf = timeUnit.getField();
        this.periodName = cf == CalendarPeriod.Field.Month || cf == CalendarPeriod.Field.Year ? "calendar " + cf.toString() : cf.toString();
    }

    @Override
    public int getCode() {
        return this.code;
    }

    public CalendarPeriod getPeriod() {
        return this.timeUnit;
    }

    @Override
    public String getUnit() {
        return this.periodName;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public CalendarDate getRefDate() {
        return this.refDate;
    }

    public void setRefDate(CalendarDate refDate) {
        this.refDate = refDate;
    }

    public double getTimeUnitScale() {
        return this.timeUnit.getValue();
    }

    public CalendarPeriod getTimeUnit() {
        return this.timeUnit;
    }

    public abstract CoordinateTimeAbstract makeBestTimeCoordinate(List<Double> var1);

    public abstract CalendarDateRange makeCalendarDateRange(Calendar var1);
}

