/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.storage;

import java.awt.Rectangle;
import java.awt.image.ColorModel;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.util.Map;
import org.apache.sis.internal.coverage.j2d.BatchComputedImage;
import org.apache.sis.internal.storage.TiledGridCoverage;

final class TiledDeferredImage
extends BatchComputedImage {
    private final int width;
    private final int height;
    private final int minTileX;
    private final int minTileY;
    private final TiledGridCoverage.AOI iterator;

    TiledDeferredImage(int[] nArray, int[] nArray2, Map<String, Object> map, TiledGridCoverage.AOI aOI) {
        super(aOI.getCoverage().model, map, new RenderedImage[0]);
        this.width = nArray[0];
        this.height = nArray[1];
        this.minTileX = nArray2[0];
        this.minTileY = nArray2[1];
        this.iterator = aOI;
    }

    @Override
    public ColorModel getColorModel() {
        return this.iterator.getCoverage().colors;
    }

    @Override
    public final int getMinX() {
        return this.iterator.getTileOrigin(0);
    }

    @Override
    public final int getMinY() {
        return this.iterator.getTileOrigin(1);
    }

    @Override
    public final int getWidth() {
        return this.width;
    }

    @Override
    public final int getHeight() {
        return this.height;
    }

    @Override
    public final int getMinTileX() {
        return this.minTileX;
    }

    @Override
    public final int getMinTileY() {
        return this.minTileY;
    }

    @Override
    protected Raster[] computeTiles(Rectangle rectangle) throws Exception {
        TiledGridCoverage.AOI aOI = this.iterator.subset(new int[]{rectangle.x, rectangle.y}, new int[]{Math.addExact(rectangle.x, rectangle.width), Math.addExact(rectangle.y, rectangle.height)});
        return aOI.getCoverage().readTiles(aOI);
    }
}

