/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.analytics.function.reduction;

import java.util.function.UnaryOperator;
import org.apache.solr.analytics.ExpressionFactory;
import org.apache.solr.analytics.function.ReductionFunction;
import org.apache.solr.analytics.function.reduction.data.ReductionDataCollector;
import org.apache.solr.analytics.function.reduction.data.SortedListCollector;
import org.apache.solr.analytics.value.AnalyticsValueStream;
import org.apache.solr.analytics.value.DateValue;
import org.apache.solr.analytics.value.DateValueStream;
import org.apache.solr.analytics.value.DoubleValue;
import org.apache.solr.analytics.value.DoubleValueStream;
import org.apache.solr.analytics.value.FloatValueStream;
import org.apache.solr.analytics.value.IntValueStream;
import org.apache.solr.analytics.value.LongValueStream;
import org.apache.solr.common.SolrException;

public class MedianFunction {
    public static final String name = "median";
    public static final ExpressionFactory.CreatorFunction creatorFunction = params -> {
        if (params.length != 1) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "The median function requires 1 paramater, " + params.length + " found.");
        }
        AnalyticsValueStream param = params[0];
        if (param instanceof DateValueStream) {
            return new DateMedianFunction((DateValueStream)param);
        }
        if (param instanceof IntValueStream) {
            return new IntMedianFunction((IntValueStream)param);
        }
        if (param instanceof LongValueStream) {
            return new LongMedianFunction((LongValueStream)param);
        }
        if (param instanceof FloatValueStream) {
            return new FloatMedianFunction((FloatValueStream)param);
        }
        if (param instanceof DoubleValueStream) {
            return new DoubleMedianFunction((DoubleValueStream)param);
        }
        throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "The median function requires a date or numeric parameter.");
    };

    static class DateMedianFunction
    extends DateValue.AbstractDateValue
    implements ReductionFunction {
        private SortedListCollector.SortedLongListCollector collector;
        public static final String name = "median";
        private final String exprStr;

        public DateMedianFunction(DateValueStream param) {
            this.collector = new SortedListCollector.SortedLongListCollector(param);
            this.exprStr = AnalyticsValueStream.createExpressionString("median", param);
        }

        @Override
        public long getLong() {
            int size = this.collector.size();
            if (size == 0) {
                return 0L;
            }
            if (size % 2 == 0) {
                return ((Long)this.collector.get(size / 2) + (Long)this.collector.get(size / 2 - 1)) / 2L;
            }
            return (Long)this.collector.get(size / 2);
        }

        @Override
        public boolean exists() {
            return this.collector.size() > 0;
        }

        @Override
        public void synchronizeDataCollectors(UnaryOperator<ReductionDataCollector<?>> sync) {
            this.collector = (SortedListCollector.SortedLongListCollector)sync.apply(this.collector);
            this.collector.calcMedian();
        }

        @Override
        public String getName() {
            return "median";
        }

        @Override
        public String getExpressionStr() {
            return this.exprStr;
        }

        @Override
        public AnalyticsValueStream.ExpressionType getExpressionType() {
            return AnalyticsValueStream.ExpressionType.REDUCTION;
        }
    }

    static class DoubleMedianFunction
    extends NumericMedianFunction<Double> {
        public DoubleMedianFunction(DoubleValueStream param) {
            super(param, new SortedListCollector.SortedDoubleListCollector(param));
        }

        @Override
        protected double collectOrd(int ord) {
            return (Double)this.collector.get(ord);
        }
    }

    static class FloatMedianFunction
    extends NumericMedianFunction<Float> {
        public FloatMedianFunction(FloatValueStream param) {
            super((DoubleValueStream)((Object)param), new SortedListCollector.SortedFloatListCollector(param));
        }

        @Override
        protected double collectOrd(int ord) {
            return ((Float)this.collector.get(ord)).floatValue();
        }
    }

    static class LongMedianFunction
    extends NumericMedianFunction<Long> {
        public LongMedianFunction(LongValueStream param) {
            super((DoubleValueStream)((Object)param), new SortedListCollector.SortedLongListCollector(param));
        }

        @Override
        protected double collectOrd(int ord) {
            return ((Long)this.collector.get(ord)).longValue();
        }
    }

    static class IntMedianFunction
    extends NumericMedianFunction<Integer> {
        public IntMedianFunction(IntValueStream param) {
            super((DoubleValueStream)((Object)param), new SortedListCollector.SortedIntListCollector(param));
        }

        @Override
        protected double collectOrd(int ord) {
            return ((Integer)this.collector.get(ord)).intValue();
        }
    }

    static abstract class NumericMedianFunction<T extends Comparable<T>>
    extends DoubleValue.AbstractDoubleValue
    implements ReductionFunction {
        protected SortedListCollector<T> collector;
        public static final String name = "median";
        private final String exprStr;

        public NumericMedianFunction(DoubleValueStream param, SortedListCollector<T> collector) {
            this.collector = collector;
            this.exprStr = AnalyticsValueStream.createExpressionString("median", param);
        }

        protected abstract double collectOrd(int var1);

        @Override
        public double getDouble() {
            int size = this.collector.size();
            if (size == 0) {
                return 0.0;
            }
            if (size % 2 == 0) {
                return (this.collectOrd(size / 2) + this.collectOrd(size / 2 - 1)) / 2.0;
            }
            return this.collectOrd(size / 2);
        }

        @Override
        public boolean exists() {
            return this.collector.size() > 0;
        }

        @Override
        public void synchronizeDataCollectors(UnaryOperator<ReductionDataCollector<?>> sync) {
            this.collector = (SortedListCollector)sync.apply(this.collector);
            this.collector.calcMedian();
        }

        @Override
        public String getName() {
            return "median";
        }

        @Override
        public String getExpressionStr() {
            return this.exprStr;
        }

        @Override
        public AnalyticsValueStream.ExpressionType getExpressionType() {
            return AnalyticsValueStream.ExpressionType.REDUCTION;
        }
    }
}

