/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.parser.microsoft.onenote.fsshttpb.streamobj;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.tika.exception.TikaException;
import org.apache.tika.parser.microsoft.onenote.fsshttpb.exception.DataElementParseErrorException;
import org.apache.tika.parser.microsoft.onenote.fsshttpb.streamobj.DataElementData;
import org.apache.tika.parser.microsoft.onenote.fsshttpb.streamobj.RevisionManifest;
import org.apache.tika.parser.microsoft.onenote.fsshttpb.streamobj.RevisionManifestObjectGroupReferences;
import org.apache.tika.parser.microsoft.onenote.fsshttpb.streamobj.RevisionManifestRootDeclare;
import org.apache.tika.parser.microsoft.onenote.fsshttpb.streamobj.StreamObject;
import org.apache.tika.parser.microsoft.onenote.fsshttpb.streamobj.StreamObjectHeaderStart;
import org.apache.tika.parser.microsoft.onenote.fsshttpb.streamobj.StreamObjectTypeHeaderStart;

public class RevisionManifestDataElementData
extends DataElementData {
    public RevisionManifest revisionManifest = new RevisionManifest();
    public List<RevisionManifestRootDeclare> revisionManifestRootDeclareList = new ArrayList<RevisionManifestRootDeclare>();
    public List<RevisionManifestObjectGroupReferences> revisionManifestObjectGroupReferences = new ArrayList<RevisionManifestObjectGroupReferences>();

    @Override
    public int deserializeDataElementDataFromByteArray(byte[] byteArray, int startIndex) throws TikaException, IOException {
        AtomicInteger index = new AtomicInteger(startIndex);
        this.revisionManifest = StreamObject.getCurrent(byteArray, index, RevisionManifest.class);
        this.revisionManifestRootDeclareList = new ArrayList<RevisionManifestRootDeclare>();
        this.revisionManifestObjectGroupReferences = new ArrayList<RevisionManifestObjectGroupReferences>();
        AtomicReference<StreamObjectHeaderStart> header = new AtomicReference<StreamObjectHeaderStart>();
        int headerLength = 0;
        while ((headerLength = StreamObjectHeaderStart.tryParse(byteArray, index.get(), header)) != 0) {
            if (header.get().type == StreamObjectTypeHeaderStart.RevisionManifestRootDeclare) {
                index.addAndGet(headerLength);
                this.revisionManifestRootDeclareList.add((RevisionManifestRootDeclare)StreamObject.parseStreamObject(header.get(), byteArray, index));
                continue;
            }
            if (header.get().type == StreamObjectTypeHeaderStart.RevisionManifestObjectGroupReferences) {
                index.addAndGet(headerLength);
                this.revisionManifestObjectGroupReferences.add((RevisionManifestObjectGroupReferences)StreamObject.parseStreamObject(header.get(), byteArray, index));
                continue;
            }
            throw new DataElementParseErrorException(index.get(), "Failed to parse RevisionManifestDataElement, expect the inner object type RevisionManifestRootDeclare or RevisionManifestObjectGroupReferences, but actual type value is " + (Object)((Object)header.get().type), null);
        }
        return index.get() - startIndex;
    }

    @Override
    public List<Byte> serializeToByteList() throws TikaException, IOException {
        ArrayList<Byte> byteList = new ArrayList<Byte>();
        byteList.addAll(this.revisionManifest.serializeToByteList());
        if (this.revisionManifestRootDeclareList != null) {
            for (RevisionManifestRootDeclare revisionManifestRootDeclare : this.revisionManifestRootDeclareList) {
                byteList.addAll(revisionManifestRootDeclare.serializeToByteList());
            }
        }
        if (this.revisionManifestObjectGroupReferences != null) {
            for (RevisionManifestObjectGroupReferences revisionManifestObjectGroupReferences : this.revisionManifestObjectGroupReferences) {
                byteList.addAll(revisionManifestObjectGroupReferences.serializeToByteList());
            }
        }
        return byteList;
    }
}

