/*
 * Decompiled with CFR 0.152.
 */
package org.thymeleaf.engine;

import java.io.IOException;
import java.io.Writer;
import org.thymeleaf.engine.AbstractTemplateEvent;
import org.thymeleaf.engine.IEngineTemplateEvent;
import org.thymeleaf.engine.ITemplateHandler;
import org.thymeleaf.model.IDocType;
import org.thymeleaf.model.IModelVisitor;

final class DocType
extends AbstractTemplateEvent
implements IDocType,
IEngineTemplateEvent {
    public static final String DEFAULT_KEYWORD = "DOCTYPE";
    public static final String DEFAULT_ELEMENT_NAME = "html";
    public static final String DEFAULT_TYPE_PUBLIC = "PUBLIC";
    public static final String DEFAULT_TYPE_SYSTEM = "SYSTEM";
    private final String keyword;
    private final String elementName;
    private final String type;
    private final String publicId;
    private final String systemId;
    private final String internalSubset;
    private final String docType;

    DocType() {
        this(null, null);
    }

    DocType(String publicId, String systemId) {
        this(DEFAULT_KEYWORD, DEFAULT_ELEMENT_NAME, publicId, systemId, null);
    }

    DocType(String keyword, String elementName, String publicId, String systemId, String internalSubset) {
        this.keyword = keyword;
        this.elementName = elementName;
        this.type = DocType.computeType(publicId, systemId);
        this.publicId = publicId;
        this.systemId = systemId;
        this.internalSubset = internalSubset;
        this.docType = this.computeDocType();
    }

    DocType(String docType, String keyword, String elementName, String publicId, String systemId, String internalSubset, String templateName, int line, int col) {
        super(templateName, line, col);
        this.keyword = keyword;
        this.elementName = elementName;
        this.type = DocType.computeType(publicId, systemId);
        this.publicId = publicId;
        this.systemId = systemId;
        this.internalSubset = internalSubset;
        this.docType = docType != null ? docType : this.computeDocType();
    }

    @Override
    public String getKeyword() {
        return this.keyword;
    }

    @Override
    public String getElementName() {
        return this.elementName;
    }

    @Override
    public String getType() {
        return this.type;
    }

    @Override
    public String getPublicId() {
        return this.publicId;
    }

    @Override
    public String getSystemId() {
        return this.systemId;
    }

    @Override
    public String getInternalSubset() {
        return this.internalSubset;
    }

    @Override
    public String getDocType() {
        return this.docType;
    }

    private String computeDocType() {
        StringBuilder strBuilder = new StringBuilder(120);
        strBuilder.append("<!");
        strBuilder.append(this.keyword);
        strBuilder.append(' ');
        strBuilder.append(this.elementName);
        if (this.type != null) {
            strBuilder.append(' ');
            strBuilder.append(this.type);
            if (this.publicId != null) {
                strBuilder.append(" \"");
                strBuilder.append(this.publicId);
                strBuilder.append('\"');
            }
            strBuilder.append(" \"");
            strBuilder.append(this.systemId);
            strBuilder.append('\"');
        }
        if (this.internalSubset != null) {
            strBuilder.append(" [");
            strBuilder.append(this.internalSubset);
            strBuilder.append(']');
        }
        strBuilder.append('>');
        return strBuilder.toString();
    }

    private static String computeType(String publicId, String systemId) {
        if (publicId != null && systemId == null) {
            throw new IllegalArgumentException("DOCTYPE clause cannot have a non-null PUBLIC ID and a null SYSTEM ID");
        }
        if (publicId == null && systemId == null) {
            return null;
        }
        if (publicId != null) {
            return DEFAULT_TYPE_PUBLIC;
        }
        return DEFAULT_TYPE_SYSTEM;
    }

    @Override
    public void accept(IModelVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public void write(Writer writer) throws IOException {
        writer.write(this.docType);
    }

    static DocType asEngineDocType(IDocType docType) {
        if (docType instanceof DocType) {
            return (DocType)docType;
        }
        return new DocType(null, docType.getKeyword(), docType.getElementName(), docType.getPublicId(), docType.getSystemId(), docType.getInternalSubset(), docType.getTemplateName(), docType.getLine(), docType.getCol());
    }

    @Override
    public void beHandled(ITemplateHandler handler) {
        handler.handleDocType(this);
    }

    public String toString() {
        return this.getDocType();
    }
}

