/*
 * Decompiled with CFR 0.152.
 */
package tools.jackson.databind.deser.jdk;

import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashSet;
import tools.jackson.databind.ValueDeserializer;
import tools.jackson.databind.deser.jdk.JavaUtilCalendarDeserializer;
import tools.jackson.databind.deser.jdk.JavaUtilDateDeserializer;

public class JDKDateDeserializers {
    private static final HashSet<String> _utilClasses = new HashSet();

    public static ValueDeserializer<?> find(Class<?> rawType, String clsName) {
        if (_utilClasses.contains(clsName)) {
            if (rawType == Calendar.class) {
                return new JavaUtilCalendarDeserializer();
            }
            if (rawType == Date.class) {
                return JavaUtilDateDeserializer.instance;
            }
            if (rawType == GregorianCalendar.class) {
                return new JavaUtilCalendarDeserializer((Class<? extends Calendar>)GregorianCalendar.class);
            }
        }
        return null;
    }

    public static boolean hasDeserializerFor(Class<?> rawType) {
        return _utilClasses.contains(rawType.getName());
    }

    static {
        _utilClasses.add("java.util.Calendar");
        _utilClasses.add("java.util.GregorianCalendar");
        _utilClasses.add("java.util.Date");
    }
}

