/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.db2.cmx.tools.internal.binder.classloaders;

import com.ibm.db2.cmx.runtime.generator.BaseCallHandler;
import com.ibm.db2.cmx.runtime.generator.BaseGeneratorCallHandler;
import com.ibm.db2.cmx.runtime.generator.BaseRowHandler;
import com.ibm.db2.cmx.runtime.handlers.BatchHandler;
import com.ibm.db2.cmx.runtime.handlers.CallHandler;
import com.ibm.db2.cmx.runtime.handlers.CallHandlerWithParameters;
import com.ibm.db2.cmx.runtime.handlers.ParameterHandler;
import com.ibm.db2.cmx.runtime.handlers.ResultHandler;
import com.ibm.db2.cmx.runtime.handlers.RowHandler;
import com.ibm.db2.cmx.runtime.internal.resources.Messages;
import com.ibm.db2.cmx.tools.internal.ToolsLogger;
import com.ibm.db2.cmx.tools.internal.binder.classloaders.ClassLoaderHelper;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;
import java.util.logging.Level;
import org.apache.bcel.classfile.ClassParser;
import org.apache.bcel.classfile.JavaClass;
import org.apache.bcel.generic.ClassGen;

public class ArchiveClassLoader
extends ClassLoader {
    String archiveName_;
    Hashtable<String, String> classToFileNameMap = new Hashtable();
    ArrayList<String> zipEntries = new ArrayList();
    public static final String FAKE_BIND_PROPS_NAME = "~!AUTO_DETECTED_BIND_PROPS_CONTENTS!~";

    public ArchiveClassLoader(String string, ClassLoader classLoader) throws IOException {
        super(classLoader);
        this.archiveName_ = string;
        this.indexContents();
    }

    protected void indexContents() throws IOException {
        ArrayList<String> arrayList = ClassLoaderHelper.getEarEntryNamesBreadthFirst(this.archiveName_);
        this.zipEntries = arrayList;
        ToolsLogger.getLogger().log(Level.FINER, "Entry count: " + arrayList.size());
        Iterator<String> iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            String string;
            String string2 = string = iterator.next();
            if (string.endsWith("/") || string.endsWith(".war") || string.endsWith(".jar")) continue;
            ToolsLogger.getLogger().log(Level.FINER, "Archive Entry: " + string);
            int n2 = string.indexOf(58);
            if (n2 > -1) {
                string2 = string.substring(n2 + 1);
                if ((n2 = string2.indexOf(58)) > -1) {
                    string2 = string2.substring(n2 + 1);
                    this.mapClassNameToOriginalName(string, string2);
                    continue;
                }
                this.mapClassNameToOriginalName(string, string2);
                continue;
            }
            this.mapClassNameToOriginalName(string, string2);
        }
        ToolsLogger.getLogger().log(Level.FINER, "Map size: " + this.classToFileNameMap.size());
    }

    private void mapClassNameToOriginalName(String string, String string2) {
        if (string2.toLowerCase().startsWith("web-inf/classes/")) {
            if (string2.endsWith(".class")) {
                String string3 = string2.substring("WEB-INF/classes/".length(), string2.length() - ".class".length());
                string3 = string3.replace('/', '.');
                this.classToFileNameMap.put(string3, string);
                ToolsLogger.getLogger().log(Level.FINEST, "Map class: " + string3 + " => " + string);
            } else {
                String string4 = string2.substring("WEB-INF/classes/".length(), string2.length());
                this.classToFileNameMap.put(string4, string);
                this.classToFileNameMap.put(string2, string);
                this.classToFileNameMap.put(string, string);
                ToolsLogger.getLogger().log(Level.FINEST, "Map resource: " + string4 + " => " + string);
                if (!string4.equals(string2)) {
                    ToolsLogger.getLogger().log(Level.FINEST, "Map resource: " + string2 + " => " + string);
                }
                if (!string.equals(string2)) {
                    ToolsLogger.getLogger().log(Level.FINEST, "Map resource: " + string + " => " + string);
                }
            }
        } else if (string2.toLowerCase().startsWith("web-inf/")) {
            if (string2.endsWith(".class")) {
                String string5 = string2.substring("WEB-INF/".length(), string2.length() - ".class".length());
                string5 = string5.replace('/', '.');
                this.classToFileNameMap.put(string5, string);
                ToolsLogger.getLogger().log(Level.FINEST, "Map class: " + string5 + " => " + string);
            } else {
                String string6 = string2.substring("WEB-INF/".length(), string2.length());
                this.classToFileNameMap.put(string6, string);
                this.classToFileNameMap.put(string2, string);
                this.classToFileNameMap.put(string, string);
                ToolsLogger.getLogger().log(Level.FINEST, "Map resource: " + string6 + " => " + string);
                if (!string6.equals(string2)) {
                    ToolsLogger.getLogger().log(Level.FINEST, "Map resource: " + string2 + " => " + string);
                }
                if (!string.equals(string2)) {
                    ToolsLogger.getLogger().log(Level.FINEST, "Map resource: " + string + " => " + string);
                }
            }
        } else if (string2.endsWith(".class")) {
            String string7 = string2.substring(0, string2.length() - ".class".length());
            string7 = string7.replace('/', '.');
            this.classToFileNameMap.put(string7, string);
            ToolsLogger.getLogger().log(Level.FINEST, "Map class: " + string7 + " => " + string);
        } else {
            this.classToFileNameMap.put(string2, string);
            this.classToFileNameMap.put(string, string);
            ToolsLogger.getLogger().log(Level.FINEST, "Map resource: " + string2 + " => " + string);
            if (!string.equals(string2)) {
                ToolsLogger.getLogger().log(Level.FINEST, "Map resource: " + string + " => " + string);
            }
        }
    }

    @Override
    protected synchronized Class<?> loadClass(String string, boolean bl2) throws ClassNotFoundException {
        Class<?> clazz = this.findLoadedClass(string);
        if (clazz == null) {
            try {
                clazz = this.getParent().loadClass(string);
                if (bl2) {
                    this.resolveClass(clazz);
                }
                return clazz;
            }
            catch (ClassNotFoundException classNotFoundException) {
            }
            catch (NoClassDefFoundError noClassDefFoundError) {
                // empty catch block
            }
            ToolsLogger.getLogger().log(Level.FINER, "Binder loading class: " + string);
            String string2 = this.classToFileNameMap.get(string);
            if (string2 == null) {
                throw new ClassNotFoundException(Messages.getText("MSG_NOT_FOUND2", string, this.archiveName_));
            }
            byte[] byArray = null;
            int n2 = string2.indexOf(58);
            if (n2 == -1) {
                byArray = ClassLoaderHelper.readClassBytesFromJar(this.archiveName_, string2);
                clazz = this.getFakeClass(byArray, string);
                if (clazz == null) {
                    clazz = this.defineClass(string, byArray, 0, byArray.length);
                }
            } else {
                String string3 = string2.substring(0, n2);
                String string4 = string2.substring(n2 + 1);
                if ((n2 = string4.indexOf(58)) == -1) {
                    byArray = ClassLoaderHelper.readClassBytesFromJarInsideWar(this.archiveName_, string3, string4);
                    clazz = this.getFakeClass(byArray, string);
                    if (clazz == null) {
                        clazz = this.defineClass(string, byArray, 0, byArray.length);
                    }
                } else {
                    String string5 = string4.substring(0, n2);
                    byArray = ClassLoaderHelper.readClassBytesFromJarInsideWarInsideEar(this.archiveName_, string3, string5, string4 = string4.substring(n2 + 1));
                    clazz = this.getFakeClass(byArray, string);
                    if (clazz == null) {
                        clazz = this.defineClass(string, byArray, 0, byArray.length);
                    }
                }
            }
        }
        if (bl2) {
            ToolsLogger.getLogger().log(Level.FINEST, "Resolving class: " + string);
            this.resolveClass(clazz);
        }
        ToolsLogger.getLogger().log(Level.FINEST, "Binder loaded class: " + string);
        return clazz;
    }

    private Class getFakeClass(byte[] byArray, String string) throws ClassNotFoundException {
        try {
            return this.getFakeClassBCEL(byArray, string);
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            ToolsLogger.getLogger().log(Level.FINEST, "Unable produce dummy user class due to NoClassDefFoundError. Will load actual user class. This may pull in excessive amount of dependencies.", noClassDefFoundError);
        }
        catch (Exception exception) {
            ToolsLogger.getLogger().log(Level.FINEST, "Unable produce dummy user class due to unknown error. Will load actual user class. This may pull in excessive amount of dependencies.", exception);
        }
        return null;
    }

    private Class getFakeClassBCEL(byte[] byArray, String string) throws ClassNotFoundException {
        try {
            if (string.startsWith("com.ibm")) {
                return null;
            }
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
            ClassParser classParser = new ClassParser((InputStream)byteArrayInputStream, string.replace('.', '/') + ".class");
            JavaClass javaClass = classParser.parse();
            if (javaClass.isInterface()) {
                return null;
            }
            if (javaClass.getSuperclassName().equals("com.ibm.db2.cmx.runtime.generator.BaseData")) {
                return null;
            }
            TypesToFake typesToFake = this.getInterfaceToFake(javaClass);
            if (typesToFake != null && typesToFake != TypesToFake.NONE) {
                InputStream inputStream = null;
                String string2 = null;
                if (typesToFake != null && typesToFake != TypesToFake.NONE) {
                    inputStream = this.getParent().getResourceAsStream("com/ibm/pdq/tools/internal/binder/classloaders/DummyHandler.class");
                    string2 = "com/ibm/pdq/tools/internal/binder/classloaders/DummyHandler.class";
                }
                if (inputStream != null) {
                    byArray = ClassLoaderHelper.getBytesFromInputStream(inputStream);
                    inputStream.close();
                    byteArrayInputStream = new ByteArrayInputStream(byArray);
                    classParser = new ClassParser((InputStream)byteArrayInputStream, string2);
                    javaClass = classParser.parse();
                    ClassGen classGen = new ClassGen(javaClass);
                    classGen.setClassName(string);
                    javaClass = classGen.getJavaClass();
                    byArray = javaClass.getBytes();
                    ToolsLogger.getLogger().log(Level.FINEST, "Return dummy class: " + string);
                    return this.defineClass(string, byArray, 0, byArray.length);
                }
            }
            return null;
        }
        catch (IOException iOException) {
            ToolsLogger.getLogger().log(Level.FINEST, "Error faking class", iOException);
            throw new ClassNotFoundException(string, iOException);
        }
        catch (Exception exception) {
            ToolsLogger.getLogger().log(Level.FINEST, "Error faking class", exception);
            throw new ClassNotFoundException(string, exception);
        }
    }

    private TypesToFake getInterfaceToFake(JavaClass javaClass) throws IOException {
        TypesToFake typesToFake = TypesToFake.NONE;
        String[] stringArray = javaClass.getInterfaceNames();
        for (String string : stringArray) {
            if (com.ibm.db2.cmx.runtime.generator.ParameterHandler.class.getName().equals(string)) {
                typesToFake = TypesToFake.GEN_PARAM_HANDLER;
                break;
            }
            if (ParameterHandler.class.getName().equals(string)) {
                typesToFake = TypesToFake.PARAM_HANDLER;
                break;
            }
            if (RowHandler.class.getName().equals(string)) {
                typesToFake = TypesToFake.ROW_HANDLER;
                break;
            }
            if (BatchHandler.class.getName().equals(string)) {
                typesToFake = TypesToFake.BATCH_HANDLER;
                break;
            }
            if (ResultHandler.class.getName().equals(string)) {
                typesToFake = TypesToFake.RESULT_HANDLER;
                break;
            }
            if (CallHandler.class.getName().equals(string)) {
                typesToFake = TypesToFake.CALL_HANDLER;
                break;
            }
            if (!CallHandlerWithParameters.class.getName().equals(string)) continue;
            typesToFake = TypesToFake.CALL_HANDLER_W_PARAM;
            break;
        }
        String string = javaClass.getSuperclassName();
        if (typesToFake == TypesToFake.NONE) {
            if (string.equals(BaseGeneratorCallHandler.class.getName())) {
                typesToFake = TypesToFake.CALL_HANDLER_W_PARAM;
            } else if (string.equals(BaseRowHandler.class.getName())) {
                typesToFake = TypesToFake.ROW_HANDLER;
            } else if (string.equals(BaseCallHandler.class.getName())) {
                typesToFake = TypesToFake.CALL_HANDLER;
            }
        }
        if (typesToFake == TypesToFake.NONE && !"java.lang.Object".equals(string)) {
            typesToFake = this.getSuperclassInterfaceToFake(string);
        }
        return typesToFake;
    }

    private TypesToFake getSuperclassInterfaceToFake(String string) throws IOException {
        if (string.startsWith("com.ibm")) {
            return TypesToFake.NONE;
        }
        string = string.replace('.', '/') + ".class";
        InputStream inputStream = this.getResourceAsStream(string);
        byte[] byArray = ClassLoaderHelper.getBytesFromInputStream(inputStream);
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        ClassParser classParser = new ClassParser((InputStream)byteArrayInputStream, string);
        JavaClass javaClass = classParser.parse();
        return this.getInterfaceToFake(javaClass);
    }

    @Override
    public InputStream getResourceAsStream(String string) {
        InputStream inputStream = this.getParent().getResourceAsStream(string);
        if (inputStream == null) {
            ToolsLogger.getLogger().log(Level.FINER, "ArchiveClassLoader::getResourceAsStream: " + string);
            inputStream = this.loadResourceAsStream(string);
        }
        if (inputStream != null) {
            ToolsLogger.getLogger().log(Level.FINER, "ArchiveClassLoader::getResourceAsStream returns: NOT null");
        } else {
            ToolsLogger.getLogger().log(Level.FINER, "ArchiveClassLoader::getResourceAsStream returns: null");
        }
        return inputStream;
    }

    public InputStream loadResourceAsStream(String string) {
        try {
            InputStream inputStream;
            String string2;
            if (string.equals(FAKE_BIND_PROPS_NAME)) {
                return this.getFakeBindPropsWithAutoDetectedContents("");
            }
            if (string.endsWith(".bindProps") && string.startsWith("/")) {
                string = string.substring(1);
            }
            if (string.endsWith(".class")) {
                string2 = string.substring(0, string.length() - ".class".length());
                if (string2.toLowerCase().startsWith("web-inf/classes/")) {
                    string2 = string2.substring("web-inf/classes/".length());
                }
                string = string2.replace('/', '.');
            }
            if ((string2 = this.classToFileNameMap.get(string)) == null) {
                return null;
            }
            int n2 = string2.indexOf(58);
            if (n2 == -1) {
                inputStream = ClassLoaderHelper.getInputStreamForResourceInJar(this.archiveName_, string2);
            } else {
                String string3 = string2.substring(0, n2);
                String string4 = string2.substring(n2 + 1);
                if ((n2 = string4.indexOf(58)) == -1) {
                    inputStream = ClassLoaderHelper.getInputStreamForResourceInJarInsideWar(this.archiveName_, string3, string4);
                } else {
                    String string5 = string4.substring(0, n2);
                    string4 = string4.substring(n2 + 1);
                    inputStream = ClassLoaderHelper.getInputStreamForResourceInJarInsideWarInsideEar(this.archiveName_, string3, string5, string4);
                }
            }
            return inputStream;
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            ToolsLogger.getLogger().log(Level.FINE, noClassDefFoundError.getMessage(), noClassDefFoundError);
            throw noClassDefFoundError;
        }
        catch (Throwable throwable) {
            ToolsLogger.getLogger().log(Level.FINE, throwable.getMessage(), throwable);
            return null;
        }
    }

    private InputStream getFakeBindPropsWithAutoDetectedContents(String string) {
        try {
            StringBuilder stringBuilder = new StringBuilder();
            for (String object2 : this.zipEntries) {
                if (object2.endsWith("Impl.class")) {
                    this.addImplToFakeBindProps(object2, stringBuilder);
                    continue;
                }
                if (!object2.endsWith(".pdqxml")) continue;
                this.addPdqXmlToFakeBindProps(object2, stringBuilder);
            }
            if (string != null && string.length() > 0) {
                string = string + "\n";
            }
            String string2 = string + stringBuilder.toString();
            stringBuilder = null;
            byte[] byArray = string2.getBytes("UTF-8");
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
            return byteArrayInputStream;
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            ToolsLogger.getLogger().log(Level.FINEST, "Error creating auto detected bindProps content: " + unsupportedEncodingException.getMessage());
        }
        catch (IOException iOException) {
            ToolsLogger.getLogger().log(Level.FINEST, "Error creating auto detected bindProps content: " + iOException.getMessage());
        }
        return null;
    }

    private void addImplToFakeBindProps(String string, StringBuilder stringBuilder) throws IOException {
        String string2;
        int n2 = string.lastIndexOf(58);
        InputStream inputStream = this.loadResourceAsStream(string = string.substring(n2 + 1));
        byte[] byArray = ClassLoaderHelper.getBytesFromInputStream(inputStream);
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        ClassParser classParser = new ClassParser((InputStream)byteArrayInputStream, string);
        JavaClass javaClass = classParser.parse();
        String string3 = javaClass.getClassName();
        if (!string3.startsWith("com.ibm.db2.cmx.runtime.internal.repository.sql.") && "com.ibm.db2.cmx.runtime.generator.BaseData".equals(string2 = javaClass.getSuperclassName())) {
            string3 = javaClass.getClassName();
            String string4 = string3.substring(0, string3.length() - "Impl".length());
            ToolsLogger.getLogger().log(Level.FINEST, "Auto detected class to bind: " + string3);
            ToolsLogger.getLogger().log(Level.FINEST, "Adding interface to bind: " + string4);
            stringBuilder.append(string4 + "=\n");
        }
    }

    private void addPdqXmlToFakeBindProps(String string, StringBuilder stringBuilder) {
        int n2 = string.lastIndexOf(58);
        string = string.substring(n2 + 1);
        stringBuilder.append(string + "=\n");
    }

    @Override
    protected Class<?> findClass(String string) throws ClassNotFoundException {
        ToolsLogger.getLogger().log(Level.FINER, "ArchiveClassLoader::findClass(" + string + ")");
        return super.findClass(string);
    }

    @Override
    protected Enumeration<URL> findResources(String string) throws IOException {
        ToolsLogger.getLogger().log(Level.FINER, "ArchiveClassLoader::findResources(" + string + ")");
        URL uRL = this.findResource(string);
        if (uRL != null) {
            Vector<URL> vector = new Vector<URL>();
            vector.add(uRL);
            return vector.elements();
        }
        return super.findResources(string);
    }

    @Override
    protected URL findResource(String string) {
        ToolsLogger.getLogger().log(Level.FINEST, "ArchiveClassLoader::findResource(" + string + ")");
        if (this.classToFileNameMap.containsKey(string)) {
            try {
                URL uRL = new URL("pdqbind:" + string);
                return uRL;
            }
            catch (MalformedURLException malformedURLException) {
                malformedURLException.printStackTrace();
            }
        }
        return super.findResource(string);
    }

    @Override
    public URL getResource(String string) {
        ToolsLogger.getLogger().log(Level.FINEST, "ArchiveClassLoader::getResource(" + string + ")");
        return super.getResource(string);
    }

    @Override
    public Enumeration<URL> getResources(String string) throws IOException {
        ToolsLogger.getLogger().log(Level.FINEST, "ArchiveClassLoader::getResources(" + string + ")");
        return super.getResources(string);
    }

    private static enum TypesToFake {
        NONE,
        PARAM_HANDLER,
        GEN_PARAM_HANDLER,
        ROW_HANDLER,
        CALL_HANDLER,
        CALL_HANDLER_W_PARAM,
        RESULT_HANDLER,
        BATCH_HANDLER;

    }
}

