/*
 * Decompiled with CFR 0.152.
 */
package org.duckdb;

import java.sql.Time;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.TimeZone;
import java.util.concurrent.TimeUnit;
import org.duckdb.DuckDBTimestamp;

public class DuckDBTime
extends DuckDBTimestamp {
    public DuckDBTime(Time time) {
        super(TimeUnit.MILLISECONDS.toMicros(DuckDBTime.timeToMillis(time)));
    }

    public DuckDBTime(LocalTime lt) {
        super(TimeUnit.NANOSECONDS.toMicros(lt.toNanoOfDay()));
    }

    private static long timeToMillis(Time time) {
        Instant instant = Instant.ofEpochMilli(time.getTime());
        ZoneId zoneId = TimeZone.getDefault().toZoneId();
        LocalDateTime ldt = LocalDateTime.ofInstant(instant, zoneId);
        ZonedDateTime utc = ldt.atZone(ZoneId.of("UTC"));
        return utc.toInstant().toEpochMilli();
    }
}

