/*
 * Decompiled with CFR 0.152.
 */
package oracle.net.ns;

import java.io.IOException;
import java.lang.reflect.Executable;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.jdbc.driver.ClioSupport;
import oracle.jdbc.logging.annotations.DefaultLogger;
import oracle.jdbc.logging.annotations.Feature;
import oracle.jdbc.logging.annotations.Log;
import oracle.jdbc.logging.annotations.Supports;
import oracle.jdbc.logging.runtime.TraceControllerImpl;
import oracle.net.ns.NetException;
import oracle.net.ns.SessionAtts;

@DefaultLogger(value="oracle.net.ns")
@Supports(value={Feature.NET})
final class NIOHeader {
    int length;
    int packetChecksum;
    int flags;
    int headerChecksum;
    int type;
    final SessionAtts session;
    private static Executable $$$methodRef$$$0;
    private static Logger $$$loggerRef$$$0;
    private static Executable $$$methodRef$$$1;
    private static Logger $$$loggerRef$$$1;
    private static Executable $$$methodRef$$$2;
    private static Logger $$$loggerRef$$$2;
    private static Executable $$$methodRef$$$3;
    private static Logger $$$loggerRef$$$3;

    NIOHeader(SessionAtts session) {
        boolean bl = (0x20000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$3, Level.FINEST, NIOHeader.class, $$$methodRef$$$3, null, session);
            }
            this.session = session;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$3, Level.FINEST, NIOHeader.class, $$$methodRef$$$3, null);
                ClioSupport.exiting($$$loggerRef$$$3, Level.FINEST, NIOHeader.class, $$$methodRef$$$3, null, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$3, Level.FINEST, NIOHeader.class, $$$methodRef$$$3, null, throwable2);
            }
            throw throwable;
        }
    }

    final void readHeaderBuffer() throws IOException, NetException {
        boolean bl = (0x20000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$0, Level.FINEST, NIOHeader.class, $$$methodRef$$$0, this, new Object[0]);
            }
            this.session.headerBufferForRead = this.session.readBuffer.slice();
            this.session.headerBufferForRead.clear();
            this.session.headerBufferForRead.limit(8);
            this.session.headerBufferForRead.rewind();
            this.readNSHeader();
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$0, Level.FINEST, NIOHeader.class, $$$methodRef$$$0, this);
                ClioSupport.exiting($$$loggerRef$$$0, Level.FINEST, NIOHeader.class, $$$methodRef$$$0, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$0, Level.FINEST, NIOHeader.class, $$$methodRef$$$0, this, throwable2);
            }
            throw throwable;
        }
    }

    final void readNSHeader() throws IOException {
        boolean bl = (0x20000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$1, Level.FINEST, NIOHeader.class, $$$methodRef$$$1, this, new Object[0]);
            }
            if (this.session.isLargeSDU && (this.type == 6 || this.type == 12 || this.type == 15 || this.type == 14)) {
                this.length = this.session.headerBufferForRead.getInt() & 0xFFFFFFFF;
            } else {
                this.length = this.session.headerBufferForRead.getShort() & 0xFFFF;
                this.packetChecksum = this.session.headerBufferForRead.getShort() & 0xFFFF;
            }
            this.type = this.session.headerBufferForRead.get() & 0xFF;
            this.flags = this.session.headerBufferForRead.get() & 0xFF;
            this.headerChecksum = this.session.headerBufferForRead.getShort() & 0xFFFF;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$1, Level.FINEST, NIOHeader.class, $$$methodRef$$$1, this);
                ClioSupport.exiting($$$loggerRef$$$1, Level.FINEST, NIOHeader.class, $$$methodRef$$$1, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$1, Level.FINEST, NIOHeader.class, $$$methodRef$$$1, this, throwable2);
            }
            throw throwable;
        }
    }

    final void fillHeaderBuffer() throws IOException {
        boolean bl = (0x20000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$2, Level.FINEST, NIOHeader.class, $$$methodRef$$$2, this, new Object[0]);
            }
            this.session.headerBufferForWrite.clear();
            if (bl) {
                this.debug($$$loggerRef$$$2, Level.FINEST, $$$methodRef$$$2, "session.headerBuffer: " + this.session.headerBufferForWrite);
            }
            if (this.session.isLargeSDU && (this.type == 6 || this.type == 12 || this.type == 15 || this.type == 14)) {
                this.session.headerBufferForWrite.putInt(this.length);
            } else {
                this.session.headerBufferForWrite.putShort((short)this.length);
                this.session.headerBufferForWrite.putShort((short)0);
            }
            this.session.headerBufferForWrite.put((byte)this.type);
            this.session.headerBufferForWrite.put((byte)this.flags);
            this.session.headerBufferForWrite.putShort((short)0);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$2, Level.FINEST, NIOHeader.class, $$$methodRef$$$2, this);
                ClioSupport.exiting($$$loggerRef$$$2, Level.FINEST, NIOHeader.class, $$$methodRef$$$2, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$2, Level.FINEST, NIOHeader.class, $$$methodRef$$$2, this, throwable2);
            }
            throw throwable;
        }
    }

    @Log
    protected void debug(Logger logger, Level level, Executable method, String msg) {
        ClioSupport.log(logger, level, this.getClass(), method, msg);
    }

    static {
        try {
            $$$methodRef$$$3 = NIOHeader.class.getDeclaredConstructor(SessionAtts.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.net.ns");
        try {
            $$$methodRef$$$2 = NIOHeader.class.getDeclaredMethod("fillHeaderBuffer", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.net.ns");
        try {
            $$$methodRef$$$1 = NIOHeader.class.getDeclaredMethod("readNSHeader", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.net.ns");
        try {
            $$$methodRef$$$0 = NIOHeader.class.getDeclaredMethod("readHeaderBuffer", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.net.ns");
    }
}

