/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.jaybird.util;

import java.sql.SQLException;
import java.util.Objects;
import java.util.function.Function;
import org.firebirdsql.jaybird.util.SQLExceptionThrowingFunction;
import org.firebirdsql.jaybird.util.UncheckedSQLException;
import org.jspecify.annotations.NullUnmarked;

@NullUnmarked
final class SQLExceptionThrowingFunctionWrappingFunction<T, R>
implements SQLExceptionThrowingFunction<T, R> {
    private final Function<T, R> wrapped;

    SQLExceptionThrowingFunctionWrappingFunction(Function<T, R> wrapped) {
        this.wrapped = Objects.requireNonNull(wrapped, "wrapped");
    }

    @Override
    public R apply(T t) throws SQLException {
        try {
            return this.wrapped.apply(t);
        }
        catch (UncheckedSQLException e) {
            throw e.getCause();
        }
    }

    @Override
    public Function<T, R> toFunction() {
        return this.wrapped;
    }
}

