/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml;

import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.sourceforge.plantuml.DefinitionsContainer;
import net.sourceforge.plantuml.PSystemBuilder;
import net.sourceforge.plantuml.Previous;
import net.sourceforge.plantuml.StringUtils;
import net.sourceforge.plantuml.cli.GlobalConfig;
import net.sourceforge.plantuml.cli.GlobalConfigKey;
import net.sourceforge.plantuml.code.AsciiEncoder;
import net.sourceforge.plantuml.code.Transcoder;
import net.sourceforge.plantuml.code.TranscoderUtil;
import net.sourceforge.plantuml.core.Diagram;
import net.sourceforge.plantuml.error.PSystemErrorPreprocessor;
import net.sourceforge.plantuml.jaws.Jaws;
import net.sourceforge.plantuml.log.Logme;
import net.sourceforge.plantuml.nio.PathSystem;
import net.sourceforge.plantuml.preproc.Defines;
import net.sourceforge.plantuml.preproc.PreprocessingArtifact;
import net.sourceforge.plantuml.preproc.ReadLineWithYamlHeader;
import net.sourceforge.plantuml.regex.Matcher2;
import net.sourceforge.plantuml.text.StringLocated;
import net.sourceforge.plantuml.tim.TimLoader;
import net.sourceforge.plantuml.utils.LineLocationImpl;
import net.sourceforge.plantuml.utils.StartUtils;
import net.sourceforge.plantuml.version.Version;

public class BlockUml {
    private final List<StringLocated> rawSource;
    private final List<StringLocated> data;
    private List<StringLocated> debug;
    private Diagram system;
    private final Defines localDefines;
    private final Previous previous;
    private final Set<File> included = new HashSet<File>();
    private final PreprocessingArtifact preprocessingArtifact;
    private final PathSystem pathSystem;
    private boolean preprocessorError;

    public Set<File> getIncluded() {
        return Collections.unmodifiableSet(this.included);
    }

    @Deprecated
    BlockUml(String ... strings) {
        this(PathSystem.fetch(), BlockUml.convert(strings), Defines.createEmpty(), null, null, null);
    }

    public String getEncodedUrl() throws IOException {
        Transcoder transcoder = TranscoderUtil.getDefaultTranscoder();
        String source = this.getDiagram().getSource().getPlainString("\n");
        String encoded = transcoder.encode(source);
        return encoded;
    }

    public String getFlashData() {
        StringBuilder sb = new StringBuilder();
        for (StringLocated line : this.data) {
            sb.append(line.getString());
            sb.append('\r');
            sb.append('\n');
        }
        return sb.toString();
    }

    public static List<StringLocated> convert(String ... strings) {
        return BlockUml.convert(Arrays.asList(strings));
    }

    public static List<StringLocated> convert(List<String> strings) {
        ArrayList<StringLocated> result = new ArrayList<StringLocated>();
        LineLocationImpl location = new LineLocationImpl("block", null);
        for (String s : strings) {
            location = location.oneLineRead();
            result.add(new StringLocated(s, location));
        }
        return result;
    }

    public BlockUml(PathSystem pathSystem, List<StringLocated> strings, Defines defines, Previous previous, DefinitionsContainer definitions, Charset charset) {
        this.pathSystem = pathSystem;
        this.rawSource = ReadLineWithYamlHeader.removeYamlHeader(strings);
        this.localDefines = defines;
        this.previous = previous;
        if (definitions == null) {
            this.data = new ArrayList<StringLocated>(this.rawSource);
            this.preprocessingArtifact = new PreprocessingArtifact();
        } else {
            TimLoader timLoader = new TimLoader(pathSystem, defines, charset, definitions, this.rawSource.get(0));
            this.included.addAll(timLoader.load(this.rawSource));
            List<StringLocated> tmp = timLoader.getResultList();
            tmp = Jaws.expands0(tmp);
            tmp = Jaws.expandsJawsForPreprocessor(tmp);
            this.data = tmp;
            this.debug = timLoader.getDebug();
            this.preprocessorError = timLoader.isPreprocessorError();
            this.preprocessingArtifact = timLoader.getPreprocessingArtifact();
        }
    }

    public String getFileOrDirname() {
        if (GlobalConfig.getInstance().boolValue(GlobalConfigKey.WORD)) {
            return null;
        }
        Matcher2 m = StartUtils.patternFilename.matcher(StringUtils.trin(this.data.get(0).getString()));
        boolean ok = m.find();
        if (!ok) {
            return null;
        }
        String result = m.group(1);
        int x = result.indexOf(44);
        if (x != -1) {
            result = result.substring(0, x);
        }
        for (int i = 0; i < result.length(); ++i) {
            char c = result.charAt(i);
            if ("<>|".indexOf(c) == -1) continue;
            return null;
        }
        if (result.startsWith("file://")) {
            result = result.substring("file://".length());
        }
        result = result.replaceAll("\\.\\w\\w\\w$", "");
        return result;
    }

    public Diagram getDiagram() {
        if (this.system == null) {
            this.system = this.preprocessorError ? new PSystemErrorPreprocessor(this.data, this.debug, this.preprocessingArtifact) : new PSystemBuilder().createPSystem(this.pathSystem, this.data, this.rawSource, this.previous, this.preprocessingArtifact);
        }
        return this.system;
    }

    public final List<StringLocated> getData() {
        return this.data;
    }

    private String internalEtag() {
        try {
            AsciiEncoder coder = new AsciiEncoder();
            MessageDigest msgDigest = MessageDigest.getInstance("MD5");
            for (StringLocated s : this.data) {
                msgDigest.update(s.getString().getBytes(StandardCharsets.UTF_8));
            }
            byte[] digest = msgDigest.digest();
            return coder.encode(digest);
        }
        catch (Exception e) {
            Logme.error(e);
            return "NOETAG";
        }
    }

    public String etag() {
        return Version.etag() + this.internalEtag();
    }

    public long lastModified() {
        return Version.compileTime() / 1000L / 60L * 1000L * 60L + (long)Version.beta() * 1000L * 3600L;
    }

    public boolean isStartDef(String name) {
        String signature = "@startdef(id=" + name + ")";
        return this.data.get(0).getString().equalsIgnoreCase(signature);
    }

    public List<String> getDefinition(boolean withHeader) {
        ArrayList<String> result = new ArrayList<String>();
        for (StringLocated s : this.data) {
            result.add(s.getString());
        }
        if (withHeader) {
            return Collections.unmodifiableList(result);
        }
        return Collections.unmodifiableList(result.subList(1, result.size() - 1));
    }

    public Defines getLocalDefines() {
        return this.localDefines;
    }
}

