/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.neuralsearch.query;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import lombok.Generated;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.search.BulkScorer;
import org.apache.lucene.search.ScoreMode;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.ScorerSupplier;
import org.apache.lucene.search.Weight;
import org.opensearch.neuralsearch.query.HybridBulkScorer;
import org.opensearch.neuralsearch.query.HybridQueryScorer;
import org.opensearch.neuralsearch.query.HybridQueryWeight;

public class HybridScorerSupplier
extends ScorerSupplier {
    private long cost = -1L;
    private final List<ScorerSupplier> scorerSuppliers;
    private final HybridQueryWeight weight;
    private final ScoreMode scoreMode;
    private final LeafReaderContext context;

    public Scorer get(long leadCost) throws IOException {
        ArrayList<Scorer> tScorers = new ArrayList<Scorer>();
        for (ScorerSupplier ss : this.scorerSuppliers) {
            if (Objects.nonNull(ss)) {
                tScorers.add(ss.get(leadCost));
                continue;
            }
            tScorers.add(null);
        }
        return new HybridQueryScorer(tScorers, this.scoreMode);
    }

    public long cost() {
        if (this.cost == -1L) {
            long cost = 0L;
            for (ScorerSupplier ss : this.scorerSuppliers) {
                if (!Objects.nonNull(ss)) continue;
                cost += ss.cost();
            }
            this.cost = cost;
        }
        return this.cost;
    }

    public void setTopLevelScoringClause() throws IOException {
        for (ScorerSupplier ss : this.scorerSuppliers) {
            if (!Objects.nonNull(ss)) continue;
            ss.setTopLevelScoringClause();
        }
    }

    public BulkScorer bulkScorer() throws IOException {
        ArrayList<Scorer> scorers = new ArrayList<Scorer>();
        for (Weight weight : this.weight.getWeights()) {
            Scorer scorer = weight.scorer(this.context);
            scorers.add(scorer);
        }
        return new HybridBulkScorer(scorers, this.scoreMode.needsScores(), this.context.reader().maxDoc());
    }

    @Generated
    public HybridScorerSupplier(List<ScorerSupplier> scorerSuppliers, HybridQueryWeight weight, ScoreMode scoreMode, LeafReaderContext context) {
        this.scorerSuppliers = scorerSuppliers;
        this.weight = weight;
        this.scoreMode = scoreMode;
        this.context = context;
    }

    @Generated
    public List<ScorerSupplier> getScorerSuppliers() {
        return this.scorerSuppliers;
    }
}

