/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch.core;

import jakarta.json.stream.JsonGenerator;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.json.PlainJsonSerializable;
import org.opensearch.client.opensearch._types.ErrorResponse;
import org.opensearch.client.opensearch._types.RequestBase;
import org.opensearch.client.opensearch.core.ClearScrollResponse;
import org.opensearch.client.transport.Endpoint;
import org.opensearch.client.transport.endpoints.SimpleEndpoint;
import org.opensearch.client.util.ApiTypeHelper;
import org.opensearch.client.util.CopyableBuilder;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ToCopyableBuilder;

@JsonpDeserializable
public final class ClearScrollRequest
extends RequestBase
implements PlainJsonSerializable,
ToCopyableBuilder<Builder, ClearScrollRequest> {
    @Nonnull
    private final List<String> scrollId;
    public static final JsonpDeserializer<ClearScrollRequest> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, ClearScrollRequest::setupClearScrollRequestDeserializer);
    public static final Endpoint<ClearScrollRequest, ClearScrollResponse, ErrorResponse> _ENDPOINT = new SimpleEndpoint<ClearScrollRequest, ClearScrollResponse>(request -> "DELETE", request -> "/_search/scroll", request -> {
        HashMap<String, String> params = new HashMap<String, String>();
        request.applyQueryParameters(params);
        return params;
    }, SimpleEndpoint.emptyMap(), true, ClearScrollResponse._DESERIALIZER);

    private ClearScrollRequest(Builder builder) {
        super(builder);
        this.scrollId = ApiTypeHelper.unmodifiable(builder.scrollId);
    }

    public static ClearScrollRequest of(Function<Builder, ObjectBuilder<ClearScrollRequest>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nonnull
    public final List<String> scrollId() {
        return this.scrollId;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (ApiTypeHelper.isDefined(this.scrollId)) {
            generator.writeKey("scroll_id");
            generator.writeStartArray();
            for (String item0 : this.scrollId) {
                generator.write(item0);
            }
            generator.writeEnd();
        }
    }

    @Override
    @Nonnull
    public Builder toBuilder() {
        return new Builder(this);
    }

    @Nonnull
    public static Builder builder() {
        return new Builder();
    }

    protected static void setupClearScrollRequestDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::scrollId, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "scroll_id");
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + Objects.hashCode(this.scrollId);
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ClearScrollRequest other = (ClearScrollRequest)o;
        return Objects.equals(this.scrollId, other.scrollId);
    }

    public static class Builder
    extends RequestBase.AbstractBuilder<Builder>
    implements CopyableBuilder<Builder, ClearScrollRequest> {
        @Nullable
        private List<String> scrollId;

        public Builder() {
        }

        private Builder(ClearScrollRequest o) {
            super(o);
            this.scrollId = Builder._listCopy(o.scrollId);
        }

        private Builder(Builder o) {
            super(o);
            this.scrollId = Builder._listCopy(o.scrollId);
        }

        @Override
        @Nonnull
        public Builder copy() {
            return new Builder(this);
        }

        @Override
        @Nonnull
        protected Builder self() {
            return this;
        }

        @Nonnull
        public final Builder scrollId(List<String> list) {
            this.scrollId = Builder._listAddAll(this.scrollId, list);
            return this;
        }

        @Nonnull
        public final Builder scrollId(String value, String ... values) {
            this.scrollId = Builder._listAdd(this.scrollId, value, values);
            return this;
        }

        @Override
        @Nonnull
        public ClearScrollRequest build() {
            this._checkSingleUse();
            return new ClearScrollRequest(this);
        }
    }
}

