/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.geospatial.index.mapper.xyshape;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Locale;
import java.util.Objects;
import org.apache.lucene.document.XYShape;
import org.apache.lucene.geo.XYLine;
import org.apache.lucene.geo.XYPoint;
import org.apache.lucene.geo.XYPolygon;
import org.apache.lucene.index.IndexableField;
import org.opensearch.geometry.Circle;
import org.opensearch.geometry.GeometryCollection;
import org.opensearch.geometry.GeometryVisitor;
import org.opensearch.geometry.Line;
import org.opensearch.geometry.LinearRing;
import org.opensearch.geometry.MultiLine;
import org.opensearch.geometry.MultiPoint;
import org.opensearch.geometry.MultiPolygon;
import org.opensearch.geometry.Point;
import org.opensearch.geometry.Polygon;
import org.opensearch.geometry.Rectangle;
import org.opensearch.geometry.ShapeType;
import org.opensearch.geospatial.index.common.xyshape.XYShapeConverter;

public final class XYShapeIndexableFieldsVisitor
implements GeometryVisitor<IndexableField[], RuntimeException> {
    private final String fieldName;

    public XYShapeIndexableFieldsVisitor(String fieldName) {
        this.fieldName = fieldName;
    }

    public IndexableField[] visit(Circle circle) {
        throw new IllegalArgumentException(String.format(Locale.ROOT, "invalid shape type found [ %s ] while indexing shape", ShapeType.CIRCLE));
    }

    public IndexableField[] visit(GeometryCollection<?> collection) {
        Objects.requireNonNull(collection, String.format(Locale.ROOT, "%s cannot be null", ShapeType.GEOMETRYCOLLECTION));
        return this.visitCollection(collection);
    }

    public IndexableField[] visit(Line line) {
        XYLine cartesianLine = XYShapeConverter.toXYLine(line);
        return XYShape.createIndexableFields((String)this.fieldName, (XYLine)cartesianLine);
    }

    public IndexableField[] visit(LinearRing ring) {
        throw new IllegalArgumentException(String.format(Locale.ROOT, "invalid shape type found [ %s ] while indexing shape", ShapeType.LINEARRING));
    }

    public IndexableField[] visit(MultiLine multiLine) {
        Objects.requireNonNull(multiLine, String.format(Locale.ROOT, "%s cannot be null", ShapeType.MULTILINESTRING));
        return this.visitCollection((GeometryCollection<?>)multiLine);
    }

    public IndexableField[] visit(MultiPoint multiPoint) {
        Objects.requireNonNull(multiPoint, String.format(Locale.ROOT, "%s cannot be null", ShapeType.MULTIPOINT));
        return this.visitCollection((GeometryCollection<?>)multiPoint);
    }

    public IndexableField[] visit(MultiPolygon multiPolygon) {
        Objects.requireNonNull(multiPolygon, String.format(Locale.ROOT, "%s cannot be null", ShapeType.MULTIPOLYGON));
        return this.visitCollection((GeometryCollection<?>)multiPolygon);
    }

    public IndexableField[] visit(Point point) {
        Objects.requireNonNull(point, String.format(Locale.ROOT, "%s cannot be null", ShapeType.POINT));
        XYPoint xyPoint = XYShapeConverter.toXYPoint(point);
        return XYShape.createIndexableFields((String)this.fieldName, (float)xyPoint.getX(), (float)xyPoint.getY());
    }

    public IndexableField[] visit(Polygon polygon) {
        XYPolygon luceneXYPolygon = XYShapeConverter.toXYPolygon(polygon);
        return this.createIndexableFields(luceneXYPolygon);
    }

    public IndexableField[] visit(Rectangle rectangle) {
        XYPolygon luceneXYPolygon = XYShapeConverter.toXYPolygon(rectangle);
        return this.createIndexableFields(luceneXYPolygon);
    }

    private IndexableField[] createIndexableFields(XYPolygon polygon) {
        return XYShape.createIndexableFields((String)this.fieldName, (XYPolygon)polygon);
    }

    private IndexableField[] visitCollection(GeometryCollection<?> collection) {
        ArrayList fields = new ArrayList();
        collection.forEach(geometry -> fields.addAll(Arrays.asList((IndexableField[])geometry.visit((GeometryVisitor)this))));
        return (IndexableField[])fields.toArray(IndexableField[]::new);
    }
}

