/*
 * Decompiled with CFR 0.152.
 */
package net.infonode.gui;

import java.awt.Color;
import java.awt.Graphics;
import net.infonode.gui.GraphicsUtil;
import net.infonode.util.ColorUtil;

public class HighlightPainter {
    private HighlightPainter() {
    }

    public static void drawLine(Graphics g, int x1, int y1, int x2, int y2, boolean clockWise, boolean inside, Color highlightColor, Color middleColor, Color shadowColor) {
        Color blendColor;
        int mul = clockWise ? 1 : -1;
        int dx = (x2 - x1) * mul;
        int dy = (y2 - y1) * mul;
        int l2 = 2 * (dx * dx + dy * dy);
        int a = dx - dy;
        Color color = blendColor = a > 0 ? highlightColor : shadowColor;
        if (blendColor != null) {
            g.setColor(ColorUtil.blend(middleColor, blendColor, (float)a * (float)a / (float)l2));
            int hx = inside ? HighlightPainter.getHighlightOffsetX(dx, dy) : 0;
            int hy = inside ? HighlightPainter.getHighlightOffsetY(dx, dy) : 0;
            GraphicsUtil.drawOptimizedLine(g, x1 + hx, y1 + hy, x2 + hx, y2 + hy);
        }
    }

    public static float getBlendFactor(int dx, int dy) {
        int l2 = 2 * (dx * dx + dy * dy);
        int a = dx - dy;
        return 1.0f - (float)a * (float)a / (float)l2;
    }

    protected static int getHighlightOffsetX(int deltaX, int deltaY) {
        return deltaY - deltaX > 0 ? (deltaX + deltaY > 0 ? -1 : 0) : (deltaX + deltaY > 0 ? 0 : 1);
    }

    protected static int getHighlightOffsetY(int deltaX, int deltaY) {
        return deltaY - deltaX > 0 ? (deltaX + deltaY > 0 ? 0 : -1) : (deltaX + deltaY > 0 ? 1 : 0);
    }
}

