﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/connectcases/ConnectCasesRequest.h>
#include <aws/connectcases/ConnectCases_EXPORTS.h>
#include <aws/core/utils/memory/stl/AWSString.h>

#include <utility>

namespace Aws {
namespace ConnectCases {
namespace Model {

/**
 */
class DeleteLayoutRequest : public ConnectCasesRequest {
 public:
  AWS_CONNECTCASES_API DeleteLayoutRequest() = default;

  // Service request name is the Operation name which will send this request out,
  // each operation should has unique request name, so that we can get operation's name from this request.
  // Note: this is not true for response, multiple operations may have the same response name,
  // so we can not get operation's name from response.
  inline virtual const char* GetServiceRequestName() const override { return "DeleteLayout"; }

  AWS_CONNECTCASES_API Aws::String SerializePayload() const override;

  ///@{
  /**
   * <p>The unique identifier of the Cases domain.</p>
   */
  inline const Aws::String& GetDomainId() const { return m_domainId; }
  inline bool DomainIdHasBeenSet() const { return m_domainIdHasBeenSet; }
  template <typename DomainIdT = Aws::String>
  void SetDomainId(DomainIdT&& value) {
    m_domainIdHasBeenSet = true;
    m_domainId = std::forward<DomainIdT>(value);
  }
  template <typename DomainIdT = Aws::String>
  DeleteLayoutRequest& WithDomainId(DomainIdT&& value) {
    SetDomainId(std::forward<DomainIdT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The unique identifier of the layout.</p>
   */
  inline const Aws::String& GetLayoutId() const { return m_layoutId; }
  inline bool LayoutIdHasBeenSet() const { return m_layoutIdHasBeenSet; }
  template <typename LayoutIdT = Aws::String>
  void SetLayoutId(LayoutIdT&& value) {
    m_layoutIdHasBeenSet = true;
    m_layoutId = std::forward<LayoutIdT>(value);
  }
  template <typename LayoutIdT = Aws::String>
  DeleteLayoutRequest& WithLayoutId(LayoutIdT&& value) {
    SetLayoutId(std::forward<LayoutIdT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::String m_domainId;

  Aws::String m_layoutId;
  bool m_domainIdHasBeenSet = false;
  bool m_layoutIdHasBeenSet = false;
};

}  // namespace Model
}  // namespace ConnectCases
}  // namespace Aws
