﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/bedrock-runtime/BedrockRuntime_EXPORTS.h>
#include <aws/core/utils/memory/stl/AWSString.h>

namespace Aws {
namespace BedrockRuntime {
namespace Model {
enum class GuardrailOwnership { NOT_SET, SELF, CROSS_ACCOUNT };

namespace GuardrailOwnershipMapper {
AWS_BEDROCKRUNTIME_API GuardrailOwnership GetGuardrailOwnershipForName(const Aws::String& name);

AWS_BEDROCKRUNTIME_API Aws::String GetNameForGuardrailOwnership(GuardrailOwnership value);
}  // namespace GuardrailOwnershipMapper
}  // namespace Model
}  // namespace BedrockRuntime
}  // namespace Aws
