from chardet.enums import CharacterCategory, SequenceLikelihood
from chardet.sbcharsetprober import SingleByteCharSetModel

POLISH_LANG_MODEL = {
    34: {  # 'A'
        34: SequenceLikelihood.UNLIKELY,  # 'A'
        46: SequenceLikelihood.LIKELY,  # 'B'
        39: SequenceLikelihood.LIKELY,  # 'C'
        41: SequenceLikelihood.LIKELY,  # 'D'
        48: SequenceLikelihood.UNLIKELY,  # 'E'
        52: SequenceLikelihood.UNLIKELY,  # 'F'
        49: SequenceLikelihood.LIKELY,  # 'G'
        54: SequenceLikelihood.UNLIKELY,  # 'H'
        43: SequenceLikelihood.UNLIKELY,  # 'I'
        47: SequenceLikelihood.LIKELY,  # 'J'
        37: SequenceLikelihood.LIKELY,  # 'K'
        50: SequenceLikelihood.LIKELY,  # 'L'
        35: SequenceLikelihood.LIKELY,  # 'M'
        36: SequenceLikelihood.LIKELY,  # 'N'
        40: SequenceLikelihood.UNLIKELY,  # 'O'
        30: SequenceLikelihood.LIKELY,  # 'P'
        64: SequenceLikelihood.UNLIKELY,  # 'Q'
        45: SequenceLikelihood.LIKELY,  # 'R'
        33: SequenceLikelihood.LIKELY,  # 'S'
        38: SequenceLikelihood.LIKELY,  # 'T'
        51: SequenceLikelihood.UNLIKELY,  # 'U'
        56: SequenceLikelihood.UNLIKELY,  # 'V'
        32: SequenceLikelihood.LIKELY,  # 'W'
        60: SequenceLikelihood.UNLIKELY,  # 'X'
        58: SequenceLikelihood.UNLIKELY,  # 'Y'
        44: SequenceLikelihood.UNLIKELY,  # 'Z'
        1: SequenceLikelihood.UNLIKELY,  # 'a'
        20: SequenceLikelihood.LIKELY,  # 'b'
        11: SequenceLikelihood.LIKELY,  # 'c'
        14: SequenceLikelihood.LIKELY,  # 'd'
        2: SequenceLikelihood.UNLIKELY,  # 'e'
        31: SequenceLikelihood.UNLIKELY,  # 'f'
        22: SequenceLikelihood.LIKELY,  # 'g'
        23: SequenceLikelihood.UNLIKELY,  # 'h'
        3: SequenceLikelihood.UNLIKELY,  # 'i'
        19: SequenceLikelihood.UNLIKELY,  # 'j'
        13: SequenceLikelihood.LIKELY,  # 'k'
        18: SequenceLikelihood.POSITIVE,  # 'l'
        15: SequenceLikelihood.LIKELY,  # 'm'
        5: SequenceLikelihood.POSITIVE,  # 'n'
        4: SequenceLikelihood.UNLIKELY,  # 'o'
        16: SequenceLikelihood.LIKELY,  # 'p'
        63: SequenceLikelihood.UNLIKELY,  # 'q'
        7: SequenceLikelihood.LIKELY,  # 'r'
        9: SequenceLikelihood.LIKELY,  # 's'
        10: SequenceLikelihood.LIKELY,  # 't'
        17: SequenceLikelihood.LIKELY,  # 'u'
        55: SequenceLikelihood.UNLIKELY,  # 'v'
        8: SequenceLikelihood.UNLIKELY,  # 'w'
        57: SequenceLikelihood.UNLIKELY,  # 'x'
        12: SequenceLikelihood.UNLIKELY,  # 'y'
        6: SequenceLikelihood.UNLIKELY,  # 'z'
        66: SequenceLikelihood.UNLIKELY,  # 'Ó'
        27: SequenceLikelihood.NEGATIVE,  # 'ó'
        67: SequenceLikelihood.NEGATIVE,  # 'Ą'
        25: SequenceLikelihood.UNLIKELY,  # 'ą'
        68: SequenceLikelihood.UNLIKELY,  # 'Ć'
        29: SequenceLikelihood.UNLIKELY,  # 'ć'
        65: SequenceLikelihood.UNLIKELY,  # 'Ę'
        24: SequenceLikelihood.NEGATIVE,  # 'ę'
        61: SequenceLikelihood.UNLIKELY,  # 'Ł'
        21: SequenceLikelihood.UNLIKELY,  # 'ł'
        70: SequenceLikelihood.UNLIKELY,  # 'Ń'
        42: SequenceLikelihood.UNLIKELY,  # 'ń'
        59: SequenceLikelihood.UNLIKELY,  # 'Ś'
        28: SequenceLikelihood.UNLIKELY,  # 'ś'
        69: SequenceLikelihood.UNLIKELY,  # 'Ź'
        53: SequenceLikelihood.UNLIKELY,  # 'ź'
        62: SequenceLikelihood.UNLIKELY,  # 'Ż'
        26: SequenceLikelihood.UNLIKELY,  # 'ż'
    },
    46: {  # 'B'
        34: SequenceLikelihood.LIKELY,  # 'A'
        46: SequenceLikelihood.UNLIKELY,  # 'B'
        39: SequenceLikelihood.UNLIKELY,  # 'C'
        41: SequenceLikelihood.UNLIKELY,  # 'D'
        48: SequenceLikelihood.UNLIKELY,  # 'E'
        52: SequenceLikelihood.UNLIKELY,  # 'F'
        49: SequenceLikelihood.UNLIKELY,  # 'G'
        54: SequenceLikelihood.UNLIKELY,  # 'H'
        43: SequenceLikelihood.LIKELY,  # 'I'
        47: SequenceLikelihood.UNLIKELY,  # 'J'
        37: SequenceLikelihood.UNLIKELY,  # 'K'
        50: SequenceLikelihood.UNLIKELY,  # 'L'
        35: SequenceLikelihood.UNLIKELY,  # 'M'
        36: SequenceLikelihood.UNLIKELY,  # 'N'
        40: SequenceLikelihood.LIKELY,  # 'O'
        30: SequenceLikelihood.UNLIKELY,  # 'P'
        64: SequenceLikelihood.UNLIKELY,  # 'Q'
        45: SequenceLikelihood.UNLIKELY,  # 'R'
        33: SequenceLikelihood.UNLIKELY,  # 'S'
        38: SequenceLikelihood.UNLIKELY,  # 'T'
        51: SequenceLikelihood.UNLIKELY,  # 'U'
        56: SequenceLikelihood.UNLIKELY,  # 'V'
        32: SequenceLikelihood.UNLIKELY,  # 'W'
        60: SequenceLikelihood.UNLIKELY,  # 'X'
        58: SequenceLikelihood.UNLIKELY,  # 'Y'
        44: SequenceLikelihood.UNLIKELY,  # 'Z'
        1: SequenceLikelihood.POSITIVE,  # 'a'
        20: SequenceLikelihood.UNLIKELY,  # 'b'
        11: SequenceLikelihood.UNLIKELY,  # 'c'
        14: SequenceLikelihood.UNLIKELY,  # 'd'
        2: SequenceLikelihood.POSITIVE,  # 'e'
        31: SequenceLikelihood.UNLIKELY,  # 'f'
        22: SequenceLikelihood.UNLIKELY,  # 'g'
        23: SequenceLikelihood.UNLIKELY,  # 'h'
        3: SequenceLikelihood.POSITIVE,  # 'i'
        19: SequenceLikelihood.UNLIKELY,  # 'j'
        13: SequenceLikelihood.UNLIKELY,  # 'k'
        18: SequenceLikelihood.LIKELY,  # 'l'
        15: SequenceLikelihood.UNLIKELY,  # 'm'
        5: SequenceLikelihood.UNLIKELY,  # 'n'
        4: SequenceLikelihood.POSITIVE,  # 'o'
        16: SequenceLikelihood.UNLIKELY,  # 'p'
        63: SequenceLikelihood.UNLIKELY,  # 'q'
        7: SequenceLikelihood.POSITIVE,  # 'r'
        9: SequenceLikelihood.UNLIKELY,  # 's'
        10: SequenceLikelihood.UNLIKELY,  # 't'
        17: SequenceLikelihood.LIKELY,  # 'u'
        55: SequenceLikelihood.UNLIKELY,  # 'v'
        8: SequenceLikelihood.UNLIKELY,  # 'w'
        57: SequenceLikelihood.UNLIKELY,  # 'x'
        12: SequenceLikelihood.LIKELY,  # 'y'
        6: SequenceLikelihood.UNLIKELY,  # 'z'
        66: SequenceLikelihood.UNLIKELY,  # 'Ó'
        27: SequenceLikelihood.UNLIKELY,  # 'ó'
        67: SequenceLikelihood.UNLIKELY,  # 'Ą'
        25: SequenceLikelihood.UNLIKELY,  # 'ą'
        68: SequenceLikelihood.UNLIKELY,  # 'Ć'
        29: SequenceLikelihood.NEGATIVE,  # 'ć'
        65: SequenceLikelihood.UNLIKELY,  # 'Ę'
        24: SequenceLikelihood.LIKELY,  # 'ę'
        61: SequenceLikelihood.UNLIKELY,  # 'Ł'
        21: SequenceLikelihood.UNLIKELY,  # 'ł'
        70: SequenceLikelihood.NEGATIVE,  # 'Ń'
        42: SequenceLikelihood.NEGATIVE,  # 'ń'
        59: SequenceLikelihood.UNLIKELY,  # 'Ś'
        28: SequenceLikelihood.NEGATIVE,  # 'ś'
        69: SequenceLikelihood.NEGATIVE,  # 'Ź'
        53: SequenceLikelihood.UNLIKELY,  # 'ź'
        62: SequenceLikelihood.UNLIKELY,  # 'Ż'
        26: SequenceLikelihood.UNLIKELY,  # 'ż'
    },
    39: {  # 'C'
        34: SequenceLikelihood.LIKELY,  # 'A'
        46: SequenceLikelihood.UNLIKELY,  # 'B'
        39: SequenceLikelihood.UNLIKELY,  # 'C'
        41: SequenceLikelihood.UNLIKELY,  # 'D'
        48: SequenceLikelihood.LIKELY,  # 'E'
        52: SequenceLikelihood.UNLIKELY,  # 'F'
        49: SequenceLikelihood.UNLIKELY,  # 'G'
        54: SequenceLikelihood.LIKELY,  # 'H'
        43: SequenceLikelihood.LIKELY,  # 'I'
        47: SequenceLikelihood.LIKELY,  # 'J'
        37: SequenceLikelihood.UNLIKELY,  # 'K'
        50: SequenceLikelihood.UNLIKELY,  # 'L'
        35: SequenceLikelihood.UNLIKELY,  # 'M'
        36: SequenceLikelihood.UNLIKELY,  # 'N'
        40: SequenceLikelihood.LIKELY,  # 'O'
        30: SequenceLikelihood.UNLIKELY,  # 'P'
        64: SequenceLikelihood.UNLIKELY,  # 'Q'
        45: SequenceLikelihood.UNLIKELY,  # 'R'
        33: SequenceLikelihood.UNLIKELY,  # 'S'
        38: SequenceLikelihood.UNLIKELY,  # 'T'
        51: SequenceLikelihood.UNLIKELY,  # 'U'
        56: SequenceLikelihood.UNLIKELY,  # 'V'
        32: SequenceLikelihood.UNLIKELY,  # 'W'
        60: SequenceLikelihood.UNLIKELY,  # 'X'
        58: SequenceLikelihood.UNLIKELY,  # 'Y'
        44: SequenceLikelihood.LIKELY,  # 'Z'
        1: SequenceLikelihood.LIKELY,  # 'a'
        20: SequenceLikelihood.UNLIKELY,  # 'b'
        11: SequenceLikelihood.UNLIKELY,  # 'c'
        14: SequenceLikelihood.UNLIKELY,  # 'd'
        2: SequenceLikelihood.LIKELY,  # 'e'
        31: SequenceLikelihood.UNLIKELY,  # 'f'
        22: SequenceLikelihood.UNLIKELY,  # 'g'
        23: SequenceLikelihood.POSITIVE,  # 'h'
        3: SequenceLikelihood.POSITIVE,  # 'i'
        19: SequenceLikelihood.UNLIKELY,  # 'j'
        13: SequenceLikelihood.UNLIKELY,  # 'k'
        18: SequenceLikelihood.LIKELY,  # 'l'
        15: SequenceLikelihood.UNLIKELY,  # 'm'
        5: SequenceLikelihood.UNLIKELY,  # 'n'
        4: SequenceLikelihood.POSITIVE,  # 'o'
        16: SequenceLikelihood.UNLIKELY,  # 'p'
        63: SequenceLikelihood.UNLIKELY,  # 'q'
        7: SequenceLikelihood.LIKELY,  # 'r'
        9: SequenceLikelihood.UNLIKELY,  # 's'
        10: SequenceLikelihood.UNLIKELY,  # 't'
        17: SequenceLikelihood.LIKELY,  # 'u'
        55: SequenceLikelihood.UNLIKELY,  # 'v'
        8: SequenceLikelihood.UNLIKELY,  # 'w'
        57: SequenceLikelihood.UNLIKELY,  # 'x'
        12: SequenceLikelihood.LIKELY,  # 'y'
        6: SequenceLikelihood.POSITIVE,  # 'z'
        66: SequenceLikelihood.UNLIKELY,  # 'Ó'
        27: SequenceLikelihood.UNLIKELY,  # 'ó'
        67: SequenceLikelihood.UNLIKELY,  # 'Ą'
        25: SequenceLikelihood.UNLIKELY,  # 'ą'
        68: SequenceLikelihood.NEGATIVE,  # 'Ć'
        29: SequenceLikelihood.NEGATIVE,  # 'ć'
        65: SequenceLikelihood.UNLIKELY,  # 'Ę'
        24: SequenceLikelihood.UNLIKELY,  # 'ę'
        61: SequenceLikelihood.UNLIKELY,  # 'Ł'
        21: SequenceLikelihood.UNLIKELY,  # 'ł'
        70: SequenceLikelihood.NEGATIVE,  # 'Ń'
        42: SequenceLikelihood.NEGATIVE,  # 'ń'
        59: SequenceLikelihood.UNLIKELY,  # 'Ś'
        28: SequenceLikelihood.UNLIKELY,  # 'ś'
        69: SequenceLikelihood.NEGATIVE,  # 'Ź'
        53: SequenceLikelihood.NEGATIVE,  # 'ź'
        62: SequenceLikelihood.UNLIKELY,  # 'Ż'
        26: SequenceLikelihood.UNLIKELY,  # 'ż'
    },
    41: {  # 'D'
        34: SequenceLikelihood.LIKELY,  # 'A'
        46: SequenceLikelihood.UNLIKELY,  # 'B'
        39: SequenceLikelihood.UNLIKELY,  # 'C'
        41: SequenceLikelihood.UNLIKELY,  # 'D'
        48: SequenceLikelihood.LIKELY,  # 'E'
        52: SequenceLikelihood.UNLIKELY,  # 'F'
        49: SequenceLikelihood.UNLIKELY,  # 'G'
        54: SequenceLikelihood.UNLIKELY,  # 'H'
        43: SequenceLikelihood.LIKELY,  # 'I'
        47: SequenceLikelihood.UNLIKELY,  # 'J'
        37: SequenceLikelihood.UNLIKELY,  # 'K'
        50: SequenceLikelihood.UNLIKELY,  # 'L'
        35: SequenceLikelihood.UNLIKELY,  # 'M'
        36: SequenceLikelihood.UNLIKELY,  # 'N'
        40: SequenceLikelihood.LIKELY,  # 'O'
        30: SequenceLikelihood.UNLIKELY,  # 'P'
        64: SequenceLikelihood.UNLIKELY,  # 'Q'
        45: SequenceLikelihood.UNLIKELY,  # 'R'
        33: SequenceLikelihood.UNLIKELY,  # 'S'
        38: SequenceLikelihood.UNLIKELY,  # 'T'
        51: SequenceLikelihood.UNLIKELY,  # 'U'
        56: SequenceLikelihood.UNLIKELY,  # 'V'
        32: SequenceLikelihood.UNLIKELY,  # 'W'
        60: SequenceLikelihood.UNLIKELY,  # 'X'
        58: SequenceLikelihood.UNLIKELY,  # 'Y'
        44: SequenceLikelihood.LIKELY,  # 'Z'
        1: SequenceLikelihood.POSITIVE,  # 'a'
        20: SequenceLikelihood.UNLIKELY,  # 'b'
        11: SequenceLikelihood.UNLIKELY,  # 'c'
        14: SequenceLikelihood.UNLIKELY,  # 'd'
        2: SequenceLikelihood.LIKELY,  # 'e'
        31: SequenceLikelihood.UNLIKELY,  # 'f'
        22: SequenceLikelihood.UNLIKELY,  # 'g'
        23: SequenceLikelihood.UNLIKELY,  # 'h'
        3: SequenceLikelihood.LIKELY,  # 'i'
        19: SequenceLikelihood.UNLIKELY,  # 'j'
        13: SequenceLikelihood.UNLIKELY,  # 'k'
        18: SequenceLikelihood.LIKELY,  # 'l'
        15: SequenceLikelihood.UNLIKELY,  # 'm'
        5: SequenceLikelihood.UNLIKELY,  # 'n'
        4: SequenceLikelihood.POSITIVE,  # 'o'
        16: SequenceLikelihood.UNLIKELY,  # 'p'
        63: SequenceLikelihood.UNLIKELY,  # 'q'
        7: SequenceLikelihood.LIKELY,  # 'r'
        9: SequenceLikelihood.UNLIKELY,  # 's'
        10: SequenceLikelihood.UNLIKELY,  # 't'
        17: SequenceLikelihood.LIKELY,  # 'u'
        55: SequenceLikelihood.UNLIKELY,  # 'v'
        8: SequenceLikelihood.LIKELY,  # 'w'
        57: SequenceLikelihood.UNLIKELY,  # 'x'
        12: SequenceLikelihood.LIKELY,  # 'y'
        6: SequenceLikelihood.POSITIVE,  # 'z'
        66: SequenceLikelihood.UNLIKELY,  # 'Ó'
        27: SequenceLikelihood.UNLIKELY,  # 'ó'
        67: SequenceLikelihood.UNLIKELY,  # 'Ą'
        25: SequenceLikelihood.UNLIKELY,  # 'ą'
        68: SequenceLikelihood.NEGATIVE,  # 'Ć'
        29: SequenceLikelihood.NEGATIVE,  # 'ć'
        65: SequenceLikelihood.UNLIKELY,  # 'Ę'
        24: SequenceLikelihood.UNLIKELY,  # 'ę'
        61: SequenceLikelihood.UNLIKELY,  # 'Ł'
        21: SequenceLikelihood.UNLIKELY,  # 'ł'
        70: SequenceLikelihood.NEGATIVE,  # 'Ń'
        42: SequenceLikelihood.NEGATIVE,  # 'ń'
        59: SequenceLikelihood.UNLIKELY,  # 'Ś'
        28: SequenceLikelihood.UNLIKELY,  # 'ś'
        69: SequenceLikelihood.UNLIKELY,  # 'Ź'
        53: SequenceLikelihood.UNLIKELY,  # 'ź'
        62: SequenceLikelihood.UNLIKELY,  # 'Ż'
        26: SequenceLikelihood.UNLIKELY,  # 'ż'
    },
    48: {  # 'E'
        34: SequenceLikelihood.LIKELY,  # 'A'
        46: SequenceLikelihood.UNLIKELY,  # 'B'
        39: SequenceLikelihood.LIKELY,  # 'C'
        41: SequenceLikelihood.LIKELY,  # 'D'
        48: SequenceLikelihood.UNLIKELY,  # 'E'
        52: SequenceLikelihood.UNLIKELY,  # 'F'
        49: SequenceLikelihood.LIKELY,  # 'G'
        54: SequenceLikelihood.UNLIKELY,  # 'H'
        43: SequenceLikelihood.UNLIKELY,  # 'I'
        47: SequenceLikelihood.LIKELY,  # 'J'
        37: SequenceLikelihood.LIKELY,  # 'K'
        50: SequenceLikelihood.LIKELY,  # 'L'
        35: SequenceLikelihood.LIKELY,  # 'M'
        36: SequenceLikelihood.LIKELY,  # 'N'
        40: SequenceLikelihood.LIKELY,  # 'O'
        30: SequenceLikelihood.UNLIKELY,  # 'P'
        64: SequenceLikelihood.UNLIKELY,  # 'Q'
        45: SequenceLikelihood.LIKELY,  # 'R'
        33: SequenceLikelihood.LIKELY,  # 'S'
        38: SequenceLikelihood.LIKELY,  # 'T'
        51: SequenceLikelihood.UNLIKELY,  # 'U'
        56: SequenceLikelihood.UNLIKELY,  # 'V'
        32: SequenceLikelihood.UNLIKELY,  # 'W'
        60: SequenceLikelihood.UNLIKELY,  # 'X'
        58: SequenceLikelihood.UNLIKELY,  # 'Y'
        44: SequenceLikelihood.UNLIKELY,  # 'Z'
        1: SequenceLikelihood.UNLIKELY,  # 'a'
        20: SequenceLikelihood.UNLIKELY,  # 'b'
        11: SequenceLikelihood.UNLIKELY,  # 'c'
        14: SequenceLikelihood.LIKELY,  # 'd'
        2: SequenceLikelihood.UNLIKELY,  # 'e'
        31: SequenceLikelihood.UNLIKELY,  # 'f'
        22: SequenceLikelihood.UNLIKELY,  # 'g'
        23: SequenceLikelihood.UNLIKELY,  # 'h'
        3: SequenceLikelihood.UNLIKELY,  # 'i'
        19: SequenceLikelihood.UNLIKELY,  # 'j'
        13: SequenceLikelihood.LIKELY,  # 'k'
        18: SequenceLikelihood.LIKELY,  # 'l'
        15: SequenceLikelihood.LIKELY,  # 'm'
        5: SequenceLikelihood.LIKELY,  # 'n'
        4: SequenceLikelihood.UNLIKELY,  # 'o'
        16: SequenceLikelihood.UNLIKELY,  # 'p'
        63: SequenceLikelihood.UNLIKELY,  # 'q'
        7: SequenceLikelihood.UNLIKELY,  # 'r'
        9: SequenceLikelihood.UNLIKELY,  # 's'
        10: SequenceLikelihood.UNLIKELY,  # 't'
        17: SequenceLikelihood.LIKELY,  # 'u'
        55: SequenceLikelihood.UNLIKELY,  # 'v'
        8: SequenceLikelihood.LIKELY,  # 'w'
        57: SequenceLikelihood.LIKELY,  # 'x'
        12: SequenceLikelihood.UNLIKELY,  # 'y'
        6: SequenceLikelihood.UNLIKELY,  # 'z'
        66: SequenceLikelihood.UNLIKELY,  # 'Ó'
        27: SequenceLikelihood.NEGATIVE,  # 'ó'
        67: SequenceLikelihood.UNLIKELY,  # 'Ą'
        25: SequenceLikelihood.UNLIKELY,  # 'ą'
        68: SequenceLikelihood.UNLIKELY,  # 'Ć'
        29: SequenceLikelihood.UNLIKELY,  # 'ć'
        65: SequenceLikelihood.UNLIKELY,  # 'Ę'
        24: SequenceLikelihood.UNLIKELY,  # 'ę'
        61: SequenceLikelihood.UNLIKELY,  # 'Ł'
        21: SequenceLikelihood.UNLIKELY,  # 'ł'
        70: SequenceLikelihood.UNLIKELY,  # 'Ń'
        42: SequenceLikelihood.UNLIKELY,  # 'ń'
        59: SequenceLikelihood.UNLIKELY,  # 'Ś'
        28: SequenceLikelihood.UNLIKELY,  # 'ś'
        69: SequenceLikelihood.UNLIKELY,  # 'Ź'
        53: SequenceLikelihood.UNLIKELY,  # 'ź'
        62: SequenceLikelihood.UNLIKELY,  # 'Ż'
        26: SequenceLikelihood.UNLIKELY,  # 'ż'
    },
    52: {  # 'F'
        34: SequenceLikelihood.UNLIKELY,  # 'A'
        46: SequenceLikelihood.UNLIKELY,  # 'B'
        39: SequenceLikelihood.UNLIKELY,  # 'C'
        41: SequenceLikelihood.UNLIKELY,  # 'D'
        48: SequenceLikelihood.UNLIKELY,  # 'E'
        52: SequenceLikelihood.UNLIKELY,  # 'F'
        49: SequenceLikelihood.UNLIKELY,  # 'G'
        54: SequenceLikelihood.UNLIKELY,  # 'H'
        43: SequenceLikelihood.LIKELY,  # 'I'
        47: SequenceLikelihood.UNLIKELY,  # 'J'
        37: SequenceLikelihood.UNLIKELY,  # 'K'
        50: SequenceLikelihood.UNLIKELY,  # 'L'
        35: SequenceLikelihood.UNLIKELY,  # 'M'
        36: SequenceLikelihood.UNLIKELY,  # 'N'
        40: SequenceLikelihood.LIKELY,  # 'O'
        30: SequenceLikelihood.UNLIKELY,  # 'P'
        64: SequenceLikelihood.UNLIKELY,  # 'Q'
        45: SequenceLikelihood.UNLIKELY,  # 'R'
        33: SequenceLikelihood.UNLIKELY,  # 'S'
        38: SequenceLikelihood.UNLIKELY,  # 'T'
        51: SequenceLikelihood.UNLIKELY,  # 'U'
        56: SequenceLikelihood.UNLIKELY,  # 'V'
        32: SequenceLikelihood.UNLIKELY,  # 'W'
        60: SequenceLikelihood.UNLIKELY,  # 'X'
        58: SequenceLikelihood.UNLIKELY,  # 'Y'
        44: SequenceLikelihood.UNLIKELY,  # 'Z'
        1: SequenceLikelihood.LIKELY,  # 'a'
        20: SequenceLikelihood.UNLIKELY,  # 'b'
        11: SequenceLikelihood.UNLIKELY,  # 'c'
        14: SequenceLikelihood.UNLIKELY,  # 'd'
        2: SequenceLikelihood.LIKELY,  # 'e'
        31: SequenceLikelihood.UNLIKELY,  # 'f'
        22: SequenceLikelihood.UNLIKELY,  # 'g'
        23: SequenceLikelihood.UNLIKELY,  # 'h'
        3: SequenceLikelihood.LIKELY,  # 'i'
        19: SequenceLikelihood.UNLIKELY,  # 'j'
        13: SequenceLikelihood.UNLIKELY,  # 'k'
        18: SequenceLikelihood.LIKELY,  # 'l'
        15: SequenceLikelihood.UNLIKELY,  # 'm'
        5: SequenceLikelihood.UNLIKELY,  # 'n'
        4: SequenceLikelihood.LIKELY,  # 'o'
        16: SequenceLikelihood.UNLIKELY,  # 'p'
        63: SequenceLikelihood.UNLIKELY,  # 'q'
        7: SequenceLikelihood.LIKELY,  # 'r'
        9: SequenceLikelihood.UNLIKELY,  # 's'
        10: SequenceLikelihood.UNLIKELY,  # 't'
        17: SequenceLikelihood.LIKELY,  # 'u'
        55: SequenceLikelihood.UNLIKELY,  # 'v'
        8: SequenceLikelihood.UNLIKELY,  # 'w'
        57: SequenceLikelihood.UNLIKELY,  # 'x'
        12: SequenceLikelihood.UNLIKELY,  # 'y'
        6: SequenceLikelihood.UNLIKELY,  # 'z'
        66: SequenceLikelihood.UNLIKELY,  # 'Ó'
        27: SequenceLikelihood.UNLIKELY,  # 'ó'
        67: SequenceLikelihood.UNLIKELY,  # 'Ą'
        25: SequenceLikelihood.UNLIKELY,  # 'ą'
        68: SequenceLikelihood.NEGATIVE,  # 'Ć'
        29: SequenceLikelihood.NEGATIVE,  # 'ć'
        65: SequenceLikelihood.UNLIKELY,  # 'Ę'
        24: SequenceLikelihood.NEGATIVE,  # 'ę'
        61: SequenceLikelihood.UNLIKELY,  # 'Ł'
        21: SequenceLikelihood.UNLIKELY,  # 'ł'
        70: SequenceLikelihood.NEGATIVE,  # 'Ń'
        42: SequenceLikelihood.NEGATIVE,  # 'ń'
        59: SequenceLikelihood.UNLIKELY,  # 'Ś'
        28: SequenceLikelihood.NEGATIVE,  # 'ś'
        69: SequenceLikelihood.UNLIKELY,  # 'Ź'
        53: SequenceLikelihood.NEGATIVE,  # 'ź'
        62: SequenceLikelihood.UNLIKELY,  # 'Ż'
        26: SequenceLikelihood.NEGATIVE,  # 'ż'
    },
    49: {  # 'G'
        34: SequenceLikelihood.LIKELY,  # 'A'
        46: SequenceLikelihood.UNLIKELY,  # 'B'
        39: SequenceLikelihood.UNLIKELY,  # 'C'
        41: SequenceLikelihood.UNLIKELY,  # 'D'
        48: SequenceLikelihood.UNLIKELY,  # 'E'
        52: SequenceLikelihood.UNLIKELY,  # 'F'
        49: SequenceLikelihood.UNLIKELY,  # 'G'
        54: SequenceLikelihood.UNLIKELY,  # 'H'
        43: SequenceLikelihood.UNLIKELY,  # 'I'
        47: SequenceLikelihood.UNLIKELY,  # 'J'
        37: SequenceLikelihood.UNLIKELY,  # 'K'
        50: SequenceLikelihood.UNLIKELY,  # 'L'
        35: SequenceLikelihood.UNLIKELY,  # 'M'
        36: SequenceLikelihood.UNLIKELY,  # 'N'
        40: SequenceLikelihood.LIKELY,  # 'O'
        30: SequenceLikelihood.UNLIKELY,  # 'P'
        64: SequenceLikelihood.UNLIKELY,  # 'Q'
        45: SequenceLikelihood.LIKELY,  # 'R'
        33: SequenceLikelihood.UNLIKELY,  # 'S'
        38: SequenceLikelihood.UNLIKELY,  # 'T'
        51: SequenceLikelihood.UNLIKELY,  # 'U'
        56: SequenceLikelihood.UNLIKELY,  # 'V'
        32: SequenceLikelihood.UNLIKELY,  # 'W'
        60: SequenceLikelihood.UNLIKELY,  # 'X'
        58: SequenceLikelihood.UNLIKELY,  # 'Y'
        44: SequenceLikelihood.UNLIKELY,  # 'Z'
        1: SequenceLikelihood.LIKELY,  # 'a'
        20: SequenceLikelihood.UNLIKELY,  # 'b'
        11: SequenceLikelihood.UNLIKELY,  # 'c'
        14: SequenceLikelihood.LIKELY,  # 'd'
        2: SequenceLikelihood.LIKELY,  # 'e'
        31: SequenceLikelihood.UNLIKELY,  # 'f'
        22: SequenceLikelihood.UNLIKELY,  # 'g'
        23: SequenceLikelihood.UNLIKELY,  # 'h'
        3: SequenceLikelihood.LIKELY,  # 'i'
        19: SequenceLikelihood.UNLIKELY,  # 'j'
        13: SequenceLikelihood.UNLIKELY,  # 'k'
        18: SequenceLikelihood.LIKELY,  # 'l'
        15: SequenceLikelihood.LIKELY,  # 'm'
        5: SequenceLikelihood.UNLIKELY,  # 'n'
        4: SequenceLikelihood.LIKELY,  # 'o'
        16: SequenceLikelihood.UNLIKELY,  # 'p'
        63: SequenceLikelihood.UNLIKELY,  # 'q'
        7: SequenceLikelihood.POSITIVE,  # 'r'
        9: SequenceLikelihood.UNLIKELY,  # 's'
        10: SequenceLikelihood.UNLIKELY,  # 't'
        17: SequenceLikelihood.LIKELY,  # 'u'
        55: SequenceLikelihood.UNLIKELY,  # 'v'
        8: SequenceLikelihood.LIKELY,  # 'w'
        57: SequenceLikelihood.UNLIKELY,  # 'x'
        12: SequenceLikelihood.UNLIKELY,  # 'y'
        6: SequenceLikelihood.UNLIKELY,  # 'z'
        66: SequenceLikelihood.UNLIKELY,  # 'Ó'
        27: SequenceLikelihood.LIKELY,  # 'ó'
        67: SequenceLikelihood.UNLIKELY,  # 'Ą'
        25: SequenceLikelihood.UNLIKELY,  # 'ą'
        68: SequenceLikelihood.NEGATIVE,  # 'Ć'
        29: SequenceLikelihood.NEGATIVE,  # 'ć'
        65: SequenceLikelihood.UNLIKELY,  # 'Ę'
        24: SequenceLikelihood.UNLIKELY,  # 'ę'
        61: SequenceLikelihood.UNLIKELY,  # 'Ł'
        21: SequenceLikelihood.LIKELY,  # 'ł'
        70: SequenceLikelihood.NEGATIVE,  # 'Ń'
        42: SequenceLikelihood.NEGATIVE,  # 'ń'
        59: SequenceLikelihood.UNLIKELY,  # 'Ś'
        28: SequenceLikelihood.UNLIKELY,  # 'ś'
        69: SequenceLikelihood.NEGATIVE,  # 'Ź'
        53: SequenceLikelihood.NEGATIVE,  # 'ź'
        62: SequenceLikelihood.UNLIKELY,  # 'Ż'
        26: SequenceLikelihood.UNLIKELY,  # 'ż'
    },
    54: {  # 'H'
        34: SequenceLikelihood.UNLIKELY,  # 'A'
        46: SequenceLikelihood.UNLIKELY,  # 'B'
        39: SequenceLikelihood.UNLIKELY,  # 'C'
        41: SequenceLikelihood.UNLIKELY,  # 'D'
        48: SequenceLikelihood.UNLIKELY,  # 'E'
        52: SequenceLikelihood.UNLIKELY,  # 'F'
        49: SequenceLikelihood.UNLIKELY,  # 'G'
        54: SequenceLikelihood.UNLIKELY,  # 'H'
        43: SequenceLikelihood.UNLIKELY,  # 'I'
        47: SequenceLikelihood.UNLIKELY,  # 'J'
        37: SequenceLikelihood.UNLIKELY,  # 'K'
        50: SequenceLikelihood.UNLIKELY,  # 'L'
        35: SequenceLikelihood.UNLIKELY,  # 'M'
        36: SequenceLikelihood.UNLIKELY,  # 'N'
        40: SequenceLikelihood.UNLIKELY,  # 'O'
        30: SequenceLikelihood.UNLIKELY,  # 'P'
        64: SequenceLikelihood.UNLIKELY,  # 'Q'
        45: SequenceLikelihood.UNLIKELY,  # 'R'
        33: SequenceLikelihood.UNLIKELY,  # 'S'
        38: SequenceLikelihood.UNLIKELY,  # 'T'
        51: SequenceLikelihood.UNLIKELY,  # 'U'
        56: SequenceLikelihood.UNLIKELY,  # 'V'
        32: SequenceLikelihood.UNLIKELY,  # 'W'
        60: SequenceLikelihood.UNLIKELY,  # 'X'
        58: SequenceLikelihood.UNLIKELY,  # 'Y'
        44: SequenceLikelihood.UNLIKELY,  # 'Z'
        1: SequenceLikelihood.LIKELY,  # 'a'
        20: SequenceLikelihood.UNLIKELY,  # 'b'
        11: SequenceLikelihood.UNLIKELY,  # 'c'
        14: SequenceLikelihood.UNLIKELY,  # 'd'
        2: SequenceLikelihood.LIKELY,  # 'e'
        31: SequenceLikelihood.UNLIKELY,  # 'f'
        22: SequenceLikelihood.UNLIKELY,  # 'g'
        23: SequenceLikelihood.UNLIKELY,  # 'h'
        3: SequenceLikelihood.LIKELY,  # 'i'
        19: SequenceLikelihood.UNLIKELY,  # 'j'
        13: SequenceLikelihood.UNLIKELY,  # 'k'
        18: SequenceLikelihood.UNLIKELY,  # 'l'
        15: SequenceLikelihood.UNLIKELY,  # 'm'
        5: SequenceLikelihood.UNLIKELY,  # 'n'
        4: SequenceLikelihood.LIKELY,  # 'o'
        16: SequenceLikelihood.UNLIKELY,  # 'p'
        63: SequenceLikelihood.UNLIKELY,  # 'q'
        7: SequenceLikelihood.UNLIKELY,  # 'r'
        9: SequenceLikelihood.UNLIKELY,  # 's'
        10: SequenceLikelihood.UNLIKELY,  # 't'
        17: SequenceLikelihood.LIKELY,  # 'u'
        55: SequenceLikelihood.UNLIKELY,  # 'v'
        8: SequenceLikelihood.UNLIKELY,  # 'w'
        57: SequenceLikelihood.UNLIKELY,  # 'x'
        12: SequenceLikelihood.UNLIKELY,  # 'y'
        6: SequenceLikelihood.UNLIKELY,  # 'z'
        66: SequenceLikelihood.UNLIKELY,  # 'Ó'
        27: SequenceLikelihood.UNLIKELY,  # 'ó'
        67: SequenceLikelihood.UNLIKELY,  # 'Ą'
        25: SequenceLikelihood.UNLIKELY,  # 'ą'
        68: SequenceLikelihood.NEGATIVE,  # 'Ć'
        29: SequenceLikelihood.NEGATIVE,  # 'ć'
        65: SequenceLikelihood.UNLIKELY,  # 'Ę'
        24: SequenceLikelihood.UNLIKELY,  # 'ę'
        61: SequenceLikelihood.UNLIKELY,  # 'Ł'
        21: SequenceLikelihood.UNLIKELY,  # 'ł'
        70: SequenceLikelihood.NEGATIVE,  # 'Ń'
        42: SequenceLikelihood.NEGATIVE,  # 'ń'
        59: SequenceLikelihood.UNLIKELY,  # 'Ś'
        28: SequenceLikelihood.NEGATIVE,  # 'ś'
        69: SequenceLikelihood.NEGATIVE,  # 'Ź'
        53: SequenceLikelihood.NEGATIVE,  # 'ź'
        62: SequenceLikelihood.UNLIKELY,  # 'Ż'
        26: SequenceLikelihood.NEGATIVE,  # 'ż'
    },
    43: {  # 'I'
        34: SequenceLikelihood.LIKELY,  # 'A'
        46: SequenceLikelihood.UNLIKELY,  # 'B'
        39: SequenceLikelihood.LIKELY,  # 'C'
        41: SequenceLikelihood.LIKELY,  # 'D'
        48: SequenceLikelihood.LIKELY,  # 'E'
        52: SequenceLikelihood.UNLIKELY,  # 'F'
        49: SequenceLikelihood.UNLIKELY,  # 'G'
        54: SequenceLikelihood.UNLIKELY,  # 'H'
        43: SequenceLikelihood.POSITIVE,  # 'I'
        47: SequenceLikelihood.UNLIKELY,  # 'J'
        37: SequenceLikelihood.LIKELY,  # 'K'
        50: SequenceLikelihood.LIKELY,  # 'L'
        35: SequenceLikelihood.LIKELY,  # 'M'
        36: SequenceLikelihood.LIKELY,  # 'N'
        40: SequenceLikelihood.LIKELY,  # 'O'
        30: SequenceLikelihood.LIKELY,  # 'P'
        64: SequenceLikelihood.UNLIKELY,  # 'Q'
        45: SequenceLikelihood.UNLIKELY,  # 'R'
        33: SequenceLikelihood.LIKELY,  # 'S'
        38: SequenceLikelihood.LIKELY,  # 'T'
        51: SequenceLikelihood.UNLIKELY,  # 'U'
        56: SequenceLikelihood.LIKELY,  # 'V'
        32: SequenceLikelihood.UNLIKELY,  # 'W'
        60: SequenceLikelihood.UNLIKELY,  # 'X'
        58: SequenceLikelihood.UNLIKELY,  # 'Y'
        44: SequenceLikelihood.UNLIKELY,  # 'Z'
        1: SequenceLikelihood.UNLIKELY,  # 'a'
        20: SequenceLikelihood.UNLIKELY,  # 'b'
        11: SequenceLikelihood.LIKELY,  # 'c'
        14: SequenceLikelihood.LIKELY,  # 'd'
        2: SequenceLikelihood.UNLIKELY,  # 'e'
        31: SequenceLikelihood.UNLIKELY,  # 'f'
        22: SequenceLikelihood.UNLIKELY,  # 'g'
        23: SequenceLikelihood.UNLIKELY,  # 'h'
        3: SequenceLikelihood.UNLIKELY,  # 'i'
        19: SequenceLikelihood.UNLIKELY,  # 'j'
        13: SequenceLikelihood.UNLIKELY,  # 'k'
        18: SequenceLikelihood.LIKELY,  # 'l'
        15: SequenceLikelihood.LIKELY,  # 'm'
        5: SequenceLikelihood.POSITIVE,  # 'n'
        4: SequenceLikelihood.UNLIKELY,  # 'o'
        16: SequenceLikelihood.UNLIKELY,  # 'p'
        63: SequenceLikelihood.UNLIKELY,  # 'q'
        7: SequenceLikelihood.LIKELY,  # 'r'
        9: SequenceLikelihood.LIKELY,  # 's'
        10: SequenceLikelihood.UNLIKELY,  # 't'
        17: SequenceLikelihood.UNLIKELY,  # 'u'
        55: SequenceLikelihood.UNLIKELY,  # 'v'
        8: SequenceLikelihood.UNLIKELY,  # 'w'
        57: SequenceLikelihood.UNLIKELY,  # 'x'
        12: SequenceLikelihood.UNLIKELY,  # 'y'
        6: SequenceLikelihood.LIKELY,  # 'z'
        66: SequenceLikelihood.UNLIKELY,  # 'Ó'
        27: SequenceLikelihood.UNLIKELY,  # 'ó'
        67: SequenceLikelihood.UNLIKELY,  # 'Ą'
        25: SequenceLikelihood.UNLIKELY,  # 'ą'
        68: SequenceLikelihood.UNLIKELY,  # 'Ć'
        29: SequenceLikelihood.UNLIKELY,  # 'ć'
        65: SequenceLikelihood.UNLIKELY,  # 'Ę'
        24: SequenceLikelihood.UNLIKELY,  # 'ę'
        61: SequenceLikelihood.UNLIKELY,  # 'Ł'
        21: SequenceLikelihood.UNLIKELY,  # 'ł'
        70: SequenceLikelihood.UNLIKELY,  # 'Ń'
        42: SequenceLikelihood.UNLIKELY,  # 'ń'
        59: SequenceLikelihood.UNLIKELY,  # 'Ś'
        28: SequenceLikelihood.UNLIKELY,  # 'ś'
        69: SequenceLikelihood.UNLIKELY,  # 'Ź'
        53: SequenceLikelihood.NEGATIVE,  # 'ź'
        62: SequenceLikelihood.UNLIKELY,  # 'Ż'
        26: SequenceLikelihood.UNLIKELY,  # 'ż'
    },
    47: {  # 'J'
        34: SequenceLikelihood.LIKELY,  # 'A'
        46: SequenceLikelihood.UNLIKELY,  # 'B'
        39: SequenceLikelihood.UNLIKELY,  # 'C'
        41: SequenceLikelihood.UNLIKELY,  # 'D'
        48: SequenceLikelihood.LIKELY,  # 'E'
        52: SequenceLikelihood.UNLIKELY,  # 'F'
        49: SequenceLikelihood.UNLIKELY,  # 'G'
        54: SequenceLikelihood.UNLIKELY,  # 'H'
        43: SequenceLikelihood.UNLIKELY,  # 'I'
        47: SequenceLikelihood.UNLIKELY,  # 'J'
        37: SequenceLikelihood.UNLIKELY,  # 'K'
        50: SequenceLikelihood.UNLIKELY,  # 'L'
        35: SequenceLikelihood.UNLIKELY,  # 'M'
        36: SequenceLikelihood.UNLIKELY,  # 'N'
        40: SequenceLikelihood.UNLIKELY,  # 'O'
        30: SequenceLikelihood.UNLIKELY,  # 'P'
        64: SequenceLikelihood.UNLIKELY,  # 'Q'
        45: SequenceLikelihood.UNLIKELY,  # 'R'
        33: SequenceLikelihood.UNLIKELY,  # 'S'
        38: SequenceLikelihood.UNLIKELY,  # 'T'
        51: SequenceLikelihood.UNLIKELY,  # 'U'
        56: SequenceLikelihood.UNLIKELY,  # 'V'
        32: SequenceLikelihood.UNLIKELY,  # 'W'
        60: SequenceLikelihood.UNLIKELY,  # 'X'
        58: SequenceLikelihood.UNLIKELY,  # 'Y'
        44: SequenceLikelihood.UNLIKELY,  # 'Z'
        1: SequenceLikelihood.POSITIVE,  # 'a'
        20: SequenceLikelihood.UNLIKELY,  # 'b'
        11: SequenceLikelihood.UNLIKELY,  # 'c'
        14: SequenceLikelihood.UNLIKELY,  # 'd'
        2: SequenceLikelihood.POSITIVE,  # 'e'
        31: SequenceLikelihood.UNLIKELY,  # 'f'
        22: SequenceLikelihood.UNLIKELY,  # 'g'
        23: SequenceLikelihood.UNLIKELY,  # 'h'
        3: SequenceLikelihood.UNLIKELY,  # 'i'
        19: SequenceLikelihood.UNLIKELY,  # 'j'
        13: SequenceLikelihood.UNLIKELY,  # 'k'
        18: SequenceLikelihood.UNLIKELY,  # 'l'
        15: SequenceLikelihood.UNLIKELY,  # 'm'
        5: SequenceLikelihood.UNLIKELY,  # 'n'
        4: SequenceLikelihood.LIKELY,  # 'o'
        16: SequenceLikelihood.UNLIKELY,  # 'p'
        63: SequenceLikelihood.UNLIKELY,  # 'q'
        7: SequenceLikelihood.UNLIKELY,  # 'r'
        9: SequenceLikelihood.UNLIKELY,  # 's'
        10: SequenceLikelihood.UNLIKELY,  # 't'
        17: SequenceLikelihood.LIKELY,  # 'u'
        55: SequenceLikelihood.UNLIKELY,  # 'v'
        8: SequenceLikelihood.UNLIKELY,  # 'w'
        57: SequenceLikelihood.UNLIKELY,  # 'x'
        12: SequenceLikelihood.UNLIKELY,  # 'y'
        6: SequenceLikelihood.UNLIKELY,  # 'z'
        66: SequenceLikelihood.UNLIKELY,  # 'Ó'
        27: SequenceLikelihood.UNLIKELY,  # 'ó'
        67: SequenceLikelihood.UNLIKELY,  # 'Ą'
        25: SequenceLikelihood.UNLIKELY,  # 'ą'
        68: SequenceLikelihood.NEGATIVE,  # 'Ć'
        29: SequenceLikelihood.NEGATIVE,  # 'ć'
        65: SequenceLikelihood.UNLIKELY,  # 'Ę'
        24: SequenceLikelihood.UNLIKELY,  # 'ę'
        61: SequenceLikelihood.NEGATIVE,  # 'Ł'
        21: SequenceLikelihood.NEGATIVE,  # 'ł'
        70: SequenceLikelihood.NEGATIVE,  # 'Ń'
        42: SequenceLikelihood.NEGATIVE,  # 'ń'
        59: SequenceLikelihood.UNLIKELY,  # 'Ś'
        28: SequenceLikelihood.UNLIKELY,  # 'ś'
        69: SequenceLikelihood.NEGATIVE,  # 'Ź'
        53: SequenceLikelihood.NEGATIVE,  # 'ź'
        62: SequenceLikelihood.UNLIKELY,  # 'Ż'
        26: SequenceLikelihood.NEGATIVE,  # 'ż'
    },
    37: {  # 'K'
        34: SequenceLikelihood.LIKELY,  # 'A'
        46: SequenceLikelihood.UNLIKELY,  # 'B'
        39: SequenceLikelihood.UNLIKELY,  # 'C'
        41: SequenceLikelihood.UNLIKELY,  # 'D'
        48: SequenceLikelihood.UNLIKELY,  # 'E'
        52: SequenceLikelihood.UNLIKELY,  # 'F'
        49: SequenceLikelihood.UNLIKELY,  # 'G'
        54: SequenceLikelihood.UNLIKELY,  # 'H'
        43: SequenceLikelihood.LIKELY,  # 'I'
        47: SequenceLikelihood.UNLIKELY,  # 'J'
        37: SequenceLikelihood.UNLIKELY,  # 'K'
        50: SequenceLikelihood.UNLIKELY,  # 'L'
        35: SequenceLikelihood.UNLIKELY,  # 'M'
        36: SequenceLikelihood.UNLIKELY,  # 'N'
        40: SequenceLikelihood.LIKELY,  # 'O'
        30: SequenceLikelihood.UNLIKELY,  # 'P'
        64: SequenceLikelihood.UNLIKELY,  # 'Q'
        45: SequenceLikelihood.LIKELY,  # 'R'
        33: SequenceLikelihood.LIKELY,  # 'S'
        38: SequenceLikelihood.UNLIKELY,  # 'T'
        51: SequenceLikelihood.LIKELY,  # 'U'
        56: SequenceLikelihood.UNLIKELY,  # 'V'
        32: SequenceLikelihood.UNLIKELY,  # 'W'
        60: SequenceLikelihood.UNLIKELY,  # 'X'
        58: SequenceLikelihood.UNLIKELY,  # 'Y'
        44: SequenceLikelihood.UNLIKELY,  # 'Z'
        1: SequenceLikelihood.POSITIVE,  # 'a'
        20: SequenceLikelihood.UNLIKELY,  # 'b'
        11: SequenceLikelihood.UNLIKELY,  # 'c'
        14: SequenceLikelihood.UNLIKELY,  # 'd'
        2: SequenceLikelihood.LIKELY,  # 'e'
        31: SequenceLikelihood.UNLIKELY,  # 'f'
        22: SequenceLikelihood.UNLIKELY,  # 'g'
        23: SequenceLikelihood.UNLIKELY,  # 'h'
        3: SequenceLikelihood.LIKELY,  # 'i'
        19: SequenceLikelihood.UNLIKELY,  # 'j'
        13: SequenceLikelihood.UNLIKELY,  # 'k'
        18: SequenceLikelihood.LIKELY,  # 'l'
        15: SequenceLikelihood.UNLIKELY,  # 'm'
        5: SequenceLikelihood.UNLIKELY,  # 'n'
        4: SequenceLikelihood.POSITIVE,  # 'o'
        16: SequenceLikelihood.UNLIKELY,  # 'p'
        63: SequenceLikelihood.UNLIKELY,  # 'q'
        7: SequenceLikelihood.POSITIVE,  # 'r'
        9: SequenceLikelihood.LIKELY,  # 's'
        10: SequenceLikelihood.LIKELY,  # 't'
        17: SequenceLikelihood.LIKELY,  # 'u'
        55: SequenceLikelihood.UNLIKELY,  # 'v'
        8: SequenceLikelihood.LIKELY,  # 'w'
        57: SequenceLikelihood.UNLIKELY,  # 'x'
        12: SequenceLikelihood.UNLIKELY,  # 'y'
        6: SequenceLikelihood.UNLIKELY,  # 'z'
        66: SequenceLikelihood.UNLIKELY,  # 'Ó'
        27: SequenceLikelihood.UNLIKELY,  # 'ó'
        67: SequenceLikelihood.UNLIKELY,  # 'Ą'
        25: SequenceLikelihood.UNLIKELY,  # 'ą'
        68: SequenceLikelihood.NEGATIVE,  # 'Ć'
        29: SequenceLikelihood.UNLIKELY,  # 'ć'
        65: SequenceLikelihood.UNLIKELY,  # 'Ę'
        24: SequenceLikelihood.UNLIKELY,  # 'ę'
        61: SequenceLikelihood.UNLIKELY,  # 'Ł'
        21: SequenceLikelihood.UNLIKELY,  # 'ł'
        70: SequenceLikelihood.NEGATIVE,  # 'Ń'
        42: SequenceLikelihood.NEGATIVE,  # 'ń'
        59: SequenceLikelihood.UNLIKELY,  # 'Ś'
        28: SequenceLikelihood.UNLIKELY,  # 'ś'
        69: SequenceLikelihood.UNLIKELY,  # 'Ź'
        53: SequenceLikelihood.NEGATIVE,  # 'ź'
        62: SequenceLikelihood.UNLIKELY,  # 'Ż'
        26: SequenceLikelihood.UNLIKELY,  # 'ż'
    },
    50: {  # 'L'
        34: SequenceLikelihood.LIKELY,  # 'A'
        46: SequenceLikelihood.UNLIKELY,  # 'B'
        39: SequenceLikelihood.UNLIKELY,  # 'C'
        41: SequenceLikelihood.UNLIKELY,  # 'D'
        48: SequenceLikelihood.LIKELY,  # 'E'
        52: SequenceLikelihood.UNLIKELY,  # 'F'
        49: SequenceLikelihood.UNLIKELY,  # 'G'
        54: SequenceLikelihood.UNLIKELY,  # 'H'
        43: SequenceLikelihood.LIKELY,  # 'I'
        47: SequenceLikelihood.UNLIKELY,  # 'J'
        37: SequenceLikelihood.UNLIKELY,  # 'K'
        50: SequenceLikelihood.UNLIKELY,  # 'L'
        35: SequenceLikelihood.UNLIKELY,  # 'M'
        36: SequenceLikelihood.LIKELY,  # 'N'
        40: SequenceLikelihood.LIKELY,  # 'O'
        30: SequenceLikelihood.UNLIKELY,  # 'P'
        64: SequenceLikelihood.UNLIKELY,  # 'Q'
        45: SequenceLikelihood.UNLIKELY,  # 'R'
        33: SequenceLikelihood.UNLIKELY,  # 'S'
        38: SequenceLikelihood.UNLIKELY,  # 'T'
        51: SequenceLikelihood.UNLIKELY,  # 'U'
        56: SequenceLikelihood.UNLIKELY,  # 'V'
        32: SequenceLikelihood.UNLIKELY,  # 'W'
        60: SequenceLikelihood.UNLIKELY,  # 'X'
        58: SequenceLikelihood.UNLIKELY,  # 'Y'
        44: SequenceLikelihood.UNLIKELY,  # 'Z'
        1: SequenceLikelihood.LIKELY,  # 'a'
        20: SequenceLikelihood.UNLIKELY,  # 'b'
        11: SequenceLikelihood.UNLIKELY,  # 'c'
        14: SequenceLikelihood.UNLIKELY,  # 'd'
        2: SequenceLikelihood.POSITIVE,  # 'e'
        31: SequenceLikelihood.UNLIKELY,  # 'f'
        22: SequenceLikelihood.UNLIKELY,  # 'g'
        23: SequenceLikelihood.UNLIKELY,  # 'h'
        3: SequenceLikelihood.POSITIVE,  # 'i'
        19: SequenceLikelihood.UNLIKELY,  # 'j'
        13: SequenceLikelihood.UNLIKELY,  # 'k'
        18: SequenceLikelihood.UNLIKELY,  # 'l'
        15: SequenceLikelihood.UNLIKELY,  # 'm'
        5: SequenceLikelihood.UNLIKELY,  # 'n'
        4: SequenceLikelihood.LIKELY,  # 'o'
        16: SequenceLikelihood.UNLIKELY,  # 'p'
        63: SequenceLikelihood.UNLIKELY,  # 'q'
        7: SequenceLikelihood.UNLIKELY,  # 'r'
        9: SequenceLikelihood.UNLIKELY,  # 's'
        10: SequenceLikelihood.UNLIKELY,  # 't'
        17: SequenceLikelihood.LIKELY,  # 'u'
        55: SequenceLikelihood.UNLIKELY,  # 'v'
        8: SequenceLikelihood.UNLIKELY,  # 'w'
        57: SequenceLikelihood.UNLIKELY,  # 'x'
        12: SequenceLikelihood.UNLIKELY,  # 'y'
        6: SequenceLikelihood.UNLIKELY,  # 'z'
        66: SequenceLikelihood.UNLIKELY,  # 'Ó'
        27: SequenceLikelihood.UNLIKELY,  # 'ó'
        67: SequenceLikelihood.UNLIKELY,  # 'Ą'
        25: SequenceLikelihood.UNLIKELY,  # 'ą'
        68: SequenceLikelihood.NEGATIVE,  # 'Ć'
        29: SequenceLikelihood.NEGATIVE,  # 'ć'
        65: SequenceLikelihood.UNLIKELY,  # 'Ę'
        24: SequenceLikelihood.UNLIKELY,  # 'ę'
        61: SequenceLikelihood.UNLIKELY,  # 'Ł'
        21: SequenceLikelihood.NEGATIVE,  # 'ł'
        70: SequenceLikelihood.NEGATIVE,  # 'Ń'
        42: SequenceLikelihood.NEGATIVE,  # 'ń'
        59: SequenceLikelihood.UNLIKELY,  # 'Ś'
        28: SequenceLikelihood.UNLIKELY,  # 'ś'
        69: SequenceLikelihood.NEGATIVE,  # 'Ź'
        53: SequenceLikelihood.NEGATIVE,  # 'ź'
        62: SequenceLikelihood.UNLIKELY,  # 'Ż'
        26: SequenceLikelihood.UNLIKELY,  # 'ż'
    },
    35: {  # 'M'
        34: SequenceLikelihood.LIKELY,  # 'A'
        46: SequenceLikelihood.UNLIKELY,  # 'B'
        39: SequenceLikelihood.UNLIKELY,  # 'C'
        41: SequenceLikelihood.UNLIKELY,  # 'D'
        48: SequenceLikelihood.LIKELY,  # 'E'
        52: SequenceLikelihood.UNLIKELY,  # 'F'
        49: SequenceLikelihood.UNLIKELY,  # 'G'
        54: SequenceLikelihood.UNLIKELY,  # 'H'
        43: SequenceLikelihood.LIKELY,  # 'I'
        47: SequenceLikelihood.UNLIKELY,  # 'J'
        37: SequenceLikelihood.UNLIKELY,  # 'K'
        50: SequenceLikelihood.UNLIKELY,  # 'L'
        35: SequenceLikelihood.UNLIKELY,  # 'M'
        36: SequenceLikelihood.UNLIKELY,  # 'N'
        40: SequenceLikelihood.LIKELY,  # 'O'
        30: SequenceLikelihood.LIKELY,  # 'P'
        64: SequenceLikelihood.UNLIKELY,  # 'Q'
        45: SequenceLikelihood.UNLIKELY,  # 'R'
        33: SequenceLikelihood.LIKELY,  # 'S'
        38: SequenceLikelihood.UNLIKELY,  # 'T'
        51: SequenceLikelihood.UNLIKELY,  # 'U'
        56: SequenceLikelihood.UNLIKELY,  # 'V'
        32: SequenceLikelihood.UNLIKELY,  # 'W'
        60: SequenceLikelihood.UNLIKELY,  # 'X'
        58: SequenceLikelihood.UNLIKELY,  # 'Y'
        44: SequenceLikelihood.UNLIKELY,  # 'Z'
        1: SequenceLikelihood.POSITIVE,  # 'a'
        20: SequenceLikelihood.UNLIKELY,  # 'b'
        11: SequenceLikelihood.UNLIKELY,  # 'c'
        14: SequenceLikelihood.UNLIKELY,  # 'd'
        2: SequenceLikelihood.LIKELY,  # 'e'
        31: SequenceLikelihood.UNLIKELY,  # 'f'
        22: SequenceLikelihood.UNLIKELY,  # 'g'
        23: SequenceLikelihood.UNLIKELY,  # 'h'
        3: SequenceLikelihood.POSITIVE,  # 'i'
        19: SequenceLikelihood.UNLIKELY,  # 'j'
        13: SequenceLikelihood.UNLIKELY,  # 'k'
        18: SequenceLikelihood.UNLIKELY,  # 'l'
        15: SequenceLikelihood.UNLIKELY,  # 'm'
        5: SequenceLikelihood.UNLIKELY,  # 'n'
        4: SequenceLikelihood.POSITIVE,  # 'o'
        16: SequenceLikelihood.UNLIKELY,  # 'p'
        63: SequenceLikelihood.UNLIKELY,  # 'q'
        7: SequenceLikelihood.UNLIKELY,  # 'r'
        9: SequenceLikelihood.UNLIKELY,  # 's'
        10: SequenceLikelihood.UNLIKELY,  # 't'
        17: SequenceLikelihood.LIKELY,  # 'u'
        55: SequenceLikelihood.UNLIKELY,  # 'v'
        8: SequenceLikelihood.UNLIKELY,  # 'w'
        57: SequenceLikelihood.UNLIKELY,  # 'x'
        12: SequenceLikelihood.LIKELY,  # 'y'
        6: SequenceLikelihood.UNLIKELY,  # 'z'
        66: SequenceLikelihood.UNLIKELY,  # 'Ó'
        27: SequenceLikelihood.LIKELY,  # 'ó'
        67: SequenceLikelihood.UNLIKELY,  # 'Ą'
        25: SequenceLikelihood.UNLIKELY,  # 'ą'
        68: SequenceLikelihood.UNLIKELY,  # 'Ć'
        29: SequenceLikelihood.NEGATIVE,  # 'ć'
        65: SequenceLikelihood.UNLIKELY,  # 'Ę'
        24: SequenceLikelihood.UNLIKELY,  # 'ę'
        61: SequenceLikelihood.UNLIKELY,  # 'Ł'
        21: SequenceLikelihood.LIKELY,  # 'ł'
        70: SequenceLikelihood.NEGATIVE,  # 'Ń'
        42: SequenceLikelihood.NEGATIVE,  # 'ń'
        59: SequenceLikelihood.UNLIKELY,  # 'Ś'
        28: SequenceLikelihood.UNLIKELY,  # 'ś'
        69: SequenceLikelihood.NEGATIVE,  # 'Ź'
        53: SequenceLikelihood.NEGATIVE,  # 'ź'
        62: SequenceLikelihood.UNLIKELY,  # 'Ż'
        26: SequenceLikelihood.UNLIKELY,  # 'ż'
    },
    36: {  # 'N'
        34: SequenceLikelihood.LIKELY,  # 'A'
        46: SequenceLikelihood.UNLIKELY,  # 'B'
        39: SequenceLikelihood.UNLIKELY,  # 'C'
        41: SequenceLikelihood.UNLIKELY,  # 'D'
        48: SequenceLikelihood.LIKELY,  # 'E'
        52: SequenceLikelihood.UNLIKELY,  # 'F'
        49: SequenceLikelihood.UNLIKELY,  # 'G'
        54: SequenceLikelihood.UNLIKELY,  # 'H'
        43: SequenceLikelihood.LIKELY,  # 'I'
        47: SequenceLikelihood.UNLIKELY,  # 'J'
        37: SequenceLikelihood.UNLIKELY,  # 'K'
        50: SequenceLikelihood.UNLIKELY,  # 'L'
        35: SequenceLikelihood.UNLIKELY,  # 'M'
        36: SequenceLikelihood.UNLIKELY,  # 'N'
        40: SequenceLikelihood.LIKELY,  # 'O'
        30: SequenceLikelihood.UNLIKELY,  # 'P'
        64: SequenceLikelihood.UNLIKELY,  # 'Q'
        45: SequenceLikelihood.UNLIKELY,  # 'R'
        33: SequenceLikelihood.UNLIKELY,  # 'S'
        38: SequenceLikelihood.LIKELY,  # 'T'
        51: SequenceLikelihood.UNLIKELY,  # 'U'
        56: SequenceLikelihood.UNLIKELY,  # 'V'
        32: SequenceLikelihood.UNLIKELY,  # 'W'
        60: SequenceLikelihood.UNLIKELY,  # 'X'
        58: SequenceLikelihood.LIKELY,  # 'Y'
        44: SequenceLikelihood.UNLIKELY,  # 'Z'
        1: SequenceLikelihood.POSITIVE,  # 'a'
        20: SequenceLikelihood.UNLIKELY,  # 'b'
        11: SequenceLikelihood.UNLIKELY,  # 'c'
        14: SequenceLikelihood.UNLIKELY,  # 'd'
        2: SequenceLikelihood.LIKELY,  # 'e'
        31: SequenceLikelihood.UNLIKELY,  # 'f'
        22: SequenceLikelihood.UNLIKELY,  # 'g'
        23: SequenceLikelihood.UNLIKELY,  # 'h'
        3: SequenceLikelihood.POSITIVE,  # 'i'
        19: SequenceLikelihood.UNLIKELY,  # 'j'
        13: SequenceLikelihood.UNLIKELY,  # 'k'
        18: SequenceLikelihood.UNLIKELY,  # 'l'
        15: SequenceLikelihood.UNLIKELY,  # 'm'
        5: SequenceLikelihood.UNLIKELY,  # 'n'
        4: SequenceLikelihood.POSITIVE,  # 'o'
        16: SequenceLikelihood.UNLIKELY,  # 'p'
        63: SequenceLikelihood.UNLIKELY,  # 'q'
        7: SequenceLikelihood.UNLIKELY,  # 'r'
        9: SequenceLikelihood.UNLIKELY,  # 's'
        10: SequenceLikelihood.UNLIKELY,  # 't'
        17: SequenceLikelihood.LIKELY,  # 'u'
        55: SequenceLikelihood.UNLIKELY,  # 'v'
        8: SequenceLikelihood.UNLIKELY,  # 'w'
        57: SequenceLikelihood.UNLIKELY,  # 'x'
        12: SequenceLikelihood.UNLIKELY,  # 'y'
        6: SequenceLikelihood.UNLIKELY,  # 'z'
        66: SequenceLikelihood.UNLIKELY,  # 'Ó'
        27: SequenceLikelihood.UNLIKELY,  # 'ó'
        67: SequenceLikelihood.UNLIKELY,  # 'Ą'
        25: SequenceLikelihood.NEGATIVE,  # 'ą'
        68: SequenceLikelihood.UNLIKELY,  # 'Ć'
        29: SequenceLikelihood.NEGATIVE,  # 'ć'
        65: SequenceLikelihood.UNLIKELY,  # 'Ę'
        24: SequenceLikelihood.UNLIKELY,  # 'ę'
        61: SequenceLikelihood.NEGATIVE,  # 'Ł'
        21: SequenceLikelihood.NEGATIVE,  # 'ł'
        70: SequenceLikelihood.NEGATIVE,  # 'Ń'
        42: SequenceLikelihood.NEGATIVE,  # 'ń'
        59: SequenceLikelihood.UNLIKELY,  # 'Ś'
        28: SequenceLikelihood.UNLIKELY,  # 'ś'
        69: SequenceLikelihood.NEGATIVE,  # 'Ź'
        53: SequenceLikelihood.NEGATIVE,  # 'ź'
        62: SequenceLikelihood.UNLIKELY,  # 'Ż'
        26: SequenceLikelihood.UNLIKELY,  # 'ż'
    },
    40: {  # 'O'
        34: SequenceLikelihood.UNLIKELY,  # 'A'
        46: SequenceLikelihood.LIKELY,  # 'B'
        39: SequenceLikelihood.LIKELY,  # 'C'
        41: SequenceLikelihood.LIKELY,  # 'D'
        48: SequenceLikelihood.UNLIKELY,  # 'E'
        52: SequenceLikelihood.UNLIKELY,  # 'F'
        49: SequenceLikelihood.UNLIKELY,  # 'G'
        54: SequenceLikelihood.UNLIKELY,  # 'H'
        43: SequenceLikelihood.UNLIKELY,  # 'I'
        47: SequenceLikelihood.UNLIKELY,  # 'J'
        37: SequenceLikelihood.LIKELY,  # 'K'
        50: SequenceLikelihood.LIKELY,  # 'L'
        35: SequenceLikelihood.LIKELY,  # 'M'
        36: SequenceLikelihood.LIKELY,  # 'N'
        40: SequenceLikelihood.UNLIKELY,  # 'O'
        30: SequenceLikelihood.LIKELY,  # 'P'
        64: SequenceLikelihood.UNLIKELY,  # 'Q'
        45: SequenceLikelihood.LIKELY,  # 'R'
        33: SequenceLikelihood.LIKELY,  # 'S'
        38: SequenceLikelihood.LIKELY,  # 'T'
        51: SequenceLikelihood.UNLIKELY,  # 'U'
        56: SequenceLikelihood.UNLIKELY,  # 'V'
        32: SequenceLikelihood.LIKELY,  # 'W'
        60: SequenceLikelihood.UNLIKELY,  # 'X'
        58: SequenceLikelihood.UNLIKELY,  # 'Y'
        44: SequenceLikelihood.UNLIKELY,  # 'Z'
        1: SequenceLikelihood.UNLIKELY,  # 'a'
        20: SequenceLikelihood.LIKELY,  # 'b'
        11: SequenceLikelihood.LIKELY,  # 'c'
        14: SequenceLikelihood.POSITIVE,  # 'd'
        2: SequenceLikelihood.UNLIKELY,  # 'e'
        31: SequenceLikelihood.LIKELY,  # 'f'
        22: SequenceLikelihood.LIKELY,  # 'g'
        23: SequenceLikelihood.UNLIKELY,  # 'h'
        3: SequenceLikelihood.UNLIKELY,  # 'i'
        19: SequenceLikelihood.LIKELY,  # 'j'
        13: SequenceLikelihood.LIKELY,  # 'k'
        18: SequenceLikelihood.LIKELY,  # 'l'
        15: SequenceLikelihood.UNLIKELY,  # 'm'
        5: SequenceLikelihood.LIKELY,  # 'n'
        4: SequenceLikelihood.UNLIKELY,  # 'o'
        16: SequenceLikelihood.LIKELY,  # 'p'
        63: SequenceLikelihood.UNLIKELY,  # 'q'
        7: SequenceLikelihood.LIKELY,  # 'r'
        9: SequenceLikelihood.LIKELY,  # 's'
        10: SequenceLikelihood.LIKELY,  # 't'
        17: SequenceLikelihood.UNLIKELY,  # 'u'
        55: SequenceLikelihood.UNLIKELY,  # 'v'
        8: SequenceLikelihood.UNLIKELY,  # 'w'
        57: SequenceLikelihood.UNLIKELY,  # 'x'
        12: SequenceLikelihood.UNLIKELY,  # 'y'
        6: SequenceLikelihood.UNLIKELY,  # 'z'
        66: SequenceLikelihood.NEGATIVE,  # 'Ó'
        27: SequenceLikelihood.NEGATIVE,  # 'ó'
        67: SequenceLikelihood.NEGATIVE,  # 'Ą'
        25: SequenceLikelihood.NEGATIVE,  # 'ą'
        68: SequenceLikelihood.UNLIKELY,  # 'Ć'
        29: SequenceLikelihood.UNLIKELY,  # 'ć'
        65: SequenceLikelihood.NEGATIVE,  # 'Ę'
        24: SequenceLikelihood.NEGATIVE,  # 'ę'
        61: SequenceLikelihood.UNLIKELY,  # 'Ł'
        21: SequenceLikelihood.UNLIKELY,  # 'ł'
        70: SequenceLikelihood.UNLIKELY,  # 'Ń'
        42: SequenceLikelihood.UNLIKELY,  # 'ń'
        59: SequenceLikelihood.LIKELY,  # 'Ś'
        28: SequenceLikelihood.LIKELY,  # 'ś'
        69: SequenceLikelihood.UNLIKELY,  # 'Ź'
        53: SequenceLikelihood.UNLIKELY,  # 'ź'
        62: SequenceLikelihood.UNLIKELY,  # 'Ż'
        26: SequenceLikelihood.UNLIKELY,  # 'ż'
    },
    30: {  # 'P'
        34: SequenceLikelihood.LIKELY,  # 'A'
        46: SequenceLikelihood.UNLIKELY,  # 'B'
        39: SequenceLikelihood.LIKELY,  # 'C'
        41: SequenceLikelihood.UNLIKELY,  # 'D'
        48: SequenceLikelihood.LIKELY,  # 'E'
        52: SequenceLikelihood.UNLIKELY,  # 'F'
        49: SequenceLikelihood.UNLIKELY,  # 'G'
        54: SequenceLikelihood.UNLIKELY,  # 'H'
        43: SequenceLikelihood.LIKELY,  # 'I'
        47: SequenceLikelihood.UNLIKELY,  # 'J'
        37: SequenceLikelihood.LIKELY,  # 'K'
        50: SequenceLikelihood.LIKELY,  # 'L'
        35: SequenceLikelihood.UNLIKELY,  # 'M'
        36: SequenceLikelihood.UNLIKELY,  # 'N'
        40: SequenceLikelihood.LIKELY,  # 'O'
        30: SequenceLikelihood.UNLIKELY,  # 'P'
        64: SequenceLikelihood.UNLIKELY,  # 'Q'
        45: SequenceLikelihood.LIKELY,  # 'R'
        33: SequenceLikelihood.LIKELY,  # 'S'
        38: SequenceLikelihood.UNLIKELY,  # 'T'
        51: SequenceLikelihood.UNLIKELY,  # 'U'
        56: SequenceLikelihood.UNLIKELY,  # 'V'
        32: SequenceLikelihood.UNLIKELY,  # 'W'
        60: SequenceLikelihood.UNLIKELY,  # 'X'
        58: SequenceLikelihood.UNLIKELY,  # 'Y'
        44: SequenceLikelihood.UNLIKELY,  # 'Z'
        1: SequenceLikelihood.POSITIVE,  # 'a'
        20: SequenceLikelihood.UNLIKELY,  # 'b'
        11: SequenceLikelihood.UNLIKELY,  # 'c'
        14: SequenceLikelihood.UNLIKELY,  # 'd'
        2: SequenceLikelihood.LIKELY,  # 'e'
        31: SequenceLikelihood.UNLIKELY,  # 'f'
        22: SequenceLikelihood.UNLIKELY,  # 'g'
        23: SequenceLikelihood.LIKELY,  # 'h'
        3: SequenceLikelihood.POSITIVE,  # 'i'
        19: SequenceLikelihood.UNLIKELY,  # 'j'
        13: SequenceLikelihood.UNLIKELY,  # 'k'
        18: SequenceLikelihood.LIKELY,  # 'l'
        15: SequenceLikelihood.UNLIKELY,  # 'm'
        5: SequenceLikelihood.UNLIKELY,  # 'n'
        4: SequenceLikelihood.POSITIVE,  # 'o'
        16: SequenceLikelihood.UNLIKELY,  # 'p'
        63: SequenceLikelihood.UNLIKELY,  # 'q'
        7: SequenceLikelihood.POSITIVE,  # 'r'
        9: SequenceLikelihood.LIKELY,  # 's'
        10: SequenceLikelihood.UNLIKELY,  # 't'
        17: SequenceLikelihood.LIKELY,  # 'u'
        55: SequenceLikelihood.UNLIKELY,  # 'v'
        8: SequenceLikelihood.UNLIKELY,  # 'w'
        57: SequenceLikelihood.UNLIKELY,  # 'x'
        12: SequenceLikelihood.LIKELY,  # 'y'
        6: SequenceLikelihood.UNLIKELY,  # 'z'
        66: SequenceLikelihood.UNLIKELY,  # 'Ó'
        27: SequenceLikelihood.LIKELY,  # 'ó'
        67: SequenceLikelihood.UNLIKELY,  # 'Ą'
        25: SequenceLikelihood.UNLIKELY,  # 'ą'
        68: SequenceLikelihood.NEGATIVE,  # 'Ć'
        29: SequenceLikelihood.NEGATIVE,  # 'ć'
        65: SequenceLikelihood.UNLIKELY,  # 'Ę'
        24: SequenceLikelihood.UNLIKELY,  # 'ę'
        61: SequenceLikelihood.UNLIKELY,  # 'Ł'
        21: SequenceLikelihood.LIKELY,  # 'ł'
        70: SequenceLikelihood.UNLIKELY,  # 'Ń'
        42: SequenceLikelihood.NEGATIVE,  # 'ń'
        59: SequenceLikelihood.UNLIKELY,  # 'Ś'
        28: SequenceLikelihood.NEGATIVE,  # 'ś'
        69: SequenceLikelihood.UNLIKELY,  # 'Ź'
        53: SequenceLikelihood.NEGATIVE,  # 'ź'
        62: SequenceLikelihood.UNLIKELY,  # 'Ż'
        26: SequenceLikelihood.UNLIKELY,  # 'ż'
    },
    64: {  # 'Q'
        34: SequenceLikelihood.UNLIKELY,  # 'A'
        46: SequenceLikelihood.UNLIKELY,  # 'B'
        39: SequenceLikelihood.UNLIKELY,  # 'C'
        41: SequenceLikelihood.UNLIKELY,  # 'D'
        48: SequenceLikelihood.UNLIKELY,  # 'E'
        52: SequenceLikelihood.UNLIKELY,  # 'F'
        49: SequenceLikelihood.UNLIKELY,  # 'G'
        54: SequenceLikelihood.UNLIKELY,  # 'H'
        43: SequenceLikelihood.UNLIKELY,  # 'I'
        47: SequenceLikelihood.UNLIKELY,  # 'J'
        37: SequenceLikelihood.UNLIKELY,  # 'K'
        50: SequenceLikelihood.UNLIKELY,  # 'L'
        35: SequenceLikelihood.UNLIKELY,  # 'M'
        36: SequenceLikelihood.UNLIKELY,  # 'N'
        40: SequenceLikelihood.UNLIKELY,  # 'O'
        30: SequenceLikelihood.UNLIKELY,  # 'P'
        64: SequenceLikelihood.UNLIKELY,  # 'Q'
        45: SequenceLikelihood.UNLIKELY,  # 'R'
        33: SequenceLikelihood.UNLIKELY,  # 'S'
        38: SequenceLikelihood.UNLIKELY,  # 'T'
        51: SequenceLikelihood.UNLIKELY,  # 'U'
        56: SequenceLikelihood.UNLIKELY,  # 'V'
        32: SequenceLikelihood.UNLIKELY,  # 'W'
        60: SequenceLikelihood.UNLIKELY,  # 'X'
        58: SequenceLikelihood.UNLIKELY,  # 'Y'
        44: SequenceLikelihood.UNLIKELY,  # 'Z'
        1: SequenceLikelihood.UNLIKELY,  # 'a'
        20: SequenceLikelihood.UNLIKELY,  # 'b'
        11: SequenceLikelihood.UNLIKELY,  # 'c'
        14: SequenceLikelihood.UNLIKELY,  # 'd'
        2: SequenceLikelihood.UNLIKELY,  # 'e'
        31: SequenceLikelihood.UNLIKELY,  # 'f'
        22: SequenceLikelihood.UNLIKELY,  # 'g'
        23: SequenceLikelihood.UNLIKELY,  # 'h'
        3: SequenceLikelihood.UNLIKELY,  # 'i'
        19: SequenceLikelihood.UNLIKELY,  # 'j'
        13: SequenceLikelihood.UNLIKELY,  # 'k'
        18: SequenceLikelihood.UNLIKELY,  # 'l'
        15: SequenceLikelihood.UNLIKELY,  # 'm'
        5: SequenceLikelihood.UNLIKELY,  # 'n'
        4: SequenceLikelihood.UNLIKELY,  # 'o'
        16: SequenceLikelihood.UNLIKELY,  # 'p'
        63: SequenceLikelihood.UNLIKELY,  # 'q'
        7: SequenceLikelihood.UNLIKELY,  # 'r'
        9: SequenceLikelihood.UNLIKELY,  # 's'
        10: SequenceLikelihood.UNLIKELY,  # 't'
        17: SequenceLikelihood.UNLIKELY,  # 'u'
        55: SequenceLikelihood.UNLIKELY,  # 'v'
        8: SequenceLikelihood.UNLIKELY,  # 'w'
        57: SequenceLikelihood.UNLIKELY,  # 'x'
        12: SequenceLikelihood.UNLIKELY,  # 'y'
        6: SequenceLikelihood.UNLIKELY,  # 'z'
        66: SequenceLikelihood.NEGATIVE,  # 'Ó'
        27: SequenceLikelihood.NEGATIVE,  # 'ó'
        67: SequenceLikelihood.NEGATIVE,  # 'Ą'
        25: SequenceLikelihood.NEGATIVE,  # 'ą'
        68: SequenceLikelihood.NEGATIVE,  # 'Ć'
        29: SequenceLikelihood.NEGATIVE,  # 'ć'
        65: SequenceLikelihood.NEGATIVE,  # 'Ę'
        24: SequenceLikelihood.NEGATIVE,  # 'ę'
        61: SequenceLikelihood.NEGATIVE,  # 'Ł'
        21: SequenceLikelihood.NEGATIVE,  # 'ł'
        70: SequenceLikelihood.NEGATIVE,  # 'Ń'
        42: SequenceLikelihood.NEGATIVE,  # 'ń'
        59: SequenceLikelihood.NEGATIVE,  # 'Ś'
        28: SequenceLikelihood.UNLIKELY,  # 'ś'
        69: SequenceLikelihood.UNLIKELY,  # 'Ź'
        53: SequenceLikelihood.NEGATIVE,  # 'ź'
        62: SequenceLikelihood.NEGATIVE,  # 'Ż'
        26: SequenceLikelihood.NEGATIVE,  # 'ż'
    },
    45: {  # 'R'
        34: SequenceLikelihood.LIKELY,  # 'A'
        46: SequenceLikelihood.UNLIKELY,  # 'B'
        39: SequenceLikelihood.UNLIKELY,  # 'C'
        41: SequenceLikelihood.UNLIKELY,  # 'D'
        48: SequenceLikelihood.LIKELY,  # 'E'
        52: SequenceLikelihood.UNLIKELY,  # 'F'
        49: SequenceLikelihood.UNLIKELY,  # 'G'
        54: SequenceLikelihood.UNLIKELY,  # 'H'
        43: SequenceLikelihood.LIKELY,  # 'I'
        47: SequenceLikelihood.UNLIKELY,  # 'J'
        37: SequenceLikelihood.UNLIKELY,  # 'K'
        50: SequenceLikelihood.UNLIKELY,  # 'L'
        35: SequenceLikelihood.LIKELY,  # 'M'
        36: SequenceLikelihood.UNLIKELY,  # 'N'
        40: SequenceLikelihood.LIKELY,  # 'O'
        30: SequenceLikelihood.LIKELY,  # 'P'
        64: SequenceLikelihood.UNLIKELY,  # 'Q'
        45: SequenceLikelihood.UNLIKELY,  # 'R'
        33: SequenceLikelihood.LIKELY,  # 'S'
        38: SequenceLikelihood.LIKELY,  # 'T'
        51: SequenceLikelihood.LIKELY,  # 'U'
        56: SequenceLikelihood.UNLIKELY,  # 'V'
        32: SequenceLikelihood.UNLIKELY,  # 'W'
        60: SequenceLikelihood.UNLIKELY,  # 'X'
        58: SequenceLikelihood.LIKELY,  # 'Y'
        44: SequenceLikelihood.LIKELY,  # 'Z'
        1: SequenceLikelihood.POSITIVE,  # 'a'
        20: SequenceLikelihood.UNLIKELY,  # 'b'
        11: SequenceLikelihood.UNLIKELY,  # 'c'
        14: SequenceLikelihood.UNLIKELY,  # 'd'
        2: SequenceLikelihood.POSITIVE,  # 'e'
        31: SequenceLikelihood.UNLIKELY,  # 'f'
        22: SequenceLikelihood.UNLIKELY,  # 'g'
        23: SequenceLikelihood.UNLIKELY,  # 'h'
        3: SequenceLikelihood.LIKELY,  # 'i'
        19: SequenceLikelihood.UNLIKELY,  # 'j'
        13: SequenceLikelihood.UNLIKELY,  # 'k'
        18: SequenceLikelihood.UNLIKELY,  # 'l'
        15: SequenceLikelihood.UNLIKELY,  # 'm'
        5: SequenceLikelihood.UNLIKELY,  # 'n'
        4: SequenceLikelihood.POSITIVE,  # 'o'
        16: SequenceLikelihood.UNLIKELY,  # 'p'
        63: SequenceLikelihood.UNLIKELY,  # 'q'
        7: SequenceLikelihood.UNLIKELY,  # 'r'
        9: SequenceLikelihood.UNLIKELY,  # 's'
        10: SequenceLikelihood.UNLIKELY,  # 't'
        17: SequenceLikelihood.LIKELY,  # 'u'
        55: SequenceLikelihood.UNLIKELY,  # 'v'
        8: SequenceLikelihood.UNLIKELY,  # 'w'
        57: SequenceLikelihood.UNLIKELY,  # 'x'
        12: SequenceLikelihood.LIKELY,  # 'y'
        6: SequenceLikelihood.LIKELY,  # 'z'
        66: SequenceLikelihood.UNLIKELY,  # 'Ó'
        27: SequenceLikelihood.LIKELY,  # 'ó'
        67: SequenceLikelihood.UNLIKELY,  # 'Ą'
        25: SequenceLikelihood.UNLIKELY,  # 'ą'
        68: SequenceLikelihood.UNLIKELY,  # 'Ć'
        29: SequenceLikelihood.UNLIKELY,  # 'ć'
        65: SequenceLikelihood.UNLIKELY,  # 'Ę'
        24: SequenceLikelihood.UNLIKELY,  # 'ę'
        61: SequenceLikelihood.UNLIKELY,  # 'Ł'
        21: SequenceLikelihood.NEGATIVE,  # 'ł'
        70: SequenceLikelihood.UNLIKELY,  # 'Ń'
        42: SequenceLikelihood.NEGATIVE,  # 'ń'
        59: SequenceLikelihood.UNLIKELY,  # 'Ś'
        28: SequenceLikelihood.NEGATIVE,  # 'ś'
        69: SequenceLikelihood.NEGATIVE,  # 'Ź'
        53: SequenceLikelihood.NEGATIVE,  # 'ź'
        62: SequenceLikelihood.UNLIKELY,  # 'Ż'
        26: SequenceLikelihood.UNLIKELY,  # 'ż'
    },
    33: {  # 'S'
        34: SequenceLikelihood.LIKELY,  # 'A'
        46: SequenceLikelihood.LIKELY,  # 'B'
        39: SequenceLikelihood.UNLIKELY,  # 'C'
        41: SequenceLikelihood.LIKELY,  # 'D'
        48: SequenceLikelihood.LIKELY,  # 'E'
        52: SequenceLikelihood.UNLIKELY,  # 'F'
        49: SequenceLikelihood.UNLIKELY,  # 'G'
        54: SequenceLikelihood.UNLIKELY,  # 'H'
        43: SequenceLikelihood.LIKELY,  # 'I'
        47: SequenceLikelihood.UNLIKELY,  # 'J'
        37: SequenceLikelihood.LIKELY,  # 'K'
        50: SequenceLikelihood.UNLIKELY,  # 'L'
        35: SequenceLikelihood.LIKELY,  # 'M'
        36: SequenceLikelihood.UNLIKELY,  # 'N'
        40: SequenceLikelihood.LIKELY,  # 'O'
        30: SequenceLikelihood.LIKELY,  # 'P'
        64: SequenceLikelihood.UNLIKELY,  # 'Q'
        45: SequenceLikelihood.UNLIKELY,  # 'R'
        33: SequenceLikelihood.LIKELY,  # 'S'
        38: SequenceLikelihood.LIKELY,  # 'T'
        51: SequenceLikelihood.UNLIKELY,  # 'U'
        56: SequenceLikelihood.UNLIKELY,  # 'V'
        32: SequenceLikelihood.UNLIKELY,  # 'W'
        60: SequenceLikelihood.UNLIKELY,  # 'X'
        58: SequenceLikelihood.UNLIKELY,  # 'Y'
        44: SequenceLikelihood.LIKELY,  # 'Z'
        1: SequenceLikelihood.POSITIVE,  # 'a'
        20: SequenceLikelihood.UNLIKELY,  # 'b'
        11: SequenceLikelihood.LIKELY,  # 'c'
        14: SequenceLikelihood.UNLIKELY,  # 'd'
        2: SequenceLikelihood.POSITIVE,  # 'e'
        31: SequenceLikelihood.UNLIKELY,  # 'f'
        22: SequenceLikelihood.UNLIKELY,  # 'g'
        23: SequenceLikelihood.LIKELY,  # 'h'
        3: SequenceLikelihood.LIKELY,  # 'i'
        19: SequenceLikelihood.UNLIKELY,  # 'j'
        13: SequenceLikelihood.LIKELY,  # 'k'
        18: SequenceLikelihood.UNLIKELY,  # 'l'
        15: SequenceLikelihood.LIKELY,  # 'm'
        5: SequenceLikelihood.UNLIKELY,  # 'n'
        4: SequenceLikelihood.LIKELY,  # 'o'
        16: SequenceLikelihood.POSITIVE,  # 'p'
        63: SequenceLikelihood.UNLIKELY,  # 'q'
        7: SequenceLikelihood.UNLIKELY,  # 'r'
        9: SequenceLikelihood.UNLIKELY,  # 's'
        10: SequenceLikelihood.POSITIVE,  # 't'
        17: SequenceLikelihood.LIKELY,  # 'u'
        55: SequenceLikelihood.UNLIKELY,  # 'v'
        8: SequenceLikelihood.LIKELY,  # 'w'
        57: SequenceLikelihood.UNLIKELY,  # 'x'
        12: SequenceLikelihood.LIKELY,  # 'y'
        6: SequenceLikelihood.POSITIVE,  # 'z'
        66: SequenceLikelihood.UNLIKELY,  # 'Ó'
        27: SequenceLikelihood.UNLIKELY,  # 'ó'
        67: SequenceLikelihood.UNLIKELY,  # 'Ą'
        25: SequenceLikelihood.LIKELY,  # 'ą'
        68: SequenceLikelihood.UNLIKELY,  # 'Ć'
        29: SequenceLikelihood.NEGATIVE,  # 'ć'
        65: SequenceLikelihood.UNLIKELY,  # 'Ę'
        24: SequenceLikelihood.UNLIKELY,  # 'ę'
        61: SequenceLikelihood.UNLIKELY,  # 'Ł'
        21: SequenceLikelihood.LIKELY,  # 'ł'
        70: SequenceLikelihood.NEGATIVE,  # 'Ń'
        42: SequenceLikelihood.NEGATIVE,  # 'ń'
        59: SequenceLikelihood.UNLIKELY,  # 'Ś'
        28: SequenceLikelihood.NEGATIVE,  # 'ś'
        69: SequenceLikelihood.NEGATIVE,  # 'Ź'
        53: SequenceLikelihood.UNLIKELY,  # 'ź'
        62: SequenceLikelihood.UNLIKELY,  # 'Ż'
        26: SequenceLikelihood.NEGATIVE,  # 'ż'
    },
    38: {  # 'T'
        34: SequenceLikelihood.LIKELY,  # 'A'
        46: SequenceLikelihood.UNLIKELY,  # 'B'
        39: SequenceLikelihood.UNLIKELY,  # 'C'
        41: SequenceLikelihood.UNLIKELY,  # 'D'
        48: SequenceLikelihood.LIKELY,  # 'E'
        52: SequenceLikelihood.UNLIKELY,  # 'F'
        49: SequenceLikelihood.UNLIKELY,  # 'G'
        54: SequenceLikelihood.UNLIKELY,  # 'H'
        43: SequenceLikelihood.LIKELY,  # 'I'
        47: SequenceLikelihood.UNLIKELY,  # 'J'
        37: SequenceLikelihood.UNLIKELY,  # 'K'
        50: SequenceLikelihood.UNLIKELY,  # 'L'
        35: SequenceLikelihood.UNLIKELY,  # 'M'
        36: SequenceLikelihood.UNLIKELY,  # 'N'
        40: SequenceLikelihood.LIKELY,  # 'O'
        30: SequenceLikelihood.UNLIKELY,  # 'P'
        64: SequenceLikelihood.UNLIKELY,  # 'Q'
        45: SequenceLikelihood.LIKELY,  # 'R'
        33: SequenceLikelihood.UNLIKELY,  # 'S'
        38: SequenceLikelihood.UNLIKELY,  # 'T'
        51: SequenceLikelihood.LIKELY,  # 'U'
        56: SequenceLikelihood.LIKELY,  # 'V'
        32: SequenceLikelihood.UNLIKELY,  # 'W'
        60: SequenceLikelihood.UNLIKELY,  # 'X'
        58: SequenceLikelihood.LIKELY,  # 'Y'
        44: SequenceLikelihood.UNLIKELY,  # 'Z'
        1: SequenceLikelihood.POSITIVE,  # 'a'
        20: SequenceLikelihood.UNLIKELY,  # 'b'
        11: SequenceLikelihood.UNLIKELY,  # 'c'
        14: SequenceLikelihood.UNLIKELY,  # 'd'
        2: SequenceLikelihood.POSITIVE,  # 'e'
        31: SequenceLikelihood.UNLIKELY,  # 'f'
        22: SequenceLikelihood.UNLIKELY,  # 'g'
        23: SequenceLikelihood.LIKELY,  # 'h'
        3: SequenceLikelihood.LIKELY,  # 'i'
        19: SequenceLikelihood.UNLIKELY,  # 'j'
        13: SequenceLikelihood.UNLIKELY,  # 'k'
        18: SequenceLikelihood.UNLIKELY,  # 'l'
        15: SequenceLikelihood.UNLIKELY,  # 'm'
        5: SequenceLikelihood.UNLIKELY,  # 'n'
        4: SequenceLikelihood.POSITIVE,  # 'o'
        16: SequenceLikelihood.UNLIKELY,  # 'p'
        63: SequenceLikelihood.UNLIKELY,  # 'q'
        7: SequenceLikelihood.POSITIVE,  # 'r'
        9: SequenceLikelihood.UNLIKELY,  # 's'
        10: SequenceLikelihood.UNLIKELY,  # 't'
        17: SequenceLikelihood.LIKELY,  # 'u'
        55: SequenceLikelihood.UNLIKELY,  # 'v'
        8: SequenceLikelihood.LIKELY,  # 'w'
        57: SequenceLikelihood.UNLIKELY,  # 'x'
        12: SequenceLikelihood.LIKELY,  # 'y'
        6: SequenceLikelihood.UNLIKELY,  # 'z'
        66: SequenceLikelihood.UNLIKELY,  # 'Ó'
        27: SequenceLikelihood.UNLIKELY,  # 'ó'
        67: SequenceLikelihood.UNLIKELY,  # 'Ą'
        25: SequenceLikelihood.UNLIKELY,  # 'ą'
        68: SequenceLikelihood.NEGATIVE,  # 'Ć'
        29: SequenceLikelihood.NEGATIVE,  # 'ć'
        65: SequenceLikelihood.UNLIKELY,  # 'Ę'
        24: SequenceLikelihood.UNLIKELY,  # 'ę'
        61: SequenceLikelihood.UNLIKELY,  # 'Ł'
        21: SequenceLikelihood.UNLIKELY,  # 'ł'
        70: SequenceLikelihood.NEGATIVE,  # 'Ń'
        42: SequenceLikelihood.NEGATIVE,  # 'ń'
        59: SequenceLikelihood.UNLIKELY,  # 'Ś'
        28: SequenceLikelihood.NEGATIVE,  # 'ś'
        69: SequenceLikelihood.NEGATIVE,  # 'Ź'
        53: SequenceLikelihood.NEGATIVE,  # 'ź'
        62: SequenceLikelihood.UNLIKELY,  # 'Ż'
        26: SequenceLikelihood.UNLIKELY,  # 'ż'
    },
    51: {  # 'U'
        34: SequenceLikelihood.UNLIKELY,  # 'A'
        46: SequenceLikelihood.UNLIKELY,  # 'B'
        39: SequenceLikelihood.UNLIKELY,  # 'C'
        41: SequenceLikelihood.UNLIKELY,  # 'D'
        48: SequenceLikelihood.LIKELY,  # 'E'
        52: SequenceLikelihood.UNLIKELY,  # 'F'
        49: SequenceLikelihood.UNLIKELY,  # 'G'
        54: SequenceLikelihood.UNLIKELY,  # 'H'
        43: SequenceLikelihood.UNLIKELY,  # 'I'
        47: SequenceLikelihood.UNLIKELY,  # 'J'
        37: SequenceLikelihood.UNLIKELY,  # 'K'
        50: SequenceLikelihood.UNLIKELY,  # 'L'
        35: SequenceLikelihood.LIKELY,  # 'M'
        36: SequenceLikelihood.UNLIKELY,  # 'N'
        40: SequenceLikelihood.UNLIKELY,  # 'O'
        30: SequenceLikelihood.UNLIKELY,  # 'P'
        64: SequenceLikelihood.UNLIKELY,  # 'Q'
        45: SequenceLikelihood.LIKELY,  # 'R'
        33: SequenceLikelihood.LIKELY,  # 'S'
        38: SequenceLikelihood.LIKELY,  # 'T'
        51: SequenceLikelihood.UNLIKELY,  # 'U'
        56: SequenceLikelihood.UNLIKELY,  # 'V'
        32: SequenceLikelihood.UNLIKELY,  # 'W'
        60: SequenceLikelihood.UNLIKELY,  # 'X'
        58: SequenceLikelihood.UNLIKELY,  # 'Y'
        44: SequenceLikelihood.UNLIKELY,  # 'Z'
        1: SequenceLikelihood.UNLIKELY,  # 'a'
        20: SequenceLikelihood.UNLIKELY,  # 'b'
        11: SequenceLikelihood.LIKELY,  # 'c'
        14: SequenceLikelihood.LIKELY,  # 'd'
        2: SequenceLikelihood.UNLIKELY,  # 'e'
        31: SequenceLikelihood.UNLIKELY,  # 'f'
        22: SequenceLikelihood.UNLIKELY,  # 'g'
        23: SequenceLikelihood.UNLIKELY,  # 'h'
        3: SequenceLikelihood.UNLIKELY,  # 'i'
        19: SequenceLikelihood.UNLIKELY,  # 'j'
        13: SequenceLikelihood.LIKELY,  # 'k'
        18: SequenceLikelihood.UNLIKELY,  # 'l'
        15: SequenceLikelihood.LIKELY,  # 'm'
        5: SequenceLikelihood.LIKELY,  # 'n'
        4: SequenceLikelihood.UNLIKELY,  # 'o'
        16: SequenceLikelihood.UNLIKELY,  # 'p'
        63: SequenceLikelihood.UNLIKELY,  # 'q'
        7: SequenceLikelihood.LIKELY,  # 'r'
        9: SequenceLikelihood.LIKELY,  # 's'
        10: SequenceLikelihood.UNLIKELY,  # 't'
        17: SequenceLikelihood.UNLIKELY,  # 'u'
        55: SequenceLikelihood.UNLIKELY,  # 'v'
        8: SequenceLikelihood.LIKELY,  # 'w'
        57: SequenceLikelihood.UNLIKELY,  # 'x'
        12: SequenceLikelihood.UNLIKELY,  # 'y'
        6: SequenceLikelihood.UNLIKELY,  # 'z'
        66: SequenceLikelihood.NEGATIVE,  # 'Ó'
        27: SequenceLikelihood.NEGATIVE,  # 'ó'
        67: SequenceLikelihood.NEGATIVE,  # 'Ą'
        25: SequenceLikelihood.NEGATIVE,  # 'ą'
        68: SequenceLikelihood.UNLIKELY,  # 'Ć'
        29: SequenceLikelihood.NEGATIVE,  # 'ć'
        65: SequenceLikelihood.UNLIKELY,  # 'Ę'
        24: SequenceLikelihood.NEGATIVE,  # 'ę'
        61: SequenceLikelihood.UNLIKELY,  # 'Ł'
        21: SequenceLikelihood.UNLIKELY,  # 'ł'
        70: SequenceLikelihood.UNLIKELY,  # 'Ń'
        42: SequenceLikelihood.NEGATIVE,  # 'ń'
        59: SequenceLikelihood.UNLIKELY,  # 'Ś'
        28: SequenceLikelihood.UNLIKELY,  # 'ś'
        69: SequenceLikelihood.UNLIKELY,  # 'Ź'
        53: SequenceLikelihood.UNLIKELY,  # 'ź'
        62: SequenceLikelihood.UNLIKELY,  # 'Ż'
        26: SequenceLikelihood.LIKELY,  # 'ż'
    },
    56: {  # 'V'
        34: SequenceLikelihood.LIKELY,  # 'A'
        46: SequenceLikelihood.UNLIKELY,  # 'B'
        39: SequenceLikelihood.UNLIKELY,  # 'C'
        41: SequenceLikelihood.UNLIKELY,  # 'D'
        48: SequenceLikelihood.UNLIKELY,  # 'E'
        52: SequenceLikelihood.UNLIKELY,  # 'F'
        49: SequenceLikelihood.UNLIKELY,  # 'G'
        54: SequenceLikelihood.UNLIKELY,  # 'H'
        43: SequenceLikelihood.LIKELY,  # 'I'
        47: SequenceLikelihood.UNLIKELY,  # 'J'
        37: SequenceLikelihood.UNLIKELY,  # 'K'
        50: SequenceLikelihood.UNLIKELY,  # 'L'
        35: SequenceLikelihood.UNLIKELY,  # 'M'
        36: SequenceLikelihood.UNLIKELY,  # 'N'
        40: SequenceLikelihood.UNLIKELY,  # 'O'
        30: SequenceLikelihood.UNLIKELY,  # 'P'
        64: SequenceLikelihood.UNLIKELY,  # 'Q'
        45: SequenceLikelihood.UNLIKELY,  # 'R'
        33: SequenceLikelihood.UNLIKELY,  # 'S'
        38: SequenceLikelihood.UNLIKELY,  # 'T'
        51: SequenceLikelihood.UNLIKELY,  # 'U'
        56: SequenceLikelihood.UNLIKELY,  # 'V'
        32: SequenceLikelihood.UNLIKELY,  # 'W'
        60: SequenceLikelihood.UNLIKELY,  # 'X'
        58: SequenceLikelihood.UNLIKELY,  # 'Y'
        44: SequenceLikelihood.UNLIKELY,  # 'Z'
        1: SequenceLikelihood.LIKELY,  # 'a'
        20: SequenceLikelihood.UNLIKELY,  # 'b'
        11: SequenceLikelihood.UNLIKELY,  # 'c'
        14: SequenceLikelihood.UNLIKELY,  # 'd'
        2: SequenceLikelihood.LIKELY,  # 'e'
        31: SequenceLikelihood.UNLIKELY,  # 'f'
        22: SequenceLikelihood.UNLIKELY,  # 'g'
        23: SequenceLikelihood.UNLIKELY,  # 'h'
        3: SequenceLikelihood.LIKELY,  # 'i'
        19: SequenceLikelihood.UNLIKELY,  # 'j'
        13: SequenceLikelihood.UNLIKELY,  # 'k'
        18: SequenceLikelihood.UNLIKELY,  # 'l'
        15: SequenceLikelihood.UNLIKELY,  # 'm'
        5: SequenceLikelihood.UNLIKELY,  # 'n'
        4: SequenceLikelihood.UNLIKELY,  # 'o'
        16: SequenceLikelihood.UNLIKELY,  # 'p'
        63: SequenceLikelihood.UNLIKELY,  # 'q'
        7: SequenceLikelihood.UNLIKELY,  # 'r'
        9: SequenceLikelihood.UNLIKELY,  # 's'
        10: SequenceLikelihood.UNLIKELY,  # 't'
        17: SequenceLikelihood.UNLIKELY,  # 'u'
        55: SequenceLikelihood.UNLIKELY,  # 'v'
        8: SequenceLikelihood.UNLIKELY,  # 'w'
        57: SequenceLikelihood.UNLIKELY,  # 'x'
        12: SequenceLikelihood.UNLIKELY,  # 'y'
        6: SequenceLikelihood.UNLIKELY,  # 'z'
        66: SequenceLikelihood.NEGATIVE,  # 'Ó'
        27: SequenceLikelihood.UNLIKELY,  # 'ó'
        67: SequenceLikelihood.UNLIKELY,  # 'Ą'
        25: SequenceLikelihood.NEGATIVE,  # 'ą'
        68: SequenceLikelihood.NEGATIVE,  # 'Ć'
        29: SequenceLikelihood.NEGATIVE,  # 'ć'
        65: SequenceLikelihood.UNLIKELY,  # 'Ę'
        24: SequenceLikelihood.UNLIKELY,  # 'ę'
        61: SequenceLikelihood.UNLIKELY,  # 'Ł'
        21: SequenceLikelihood.NEGATIVE,  # 'ł'
        70: SequenceLikelihood.NEGATIVE,  # 'Ń'
        42: SequenceLikelihood.NEGATIVE,  # 'ń'
        59: SequenceLikelihood.UNLIKELY,  # 'Ś'
        28: SequenceLikelihood.NEGATIVE,  # 'ś'
        69: SequenceLikelihood.NEGATIVE,  # 'Ź'
        53: SequenceLikelihood.NEGATIVE,  # 'ź'
        62: SequenceLikelihood.NEGATIVE,  # 'Ż'
        26: SequenceLikelihood.NEGATIVE,  # 'ż'
    },
    32: {  # 'W'
        34: SequenceLikelihood.LIKELY,  # 'A'
        46: SequenceLikelihood.UNLIKELY,  # 'B'
        39: SequenceLikelihood.UNLIKELY,  # 'C'
        41: SequenceLikelihood.UNLIKELY,  # 'D'
        48: SequenceLikelihood.LIKELY,  # 'E'
        52: SequenceLikelihood.UNLIKELY,  # 'F'
        49: SequenceLikelihood.UNLIKELY,  # 'G'
        54: SequenceLikelihood.UNLIKELY,  # 'H'
        43: SequenceLikelihood.LIKELY,  # 'I'
        47: SequenceLikelihood.UNLIKELY,  # 'J'
        37: SequenceLikelihood.UNLIKELY,  # 'K'
        50: SequenceLikelihood.UNLIKELY,  # 'L'
        35: SequenceLikelihood.UNLIKELY,  # 'M'
        36: SequenceLikelihood.UNLIKELY,  # 'N'
        40: SequenceLikelihood.LIKELY,  # 'O'
        30: SequenceLikelihood.UNLIKELY,  # 'P'
        64: SequenceLikelihood.UNLIKELY,  # 'Q'
        45: SequenceLikelihood.UNLIKELY,  # 'R'
        33: SequenceLikelihood.LIKELY,  # 'S'
        38: SequenceLikelihood.UNLIKELY,  # 'T'
        51: SequenceLikelihood.UNLIKELY,  # 'U'
        56: SequenceLikelihood.UNLIKELY,  # 'V'
        32: SequenceLikelihood.UNLIKELY,  # 'W'
        60: SequenceLikelihood.UNLIKELY,  # 'X'
        58: SequenceLikelihood.LIKELY,  # 'Y'
        44: SequenceLikelihood.UNLIKELY,  # 'Z'
        1: SequenceLikelihood.POSITIVE,  # 'a'
        20: SequenceLikelihood.UNLIKELY,  # 'b'
        11: SequenceLikelihood.LIKELY,  # 'c'
        14: SequenceLikelihood.UNLIKELY,  # 'd'
        2: SequenceLikelihood.LIKELY,  # 'e'
        31: SequenceLikelihood.UNLIKELY,  # 'f'
        22: SequenceLikelihood.UNLIKELY,  # 'g'
        23: SequenceLikelihood.UNLIKELY,  # 'h'
        3: SequenceLikelihood.POSITIVE,  # 'i'
        19: SequenceLikelihood.UNLIKELY,  # 'j'
        13: SequenceLikelihood.UNLIKELY,  # 'k'
        18: SequenceLikelihood.UNLIKELY,  # 'l'
        15: SequenceLikelihood.UNLIKELY,  # 'm'
        5: SequenceLikelihood.UNLIKELY,  # 'n'
        4: SequenceLikelihood.POSITIVE,  # 'o'
        16: SequenceLikelihood.LIKELY,  # 'p'
        63: SequenceLikelihood.UNLIKELY,  # 'q'
        7: SequenceLikelihood.LIKELY,  # 'r'
        9: SequenceLikelihood.POSITIVE,  # 's'
        10: SequenceLikelihood.LIKELY,  # 't'
        17: SequenceLikelihood.UNLIKELY,  # 'u'
        55: SequenceLikelihood.UNLIKELY,  # 'v'
        8: SequenceLikelihood.UNLIKELY,  # 'w'
        57: SequenceLikelihood.UNLIKELY,  # 'x'
        12: SequenceLikelihood.POSITIVE,  # 'y'
        6: SequenceLikelihood.LIKELY,  # 'z'
        66: SequenceLikelihood.UNLIKELY,  # 'Ó'
        27: SequenceLikelihood.UNLIKELY,  # 'ó'
        67: SequenceLikelihood.UNLIKELY,  # 'Ą'
        25: SequenceLikelihood.UNLIKELY,  # 'ą'
        68: SequenceLikelihood.NEGATIVE,  # 'Ć'
        29: SequenceLikelihood.NEGATIVE,  # 'ć'
        65: SequenceLikelihood.UNLIKELY,  # 'Ę'
        24: SequenceLikelihood.UNLIKELY,  # 'ę'
        61: SequenceLikelihood.UNLIKELY,  # 'Ł'
        21: SequenceLikelihood.LIKELY,  # 'ł'
        70: SequenceLikelihood.NEGATIVE,  # 'Ń'
        42: SequenceLikelihood.NEGATIVE,  # 'ń'
        59: SequenceLikelihood.UNLIKELY,  # 'Ś'
        28: SequenceLikelihood.UNLIKELY,  # 'ś'
        69: SequenceLikelihood.NEGATIVE,  # 'Ź'
        53: SequenceLikelihood.UNLIKELY,  # 'ź'
        62: SequenceLikelihood.UNLIKELY,  # 'Ż'
        26: SequenceLikelihood.UNLIKELY,  # 'ż'
    },
    60: {  # 'X'
        34: SequenceLikelihood.UNLIKELY,  # 'A'
        46: SequenceLikelihood.UNLIKELY,  # 'B'
        39: SequenceLikelihood.UNLIKELY,  # 'C'
        41: SequenceLikelihood.UNLIKELY,  # 'D'
        48: SequenceLikelihood.UNLIKELY,  # 'E'
        52: SequenceLikelihood.UNLIKELY,  # 'F'
        49: SequenceLikelihood.UNLIKELY,  # 'G'
        54: SequenceLikelihood.UNLIKELY,  # 'H'
        43: SequenceLikelihood.LIKELY,  # 'I'
        47: SequenceLikelihood.UNLIKELY,  # 'J'
        37: SequenceLikelihood.UNLIKELY,  # 'K'
        50: SequenceLikelihood.UNLIKELY,  # 'L'
        35: SequenceLikelihood.UNLIKELY,  # 'M'
        36: SequenceLikelihood.UNLIKELY,  # 'N'
        40: SequenceLikelihood.UNLIKELY,  # 'O'
        30: SequenceLikelihood.UNLIKELY,  # 'P'
        64: SequenceLikelihood.UNLIKELY,  # 'Q'
        45: SequenceLikelihood.UNLIKELY,  # 'R'
        33: SequenceLikelihood.UNLIKELY,  # 'S'
        38: SequenceLikelihood.UNLIKELY,  # 'T'
        51: SequenceLikelihood.UNLIKELY,  # 'U'
        56: SequenceLikelihood.UNLIKELY,  # 'V'
        32: SequenceLikelihood.UNLIKELY,  # 'W'
        60: SequenceLikelihood.LIKELY,  # 'X'
        58: SequenceLikelihood.UNLIKELY,  # 'Y'
        44: SequenceLikelihood.UNLIKELY,  # 'Z'
        1: SequenceLikelihood.UNLIKELY,  # 'a'
        20: SequenceLikelihood.UNLIKELY,  # 'b'
        11: SequenceLikelihood.UNLIKELY,  # 'c'
        14: SequenceLikelihood.UNLIKELY,  # 'd'
        2: SequenceLikelihood.UNLIKELY,  # 'e'
        31: SequenceLikelihood.UNLIKELY,  # 'f'
        22: SequenceLikelihood.UNLIKELY,  # 'g'
        23: SequenceLikelihood.UNLIKELY,  # 'h'
        3: SequenceLikelihood.UNLIKELY,  # 'i'
        19: SequenceLikelihood.UNLIKELY,  # 'j'
        13: SequenceLikelihood.UNLIKELY,  # 'k'
        18: SequenceLikelihood.UNLIKELY,  # 'l'
        15: SequenceLikelihood.UNLIKELY,  # 'm'
        5: SequenceLikelihood.UNLIKELY,  # 'n'
        4: SequenceLikelihood.UNLIKELY,  # 'o'
        16: SequenceLikelihood.UNLIKELY,  # 'p'
        63: SequenceLikelihood.UNLIKELY,  # 'q'
        7: SequenceLikelihood.UNLIKELY,  # 'r'
        9: SequenceLikelihood.UNLIKELY,  # 's'
        10: SequenceLikelihood.UNLIKELY,  # 't'
        17: SequenceLikelihood.UNLIKELY,  # 'u'
        55: SequenceLikelihood.UNLIKELY,  # 'v'
        8: SequenceLikelihood.UNLIKELY,  # 'w'
        57: SequenceLikelihood.UNLIKELY,  # 'x'
        12: SequenceLikelihood.UNLIKELY,  # 'y'
        6: SequenceLikelihood.UNLIKELY,  # 'z'
        66: SequenceLikelihood.UNLIKELY,  # 'Ó'
        27: SequenceLikelihood.UNLIKELY,  # 'ó'
        67: SequenceLikelihood.NEGATIVE,  # 'Ą'
        25: SequenceLikelihood.NEGATIVE,  # 'ą'
        68: SequenceLikelihood.NEGATIVE,  # 'Ć'
        29: SequenceLikelihood.NEGATIVE,  # 'ć'
        65: SequenceLikelihood.NEGATIVE,  # 'Ę'
        24: SequenceLikelihood.NEGATIVE,  # 'ę'
        61: SequenceLikelihood.NEGATIVE,  # 'Ł'
        21: SequenceLikelihood.NEGATIVE,  # 'ł'
        70: SequenceLikelihood.NEGATIVE,  # 'Ń'
        42: SequenceLikelihood.NEGATIVE,  # 'ń'
        59: SequenceLikelihood.NEGATIVE,  # 'Ś'
        28: SequenceLikelihood.NEGATIVE,  # 'ś'
        69: SequenceLikelihood.NEGATIVE,  # 'Ź'
        53: SequenceLikelihood.NEGATIVE,  # 'ź'
        62: SequenceLikelihood.NEGATIVE,  # 'Ż'
        26: SequenceLikelihood.UNLIKELY,  # 'ż'
    },
    58: {  # 'Y'
        34: SequenceLikelihood.UNLIKELY,  # 'A'
        46: SequenceLikelihood.UNLIKELY,  # 'B'
        39: SequenceLikelihood.LIKELY,  # 'C'
        41: SequenceLikelihood.UNLIKELY,  # 'D'
        48: SequenceLikelihood.UNLIKELY,  # 'E'
        52: SequenceLikelihood.UNLIKELY,  # 'F'
        49: SequenceLikelihood.UNLIKELY,  # 'G'
        54: SequenceLikelihood.UNLIKELY,  # 'H'
        43: SequenceLikelihood.UNLIKELY,  # 'I'
        47: SequenceLikelihood.UNLIKELY,  # 'J'
        37: SequenceLikelihood.UNLIKELY,  # 'K'
        50: SequenceLikelihood.UNLIKELY,  # 'L'
        35: SequenceLikelihood.UNLIKELY,  # 'M'
        36: SequenceLikelihood.UNLIKELY,  # 'N'
        40: SequenceLikelihood.UNLIKELY,  # 'O'
        30: SequenceLikelihood.UNLIKELY,  # 'P'
        64: SequenceLikelihood.UNLIKELY,  # 'Q'
        45: SequenceLikelihood.UNLIKELY,  # 'R'
        33: SequenceLikelihood.UNLIKELY,  # 'S'
        38: SequenceLikelihood.UNLIKELY,  # 'T'
        51: SequenceLikelihood.UNLIKELY,  # 'U'
        56: SequenceLikelihood.UNLIKELY,  # 'V'
        32: SequenceLikelihood.UNLIKELY,  # 'W'
        60: SequenceLikelihood.UNLIKELY,  # 'X'
        58: SequenceLikelihood.UNLIKELY,  # 'Y'
        44: SequenceLikelihood.UNLIKELY,  # 'Z'
        1: SequenceLikelihood.UNLIKELY,  # 'a'
        20: SequenceLikelihood.UNLIKELY,  # 'b'
        11: SequenceLikelihood.UNLIKELY,  # 'c'
        14: SequenceLikelihood.UNLIKELY,  # 'd'
        2: SequenceLikelihood.UNLIKELY,  # 'e'
        31: SequenceLikelihood.UNLIKELY,  # 'f'
        22: SequenceLikelihood.UNLIKELY,  # 'g'
        23: SequenceLikelihood.UNLIKELY,  # 'h'
        3: SequenceLikelihood.UNLIKELY,  # 'i'
        19: SequenceLikelihood.UNLIKELY,  # 'j'
        13: SequenceLikelihood.UNLIKELY,  # 'k'
        18: SequenceLikelihood.UNLIKELY,  # 'l'
        15: SequenceLikelihood.UNLIKELY,  # 'm'
        5: SequenceLikelihood.UNLIKELY,  # 'n'
        4: SequenceLikelihood.LIKELY,  # 'o'
        16: SequenceLikelihood.UNLIKELY,  # 'p'
        63: SequenceLikelihood.UNLIKELY,  # 'q'
        7: SequenceLikelihood.UNLIKELY,  # 'r'
        9: SequenceLikelihood.UNLIKELY,  # 's'
        10: SequenceLikelihood.UNLIKELY,  # 't'
        17: SequenceLikelihood.UNLIKELY,  # 'u'
        55: SequenceLikelihood.UNLIKELY,  # 'v'
        8: SequenceLikelihood.UNLIKELY,  # 'w'
        57: SequenceLikelihood.UNLIKELY,  # 'x'
        12: SequenceLikelihood.UNLIKELY,  # 'y'
        6: SequenceLikelihood.UNLIKELY,  # 'z'
        66: SequenceLikelihood.NEGATIVE,  # 'Ó'
        27: SequenceLikelihood.NEGATIVE,  # 'ó'
        67: SequenceLikelihood.UNLIKELY,  # 'Ą'
        25: SequenceLikelihood.NEGATIVE,  # 'ą'
        68: SequenceLikelihood.UNLIKELY,  # 'Ć'
        29: SequenceLikelihood.UNLIKELY,  # 'ć'
        65: SequenceLikelihood.NEGATIVE,  # 'Ę'
        24: SequenceLikelihood.NEGATIVE,  # 'ę'
        61: SequenceLikelihood.UNLIKELY,  # 'Ł'
        21: SequenceLikelihood.UNLIKELY,  # 'ł'
        70: SequenceLikelihood.UNLIKELY,  # 'Ń'
        42: SequenceLikelihood.NEGATIVE,  # 'ń'
        59: SequenceLikelihood.UNLIKELY,  # 'Ś'
        28: SequenceLikelihood.UNLIKELY,  # 'ś'
        69: SequenceLikelihood.UNLIKELY,  # 'Ź'
        53: SequenceLikelihood.UNLIKELY,  # 'ź'
        62: SequenceLikelihood.UNLIKELY,  # 'Ż'
        26: SequenceLikelihood.UNLIKELY,  # 'ż'
    },
    44: {  # 'Z'
        34: SequenceLikelihood.LIKELY,  # 'A'
        46: SequenceLikelihood.UNLIKELY,  # 'B'
        39: SequenceLikelihood.UNLIKELY,  # 'C'
        41: SequenceLikelihood.UNLIKELY,  # 'D'
        48: SequenceLikelihood.LIKELY,  # 'E'
        52: SequenceLikelihood.UNLIKELY,  # 'F'
        49: SequenceLikelihood.UNLIKELY,  # 'G'
        54: SequenceLikelihood.UNLIKELY,  # 'H'
        43: SequenceLikelihood.LIKELY,  # 'I'
        47: SequenceLikelihood.UNLIKELY,  # 'J'
        37: SequenceLikelihood.UNLIKELY,  # 'K'
        50: SequenceLikelihood.UNLIKELY,  # 'L'
        35: SequenceLikelihood.UNLIKELY,  # 'M'
        36: SequenceLikelihood.LIKELY,  # 'N'
        40: SequenceLikelihood.LIKELY,  # 'O'
        30: SequenceLikelihood.UNLIKELY,  # 'P'
        64: SequenceLikelihood.UNLIKELY,  # 'Q'
        45: SequenceLikelihood.UNLIKELY,  # 'R'
        33: SequenceLikelihood.UNLIKELY,  # 'S'
        38: SequenceLikelihood.UNLIKELY,  # 'T'
        51: SequenceLikelihood.UNLIKELY,  # 'U'
        56: SequenceLikelihood.UNLIKELY,  # 'V'
        32: SequenceLikelihood.UNLIKELY,  # 'W'
        60: SequenceLikelihood.UNLIKELY,  # 'X'
        58: SequenceLikelihood.LIKELY,  # 'Y'
        44: SequenceLikelihood.UNLIKELY,  # 'Z'
        1: SequenceLikelihood.POSITIVE,  # 'a'
        20: SequenceLikelihood.LIKELY,  # 'b'
        11: SequenceLikelihood.UNLIKELY,  # 'c'
        14: SequenceLikelihood.LIKELY,  # 'd'
        2: SequenceLikelihood.LIKELY,  # 'e'
        31: SequenceLikelihood.UNLIKELY,  # 'f'
        22: SequenceLikelihood.LIKELY,  # 'g'
        23: SequenceLikelihood.UNLIKELY,  # 'h'
        3: SequenceLikelihood.LIKELY,  # 'i'
        19: SequenceLikelihood.LIKELY,  # 'j'
        13: SequenceLikelihood.UNLIKELY,  # 'k'
        18: SequenceLikelihood.UNLIKELY,  # 'l'
        15: SequenceLikelihood.LIKELY,  # 'm'
        5: SequenceLikelihood.LIKELY,  # 'n'
        4: SequenceLikelihood.LIKELY,  # 'o'
        16: SequenceLikelihood.UNLIKELY,  # 'p'
        63: SequenceLikelihood.UNLIKELY,  # 'q'
        7: SequenceLikelihood.LIKELY,  # 'r'
        9: SequenceLikelihood.UNLIKELY,  # 's'
        10: SequenceLikelihood.UNLIKELY,  # 't'
        17: SequenceLikelihood.UNLIKELY,  # 'u'
        55: SequenceLikelihood.UNLIKELY,  # 'v'
        8: SequenceLikelihood.LIKELY,  # 'w'
        57: SequenceLikelihood.UNLIKELY,  # 'x'
        12: SequenceLikelihood.UNLIKELY,  # 'y'
        6: SequenceLikelihood.UNLIKELY,  # 'z'
        66: SequenceLikelihood.UNLIKELY,  # 'Ó'
        27: SequenceLikelihood.UNLIKELY,  # 'ó'
        67: SequenceLikelihood.UNLIKELY,  # 'Ą'
        25: SequenceLikelihood.UNLIKELY,  # 'ą'
        68: SequenceLikelihood.NEGATIVE,  # 'Ć'
        29: SequenceLikelihood.NEGATIVE,  # 'ć'
        65: SequenceLikelihood.UNLIKELY,  # 'Ę'
        24: SequenceLikelihood.UNLIKELY,  # 'ę'
        61: SequenceLikelihood.UNLIKELY,  # 'Ł'
        21: SequenceLikelihood.LIKELY,  # 'ł'
        70: SequenceLikelihood.UNLIKELY,  # 'Ń'
        42: SequenceLikelihood.NEGATIVE,  # 'ń'
        59: SequenceLikelihood.UNLIKELY,  # 'Ś'
        28: SequenceLikelihood.NEGATIVE,  # 'ś'
        69: SequenceLikelihood.NEGATIVE,  # 'Ź'
        53: SequenceLikelihood.NEGATIVE,  # 'ź'
        62: SequenceLikelihood.UNLIKELY,  # 'Ż'
        26: SequenceLikelihood.UNLIKELY,  # 'ż'
    },
    1: {  # 'a'
        34: SequenceLikelihood.UNLIKELY,  # 'A'
        46: SequenceLikelihood.UNLIKELY,  # 'B'
        39: SequenceLikelihood.UNLIKELY,  # 'C'
        41: SequenceLikelihood.UNLIKELY,  # 'D'
        48: SequenceLikelihood.UNLIKELY,  # 'E'
        52: SequenceLikelihood.UNLIKELY,  # 'F'
        49: SequenceLikelihood.UNLIKELY,  # 'G'
        54: SequenceLikelihood.UNLIKELY,  # 'H'
        43: SequenceLikelihood.UNLIKELY,  # 'I'
        47: SequenceLikelihood.UNLIKELY,  # 'J'
        37: SequenceLikelihood.UNLIKELY,  # 'K'
        50: SequenceLikelihood.UNLIKELY,  # 'L'
        35: SequenceLikelihood.UNLIKELY,  # 'M'
        36: SequenceLikelihood.UNLIKELY,  # 'N'
        40: SequenceLikelihood.UNLIKELY,  # 'O'
        30: SequenceLikelihood.UNLIKELY,  # 'P'
        64: SequenceLikelihood.UNLIKELY,  # 'Q'
        45: SequenceLikelihood.UNLIKELY,  # 'R'
        33: SequenceLikelihood.UNLIKELY,  # 'S'
        38: SequenceLikelihood.UNLIKELY,  # 'T'
        51: SequenceLikelihood.UNLIKELY,  # 'U'
        56: SequenceLikelihood.UNLIKELY,  # 'V'
        32: SequenceLikelihood.UNLIKELY,  # 'W'
        60: SequenceLikelihood.UNLIKELY,  # 'X'
        58: SequenceLikelihood.UNLIKELY,  # 'Y'
        44: SequenceLikelihood.UNLIKELY,  # 'Z'
        1: SequenceLikelihood.LIKELY,  # 'a'
        20: SequenceLikelihood.POSITIVE,  # 'b'
        11: SequenceLikelihood.POSITIVE,  # 'c'
        14: SequenceLikelihood.POSITIVE,  # 'd'
        2: SequenceLikelihood.LIKELY,  # 'e'
        31: SequenceLikelihood.POSITIVE,  # 'f'
        22: SequenceLikelihood.POSITIVE,  # 'g'
        23: SequenceLikelihood.LIKELY,  # 'h'
        3: SequenceLikelihood.POSITIVE,  # 'i'
        19: SequenceLikelihood.POSITIVE,  # 'j'
        13: SequenceLikelihood.POSITIVE,  # 'k'
        18: SequenceLikelihood.POSITIVE,  # 'l'
        15: SequenceLikelihood.POSITIVE,  # 'm'
        5: SequenceLikelihood.POSITIVE,  # 'n'
        4: SequenceLikelihood.LIKELY,  # 'o'
        16: SequenceLikelihood.POSITIVE,  # 'p'
        63: SequenceLikelihood.UNLIKELY,  # 'q'
        7: SequenceLikelihood.POSITIVE,  # 'r'
        9: SequenceLikelihood.POSITIVE,  # 's'
        10: SequenceLikelihood.POSITIVE,  # 't'
        17: SequenceLikelihood.POSITIVE,  # 'u'
        55: SequenceLikelihood.LIKELY,  # 'v'
        8: SequenceLikelihood.POSITIVE,  # 'w'
        57: SequenceLikelihood.LIKELY,  # 'x'
        12: SequenceLikelihood.LIKELY,  # 'y'
        6: SequenceLikelihood.POSITIVE,  # 'z'
        66: SequenceLikelihood.NEGATIVE,  # 'Ó'
        27: SequenceLikelihood.UNLIKELY,  # 'ó'
        67: SequenceLikelihood.UNLIKELY,  # 'Ą'
        25: SequenceLikelihood.UNLIKELY,  # 'ą'
        68: SequenceLikelihood.UNLIKELY,  # 'Ć'
        29: SequenceLikelihood.POSITIVE,  # 'ć'
        65: SequenceLikelihood.UNLIKELY,  # 'Ę'
        24: SequenceLikelihood.UNLIKELY,  # 'ę'
        61: SequenceLikelihood.UNLIKELY,  # 'Ł'
        21: SequenceLikelihood.POSITIVE,  # 'ł'
        70: SequenceLikelihood.UNLIKELY,  # 'Ń'
        42: SequenceLikelihood.POSITIVE,  # 'ń'
        59: SequenceLikelihood.UNLIKELY,  # 'Ś'
        28: SequenceLikelihood.POSITIVE,  # 'ś'
        69: SequenceLikelihood.UNLIKELY,  # 'Ź'
        53: SequenceLikelihood.LIKELY,  # 'ź'
        62: SequenceLikelihood.UNLIKELY,  # 'Ż'
        26: SequenceLikelihood.POSITIVE,  # 'ż'
    },
    20: {  # 'b'
        34: SequenceLikelihood.UNLIKELY,  # 'A'
        46: SequenceLikelihood.UNLIKELY,  # 'B'
        39: SequenceLikelihood.UNLIKELY,  # 'C'
        41: SequenceLikelihood.UNLIKELY,  # 'D'
        48: SequenceLikelihood.UNLIKELY,  # 'E'
        52: SequenceLikelihood.UNLIKELY,  # 'F'
        49: SequenceLikelihood.UNLIKELY,  # 'G'
        54: SequenceLikelihood.UNLIKELY,  # 'H'
        43: SequenceLikelihood.UNLIKELY,  # 'I'
        47: SequenceLikelihood.UNLIKELY,  # 'J'
        37: SequenceLikelihood.UNLIKELY,  # 'K'
        50: SequenceLikelihood.UNLIKELY,  # 'L'
        35: SequenceLikelihood.UNLIKELY,  # 'M'
        36: SequenceLikelihood.UNLIKELY,  # 'N'
        40: SequenceLikelihood.UNLIKELY,  # 'O'
        30: SequenceLikelihood.UNLIKELY,  # 'P'
        64: SequenceLikelihood.UNLIKELY,  # 'Q'
        45: SequenceLikelihood.UNLIKELY,  # 'R'
        33: SequenceLikelihood.UNLIKELY,  # 'S'
        38: SequenceLikelihood.UNLIKELY,  # 'T'
        51: SequenceLikelihood.UNLIKELY,  # 'U'
        56: SequenceLikelihood.UNLIKELY,  # 'V'
        32: SequenceLikelihood.UNLIKELY,  # 'W'
        60: SequenceLikelihood.UNLIKELY,  # 'X'
        58: SequenceLikelihood.UNLIKELY,  # 'Y'
        44: SequenceLikelihood.UNLIKELY,  # 'Z'
        1: SequenceLikelihood.POSITIVE,  # 'a'
        20: SequenceLikelihood.LIKELY,  # 'b'
        11: SequenceLikelihood.LIKELY,  # 'c'
        14: SequenceLikelihood.UNLIKELY,  # 'd'
        2: SequenceLikelihood.POSITIVE,  # 'e'
        31: SequenceLikelihood.UNLIKELY,  # 'f'
        22: SequenceLikelihood.UNLIKELY,  # 'g'
        23: SequenceLikelihood.UNLIKELY,  # 'h'
        3: SequenceLikelihood.POSITIVE,  # 'i'
        19: SequenceLikelihood.LIKELY,  # 'j'
        13: SequenceLikelihood.POSITIVE,  # 'k'
        18: SequenceLikelihood.POSITIVE,  # 'l'
        15: SequenceLikelihood.UNLIKELY,  # 'm'
        5: SequenceLikelihood.POSITIVE,  # 'n'
        4: SequenceLikelihood.POSITIVE,  # 'o'
        16: SequenceLikelihood.UNLIKELY,  # 'p'
        63: SequenceLikelihood.UNLIKELY,  # 'q'
        7: SequenceLikelihood.POSITIVE,  # 'r'
        9: SequenceLikelihood.POSITIVE,  # 's'
        10: SequenceLikelihood.UNLIKELY,  # 't'
        17: SequenceLikelihood.POSITIVE,  # 'u'
        55: SequenceLikelihood.UNLIKELY,  # 'v'
        8: SequenceLikelihood.LIKELY,  # 'w'
        57: SequenceLikelihood.UNLIKELY,  # 'x'
        12: SequenceLikelihood.POSITIVE,  # 'y'
        6: SequenceLikelihood.UNLIKELY,  # 'z'
        66: SequenceLikelihood.UNLIKELY,  # 'Ó'
        27: SequenceLikelihood.POSITIVE,  # 'ó'
        67: SequenceLikelihood.NEGATIVE,  # 'Ą'
        25: SequenceLikelihood.LIKELY,  # 'ą'
        68: SequenceLikelihood.NEGATIVE,  # 'Ć'
        29: SequenceLikelihood.UNLIKELY,  # 'ć'
        65: SequenceLikelihood.NEGATIVE,  # 'Ę'
        24: SequenceLikelihood.POSITIVE,  # 'ę'
        61: SequenceLikelihood.UNLIKELY,  # 'Ł'
        21: SequenceLikelihood.LIKELY,  # 'ł'
        70: SequenceLikelihood.NEGATIVE,  # 'Ń'
        42: SequenceLikelihood.NEGATIVE,  # 'ń'
        59: SequenceLikelihood.NEGATIVE,  # 'Ś'
        28: SequenceLikelihood.UNLIKELY,  # 'ś'
        69: SequenceLikelihood.NEGATIVE,  # 'Ź'
        53: SequenceLikelihood.UNLIKELY,  # 'ź'
        62: SequenceLikelihood.NEGATIVE,  # 'Ż'
        26: SequenceLikelihood.UNLIKELY,  # 'ż'
    },
    11: {  # 'c'
        34: SequenceLikelihood.UNLIKELY,  # 'A'
        46: SequenceLikelihood.UNLIKELY,  # 'B'
        39: SequenceLikelihood.UNLIKELY,  # 'C'
        41: SequenceLikelihood.UNLIKELY,  # 'D'
        48: SequenceLikelihood.UNLIKELY,  # 'E'
        52: SequenceLikelihood.UNLIKELY,  # 'F'
        49: SequenceLikelihood.UNLIKELY,  # 'G'
        54: SequenceLikelihood.UNLIKELY,  # 'H'
        43: SequenceLikelihood.UNLIKELY,  # 'I'
        47: SequenceLikelihood.UNLIKELY,  # 'J'
        37: SequenceLikelihood.UNLIKELY,  # 'K'
        50: SequenceLikelihood.UNLIKELY,  # 'L'
        35: SequenceLikelihood.UNLIKELY,  # 'M'
        36: SequenceLikelihood.UNLIKELY,  # 'N'
        40: SequenceLikelihood.UNLIKELY,  # 'O'
        30: SequenceLikelihood.UNLIKELY,  # 'P'
        64: SequenceLikelihood.UNLIKELY,  # 'Q'
        45: SequenceLikelihood.UNLIKELY,  # 'R'
        33: SequenceLikelihood.UNLIKELY,  # 'S'
        38: SequenceLikelihood.UNLIKELY,  # 'T'
        51: SequenceLikelihood.UNLIKELY,  # 'U'
        56: SequenceLikelihood.UNLIKELY,  # 'V'
        32: SequenceLikelihood.UNLIKELY,  # 'W'
        60: SequenceLikelihood.UNLIKELY,  # 'X'
        58: SequenceLikelihood.UNLIKELY,  # 'Y'
        44: SequenceLikelihood.UNLIKELY,  # 'Z'
        1: SequenceLikelihood.POSITIVE,  # 'a'
        20: SequenceLikelihood.UNLIKELY,  # 'b'
        11: SequenceLikelihood.LIKELY,  # 'c'
        14: SequenceLikelihood.UNLIKELY,  # 'd'
        2: SequenceLikelihood.POSITIVE,  # 'e'
        31: SequenceLikelihood.UNLIKELY,  # 'f'
        22: SequenceLikelihood.UNLIKELY,  # 'g'
        23: SequenceLikelihood.POSITIVE,  # 'h'
        3: SequenceLikelihood.POSITIVE,  # 'i'
        19: SequenceLikelihood.POSITIVE,  # 'j'
        13: SequenceLikelihood.POSITIVE,  # 'k'
        18: SequenceLikelihood.LIKELY,  # 'l'
        15: SequenceLikelihood.LIKELY,  # 'm'
        5: SequenceLikelihood.POSITIVE,  # 'n'
        4: SequenceLikelihood.POSITIVE,  # 'o'
        16: SequenceLikelihood.UNLIKELY,  # 'p'
        63: SequenceLikelihood.UNLIKELY,  # 'q'
        7: SequenceLikelihood.LIKELY,  # 'r'
        9: SequenceLikelihood.UNLIKELY,  # 's'
        10: SequenceLikelihood.POSITIVE,  # 't'
        17: SequenceLikelihood.POSITIVE,  # 'u'
        55: SequenceLikelihood.UNLIKELY,  # 'v'
        8: SequenceLikelihood.UNLIKELY,  # 'w'
        57: SequenceLikelihood.UNLIKELY,  # 'x'
        12: SequenceLikelihood.POSITIVE,  # 'y'
        6: SequenceLikelihood.POSITIVE,  # 'z'
        66: SequenceLikelihood.UNLIKELY,  # 'Ó'
        27: SequenceLikelihood.POSITIVE,  # 'ó'
        67: SequenceLikelihood.UNLIKELY,  # 'Ą'
        25: SequenceLikelihood.POSITIVE,  # 'ą'
        68: SequenceLikelihood.UNLIKELY,  # 'Ć'
        29: SequenceLikelihood.UNLIKELY,  # 'ć'
        65: SequenceLikelihood.UNLIKELY,  # 'Ę'
        24: SequenceLikelihood.LIKELY,  # 'ę'
        61: SequenceLikelihood.UNLIKELY,  # 'Ł'
        21: SequenceLikelihood.LIKELY,  # 'ł'
        70: SequenceLikelihood.NEGATIVE,  # 'Ń'
        42: SequenceLikelihood.NEGATIVE,  # 'ń'
        59: SequenceLikelihood.UNLIKELY,  # 'Ś'
        28: SequenceLikelihood.UNLIKELY,  # 'ś'
        69: SequenceLikelihood.NEGATIVE,  # 'Ź'
        53: SequenceLikelihood.UNLIKELY,  # 'ź'
        62: SequenceLikelihood.NEGATIVE,  # 'Ż'
        26: SequenceLikelihood.UNLIKELY,  # 'ż'
    },
    14: {  # 'd'
        34: SequenceLikelihood.UNLIKELY,  # 'A'
        46: SequenceLikelihood.UNLIKELY,  # 'B'
        39: SequenceLikelihood.UNLIKELY,  # 'C'
        41: SequenceLikelihood.UNLIKELY,  # 'D'
        48: SequenceLikelihood.UNLIKELY,  # 'E'
        52: SequenceLikelihood.UNLIKELY,  # 'F'
        49: SequenceLikelihood.UNLIKELY,  # 'G'
        54: SequenceLikelihood.UNLIKELY,  # 'H'
        43: SequenceLikelihood.UNLIKELY,  # 'I'
        47: SequenceLikelihood.UNLIKELY,  # 'J'
        37: SequenceLikelihood.UNLIKELY,  # 'K'
        50: SequenceLikelihood.UNLIKELY,  # 'L'
        35: SequenceLikelihood.UNLIKELY,  # 'M'
        36: SequenceLikelihood.UNLIKELY,  # 'N'
        40: SequenceLikelihood.UNLIKELY,  # 'O'
        30: SequenceLikelihood.UNLIKELY,  # 'P'
        64: SequenceLikelihood.UNLIKELY,  # 'Q'
        45: SequenceLikelihood.UNLIKELY,  # 'R'
        33: SequenceLikelihood.UNLIKELY,  # 'S'
        38: SequenceLikelihood.UNLIKELY,  # 'T'
        51: SequenceLikelihood.UNLIKELY,  # 'U'
        56: SequenceLikelihood.UNLIKELY,  # 'V'
        32: SequenceLikelihood.UNLIKELY,  # 'W'
        60: SequenceLikelihood.UNLIKELY,  # 'X'
        58: SequenceLikelihood.UNLIKELY,  # 'Y'
        44: SequenceLikelihood.UNLIKELY,  # 'Z'
        1: SequenceLikelihood.POSITIVE,  # 'a'
        20: SequenceLikelihood.POSITIVE,  # 'b'
        11: SequenceLikelihood.POSITIVE,  # 'c'
        14: SequenceLikelihood.POSITIVE,  # 'd'
        2: SequenceLikelihood.POSITIVE,  # 'e'
        31: SequenceLikelihood.UNLIKELY,  # 'f'
        22: SequenceLikelihood.LIKELY,  # 'g'
        23: SequenceLikelihood.UNLIKELY,  # 'h'
        3: SequenceLikelihood.POSITIVE,  # 'i'
        19: SequenceLikelihood.POSITIVE,  # 'j'
        13: SequenceLikelihood.POSITIVE,  # 'k'
        18: SequenceLikelihood.POSITIVE,  # 'l'
        15: SequenceLikelihood.POSITIVE,  # 'm'
        5: SequenceLikelihood.POSITIVE,  # 'n'
        4: SequenceLikelihood.POSITIVE,  # 'o'
        16: SequenceLikelihood.POSITIVE,  # 'p'
        63: SequenceLikelihood.UNLIKELY,  # 'q'
        7: SequenceLikelihood.POSITIVE,  # 'r'
        9: SequenceLikelihood.POSITIVE,  # 's'
        10: SequenceLikelihood.LIKELY,  # 't'
        17: SequenceLikelihood.POSITIVE,  # 'u'
        55: SequenceLikelihood.UNLIKELY,  # 'v'
        8: SequenceLikelihood.POSITIVE,  # 'w'
        57: SequenceLikelihood.UNLIKELY,  # 'x'
        12: SequenceLikelihood.POSITIVE,  # 'y'
        6: SequenceLikelihood.POSITIVE,  # 'z'
        66: SequenceLikelihood.UNLIKELY,  # 'Ó'
        27: SequenceLikelihood.POSITIVE,  # 'ó'
        67: SequenceLikelihood.UNLIKELY,  # 'Ą'
        25: SequenceLikelihood.POSITIVE,  # 'ą'
        68: SequenceLikelihood.NEGATIVE,  # 'Ć'
        29: SequenceLikelihood.UNLIKELY,  # 'ć'
        65: SequenceLikelihood.UNLIKELY,  # 'Ę'
        24: SequenceLikelihood.POSITIVE,  # 'ę'
        61: SequenceLikelihood.UNLIKELY,  # 'Ł'
        21: SequenceLikelihood.POSITIVE,  # 'ł'
        70: SequenceLikelihood.NEGATIVE,  # 'Ń'
        42: SequenceLikelihood.UNLIKELY,  # 'ń'
        59: SequenceLikelihood.UNLIKELY,  # 'Ś'
        28: SequenceLikelihood.UNLIKELY,  # 'ś'
        69: SequenceLikelihood.UNLIKELY,  # 'Ź'
        53: SequenceLikelihood.POSITIVE,  # 'ź'
        62: SequenceLikelihood.NEGATIVE,  # 'Ż'
        26: SequenceLikelihood.LIKELY,  # 'ż'
    },
    2: {  # 'e'
        34: SequenceLikelihood.UNLIKELY,  # 'A'
        46: SequenceLikelihood.UNLIKELY,  # 'B'
        39: SequenceLikelihood.UNLIKELY,  # 'C'
        41: SequenceLikelihood.UNLIKELY,  # 'D'
        48: SequenceLikelihood.UNLIKELY,  # 'E'
        52: SequenceLikelihood.UNLIKELY,  # 'F'
        49: SequenceLikelihood.UNLIKELY,  # 'G'
        54: SequenceLikelihood.UNLIKELY,  # 'H'
        43: SequenceLikelihood.UNLIKELY,  # 'I'
        47: SequenceLikelihood.UNLIKELY,  # 'J'
        37: SequenceLikelihood.UNLIKELY,  # 'K'
        50: SequenceLikelihood.UNLIKELY,  # 'L'
        35: SequenceLikelihood.UNLIKELY,  # 'M'
        36: SequenceLikelihood.UNLIKELY,  # 'N'
        40: SequenceLikelihood.UNLIKELY,  # 'O'
        30: SequenceLikelihood.UNLIKELY,  # 'P'
        64: SequenceLikelihood.UNLIKELY,  # 'Q'
        45: SequenceLikelihood.UNLIKELY,  # 'R'
        33: SequenceLikelihood.UNLIKELY,  # 'S'
        38: SequenceLikelihood.UNLIKELY,  # 'T'
        51: SequenceLikelihood.UNLIKELY,  # 'U'
        56: SequenceLikelihood.UNLIKELY,  # 'V'
        32: SequenceLikelihood.UNLIKELY,  # 'W'
        60: SequenceLikelihood.UNLIKELY,  # 'X'
        58: SequenceLikelihood.UNLIKELY,  # 'Y'
        44: SequenceLikelihood.UNLIKELY,  # 'Z'
        1: SequenceLikelihood.POSITIVE,  # 'a'
        20: SequenceLikelihood.POSITIVE,  # 'b'
        11: SequenceLikelihood.POSITIVE,  # 'c'
        14: SequenceLikelihood.POSITIVE,  # 'd'
        2: SequenceLikelihood.LIKELY,  # 'e'
        31: SequenceLikelihood.POSITIVE,  # 'f'
        22: SequenceLikelihood.POSITIVE,  # 'g'
        23: SequenceLikelihood.LIKELY,  # 'h'
        3: SequenceLikelihood.LIKELY,  # 'i'
        19: SequenceLikelihood.POSITIVE,  # 'j'
        13: SequenceLikelihood.POSITIVE,  # 'k'
        18: SequenceLikelihood.POSITIVE,  # 'l'
        15: SequenceLikelihood.POSITIVE,  # 'm'
        5: SequenceLikelihood.POSITIVE,  # 'n'
        4: SequenceLikelihood.POSITIVE,  # 'o'
        16: SequenceLikelihood.POSITIVE,  # 'p'
        63: SequenceLikelihood.UNLIKELY,  # 'q'
        7: SequenceLikelihood.POSITIVE,  # 'r'
        9: SequenceLikelihood.POSITIVE,  # 's'
        10: SequenceLikelihood.POSITIVE,  # 't'
        17: SequenceLikelihood.POSITIVE,  # 'u'
        55: SequenceLikelihood.LIKELY,  # 'v'
        8: SequenceLikelihood.POSITIVE,  # 'w'
        57: SequenceLikelihood.LIKELY,  # 'x'
        12: SequenceLikelihood.LIKELY,  # 'y'
        6: SequenceLikelihood.POSITIVE,  # 'z'
        66: SequenceLikelihood.NEGATIVE,  # 'Ó'
        27: SequenceLikelihood.UNLIKELY,  # 'ó'
        67: SequenceLikelihood.UNLIKELY,  # 'Ą'
        25: SequenceLikelihood.UNLIKELY,  # 'ą'
        68: SequenceLikelihood.UNLIKELY,  # 'Ć'
        29: SequenceLikelihood.POSITIVE,  # 'ć'
        65: SequenceLikelihood.NEGATIVE,  # 'Ę'
        24: SequenceLikelihood.UNLIKELY,  # 'ę'
        61: SequenceLikelihood.UNLIKELY,  # 'Ł'
        21: SequenceLikelihood.POSITIVE,  # 'ł'
        70: SequenceLikelihood.UNLIKELY,  # 'Ń'
        42: SequenceLikelihood.POSITIVE,  # 'ń'
        59: SequenceLikelihood.UNLIKELY,  # 'Ś'
        28: SequenceLikelihood.POSITIVE,  # 'ś'
        69: SequenceLikelihood.UNLIKELY,  # 'Ź'
        53: SequenceLikelihood.LIKELY,  # 'ź'
        62: SequenceLikelihood.UNLIKELY,  # 'Ż'
        26: SequenceLikelihood.POSITIVE,  # 'ż'
    },
    31: {  # 'f'
        34: SequenceLikelihood.UNLIKELY,  # 'A'
        46: SequenceLikelihood.UNLIKELY,  # 'B'
        39: SequenceLikelihood.UNLIKELY,  # 'C'
        41: SequenceLikelihood.UNLIKELY,  # 'D'
        48: SequenceLikelihood.UNLIKELY,  # 'E'
        52: SequenceLikelihood.UNLIKELY,  # 'F'
        49: SequenceLikelihood.UNLIKELY,  # 'G'
        54: SequenceLikelihood.UNLIKELY,  # 'H'
        43: SequenceLikelihood.UNLIKELY,  # 'I'
        47: SequenceLikelihood.UNLIKELY,  # 'J'
        37: SequenceLikelihood.UNLIKELY,  # 'K'
        50: SequenceLikelihood.UNLIKELY,  # 'L'
        35: SequenceLikelihood.UNLIKELY,  # 'M'
        36: SequenceLikelihood.UNLIKELY,  # 'N'
        40: SequenceLikelihood.UNLIKELY,  # 'O'
        30: SequenceLikelihood.UNLIKELY,  # 'P'
        64: SequenceLikelihood.UNLIKELY,  # 'Q'
        45: SequenceLikelihood.UNLIKELY,  # 'R'
        33: SequenceLikelihood.UNLIKELY,  # 'S'
        38: SequenceLikelihood.UNLIKELY,  # 'T'
        51: SequenceLikelihood.UNLIKELY,  # 'U'
        56: SequenceLikelihood.UNLIKELY,  # 'V'
        32: SequenceLikelihood.UNLIKELY,  # 'W'
        60: SequenceLikelihood.UNLIKELY,  # 'X'
        58: SequenceLikelihood.UNLIKELY,  # 'Y'
        44: SequenceLikelihood.UNLIKELY,  # 'Z'
        1: SequenceLikelihood.POSITIVE,  # 'a'
        20: SequenceLikelihood.UNLIKELY,  # 'b'
        11: SequenceLikelihood.UNLIKELY,  # 'c'
        14: SequenceLikelihood.UNLIKELY,  # 'd'
        2: SequenceLikelihood.POSITIVE,  # 'e'
        31: SequenceLikelihood.LIKELY,  # 'f'
        22: SequenceLikelihood.UNLIKELY,  # 'g'
        23: SequenceLikelihood.UNLIKELY,  # 'h'
        3: SequenceLikelihood.POSITIVE,  # 'i'
        19: SequenceLikelihood.UNLIKELY,  # 'j'
        13: SequenceLikelihood.UNLIKELY,  # 'k'
        18: SequenceLikelihood.LIKELY,  # 'l'
        15: SequenceLikelihood.UNLIKELY,  # 'm'
        5: SequenceLikelihood.UNLIKELY,  # 'n'
        4: SequenceLikelihood.POSITIVE,  # 'o'
        16: SequenceLikelihood.UNLIKELY,  # 'p'
        63: SequenceLikelihood.UNLIKELY,  # 'q'
        7: SequenceLikelihood.POSITIVE,  # 'r'
        9: SequenceLikelihood.UNLIKELY,  # 's'
        10: SequenceLikelihood.LIKELY,  # 't'
        17: SequenceLikelihood.POSITIVE,  # 'u'
        55: SequenceLikelihood.UNLIKELY,  # 'v'
        8: SequenceLikelihood.UNLIKELY,  # 'w'
        57: SequenceLikelihood.UNLIKELY,  # 'x'
        12: SequenceLikelihood.LIKELY,  # 'y'
        6: SequenceLikelihood.UNLIKELY,  # 'z'
        66: SequenceLikelihood.NEGATIVE,  # 'Ó'
        27: SequenceLikelihood.UNLIKELY,  # 'ó'
        67: SequenceLikelihood.NEGATIVE,  # 'Ą'
        25: SequenceLikelihood.UNLIKELY,  # 'ą'
        68: SequenceLikelihood.NEGATIVE,  # 'Ć'
        29: SequenceLikelihood.NEGATIVE,  # 'ć'
        65: SequenceLikelihood.NEGATIVE,  # 'Ę'
        24: SequenceLikelihood.UNLIKELY,  # 'ę'
        61: SequenceLikelihood.NEGATIVE,  # 'Ł'
        21: SequenceLikelihood.UNLIKELY,  # 'ł'
        70: SequenceLikelihood.NEGATIVE,  # 'Ń'
        42: SequenceLikelihood.UNLIKELY,  # 'ń'
        59: SequenceLikelihood.UNLIKELY,  # 'Ś'
        28: SequenceLikelihood.UNLIKELY,  # 'ś'
        69: SequenceLikelihood.NEGATIVE,  # 'Ź'
        53: SequenceLikelihood.NEGATIVE,  # 'ź'
        62: SequenceLikelihood.NEGATIVE,  # 'Ż'
        26: SequenceLikelihood.NEGATIVE,  # 'ż'
    },
    22: {  # 'g'
        34: SequenceLikelihood.UNLIKELY,  # 'A'
        46: SequenceLikelihood.UNLIKELY,  # 'B'
        39: SequenceLikelihood.UNLIKELY,  # 'C'
        41: SequenceLikelihood.UNLIKELY,  # 'D'
        48: SequenceLikelihood.UNLIKELY,  # 'E'
        52: SequenceLikelihood.UNLIKELY,  # 'F'
        49: SequenceLikelihood.UNLIKELY,  # 'G'
        54: SequenceLikelihood.UNLIKELY,  # 'H'
        43: SequenceLikelihood.UNLIKELY,  # 'I'
        47: SequenceLikelihood.UNLIKELY,  # 'J'
        37: SequenceLikelihood.UNLIKELY,  # 'K'
        50: SequenceLikelihood.UNLIKELY,  # 'L'
        35: SequenceLikelihood.UNLIKELY,  # 'M'
        36: SequenceLikelihood.UNLIKELY,  # 'N'
        40: SequenceLikelihood.UNLIKELY,  # 'O'
        30: SequenceLikelihood.UNLIKELY,  # 'P'
        64: SequenceLikelihood.UNLIKELY,  # 'Q'
        45: SequenceLikelihood.UNLIKELY,  # 'R'
        33: SequenceLikelihood.UNLIKELY,  # 'S'
        38: SequenceLikelihood.UNLIKELY,  # 'T'
        51: SequenceLikelihood.UNLIKELY,  # 'U'
        56: SequenceLikelihood.UNLIKELY,  # 'V'
        32: SequenceLikelihood.UNLIKELY,  # 'W'
        60: SequenceLikelihood.UNLIKELY,  # 'X'
        58: SequenceLikelihood.UNLIKELY,  # 'Y'
        44: SequenceLikelihood.UNLIKELY,  # 'Z'
        1: SequenceLikelihood.POSITIVE,  # 'a'
        20: SequenceLikelihood.UNLIKELY,  # 'b'
        11: SequenceLikelihood.UNLIKELY,  # 'c'
        14: SequenceLikelihood.POSITIVE,  # 'd'
        2: SequenceLikelihood.POSITIVE,  # 'e'
        31: SequenceLikelihood.UNLIKELY,  # 'f'
        22: SequenceLikelihood.LIKELY,  # 'g'
        23: SequenceLikelihood.LIKELY,  # 'h'
        3: SequenceLikelihood.POSITIVE,  # 'i'
        19: SequenceLikelihood.UNLIKELY,  # 'j'
        13: SequenceLikelihood.UNLIKELY,  # 'k'
        18: SequenceLikelihood.POSITIVE,  # 'l'
        15: SequenceLikelihood.LIKELY,  # 'm'
        5: SequenceLikelihood.POSITIVE,  # 'n'
        4: SequenceLikelihood.POSITIVE,  # 'o'
        16: SequenceLikelihood.UNLIKELY,  # 'p'
        63: SequenceLikelihood.UNLIKELY,  # 'q'
        7: SequenceLikelihood.POSITIVE,  # 'r'
        9: SequenceLikelihood.LIKELY,  # 's'
        10: SequenceLikelihood.UNLIKELY,  # 't'
        17: SequenceLikelihood.POSITIVE,  # 'u'
        55: SequenceLikelihood.UNLIKELY,  # 'v'
        8: SequenceLikelihood.LIKELY,  # 'w'
        57: SequenceLikelihood.UNLIKELY,  # 'x'
        12: SequenceLikelihood.UNLIKELY,  # 'y'
        6: SequenceLikelihood.LIKELY,  # 'z'
        66: SequenceLikelihood.UNLIKELY,  # 'Ó'
        27: SequenceLikelihood.POSITIVE,  # 'ó'
        67: SequenceLikelihood.NEGATIVE,  # 'Ą'
        25: SequenceLikelihood.POSITIVE,  # 'ą'
        68: SequenceLikelihood.NEGATIVE,  # 'Ć'
        29: SequenceLikelihood.UNLIKELY,  # 'ć'
        65: SequenceLikelihood.UNLIKELY,  # 'Ę'
        24: SequenceLikelihood.POSITIVE,  # 'ę'
        61: SequenceLikelihood.UNLIKELY,  # 'Ł'
        21: SequenceLikelihood.POSITIVE,  # 'ł'
        70: SequenceLikelihood.NEGATIVE,  # 'Ń'
        42: SequenceLikelihood.UNLIKELY,  # 'ń'
        59: SequenceLikelihood.UNLIKELY,  # 'Ś'
        28: SequenceLikelihood.UNLIKELY,  # 'ś'
        69: SequenceLikelihood.UNLIKELY,  # 'Ź'
        53: SequenceLikelihood.NEGATIVE,  # 'ź'
        62: SequenceLikelihood.UNLIKELY,  # 'Ż'
        26: SequenceLikelihood.UNLIKELY,  # 'ż'
    },
    23: {  # 'h'
        34: SequenceLikelihood.UNLIKELY,  # 'A'
        46: SequenceLikelihood.UNLIKELY,  # 'B'
        39: SequenceLikelihood.UNLIKELY,  # 'C'
        41: SequenceLikelihood.UNLIKELY,  # 'D'
        48: SequenceLikelihood.UNLIKELY,  # 'E'
        52: SequenceLikelihood.UNLIKELY,  # 'F'
        49: SequenceLikelihood.UNLIKELY,  # 'G'
        54: SequenceLikelihood.UNLIKELY,  # 'H'
        43: SequenceLikelihood.UNLIKELY,  # 'I'
        47: SequenceLikelihood.UNLIKELY,  # 'J'
        37: SequenceLikelihood.UNLIKELY,  # 'K'
        50: SequenceLikelihood.UNLIKELY,  # 'L'
        35: SequenceLikelihood.UNLIKELY,  # 'M'
        36: SequenceLikelihood.UNLIKELY,  # 'N'
        40: SequenceLikelihood.UNLIKELY,  # 'O'
        30: SequenceLikelihood.UNLIKELY,  # 'P'
        64: SequenceLikelihood.UNLIKELY,  # 'Q'
        45: SequenceLikelihood.UNLIKELY,  # 'R'
        33: SequenceLikelihood.UNLIKELY,  # 'S'
        38: SequenceLikelihood.UNLIKELY,  # 'T'
        51: SequenceLikelihood.UNLIKELY,  # 'U'
        56: SequenceLikelihood.UNLIKELY,  # 'V'
        32: SequenceLikelihood.UNLIKELY,  # 'W'
        60: SequenceLikelihood.UNLIKELY,  # 'X'
        58: SequenceLikelihood.UNLIKELY,  # 'Y'
        44: SequenceLikelihood.UNLIKELY,  # 'Z'
        1: SequenceLikelihood.POSITIVE,  # 'a'
        20: SequenceLikelihood.UNLIKELY,  # 'b'
        11: SequenceLikelihood.POSITIVE,  # 'c'
        14: SequenceLikelihood.UNLIKELY,  # 'd'
        2: SequenceLikelihood.POSITIVE,  # 'e'
        31: SequenceLikelihood.UNLIKELY,  # 'f'
        22: SequenceLikelihood.UNLIKELY,  # 'g'
        23: SequenceLikelihood.UNLIKELY,  # 'h'
        3: SequenceLikelihood.POSITIVE,  # 'i'
        19: SequenceLikelihood.UNLIKELY,  # 'j'
        13: SequenceLikelihood.UNLIKELY,  # 'k'
        18: SequenceLikelihood.LIKELY,  # 'l'
        15: SequenceLikelihood.LIKELY,  # 'm'
        5: SequenceLikelihood.POSITIVE,  # 'n'
        4: SequenceLikelihood.POSITIVE,  # 'o'
        16: SequenceLikelihood.LIKELY,  # 'p'
        63: SequenceLikelihood.UNLIKELY,  # 'q'
        7: SequenceLikelihood.POSITIVE,  # 'r'
        9: SequenceLikelihood.UNLIKELY,  # 's'
        10: SequenceLikelihood.LIKELY,  # 't'
        17: SequenceLikelihood.POSITIVE,  # 'u'
        55: SequenceLikelihood.UNLIKELY,  # 'v'
        8: SequenceLikelihood.POSITIVE,  # 'w'
        57: SequenceLikelihood.UNLIKELY,  # 'x'
        12: SequenceLikelihood.POSITIVE,  # 'y'
        6: SequenceLikelihood.UNLIKELY,  # 'z'
        66: SequenceLikelihood.UNLIKELY,  # 'Ó'
        27: SequenceLikelihood.LIKELY,  # 'ó'
        67: SequenceLikelihood.NEGATIVE,  # 'Ą'
        25: SequenceLikelihood.UNLIKELY,  # 'ą'
        68: SequenceLikelihood.UNLIKELY,  # 'Ć'
        29: SequenceLikelihood.UNLIKELY,  # 'ć'
        65: SequenceLikelihood.NEGATIVE,  # 'Ę'
        24: SequenceLikelihood.POSITIVE,  # 'ę'
        61: SequenceLikelihood.UNLIKELY,  # 'Ł'
        21: SequenceLikelihood.LIKELY,  # 'ł'
        70: SequenceLikelihood.NEGATIVE,  # 'Ń'
        42: SequenceLikelihood.UNLIKELY,  # 'ń'
        59: SequenceLikelihood.UNLIKELY,  # 'Ś'
        28: SequenceLikelihood.UNLIKELY,  # 'ś'
        69: SequenceLikelihood.UNLIKELY,  # 'Ź'
        53: SequenceLikelihood.UNLIKELY,  # 'ź'
        62: SequenceLikelihood.UNLIKELY,  # 'Ż'
        26: SequenceLikelihood.UNLIKELY,  # 'ż'
    },
    3: {  # 'i'
        34: SequenceLikelihood.UNLIKELY,  # 'A'
        46: SequenceLikelihood.UNLIKELY,  # 'B'
        39: SequenceLikelihood.UNLIKELY,  # 'C'
        41: SequenceLikelihood.UNLIKELY,  # 'D'
        48: SequenceLikelihood.UNLIKELY,  # 'E'
        52: SequenceLikelihood.UNLIKELY,  # 'F'
        49: SequenceLikelihood.UNLIKELY,  # 'G'
        54: SequenceLikelihood.UNLIKELY,  # 'H'
        43: SequenceLikelihood.UNLIKELY,  # 'I'
        47: SequenceLikelihood.UNLIKELY,  # 'J'
        37: SequenceLikelihood.UNLIKELY,  # 'K'
        50: SequenceLikelihood.UNLIKELY,  # 'L'
        35: SequenceLikelihood.UNLIKELY,  # 'M'
        36: SequenceLikelihood.UNLIKELY,  # 'N'
        40: SequenceLikelihood.UNLIKELY,  # 'O'
        30: SequenceLikelihood.UNLIKELY,  # 'P'
        64: SequenceLikelihood.UNLIKELY,  # 'Q'
        45: SequenceLikelihood.UNLIKELY,  # 'R'
        33: SequenceLikelihood.LIKELY,  # 'S'
        38: SequenceLikelihood.UNLIKELY,  # 'T'
        51: SequenceLikelihood.UNLIKELY,  # 'U'
        56: SequenceLikelihood.UNLIKELY,  # 'V'
        32: SequenceLikelihood.UNLIKELY,  # 'W'
        60: SequenceLikelihood.UNLIKELY,  # 'X'
        58: SequenceLikelihood.UNLIKELY,  # 'Y'
        44: SequenceLikelihood.UNLIKELY,  # 'Z'
        1: SequenceLikelihood.POSITIVE,  # 'a'
        20: SequenceLikelihood.POSITIVE,  # 'b'
        11: SequenceLikelihood.POSITIVE,  # 'c'
        14: SequenceLikelihood.POSITIVE,  # 'd'
        2: SequenceLikelihood.POSITIVE,  # 'e'
        31: SequenceLikelihood.LIKELY,  # 'f'
        22: SequenceLikelihood.POSITIVE,  # 'g'
        23: SequenceLikelihood.UNLIKELY,  # 'h'
        3: SequenceLikelihood.POSITIVE,  # 'i'
        19: SequenceLikelihood.POSITIVE,  # 'j'
        13: SequenceLikelihood.POSITIVE,  # 'k'
        18: SequenceLikelihood.POSITIVE,  # 'l'
        15: SequenceLikelihood.POSITIVE,  # 'm'
        5: SequenceLikelihood.POSITIVE,  # 'n'
        4: SequenceLikelihood.POSITIVE,  # 'o'
        16: SequenceLikelihood.POSITIVE,  # 'p'
        63: SequenceLikelihood.UNLIKELY,  # 'q'
        7: SequenceLikelihood.POSITIVE,  # 'r'
        9: SequenceLikelihood.POSITIVE,  # 's'
        10: SequenceLikelihood.POSITIVE,  # 't'
        17: SequenceLikelihood.POSITIVE,  # 'u'
        55: SequenceLikelihood.LIKELY,  # 'v'
        8: SequenceLikelihood.POSITIVE,  # 'w'
        57: SequenceLikelihood.LIKELY,  # 'x'
        12: SequenceLikelihood.UNLIKELY,  # 'y'
        6: SequenceLikelihood.POSITIVE,  # 'z'
        66: SequenceLikelihood.UNLIKELY,  # 'Ó'
        27: SequenceLikelihood.POSITIVE,  # 'ó'
        67: SequenceLikelihood.UNLIKELY,  # 'Ą'
        25: SequenceLikelihood.POSITIVE,  # 'ą'
        68: SequenceLikelihood.UNLIKELY,  # 'Ć'
        29: SequenceLikelihood.POSITIVE,  # 'ć'
        65: SequenceLikelihood.UNLIKELY,  # 'Ę'
        24: SequenceLikelihood.POSITIVE,  # 'ę'
        61: SequenceLikelihood.UNLIKELY,  # 'Ł'
        21: SequenceLikelihood.POSITIVE,  # 'ł'
        70: SequenceLikelihood.UNLIKELY,  # 'Ń'
        42: SequenceLikelihood.LIKELY,  # 'ń'
        59: SequenceLikelihood.UNLIKELY,  # 'Ś'
        28: SequenceLikelihood.POSITIVE,  # 'ś'
        69: SequenceLikelihood.UNLIKELY,  # 'Ź'
        53: SequenceLikelihood.UNLIKELY,  # 'ź'
        62: SequenceLikelihood.UNLIKELY,  # 'Ż'
        26: SequenceLikelihood.POSITIVE,  # 'ż'
    },
    19: {  # 'j'
        34: SequenceLikelihood.UNLIKELY,  # 'A'
        46: SequenceLikelihood.UNLIKELY,  # 'B'
        39: SequenceLikelihood.UNLIKELY,  # 'C'
        41: SequenceLikelihood.UNLIKELY,  # 'D'
        48: SequenceLikelihood.UNLIKELY,  # 'E'
        52: SequenceLikelihood.UNLIKELY,  # 'F'
        49: SequenceLikelihood.UNLIKELY,  # 'G'
        54: SequenceLikelihood.UNLIKELY,  # 'H'
        43: SequenceLikelihood.UNLIKELY,  # 'I'
        47: SequenceLikelihood.UNLIKELY,  # 'J'
        37: SequenceLikelihood.UNLIKELY,  # 'K'
        50: SequenceLikelihood.UNLIKELY,  # 'L'
        35: SequenceLikelihood.UNLIKELY,  # 'M'
        36: SequenceLikelihood.UNLIKELY,  # 'N'
        40: SequenceLikelihood.UNLIKELY,  # 'O'
        30: SequenceLikelihood.UNLIKELY,  # 'P'
        64: SequenceLikelihood.UNLIKELY,  # 'Q'
        45: SequenceLikelihood.UNLIKELY,  # 'R'
        33: SequenceLikelihood.UNLIKELY,  # 'S'
        38: SequenceLikelihood.UNLIKELY,  # 'T'
        51: SequenceLikelihood.UNLIKELY,  # 'U'
        56: SequenceLikelihood.UNLIKELY,  # 'V'
        32: SequenceLikelihood.UNLIKELY,  # 'W'
        60: SequenceLikelihood.UNLIKELY,  # 'X'
        58: SequenceLikelihood.UNLIKELY,  # 'Y'
        44: SequenceLikelihood.UNLIKELY,  # 'Z'
        1: SequenceLikelihood.POSITIVE,  # 'a'
        20: SequenceLikelihood.LIKELY,  # 'b'
        11: SequenceLikelihood.POSITIVE,  # 'c'
        14: SequenceLikelihood.POSITIVE,  # 'd'
        2: SequenceLikelihood.POSITIVE,  # 'e'
        31: SequenceLikelihood.UNLIKELY,  # 'f'
        22: SequenceLikelihood.LIKELY,  # 'g'
        23: SequenceLikelihood.UNLIKELY,  # 'h'
        3: SequenceLikelihood.POSITIVE,  # 'i'
        19: SequenceLikelihood.UNLIKELY,  # 'j'
        13: SequenceLikelihood.LIKELY,  # 'k'
        18: SequenceLikelihood.POSITIVE,  # 'l'
        15: SequenceLikelihood.POSITIVE,  # 'm'
        5: SequenceLikelihood.POSITIVE,  # 'n'
        4: SequenceLikelihood.POSITIVE,  # 'o'
        16: SequenceLikelihood.LIKELY,  # 'p'
        63: SequenceLikelihood.UNLIKELY,  # 'q'
        7: SequenceLikelihood.LIKELY,  # 'r'
        9: SequenceLikelihood.POSITIVE,  # 's'
        10: SequenceLikelihood.LIKELY,  # 't'
        17: SequenceLikelihood.POSITIVE,  # 'u'
        55: SequenceLikelihood.UNLIKELY,  # 'v'
        8: SequenceLikelihood.POSITIVE,  # 'w'
        57: SequenceLikelihood.UNLIKELY,  # 'x'
        12: SequenceLikelihood.UNLIKELY,  # 'y'
        6: SequenceLikelihood.UNLIKELY,  # 'z'
        66: SequenceLikelihood.UNLIKELY,  # 'Ó'
        27: SequenceLikelihood.LIKELY,  # 'ó'
        67: SequenceLikelihood.UNLIKELY,  # 'Ą'
        25: SequenceLikelihood.POSITIVE,  # 'ą'
        68: SequenceLikelihood.NEGATIVE,  # 'Ć'
        29: SequenceLikelihood.UNLIKELY,  # 'ć'
        65: SequenceLikelihood.UNLIKELY,  # 'Ę'
        24: SequenceLikelihood.POSITIVE,  # 'ę'
        61: SequenceLikelihood.NEGATIVE,  # 'Ł'
        21: SequenceLikelihood.UNLIKELY,  # 'ł'
        70: SequenceLikelihood.NEGATIVE,  # 'Ń'
        42: SequenceLikelihood.UNLIKELY,  # 'ń'
        59: SequenceLikelihood.UNLIKELY,  # 'Ś'
        28: SequenceLikelihood.POSITIVE,  # 'ś'
        69: SequenceLikelihood.UNLIKELY,  # 'Ź'
        53: SequenceLikelihood.UNLIKELY,  # 'ź'
        62: SequenceLikelihood.UNLIKELY,  # 'Ż'
        26: SequenceLikelihood.UNLIKELY,  # 'ż'
    },
    13: {  # 'k'
        34: SequenceLikelihood.UNLIKELY,  # 'A'
        46: SequenceLikelihood.UNLIKELY,  # 'B'
        39: SequenceLikelihood.UNLIKELY,  # 'C'
        41: SequenceLikelihood.UNLIKELY,  # 'D'
        48: SequenceLikelihood.UNLIKELY,  # 'E'
        52: SequenceLikelihood.UNLIKELY,  # 'F'
        49: SequenceLikelihood.UNLIKELY,  # 'G'
        54: SequenceLikelihood.UNLIKELY,  # 'H'
        43: SequenceLikelihood.UNLIKELY,  # 'I'
        47: SequenceLikelihood.UNLIKELY,  # 'J'
        37: SequenceLikelihood.UNLIKELY,  # 'K'
        50: SequenceLikelihood.UNLIKELY,  # 'L'
        35: SequenceLikelihood.UNLIKELY,  # 'M'
        36: SequenceLikelihood.UNLIKELY,  # 'N'
        40: SequenceLikelihood.UNLIKELY,  # 'O'
        30: SequenceLikelihood.UNLIKELY,  # 'P'
        64: SequenceLikelihood.UNLIKELY,  # 'Q'
        45: SequenceLikelihood.UNLIKELY,  # 'R'
        33: SequenceLikelihood.UNLIKELY,  # 'S'
        38: SequenceLikelihood.UNLIKELY,  # 'T'
        51: SequenceLikelihood.UNLIKELY,  # 'U'
        56: SequenceLikelihood.UNLIKELY,  # 'V'
        32: SequenceLikelihood.UNLIKELY,  # 'W'
        60: SequenceLikelihood.UNLIKELY,  # 'X'
        58: SequenceLikelihood.UNLIKELY,  # 'Y'
        44: SequenceLikelihood.UNLIKELY,  # 'Z'
        1: SequenceLikelihood.POSITIVE,  # 'a'
        20: SequenceLikelihood.LIKELY,  # 'b'
        11: SequenceLikelihood.POSITIVE,  # 'c'
        14: SequenceLikelihood.UNLIKELY,  # 'd'
        2: SequenceLikelihood.POSITIVE,  # 'e'
        31: SequenceLikelihood.UNLIKELY,  # 'f'
        22: SequenceLikelihood.LIKELY,  # 'g'
        23: SequenceLikelihood.UNLIKELY,  # 'h'
        3: SequenceLikelihood.POSITIVE,  # 'i'
        19: SequenceLikelihood.UNLIKELY,  # 'j'
        13: SequenceLikelihood.LIKELY,  # 'k'
        18: SequenceLikelihood.POSITIVE,  # 'l'
        15: SequenceLikelihood.LIKELY,  # 'm'
        5: SequenceLikelihood.POSITIVE,  # 'n'
        4: SequenceLikelihood.POSITIVE,  # 'o'
        16: SequenceLikelihood.UNLIKELY,  # 'p'
        63: SequenceLikelihood.UNLIKELY,  # 'q'
        7: SequenceLikelihood.POSITIVE,  # 'r'
        9: SequenceLikelihood.POSITIVE,  # 's'
        10: SequenceLikelihood.POSITIVE,  # 't'
        17: SequenceLikelihood.POSITIVE,  # 'u'
        55: SequenceLikelihood.UNLIKELY,  # 'v'
        8: SequenceLikelihood.POSITIVE,  # 'w'
        57: SequenceLikelihood.UNLIKELY,  # 'x'
        12: SequenceLikelihood.LIKELY,  # 'y'
        6: SequenceLikelihood.UNLIKELY,  # 'z'
        66: SequenceLikelihood.UNLIKELY,  # 'Ó'
        27: SequenceLikelihood.POSITIVE,  # 'ó'
        67: SequenceLikelihood.UNLIKELY,  # 'Ą'
        25: SequenceLikelihood.POSITIVE,  # 'ą'
        68: SequenceLikelihood.NEGATIVE,  # 'Ć'
        29: SequenceLikelihood.UNLIKELY,  # 'ć'
        65: SequenceLikelihood.UNLIKELY,  # 'Ę'
        24: SequenceLikelihood.POSITIVE,  # 'ę'
        61: SequenceLikelihood.UNLIKELY,  # 'Ł'
        21: SequenceLikelihood.POSITIVE,  # 'ł'
        70: SequenceLikelihood.NEGATIVE,  # 'Ń'
        42: SequenceLikelihood.UNLIKELY,  # 'ń'
        59: SequenceLikelihood.UNLIKELY,  # 'Ś'
        28: SequenceLikelihood.UNLIKELY,  # 'ś'
        69: SequenceLikelihood.UNLIKELY,  # 'Ź'
        53: SequenceLikelihood.UNLIKELY,  # 'ź'
        62: SequenceLikelihood.UNLIKELY,  # 'Ż'
        26: SequenceLikelihood.POSITIVE,  # 'ż'
    },
    18: {  # 'l'
        34: SequenceLikelihood.UNLIKELY,  # 'A'
        46: SequenceLikelihood.UNLIKELY,  # 'B'
        39: SequenceLikelihood.UNLIKELY,  # 'C'
        41: SequenceLikelihood.UNLIKELY,  # 'D'
        48: SequenceLikelihood.UNLIKELY,  # 'E'
        52: SequenceLikelihood.UNLIKELY,  # 'F'
        49: SequenceLikelihood.UNLIKELY,  # 'G'
        54: SequenceLikelihood.UNLIKELY,  # 'H'
        43: SequenceLikelihood.UNLIKELY,  # 'I'
        47: SequenceLikelihood.UNLIKELY,  # 'J'
        37: SequenceLikelihood.UNLIKELY,  # 'K'
        50: SequenceLikelihood.UNLIKELY,  # 'L'
        35: SequenceLikelihood.UNLIKELY,  # 'M'
        36: SequenceLikelihood.UNLIKELY,  # 'N'
        40: SequenceLikelihood.UNLIKELY,  # 'O'
        30: SequenceLikelihood.UNLIKELY,  # 'P'
        64: SequenceLikelihood.UNLIKELY,  # 'Q'
        45: SequenceLikelihood.UNLIKELY,  # 'R'
        33: SequenceLikelihood.UNLIKELY,  # 'S'
        38: SequenceLikelihood.UNLIKELY,  # 'T'
        51: SequenceLikelihood.UNLIKELY,  # 'U'
        56: SequenceLikelihood.UNLIKELY,  # 'V'
        32: SequenceLikelihood.UNLIKELY,  # 'W'
        60: SequenceLikelihood.UNLIKELY,  # 'X'
        58: SequenceLikelihood.UNLIKELY,  # 'Y'
        44: SequenceLikelihood.UNLIKELY,  # 'Z'
        1: SequenceLikelihood.POSITIVE,  # 'a'
        20: SequenceLikelihood.POSITIVE,  # 'b'
        11: SequenceLikelihood.POSITIVE,  # 'c'
        14: SequenceLikelihood.LIKELY,  # 'd'
        2: SequenceLikelihood.POSITIVE,  # 'e'
        31: SequenceLikelihood.LIKELY,  # 'f'
        22: SequenceLikelihood.LIKELY,  # 'g'
        23: SequenceLikelihood.UNLIKELY,  # 'h'
        3: SequenceLikelihood.POSITIVE,  # 'i'
        19: SequenceLikelihood.UNLIKELY,  # 'j'
        13: SequenceLikelihood.POSITIVE,  # 'k'
        18: SequenceLikelihood.POSITIVE,  # 'l'
        15: SequenceLikelihood.POSITIVE,  # 'm'
        5: SequenceLikelihood.POSITIVE,  # 'n'
        4: SequenceLikelihood.POSITIVE,  # 'o'
        16: SequenceLikelihood.LIKELY,  # 'p'
        63: SequenceLikelihood.UNLIKELY,  # 'q'
        7: SequenceLikelihood.UNLIKELY,  # 'r'
        9: SequenceLikelihood.POSITIVE,  # 's'
        10: SequenceLikelihood.POSITIVE,  # 't'
        17: SequenceLikelihood.POSITIVE,  # 'u'
        55: SequenceLikelihood.LIKELY,  # 'v'
        8: SequenceLikelihood.LIKELY,  # 'w'
        57: SequenceLikelihood.UNLIKELY,  # 'x'
        12: SequenceLikelihood.LIKELY,  # 'y'
        6: SequenceLikelihood.UNLIKELY,  # 'z'
        66: SequenceLikelihood.UNLIKELY,  # 'Ó'
        27: SequenceLikelihood.LIKELY,  # 'ó'
        67: SequenceLikelihood.UNLIKELY,  # 'Ą'
        25: SequenceLikelihood.POSITIVE,  # 'ą'
        68: SequenceLikelihood.UNLIKELY,  # 'Ć'
        29: SequenceLikelihood.UNLIKELY,  # 'ć'
        65: SequenceLikelihood.UNLIKELY,  # 'Ę'
        24: SequenceLikelihood.POSITIVE,  # 'ę'
        61: SequenceLikelihood.UNLIKELY,  # 'Ł'
        21: SequenceLikelihood.UNLIKELY,  # 'ł'
        70: SequenceLikelihood.NEGATIVE,  # 'Ń'
        42: SequenceLikelihood.UNLIKELY,  # 'ń'
        59: SequenceLikelihood.UNLIKELY,  # 'Ś'
        28: SequenceLikelihood.UNLIKELY,  # 'ś'
        69: SequenceLikelihood.UNLIKELY,  # 'Ź'
        53: SequenceLikelihood.UNLIKELY,  # 'ź'
        62: SequenceLikelihood.NEGATIVE,  # 'Ż'
        26: SequenceLikelihood.LIKELY,  # 'ż'
    },
    15: {  # 'm'
        34: SequenceLikelihood.UNLIKELY,  # 'A'
        46: SequenceLikelihood.UNLIKELY,  # 'B'
        39: SequenceLikelihood.UNLIKELY,  # 'C'
        41: SequenceLikelihood.UNLIKELY,  # 'D'
        48: SequenceLikelihood.UNLIKELY,  # 'E'
        52: SequenceLikelihood.UNLIKELY,  # 'F'
        49: SequenceLikelihood.UNLIKELY,  # 'G'
        54: SequenceLikelihood.UNLIKELY,  # 'H'
        43: SequenceLikelihood.UNLIKELY,  # 'I'
        47: SequenceLikelihood.UNLIKELY,  # 'J'
        37: SequenceLikelihood.UNLIKELY,  # 'K'
        50: SequenceLikelihood.UNLIKELY,  # 'L'
        35: SequenceLikelihood.UNLIKELY,  # 'M'
        36: SequenceLikelihood.UNLIKELY,  # 'N'
        40: SequenceLikelihood.UNLIKELY,  # 'O'
        30: SequenceLikelihood.UNLIKELY,  # 'P'
        64: SequenceLikelihood.UNLIKELY,  # 'Q'
        45: SequenceLikelihood.UNLIKELY,  # 'R'
        33: SequenceLikelihood.UNLIKELY,  # 'S'
        38: SequenceLikelihood.UNLIKELY,  # 'T'
        51: SequenceLikelihood.UNLIKELY,  # 'U'
        56: SequenceLikelihood.UNLIKELY,  # 'V'
        32: SequenceLikelihood.UNLIKELY,  # 'W'
        60: SequenceLikelihood.UNLIKELY,  # 'X'
        58: SequenceLikelihood.UNLIKELY,  # 'Y'
        44: SequenceLikelihood.UNLIKELY,  # 'Z'
        1: SequenceLikelihood.POSITIVE,  # 'a'
        20: SequenceLikelihood.LIKELY,  # 'b'
        11: SequenceLikelihood.LIKELY,  # 'c'
        14: SequenceLikelihood.UNLIKELY,  # 'd'
        2: SequenceLikelihood.POSITIVE,  # 'e'
        31: SequenceLikelihood.LIKELY,  # 'f'
        22: SequenceLikelihood.LIKELY,  # 'g'
        23: SequenceLikelihood.UNLIKELY,  # 'h'
        3: SequenceLikelihood.POSITIVE,  # 'i'
        19: SequenceLikelihood.UNLIKELY,  # 'j'
        13: SequenceLikelihood.LIKELY,  # 'k'
        18: SequenceLikelihood.LIKELY,  # 'l'
        15: SequenceLikelihood.LIKELY,  # 'm'
        5: SequenceLikelihood.POSITIVE,  # 'n'
        4: SequenceLikelihood.POSITIVE,  # 'o'
        16: SequenceLikelihood.POSITIVE,  # 'p'
        63: SequenceLikelihood.UNLIKELY,  # 'q'
        7: SequenceLikelihood.LIKELY,  # 'r'
        9: SequenceLikelihood.LIKELY,  # 's'
        10: SequenceLikelihood.LIKELY,  # 't'
        17: SequenceLikelihood.POSITIVE,  # 'u'
        55: SequenceLikelihood.UNLIKELY,  # 'v'
        8: SequenceLikelihood.UNLIKELY,  # 'w'
        57: SequenceLikelihood.UNLIKELY,  # 'x'
        12: SequenceLikelihood.POSITIVE,  # 'y'
        6: SequenceLikelihood.UNLIKELY,  # 'z'
        66: SequenceLikelihood.UNLIKELY,  # 'Ó'
        27: SequenceLikelihood.POSITIVE,  # 'ó'
        67: SequenceLikelihood.NEGATIVE,  # 'Ą'
        25: SequenceLikelihood.LIKELY,  # 'ą'
        68: SequenceLikelihood.NEGATIVE,  # 'Ć'
        29: SequenceLikelihood.UNLIKELY,  # 'ć'
        65: SequenceLikelihood.UNLIKELY,  # 'Ę'
        24: SequenceLikelihood.POSITIVE,  # 'ę'
        61: SequenceLikelihood.UNLIKELY,  # 'Ł'
        21: SequenceLikelihood.LIKELY,  # 'ł'
        70: SequenceLikelihood.NEGATIVE,  # 'Ń'
        42: SequenceLikelihood.UNLIKELY,  # 'ń'
        59: SequenceLikelihood.UNLIKELY,  # 'Ś'
        28: SequenceLikelihood.LIKELY,  # 'ś'
        69: SequenceLikelihood.UNLIKELY,  # 'Ź'
        53: SequenceLikelihood.UNLIKELY,  # 'ź'
        62: SequenceLikelihood.UNLIKELY,  # 'Ż'
        26: SequenceLikelihood.UNLIKELY,  # 'ż'
    },
    5: {  # 'n'
        34: SequenceLikelihood.UNLIKELY,  # 'A'
        46: SequenceLikelihood.UNLIKELY,  # 'B'
        39: SequenceLikelihood.UNLIKELY,  # 'C'
        41: SequenceLikelihood.UNLIKELY,  # 'D'
        48: SequenceLikelihood.UNLIKELY,  # 'E'
        52: SequenceLikelihood.UNLIKELY,  # 'F'
        49: SequenceLikelihood.UNLIKELY,  # 'G'
        54: SequenceLikelihood.UNLIKELY,  # 'H'
        43: SequenceLikelihood.UNLIKELY,  # 'I'
        47: SequenceLikelihood.UNLIKELY,  # 'J'
        37: SequenceLikelihood.UNLIKELY,  # 'K'
        50: SequenceLikelihood.UNLIKELY,  # 'L'
        35: SequenceLikelihood.UNLIKELY,  # 'M'
        36: SequenceLikelihood.UNLIKELY,  # 'N'
        40: SequenceLikelihood.UNLIKELY,  # 'O'
        30: SequenceLikelihood.UNLIKELY,  # 'P'
        64: SequenceLikelihood.UNLIKELY,  # 'Q'
        45: SequenceLikelihood.UNLIKELY,  # 'R'
        33: SequenceLikelihood.UNLIKELY,  # 'S'
        38: SequenceLikelihood.UNLIKELY,  # 'T'
        51: SequenceLikelihood.UNLIKELY,  # 'U'
        56: SequenceLikelihood.UNLIKELY,  # 'V'
        32: SequenceLikelihood.UNLIKELY,  # 'W'
        60: SequenceLikelihood.UNLIKELY,  # 'X'
        58: SequenceLikelihood.UNLIKELY,  # 'Y'
        44: SequenceLikelihood.UNLIKELY,  # 'Z'
        1: SequenceLikelihood.POSITIVE,  # 'a'
        20: SequenceLikelihood.LIKELY,  # 'b'
        11: SequenceLikelihood.POSITIVE,  # 'c'
        14: SequenceLikelihood.POSITIVE,  # 'd'
        2: SequenceLikelihood.POSITIVE,  # 'e'
        31: SequenceLikelihood.POSITIVE,  # 'f'
        22: SequenceLikelihood.POSITIVE,  # 'g'
        23: SequenceLikelihood.LIKELY,  # 'h'
        3: SequenceLikelihood.POSITIVE,  # 'i'
        19: SequenceLikelihood.UNLIKELY,  # 'j'
        13: SequenceLikelihood.POSITIVE,  # 'k'
        18: SequenceLikelihood.LIKELY,  # 'l'
        15: SequenceLikelihood.UNLIKELY,  # 'm'
        5: SequenceLikelihood.POSITIVE,  # 'n'
        4: SequenceLikelihood.POSITIVE,  # 'o'
        16: SequenceLikelihood.LIKELY,  # 'p'
        63: SequenceLikelihood.UNLIKELY,  # 'q'
        7: SequenceLikelihood.LIKELY,  # 'r'
        9: SequenceLikelihood.POSITIVE,  # 's'
        10: SequenceLikelihood.POSITIVE,  # 't'
        17: SequenceLikelihood.POSITIVE,  # 'u'
        55: SequenceLikelihood.UNLIKELY,  # 'v'
        8: SequenceLikelihood.LIKELY,  # 'w'
        57: SequenceLikelihood.UNLIKELY,  # 'x'
        12: SequenceLikelihood.POSITIVE,  # 'y'
        6: SequenceLikelihood.LIKELY,  # 'z'
        66: SequenceLikelihood.UNLIKELY,  # 'Ó'
        27: SequenceLikelihood.POSITIVE,  # 'ó'
        67: SequenceLikelihood.UNLIKELY,  # 'Ą'
        25: SequenceLikelihood.POSITIVE,  # 'ą'
        68: SequenceLikelihood.NEGATIVE,  # 'Ć'
        29: SequenceLikelihood.UNLIKELY,  # 'ć'
        65: SequenceLikelihood.UNLIKELY,  # 'Ę'
        24: SequenceLikelihood.POSITIVE,  # 'ę'
        61: SequenceLikelihood.UNLIKELY,  # 'Ł'
        21: SequenceLikelihood.UNLIKELY,  # 'ł'
        70: SequenceLikelihood.NEGATIVE,  # 'Ń'
        42: SequenceLikelihood.UNLIKELY,  # 'ń'
        59: SequenceLikelihood.UNLIKELY,  # 'Ś'
        28: SequenceLikelihood.UNLIKELY,  # 'ś'
        69: SequenceLikelihood.UNLIKELY,  # 'Ź'
        53: SequenceLikelihood.UNLIKELY,  # 'ź'
        62: SequenceLikelihood.UNLIKELY,  # 'Ż'
        26: SequenceLikelihood.LIKELY,  # 'ż'
    },
    4: {  # 'o'
        34: SequenceLikelihood.UNLIKELY,  # 'A'
        46: SequenceLikelihood.UNLIKELY,  # 'B'
        39: SequenceLikelihood.UNLIKELY,  # 'C'
        41: SequenceLikelihood.UNLIKELY,  # 'D'
        48: SequenceLikelihood.UNLIKELY,  # 'E'
        52: SequenceLikelihood.UNLIKELY,  # 'F'
        49: SequenceLikelihood.UNLIKELY,  # 'G'
        54: SequenceLikelihood.UNLIKELY,  # 'H'
        43: SequenceLikelihood.UNLIKELY,  # 'I'
        47: SequenceLikelihood.UNLIKELY,  # 'J'
        37: SequenceLikelihood.UNLIKELY,  # 'K'
        50: SequenceLikelihood.UNLIKELY,  # 'L'
        35: SequenceLikelihood.UNLIKELY,  # 'M'
        36: SequenceLikelihood.UNLIKELY,  # 'N'
        40: SequenceLikelihood.UNLIKELY,  # 'O'
        30: SequenceLikelihood.UNLIKELY,  # 'P'
        64: SequenceLikelihood.UNLIKELY,  # 'Q'
        45: SequenceLikelihood.UNLIKELY,  # 'R'
        33: SequenceLikelihood.UNLIKELY,  # 'S'
        38: SequenceLikelihood.UNLIKELY,  # 'T'
        51: SequenceLikelihood.UNLIKELY,  # 'U'
        56: SequenceLikelihood.UNLIKELY,  # 'V'
        32: SequenceLikelihood.UNLIKELY,  # 'W'
        60: SequenceLikelihood.UNLIKELY,  # 'X'
        58: SequenceLikelihood.UNLIKELY,  # 'Y'
        44: SequenceLikelihood.UNLIKELY,  # 'Z'
        1: SequenceLikelihood.LIKELY,  # 'a'
        20: SequenceLikelihood.POSITIVE,  # 'b'
        11: SequenceLikelihood.POSITIVE,  # 'c'
        14: SequenceLikelihood.POSITIVE,  # 'd'
        2: SequenceLikelihood.LIKELY,  # 'e'
        31: SequenceLikelihood.POSITIVE,  # 'f'
        22: SequenceLikelihood.POSITIVE,  # 'g'
        23: SequenceLikelihood.LIKELY,  # 'h'
        3: SequenceLikelihood.POSITIVE,  # 'i'
        19: SequenceLikelihood.POSITIVE,  # 'j'
        13: SequenceLikelihood.POSITIVE,  # 'k'
        18: SequenceLikelihood.POSITIVE,  # 'l'
        15: SequenceLikelihood.POSITIVE,  # 'm'
        5: SequenceLikelihood.POSITIVE,  # 'n'
        4: SequenceLikelihood.POSITIVE,  # 'o'
        16: SequenceLikelihood.POSITIVE,  # 'p'
        63: SequenceLikelihood.UNLIKELY,  # 'q'
        7: SequenceLikelihood.POSITIVE,  # 'r'
        9: SequenceLikelihood.POSITIVE,  # 's'
        10: SequenceLikelihood.POSITIVE,  # 't'
        17: SequenceLikelihood.POSITIVE,  # 'u'
        55: SequenceLikelihood.LIKELY,  # 'v'
        8: SequenceLikelihood.POSITIVE,  # 'w'
        57: SequenceLikelihood.LIKELY,  # 'x'
        12: SequenceLikelihood.LIKELY,  # 'y'
        6: SequenceLikelihood.POSITIVE,  # 'z'
        66: SequenceLikelihood.NEGATIVE,  # 'Ó'
        27: SequenceLikelihood.UNLIKELY,  # 'ó'
        67: SequenceLikelihood.NEGATIVE,  # 'Ą'
        25: SequenceLikelihood.UNLIKELY,  # 'ą'
        68: SequenceLikelihood.NEGATIVE,  # 'Ć'
        29: SequenceLikelihood.LIKELY,  # 'ć'
        65: SequenceLikelihood.NEGATIVE,  # 'Ę'
        24: SequenceLikelihood.UNLIKELY,  # 'ę'
        61: SequenceLikelihood.UNLIKELY,  # 'Ł'
        21: SequenceLikelihood.POSITIVE,  # 'ł'
        70: SequenceLikelihood.UNLIKELY,  # 'Ń'
        42: SequenceLikelihood.POSITIVE,  # 'ń'
        59: SequenceLikelihood.UNLIKELY,  # 'Ś'
        28: SequenceLikelihood.POSITIVE,  # 'ś'
        69: SequenceLikelihood.UNLIKELY,  # 'Ź'
        53: SequenceLikelihood.LIKELY,  # 'ź'
        62: SequenceLikelihood.UNLIKELY,  # 'Ż'
        26: SequenceLikelihood.POSITIVE,  # 'ż'
    },
    16: {  # 'p'
        34: SequenceLikelihood.UNLIKELY,  # 'A'
        46: SequenceLikelihood.UNLIKELY,  # 'B'
        39: SequenceLikelihood.UNLIKELY,  # 'C'
        41: SequenceLikelihood.UNLIKELY,  # 'D'
        48: SequenceLikelihood.UNLIKELY,  # 'E'
        52: SequenceLikelihood.UNLIKELY,  # 'F'
        49: SequenceLikelihood.UNLIKELY,  # 'G'
        54: SequenceLikelihood.UNLIKELY,  # 'H'
        43: SequenceLikelihood.UNLIKELY,  # 'I'
        47: SequenceLikelihood.UNLIKELY,  # 'J'
        37: SequenceLikelihood.UNLIKELY,  # 'K'
        50: SequenceLikelihood.UNLIKELY,  # 'L'
        35: SequenceLikelihood.UNLIKELY,  # 'M'
        36: SequenceLikelihood.UNLIKELY,  # 'N'
        40: SequenceLikelihood.UNLIKELY,  # 'O'
        30: SequenceLikelihood.UNLIKELY,  # 'P'
        64: SequenceLikelihood.UNLIKELY,  # 'Q'
        45: SequenceLikelihood.UNLIKELY,  # 'R'
        33: SequenceLikelihood.UNLIKELY,  # 'S'
        38: SequenceLikelihood.UNLIKELY,  # 'T'
        51: SequenceLikelihood.UNLIKELY,  # 'U'
        56: SequenceLikelihood.UNLIKELY,  # 'V'
        32: SequenceLikelihood.UNLIKELY,  # 'W'
        60: SequenceLikelihood.UNLIKELY,  # 'X'
        58: SequenceLikelihood.UNLIKELY,  # 'Y'
        44: SequenceLikelihood.UNLIKELY,  # 'Z'
        1: SequenceLikelihood.POSITIVE,  # 'a'
        20: SequenceLikelihood.UNLIKELY,  # 'b'
        11: SequenceLikelihood.POSITIVE,  # 'c'
        14: SequenceLikelihood.UNLIKELY,  # 'd'
        2: SequenceLikelihood.POSITIVE,  # 'e'
        31: SequenceLikelihood.UNLIKELY,  # 'f'
        22: SequenceLikelihood.UNLIKELY,  # 'g'
        23: SequenceLikelihood.LIKELY,  # 'h'
        3: SequenceLikelihood.POSITIVE,  # 'i'
        19: SequenceLikelihood.UNLIKELY,  # 'j'
        13: SequenceLikelihood.LIKELY,  # 'k'
        18: SequenceLikelihood.POSITIVE,  # 'l'
        15: SequenceLikelihood.UNLIKELY,  # 'm'
        5: SequenceLikelihood.POSITIVE,  # 'n'
        4: SequenceLikelihood.POSITIVE,  # 'o'
        16: SequenceLikelihood.LIKELY,  # 'p'
        63: SequenceLikelihood.UNLIKELY,  # 'q'
        7: SequenceLikelihood.POSITIVE,  # 'r'
        9: SequenceLikelihood.POSITIVE,  # 's'
        10: SequenceLikelihood.POSITIVE,  # 't'
        17: SequenceLikelihood.POSITIVE,  # 'u'
        55: SequenceLikelihood.UNLIKELY,  # 'v'
        8: SequenceLikelihood.UNLIKELY,  # 'w'
        57: SequenceLikelihood.UNLIKELY,  # 'x'
        12: SequenceLikelihood.POSITIVE,  # 'y'
        6: SequenceLikelihood.UNLIKELY,  # 'z'
        66: SequenceLikelihood.UNLIKELY,  # 'Ó'
        27: SequenceLikelihood.POSITIVE,  # 'ó'
        67: SequenceLikelihood.NEGATIVE,  # 'Ą'
        25: SequenceLikelihood.UNLIKELY,  # 'ą'
        68: SequenceLikelihood.NEGATIVE,  # 'Ć'
        29: SequenceLikelihood.UNLIKELY,  # 'ć'
        65: SequenceLikelihood.UNLIKELY,  # 'Ę'
        24: SequenceLikelihood.LIKELY,  # 'ę'
        61: SequenceLikelihood.UNLIKELY,  # 'Ł'
        21: SequenceLikelihood.POSITIVE,  # 'ł'
        70: SequenceLikelihood.NEGATIVE,  # 'Ń'
        42: SequenceLikelihood.UNLIKELY,  # 'ń'
        59: SequenceLikelihood.UNLIKELY,  # 'Ś'
        28: SequenceLikelihood.UNLIKELY,  # 'ś'
        69: SequenceLikelihood.NEGATIVE,  # 'Ź'
        53: SequenceLikelihood.NEGATIVE,  # 'ź'
        62: SequenceLikelihood.UNLIKELY,  # 'Ż'
        26: SequenceLikelihood.UNLIKELY,  # 'ż'
    },
    63: {  # 'q'
        34: SequenceLikelihood.UNLIKELY,  # 'A'
        46: SequenceLikelihood.UNLIKELY,  # 'B'
        39: SequenceLikelihood.UNLIKELY,  # 'C'
        41: SequenceLikelihood.UNLIKELY,  # 'D'
        48: SequenceLikelihood.UNLIKELY,  # 'E'
        52: SequenceLikelihood.UNLIKELY,  # 'F'
        49: SequenceLikelihood.UNLIKELY,  # 'G'
        54: SequenceLikelihood.UNLIKELY,  # 'H'
        43: SequenceLikelihood.UNLIKELY,  # 'I'
        47: SequenceLikelihood.UNLIKELY,  # 'J'
        37: SequenceLikelihood.UNLIKELY,  # 'K'
        50: SequenceLikelihood.UNLIKELY,  # 'L'
        35: SequenceLikelihood.UNLIKELY,  # 'M'
        36: SequenceLikelihood.UNLIKELY,  # 'N'
        40: SequenceLikelihood.UNLIKELY,  # 'O'
        30: SequenceLikelihood.UNLIKELY,  # 'P'
        64: SequenceLikelihood.UNLIKELY,  # 'Q'
        45: SequenceLikelihood.UNLIKELY,  # 'R'
        33: SequenceLikelihood.UNLIKELY,  # 'S'
        38: SequenceLikelihood.UNLIKELY,  # 'T'
        51: SequenceLikelihood.UNLIKELY,  # 'U'
        56: SequenceLikelihood.UNLIKELY,  # 'V'
        32: SequenceLikelihood.UNLIKELY,  # 'W'
        60: SequenceLikelihood.UNLIKELY,  # 'X'
        58: SequenceLikelihood.UNLIKELY,  # 'Y'
        44: SequenceLikelihood.UNLIKELY,  # 'Z'
        1: SequenceLikelihood.UNLIKELY,  # 'a'
        20: SequenceLikelihood.UNLIKELY,  # 'b'
        11: SequenceLikelihood.UNLIKELY,  # 'c'
        14: SequenceLikelihood.UNLIKELY,  # 'd'
        2: SequenceLikelihood.UNLIKELY,  # 'e'
        31: SequenceLikelihood.UNLIKELY,  # 'f'
        22: SequenceLikelihood.UNLIKELY,  # 'g'
        23: SequenceLikelihood.UNLIKELY,  # 'h'
        3: SequenceLikelihood.UNLIKELY,  # 'i'
        19: SequenceLikelihood.UNLIKELY,  # 'j'
        13: SequenceLikelihood.UNLIKELY,  # 'k'
        18: SequenceLikelihood.UNLIKELY,  # 'l'
        15: SequenceLikelihood.UNLIKELY,  # 'm'
        5: SequenceLikelihood.UNLIKELY,  # 'n'
        4: SequenceLikelihood.UNLIKELY,  # 'o'
        16: SequenceLikelihood.UNLIKELY,  # 'p'
        63: SequenceLikelihood.UNLIKELY,  # 'q'
        7: SequenceLikelihood.UNLIKELY,  # 'r'
        9: SequenceLikelihood.UNLIKELY,  # 's'
        10: SequenceLikelihood.UNLIKELY,  # 't'
        17: SequenceLikelihood.LIKELY,  # 'u'
        55: SequenceLikelihood.UNLIKELY,  # 'v'
        8: SequenceLikelihood.UNLIKELY,  # 'w'
        57: SequenceLikelihood.UNLIKELY,  # 'x'
        12: SequenceLikelihood.UNLIKELY,  # 'y'
        6: SequenceLikelihood.UNLIKELY,  # 'z'
        66: SequenceLikelihood.NEGATIVE,  # 'Ó'
        27: SequenceLikelihood.UNLIKELY,  # 'ó'
        67: SequenceLikelihood.NEGATIVE,  # 'Ą'
        25: SequenceLikelihood.NEGATIVE,  # 'ą'
        68: SequenceLikelihood.NEGATIVE,  # 'Ć'
        29: SequenceLikelihood.NEGATIVE,  # 'ć'
        65: SequenceLikelihood.NEGATIVE,  # 'Ę'
        24: SequenceLikelihood.NEGATIVE,  # 'ę'
        61: SequenceLikelihood.NEGATIVE,  # 'Ł'
        21: SequenceLikelihood.UNLIKELY,  # 'ł'
        70: SequenceLikelihood.NEGATIVE,  # 'Ń'
        42: SequenceLikelihood.NEGATIVE,  # 'ń'
        59: SequenceLikelihood.NEGATIVE,  # 'Ś'
        28: SequenceLikelihood.NEGATIVE,  # 'ś'
        69: SequenceLikelihood.NEGATIVE,  # 'Ź'
        53: SequenceLikelihood.NEGATIVE,  # 'ź'
        62: SequenceLikelihood.NEGATIVE,  # 'Ż'
        26: SequenceLikelihood.UNLIKELY,  # 'ż'
    },
    7: {  # 'r'
        34: SequenceLikelihood.UNLIKELY,  # 'A'
        46: SequenceLikelihood.UNLIKELY,  # 'B'
        39: SequenceLikelihood.UNLIKELY,  # 'C'
        41: SequenceLikelihood.UNLIKELY,  # 'D'
        48: SequenceLikelihood.UNLIKELY,  # 'E'
        52: SequenceLikelihood.UNLIKELY,  # 'F'
        49: SequenceLikelihood.UNLIKELY,  # 'G'
        54: SequenceLikelihood.UNLIKELY,  # 'H'
        43: SequenceLikelihood.UNLIKELY,  # 'I'
        47: SequenceLikelihood.UNLIKELY,  # 'J'
        37: SequenceLikelihood.UNLIKELY,  # 'K'
        50: SequenceLikelihood.UNLIKELY,  # 'L'
        35: SequenceLikelihood.UNLIKELY,  # 'M'
        36: SequenceLikelihood.UNLIKELY,  # 'N'
        40: SequenceLikelihood.UNLIKELY,  # 'O'
        30: SequenceLikelihood.UNLIKELY,  # 'P'
        64: SequenceLikelihood.UNLIKELY,  # 'Q'
        45: SequenceLikelihood.UNLIKELY,  # 'R'
        33: SequenceLikelihood.UNLIKELY,  # 'S'
        38: SequenceLikelihood.UNLIKELY,  # 'T'
        51: SequenceLikelihood.UNLIKELY,  # 'U'
        56: SequenceLikelihood.UNLIKELY,  # 'V'
        32: SequenceLikelihood.UNLIKELY,  # 'W'
        60: SequenceLikelihood.UNLIKELY,  # 'X'
        58: SequenceLikelihood.UNLIKELY,  # 'Y'
        44: SequenceLikelihood.UNLIKELY,  # 'Z'
        1: SequenceLikelihood.POSITIVE,  # 'a'
        20: SequenceLikelihood.POSITIVE,  # 'b'
        11: SequenceLikelihood.POSITIVE,  # 'c'
        14: SequenceLikelihood.POSITIVE,  # 'd'
        2: SequenceLikelihood.POSITIVE,  # 'e'
        31: SequenceLikelihood.LIKELY,  # 'f'
        22: SequenceLikelihood.POSITIVE,  # 'g'
        23: SequenceLikelihood.UNLIKELY,  # 'h'
        3: SequenceLikelihood.POSITIVE,  # 'i'
        19: SequenceLikelihood.UNLIKELY,  # 'j'
        13: SequenceLikelihood.POSITIVE,  # 'k'
        18: SequenceLikelihood.LIKELY,  # 'l'
        15: SequenceLikelihood.POSITIVE,  # 'm'
        5: SequenceLikelihood.POSITIVE,  # 'n'
        4: SequenceLikelihood.POSITIVE,  # 'o'
        16: SequenceLikelihood.POSITIVE,  # 'p'
        63: SequenceLikelihood.UNLIKELY,  # 'q'
        7: SequenceLikelihood.LIKELY,  # 'r'
        9: SequenceLikelihood.POSITIVE,  # 's'
        10: SequenceLikelihood.POSITIVE,  # 't'
        17: SequenceLikelihood.POSITIVE,  # 'u'
        55: SequenceLikelihood.LIKELY,  # 'v'
        8: SequenceLikelihood.POSITIVE,  # 'w'
        57: SequenceLikelihood.UNLIKELY,  # 'x'
        12: SequenceLikelihood.POSITIVE,  # 'y'
        6: SequenceLikelihood.POSITIVE,  # 'z'
        66: SequenceLikelihood.UNLIKELY,  # 'Ó'
        27: SequenceLikelihood.POSITIVE,  # 'ó'
        67: SequenceLikelihood.NEGATIVE,  # 'Ą'
        25: SequenceLikelihood.POSITIVE,  # 'ą'
        68: SequenceLikelihood.NEGATIVE,  # 'Ć'
        29: SequenceLikelihood.UNLIKELY,  # 'ć'
        65: SequenceLikelihood.UNLIKELY,  # 'Ę'
        24: SequenceLikelihood.POSITIVE,  # 'ę'
        61: SequenceLikelihood.UNLIKELY,  # 'Ł'
        21: SequenceLikelihood.LIKELY,  # 'ł'
        70: SequenceLikelihood.NEGATIVE,  # 'Ń'
        42: SequenceLikelihood.UNLIKELY,  # 'ń'
        59: SequenceLikelihood.UNLIKELY,  # 'Ś'
        28: SequenceLikelihood.UNLIKELY,  # 'ś'
        69: SequenceLikelihood.NEGATIVE,  # 'Ź'
        53: SequenceLikelihood.UNLIKELY,  # 'ź'
        62: SequenceLikelihood.UNLIKELY,  # 'Ż'
        26: SequenceLikelihood.LIKELY,  # 'ż'
    },
    9: {  # 's'
        34: SequenceLikelihood.UNLIKELY,  # 'A'
        46: SequenceLikelihood.UNLIKELY,  # 'B'
        39: SequenceLikelihood.UNLIKELY,  # 'C'
        41: SequenceLikelihood.UNLIKELY,  # 'D'
        48: SequenceLikelihood.UNLIKELY,  # 'E'
        52: SequenceLikelihood.UNLIKELY,  # 'F'
        49: SequenceLikelihood.UNLIKELY,  # 'G'
        54: SequenceLikelihood.UNLIKELY,  # 'H'
        43: SequenceLikelihood.UNLIKELY,  # 'I'
        47: SequenceLikelihood.UNLIKELY,  # 'J'
        37: SequenceLikelihood.UNLIKELY,  # 'K'
        50: SequenceLikelihood.UNLIKELY,  # 'L'
        35: SequenceLikelihood.UNLIKELY,  # 'M'
        36: SequenceLikelihood.UNLIKELY,  # 'N'
        40: SequenceLikelihood.UNLIKELY,  # 'O'
        30: SequenceLikelihood.UNLIKELY,  # 'P'
        64: SequenceLikelihood.UNLIKELY,  # 'Q'
        45: SequenceLikelihood.UNLIKELY,  # 'R'
        33: SequenceLikelihood.UNLIKELY,  # 'S'
        38: SequenceLikelihood.UNLIKELY,  # 'T'
        51: SequenceLikelihood.UNLIKELY,  # 'U'
        56: SequenceLikelihood.UNLIKELY,  # 'V'
        32: SequenceLikelihood.UNLIKELY,  # 'W'
        60: SequenceLikelihood.UNLIKELY,  # 'X'
        58: SequenceLikelihood.UNLIKELY,  # 'Y'
        44: SequenceLikelihood.UNLIKELY,  # 'Z'
        1: SequenceLikelihood.POSITIVE,  # 'a'
        20: SequenceLikelihood.UNLIKELY,  # 'b'
        11: SequenceLikelihood.POSITIVE,  # 'c'
        14: SequenceLikelihood.UNLIKELY,  # 'd'
        2: SequenceLikelihood.POSITIVE,  # 'e'
        31: SequenceLikelihood.LIKELY,  # 'f'
        22: SequenceLikelihood.UNLIKELY,  # 'g'
        23: SequenceLikelihood.LIKELY,  # 'h'
        3: SequenceLikelihood.POSITIVE,  # 'i'
        19: SequenceLikelihood.POSITIVE,  # 'j'
        13: SequenceLikelihood.POSITIVE,  # 'k'
        18: SequenceLikelihood.LIKELY,  # 'l'
        15: SequenceLikelihood.POSITIVE,  # 'm'
        5: SequenceLikelihood.POSITIVE,  # 'n'
        4: SequenceLikelihood.POSITIVE,  # 'o'
        16: SequenceLikelihood.POSITIVE,  # 'p'
        63: SequenceLikelihood.UNLIKELY,  # 'q'
        7: SequenceLikelihood.LIKELY,  # 'r'
        9: SequenceLikelihood.POSITIVE,  # 's'
        10: SequenceLikelihood.POSITIVE,  # 't'
        17: SequenceLikelihood.POSITIVE,  # 'u'
        55: SequenceLikelihood.UNLIKELY,  # 'v'
        8: SequenceLikelihood.POSITIVE,  # 'w'
        57: SequenceLikelihood.UNLIKELY,  # 'x'
        12: SequenceLikelihood.POSITIVE,  # 'y'
        6: SequenceLikelihood.POSITIVE,  # 'z'
        66: SequenceLikelihood.UNLIKELY,  # 'Ó'
        27: SequenceLikelihood.POSITIVE,  # 'ó'
        67: SequenceLikelihood.UNLIKELY,  # 'Ą'
        25: SequenceLikelihood.POSITIVE,  # 'ą'
        68: SequenceLikelihood.UNLIKELY,  # 'Ć'
        29: SequenceLikelihood.UNLIKELY,  # 'ć'
        65: SequenceLikelihood.NEGATIVE,  # 'Ę'
        24: SequenceLikelihood.LIKELY,  # 'ę'
        61: SequenceLikelihood.UNLIKELY,  # 'Ł'
        21: SequenceLikelihood.POSITIVE,  # 'ł'
        70: SequenceLikelihood.NEGATIVE,  # 'Ń'
        42: SequenceLikelihood.UNLIKELY,  # 'ń'
        59: SequenceLikelihood.UNLIKELY,  # 'Ś'
        28: SequenceLikelihood.UNLIKELY,  # 'ś'
        69: SequenceLikelihood.UNLIKELY,  # 'Ź'
        53: SequenceLikelihood.UNLIKELY,  # 'ź'
        62: SequenceLikelihood.UNLIKELY,  # 'Ż'
        26: SequenceLikelihood.UNLIKELY,  # 'ż'
    },
    10: {  # 't'
        34: SequenceLikelihood.UNLIKELY,  # 'A'
        46: SequenceLikelihood.UNLIKELY,  # 'B'
        39: SequenceLikelihood.UNLIKELY,  # 'C'
        41: SequenceLikelihood.UNLIKELY,  # 'D'
        48: SequenceLikelihood.UNLIKELY,  # 'E'
        52: SequenceLikelihood.UNLIKELY,  # 'F'
        49: SequenceLikelihood.UNLIKELY,  # 'G'
        54: SequenceLikelihood.UNLIKELY,  # 'H'
        43: SequenceLikelihood.UNLIKELY,  # 'I'
        47: SequenceLikelihood.UNLIKELY,  # 'J'
        37: SequenceLikelihood.UNLIKELY,  # 'K'
        50: SequenceLikelihood.UNLIKELY,  # 'L'
        35: SequenceLikelihood.UNLIKELY,  # 'M'
        36: SequenceLikelihood.UNLIKELY,  # 'N'
        40: SequenceLikelihood.UNLIKELY,  # 'O'
        30: SequenceLikelihood.UNLIKELY,  # 'P'
        64: SequenceLikelihood.UNLIKELY,  # 'Q'
        45: SequenceLikelihood.UNLIKELY,  # 'R'
        33: SequenceLikelihood.UNLIKELY,  # 'S'
        38: SequenceLikelihood.UNLIKELY,  # 'T'
        51: SequenceLikelihood.UNLIKELY,  # 'U'
        56: SequenceLikelihood.UNLIKELY,  # 'V'
        32: SequenceLikelihood.UNLIKELY,  # 'W'
        60: SequenceLikelihood.UNLIKELY,  # 'X'
        58: SequenceLikelihood.UNLIKELY,  # 'Y'
        44: SequenceLikelihood.UNLIKELY,  # 'Z'
        1: SequenceLikelihood.POSITIVE,  # 'a'
        20: SequenceLikelihood.UNLIKELY,  # 'b'
        11: SequenceLikelihood.LIKELY,  # 'c'
        14: SequenceLikelihood.LIKELY,  # 'd'
        2: SequenceLikelihood.POSITIVE,  # 'e'
        31: SequenceLikelihood.LIKELY,  # 'f'
        22: SequenceLikelihood.UNLIKELY,  # 'g'
        23: SequenceLikelihood.POSITIVE,  # 'h'
        3: SequenceLikelihood.POSITIVE,  # 'i'
        19: SequenceLikelihood.UNLIKELY,  # 'j'
        13: SequenceLikelihood.POSITIVE,  # 'k'
        18: SequenceLikelihood.POSITIVE,  # 'l'
        15: SequenceLikelihood.LIKELY,  # 'm'
        5: SequenceLikelihood.POSITIVE,  # 'n'
        4: SequenceLikelihood.POSITIVE,  # 'o'
        16: SequenceLikelihood.POSITIVE,  # 'p'
        63: SequenceLikelihood.UNLIKELY,  # 'q'
        7: SequenceLikelihood.POSITIVE,  # 'r'
        9: SequenceLikelihood.LIKELY,  # 's'
        10: SequenceLikelihood.POSITIVE,  # 't'
        17: SequenceLikelihood.POSITIVE,  # 'u'
        55: SequenceLikelihood.UNLIKELY,  # 'v'
        8: SequenceLikelihood.POSITIVE,  # 'w'
        57: SequenceLikelihood.UNLIKELY,  # 'x'
        12: SequenceLikelihood.POSITIVE,  # 'y'
        6: SequenceLikelihood.LIKELY,  # 'z'
        66: SequenceLikelihood.UNLIKELY,  # 'Ó'
        27: SequenceLikelihood.POSITIVE,  # 'ó'
        67: SequenceLikelihood.UNLIKELY,  # 'Ą'
        25: SequenceLikelihood.POSITIVE,  # 'ą'
        68: SequenceLikelihood.NEGATIVE,  # 'Ć'
        29: SequenceLikelihood.UNLIKELY,  # 'ć'
        65: SequenceLikelihood.UNLIKELY,  # 'Ę'
        24: SequenceLikelihood.POSITIVE,  # 'ę'
        61: SequenceLikelihood.UNLIKELY,  # 'Ł'
        21: SequenceLikelihood.POSITIVE,  # 'ł'
        70: SequenceLikelihood.NEGATIVE,  # 'Ń'
        42: SequenceLikelihood.UNLIKELY,  # 'ń'
        59: SequenceLikelihood.UNLIKELY,  # 'Ś'
        28: SequenceLikelihood.UNLIKELY,  # 'ś'
        69: SequenceLikelihood.NEGATIVE,  # 'Ź'
        53: SequenceLikelihood.UNLIKELY,  # 'ź'
        62: SequenceLikelihood.UNLIKELY,  # 'Ż'
        26: SequenceLikelihood.UNLIKELY,  # 'ż'
    },
    17: {  # 'u'
        34: SequenceLikelihood.UNLIKELY,  # 'A'
        46: SequenceLikelihood.UNLIKELY,  # 'B'
        39: SequenceLikelihood.UNLIKELY,  # 'C'
        41: SequenceLikelihood.UNLIKELY,  # 'D'
        48: SequenceLikelihood.UNLIKELY,  # 'E'
        52: SequenceLikelihood.UNLIKELY,  # 'F'
        49: SequenceLikelihood.UNLIKELY,  # 'G'
        54: SequenceLikelihood.UNLIKELY,  # 'H'
        43: SequenceLikelihood.UNLIKELY,  # 'I'
        47: SequenceLikelihood.UNLIKELY,  # 'J'
        37: SequenceLikelihood.UNLIKELY,  # 'K'
        50: SequenceLikelihood.UNLIKELY,  # 'L'
        35: SequenceLikelihood.UNLIKELY,  # 'M'
        36: SequenceLikelihood.UNLIKELY,  # 'N'
        40: SequenceLikelihood.UNLIKELY,  # 'O'
        30: SequenceLikelihood.UNLIKELY,  # 'P'
        64: SequenceLikelihood.UNLIKELY,  # 'Q'
        45: SequenceLikelihood.UNLIKELY,  # 'R'
        33: SequenceLikelihood.UNLIKELY,  # 'S'
        38: SequenceLikelihood.UNLIKELY,  # 'T'
        51: SequenceLikelihood.UNLIKELY,  # 'U'
        56: SequenceLikelihood.UNLIKELY,  # 'V'
        32: SequenceLikelihood.UNLIKELY,  # 'W'
        60: SequenceLikelihood.UNLIKELY,  # 'X'
        58: SequenceLikelihood.UNLIKELY,  # 'Y'
        44: SequenceLikelihood.UNLIKELY,  # 'Z'
        1: SequenceLikelihood.POSITIVE,  # 'a'
        20: SequenceLikelihood.POSITIVE,  # 'b'
        11: SequenceLikelihood.POSITIVE,  # 'c'
        14: SequenceLikelihood.POSITIVE,  # 'd'
        2: SequenceLikelihood.LIKELY,  # 'e'
        31: SequenceLikelihood.LIKELY,  # 'f'
        22: SequenceLikelihood.POSITIVE,  # 'g'
        23: SequenceLikelihood.UNLIKELY,  # 'h'
        3: SequenceLikelihood.LIKELY,  # 'i'
        19: SequenceLikelihood.POSITIVE,  # 'j'
        13: SequenceLikelihood.POSITIVE,  # 'k'
        18: SequenceLikelihood.POSITIVE,  # 'l'
        15: SequenceLikelihood.POSITIVE,  # 'm'
        5: SequenceLikelihood.POSITIVE,  # 'n'
        4: SequenceLikelihood.LIKELY,  # 'o'
        16: SequenceLikelihood.POSITIVE,  # 'p'
        63: SequenceLikelihood.UNLIKELY,  # 'q'
        7: SequenceLikelihood.POSITIVE,  # 'r'
        9: SequenceLikelihood.POSITIVE,  # 's'
        10: SequenceLikelihood.POSITIVE,  # 't'
        17: SequenceLikelihood.UNLIKELY,  # 'u'
        55: SequenceLikelihood.UNLIKELY,  # 'v'
        8: SequenceLikelihood.POSITIVE,  # 'w'
        57: SequenceLikelihood.UNLIKELY,  # 'x'
        12: SequenceLikelihood.UNLIKELY,  # 'y'
        6: SequenceLikelihood.POSITIVE,  # 'z'
        66: SequenceLikelihood.NEGATIVE,  # 'Ó'
        27: SequenceLikelihood.UNLIKELY,  # 'ó'
        67: SequenceLikelihood.NEGATIVE,  # 'Ą'
        25: SequenceLikelihood.UNLIKELY,  # 'ą'
        68: SequenceLikelihood.NEGATIVE,  # 'Ć'
        29: SequenceLikelihood.LIKELY,  # 'ć'
        65: SequenceLikelihood.NEGATIVE,  # 'Ę'
        24: SequenceLikelihood.UNLIKELY,  # 'ę'
        61: SequenceLikelihood.UNLIKELY,  # 'Ł'
        21: SequenceLikelihood.POSITIVE,  # 'ł'
        70: SequenceLikelihood.UNLIKELY,  # 'Ń'
        42: SequenceLikelihood.LIKELY,  # 'ń'
        59: SequenceLikelihood.UNLIKELY,  # 'Ś'
        28: SequenceLikelihood.LIKELY,  # 'ś'
        69: SequenceLikelihood.UNLIKELY,  # 'Ź'
        53: SequenceLikelihood.UNLIKELY,  # 'ź'
        62: SequenceLikelihood.UNLIKELY,  # 'Ż'
        26: SequenceLikelihood.POSITIVE,  # 'ż'
    },
    55: {  # 'v'
        34: SequenceLikelihood.UNLIKELY,  # 'A'
        46: SequenceLikelihood.UNLIKELY,  # 'B'
        39: SequenceLikelihood.UNLIKELY,  # 'C'
        41: SequenceLikelihood.UNLIKELY,  # 'D'
        48: SequenceLikelihood.UNLIKELY,  # 'E'
        52: SequenceLikelihood.UNLIKELY,  # 'F'
        49: SequenceLikelihood.UNLIKELY,  # 'G'
        54: SequenceLikelihood.UNLIKELY,  # 'H'
        43: SequenceLikelihood.UNLIKELY,  # 'I'
        47: SequenceLikelihood.UNLIKELY,  # 'J'
        37: SequenceLikelihood.UNLIKELY,  # 'K'
        50: SequenceLikelihood.UNLIKELY,  # 'L'
        35: SequenceLikelihood.UNLIKELY,  # 'M'
        36: SequenceLikelihood.UNLIKELY,  # 'N'
        40: SequenceLikelihood.UNLIKELY,  # 'O'
        30: SequenceLikelihood.UNLIKELY,  # 'P'
        64: SequenceLikelihood.UNLIKELY,  # 'Q'
        45: SequenceLikelihood.UNLIKELY,  # 'R'
        33: SequenceLikelihood.UNLIKELY,  # 'S'
        38: SequenceLikelihood.UNLIKELY,  # 'T'
        51: SequenceLikelihood.UNLIKELY,  # 'U'
        56: SequenceLikelihood.UNLIKELY,  # 'V'
        32: SequenceLikelihood.UNLIKELY,  # 'W'
        60: SequenceLikelihood.UNLIKELY,  # 'X'
        58: SequenceLikelihood.UNLIKELY,  # 'Y'
        44: SequenceLikelihood.UNLIKELY,  # 'Z'
        1: SequenceLikelihood.LIKELY,  # 'a'
        20: SequenceLikelihood.UNLIKELY,  # 'b'
        11: SequenceLikelihood.UNLIKELY,  # 'c'
        14: SequenceLikelihood.UNLIKELY,  # 'd'
        2: SequenceLikelihood.POSITIVE,  # 'e'
        31: SequenceLikelihood.UNLIKELY,  # 'f'
        22: SequenceLikelihood.UNLIKELY,  # 'g'
        23: SequenceLikelihood.UNLIKELY,  # 'h'
        3: SequenceLikelihood.LIKELY,  # 'i'
        19: SequenceLikelihood.UNLIKELY,  # 'j'
        13: SequenceLikelihood.UNLIKELY,  # 'k'
        18: SequenceLikelihood.UNLIKELY,  # 'l'
        15: SequenceLikelihood.UNLIKELY,  # 'm'
        5: SequenceLikelihood.UNLIKELY,  # 'n'
        4: SequenceLikelihood.LIKELY,  # 'o'
        16: SequenceLikelihood.UNLIKELY,  # 'p'
        63: SequenceLikelihood.UNLIKELY,  # 'q'
        7: SequenceLikelihood.UNLIKELY,  # 'r'
        9: SequenceLikelihood.UNLIKELY,  # 's'
        10: SequenceLikelihood.UNLIKELY,  # 't'
        17: SequenceLikelihood.UNLIKELY,  # 'u'
        55: SequenceLikelihood.UNLIKELY,  # 'v'
        8: SequenceLikelihood.UNLIKELY,  # 'w'
        57: SequenceLikelihood.UNLIKELY,  # 'x'
        12: SequenceLikelihood.UNLIKELY,  # 'y'
        6: SequenceLikelihood.UNLIKELY,  # 'z'
        66: SequenceLikelihood.NEGATIVE,  # 'Ó'
        27: SequenceLikelihood.UNLIKELY,  # 'ó'
        67: SequenceLikelihood.NEGATIVE,  # 'Ą'
        25: SequenceLikelihood.UNLIKELY,  # 'ą'
        68: SequenceLikelihood.NEGATIVE,  # 'Ć'
        29: SequenceLikelihood.UNLIKELY,  # 'ć'
        65: SequenceLikelihood.NEGATIVE,  # 'Ę'
        24: SequenceLikelihood.UNLIKELY,  # 'ę'
        61: SequenceLikelihood.NEGATIVE,  # 'Ł'
        21: SequenceLikelihood.NEGATIVE,  # 'ł'
        70: SequenceLikelihood.NEGATIVE,  # 'Ń'
        42: SequenceLikelihood.NEGATIVE,  # 'ń'
        59: SequenceLikelihood.NEGATIVE,  # 'Ś'
        28: SequenceLikelihood.NEGATIVE,  # 'ś'
        69: SequenceLikelihood.NEGATIVE,  # 'Ź'
        53: SequenceLikelihood.NEGATIVE,  # 'ź'
        62: SequenceLikelihood.NEGATIVE,  # 'Ż'
        26: SequenceLikelihood.UNLIKELY,  # 'ż'
    },
    8: {  # 'w'
        34: SequenceLikelihood.UNLIKELY,  # 'A'
        46: SequenceLikelihood.UNLIKELY,  # 'B'
        39: SequenceLikelihood.UNLIKELY,  # 'C'
        41: SequenceLikelihood.UNLIKELY,  # 'D'
        48: SequenceLikelihood.UNLIKELY,  # 'E'
        52: SequenceLikelihood.UNLIKELY,  # 'F'
        49: SequenceLikelihood.UNLIKELY,  # 'G'
        54: SequenceLikelihood.UNLIKELY,  # 'H'
        43: SequenceLikelihood.UNLIKELY,  # 'I'
        47: SequenceLikelihood.UNLIKELY,  # 'J'
        37: SequenceLikelihood.UNLIKELY,  # 'K'
        50: SequenceLikelihood.UNLIKELY,  # 'L'
        35: SequenceLikelihood.UNLIKELY,  # 'M'
        36: SequenceLikelihood.UNLIKELY,  # 'N'
        40: SequenceLikelihood.UNLIKELY,  # 'O'
        30: SequenceLikelihood.UNLIKELY,  # 'P'
        64: SequenceLikelihood.UNLIKELY,  # 'Q'
        45: SequenceLikelihood.UNLIKELY,  # 'R'
        33: SequenceLikelihood.UNLIKELY,  # 'S'
        38: SequenceLikelihood.UNLIKELY,  # 'T'
        51: SequenceLikelihood.UNLIKELY,  # 'U'
        56: SequenceLikelihood.UNLIKELY,  # 'V'
        32: SequenceLikelihood.UNLIKELY,  # 'W'
        60: SequenceLikelihood.UNLIKELY,  # 'X'
        58: SequenceLikelihood.UNLIKELY,  # 'Y'
        44: SequenceLikelihood.UNLIKELY,  # 'Z'
        1: SequenceLikelihood.POSITIVE,  # 'a'
        20: SequenceLikelihood.LIKELY,  # 'b'
        11: SequenceLikelihood.POSITIVE,  # 'c'
        14: SequenceLikelihood.POSITIVE,  # 'd'
        2: SequenceLikelihood.POSITIVE,  # 'e'
        31: SequenceLikelihood.UNLIKELY,  # 'f'
        22: SequenceLikelihood.LIKELY,  # 'g'
        23: SequenceLikelihood.UNLIKELY,  # 'h'
        3: SequenceLikelihood.POSITIVE,  # 'i'
        19: SequenceLikelihood.UNLIKELY,  # 'j'
        13: SequenceLikelihood.POSITIVE,  # 'k'
        18: SequenceLikelihood.LIKELY,  # 'l'
        15: SequenceLikelihood.UNLIKELY,  # 'm'
        5: SequenceLikelihood.POSITIVE,  # 'n'
        4: SequenceLikelihood.POSITIVE,  # 'o'
        16: SequenceLikelihood.POSITIVE,  # 'p'
        63: SequenceLikelihood.UNLIKELY,  # 'q'
        7: SequenceLikelihood.POSITIVE,  # 'r'
        9: SequenceLikelihood.POSITIVE,  # 's'
        10: SequenceLikelihood.LIKELY,  # 't'
        17: SequenceLikelihood.POSITIVE,  # 'u'
        55: SequenceLikelihood.UNLIKELY,  # 'v'
        8: SequenceLikelihood.POSITIVE,  # 'w'
        57: SequenceLikelihood.UNLIKELY,  # 'x'
        12: SequenceLikelihood.POSITIVE,  # 'y'
        6: SequenceLikelihood.POSITIVE,  # 'z'
        66: SequenceLikelihood.UNLIKELY,  # 'Ó'
        27: SequenceLikelihood.POSITIVE,  # 'ó'
        67: SequenceLikelihood.UNLIKELY,  # 'Ą'
        25: SequenceLikelihood.POSITIVE,  # 'ą'
        68: SequenceLikelihood.NEGATIVE,  # 'Ć'
        29: SequenceLikelihood.UNLIKELY,  # 'ć'
        65: SequenceLikelihood.UNLIKELY,  # 'Ę'
        24: SequenceLikelihood.POSITIVE,  # 'ę'
        61: SequenceLikelihood.UNLIKELY,  # 'Ł'
        21: SequenceLikelihood.POSITIVE,  # 'ł'
        70: SequenceLikelihood.NEGATIVE,  # 'Ń'
        42: SequenceLikelihood.UNLIKELY,  # 'ń'
        59: SequenceLikelihood.UNLIKELY,  # 'Ś'
        28: SequenceLikelihood.LIKELY,  # 'ś'
        69: SequenceLikelihood.UNLIKELY,  # 'Ź'
        53: SequenceLikelihood.UNLIKELY,  # 'ź'
        62: SequenceLikelihood.UNLIKELY,  # 'Ż'
        26: SequenceLikelihood.UNLIKELY,  # 'ż'
    },
    57: {  # 'x'
        34: SequenceLikelihood.UNLIKELY,  # 'A'
        46: SequenceLikelihood.UNLIKELY,  # 'B'
        39: SequenceLikelihood.UNLIKELY,  # 'C'
        41: SequenceLikelihood.UNLIKELY,  # 'D'
        48: SequenceLikelihood.UNLIKELY,  # 'E'
        52: SequenceLikelihood.UNLIKELY,  # 'F'
        49: SequenceLikelihood.UNLIKELY,  # 'G'
        54: SequenceLikelihood.UNLIKELY,  # 'H'
        43: SequenceLikelihood.UNLIKELY,  # 'I'
        47: SequenceLikelihood.UNLIKELY,  # 'J'
        37: SequenceLikelihood.UNLIKELY,  # 'K'
        50: SequenceLikelihood.UNLIKELY,  # 'L'
        35: SequenceLikelihood.UNLIKELY,  # 'M'
        36: SequenceLikelihood.UNLIKELY,  # 'N'
        40: SequenceLikelihood.UNLIKELY,  # 'O'
        30: SequenceLikelihood.UNLIKELY,  # 'P'
        64: SequenceLikelihood.UNLIKELY,  # 'Q'
        45: SequenceLikelihood.UNLIKELY,  # 'R'
        33: SequenceLikelihood.UNLIKELY,  # 'S'
        38: SequenceLikelihood.UNLIKELY,  # 'T'
        51: SequenceLikelihood.UNLIKELY,  # 'U'
        56: SequenceLikelihood.UNLIKELY,  # 'V'
        32: SequenceLikelihood.UNLIKELY,  # 'W'
        60: SequenceLikelihood.UNLIKELY,  # 'X'
        58: SequenceLikelihood.UNLIKELY,  # 'Y'
        44: SequenceLikelihood.UNLIKELY,  # 'Z'
        1: SequenceLikelihood.UNLIKELY,  # 'a'
        20: SequenceLikelihood.UNLIKELY,  # 'b'
        11: SequenceLikelihood.UNLIKELY,  # 'c'
        14: SequenceLikelihood.UNLIKELY,  # 'd'
        2: SequenceLikelihood.UNLIKELY,  # 'e'
        31: SequenceLikelihood.UNLIKELY,  # 'f'
        22: SequenceLikelihood.UNLIKELY,  # 'g'
        23: SequenceLikelihood.UNLIKELY,  # 'h'
        3: SequenceLikelihood.LIKELY,  # 'i'
        19: SequenceLikelihood.UNLIKELY,  # 'j'
        13: SequenceLikelihood.UNLIKELY,  # 'k'
        18: SequenceLikelihood.UNLIKELY,  # 'l'
        15: SequenceLikelihood.UNLIKELY,  # 'm'
        5: SequenceLikelihood.UNLIKELY,  # 'n'
        4: SequenceLikelihood.UNLIKELY,  # 'o'
        16: SequenceLikelihood.LIKELY,  # 'p'
        63: SequenceLikelihood.UNLIKELY,  # 'q'
        7: SequenceLikelihood.UNLIKELY,  # 'r'
        9: SequenceLikelihood.UNLIKELY,  # 's'
        10: SequenceLikelihood.UNLIKELY,  # 't'
        17: SequenceLikelihood.UNLIKELY,  # 'u'
        55: SequenceLikelihood.UNLIKELY,  # 'v'
        8: SequenceLikelihood.UNLIKELY,  # 'w'
        57: SequenceLikelihood.UNLIKELY,  # 'x'
        12: SequenceLikelihood.UNLIKELY,  # 'y'
        6: SequenceLikelihood.UNLIKELY,  # 'z'
        66: SequenceLikelihood.NEGATIVE,  # 'Ó'
        27: SequenceLikelihood.UNLIKELY,  # 'ó'
        67: SequenceLikelihood.NEGATIVE,  # 'Ą'
        25: SequenceLikelihood.UNLIKELY,  # 'ą'
        68: SequenceLikelihood.NEGATIVE,  # 'Ć'
        29: SequenceLikelihood.UNLIKELY,  # 'ć'
        65: SequenceLikelihood.NEGATIVE,  # 'Ę'
        24: SequenceLikelihood.UNLIKELY,  # 'ę'
        61: SequenceLikelihood.NEGATIVE,  # 'Ł'
        21: SequenceLikelihood.NEGATIVE,  # 'ł'
        70: SequenceLikelihood.NEGATIVE,  # 'Ń'
        42: SequenceLikelihood.NEGATIVE,  # 'ń'
        59: SequenceLikelihood.NEGATIVE,  # 'Ś'
        28: SequenceLikelihood.NEGATIVE,  # 'ś'
        69: SequenceLikelihood.NEGATIVE,  # 'Ź'
        53: SequenceLikelihood.NEGATIVE,  # 'ź'
        62: SequenceLikelihood.UNLIKELY,  # 'Ż'
        26: SequenceLikelihood.NEGATIVE,  # 'ż'
    },
    12: {  # 'y'
        34: SequenceLikelihood.UNLIKELY,  # 'A'
        46: SequenceLikelihood.UNLIKELY,  # 'B'
        39: SequenceLikelihood.UNLIKELY,  # 'C'
        41: SequenceLikelihood.UNLIKELY,  # 'D'
        48: SequenceLikelihood.UNLIKELY,  # 'E'
        52: SequenceLikelihood.UNLIKELY,  # 'F'
        49: SequenceLikelihood.UNLIKELY,  # 'G'
        54: SequenceLikelihood.UNLIKELY,  # 'H'
        43: SequenceLikelihood.UNLIKELY,  # 'I'
        47: SequenceLikelihood.UNLIKELY,  # 'J'
        37: SequenceLikelihood.UNLIKELY,  # 'K'
        50: SequenceLikelihood.UNLIKELY,  # 'L'
        35: SequenceLikelihood.UNLIKELY,  # 'M'
        36: SequenceLikelihood.UNLIKELY,  # 'N'
        40: SequenceLikelihood.UNLIKELY,  # 'O'
        30: SequenceLikelihood.UNLIKELY,  # 'P'
        64: SequenceLikelihood.UNLIKELY,  # 'Q'
        45: SequenceLikelihood.UNLIKELY,  # 'R'
        33: SequenceLikelihood.UNLIKELY,  # 'S'
        38: SequenceLikelihood.UNLIKELY,  # 'T'
        51: SequenceLikelihood.UNLIKELY,  # 'U'
        56: SequenceLikelihood.UNLIKELY,  # 'V'
        32: SequenceLikelihood.UNLIKELY,  # 'W'
        60: SequenceLikelihood.UNLIKELY,  # 'X'
        58: SequenceLikelihood.UNLIKELY,  # 'Y'
        44: SequenceLikelihood.UNLIKELY,  # 'Z'
        1: SequenceLikelihood.LIKELY,  # 'a'
        20: SequenceLikelihood.POSITIVE,  # 'b'
        11: SequenceLikelihood.POSITIVE,  # 'c'
        14: SequenceLikelihood.POSITIVE,  # 'd'
        2: SequenceLikelihood.LIKELY,  # 'e'
        31: SequenceLikelihood.POSITIVE,  # 'f'
        22: SequenceLikelihood.POSITIVE,  # 'g'
        23: SequenceLikelihood.UNLIKELY,  # 'h'
        3: SequenceLikelihood.UNLIKELY,  # 'i'
        19: SequenceLikelihood.POSITIVE,  # 'j'
        13: SequenceLikelihood.POSITIVE,  # 'k'
        18: SequenceLikelihood.POSITIVE,  # 'l'
        15: SequenceLikelihood.POSITIVE,  # 'm'
        5: SequenceLikelihood.POSITIVE,  # 'n'
        4: SequenceLikelihood.LIKELY,  # 'o'
        16: SequenceLikelihood.POSITIVE,  # 'p'
        63: SequenceLikelihood.UNLIKELY,  # 'q'
        7: SequenceLikelihood.POSITIVE,  # 'r'
        9: SequenceLikelihood.POSITIVE,  # 's'
        10: SequenceLikelihood.POSITIVE,  # 't'
        17: SequenceLikelihood.UNLIKELY,  # 'u'
        55: SequenceLikelihood.UNLIKELY,  # 'v'
        8: SequenceLikelihood.POSITIVE,  # 'w'
        57: SequenceLikelihood.UNLIKELY,  # 'x'
        12: SequenceLikelihood.UNLIKELY,  # 'y'
        6: SequenceLikelihood.POSITIVE,  # 'z'
        66: SequenceLikelihood.NEGATIVE,  # 'Ó'
        27: SequenceLikelihood.UNLIKELY,  # 'ó'
        67: SequenceLikelihood.NEGATIVE,  # 'Ą'
        25: SequenceLikelihood.UNLIKELY,  # 'ą'
        68: SequenceLikelihood.UNLIKELY,  # 'Ć'
        29: SequenceLikelihood.POSITIVE,  # 'ć'
        65: SequenceLikelihood.NEGATIVE,  # 'Ę'
        24: SequenceLikelihood.UNLIKELY,  # 'ę'
        61: SequenceLikelihood.UNLIKELY,  # 'Ł'
        21: SequenceLikelihood.POSITIVE,  # 'ł'
        70: SequenceLikelihood.UNLIKELY,  # 'Ń'
        42: SequenceLikelihood.LIKELY,  # 'ń'
        59: SequenceLikelihood.UNLIKELY,  # 'Ś'
        28: SequenceLikelihood.POSITIVE,  # 'ś'
        69: SequenceLikelihood.UNLIKELY,  # 'Ź'
        53: SequenceLikelihood.UNLIKELY,  # 'ź'
        62: SequenceLikelihood.UNLIKELY,  # 'Ż'
        26: SequenceLikelihood.POSITIVE,  # 'ż'
    },
    6: {  # 'z'
        34: SequenceLikelihood.UNLIKELY,  # 'A'
        46: SequenceLikelihood.UNLIKELY,  # 'B'
        39: SequenceLikelihood.UNLIKELY,  # 'C'
        41: SequenceLikelihood.UNLIKELY,  # 'D'
        48: SequenceLikelihood.UNLIKELY,  # 'E'
        52: SequenceLikelihood.UNLIKELY,  # 'F'
        49: SequenceLikelihood.UNLIKELY,  # 'G'
        54: SequenceLikelihood.UNLIKELY,  # 'H'
        43: SequenceLikelihood.UNLIKELY,  # 'I'
        47: SequenceLikelihood.UNLIKELY,  # 'J'
        37: SequenceLikelihood.UNLIKELY,  # 'K'
        50: SequenceLikelihood.UNLIKELY,  # 'L'
        35: SequenceLikelihood.UNLIKELY,  # 'M'
        36: SequenceLikelihood.UNLIKELY,  # 'N'
        40: SequenceLikelihood.UNLIKELY,  # 'O'
        30: SequenceLikelihood.UNLIKELY,  # 'P'
        64: SequenceLikelihood.UNLIKELY,  # 'Q'
        45: SequenceLikelihood.UNLIKELY,  # 'R'
        33: SequenceLikelihood.UNLIKELY,  # 'S'
        38: SequenceLikelihood.UNLIKELY,  # 'T'
        51: SequenceLikelihood.UNLIKELY,  # 'U'
        56: SequenceLikelihood.UNLIKELY,  # 'V'
        32: SequenceLikelihood.UNLIKELY,  # 'W'
        60: SequenceLikelihood.UNLIKELY,  # 'X'
        58: SequenceLikelihood.UNLIKELY,  # 'Y'
        44: SequenceLikelihood.UNLIKELY,  # 'Z'
        1: SequenceLikelihood.POSITIVE,  # 'a'
        20: SequenceLikelihood.POSITIVE,  # 'b'
        11: SequenceLikelihood.POSITIVE,  # 'c'
        14: SequenceLikelihood.POSITIVE,  # 'd'
        2: SequenceLikelihood.POSITIVE,  # 'e'
        31: SequenceLikelihood.UNLIKELY,  # 'f'
        22: SequenceLikelihood.POSITIVE,  # 'g'
        23: SequenceLikelihood.UNLIKELY,  # 'h'
        3: SequenceLikelihood.POSITIVE,  # 'i'
        19: SequenceLikelihood.POSITIVE,  # 'j'
        13: SequenceLikelihood.POSITIVE,  # 'k'
        18: SequenceLikelihood.POSITIVE,  # 'l'
        15: SequenceLikelihood.POSITIVE,  # 'm'
        5: SequenceLikelihood.POSITIVE,  # 'n'
        4: SequenceLikelihood.POSITIVE,  # 'o'
        16: SequenceLikelihood.POSITIVE,  # 'p'
        63: SequenceLikelihood.UNLIKELY,  # 'q'
        7: SequenceLikelihood.POSITIVE,  # 'r'
        9: SequenceLikelihood.LIKELY,  # 's'
        10: SequenceLikelihood.POSITIVE,  # 't'
        17: SequenceLikelihood.POSITIVE,  # 'u'
        55: SequenceLikelihood.UNLIKELY,  # 'v'
        8: SequenceLikelihood.POSITIVE,  # 'w'
        57: SequenceLikelihood.UNLIKELY,  # 'x'
        12: SequenceLikelihood.POSITIVE,  # 'y'
        6: SequenceLikelihood.LIKELY,  # 'z'
        66: SequenceLikelihood.UNLIKELY,  # 'Ó'
        27: SequenceLikelihood.LIKELY,  # 'ó'
        67: SequenceLikelihood.UNLIKELY,  # 'Ą'
        25: SequenceLikelihood.POSITIVE,  # 'ą'
        68: SequenceLikelihood.NEGATIVE,  # 'Ć'
        29: SequenceLikelihood.UNLIKELY,  # 'ć'
        65: SequenceLikelihood.UNLIKELY,  # 'Ę'
        24: SequenceLikelihood.POSITIVE,  # 'ę'
        61: SequenceLikelihood.UNLIKELY,  # 'Ł'
        21: SequenceLikelihood.POSITIVE,  # 'ł'
        70: SequenceLikelihood.NEGATIVE,  # 'Ń'
        42: SequenceLikelihood.UNLIKELY,  # 'ń'
        59: SequenceLikelihood.UNLIKELY,  # 'Ś'
        28: SequenceLikelihood.UNLIKELY,  # 'ś'
        69: SequenceLikelihood.UNLIKELY,  # 'Ź'
        53: SequenceLikelihood.UNLIKELY,  # 'ź'
        62: SequenceLikelihood.UNLIKELY,  # 'Ż'
        26: SequenceLikelihood.UNLIKELY,  # 'ż'
    },
    66: {  # 'Ó'
        34: SequenceLikelihood.NEGATIVE,  # 'A'
        46: SequenceLikelihood.UNLIKELY,  # 'B'
        39: SequenceLikelihood.UNLIKELY,  # 'C'
        41: SequenceLikelihood.UNLIKELY,  # 'D'
        48: SequenceLikelihood.NEGATIVE,  # 'E'
        52: SequenceLikelihood.UNLIKELY,  # 'F'
        49: SequenceLikelihood.UNLIKELY,  # 'G'
        54: SequenceLikelihood.NEGATIVE,  # 'H'
        43: SequenceLikelihood.NEGATIVE,  # 'I'
        47: SequenceLikelihood.UNLIKELY,  # 'J'
        37: SequenceLikelihood.UNLIKELY,  # 'K'
        50: SequenceLikelihood.UNLIKELY,  # 'L'
        35: SequenceLikelihood.NEGATIVE,  # 'M'
        36: SequenceLikelihood.UNLIKELY,  # 'N'
        40: SequenceLikelihood.NEGATIVE,  # 'O'
        30: SequenceLikelihood.UNLIKELY,  # 'P'
        64: SequenceLikelihood.NEGATIVE,  # 'Q'
        45: SequenceLikelihood.UNLIKELY,  # 'R'
        33: SequenceLikelihood.UNLIKELY,  # 'S'
        38: SequenceLikelihood.UNLIKELY,  # 'T'
        51: SequenceLikelihood.NEGATIVE,  # 'U'
        56: SequenceLikelihood.UNLIKELY,  # 'V'
        32: SequenceLikelihood.LIKELY,  # 'W'
        60: SequenceLikelihood.NEGATIVE,  # 'X'
        58: SequenceLikelihood.NEGATIVE,  # 'Y'
        44: SequenceLikelihood.UNLIKELY,  # 'Z'
        1: SequenceLikelihood.NEGATIVE,  # 'a'
        20: SequenceLikelihood.UNLIKELY,  # 'b'
        11: SequenceLikelihood.NEGATIVE,  # 'c'
        14: SequenceLikelihood.UNLIKELY,  # 'd'
        2: SequenceLikelihood.NEGATIVE,  # 'e'
        31: SequenceLikelihood.NEGATIVE,  # 'f'
        22: SequenceLikelihood.UNLIKELY,  # 'g'
        23: SequenceLikelihood.NEGATIVE,  # 'h'
        3: SequenceLikelihood.NEGATIVE,  # 'i'
        19: SequenceLikelihood.UNLIKELY,  # 'j'
        13: SequenceLikelihood.NEGATIVE,  # 'k'
        18: SequenceLikelihood.UNLIKELY,  # 'l'
        15: SequenceLikelihood.NEGATIVE,  # 'm'
        5: SequenceLikelihood.NEGATIVE,  # 'n'
        4: SequenceLikelihood.NEGATIVE,  # 'o'
        16: SequenceLikelihood.UNLIKELY,  # 'p'
        63: SequenceLikelihood.NEGATIVE,  # 'q'
        7: SequenceLikelihood.UNLIKELY,  # 'r'
        9: SequenceLikelihood.UNLIKELY,  # 's'
        10: SequenceLikelihood.UNLIKELY,  # 't'
        17: SequenceLikelihood.NEGATIVE,  # 'u'
        55: SequenceLikelihood.NEGATIVE,  # 'v'
        8: SequenceLikelihood.UNLIKELY,  # 'w'
        57: SequenceLikelihood.NEGATIVE,  # 'x'
        12: SequenceLikelihood.NEGATIVE,  # 'y'
        6: SequenceLikelihood.UNLIKELY,  # 'z'
        66: SequenceLikelihood.NEGATIVE,  # 'Ó'
        27: SequenceLikelihood.NEGATIVE,  # 'ó'
        67: SequenceLikelihood.NEGATIVE,  # 'Ą'
        25: SequenceLikelihood.NEGATIVE,  # 'ą'
        68: SequenceLikelihood.UNLIKELY,  # 'Ć'
        29: SequenceLikelihood.NEGATIVE,  # 'ć'
        65: SequenceLikelihood.NEGATIVE,  # 'Ę'
        24: SequenceLikelihood.NEGATIVE,  # 'ę'
        61: SequenceLikelihood.UNLIKELY,  # 'Ł'
        21: SequenceLikelihood.UNLIKELY,  # 'ł'
        70: SequenceLikelihood.NEGATIVE,  # 'Ń'
        42: SequenceLikelihood.NEGATIVE,  # 'ń'
        59: SequenceLikelihood.UNLIKELY,  # 'Ś'
        28: SequenceLikelihood.UNLIKELY,  # 'ś'
        69: SequenceLikelihood.UNLIKELY,  # 'Ź'
        53: SequenceLikelihood.NEGATIVE,  # 'ź'
        62: SequenceLikelihood.UNLIKELY,  # 'Ż'
        26: SequenceLikelihood.UNLIKELY,  # 'ż'
    },
    27: {  # 'ó'
        34: SequenceLikelihood.NEGATIVE,  # 'A'
        46: SequenceLikelihood.UNLIKELY,  # 'B'
        39: SequenceLikelihood.UNLIKELY,  # 'C'
        41: SequenceLikelihood.UNLIKELY,  # 'D'
        48: SequenceLikelihood.NEGATIVE,  # 'E'
        52: SequenceLikelihood.NEGATIVE,  # 'F'
        49: SequenceLikelihood.NEGATIVE,  # 'G'
        54: SequenceLikelihood.NEGATIVE,  # 'H'
        43: SequenceLikelihood.NEGATIVE,  # 'I'
        47: SequenceLikelihood.UNLIKELY,  # 'J'
        37: SequenceLikelihood.NEGATIVE,  # 'K'
        50: SequenceLikelihood.UNLIKELY,  # 'L'
        35: SequenceLikelihood.NEGATIVE,  # 'M'
        36: SequenceLikelihood.NEGATIVE,  # 'N'
        40: SequenceLikelihood.NEGATIVE,  # 'O'
        30: SequenceLikelihood.UNLIKELY,  # 'P'
        64: SequenceLikelihood.NEGATIVE,  # 'Q'
        45: SequenceLikelihood.UNLIKELY,  # 'R'
        33: SequenceLikelihood.NEGATIVE,  # 'S'
        38: SequenceLikelihood.NEGATIVE,  # 'T'
        51: SequenceLikelihood.NEGATIVE,  # 'U'
        56: SequenceLikelihood.NEGATIVE,  # 'V'
        32: SequenceLikelihood.UNLIKELY,  # 'W'
        60: SequenceLikelihood.NEGATIVE,  # 'X'
        58: SequenceLikelihood.NEGATIVE,  # 'Y'
        44: SequenceLikelihood.UNLIKELY,  # 'Z'
        1: SequenceLikelihood.UNLIKELY,  # 'a'
        20: SequenceLikelihood.POSITIVE,  # 'b'
        11: SequenceLikelihood.POSITIVE,  # 'c'
        14: SequenceLikelihood.POSITIVE,  # 'd'
        2: SequenceLikelihood.UNLIKELY,  # 'e'
        31: SequenceLikelihood.UNLIKELY,  # 'f'
        22: SequenceLikelihood.LIKELY,  # 'g'
        23: SequenceLikelihood.UNLIKELY,  # 'h'
        3: SequenceLikelihood.UNLIKELY,  # 'i'
        19: SequenceLikelihood.POSITIVE,  # 'j'
        13: SequenceLikelihood.LIKELY,  # 'k'
        18: SequenceLikelihood.POSITIVE,  # 'l'
        15: SequenceLikelihood.UNLIKELY,  # 'm'
        5: SequenceLikelihood.UNLIKELY,  # 'n'
        4: SequenceLikelihood.UNLIKELY,  # 'o'
        16: SequenceLikelihood.UNLIKELY,  # 'p'
        63: SequenceLikelihood.UNLIKELY,  # 'q'
        7: SequenceLikelihood.POSITIVE,  # 'r'
        9: SequenceLikelihood.LIKELY,  # 's'
        10: SequenceLikelihood.LIKELY,  # 't'
        17: SequenceLikelihood.UNLIKELY,  # 'u'
        55: SequenceLikelihood.UNLIKELY,  # 'v'
        8: SequenceLikelihood.POSITIVE,  # 'w'
        57: SequenceLikelihood.UNLIKELY,  # 'x'
        12: SequenceLikelihood.UNLIKELY,  # 'y'
        6: SequenceLikelihood.LIKELY,  # 'z'
        66: SequenceLikelihood.NEGATIVE,  # 'Ó'
        27: SequenceLikelihood.UNLIKELY,  # 'ó'
        67: SequenceLikelihood.UNLIKELY,  # 'Ą'
        25: SequenceLikelihood.UNLIKELY,  # 'ą'
        68: SequenceLikelihood.NEGATIVE,  # 'Ć'
        29: SequenceLikelihood.UNLIKELY,  # 'ć'
        65: SequenceLikelihood.NEGATIVE,  # 'Ę'
        24: SequenceLikelihood.NEGATIVE,  # 'ę'
        61: SequenceLikelihood.UNLIKELY,  # 'Ł'
        21: SequenceLikelihood.POSITIVE,  # 'ł'
        70: SequenceLikelihood.NEGATIVE,  # 'Ń'
        42: SequenceLikelihood.UNLIKELY,  # 'ń'
        59: SequenceLikelihood.NEGATIVE,  # 'Ś'
        28: SequenceLikelihood.UNLIKELY,  # 'ś'
        69: SequenceLikelihood.NEGATIVE,  # 'Ź'
        53: SequenceLikelihood.LIKELY,  # 'ź'
        62: SequenceLikelihood.NEGATIVE,  # 'Ż'
        26: SequenceLikelihood.POSITIVE,  # 'ż'
    },
    67: {  # 'Ą'
        34: SequenceLikelihood.NEGATIVE,  # 'A'
        46: SequenceLikelihood.UNLIKELY,  # 'B'
        39: SequenceLikelihood.UNLIKELY,  # 'C'
        41: SequenceLikelihood.UNLIKELY,  # 'D'
        48: SequenceLikelihood.NEGATIVE,  # 'E'
        52: SequenceLikelihood.NEGATIVE,  # 'F'
        49: SequenceLikelihood.UNLIKELY,  # 'G'
        54: SequenceLikelihood.NEGATIVE,  # 'H'
        43: SequenceLikelihood.NEGATIVE,  # 'I'
        47: SequenceLikelihood.UNLIKELY,  # 'J'
        37: SequenceLikelihood.UNLIKELY,  # 'K'
        50: SequenceLikelihood.UNLIKELY,  # 'L'
        35: SequenceLikelihood.UNLIKELY,  # 'M'
        36: SequenceLikelihood.UNLIKELY,  # 'N'
        40: SequenceLikelihood.NEGATIVE,  # 'O'
        30: SequenceLikelihood.UNLIKELY,  # 'P'
        64: SequenceLikelihood.NEGATIVE,  # 'Q'
        45: SequenceLikelihood.NEGATIVE,  # 'R'
        33: SequenceLikelihood.UNLIKELY,  # 'S'
        38: SequenceLikelihood.UNLIKELY,  # 'T'
        51: SequenceLikelihood.NEGATIVE,  # 'U'
        56: SequenceLikelihood.NEGATIVE,  # 'V'
        32: SequenceLikelihood.UNLIKELY,  # 'W'
        60: SequenceLikelihood.NEGATIVE,  # 'X'
        58: SequenceLikelihood.NEGATIVE,  # 'Y'
        44: SequenceLikelihood.UNLIKELY,  # 'Z'
        1: SequenceLikelihood.NEGATIVE,  # 'a'
        20: SequenceLikelihood.UNLIKELY,  # 'b'
        11: SequenceLikelihood.UNLIKELY,  # 'c'
        14: SequenceLikelihood.UNLIKELY,  # 'd'
        2: SequenceLikelihood.NEGATIVE,  # 'e'
        31: SequenceLikelihood.NEGATIVE,  # 'f'
        22: SequenceLikelihood.UNLIKELY,  # 'g'
        23: SequenceLikelihood.NEGATIVE,  # 'h'
        3: SequenceLikelihood.NEGATIVE,  # 'i'
        19: SequenceLikelihood.NEGATIVE,  # 'j'
        13: SequenceLikelihood.NEGATIVE,  # 'k'
        18: SequenceLikelihood.NEGATIVE,  # 'l'
        15: SequenceLikelihood.UNLIKELY,  # 'm'
        5: SequenceLikelihood.UNLIKELY,  # 'n'
        4: SequenceLikelihood.NEGATIVE,  # 'o'
        16: SequenceLikelihood.UNLIKELY,  # 'p'
        63: SequenceLikelihood.NEGATIVE,  # 'q'
        7: SequenceLikelihood.NEGATIVE,  # 'r'
        9: SequenceLikelihood.UNLIKELY,  # 's'
        10: SequenceLikelihood.UNLIKELY,  # 't'
        17: SequenceLikelihood.NEGATIVE,  # 'u'
        55: SequenceLikelihood.NEGATIVE,  # 'v'
        8: SequenceLikelihood.NEGATIVE,  # 'w'
        57: SequenceLikelihood.NEGATIVE,  # 'x'
        12: SequenceLikelihood.NEGATIVE,  # 'y'
        6: SequenceLikelihood.NEGATIVE,  # 'z'
        66: SequenceLikelihood.NEGATIVE,  # 'Ó'
        27: SequenceLikelihood.NEGATIVE,  # 'ó'
        67: SequenceLikelihood.UNLIKELY,  # 'Ą'
        25: SequenceLikelihood.NEGATIVE,  # 'ą'
        68: SequenceLikelihood.UNLIKELY,  # 'Ć'
        29: SequenceLikelihood.NEGATIVE,  # 'ć'
        65: SequenceLikelihood.NEGATIVE,  # 'Ę'
        24: SequenceLikelihood.NEGATIVE,  # 'ę'
        61: SequenceLikelihood.UNLIKELY,  # 'Ł'
        21: SequenceLikelihood.UNLIKELY,  # 'ł'
        70: SequenceLikelihood.NEGATIVE,  # 'Ń'
        42: SequenceLikelihood.NEGATIVE,  # 'ń'
        59: SequenceLikelihood.UNLIKELY,  # 'Ś'
        28: SequenceLikelihood.UNLIKELY,  # 'ś'
        69: SequenceLikelihood.NEGATIVE,  # 'Ź'
        53: SequenceLikelihood.NEGATIVE,  # 'ź'
        62: SequenceLikelihood.UNLIKELY,  # 'Ż'
        26: SequenceLikelihood.UNLIKELY,  # 'ż'
    },
    25: {  # 'ą'
        34: SequenceLikelihood.UNLIKELY,  # 'A'
        46: SequenceLikelihood.UNLIKELY,  # 'B'
        39: SequenceLikelihood.UNLIKELY,  # 'C'
        41: SequenceLikelihood.UNLIKELY,  # 'D'
        48: SequenceLikelihood.UNLIKELY,  # 'E'
        52: SequenceLikelihood.UNLIKELY,  # 'F'
        49: SequenceLikelihood.UNLIKELY,  # 'G'
        54: SequenceLikelihood.UNLIKELY,  # 'H'
        43: SequenceLikelihood.UNLIKELY,  # 'I'
        47: SequenceLikelihood.UNLIKELY,  # 'J'
        37: SequenceLikelihood.UNLIKELY,  # 'K'
        50: SequenceLikelihood.UNLIKELY,  # 'L'
        35: SequenceLikelihood.UNLIKELY,  # 'M'
        36: SequenceLikelihood.UNLIKELY,  # 'N'
        40: SequenceLikelihood.UNLIKELY,  # 'O'
        30: SequenceLikelihood.UNLIKELY,  # 'P'
        64: SequenceLikelihood.NEGATIVE,  # 'Q'
        45: SequenceLikelihood.UNLIKELY,  # 'R'
        33: SequenceLikelihood.UNLIKELY,  # 'S'
        38: SequenceLikelihood.UNLIKELY,  # 'T'
        51: SequenceLikelihood.UNLIKELY,  # 'U'
        56: SequenceLikelihood.NEGATIVE,  # 'V'
        32: SequenceLikelihood.UNLIKELY,  # 'W'
        60: SequenceLikelihood.NEGATIVE,  # 'X'
        58: SequenceLikelihood.UNLIKELY,  # 'Y'
        44: SequenceLikelihood.UNLIKELY,  # 'Z'
        1: SequenceLikelihood.UNLIKELY,  # 'a'
        20: SequenceLikelihood.LIKELY,  # 'b'
        11: SequenceLikelihood.POSITIVE,  # 'c'
        14: SequenceLikelihood.POSITIVE,  # 'd'
        2: SequenceLikelihood.UNLIKELY,  # 'e'
        31: SequenceLikelihood.UNLIKELY,  # 'f'
        22: SequenceLikelihood.POSITIVE,  # 'g'
        23: SequenceLikelihood.UNLIKELY,  # 'h'
        3: SequenceLikelihood.UNLIKELY,  # 'i'
        19: SequenceLikelihood.UNLIKELY,  # 'j'
        13: SequenceLikelihood.LIKELY,  # 'k'
        18: SequenceLikelihood.UNLIKELY,  # 'l'
        15: SequenceLikelihood.UNLIKELY,  # 'm'
        5: SequenceLikelihood.UNLIKELY,  # 'n'
        4: SequenceLikelihood.UNLIKELY,  # 'o'
        16: SequenceLikelihood.LIKELY,  # 'p'
        63: SequenceLikelihood.NEGATIVE,  # 'q'
        7: SequenceLikelihood.UNLIKELY,  # 'r'
        9: SequenceLikelihood.LIKELY,  # 's'
        10: SequenceLikelihood.POSITIVE,  # 't'
        17: SequenceLikelihood.UNLIKELY,  # 'u'
        55: SequenceLikelihood.UNLIKELY,  # 'v'
        8: SequenceLikelihood.UNLIKELY,  # 'w'
        57: SequenceLikelihood.UNLIKELY,  # 'x'
        12: SequenceLikelihood.UNLIKELY,  # 'y'
        6: SequenceLikelihood.POSITIVE,  # 'z'
        66: SequenceLikelihood.NEGATIVE,  # 'Ó'
        27: SequenceLikelihood.NEGATIVE,  # 'ó'
        67: SequenceLikelihood.NEGATIVE,  # 'Ą'
        25: SequenceLikelihood.UNLIKELY,  # 'ą'
        68: SequenceLikelihood.UNLIKELY,  # 'Ć'
        29: SequenceLikelihood.POSITIVE,  # 'ć'
        65: SequenceLikelihood.NEGATIVE,  # 'Ę'
        24: SequenceLikelihood.UNLIKELY,  # 'ę'
        61: SequenceLikelihood.NEGATIVE,  # 'Ł'
        21: SequenceLikelihood.LIKELY,  # 'ł'
        70: SequenceLikelihood.NEGATIVE,  # 'Ń'
        42: SequenceLikelihood.UNLIKELY,  # 'ń'
        59: SequenceLikelihood.UNLIKELY,  # 'Ś'
        28: SequenceLikelihood.UNLIKELY,  # 'ś'
        69: SequenceLikelihood.UNLIKELY,  # 'Ź'
        53: SequenceLikelihood.UNLIKELY,  # 'ź'
        62: SequenceLikelihood.UNLIKELY,  # 'Ż'
        26: SequenceLikelihood.POSITIVE,  # 'ż'
    },
    68: {  # 'Ć'
        34: SequenceLikelihood.UNLIKELY,  # 'A'
        46: SequenceLikelihood.NEGATIVE,  # 'B'
        39: SequenceLikelihood.UNLIKELY,  # 'C'
        41: SequenceLikelihood.UNLIKELY,  # 'D'
        48: SequenceLikelihood.NEGATIVE,  # 'E'
        52: SequenceLikelihood.UNLIKELY,  # 'F'
        49: SequenceLikelihood.NEGATIVE,  # 'G'
        54: SequenceLikelihood.NEGATIVE,  # 'H'
        43: SequenceLikelihood.UNLIKELY,  # 'I'
        47: SequenceLikelihood.NEGATIVE,  # 'J'
        37: SequenceLikelihood.UNLIKELY,  # 'K'
        50: SequenceLikelihood.NEGATIVE,  # 'L'
        35: SequenceLikelihood.UNLIKELY,  # 'M'
        36: SequenceLikelihood.UNLIKELY,  # 'N'
        40: SequenceLikelihood.UNLIKELY,  # 'O'
        30: SequenceLikelihood.UNLIKELY,  # 'P'
        64: SequenceLikelihood.NEGATIVE,  # 'Q'
        45: SequenceLikelihood.NEGATIVE,  # 'R'
        33: SequenceLikelihood.UNLIKELY,  # 'S'
        38: SequenceLikelihood.NEGATIVE,  # 'T'
        51: SequenceLikelihood.UNLIKELY,  # 'U'
        56: SequenceLikelihood.NEGATIVE,  # 'V'
        32: SequenceLikelihood.UNLIKELY,  # 'W'
        60: SequenceLikelihood.NEGATIVE,  # 'X'
        58: SequenceLikelihood.NEGATIVE,  # 'Y'
        44: SequenceLikelihood.UNLIKELY,  # 'Z'
        1: SequenceLikelihood.UNLIKELY,  # 'a'
        20: SequenceLikelihood.NEGATIVE,  # 'b'
        11: SequenceLikelihood.NEGATIVE,  # 'c'
        14: SequenceLikelihood.NEGATIVE,  # 'd'
        2: SequenceLikelihood.UNLIKELY,  # 'e'
        31: SequenceLikelihood.NEGATIVE,  # 'f'
        22: SequenceLikelihood.NEGATIVE,  # 'g'
        23: SequenceLikelihood.NEGATIVE,  # 'h'
        3: SequenceLikelihood.UNLIKELY,  # 'i'
        19: SequenceLikelihood.NEGATIVE,  # 'j'
        13: SequenceLikelihood.NEGATIVE,  # 'k'
        18: SequenceLikelihood.NEGATIVE,  # 'l'
        15: SequenceLikelihood.UNLIKELY,  # 'm'
        5: SequenceLikelihood.NEGATIVE,  # 'n'
        4: SequenceLikelihood.UNLIKELY,  # 'o'
        16: SequenceLikelihood.UNLIKELY,  # 'p'
        63: SequenceLikelihood.NEGATIVE,  # 'q'
        7: SequenceLikelihood.UNLIKELY,  # 'r'
        9: SequenceLikelihood.NEGATIVE,  # 's'
        10: SequenceLikelihood.NEGATIVE,  # 't'
        17: SequenceLikelihood.UNLIKELY,  # 'u'
        55: SequenceLikelihood.NEGATIVE,  # 'v'
        8: SequenceLikelihood.UNLIKELY,  # 'w'
        57: SequenceLikelihood.NEGATIVE,  # 'x'
        12: SequenceLikelihood.NEGATIVE,  # 'y'
        6: SequenceLikelihood.NEGATIVE,  # 'z'
        66: SequenceLikelihood.NEGATIVE,  # 'Ó'
        27: SequenceLikelihood.NEGATIVE,  # 'ó'
        67: SequenceLikelihood.NEGATIVE,  # 'Ą'
        25: SequenceLikelihood.NEGATIVE,  # 'ą'
        68: SequenceLikelihood.NEGATIVE,  # 'Ć'
        29: SequenceLikelihood.NEGATIVE,  # 'ć'
        65: SequenceLikelihood.NEGATIVE,  # 'Ę'
        24: SequenceLikelihood.NEGATIVE,  # 'ę'
        61: SequenceLikelihood.UNLIKELY,  # 'Ł'
        21: SequenceLikelihood.NEGATIVE,  # 'ł'
        70: SequenceLikelihood.NEGATIVE,  # 'Ń'
        42: SequenceLikelihood.NEGATIVE,  # 'ń'
        59: SequenceLikelihood.NEGATIVE,  # 'Ś'
        28: SequenceLikelihood.UNLIKELY,  # 'ś'
        69: SequenceLikelihood.NEGATIVE,  # 'Ź'
        53: SequenceLikelihood.NEGATIVE,  # 'ź'
        62: SequenceLikelihood.NEGATIVE,  # 'Ż'
        26: SequenceLikelihood.NEGATIVE,  # 'ż'
    },
    29: {  # 'ć'
        34: SequenceLikelihood.UNLIKELY,  # 'A'
        46: SequenceLikelihood.UNLIKELY,  # 'B'
        39: SequenceLikelihood.UNLIKELY,  # 'C'
        41: SequenceLikelihood.UNLIKELY,  # 'D'
        48: SequenceLikelihood.UNLIKELY,  # 'E'
        52: SequenceLikelihood.UNLIKELY,  # 'F'
        49: SequenceLikelihood.UNLIKELY,  # 'G'
        54: SequenceLikelihood.UNLIKELY,  # 'H'
        43: SequenceLikelihood.UNLIKELY,  # 'I'
        47: SequenceLikelihood.UNLIKELY,  # 'J'
        37: SequenceLikelihood.UNLIKELY,  # 'K'
        50: SequenceLikelihood.UNLIKELY,  # 'L'
        35: SequenceLikelihood.UNLIKELY,  # 'M'
        36: SequenceLikelihood.UNLIKELY,  # 'N'
        40: SequenceLikelihood.UNLIKELY,  # 'O'
        30: SequenceLikelihood.UNLIKELY,  # 'P'
        64: SequenceLikelihood.NEGATIVE,  # 'Q'
        45: SequenceLikelihood.UNLIKELY,  # 'R'
        33: SequenceLikelihood.UNLIKELY,  # 'S'
        38: SequenceLikelihood.UNLIKELY,  # 'T'
        51: SequenceLikelihood.UNLIKELY,  # 'U'
        56: SequenceLikelihood.UNLIKELY,  # 'V'
        32: SequenceLikelihood.UNLIKELY,  # 'W'
        60: SequenceLikelihood.NEGATIVE,  # 'X'
        58: SequenceLikelihood.UNLIKELY,  # 'Y'
        44: SequenceLikelihood.UNLIKELY,  # 'Z'
        1: SequenceLikelihood.UNLIKELY,  # 'a'
        20: SequenceLikelihood.UNLIKELY,  # 'b'
        11: SequenceLikelihood.UNLIKELY,  # 'c'
        14: SequenceLikelihood.UNLIKELY,  # 'd'
        2: SequenceLikelihood.UNLIKELY,  # 'e'
        31: SequenceLikelihood.UNLIKELY,  # 'f'
        22: SequenceLikelihood.UNLIKELY,  # 'g'
        23: SequenceLikelihood.UNLIKELY,  # 'h'
        3: SequenceLikelihood.UNLIKELY,  # 'i'
        19: SequenceLikelihood.UNLIKELY,  # 'j'
        13: SequenceLikelihood.UNLIKELY,  # 'k'
        18: SequenceLikelihood.UNLIKELY,  # 'l'
        15: SequenceLikelihood.LIKELY,  # 'm'
        5: SequenceLikelihood.UNLIKELY,  # 'n'
        4: SequenceLikelihood.UNLIKELY,  # 'o'
        16: SequenceLikelihood.UNLIKELY,  # 'p'
        63: SequenceLikelihood.NEGATIVE,  # 'q'
        7: SequenceLikelihood.UNLIKELY,  # 'r'
        9: SequenceLikelihood.UNLIKELY,  # 's'
        10: SequenceLikelihood.UNLIKELY,  # 't'
        17: SequenceLikelihood.UNLIKELY,  # 'u'
        55: SequenceLikelihood.UNLIKELY,  # 'v'
        8: SequenceLikelihood.LIKELY,  # 'w'
        57: SequenceLikelihood.UNLIKELY,  # 'x'
        12: SequenceLikelihood.UNLIKELY,  # 'y'
        6: SequenceLikelihood.UNLIKELY,  # 'z'
        66: SequenceLikelihood.NEGATIVE,  # 'Ó'
        27: SequenceLikelihood.UNLIKELY,  # 'ó'
        67: SequenceLikelihood.NEGATIVE,  # 'Ą'
        25: SequenceLikelihood.NEGATIVE,  # 'ą'
        68: SequenceLikelihood.NEGATIVE,  # 'Ć'
        29: SequenceLikelihood.UNLIKELY,  # 'ć'
        65: SequenceLikelihood.NEGATIVE,  # 'Ę'
        24: SequenceLikelihood.NEGATIVE,  # 'ę'
        61: SequenceLikelihood.NEGATIVE,  # 'Ł'
        21: SequenceLikelihood.UNLIKELY,  # 'ł'
        70: SequenceLikelihood.NEGATIVE,  # 'Ń'
        42: SequenceLikelihood.NEGATIVE,  # 'ń'
        59: SequenceLikelihood.UNLIKELY,  # 'Ś'
        28: SequenceLikelihood.UNLIKELY,  # 'ś'
        69: SequenceLikelihood.UNLIKELY,  # 'Ź'
        53: SequenceLikelihood.NEGATIVE,  # 'ź'
        62: SequenceLikelihood.UNLIKELY,  # 'Ż'
        26: SequenceLikelihood.UNLIKELY,  # 'ż'
    },
    65: {  # 'Ę'
        34: SequenceLikelihood.NEGATIVE,  # 'A'
        46: SequenceLikelihood.UNLIKELY,  # 'B'
        39: SequenceLikelihood.UNLIKELY,  # 'C'
        41: SequenceLikelihood.UNLIKELY,  # 'D'
        48: SequenceLikelihood.NEGATIVE,  # 'E'
        52: SequenceLikelihood.UNLIKELY,  # 'F'
        49: SequenceLikelihood.UNLIKELY,  # 'G'
        54: SequenceLikelihood.NEGATIVE,  # 'H'
        43: SequenceLikelihood.NEGATIVE,  # 'I'
        47: SequenceLikelihood.UNLIKELY,  # 'J'
        37: SequenceLikelihood.UNLIKELY,  # 'K'
        50: SequenceLikelihood.UNLIKELY,  # 'L'
        35: SequenceLikelihood.NEGATIVE,  # 'M'
        36: SequenceLikelihood.UNLIKELY,  # 'N'
        40: SequenceLikelihood.UNLIKELY,  # 'O'
        30: SequenceLikelihood.UNLIKELY,  # 'P'
        64: SequenceLikelihood.NEGATIVE,  # 'Q'
        45: SequenceLikelihood.NEGATIVE,  # 'R'
        33: SequenceLikelihood.UNLIKELY,  # 'S'
        38: SequenceLikelihood.UNLIKELY,  # 'T'
        51: SequenceLikelihood.NEGATIVE,  # 'U'
        56: SequenceLikelihood.NEGATIVE,  # 'V'
        32: SequenceLikelihood.UNLIKELY,  # 'W'
        60: SequenceLikelihood.UNLIKELY,  # 'X'
        58: SequenceLikelihood.NEGATIVE,  # 'Y'
        44: SequenceLikelihood.UNLIKELY,  # 'Z'
        1: SequenceLikelihood.NEGATIVE,  # 'a'
        20: SequenceLikelihood.UNLIKELY,  # 'b'
        11: SequenceLikelihood.UNLIKELY,  # 'c'
        14: SequenceLikelihood.UNLIKELY,  # 'd'
        2: SequenceLikelihood.NEGATIVE,  # 'e'
        31: SequenceLikelihood.NEGATIVE,  # 'f'
        22: SequenceLikelihood.UNLIKELY,  # 'g'
        23: SequenceLikelihood.NEGATIVE,  # 'h'
        3: SequenceLikelihood.UNLIKELY,  # 'i'
        19: SequenceLikelihood.NEGATIVE,  # 'j'
        13: SequenceLikelihood.UNLIKELY,  # 'k'
        18: SequenceLikelihood.NEGATIVE,  # 'l'
        15: SequenceLikelihood.UNLIKELY,  # 'm'
        5: SequenceLikelihood.NEGATIVE,  # 'n'
        4: SequenceLikelihood.NEGATIVE,  # 'o'
        16: SequenceLikelihood.UNLIKELY,  # 'p'
        63: SequenceLikelihood.NEGATIVE,  # 'q'
        7: SequenceLikelihood.NEGATIVE,  # 'r'
        9: SequenceLikelihood.UNLIKELY,  # 's'
        10: SequenceLikelihood.UNLIKELY,  # 't'
        17: SequenceLikelihood.NEGATIVE,  # 'u'
        55: SequenceLikelihood.NEGATIVE,  # 'v'
        8: SequenceLikelihood.NEGATIVE,  # 'w'
        57: SequenceLikelihood.NEGATIVE,  # 'x'
        12: SequenceLikelihood.UNLIKELY,  # 'y'
        6: SequenceLikelihood.UNLIKELY,  # 'z'
        66: SequenceLikelihood.NEGATIVE,  # 'Ó'
        27: SequenceLikelihood.NEGATIVE,  # 'ó'
        67: SequenceLikelihood.UNLIKELY,  # 'Ą'
        25: SequenceLikelihood.NEGATIVE,  # 'ą'
        68: SequenceLikelihood.UNLIKELY,  # 'Ć'
        29: SequenceLikelihood.NEGATIVE,  # 'ć'
        65: SequenceLikelihood.UNLIKELY,  # 'Ę'
        24: SequenceLikelihood.NEGATIVE,  # 'ę'
        61: SequenceLikelihood.UNLIKELY,  # 'Ł'
        21: SequenceLikelihood.UNLIKELY,  # 'ł'
        70: SequenceLikelihood.NEGATIVE,  # 'Ń'
        42: SequenceLikelihood.NEGATIVE,  # 'ń'
        59: SequenceLikelihood.UNLIKELY,  # 'Ś'
        28: SequenceLikelihood.NEGATIVE,  # 'ś'
        69: SequenceLikelihood.UNLIKELY,  # 'Ź'
        53: SequenceLikelihood.NEGATIVE,  # 'ź'
        62: SequenceLikelihood.UNLIKELY,  # 'Ż'
        26: SequenceLikelihood.UNLIKELY,  # 'ż'
    },
    24: {  # 'ę'
        34: SequenceLikelihood.UNLIKELY,  # 'A'
        46: SequenceLikelihood.UNLIKELY,  # 'B'
        39: SequenceLikelihood.UNLIKELY,  # 'C'
        41: SequenceLikelihood.UNLIKELY,  # 'D'
        48: SequenceLikelihood.UNLIKELY,  # 'E'
        52: SequenceLikelihood.UNLIKELY,  # 'F'
        49: SequenceLikelihood.UNLIKELY,  # 'G'
        54: SequenceLikelihood.UNLIKELY,  # 'H'
        43: SequenceLikelihood.UNLIKELY,  # 'I'
        47: SequenceLikelihood.UNLIKELY,  # 'J'
        37: SequenceLikelihood.UNLIKELY,  # 'K'
        50: SequenceLikelihood.UNLIKELY,  # 'L'
        35: SequenceLikelihood.UNLIKELY,  # 'M'
        36: SequenceLikelihood.UNLIKELY,  # 'N'
        40: SequenceLikelihood.UNLIKELY,  # 'O'
        30: SequenceLikelihood.UNLIKELY,  # 'P'
        64: SequenceLikelihood.NEGATIVE,  # 'Q'
        45: SequenceLikelihood.UNLIKELY,  # 'R'
        33: SequenceLikelihood.UNLIKELY,  # 'S'
        38: SequenceLikelihood.UNLIKELY,  # 'T'
        51: SequenceLikelihood.UNLIKELY,  # 'U'
        56: SequenceLikelihood.UNLIKELY,  # 'V'
        32: SequenceLikelihood.UNLIKELY,  # 'W'
        60: SequenceLikelihood.UNLIKELY,  # 'X'
        58: SequenceLikelihood.UNLIKELY,  # 'Y'
        44: SequenceLikelihood.UNLIKELY,  # 'Z'
        1: SequenceLikelihood.UNLIKELY,  # 'a'
        20: SequenceLikelihood.POSITIVE,  # 'b'
        11: SequenceLikelihood.POSITIVE,  # 'c'
        14: SequenceLikelihood.POSITIVE,  # 'd'
        2: SequenceLikelihood.UNLIKELY,  # 'e'
        31: SequenceLikelihood.UNLIKELY,  # 'f'
        22: SequenceLikelihood.POSITIVE,  # 'g'
        23: SequenceLikelihood.UNLIKELY,  # 'h'
        3: SequenceLikelihood.UNLIKELY,  # 'i'
        19: SequenceLikelihood.UNLIKELY,  # 'j'
        13: SequenceLikelihood.POSITIVE,  # 'k'
        18: SequenceLikelihood.LIKELY,  # 'l'
        15: SequenceLikelihood.UNLIKELY,  # 'm'
        5: SequenceLikelihood.UNLIKELY,  # 'n'
        4: SequenceLikelihood.UNLIKELY,  # 'o'
        16: SequenceLikelihood.POSITIVE,  # 'p'
        63: SequenceLikelihood.NEGATIVE,  # 'q'
        7: SequenceLikelihood.UNLIKELY,  # 'r'
        9: SequenceLikelihood.POSITIVE,  # 's'
        10: SequenceLikelihood.POSITIVE,  # 't'
        17: SequenceLikelihood.UNLIKELY,  # 'u'
        55: SequenceLikelihood.NEGATIVE,  # 'v'
        8: SequenceLikelihood.UNLIKELY,  # 'w'
        57: SequenceLikelihood.UNLIKELY,  # 'x'
        12: SequenceLikelihood.UNLIKELY,  # 'y'
        6: SequenceLikelihood.LIKELY,  # 'z'
        66: SequenceLikelihood.NEGATIVE,  # 'Ó'
        27: SequenceLikelihood.NEGATIVE,  # 'ó'
        67: SequenceLikelihood.NEGATIVE,  # 'Ą'
        25: SequenceLikelihood.NEGATIVE,  # 'ą'
        68: SequenceLikelihood.NEGATIVE,  # 'Ć'
        29: SequenceLikelihood.LIKELY,  # 'ć'
        65: SequenceLikelihood.NEGATIVE,  # 'Ę'
        24: SequenceLikelihood.UNLIKELY,  # 'ę'
        61: SequenceLikelihood.NEGATIVE,  # 'Ł'
        21: SequenceLikelihood.LIKELY,  # 'ł'
        70: SequenceLikelihood.NEGATIVE,  # 'Ń'
        42: SequenceLikelihood.UNLIKELY,  # 'ń'
        59: SequenceLikelihood.UNLIKELY,  # 'Ś'
        28: SequenceLikelihood.POSITIVE,  # 'ś'
        69: SequenceLikelihood.NEGATIVE,  # 'Ź'
        53: SequenceLikelihood.UNLIKELY,  # 'ź'
        62: SequenceLikelihood.NEGATIVE,  # 'Ż'
        26: SequenceLikelihood.POSITIVE,  # 'ż'
    },
    61: {  # 'Ł'
        34: SequenceLikelihood.UNLIKELY,  # 'A'
        46: SequenceLikelihood.UNLIKELY,  # 'B'
        39: SequenceLikelihood.UNLIKELY,  # 'C'
        41: SequenceLikelihood.UNLIKELY,  # 'D'
        48: SequenceLikelihood.UNLIKELY,  # 'E'
        52: SequenceLikelihood.UNLIKELY,  # 'F'
        49: SequenceLikelihood.UNLIKELY,  # 'G'
        54: SequenceLikelihood.UNLIKELY,  # 'H'
        43: SequenceLikelihood.UNLIKELY,  # 'I'
        47: SequenceLikelihood.UNLIKELY,  # 'J'
        37: SequenceLikelihood.UNLIKELY,  # 'K'
        50: SequenceLikelihood.UNLIKELY,  # 'L'
        35: SequenceLikelihood.UNLIKELY,  # 'M'
        36: SequenceLikelihood.UNLIKELY,  # 'N'
        40: SequenceLikelihood.UNLIKELY,  # 'O'
        30: SequenceLikelihood.UNLIKELY,  # 'P'
        64: SequenceLikelihood.NEGATIVE,  # 'Q'
        45: SequenceLikelihood.UNLIKELY,  # 'R'
        33: SequenceLikelihood.UNLIKELY,  # 'S'
        38: SequenceLikelihood.UNLIKELY,  # 'T'
        51: SequenceLikelihood.UNLIKELY,  # 'U'
        56: SequenceLikelihood.NEGATIVE,  # 'V'
        32: SequenceLikelihood.UNLIKELY,  # 'W'
        60: SequenceLikelihood.NEGATIVE,  # 'X'
        58: SequenceLikelihood.UNLIKELY,  # 'Y'
        44: SequenceLikelihood.UNLIKELY,  # 'Z'
        1: SequenceLikelihood.LIKELY,  # 'a'
        20: SequenceLikelihood.UNLIKELY,  # 'b'
        11: SequenceLikelihood.NEGATIVE,  # 'c'
        14: SequenceLikelihood.UNLIKELY,  # 'd'
        2: SequenceLikelihood.UNLIKELY,  # 'e'
        31: SequenceLikelihood.UNLIKELY,  # 'f'
        22: SequenceLikelihood.UNLIKELY,  # 'g'
        23: SequenceLikelihood.NEGATIVE,  # 'h'
        3: SequenceLikelihood.UNLIKELY,  # 'i'
        19: SequenceLikelihood.NEGATIVE,  # 'j'
        13: SequenceLikelihood.UNLIKELY,  # 'k'
        18: SequenceLikelihood.NEGATIVE,  # 'l'
        15: SequenceLikelihood.NEGATIVE,  # 'm'
        5: SequenceLikelihood.UNLIKELY,  # 'n'
        4: SequenceLikelihood.LIKELY,  # 'o'
        16: SequenceLikelihood.UNLIKELY,  # 'p'
        63: SequenceLikelihood.NEGATIVE,  # 'q'
        7: SequenceLikelihood.NEGATIVE,  # 'r'
        9: SequenceLikelihood.UNLIKELY,  # 's'
        10: SequenceLikelihood.UNLIKELY,  # 't'
        17: SequenceLikelihood.LIKELY,  # 'u'
        55: SequenceLikelihood.NEGATIVE,  # 'v'
        8: SequenceLikelihood.NEGATIVE,  # 'w'
        57: SequenceLikelihood.NEGATIVE,  # 'x'
        12: SequenceLikelihood.UNLIKELY,  # 'y'
        6: SequenceLikelihood.UNLIKELY,  # 'z'
        66: SequenceLikelihood.UNLIKELY,  # 'Ó'
        27: SequenceLikelihood.UNLIKELY,  # 'ó'
        67: SequenceLikelihood.UNLIKELY,  # 'Ą'
        25: SequenceLikelihood.UNLIKELY,  # 'ą'
        68: SequenceLikelihood.NEGATIVE,  # 'Ć'
        29: SequenceLikelihood.NEGATIVE,  # 'ć'
        65: SequenceLikelihood.UNLIKELY,  # 'Ę'
        24: SequenceLikelihood.UNLIKELY,  # 'ę'
        61: SequenceLikelihood.UNLIKELY,  # 'Ł'
        21: SequenceLikelihood.NEGATIVE,  # 'ł'
        70: SequenceLikelihood.NEGATIVE,  # 'Ń'
        42: SequenceLikelihood.NEGATIVE,  # 'ń'
        59: SequenceLikelihood.UNLIKELY,  # 'Ś'
        28: SequenceLikelihood.NEGATIVE,  # 'ś'
        69: SequenceLikelihood.NEGATIVE,  # 'Ź'
        53: SequenceLikelihood.NEGATIVE,  # 'ź'
        62: SequenceLikelihood.UNLIKELY,  # 'Ż'
        26: SequenceLikelihood.UNLIKELY,  # 'ż'
    },
    21: {  # 'ł'
        34: SequenceLikelihood.UNLIKELY,  # 'A'
        46: SequenceLikelihood.UNLIKELY,  # 'B'
        39: SequenceLikelihood.UNLIKELY,  # 'C'
        41: SequenceLikelihood.UNLIKELY,  # 'D'
        48: SequenceLikelihood.UNLIKELY,  # 'E'
        52: SequenceLikelihood.UNLIKELY,  # 'F'
        49: SequenceLikelihood.UNLIKELY,  # 'G'
        54: SequenceLikelihood.UNLIKELY,  # 'H'
        43: SequenceLikelihood.UNLIKELY,  # 'I'
        47: SequenceLikelihood.UNLIKELY,  # 'J'
        37: SequenceLikelihood.UNLIKELY,  # 'K'
        50: SequenceLikelihood.UNLIKELY,  # 'L'
        35: SequenceLikelihood.UNLIKELY,  # 'M'
        36: SequenceLikelihood.UNLIKELY,  # 'N'
        40: SequenceLikelihood.UNLIKELY,  # 'O'
        30: SequenceLikelihood.UNLIKELY,  # 'P'
        64: SequenceLikelihood.NEGATIVE,  # 'Q'
        45: SequenceLikelihood.UNLIKELY,  # 'R'
        33: SequenceLikelihood.UNLIKELY,  # 'S'
        38: SequenceLikelihood.UNLIKELY,  # 'T'
        51: SequenceLikelihood.UNLIKELY,  # 'U'
        56: SequenceLikelihood.UNLIKELY,  # 'V'
        32: SequenceLikelihood.UNLIKELY,  # 'W'
        60: SequenceLikelihood.UNLIKELY,  # 'X'
        58: SequenceLikelihood.UNLIKELY,  # 'Y'
        44: SequenceLikelihood.UNLIKELY,  # 'Z'
        1: SequenceLikelihood.POSITIVE,  # 'a'
        20: SequenceLikelihood.LIKELY,  # 'b'
        11: SequenceLikelihood.LIKELY,  # 'c'
        14: SequenceLikelihood.LIKELY,  # 'd'
        2: SequenceLikelihood.POSITIVE,  # 'e'
        31: SequenceLikelihood.UNLIKELY,  # 'f'
        22: SequenceLikelihood.LIKELY,  # 'g'
        23: SequenceLikelihood.UNLIKELY,  # 'h'
        3: SequenceLikelihood.UNLIKELY,  # 'i'
        19: SequenceLikelihood.UNLIKELY,  # 'j'
        13: SequenceLikelihood.POSITIVE,  # 'k'
        18: SequenceLikelihood.UNLIKELY,  # 'l'
        15: SequenceLikelihood.UNLIKELY,  # 'm'
        5: SequenceLikelihood.POSITIVE,  # 'n'
        4: SequenceLikelihood.POSITIVE,  # 'o'
        16: SequenceLikelihood.LIKELY,  # 'p'
        63: SequenceLikelihood.UNLIKELY,  # 'q'
        7: SequenceLikelihood.UNLIKELY,  # 'r'
        9: SequenceLikelihood.UNLIKELY,  # 's'
        10: SequenceLikelihood.LIKELY,  # 't'
        17: SequenceLikelihood.POSITIVE,  # 'u'
        55: SequenceLikelihood.UNLIKELY,  # 'v'
        8: SequenceLikelihood.UNLIKELY,  # 'w'
        57: SequenceLikelihood.UNLIKELY,  # 'x'
        12: SequenceLikelihood.POSITIVE,  # 'y'
        6: SequenceLikelihood.UNLIKELY,  # 'z'
        66: SequenceLikelihood.UNLIKELY,  # 'Ó'
        27: SequenceLikelihood.POSITIVE,  # 'ó'
        67: SequenceLikelihood.UNLIKELY,  # 'Ą'
        25: SequenceLikelihood.POSITIVE,  # 'ą'
        68: SequenceLikelihood.NEGATIVE,  # 'Ć'
        29: SequenceLikelihood.UNLIKELY,  # 'ć'
        65: SequenceLikelihood.NEGATIVE,  # 'Ę'
        24: SequenceLikelihood.LIKELY,  # 'ę'
        61: SequenceLikelihood.UNLIKELY,  # 'Ł'
        21: SequenceLikelihood.UNLIKELY,  # 'ł'
        70: SequenceLikelihood.NEGATIVE,  # 'Ń'
        42: SequenceLikelihood.UNLIKELY,  # 'ń'
        59: SequenceLikelihood.UNLIKELY,  # 'Ś'
        28: SequenceLikelihood.UNLIKELY,  # 'ś'
        69: SequenceLikelihood.UNLIKELY,  # 'Ź'
        53: SequenceLikelihood.UNLIKELY,  # 'ź'
        62: SequenceLikelihood.NEGATIVE,  # 'Ż'
        26: SequenceLikelihood.LIKELY,  # 'ż'
    },
    70: {  # 'Ń'
        34: SequenceLikelihood.UNLIKELY,  # 'A'
        46: SequenceLikelihood.UNLIKELY,  # 'B'
        39: SequenceLikelihood.UNLIKELY,  # 'C'
        41: SequenceLikelihood.UNLIKELY,  # 'D'
        48: SequenceLikelihood.NEGATIVE,  # 'E'
        52: SequenceLikelihood.UNLIKELY,  # 'F'
        49: SequenceLikelihood.NEGATIVE,  # 'G'
        54: SequenceLikelihood.NEGATIVE,  # 'H'
        43: SequenceLikelihood.NEGATIVE,  # 'I'
        47: SequenceLikelihood.NEGATIVE,  # 'J'
        37: SequenceLikelihood.UNLIKELY,  # 'K'
        50: SequenceLikelihood.NEGATIVE,  # 'L'
        35: SequenceLikelihood.UNLIKELY,  # 'M'
        36: SequenceLikelihood.NEGATIVE,  # 'N'
        40: SequenceLikelihood.UNLIKELY,  # 'O'
        30: SequenceLikelihood.UNLIKELY,  # 'P'
        64: SequenceLikelihood.NEGATIVE,  # 'Q'
        45: SequenceLikelihood.NEGATIVE,  # 'R'
        33: SequenceLikelihood.UNLIKELY,  # 'S'
        38: SequenceLikelihood.UNLIKELY,  # 'T'
        51: SequenceLikelihood.NEGATIVE,  # 'U'
        56: SequenceLikelihood.NEGATIVE,  # 'V'
        32: SequenceLikelihood.UNLIKELY,  # 'W'
        60: SequenceLikelihood.NEGATIVE,  # 'X'
        58: SequenceLikelihood.NEGATIVE,  # 'Y'
        44: SequenceLikelihood.UNLIKELY,  # 'Z'
        1: SequenceLikelihood.NEGATIVE,  # 'a'
        20: SequenceLikelihood.NEGATIVE,  # 'b'
        11: SequenceLikelihood.UNLIKELY,  # 'c'
        14: SequenceLikelihood.NEGATIVE,  # 'd'
        2: SequenceLikelihood.NEGATIVE,  # 'e'
        31: SequenceLikelihood.NEGATIVE,  # 'f'
        22: SequenceLikelihood.NEGATIVE,  # 'g'
        23: SequenceLikelihood.NEGATIVE,  # 'h'
        3: SequenceLikelihood.NEGATIVE,  # 'i'
        19: SequenceLikelihood.NEGATIVE,  # 'j'
        13: SequenceLikelihood.UNLIKELY,  # 'k'
        18: SequenceLikelihood.NEGATIVE,  # 'l'
        15: SequenceLikelihood.NEGATIVE,  # 'm'
        5: SequenceLikelihood.NEGATIVE,  # 'n'
        4: SequenceLikelihood.NEGATIVE,  # 'o'
        16: SequenceLikelihood.NEGATIVE,  # 'p'
        63: SequenceLikelihood.NEGATIVE,  # 'q'
        7: SequenceLikelihood.NEGATIVE,  # 'r'
        9: SequenceLikelihood.UNLIKELY,  # 's'
        10: SequenceLikelihood.NEGATIVE,  # 't'
        17: SequenceLikelihood.NEGATIVE,  # 'u'
        55: SequenceLikelihood.NEGATIVE,  # 'v'
        8: SequenceLikelihood.NEGATIVE,  # 'w'
        57: SequenceLikelihood.NEGATIVE,  # 'x'
        12: SequenceLikelihood.NEGATIVE,  # 'y'
        6: SequenceLikelihood.NEGATIVE,  # 'z'
        66: SequenceLikelihood.NEGATIVE,  # 'Ó'
        27: SequenceLikelihood.NEGATIVE,  # 'ó'
        67: SequenceLikelihood.NEGATIVE,  # 'Ą'
        25: SequenceLikelihood.NEGATIVE,  # 'ą'
        68: SequenceLikelihood.UNLIKELY,  # 'Ć'
        29: SequenceLikelihood.NEGATIVE,  # 'ć'
        65: SequenceLikelihood.NEGATIVE,  # 'Ę'
        24: SequenceLikelihood.NEGATIVE,  # 'ę'
        61: SequenceLikelihood.NEGATIVE,  # 'Ł'
        21: SequenceLikelihood.NEGATIVE,  # 'ł'
        70: SequenceLikelihood.NEGATIVE,  # 'Ń'
        42: SequenceLikelihood.NEGATIVE,  # 'ń'
        59: SequenceLikelihood.UNLIKELY,  # 'Ś'
        28: SequenceLikelihood.NEGATIVE,  # 'ś'
        69: SequenceLikelihood.NEGATIVE,  # 'Ź'
        53: SequenceLikelihood.NEGATIVE,  # 'ź'
        62: SequenceLikelihood.NEGATIVE,  # 'Ż'
        26: SequenceLikelihood.NEGATIVE,  # 'ż'
    },
    42: {  # 'ń'
        34: SequenceLikelihood.UNLIKELY,  # 'A'
        46: SequenceLikelihood.UNLIKELY,  # 'B'
        39: SequenceLikelihood.UNLIKELY,  # 'C'
        41: SequenceLikelihood.UNLIKELY,  # 'D'
        48: SequenceLikelihood.UNLIKELY,  # 'E'
        52: SequenceLikelihood.UNLIKELY,  # 'F'
        49: SequenceLikelihood.UNLIKELY,  # 'G'
        54: SequenceLikelihood.UNLIKELY,  # 'H'
        43: SequenceLikelihood.UNLIKELY,  # 'I'
        47: SequenceLikelihood.UNLIKELY,  # 'J'
        37: SequenceLikelihood.UNLIKELY,  # 'K'
        50: SequenceLikelihood.UNLIKELY,  # 'L'
        35: SequenceLikelihood.UNLIKELY,  # 'M'
        36: SequenceLikelihood.UNLIKELY,  # 'N'
        40: SequenceLikelihood.UNLIKELY,  # 'O'
        30: SequenceLikelihood.UNLIKELY,  # 'P'
        64: SequenceLikelihood.NEGATIVE,  # 'Q'
        45: SequenceLikelihood.UNLIKELY,  # 'R'
        33: SequenceLikelihood.UNLIKELY,  # 'S'
        38: SequenceLikelihood.UNLIKELY,  # 'T'
        51: SequenceLikelihood.UNLIKELY,  # 'U'
        56: SequenceLikelihood.UNLIKELY,  # 'V'
        32: SequenceLikelihood.UNLIKELY,  # 'W'
        60: SequenceLikelihood.UNLIKELY,  # 'X'
        58: SequenceLikelihood.UNLIKELY,  # 'Y'
        44: SequenceLikelihood.UNLIKELY,  # 'Z'
        1: SequenceLikelihood.UNLIKELY,  # 'a'
        20: SequenceLikelihood.UNLIKELY,  # 'b'
        11: SequenceLikelihood.POSITIVE,  # 'c'
        14: SequenceLikelihood.UNLIKELY,  # 'd'
        2: SequenceLikelihood.UNLIKELY,  # 'e'
        31: SequenceLikelihood.UNLIKELY,  # 'f'
        22: SequenceLikelihood.UNLIKELY,  # 'g'
        23: SequenceLikelihood.NEGATIVE,  # 'h'
        3: SequenceLikelihood.UNLIKELY,  # 'i'
        19: SequenceLikelihood.UNLIKELY,  # 'j'
        13: SequenceLikelihood.UNLIKELY,  # 'k'
        18: SequenceLikelihood.UNLIKELY,  # 'l'
        15: SequenceLikelihood.UNLIKELY,  # 'm'
        5: SequenceLikelihood.UNLIKELY,  # 'n'
        4: SequenceLikelihood.UNLIKELY,  # 'o'
        16: SequenceLikelihood.UNLIKELY,  # 'p'
        63: SequenceLikelihood.NEGATIVE,  # 'q'
        7: SequenceLikelihood.UNLIKELY,  # 'r'
        9: SequenceLikelihood.POSITIVE,  # 's'
        10: SequenceLikelihood.UNLIKELY,  # 't'
        17: SequenceLikelihood.UNLIKELY,  # 'u'
        55: SequenceLikelihood.UNLIKELY,  # 'v'
        8: SequenceLikelihood.UNLIKELY,  # 'w'
        57: SequenceLikelihood.UNLIKELY,  # 'x'
        12: SequenceLikelihood.UNLIKELY,  # 'y'
        6: SequenceLikelihood.UNLIKELY,  # 'z'
        66: SequenceLikelihood.NEGATIVE,  # 'Ó'
        27: SequenceLikelihood.UNLIKELY,  # 'ó'
        67: SequenceLikelihood.NEGATIVE,  # 'Ą'
        25: SequenceLikelihood.NEGATIVE,  # 'ą'
        68: SequenceLikelihood.NEGATIVE,  # 'Ć'
        29: SequenceLikelihood.UNLIKELY,  # 'ć'
        65: SequenceLikelihood.NEGATIVE,  # 'Ę'
        24: SequenceLikelihood.UNLIKELY,  # 'ę'
        61: SequenceLikelihood.UNLIKELY,  # 'Ł'
        21: SequenceLikelihood.NEGATIVE,  # 'ł'
        70: SequenceLikelihood.NEGATIVE,  # 'Ń'
        42: SequenceLikelihood.NEGATIVE,  # 'ń'
        59: SequenceLikelihood.UNLIKELY,  # 'Ś'
        28: SequenceLikelihood.UNLIKELY,  # 'ś'
        69: SequenceLikelihood.UNLIKELY,  # 'Ź'
        53: SequenceLikelihood.NEGATIVE,  # 'ź'
        62: SequenceLikelihood.NEGATIVE,  # 'Ż'
        26: SequenceLikelihood.UNLIKELY,  # 'ż'
    },
    59: {  # 'Ś'
        34: SequenceLikelihood.UNLIKELY,  # 'A'
        46: SequenceLikelihood.UNLIKELY,  # 'B'
        39: SequenceLikelihood.UNLIKELY,  # 'C'
        41: SequenceLikelihood.UNLIKELY,  # 'D'
        48: SequenceLikelihood.NEGATIVE,  # 'E'
        52: SequenceLikelihood.UNLIKELY,  # 'F'
        49: SequenceLikelihood.UNLIKELY,  # 'G'
        54: SequenceLikelihood.UNLIKELY,  # 'H'
        43: SequenceLikelihood.UNLIKELY,  # 'I'
        47: SequenceLikelihood.UNLIKELY,  # 'J'
        37: SequenceLikelihood.UNLIKELY,  # 'K'
        50: SequenceLikelihood.UNLIKELY,  # 'L'
        35: SequenceLikelihood.UNLIKELY,  # 'M'
        36: SequenceLikelihood.UNLIKELY,  # 'N'
        40: SequenceLikelihood.UNLIKELY,  # 'O'
        30: SequenceLikelihood.UNLIKELY,  # 'P'
        64: SequenceLikelihood.NEGATIVE,  # 'Q'
        45: SequenceLikelihood.UNLIKELY,  # 'R'
        33: SequenceLikelihood.UNLIKELY,  # 'S'
        38: SequenceLikelihood.UNLIKELY,  # 'T'
        51: SequenceLikelihood.UNLIKELY,  # 'U'
        56: SequenceLikelihood.NEGATIVE,  # 'V'
        32: SequenceLikelihood.UNLIKELY,  # 'W'
        60: SequenceLikelihood.NEGATIVE,  # 'X'
        58: SequenceLikelihood.NEGATIVE,  # 'Y'
        44: SequenceLikelihood.UNLIKELY,  # 'Z'
        1: SequenceLikelihood.UNLIKELY,  # 'a'
        20: SequenceLikelihood.UNLIKELY,  # 'b'
        11: SequenceLikelihood.UNLIKELY,  # 'c'
        14: SequenceLikelihood.NEGATIVE,  # 'd'
        2: SequenceLikelihood.UNLIKELY,  # 'e'
        31: SequenceLikelihood.UNLIKELY,  # 'f'
        22: SequenceLikelihood.NEGATIVE,  # 'g'
        23: SequenceLikelihood.UNLIKELY,  # 'h'
        3: SequenceLikelihood.UNLIKELY,  # 'i'
        19: SequenceLikelihood.NEGATIVE,  # 'j'
        13: SequenceLikelihood.UNLIKELY,  # 'k'
        18: SequenceLikelihood.LIKELY,  # 'l'
        15: SequenceLikelihood.UNLIKELY,  # 'm'
        5: SequenceLikelihood.UNLIKELY,  # 'n'
        4: SequenceLikelihood.UNLIKELY,  # 'o'
        16: SequenceLikelihood.UNLIKELY,  # 'p'
        63: SequenceLikelihood.NEGATIVE,  # 'q'
        7: SequenceLikelihood.LIKELY,  # 'r'
        9: SequenceLikelihood.NEGATIVE,  # 's'
        10: SequenceLikelihood.UNLIKELY,  # 't'
        17: SequenceLikelihood.UNLIKELY,  # 'u'
        55: SequenceLikelihood.NEGATIVE,  # 'v'
        8: SequenceLikelihood.LIKELY,  # 'w'
        57: SequenceLikelihood.NEGATIVE,  # 'x'
        12: SequenceLikelihood.NEGATIVE,  # 'y'
        6: SequenceLikelihood.UNLIKELY,  # 'z'
        66: SequenceLikelihood.NEGATIVE,  # 'Ó'
        27: SequenceLikelihood.NEGATIVE,  # 'ó'
        67: SequenceLikelihood.NEGATIVE,  # 'Ą'
        25: SequenceLikelihood.NEGATIVE,  # 'ą'
        68: SequenceLikelihood.UNLIKELY,  # 'Ć'
        29: SequenceLikelihood.UNLIKELY,  # 'ć'
        65: SequenceLikelihood.NEGATIVE,  # 'Ę'
        24: SequenceLikelihood.NEGATIVE,  # 'ę'
        61: SequenceLikelihood.NEGATIVE,  # 'Ł'
        21: SequenceLikelihood.NEGATIVE,  # 'ł'
        70: SequenceLikelihood.UNLIKELY,  # 'Ń'
        42: SequenceLikelihood.NEGATIVE,  # 'ń'
        59: SequenceLikelihood.UNLIKELY,  # 'Ś'
        28: SequenceLikelihood.UNLIKELY,  # 'ś'
        69: SequenceLikelihood.NEGATIVE,  # 'Ź'
        53: SequenceLikelihood.NEGATIVE,  # 'ź'
        62: SequenceLikelihood.NEGATIVE,  # 'Ż'
        26: SequenceLikelihood.NEGATIVE,  # 'ż'
    },
    28: {  # 'ś'
        34: SequenceLikelihood.UNLIKELY,  # 'A'
        46: SequenceLikelihood.UNLIKELY,  # 'B'
        39: SequenceLikelihood.UNLIKELY,  # 'C'
        41: SequenceLikelihood.NEGATIVE,  # 'D'
        48: SequenceLikelihood.UNLIKELY,  # 'E'
        52: SequenceLikelihood.UNLIKELY,  # 'F'
        49: SequenceLikelihood.UNLIKELY,  # 'G'
        54: SequenceLikelihood.UNLIKELY,  # 'H'
        43: SequenceLikelihood.NEGATIVE,  # 'I'
        47: SequenceLikelihood.UNLIKELY,  # 'J'
        37: SequenceLikelihood.UNLIKELY,  # 'K'
        50: SequenceLikelihood.UNLIKELY,  # 'L'
        35: SequenceLikelihood.UNLIKELY,  # 'M'
        36: SequenceLikelihood.UNLIKELY,  # 'N'
        40: SequenceLikelihood.UNLIKELY,  # 'O'
        30: SequenceLikelihood.UNLIKELY,  # 'P'
        64: SequenceLikelihood.NEGATIVE,  # 'Q'
        45: SequenceLikelihood.UNLIKELY,  # 'R'
        33: SequenceLikelihood.UNLIKELY,  # 'S'
        38: SequenceLikelihood.UNLIKELY,  # 'T'
        51: SequenceLikelihood.NEGATIVE,  # 'U'
        56: SequenceLikelihood.NEGATIVE,  # 'V'
        32: SequenceLikelihood.UNLIKELY,  # 'W'
        60: SequenceLikelihood.NEGATIVE,  # 'X'
        58: SequenceLikelihood.UNLIKELY,  # 'Y'
        44: SequenceLikelihood.NEGATIVE,  # 'Z'
        1: SequenceLikelihood.UNLIKELY,  # 'a'
        20: SequenceLikelihood.UNLIKELY,  # 'b'
        11: SequenceLikelihood.POSITIVE,  # 'c'
        14: SequenceLikelihood.UNLIKELY,  # 'd'
        2: SequenceLikelihood.UNLIKELY,  # 'e'
        31: SequenceLikelihood.UNLIKELY,  # 'f'
        22: SequenceLikelihood.UNLIKELY,  # 'g'
        23: SequenceLikelihood.NEGATIVE,  # 'h'
        3: SequenceLikelihood.UNLIKELY,  # 'i'
        19: SequenceLikelihood.UNLIKELY,  # 'j'
        13: SequenceLikelihood.UNLIKELY,  # 'k'
        18: SequenceLikelihood.POSITIVE,  # 'l'
        15: SequenceLikelihood.POSITIVE,  # 'm'
        5: SequenceLikelihood.POSITIVE,  # 'n'
        4: SequenceLikelihood.UNLIKELY,  # 'o'
        16: SequenceLikelihood.LIKELY,  # 'p'
        63: SequenceLikelihood.UNLIKELY,  # 'q'
        7: SequenceLikelihood.POSITIVE,  # 'r'
        9: SequenceLikelihood.UNLIKELY,  # 's'
        10: SequenceLikelihood.UNLIKELY,  # 't'
        17: SequenceLikelihood.UNLIKELY,  # 'u'
        55: SequenceLikelihood.UNLIKELY,  # 'v'
        8: SequenceLikelihood.POSITIVE,  # 'w'
        57: SequenceLikelihood.UNLIKELY,  # 'x'
        12: SequenceLikelihood.UNLIKELY,  # 'y'
        6: SequenceLikelihood.UNLIKELY,  # 'z'
        66: SequenceLikelihood.NEGATIVE,  # 'Ó'
        27: SequenceLikelihood.UNLIKELY,  # 'ó'
        67: SequenceLikelihood.NEGATIVE,  # 'Ą'
        25: SequenceLikelihood.UNLIKELY,  # 'ą'
        68: SequenceLikelihood.NEGATIVE,  # 'Ć'
        29: SequenceLikelihood.POSITIVE,  # 'ć'
        65: SequenceLikelihood.NEGATIVE,  # 'Ę'
        24: SequenceLikelihood.UNLIKELY,  # 'ę'
        61: SequenceLikelihood.UNLIKELY,  # 'Ł'
        21: SequenceLikelihood.UNLIKELY,  # 'ł'
        70: SequenceLikelihood.NEGATIVE,  # 'Ń'
        42: SequenceLikelihood.UNLIKELY,  # 'ń'
        59: SequenceLikelihood.NEGATIVE,  # 'Ś'
        28: SequenceLikelihood.UNLIKELY,  # 'ś'
        69: SequenceLikelihood.NEGATIVE,  # 'Ź'
        53: SequenceLikelihood.NEGATIVE,  # 'ź'
        62: SequenceLikelihood.NEGATIVE,  # 'Ż'
        26: SequenceLikelihood.UNLIKELY,  # 'ż'
    },
    69: {  # 'Ź'
        34: SequenceLikelihood.UNLIKELY,  # 'A'
        46: SequenceLikelihood.UNLIKELY,  # 'B'
        39: SequenceLikelihood.UNLIKELY,  # 'C'
        41: SequenceLikelihood.UNLIKELY,  # 'D'
        48: SequenceLikelihood.UNLIKELY,  # 'E'
        52: SequenceLikelihood.NEGATIVE,  # 'F'
        49: SequenceLikelihood.NEGATIVE,  # 'G'
        54: SequenceLikelihood.NEGATIVE,  # 'H'
        43: SequenceLikelihood.UNLIKELY,  # 'I'
        47: SequenceLikelihood.NEGATIVE,  # 'J'
        37: SequenceLikelihood.UNLIKELY,  # 'K'
        50: SequenceLikelihood.UNLIKELY,  # 'L'
        35: SequenceLikelihood.UNLIKELY,  # 'M'
        36: SequenceLikelihood.UNLIKELY,  # 'N'
        40: SequenceLikelihood.UNLIKELY,  # 'O'
        30: SequenceLikelihood.NEGATIVE,  # 'P'
        64: SequenceLikelihood.NEGATIVE,  # 'Q'
        45: SequenceLikelihood.UNLIKELY,  # 'R'
        33: SequenceLikelihood.NEGATIVE,  # 'S'
        38: SequenceLikelihood.NEGATIVE,  # 'T'
        51: SequenceLikelihood.NEGATIVE,  # 'U'
        56: SequenceLikelihood.NEGATIVE,  # 'V'
        32: SequenceLikelihood.UNLIKELY,  # 'W'
        60: SequenceLikelihood.NEGATIVE,  # 'X'
        58: SequenceLikelihood.NEGATIVE,  # 'Y'
        44: SequenceLikelihood.UNLIKELY,  # 'Z'
        1: SequenceLikelihood.UNLIKELY,  # 'a'
        20: SequenceLikelihood.NEGATIVE,  # 'b'
        11: SequenceLikelihood.NEGATIVE,  # 'c'
        14: SequenceLikelihood.UNLIKELY,  # 'd'
        2: SequenceLikelihood.UNLIKELY,  # 'e'
        31: SequenceLikelihood.NEGATIVE,  # 'f'
        22: SequenceLikelihood.NEGATIVE,  # 'g'
        23: SequenceLikelihood.NEGATIVE,  # 'h'
        3: SequenceLikelihood.NEGATIVE,  # 'i'
        19: SequenceLikelihood.NEGATIVE,  # 'j'
        13: SequenceLikelihood.NEGATIVE,  # 'k'
        18: SequenceLikelihood.UNLIKELY,  # 'l'
        15: SequenceLikelihood.UNLIKELY,  # 'm'
        5: SequenceLikelihood.UNLIKELY,  # 'n'
        4: SequenceLikelihood.UNLIKELY,  # 'o'
        16: SequenceLikelihood.NEGATIVE,  # 'p'
        63: SequenceLikelihood.NEGATIVE,  # 'q'
        7: SequenceLikelihood.UNLIKELY,  # 'r'
        9: SequenceLikelihood.NEGATIVE,  # 's'
        10: SequenceLikelihood.NEGATIVE,  # 't'
        17: SequenceLikelihood.UNLIKELY,  # 'u'
        55: SequenceLikelihood.NEGATIVE,  # 'v'
        8: SequenceLikelihood.UNLIKELY,  # 'w'
        57: SequenceLikelihood.NEGATIVE,  # 'x'
        12: SequenceLikelihood.UNLIKELY,  # 'y'
        6: SequenceLikelihood.NEGATIVE,  # 'z'
        66: SequenceLikelihood.NEGATIVE,  # 'Ó'
        27: SequenceLikelihood.NEGATIVE,  # 'ó'
        67: SequenceLikelihood.NEGATIVE,  # 'Ą'
        25: SequenceLikelihood.NEGATIVE,  # 'ą'
        68: SequenceLikelihood.UNLIKELY,  # 'Ć'
        29: SequenceLikelihood.NEGATIVE,  # 'ć'
        65: SequenceLikelihood.NEGATIVE,  # 'Ę'
        24: SequenceLikelihood.NEGATIVE,  # 'ę'
        61: SequenceLikelihood.NEGATIVE,  # 'Ł'
        21: SequenceLikelihood.NEGATIVE,  # 'ł'
        70: SequenceLikelihood.UNLIKELY,  # 'Ń'
        42: SequenceLikelihood.NEGATIVE,  # 'ń'
        59: SequenceLikelihood.NEGATIVE,  # 'Ś'
        28: SequenceLikelihood.NEGATIVE,  # 'ś'
        69: SequenceLikelihood.NEGATIVE,  # 'Ź'
        53: SequenceLikelihood.NEGATIVE,  # 'ź'
        62: SequenceLikelihood.NEGATIVE,  # 'Ż'
        26: SequenceLikelihood.NEGATIVE,  # 'ż'
    },
    53: {  # 'ź'
        34: SequenceLikelihood.UNLIKELY,  # 'A'
        46: SequenceLikelihood.NEGATIVE,  # 'B'
        39: SequenceLikelihood.UNLIKELY,  # 'C'
        41: SequenceLikelihood.UNLIKELY,  # 'D'
        48: SequenceLikelihood.NEGATIVE,  # 'E'
        52: SequenceLikelihood.UNLIKELY,  # 'F'
        49: SequenceLikelihood.UNLIKELY,  # 'G'
        54: SequenceLikelihood.NEGATIVE,  # 'H'
        43: SequenceLikelihood.NEGATIVE,  # 'I'
        47: SequenceLikelihood.UNLIKELY,  # 'J'
        37: SequenceLikelihood.UNLIKELY,  # 'K'
        50: SequenceLikelihood.UNLIKELY,  # 'L'
        35: SequenceLikelihood.UNLIKELY,  # 'M'
        36: SequenceLikelihood.UNLIKELY,  # 'N'
        40: SequenceLikelihood.UNLIKELY,  # 'O'
        30: SequenceLikelihood.UNLIKELY,  # 'P'
        64: SequenceLikelihood.NEGATIVE,  # 'Q'
        45: SequenceLikelihood.UNLIKELY,  # 'R'
        33: SequenceLikelihood.UNLIKELY,  # 'S'
        38: SequenceLikelihood.NEGATIVE,  # 'T'
        51: SequenceLikelihood.NEGATIVE,  # 'U'
        56: SequenceLikelihood.NEGATIVE,  # 'V'
        32: SequenceLikelihood.UNLIKELY,  # 'W'
        60: SequenceLikelihood.NEGATIVE,  # 'X'
        58: SequenceLikelihood.NEGATIVE,  # 'Y'
        44: SequenceLikelihood.UNLIKELY,  # 'Z'
        1: SequenceLikelihood.UNLIKELY,  # 'a'
        20: SequenceLikelihood.UNLIKELY,  # 'b'
        11: SequenceLikelihood.UNLIKELY,  # 'c'
        14: SequenceLikelihood.LIKELY,  # 'd'
        2: SequenceLikelihood.UNLIKELY,  # 'e'
        31: SequenceLikelihood.UNLIKELY,  # 'f'
        22: SequenceLikelihood.UNLIKELY,  # 'g'
        23: SequenceLikelihood.UNLIKELY,  # 'h'
        3: SequenceLikelihood.UNLIKELY,  # 'i'
        19: SequenceLikelihood.UNLIKELY,  # 'j'
        13: SequenceLikelihood.UNLIKELY,  # 'k'
        18: SequenceLikelihood.LIKELY,  # 'l'
        15: SequenceLikelihood.LIKELY,  # 'm'
        5: SequenceLikelihood.POSITIVE,  # 'n'
        4: SequenceLikelihood.UNLIKELY,  # 'o'
        16: SequenceLikelihood.UNLIKELY,  # 'p'
        63: SequenceLikelihood.NEGATIVE,  # 'q'
        7: SequenceLikelihood.LIKELY,  # 'r'
        9: SequenceLikelihood.UNLIKELY,  # 's'
        10: SequenceLikelihood.UNLIKELY,  # 't'
        17: SequenceLikelihood.UNLIKELY,  # 'u'
        55: SequenceLikelihood.NEGATIVE,  # 'v'
        8: SequenceLikelihood.LIKELY,  # 'w'
        57: SequenceLikelihood.NEGATIVE,  # 'x'
        12: SequenceLikelihood.UNLIKELY,  # 'y'
        6: SequenceLikelihood.NEGATIVE,  # 'z'
        66: SequenceLikelihood.NEGATIVE,  # 'Ó'
        27: SequenceLikelihood.UNLIKELY,  # 'ó'
        67: SequenceLikelihood.NEGATIVE,  # 'Ą'
        25: SequenceLikelihood.UNLIKELY,  # 'ą'
        68: SequenceLikelihood.NEGATIVE,  # 'Ć'
        29: SequenceLikelihood.LIKELY,  # 'ć'
        65: SequenceLikelihood.NEGATIVE,  # 'Ę'
        24: SequenceLikelihood.UNLIKELY,  # 'ę'
        61: SequenceLikelihood.NEGATIVE,  # 'Ł'
        21: SequenceLikelihood.UNLIKELY,  # 'ł'
        70: SequenceLikelihood.NEGATIVE,  # 'Ń'
        42: SequenceLikelihood.UNLIKELY,  # 'ń'
        59: SequenceLikelihood.UNLIKELY,  # 'Ś'
        28: SequenceLikelihood.UNLIKELY,  # 'ś'
        69: SequenceLikelihood.NEGATIVE,  # 'Ź'
        53: SequenceLikelihood.NEGATIVE,  # 'ź'
        62: SequenceLikelihood.NEGATIVE,  # 'Ż'
        26: SequenceLikelihood.UNLIKELY,  # 'ż'
    },
    62: {  # 'Ż'
        34: SequenceLikelihood.UNLIKELY,  # 'A'
        46: SequenceLikelihood.UNLIKELY,  # 'B'
        39: SequenceLikelihood.UNLIKELY,  # 'C'
        41: SequenceLikelihood.UNLIKELY,  # 'D'
        48: SequenceLikelihood.UNLIKELY,  # 'E'
        52: SequenceLikelihood.NEGATIVE,  # 'F'
        49: SequenceLikelihood.UNLIKELY,  # 'G'
        54: SequenceLikelihood.NEGATIVE,  # 'H'
        43: SequenceLikelihood.UNLIKELY,  # 'I'
        47: SequenceLikelihood.NEGATIVE,  # 'J'
        37: SequenceLikelihood.UNLIKELY,  # 'K'
        50: SequenceLikelihood.UNLIKELY,  # 'L'
        35: SequenceLikelihood.UNLIKELY,  # 'M'
        36: SequenceLikelihood.UNLIKELY,  # 'N'
        40: SequenceLikelihood.UNLIKELY,  # 'O'
        30: SequenceLikelihood.UNLIKELY,  # 'P'
        64: SequenceLikelihood.NEGATIVE,  # 'Q'
        45: SequenceLikelihood.UNLIKELY,  # 'R'
        33: SequenceLikelihood.UNLIKELY,  # 'S'
        38: SequenceLikelihood.UNLIKELY,  # 'T'
        51: SequenceLikelihood.UNLIKELY,  # 'U'
        56: SequenceLikelihood.NEGATIVE,  # 'V'
        32: SequenceLikelihood.UNLIKELY,  # 'W'
        60: SequenceLikelihood.NEGATIVE,  # 'X'
        58: SequenceLikelihood.UNLIKELY,  # 'Y'
        44: SequenceLikelihood.UNLIKELY,  # 'Z'
        1: SequenceLikelihood.UNLIKELY,  # 'a'
        20: SequenceLikelihood.UNLIKELY,  # 'b'
        11: SequenceLikelihood.NEGATIVE,  # 'c'
        14: SequenceLikelihood.UNLIKELY,  # 'd'
        2: SequenceLikelihood.LIKELY,  # 'e'
        31: SequenceLikelihood.NEGATIVE,  # 'f'
        22: SequenceLikelihood.NEGATIVE,  # 'g'
        23: SequenceLikelihood.NEGATIVE,  # 'h'
        3: SequenceLikelihood.UNLIKELY,  # 'i'
        19: SequenceLikelihood.NEGATIVE,  # 'j'
        13: SequenceLikelihood.UNLIKELY,  # 'k'
        18: SequenceLikelihood.UNLIKELY,  # 'l'
        15: SequenceLikelihood.UNLIKELY,  # 'm'
        5: SequenceLikelihood.UNLIKELY,  # 'n'
        4: SequenceLikelihood.UNLIKELY,  # 'o'
        16: SequenceLikelihood.NEGATIVE,  # 'p'
        63: SequenceLikelihood.NEGATIVE,  # 'q'
        7: SequenceLikelihood.UNLIKELY,  # 'r'
        9: SequenceLikelihood.UNLIKELY,  # 's'
        10: SequenceLikelihood.UNLIKELY,  # 't'
        17: SequenceLikelihood.UNLIKELY,  # 'u'
        55: SequenceLikelihood.NEGATIVE,  # 'v'
        8: SequenceLikelihood.UNLIKELY,  # 'w'
        57: SequenceLikelihood.NEGATIVE,  # 'x'
        12: SequenceLikelihood.LIKELY,  # 'y'
        6: SequenceLikelihood.UNLIKELY,  # 'z'
        66: SequenceLikelihood.UNLIKELY,  # 'Ó'
        27: SequenceLikelihood.UNLIKELY,  # 'ó'
        67: SequenceLikelihood.UNLIKELY,  # 'Ą'
        25: SequenceLikelihood.UNLIKELY,  # 'ą'
        68: SequenceLikelihood.NEGATIVE,  # 'Ć'
        29: SequenceLikelihood.NEGATIVE,  # 'ć'
        65: SequenceLikelihood.UNLIKELY,  # 'Ę'
        24: SequenceLikelihood.UNLIKELY,  # 'ę'
        61: SequenceLikelihood.UNLIKELY,  # 'Ł'
        21: SequenceLikelihood.UNLIKELY,  # 'ł'
        70: SequenceLikelihood.NEGATIVE,  # 'Ń'
        42: SequenceLikelihood.NEGATIVE,  # 'ń'
        59: SequenceLikelihood.UNLIKELY,  # 'Ś'
        28: SequenceLikelihood.NEGATIVE,  # 'ś'
        69: SequenceLikelihood.NEGATIVE,  # 'Ź'
        53: SequenceLikelihood.NEGATIVE,  # 'ź'
        62: SequenceLikelihood.UNLIKELY,  # 'Ż'
        26: SequenceLikelihood.UNLIKELY,  # 'ż'
    },
    26: {  # 'ż'
        34: SequenceLikelihood.UNLIKELY,  # 'A'
        46: SequenceLikelihood.UNLIKELY,  # 'B'
        39: SequenceLikelihood.UNLIKELY,  # 'C'
        41: SequenceLikelihood.UNLIKELY,  # 'D'
        48: SequenceLikelihood.UNLIKELY,  # 'E'
        52: SequenceLikelihood.UNLIKELY,  # 'F'
        49: SequenceLikelihood.UNLIKELY,  # 'G'
        54: SequenceLikelihood.UNLIKELY,  # 'H'
        43: SequenceLikelihood.UNLIKELY,  # 'I'
        47: SequenceLikelihood.UNLIKELY,  # 'J'
        37: SequenceLikelihood.UNLIKELY,  # 'K'
        50: SequenceLikelihood.UNLIKELY,  # 'L'
        35: SequenceLikelihood.UNLIKELY,  # 'M'
        36: SequenceLikelihood.UNLIKELY,  # 'N'
        40: SequenceLikelihood.UNLIKELY,  # 'O'
        30: SequenceLikelihood.UNLIKELY,  # 'P'
        64: SequenceLikelihood.NEGATIVE,  # 'Q'
        45: SequenceLikelihood.UNLIKELY,  # 'R'
        33: SequenceLikelihood.UNLIKELY,  # 'S'
        38: SequenceLikelihood.UNLIKELY,  # 'T'
        51: SequenceLikelihood.UNLIKELY,  # 'U'
        56: SequenceLikelihood.UNLIKELY,  # 'V'
        32: SequenceLikelihood.UNLIKELY,  # 'W'
        60: SequenceLikelihood.NEGATIVE,  # 'X'
        58: SequenceLikelihood.UNLIKELY,  # 'Y'
        44: SequenceLikelihood.UNLIKELY,  # 'Z'
        1: SequenceLikelihood.POSITIVE,  # 'a'
        20: SequenceLikelihood.LIKELY,  # 'b'
        11: SequenceLikelihood.LIKELY,  # 'c'
        14: SequenceLikelihood.POSITIVE,  # 'd'
        2: SequenceLikelihood.POSITIVE,  # 'e'
        31: SequenceLikelihood.UNLIKELY,  # 'f'
        22: SequenceLikelihood.UNLIKELY,  # 'g'
        23: SequenceLikelihood.UNLIKELY,  # 'h'
        3: SequenceLikelihood.UNLIKELY,  # 'i'
        19: SequenceLikelihood.UNLIKELY,  # 'j'
        13: SequenceLikelihood.POSITIVE,  # 'k'
        18: SequenceLikelihood.POSITIVE,  # 'l'
        15: SequenceLikelihood.UNLIKELY,  # 'm'
        5: SequenceLikelihood.POSITIVE,  # 'n'
        4: SequenceLikelihood.POSITIVE,  # 'o'
        16: SequenceLikelihood.UNLIKELY,  # 'p'
        63: SequenceLikelihood.NEGATIVE,  # 'q'
        7: SequenceLikelihood.UNLIKELY,  # 'r'
        9: SequenceLikelihood.POSITIVE,  # 's'
        10: SequenceLikelihood.UNLIKELY,  # 't'
        17: SequenceLikelihood.LIKELY,  # 'u'
        55: SequenceLikelihood.NEGATIVE,  # 'v'
        8: SequenceLikelihood.UNLIKELY,  # 'w'
        57: SequenceLikelihood.UNLIKELY,  # 'x'
        12: SequenceLikelihood.POSITIVE,  # 'y'
        6: SequenceLikelihood.UNLIKELY,  # 'z'
        66: SequenceLikelihood.NEGATIVE,  # 'Ó'
        27: SequenceLikelihood.LIKELY,  # 'ó'
        67: SequenceLikelihood.NEGATIVE,  # 'Ą'
        25: SequenceLikelihood.POSITIVE,  # 'ą'
        68: SequenceLikelihood.NEGATIVE,  # 'Ć'
        29: SequenceLikelihood.UNLIKELY,  # 'ć'
        65: SequenceLikelihood.NEGATIVE,  # 'Ę'
        24: SequenceLikelihood.LIKELY,  # 'ę'
        61: SequenceLikelihood.UNLIKELY,  # 'Ł'
        21: SequenceLikelihood.UNLIKELY,  # 'ł'
        70: SequenceLikelihood.NEGATIVE,  # 'Ń'
        42: SequenceLikelihood.UNLIKELY,  # 'ń'
        59: SequenceLikelihood.NEGATIVE,  # 'Ś'
        28: SequenceLikelihood.UNLIKELY,  # 'ś'
        69: SequenceLikelihood.NEGATIVE,  # 'Ź'
        53: SequenceLikelihood.UNLIKELY,  # 'ź'
        62: SequenceLikelihood.UNLIKELY,  # 'Ż'
        26: SequenceLikelihood.UNLIKELY,  # 'ż'
    },
}

# Character Mapping Table(s):
CP852_POLISH_CHAR_TO_ORDER = {
    0: CharacterCategory.CONTROL,  # '\x00'
    1: CharacterCategory.CONTROL,  # '\x01'
    2: CharacterCategory.CONTROL,  # '\x02'
    3: CharacterCategory.CONTROL,  # '\x03'
    4: CharacterCategory.CONTROL,  # '\x04'
    5: CharacterCategory.CONTROL,  # '\x05'
    6: CharacterCategory.CONTROL,  # '\x06'
    7: CharacterCategory.CONTROL,  # '\x07'
    8: CharacterCategory.CONTROL,  # '\x08'
    9: CharacterCategory.CONTROL,  # '\t'
    10: CharacterCategory.LINE_BREAK,  # '\n'
    11: CharacterCategory.CONTROL,  # '\x0b'
    12: CharacterCategory.CONTROL,  # '\x0c'
    13: CharacterCategory.LINE_BREAK,  # '\r'
    14: CharacterCategory.CONTROL,  # '\x0e'
    15: CharacterCategory.CONTROL,  # '\x0f'
    16: CharacterCategory.CONTROL,  # '\x10'
    17: CharacterCategory.CONTROL,  # '\x11'
    18: CharacterCategory.CONTROL,  # '\x12'
    19: CharacterCategory.CONTROL,  # '\x13'
    20: CharacterCategory.CONTROL,  # '\x14'
    21: CharacterCategory.CONTROL,  # '\x15'
    22: CharacterCategory.CONTROL,  # '\x16'
    23: CharacterCategory.CONTROL,  # '\x17'
    24: CharacterCategory.CONTROL,  # '\x18'
    25: CharacterCategory.CONTROL,  # '\x19'
    26: CharacterCategory.CONTROL,  # '\x1a'
    27: CharacterCategory.CONTROL,  # '\x1b'
    28: CharacterCategory.CONTROL,  # '\x1c'
    29: CharacterCategory.CONTROL,  # '\x1d'
    30: CharacterCategory.CONTROL,  # '\x1e'
    31: CharacterCategory.CONTROL,  # '\x1f'
    32: CharacterCategory.CONTROL,  # ' '
    33: CharacterCategory.SYMBOL,  # '!'
    34: CharacterCategory.SYMBOL,  # '"'
    35: CharacterCategory.SYMBOL,  # '#'
    36: CharacterCategory.SYMBOL,  # '$'
    37: CharacterCategory.SYMBOL,  # '%'
    38: CharacterCategory.SYMBOL,  # '&'
    39: CharacterCategory.SYMBOL,  # "'"
    40: CharacterCategory.SYMBOL,  # '('
    41: CharacterCategory.SYMBOL,  # ')'
    42: CharacterCategory.SYMBOL,  # '*'
    43: CharacterCategory.SYMBOL,  # '+'
    44: CharacterCategory.SYMBOL,  # ','
    45: CharacterCategory.SYMBOL,  # '-'
    46: CharacterCategory.SYMBOL,  # '.'
    47: CharacterCategory.SYMBOL,  # '/'
    48: CharacterCategory.DIGIT,  # '0'
    49: CharacterCategory.DIGIT,  # '1'
    50: CharacterCategory.DIGIT,  # '2'
    51: CharacterCategory.DIGIT,  # '3'
    52: CharacterCategory.DIGIT,  # '4'
    53: CharacterCategory.DIGIT,  # '5'
    54: CharacterCategory.DIGIT,  # '6'
    55: CharacterCategory.DIGIT,  # '7'
    56: CharacterCategory.DIGIT,  # '8'
    57: CharacterCategory.DIGIT,  # '9'
    58: CharacterCategory.SYMBOL,  # ':'
    59: CharacterCategory.SYMBOL,  # ';'
    60: CharacterCategory.SYMBOL,  # '<'
    61: CharacterCategory.SYMBOL,  # '='
    62: CharacterCategory.SYMBOL,  # '>'
    63: CharacterCategory.SYMBOL,  # '?'
    64: CharacterCategory.SYMBOL,  # '@'
    65: 34,  # 'A'
    66: 46,  # 'B'
    67: 39,  # 'C'
    68: 41,  # 'D'
    69: 48,  # 'E'
    70: 52,  # 'F'
    71: 49,  # 'G'
    72: 54,  # 'H'
    73: 43,  # 'I'
    74: 47,  # 'J'
    75: 37,  # 'K'
    76: 50,  # 'L'
    77: 35,  # 'M'
    78: 36,  # 'N'
    79: 40,  # 'O'
    80: 30,  # 'P'
    81: 64,  # 'Q'
    82: 45,  # 'R'
    83: 33,  # 'S'
    84: 38,  # 'T'
    85: 51,  # 'U'
    86: 56,  # 'V'
    87: 32,  # 'W'
    88: 60,  # 'X'
    89: 58,  # 'Y'
    90: 44,  # 'Z'
    91: CharacterCategory.SYMBOL,  # '['
    92: CharacterCategory.SYMBOL,  # '\\'
    93: CharacterCategory.SYMBOL,  # ']'
    94: CharacterCategory.SYMBOL,  # '^'
    95: CharacterCategory.SYMBOL,  # '_'
    96: CharacterCategory.SYMBOL,  # '`'
    97: 1,  # 'a'
    98: 20,  # 'b'
    99: 11,  # 'c'
    100: 14,  # 'd'
    101: 2,  # 'e'
    102: 31,  # 'f'
    103: 22,  # 'g'
    104: 23,  # 'h'
    105: 3,  # 'i'
    106: 19,  # 'j'
    107: 13,  # 'k'
    108: 18,  # 'l'
    109: 15,  # 'm'
    110: 5,  # 'n'
    111: 4,  # 'o'
    112: 16,  # 'p'
    113: 63,  # 'q'
    114: 7,  # 'r'
    115: 9,  # 's'
    116: 10,  # 't'
    117: 17,  # 'u'
    118: 55,  # 'v'
    119: 8,  # 'w'
    120: 57,  # 'x'
    121: 12,  # 'y'
    122: 6,  # 'z'
    123: CharacterCategory.SYMBOL,  # '{'
    124: CharacterCategory.SYMBOL,  # '|'
    125: CharacterCategory.SYMBOL,  # '}'
    126: CharacterCategory.SYMBOL,  # '~'
    127: CharacterCategory.CONTROL,  # '\x7f'
    128: 0,  # 'Ç'
    129: 0,  # 'ü'
    130: 0,  # 'é'
    131: 0,  # 'â'
    132: 0,  # 'ä'
    133: 0,  # 'ů'
    134: 29,  # 'ć'
    135: 0,  # 'ç'
    136: 21,  # 'ł'
    137: 0,  # 'ë'
    138: 0,  # 'Ő'
    139: 0,  # 'ő'
    140: 0,  # 'î'
    141: 69,  # 'Ź'
    142: 0,  # 'Ä'
    143: 68,  # 'Ć'
    144: 0,  # 'É'
    145: 0,  # 'Ĺ'
    146: 0,  # 'ĺ'
    147: 0,  # 'ô'
    148: 0,  # 'ö'
    149: 0,  # 'Ľ'
    150: 0,  # 'ľ'
    151: 59,  # 'Ś'
    152: 28,  # 'ś'
    153: 0,  # 'Ö'
    154: 0,  # 'Ü'
    155: 0,  # 'Ť'
    156: 0,  # 'ť'
    157: 61,  # 'Ł'
    158: CharacterCategory.SYMBOL,  # '×'
    159: 0,  # 'č'
    160: 0,  # 'á'
    161: 0,  # 'í'
    162: 27,  # 'ó'
    163: 0,  # 'ú'
    164: 67,  # 'Ą'
    165: 25,  # 'ą'
    166: 0,  # 'Ž'
    167: 0,  # 'ž'
    168: 65,  # 'Ę'
    169: 24,  # 'ę'
    170: CharacterCategory.SYMBOL,  # '¬'
    171: 53,  # 'ź'
    172: 0,  # 'Č'
    173: 0,  # 'ş'
    174: CharacterCategory.SYMBOL,  # '«'
    175: CharacterCategory.SYMBOL,  # '»'
    176: CharacterCategory.SYMBOL,  # '░'
    177: CharacterCategory.SYMBOL,  # '▒'
    178: CharacterCategory.SYMBOL,  # '▓'
    179: CharacterCategory.SYMBOL,  # '│'
    180: CharacterCategory.SYMBOL,  # '┤'
    181: 0,  # 'Á'
    182: 0,  # 'Â'
    183: 0,  # 'Ě'
    184: 0,  # 'Ş'
    185: CharacterCategory.SYMBOL,  # '╣'
    186: CharacterCategory.SYMBOL,  # '║'
    187: CharacterCategory.SYMBOL,  # '╗'
    188: CharacterCategory.SYMBOL,  # '╝'
    189: 62,  # 'Ż'
    190: 26,  # 'ż'
    191: CharacterCategory.SYMBOL,  # '┐'
    192: CharacterCategory.SYMBOL,  # '└'
    193: CharacterCategory.SYMBOL,  # '┴'
    194: CharacterCategory.SYMBOL,  # '┬'
    195: CharacterCategory.SYMBOL,  # '├'
    196: CharacterCategory.SYMBOL,  # '─'
    197: CharacterCategory.SYMBOL,  # '┼'
    198: 0,  # 'Ă'
    199: 0,  # 'ă'
    200: CharacterCategory.SYMBOL,  # '╚'
    201: CharacterCategory.SYMBOL,  # '╔'
    202: CharacterCategory.SYMBOL,  # '╩'
    203: CharacterCategory.SYMBOL,  # '╦'
    204: CharacterCategory.SYMBOL,  # '╠'
    205: CharacterCategory.SYMBOL,  # '═'
    206: CharacterCategory.SYMBOL,  # '╬'
    207: CharacterCategory.SYMBOL,  # '¤'
    208: 0,  # 'đ'
    209: 0,  # 'Đ'
    210: 0,  # 'Ď'
    211: 0,  # 'Ë'
    212: 0,  # 'ď'
    213: 0,  # 'Ň'
    214: 0,  # 'Í'
    215: 0,  # 'Î'
    216: 0,  # 'ě'
    217: CharacterCategory.SYMBOL,  # '┘'
    218: CharacterCategory.SYMBOL,  # '┌'
    219: CharacterCategory.SYMBOL,  # '█'
    220: CharacterCategory.SYMBOL,  # '▄'
    221: 0,  # 'Ţ'
    222: 0,  # 'Ů'
    223: CharacterCategory.SYMBOL,  # '▀'
    224: 66,  # 'Ó'
    225: 0,  # 'ß'
    226: 0,  # 'Ô'
    227: 70,  # 'Ń'
    228: 42,  # 'ń'
    229: 0,  # 'ň'
    230: 0,  # 'Š'
    231: 0,  # 'š'
    232: 0,  # 'Ŕ'
    233: 0,  # 'Ú'
    234: 0,  # 'ŕ'
    235: 0,  # 'Ű'
    236: 0,  # 'ý'
    237: 0,  # 'Ý'
    238: 0,  # 'ţ'
    239: CharacterCategory.SYMBOL,  # '´'
    240: CharacterCategory.CONTROL,  # '\xad'
    241: CharacterCategory.SYMBOL,  # '˝'
    242: CharacterCategory.SYMBOL,  # '˛'
    243: 0,  # 'ˇ'
    244: CharacterCategory.SYMBOL,  # '˘'
    245: CharacterCategory.SYMBOL,  # '§'
    246: CharacterCategory.SYMBOL,  # '÷'
    247: CharacterCategory.SYMBOL,  # '¸'
    248: CharacterCategory.SYMBOL,  # '°'
    249: CharacterCategory.SYMBOL,  # '¨'
    250: CharacterCategory.SYMBOL,  # '˙'
    251: 0,  # 'ű'
    252: 0,  # 'Ř'
    253: 0,  # 'ř'
    254: CharacterCategory.SYMBOL,  # '■'
    255: CharacterCategory.CONTROL,  # '\xa0'
}

CP852_POLISH_MODEL = SingleByteCharSetModel(
    charset_name="CP852",
    language="Polish",
    char_to_order_map=CP852_POLISH_CHAR_TO_ORDER,
    language_model=POLISH_LANG_MODEL,
    typical_positive_ratio=0.9630494627274031,
    keep_ascii_letters=True,
    alphabet="ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyzÓóĄąĆćĘęŁłŃńŚśŹźŻż",
)

ISO_8859_2_POLISH_CHAR_TO_ORDER = {
    0: CharacterCategory.CONTROL,  # '\x00'
    1: CharacterCategory.CONTROL,  # '\x01'
    2: CharacterCategory.CONTROL,  # '\x02'
    3: CharacterCategory.CONTROL,  # '\x03'
    4: CharacterCategory.CONTROL,  # '\x04'
    5: CharacterCategory.CONTROL,  # '\x05'
    6: CharacterCategory.CONTROL,  # '\x06'
    7: CharacterCategory.CONTROL,  # '\x07'
    8: CharacterCategory.CONTROL,  # '\x08'
    9: CharacterCategory.CONTROL,  # '\t'
    10: CharacterCategory.LINE_BREAK,  # '\n'
    11: CharacterCategory.CONTROL,  # '\x0b'
    12: CharacterCategory.CONTROL,  # '\x0c'
    13: CharacterCategory.LINE_BREAK,  # '\r'
    14: CharacterCategory.CONTROL,  # '\x0e'
    15: CharacterCategory.CONTROL,  # '\x0f'
    16: CharacterCategory.CONTROL,  # '\x10'
    17: CharacterCategory.CONTROL,  # '\x11'
    18: CharacterCategory.CONTROL,  # '\x12'
    19: CharacterCategory.CONTROL,  # '\x13'
    20: CharacterCategory.CONTROL,  # '\x14'
    21: CharacterCategory.CONTROL,  # '\x15'
    22: CharacterCategory.CONTROL,  # '\x16'
    23: CharacterCategory.CONTROL,  # '\x17'
    24: CharacterCategory.CONTROL,  # '\x18'
    25: CharacterCategory.CONTROL,  # '\x19'
    26: CharacterCategory.CONTROL,  # '\x1a'
    27: CharacterCategory.CONTROL,  # '\x1b'
    28: CharacterCategory.CONTROL,  # '\x1c'
    29: CharacterCategory.CONTROL,  # '\x1d'
    30: CharacterCategory.CONTROL,  # '\x1e'
    31: CharacterCategory.CONTROL,  # '\x1f'
    32: CharacterCategory.CONTROL,  # ' '
    33: CharacterCategory.SYMBOL,  # '!'
    34: CharacterCategory.SYMBOL,  # '"'
    35: CharacterCategory.SYMBOL,  # '#'
    36: CharacterCategory.SYMBOL,  # '$'
    37: CharacterCategory.SYMBOL,  # '%'
    38: CharacterCategory.SYMBOL,  # '&'
    39: CharacterCategory.SYMBOL,  # "'"
    40: CharacterCategory.SYMBOL,  # '('
    41: CharacterCategory.SYMBOL,  # ')'
    42: CharacterCategory.SYMBOL,  # '*'
    43: CharacterCategory.SYMBOL,  # '+'
    44: CharacterCategory.SYMBOL,  # ','
    45: CharacterCategory.SYMBOL,  # '-'
    46: CharacterCategory.SYMBOL,  # '.'
    47: CharacterCategory.SYMBOL,  # '/'
    48: CharacterCategory.DIGIT,  # '0'
    49: CharacterCategory.DIGIT,  # '1'
    50: CharacterCategory.DIGIT,  # '2'
    51: CharacterCategory.DIGIT,  # '3'
    52: CharacterCategory.DIGIT,  # '4'
    53: CharacterCategory.DIGIT,  # '5'
    54: CharacterCategory.DIGIT,  # '6'
    55: CharacterCategory.DIGIT,  # '7'
    56: CharacterCategory.DIGIT,  # '8'
    57: CharacterCategory.DIGIT,  # '9'
    58: CharacterCategory.SYMBOL,  # ':'
    59: CharacterCategory.SYMBOL,  # ';'
    60: CharacterCategory.SYMBOL,  # '<'
    61: CharacterCategory.SYMBOL,  # '='
    62: CharacterCategory.SYMBOL,  # '>'
    63: CharacterCategory.SYMBOL,  # '?'
    64: CharacterCategory.SYMBOL,  # '@'
    65: 34,  # 'A'
    66: 46,  # 'B'
    67: 39,  # 'C'
    68: 41,  # 'D'
    69: 48,  # 'E'
    70: 52,  # 'F'
    71: 49,  # 'G'
    72: 54,  # 'H'
    73: 43,  # 'I'
    74: 47,  # 'J'
    75: 37,  # 'K'
    76: 50,  # 'L'
    77: 35,  # 'M'
    78: 36,  # 'N'
    79: 40,  # 'O'
    80: 30,  # 'P'
    81: 64,  # 'Q'
    82: 45,  # 'R'
    83: 33,  # 'S'
    84: 38,  # 'T'
    85: 51,  # 'U'
    86: 56,  # 'V'
    87: 32,  # 'W'
    88: 60,  # 'X'
    89: 58,  # 'Y'
    90: 44,  # 'Z'
    91: CharacterCategory.SYMBOL,  # '['
    92: CharacterCategory.SYMBOL,  # '\\'
    93: CharacterCategory.SYMBOL,  # ']'
    94: CharacterCategory.SYMBOL,  # '^'
    95: CharacterCategory.SYMBOL,  # '_'
    96: CharacterCategory.SYMBOL,  # '`'
    97: 1,  # 'a'
    98: 20,  # 'b'
    99: 11,  # 'c'
    100: 14,  # 'd'
    101: 2,  # 'e'
    102: 31,  # 'f'
    103: 22,  # 'g'
    104: 23,  # 'h'
    105: 3,  # 'i'
    106: 19,  # 'j'
    107: 13,  # 'k'
    108: 18,  # 'l'
    109: 15,  # 'm'
    110: 5,  # 'n'
    111: 4,  # 'o'
    112: 16,  # 'p'
    113: 63,  # 'q'
    114: 7,  # 'r'
    115: 9,  # 's'
    116: 10,  # 't'
    117: 17,  # 'u'
    118: 55,  # 'v'
    119: 8,  # 'w'
    120: 57,  # 'x'
    121: 12,  # 'y'
    122: 6,  # 'z'
    123: CharacterCategory.SYMBOL,  # '{'
    124: CharacterCategory.SYMBOL,  # '|'
    125: CharacterCategory.SYMBOL,  # '}'
    126: CharacterCategory.SYMBOL,  # '~'
    127: CharacterCategory.CONTROL,  # '\x7f'
    128: CharacterCategory.CONTROL,  # '\x80'
    129: CharacterCategory.CONTROL,  # '\x81'
    130: CharacterCategory.CONTROL,  # '\x82'
    131: CharacterCategory.CONTROL,  # '\x83'
    132: CharacterCategory.CONTROL,  # '\x84'
    133: CharacterCategory.CONTROL,  # '\x85'
    134: CharacterCategory.CONTROL,  # '\x86'
    135: CharacterCategory.CONTROL,  # '\x87'
    136: CharacterCategory.CONTROL,  # '\x88'
    137: CharacterCategory.CONTROL,  # '\x89'
    138: CharacterCategory.CONTROL,  # '\x8a'
    139: CharacterCategory.CONTROL,  # '\x8b'
    140: CharacterCategory.CONTROL,  # '\x8c'
    141: CharacterCategory.CONTROL,  # '\x8d'
    142: CharacterCategory.CONTROL,  # '\x8e'
    143: CharacterCategory.CONTROL,  # '\x8f'
    144: CharacterCategory.CONTROL,  # '\x90'
    145: CharacterCategory.CONTROL,  # '\x91'
    146: CharacterCategory.CONTROL,  # '\x92'
    147: CharacterCategory.CONTROL,  # '\x93'
    148: CharacterCategory.CONTROL,  # '\x94'
    149: CharacterCategory.CONTROL,  # '\x95'
    150: CharacterCategory.CONTROL,  # '\x96'
    151: CharacterCategory.CONTROL,  # '\x97'
    152: CharacterCategory.CONTROL,  # '\x98'
    153: CharacterCategory.CONTROL,  # '\x99'
    154: CharacterCategory.CONTROL,  # '\x9a'
    155: CharacterCategory.CONTROL,  # '\x9b'
    156: CharacterCategory.CONTROL,  # '\x9c'
    157: CharacterCategory.CONTROL,  # '\x9d'
    158: CharacterCategory.CONTROL,  # '\x9e'
    159: CharacterCategory.CONTROL,  # '\x9f'
    160: CharacterCategory.CONTROL,  # '\xa0'
    161: 67,  # 'Ą'
    162: CharacterCategory.SYMBOL,  # '˘'
    163: 61,  # 'Ł'
    164: CharacterCategory.SYMBOL,  # '¤'
    165: 0,  # 'Ľ'
    166: 59,  # 'Ś'
    167: CharacterCategory.SYMBOL,  # '§'
    168: CharacterCategory.SYMBOL,  # '¨'
    169: 0,  # 'Š'
    170: 0,  # 'Ş'
    171: 0,  # 'Ť'
    172: 69,  # 'Ź'
    173: CharacterCategory.CONTROL,  # '\xad'
    174: 0,  # 'Ž'
    175: 62,  # 'Ż'
    176: CharacterCategory.SYMBOL,  # '°'
    177: 25,  # 'ą'
    178: CharacterCategory.SYMBOL,  # '˛'
    179: 21,  # 'ł'
    180: CharacterCategory.SYMBOL,  # '´'
    181: 0,  # 'ľ'
    182: 28,  # 'ś'
    183: 0,  # 'ˇ'
    184: CharacterCategory.SYMBOL,  # '¸'
    185: 0,  # 'š'
    186: 0,  # 'ş'
    187: 0,  # 'ť'
    188: 53,  # 'ź'
    189: CharacterCategory.SYMBOL,  # '˝'
    190: 0,  # 'ž'
    191: 26,  # 'ż'
    192: 0,  # 'Ŕ'
    193: 0,  # 'Á'
    194: 0,  # 'Â'
    195: 0,  # 'Ă'
    196: 0,  # 'Ä'
    197: 0,  # 'Ĺ'
    198: 68,  # 'Ć'
    199: 0,  # 'Ç'
    200: 0,  # 'Č'
    201: 0,  # 'É'
    202: 65,  # 'Ę'
    203: 0,  # 'Ë'
    204: 0,  # 'Ě'
    205: 0,  # 'Í'
    206: 0,  # 'Î'
    207: 0,  # 'Ď'
    208: 0,  # 'Đ'
    209: 70,  # 'Ń'
    210: 0,  # 'Ň'
    211: 66,  # 'Ó'
    212: 0,  # 'Ô'
    213: 0,  # 'Ő'
    214: 0,  # 'Ö'
    215: CharacterCategory.SYMBOL,  # '×'
    216: 0,  # 'Ř'
    217: 0,  # 'Ů'
    218: 0,  # 'Ú'
    219: 0,  # 'Ű'
    220: 0,  # 'Ü'
    221: 0,  # 'Ý'
    222: 0,  # 'Ţ'
    223: 0,  # 'ß'
    224: 0,  # 'ŕ'
    225: 0,  # 'á'
    226: 0,  # 'â'
    227: 0,  # 'ă'
    228: 0,  # 'ä'
    229: 0,  # 'ĺ'
    230: 29,  # 'ć'
    231: 0,  # 'ç'
    232: 0,  # 'č'
    233: 0,  # 'é'
    234: 24,  # 'ę'
    235: 0,  # 'ë'
    236: 0,  # 'ě'
    237: 0,  # 'í'
    238: 0,  # 'î'
    239: 0,  # 'ď'
    240: 0,  # 'đ'
    241: 42,  # 'ń'
    242: 0,  # 'ň'
    243: 27,  # 'ó'
    244: 0,  # 'ô'
    245: 0,  # 'ő'
    246: 0,  # 'ö'
    247: CharacterCategory.SYMBOL,  # '÷'
    248: 0,  # 'ř'
    249: 0,  # 'ů'
    250: 0,  # 'ú'
    251: 0,  # 'ű'
    252: 0,  # 'ü'
    253: 0,  # 'ý'
    254: 0,  # 'ţ'
    255: CharacterCategory.SYMBOL,  # '˙'
}

ISO_8859_2_POLISH_MODEL = SingleByteCharSetModel(
    charset_name="ISO-8859-2",
    language="Polish",
    char_to_order_map=ISO_8859_2_POLISH_CHAR_TO_ORDER,
    language_model=POLISH_LANG_MODEL,
    typical_positive_ratio=0.9630494627274031,
    keep_ascii_letters=True,
    alphabet="ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyzÓóĄąĆćĘęŁłŃńŚśŹźŻż",
)

ISO_8859_16_POLISH_CHAR_TO_ORDER = {
    0: CharacterCategory.CONTROL,  # '\x00'
    1: CharacterCategory.CONTROL,  # '\x01'
    2: CharacterCategory.CONTROL,  # '\x02'
    3: CharacterCategory.CONTROL,  # '\x03'
    4: CharacterCategory.CONTROL,  # '\x04'
    5: CharacterCategory.CONTROL,  # '\x05'
    6: CharacterCategory.CONTROL,  # '\x06'
    7: CharacterCategory.CONTROL,  # '\x07'
    8: CharacterCategory.CONTROL,  # '\x08'
    9: CharacterCategory.CONTROL,  # '\t'
    10: CharacterCategory.LINE_BREAK,  # '\n'
    11: CharacterCategory.CONTROL,  # '\x0b'
    12: CharacterCategory.CONTROL,  # '\x0c'
    13: CharacterCategory.LINE_BREAK,  # '\r'
    14: CharacterCategory.CONTROL,  # '\x0e'
    15: CharacterCategory.CONTROL,  # '\x0f'
    16: CharacterCategory.CONTROL,  # '\x10'
    17: CharacterCategory.CONTROL,  # '\x11'
    18: CharacterCategory.CONTROL,  # '\x12'
    19: CharacterCategory.CONTROL,  # '\x13'
    20: CharacterCategory.CONTROL,  # '\x14'
    21: CharacterCategory.CONTROL,  # '\x15'
    22: CharacterCategory.CONTROL,  # '\x16'
    23: CharacterCategory.CONTROL,  # '\x17'
    24: CharacterCategory.CONTROL,  # '\x18'
    25: CharacterCategory.CONTROL,  # '\x19'
    26: CharacterCategory.CONTROL,  # '\x1a'
    27: CharacterCategory.CONTROL,  # '\x1b'
    28: CharacterCategory.CONTROL,  # '\x1c'
    29: CharacterCategory.CONTROL,  # '\x1d'
    30: CharacterCategory.CONTROL,  # '\x1e'
    31: CharacterCategory.CONTROL,  # '\x1f'
    32: CharacterCategory.CONTROL,  # ' '
    33: CharacterCategory.SYMBOL,  # '!'
    34: CharacterCategory.SYMBOL,  # '"'
    35: CharacterCategory.SYMBOL,  # '#'
    36: CharacterCategory.SYMBOL,  # '$'
    37: CharacterCategory.SYMBOL,  # '%'
    38: CharacterCategory.SYMBOL,  # '&'
    39: CharacterCategory.SYMBOL,  # "'"
    40: CharacterCategory.SYMBOL,  # '('
    41: CharacterCategory.SYMBOL,  # ')'
    42: CharacterCategory.SYMBOL,  # '*'
    43: CharacterCategory.SYMBOL,  # '+'
    44: CharacterCategory.SYMBOL,  # ','
    45: CharacterCategory.SYMBOL,  # '-'
    46: CharacterCategory.SYMBOL,  # '.'
    47: CharacterCategory.SYMBOL,  # '/'
    48: CharacterCategory.DIGIT,  # '0'
    49: CharacterCategory.DIGIT,  # '1'
    50: CharacterCategory.DIGIT,  # '2'
    51: CharacterCategory.DIGIT,  # '3'
    52: CharacterCategory.DIGIT,  # '4'
    53: CharacterCategory.DIGIT,  # '5'
    54: CharacterCategory.DIGIT,  # '6'
    55: CharacterCategory.DIGIT,  # '7'
    56: CharacterCategory.DIGIT,  # '8'
    57: CharacterCategory.DIGIT,  # '9'
    58: CharacterCategory.SYMBOL,  # ':'
    59: CharacterCategory.SYMBOL,  # ';'
    60: CharacterCategory.SYMBOL,  # '<'
    61: CharacterCategory.SYMBOL,  # '='
    62: CharacterCategory.SYMBOL,  # '>'
    63: CharacterCategory.SYMBOL,  # '?'
    64: CharacterCategory.SYMBOL,  # '@'
    65: 34,  # 'A'
    66: 46,  # 'B'
    67: 39,  # 'C'
    68: 41,  # 'D'
    69: 48,  # 'E'
    70: 52,  # 'F'
    71: 49,  # 'G'
    72: 54,  # 'H'
    73: 43,  # 'I'
    74: 47,  # 'J'
    75: 37,  # 'K'
    76: 50,  # 'L'
    77: 35,  # 'M'
    78: 36,  # 'N'
    79: 40,  # 'O'
    80: 30,  # 'P'
    81: 64,  # 'Q'
    82: 45,  # 'R'
    83: 33,  # 'S'
    84: 38,  # 'T'
    85: 51,  # 'U'
    86: 56,  # 'V'
    87: 32,  # 'W'
    88: 60,  # 'X'
    89: 58,  # 'Y'
    90: 44,  # 'Z'
    91: CharacterCategory.SYMBOL,  # '['
    92: CharacterCategory.SYMBOL,  # '\\'
    93: CharacterCategory.SYMBOL,  # ']'
    94: CharacterCategory.SYMBOL,  # '^'
    95: CharacterCategory.SYMBOL,  # '_'
    96: CharacterCategory.SYMBOL,  # '`'
    97: 1,  # 'a'
    98: 20,  # 'b'
    99: 11,  # 'c'
    100: 14,  # 'd'
    101: 2,  # 'e'
    102: 31,  # 'f'
    103: 22,  # 'g'
    104: 23,  # 'h'
    105: 3,  # 'i'
    106: 19,  # 'j'
    107: 13,  # 'k'
    108: 18,  # 'l'
    109: 15,  # 'm'
    110: 5,  # 'n'
    111: 4,  # 'o'
    112: 16,  # 'p'
    113: 63,  # 'q'
    114: 7,  # 'r'
    115: 9,  # 's'
    116: 10,  # 't'
    117: 17,  # 'u'
    118: 55,  # 'v'
    119: 8,  # 'w'
    120: 57,  # 'x'
    121: 12,  # 'y'
    122: 6,  # 'z'
    123: CharacterCategory.SYMBOL,  # '{'
    124: CharacterCategory.SYMBOL,  # '|'
    125: CharacterCategory.SYMBOL,  # '}'
    126: CharacterCategory.SYMBOL,  # '~'
    127: CharacterCategory.CONTROL,  # '\x7f'
    128: CharacterCategory.CONTROL,  # '\x80'
    129: CharacterCategory.CONTROL,  # '\x81'
    130: CharacterCategory.CONTROL,  # '\x82'
    131: CharacterCategory.CONTROL,  # '\x83'
    132: CharacterCategory.CONTROL,  # '\x84'
    133: CharacterCategory.CONTROL,  # '\x85'
    134: CharacterCategory.CONTROL,  # '\x86'
    135: CharacterCategory.CONTROL,  # '\x87'
    136: CharacterCategory.CONTROL,  # '\x88'
    137: CharacterCategory.CONTROL,  # '\x89'
    138: CharacterCategory.CONTROL,  # '\x8a'
    139: CharacterCategory.CONTROL,  # '\x8b'
    140: CharacterCategory.CONTROL,  # '\x8c'
    141: CharacterCategory.CONTROL,  # '\x8d'
    142: CharacterCategory.CONTROL,  # '\x8e'
    143: CharacterCategory.CONTROL,  # '\x8f'
    144: CharacterCategory.CONTROL,  # '\x90'
    145: CharacterCategory.CONTROL,  # '\x91'
    146: CharacterCategory.CONTROL,  # '\x92'
    147: CharacterCategory.CONTROL,  # '\x93'
    148: CharacterCategory.CONTROL,  # '\x94'
    149: CharacterCategory.CONTROL,  # '\x95'
    150: CharacterCategory.CONTROL,  # '\x96'
    151: CharacterCategory.CONTROL,  # '\x97'
    152: CharacterCategory.CONTROL,  # '\x98'
    153: CharacterCategory.CONTROL,  # '\x99'
    154: CharacterCategory.CONTROL,  # '\x9a'
    155: CharacterCategory.CONTROL,  # '\x9b'
    156: CharacterCategory.CONTROL,  # '\x9c'
    157: CharacterCategory.CONTROL,  # '\x9d'
    158: CharacterCategory.CONTROL,  # '\x9e'
    159: CharacterCategory.CONTROL,  # '\x9f'
    160: CharacterCategory.CONTROL,  # '\xa0'
    161: 67,  # 'Ą'
    162: 25,  # 'ą'
    163: 61,  # 'Ł'
    164: CharacterCategory.SYMBOL,  # '€'
    165: CharacterCategory.SYMBOL,  # '„'
    166: 0,  # 'Š'
    167: CharacterCategory.SYMBOL,  # '§'
    168: 0,  # 'š'
    169: CharacterCategory.SYMBOL,  # '©'
    170: 0,  # 'Ș'
    171: CharacterCategory.SYMBOL,  # '«'
    172: 69,  # 'Ź'
    173: CharacterCategory.CONTROL,  # '\xad'
    174: 53,  # 'ź'
    175: 62,  # 'Ż'
    176: CharacterCategory.SYMBOL,  # '°'
    177: CharacterCategory.SYMBOL,  # '±'
    178: 0,  # 'Č'
    179: 21,  # 'ł'
    180: 0,  # 'Ž'
    181: CharacterCategory.SYMBOL,  # '”'
    182: CharacterCategory.SYMBOL,  # '¶'
    183: CharacterCategory.SYMBOL,  # '·'
    184: 0,  # 'ž'
    185: 0,  # 'č'
    186: 0,  # 'ș'
    187: CharacterCategory.SYMBOL,  # '»'
    188: 0,  # 'Œ'
    189: 0,  # 'œ'
    190: 0,  # 'Ÿ'
    191: 26,  # 'ż'
    192: 0,  # 'À'
    193: 0,  # 'Á'
    194: 0,  # 'Â'
    195: 0,  # 'Ă'
    196: 0,  # 'Ä'
    197: 68,  # 'Ć'
    198: 0,  # 'Æ'
    199: 0,  # 'Ç'
    200: 0,  # 'È'
    201: 0,  # 'É'
    202: 0,  # 'Ê'
    203: 0,  # 'Ë'
    204: 0,  # 'Ì'
    205: 0,  # 'Í'
    206: 0,  # 'Î'
    207: 0,  # 'Ï'
    208: 0,  # 'Đ'
    209: 70,  # 'Ń'
    210: 0,  # 'Ò'
    211: 66,  # 'Ó'
    212: 0,  # 'Ô'
    213: 0,  # 'Ő'
    214: 0,  # 'Ö'
    215: 59,  # 'Ś'
    216: 0,  # 'Ű'
    217: 0,  # 'Ù'
    218: 0,  # 'Ú'
    219: 0,  # 'Û'
    220: 0,  # 'Ü'
    221: 65,  # 'Ę'
    222: 0,  # 'Ț'
    223: 0,  # 'ß'
    224: 0,  # 'à'
    225: 0,  # 'á'
    226: 0,  # 'â'
    227: 0,  # 'ă'
    228: 0,  # 'ä'
    229: 29,  # 'ć'
    230: 0,  # 'æ'
    231: 0,  # 'ç'
    232: 0,  # 'è'
    233: 0,  # 'é'
    234: 0,  # 'ê'
    235: 0,  # 'ë'
    236: 0,  # 'ì'
    237: 0,  # 'í'
    238: 0,  # 'î'
    239: 0,  # 'ï'
    240: 0,  # 'đ'
    241: 42,  # 'ń'
    242: 0,  # 'ò'
    243: 27,  # 'ó'
    244: 0,  # 'ô'
    245: 0,  # 'ő'
    246: 0,  # 'ö'
    247: 28,  # 'ś'
    248: 0,  # 'ű'
    249: 0,  # 'ù'
    250: 0,  # 'ú'
    251: 0,  # 'û'
    252: 0,  # 'ü'
    253: 24,  # 'ę'
    254: 0,  # 'ț'
    255: 0,  # 'ÿ'
}

ISO_8859_16_POLISH_MODEL = SingleByteCharSetModel(
    charset_name="ISO-8859-16",
    language="Polish",
    char_to_order_map=ISO_8859_16_POLISH_CHAR_TO_ORDER,
    language_model=POLISH_LANG_MODEL,
    typical_positive_ratio=0.9630494627274031,
    keep_ascii_letters=True,
    alphabet="ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyzÓóĄąĆćĘęŁłŃńŚśŹźŻż",
)

MACLATIN2_POLISH_CHAR_TO_ORDER = {
    0: CharacterCategory.CONTROL,  # '\x00'
    1: CharacterCategory.CONTROL,  # '\x01'
    2: CharacterCategory.CONTROL,  # '\x02'
    3: CharacterCategory.CONTROL,  # '\x03'
    4: CharacterCategory.CONTROL,  # '\x04'
    5: CharacterCategory.CONTROL,  # '\x05'
    6: CharacterCategory.CONTROL,  # '\x06'
    7: CharacterCategory.CONTROL,  # '\x07'
    8: CharacterCategory.CONTROL,  # '\x08'
    9: CharacterCategory.CONTROL,  # '\t'
    10: CharacterCategory.LINE_BREAK,  # '\n'
    11: CharacterCategory.CONTROL,  # '\x0b'
    12: CharacterCategory.CONTROL,  # '\x0c'
    13: CharacterCategory.LINE_BREAK,  # '\r'
    14: CharacterCategory.CONTROL,  # '\x0e'
    15: CharacterCategory.CONTROL,  # '\x0f'
    16: CharacterCategory.CONTROL,  # '\x10'
    17: CharacterCategory.CONTROL,  # '\x11'
    18: CharacterCategory.CONTROL,  # '\x12'
    19: CharacterCategory.CONTROL,  # '\x13'
    20: CharacterCategory.CONTROL,  # '\x14'
    21: CharacterCategory.CONTROL,  # '\x15'
    22: CharacterCategory.CONTROL,  # '\x16'
    23: CharacterCategory.CONTROL,  # '\x17'
    24: CharacterCategory.CONTROL,  # '\x18'
    25: CharacterCategory.CONTROL,  # '\x19'
    26: CharacterCategory.CONTROL,  # '\x1a'
    27: CharacterCategory.CONTROL,  # '\x1b'
    28: CharacterCategory.CONTROL,  # '\x1c'
    29: CharacterCategory.CONTROL,  # '\x1d'
    30: CharacterCategory.CONTROL,  # '\x1e'
    31: CharacterCategory.CONTROL,  # '\x1f'
    32: CharacterCategory.CONTROL,  # ' '
    33: CharacterCategory.SYMBOL,  # '!'
    34: CharacterCategory.SYMBOL,  # '"'
    35: CharacterCategory.SYMBOL,  # '#'
    36: CharacterCategory.SYMBOL,  # '$'
    37: CharacterCategory.SYMBOL,  # '%'
    38: CharacterCategory.SYMBOL,  # '&'
    39: CharacterCategory.SYMBOL,  # "'"
    40: CharacterCategory.SYMBOL,  # '('
    41: CharacterCategory.SYMBOL,  # ')'
    42: CharacterCategory.SYMBOL,  # '*'
    43: CharacterCategory.SYMBOL,  # '+'
    44: CharacterCategory.SYMBOL,  # ','
    45: CharacterCategory.SYMBOL,  # '-'
    46: CharacterCategory.SYMBOL,  # '.'
    47: CharacterCategory.SYMBOL,  # '/'
    48: CharacterCategory.DIGIT,  # '0'
    49: CharacterCategory.DIGIT,  # '1'
    50: CharacterCategory.DIGIT,  # '2'
    51: CharacterCategory.DIGIT,  # '3'
    52: CharacterCategory.DIGIT,  # '4'
    53: CharacterCategory.DIGIT,  # '5'
    54: CharacterCategory.DIGIT,  # '6'
    55: CharacterCategory.DIGIT,  # '7'
    56: CharacterCategory.DIGIT,  # '8'
    57: CharacterCategory.DIGIT,  # '9'
    58: CharacterCategory.SYMBOL,  # ':'
    59: CharacterCategory.SYMBOL,  # ';'
    60: CharacterCategory.SYMBOL,  # '<'
    61: CharacterCategory.SYMBOL,  # '='
    62: CharacterCategory.SYMBOL,  # '>'
    63: CharacterCategory.SYMBOL,  # '?'
    64: CharacterCategory.SYMBOL,  # '@'
    65: 34,  # 'A'
    66: 46,  # 'B'
    67: 39,  # 'C'
    68: 41,  # 'D'
    69: 48,  # 'E'
    70: 52,  # 'F'
    71: 49,  # 'G'
    72: 54,  # 'H'
    73: 43,  # 'I'
    74: 47,  # 'J'
    75: 37,  # 'K'
    76: 50,  # 'L'
    77: 35,  # 'M'
    78: 36,  # 'N'
    79: 40,  # 'O'
    80: 30,  # 'P'
    81: 64,  # 'Q'
    82: 45,  # 'R'
    83: 33,  # 'S'
    84: 38,  # 'T'
    85: 51,  # 'U'
    86: 56,  # 'V'
    87: 32,  # 'W'
    88: 60,  # 'X'
    89: 58,  # 'Y'
    90: 44,  # 'Z'
    91: CharacterCategory.SYMBOL,  # '['
    92: CharacterCategory.SYMBOL,  # '\\'
    93: CharacterCategory.SYMBOL,  # ']'
    94: CharacterCategory.SYMBOL,  # '^'
    95: CharacterCategory.SYMBOL,  # '_'
    96: CharacterCategory.SYMBOL,  # '`'
    97: 1,  # 'a'
    98: 20,  # 'b'
    99: 11,  # 'c'
    100: 14,  # 'd'
    101: 2,  # 'e'
    102: 31,  # 'f'
    103: 22,  # 'g'
    104: 23,  # 'h'
    105: 3,  # 'i'
    106: 19,  # 'j'
    107: 13,  # 'k'
    108: 18,  # 'l'
    109: 15,  # 'm'
    110: 5,  # 'n'
    111: 4,  # 'o'
    112: 16,  # 'p'
    113: 63,  # 'q'
    114: 7,  # 'r'
    115: 9,  # 's'
    116: 10,  # 't'
    117: 17,  # 'u'
    118: 55,  # 'v'
    119: 8,  # 'w'
    120: 57,  # 'x'
    121: 12,  # 'y'
    122: 6,  # 'z'
    123: CharacterCategory.SYMBOL,  # '{'
    124: CharacterCategory.SYMBOL,  # '|'
    125: CharacterCategory.SYMBOL,  # '}'
    126: CharacterCategory.SYMBOL,  # '~'
    127: CharacterCategory.CONTROL,  # '\x7f'
    128: 0,  # 'Ä'
    129: 0,  # 'Ā'
    130: 0,  # 'ā'
    131: 0,  # 'É'
    132: 67,  # 'Ą'
    133: 0,  # 'Ö'
    134: 0,  # 'Ü'
    135: 0,  # 'á'
    136: 25,  # 'ą'
    137: 0,  # 'Č'
    138: 0,  # 'ä'
    139: 0,  # 'č'
    140: 68,  # 'Ć'
    141: 29,  # 'ć'
    142: 0,  # 'é'
    143: 69,  # 'Ź'
    144: 53,  # 'ź'
    145: 0,  # 'Ď'
    146: 0,  # 'í'
    147: 0,  # 'ď'
    148: 0,  # 'Ē'
    149: 0,  # 'ē'
    150: 0,  # 'Ė'
    151: 27,  # 'ó'
    152: 0,  # 'ė'
    153: 0,  # 'ô'
    154: 0,  # 'ö'
    155: 0,  # 'õ'
    156: 0,  # 'ú'
    157: 0,  # 'Ě'
    158: 0,  # 'ě'
    159: 0,  # 'ü'
    160: CharacterCategory.SYMBOL,  # '†'
    161: CharacterCategory.SYMBOL,  # '°'
    162: 65,  # 'Ę'
    163: CharacterCategory.SYMBOL,  # '£'
    164: CharacterCategory.SYMBOL,  # '§'
    165: CharacterCategory.SYMBOL,  # '•'
    166: CharacterCategory.SYMBOL,  # '¶'
    167: 0,  # 'ß'
    168: CharacterCategory.SYMBOL,  # '®'
    169: CharacterCategory.SYMBOL,  # '©'
    170: CharacterCategory.SYMBOL,  # '™'
    171: 24,  # 'ę'
    172: CharacterCategory.SYMBOL,  # '¨'
    173: CharacterCategory.SYMBOL,  # '≠'
    174: 0,  # 'ģ'
    175: 0,  # 'Į'
    176: 0,  # 'į'
    177: 0,  # 'Ī'
    178: CharacterCategory.SYMBOL,  # '≤'
    179: CharacterCategory.SYMBOL,  # '≥'
    180: 0,  # 'ī'
    181: 0,  # 'Ķ'
    182: CharacterCategory.SYMBOL,  # '∂'
    183: CharacterCategory.SYMBOL,  # '∑'
    184: 21,  # 'ł'
    185: 0,  # 'Ļ'
    186: 0,  # 'ļ'
    187: 0,  # 'Ľ'
    188: 0,  # 'ľ'
    189: 0,  # 'Ĺ'
    190: 0,  # 'ĺ'
    191: 0,  # 'Ņ'
    192: 0,  # 'ņ'
    193: 70,  # 'Ń'
    194: CharacterCategory.SYMBOL,  # '¬'
    195: CharacterCategory.SYMBOL,  # '√'
    196: 42,  # 'ń'
    197: 0,  # 'Ň'
    198: CharacterCategory.SYMBOL,  # '∆'
    199: CharacterCategory.SYMBOL,  # '«'
    200: CharacterCategory.SYMBOL,  # '»'
    201: CharacterCategory.SYMBOL,  # '…'
    202: CharacterCategory.CONTROL,  # '\xa0'
    203: 0,  # 'ň'
    204: 0,  # 'Ő'
    205: 0,  # 'Õ'
    206: 0,  # 'ő'
    207: 0,  # 'Ō'
    208: CharacterCategory.SYMBOL,  # '–'
    209: CharacterCategory.SYMBOL,  # '—'
    210: CharacterCategory.SYMBOL,  # '“'
    211: CharacterCategory.SYMBOL,  # '”'
    212: CharacterCategory.SYMBOL,  # '‘'
    213: CharacterCategory.SYMBOL,  # '’'
    214: CharacterCategory.SYMBOL,  # '÷'
    215: CharacterCategory.SYMBOL,  # '◊'
    216: 0,  # 'ō'
    217: 0,  # 'Ŕ'
    218: 0,  # 'ŕ'
    219: 0,  # 'Ř'
    220: CharacterCategory.SYMBOL,  # '‹'
    221: CharacterCategory.SYMBOL,  # '›'
    222: 0,  # 'ř'
    223: 0,  # 'Ŗ'
    224: 0,  # 'ŗ'
    225: 0,  # 'Š'
    226: CharacterCategory.SYMBOL,  # '‚'
    227: CharacterCategory.SYMBOL,  # '„'
    228: 0,  # 'š'
    229: 59,  # 'Ś'
    230: 28,  # 'ś'
    231: 0,  # 'Á'
    232: 0,  # 'Ť'
    233: 0,  # 'ť'
    234: 0,  # 'Í'
    235: 0,  # 'Ž'
    236: 0,  # 'ž'
    237: 0,  # 'Ū'
    238: 66,  # 'Ó'
    239: 0,  # 'Ô'
    240: 0,  # 'ū'
    241: 0,  # 'Ů'
    242: 0,  # 'Ú'
    243: 0,  # 'ů'
    244: 0,  # 'Ű'
    245: 0,  # 'ű'
    246: 0,  # 'Ų'
    247: 0,  # 'ų'
    248: 0,  # 'Ý'
    249: 0,  # 'ý'
    250: 0,  # 'ķ'
    251: 62,  # 'Ż'
    252: 61,  # 'Ł'
    253: 26,  # 'ż'
    254: 0,  # 'Ģ'
    255: 0,  # 'ˇ'
}

MACLATIN2_POLISH_MODEL = SingleByteCharSetModel(
    charset_name="MacLatin2",
    language="Polish",
    char_to_order_map=MACLATIN2_POLISH_CHAR_TO_ORDER,
    language_model=POLISH_LANG_MODEL,
    typical_positive_ratio=0.9630494627274031,
    keep_ascii_letters=True,
    alphabet="ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyzÓóĄąĆćĘęŁłŃńŚśŹźŻż",
)

WINDOWS_1250_POLISH_CHAR_TO_ORDER = {
    0: CharacterCategory.CONTROL,  # '\x00'
    1: CharacterCategory.CONTROL,  # '\x01'
    2: CharacterCategory.CONTROL,  # '\x02'
    3: CharacterCategory.CONTROL,  # '\x03'
    4: CharacterCategory.CONTROL,  # '\x04'
    5: CharacterCategory.CONTROL,  # '\x05'
    6: CharacterCategory.CONTROL,  # '\x06'
    7: CharacterCategory.CONTROL,  # '\x07'
    8: CharacterCategory.CONTROL,  # '\x08'
    9: CharacterCategory.CONTROL,  # '\t'
    10: CharacterCategory.LINE_BREAK,  # '\n'
    11: CharacterCategory.CONTROL,  # '\x0b'
    12: CharacterCategory.CONTROL,  # '\x0c'
    13: CharacterCategory.LINE_BREAK,  # '\r'
    14: CharacterCategory.CONTROL,  # '\x0e'
    15: CharacterCategory.CONTROL,  # '\x0f'
    16: CharacterCategory.CONTROL,  # '\x10'
    17: CharacterCategory.CONTROL,  # '\x11'
    18: CharacterCategory.CONTROL,  # '\x12'
    19: CharacterCategory.CONTROL,  # '\x13'
    20: CharacterCategory.CONTROL,  # '\x14'
    21: CharacterCategory.CONTROL,  # '\x15'
    22: CharacterCategory.CONTROL,  # '\x16'
    23: CharacterCategory.CONTROL,  # '\x17'
    24: CharacterCategory.CONTROL,  # '\x18'
    25: CharacterCategory.CONTROL,  # '\x19'
    26: CharacterCategory.CONTROL,  # '\x1a'
    27: CharacterCategory.CONTROL,  # '\x1b'
    28: CharacterCategory.CONTROL,  # '\x1c'
    29: CharacterCategory.CONTROL,  # '\x1d'
    30: CharacterCategory.CONTROL,  # '\x1e'
    31: CharacterCategory.CONTROL,  # '\x1f'
    32: CharacterCategory.CONTROL,  # ' '
    33: CharacterCategory.SYMBOL,  # '!'
    34: CharacterCategory.SYMBOL,  # '"'
    35: CharacterCategory.SYMBOL,  # '#'
    36: CharacterCategory.SYMBOL,  # '$'
    37: CharacterCategory.SYMBOL,  # '%'
    38: CharacterCategory.SYMBOL,  # '&'
    39: CharacterCategory.SYMBOL,  # "'"
    40: CharacterCategory.SYMBOL,  # '('
    41: CharacterCategory.SYMBOL,  # ')'
    42: CharacterCategory.SYMBOL,  # '*'
    43: CharacterCategory.SYMBOL,  # '+'
    44: CharacterCategory.SYMBOL,  # ','
    45: CharacterCategory.SYMBOL,  # '-'
    46: CharacterCategory.SYMBOL,  # '.'
    47: CharacterCategory.SYMBOL,  # '/'
    48: CharacterCategory.DIGIT,  # '0'
    49: CharacterCategory.DIGIT,  # '1'
    50: CharacterCategory.DIGIT,  # '2'
    51: CharacterCategory.DIGIT,  # '3'
    52: CharacterCategory.DIGIT,  # '4'
    53: CharacterCategory.DIGIT,  # '5'
    54: CharacterCategory.DIGIT,  # '6'
    55: CharacterCategory.DIGIT,  # '7'
    56: CharacterCategory.DIGIT,  # '8'
    57: CharacterCategory.DIGIT,  # '9'
    58: CharacterCategory.SYMBOL,  # ':'
    59: CharacterCategory.SYMBOL,  # ';'
    60: CharacterCategory.SYMBOL,  # '<'
    61: CharacterCategory.SYMBOL,  # '='
    62: CharacterCategory.SYMBOL,  # '>'
    63: CharacterCategory.SYMBOL,  # '?'
    64: CharacterCategory.SYMBOL,  # '@'
    65: 34,  # 'A'
    66: 46,  # 'B'
    67: 39,  # 'C'
    68: 41,  # 'D'
    69: 48,  # 'E'
    70: 52,  # 'F'
    71: 49,  # 'G'
    72: 54,  # 'H'
    73: 43,  # 'I'
    74: 47,  # 'J'
    75: 37,  # 'K'
    76: 50,  # 'L'
    77: 35,  # 'M'
    78: 36,  # 'N'
    79: 40,  # 'O'
    80: 30,  # 'P'
    81: 64,  # 'Q'
    82: 45,  # 'R'
    83: 33,  # 'S'
    84: 38,  # 'T'
    85: 51,  # 'U'
    86: 56,  # 'V'
    87: 32,  # 'W'
    88: 60,  # 'X'
    89: 58,  # 'Y'
    90: 44,  # 'Z'
    91: CharacterCategory.SYMBOL,  # '['
    92: CharacterCategory.SYMBOL,  # '\\'
    93: CharacterCategory.SYMBOL,  # ']'
    94: CharacterCategory.SYMBOL,  # '^'
    95: CharacterCategory.SYMBOL,  # '_'
    96: CharacterCategory.SYMBOL,  # '`'
    97: 1,  # 'a'
    98: 20,  # 'b'
    99: 11,  # 'c'
    100: 14,  # 'd'
    101: 2,  # 'e'
    102: 31,  # 'f'
    103: 22,  # 'g'
    104: 23,  # 'h'
    105: 3,  # 'i'
    106: 19,  # 'j'
    107: 13,  # 'k'
    108: 18,  # 'l'
    109: 15,  # 'm'
    110: 5,  # 'n'
    111: 4,  # 'o'
    112: 16,  # 'p'
    113: 63,  # 'q'
    114: 7,  # 'r'
    115: 9,  # 's'
    116: 10,  # 't'
    117: 17,  # 'u'
    118: 55,  # 'v'
    119: 8,  # 'w'
    120: 57,  # 'x'
    121: 12,  # 'y'
    122: 6,  # 'z'
    123: CharacterCategory.SYMBOL,  # '{'
    124: CharacterCategory.SYMBOL,  # '|'
    125: CharacterCategory.SYMBOL,  # '}'
    126: CharacterCategory.SYMBOL,  # '~'
    127: CharacterCategory.CONTROL,  # '\x7f'
    128: CharacterCategory.SYMBOL,  # '€'
    129: CharacterCategory.UNDEFINED,  # None
    130: CharacterCategory.SYMBOL,  # '‚'
    131: CharacterCategory.UNDEFINED,  # None
    132: CharacterCategory.SYMBOL,  # '„'
    133: CharacterCategory.SYMBOL,  # '…'
    134: CharacterCategory.SYMBOL,  # '†'
    135: CharacterCategory.SYMBOL,  # '‡'
    136: CharacterCategory.UNDEFINED,  # None
    137: CharacterCategory.SYMBOL,  # '‰'
    138: 0,  # 'Š'
    139: CharacterCategory.SYMBOL,  # '‹'
    140: 59,  # 'Ś'
    141: 0,  # 'Ť'
    142: 0,  # 'Ž'
    143: 69,  # 'Ź'
    144: CharacterCategory.UNDEFINED,  # None
    145: CharacterCategory.SYMBOL,  # '‘'
    146: CharacterCategory.SYMBOL,  # '’'
    147: CharacterCategory.SYMBOL,  # '“'
    148: CharacterCategory.SYMBOL,  # '”'
    149: CharacterCategory.SYMBOL,  # '•'
    150: CharacterCategory.SYMBOL,  # '–'
    151: CharacterCategory.SYMBOL,  # '—'
    152: CharacterCategory.UNDEFINED,  # None
    153: CharacterCategory.SYMBOL,  # '™'
    154: 0,  # 'š'
    155: CharacterCategory.SYMBOL,  # '›'
    156: 28,  # 'ś'
    157: 0,  # 'ť'
    158: 0,  # 'ž'
    159: 53,  # 'ź'
    160: CharacterCategory.CONTROL,  # '\xa0'
    161: 0,  # 'ˇ'
    162: CharacterCategory.SYMBOL,  # '˘'
    163: 61,  # 'Ł'
    164: CharacterCategory.SYMBOL,  # '¤'
    165: 67,  # 'Ą'
    166: CharacterCategory.SYMBOL,  # '¦'
    167: CharacterCategory.SYMBOL,  # '§'
    168: CharacterCategory.SYMBOL,  # '¨'
    169: CharacterCategory.SYMBOL,  # '©'
    170: 0,  # 'Ş'
    171: CharacterCategory.SYMBOL,  # '«'
    172: CharacterCategory.SYMBOL,  # '¬'
    173: CharacterCategory.CONTROL,  # '\xad'
    174: CharacterCategory.SYMBOL,  # '®'
    175: 62,  # 'Ż'
    176: CharacterCategory.SYMBOL,  # '°'
    177: CharacterCategory.SYMBOL,  # '±'
    178: CharacterCategory.SYMBOL,  # '˛'
    179: 21,  # 'ł'
    180: CharacterCategory.SYMBOL,  # '´'
    181: 0,  # 'µ'
    182: CharacterCategory.SYMBOL,  # '¶'
    183: CharacterCategory.SYMBOL,  # '·'
    184: CharacterCategory.SYMBOL,  # '¸'
    185: 25,  # 'ą'
    186: 0,  # 'ş'
    187: CharacterCategory.SYMBOL,  # '»'
    188: 0,  # 'Ľ'
    189: CharacterCategory.SYMBOL,  # '˝'
    190: 0,  # 'ľ'
    191: 26,  # 'ż'
    192: 0,  # 'Ŕ'
    193: 0,  # 'Á'
    194: 0,  # 'Â'
    195: 0,  # 'Ă'
    196: 0,  # 'Ä'
    197: 0,  # 'Ĺ'
    198: 68,  # 'Ć'
    199: 0,  # 'Ç'
    200: 0,  # 'Č'
    201: 0,  # 'É'
    202: 65,  # 'Ę'
    203: 0,  # 'Ë'
    204: 0,  # 'Ě'
    205: 0,  # 'Í'
    206: 0,  # 'Î'
    207: 0,  # 'Ď'
    208: 0,  # 'Đ'
    209: 70,  # 'Ń'
    210: 0,  # 'Ň'
    211: 66,  # 'Ó'
    212: 0,  # 'Ô'
    213: 0,  # 'Ő'
    214: 0,  # 'Ö'
    215: CharacterCategory.SYMBOL,  # '×'
    216: 0,  # 'Ř'
    217: 0,  # 'Ů'
    218: 0,  # 'Ú'
    219: 0,  # 'Ű'
    220: 0,  # 'Ü'
    221: 0,  # 'Ý'
    222: 0,  # 'Ţ'
    223: 0,  # 'ß'
    224: 0,  # 'ŕ'
    225: 0,  # 'á'
    226: 0,  # 'â'
    227: 0,  # 'ă'
    228: 0,  # 'ä'
    229: 0,  # 'ĺ'
    230: 29,  # 'ć'
    231: 0,  # 'ç'
    232: 0,  # 'č'
    233: 0,  # 'é'
    234: 24,  # 'ę'
    235: 0,  # 'ë'
    236: 0,  # 'ě'
    237: 0,  # 'í'
    238: 0,  # 'î'
    239: 0,  # 'ď'
    240: 0,  # 'đ'
    241: 42,  # 'ń'
    242: 0,  # 'ň'
    243: 27,  # 'ó'
    244: 0,  # 'ô'
    245: 0,  # 'ő'
    246: 0,  # 'ö'
    247: CharacterCategory.SYMBOL,  # '÷'
    248: 0,  # 'ř'
    249: 0,  # 'ů'
    250: 0,  # 'ú'
    251: 0,  # 'ű'
    252: 0,  # 'ü'
    253: 0,  # 'ý'
    254: 0,  # 'ţ'
    255: CharacterCategory.SYMBOL,  # '˙'
}

WINDOWS_1250_POLISH_MODEL = SingleByteCharSetModel(
    charset_name="WINDOWS-1250",
    language="Polish",
    char_to_order_map=WINDOWS_1250_POLISH_CHAR_TO_ORDER,
    language_model=POLISH_LANG_MODEL,
    typical_positive_ratio=0.9630494627274031,
    keep_ascii_letters=True,
    alphabet="ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyzÓóĄąĆćĘęŁłŃńŚśŹźŻż",
)
