/*
 * Decompiled with CFR 0.152.
 */
package ca.odell.glazedlists.nachocalendar;

import ca.odell.glazedlists.Filterator;
import ca.odell.glazedlists.matchers.RangeMatcherEditor;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.Date;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import net.sf.nachocalendar.CalendarFactory;
import net.sf.nachocalendar.components.DateField;

public class NachoDateRangeMatcherEditor<E>
extends RangeMatcherEditor<Date, E> {
    private final DateField fromDateField = CalendarFactory.createDateField();
    private final DateField toDateField = CalendarFactory.createDateField();
    private final JComponent component;

    public NachoDateRangeMatcherEditor(Filterator<Date, E> filterator) {
        super(filterator);
        this.fromDateField.setAntiAliased(true);
        this.toDateField.setAntiAliased(true);
        this.fromDateField.setValue(null);
        this.toDateField.setValue(null);
        DateRangeChangeListener changeListener = new DateRangeChangeListener();
        this.fromDateField.addChangeListener((ChangeListener)changeListener);
        this.toDateField.addChangeListener((ChangeListener)changeListener);
        this.component = this.createComponent(this.fromDateField, this.toDateField);
    }

    protected JComponent createComponent(DateField fromDateField, DateField toDateField) {
        JPanel panel = new JPanel(new GridBagLayout());
        panel.setOpaque(false);
        panel.add((Component)fromDateField, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        panel.add((Component)new JLabel("to"), new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 5, 0, 5), 0, 0));
        panel.add((Component)toDateField, new GridBagConstraints(2, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        return panel;
    }

    public JComponent getComponent() {
        return this.component;
    }

    private class DateRangeChangeListener
    implements ChangeListener {
        private DateRangeChangeListener() {
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            Date fromDate = (Date)NachoDateRangeMatcherEditor.this.fromDateField.getValue();
            Date toDate = (Date)NachoDateRangeMatcherEditor.this.toDateField.getValue();
            NachoDateRangeMatcherEditor.this.setRange(fromDate, toDate);
        }
    }
}

