/*++

Copyright (C) 2024 3MF Consortium (Original Author)

All rights reserved.

Redistribution and use in source and binary forms, with or without modification,
are permitted provided that the following conditions are met:

1. Redistributions of source code must retain the above copyright notice, this
list of conditions and the following disclaimer.
2. Redistributions in binary form must reproduce the above copyright notice,
this list of conditions and the following disclaimer in the documentation
and/or other materials provided with the distribution.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR
ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
(INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

This file has been generated by the Automatic Component Toolkit (ACT) version 1.8.1-develop.

Abstract: This is an autogenerated Java file in order to allow an easy
 use of the 3MF Library

Interface version: 2.5.0

*/

package lib3mf;

import com.sun.jna.Library;
import com.sun.jna.Memory;
import com.sun.jna.Native;
import com.sun.jna.Pointer;
import java.lang.ref.Cleaner;


import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.List;

public class LevelSet extends Object {

	public LevelSet(Lib3MFWrapper wrapper, Pointer handle) {
		super(wrapper, handle);
	}

	/**
	 * Returns the function that is used as boundary shape.
	 *
	 * @return the function to use as boundary shape
	 * @throws Lib3MFException
	 */
	public Function getFunction() throws Lib3MFException {
		Pointer bufferTheFunction = new Memory(8);
		mWrapper.checkError(this, mWrapper.lib3mf_levelset_getfunction.invokeInt(new java.lang.Object[]{mHandle, bufferTheFunction}));
		Pointer valueTheFunction = bufferTheFunction.getPointer(0);
		Function theFunction = null;
		if (valueTheFunction != Pointer.NULL) {
		  theFunction = mWrapper.PolymorphicFactory(valueTheFunction, Function.class);
		}
		return theFunction;
	}

	/**
	 * Sets the function to use as boundary shape.
	 *
	 * @param theFunction the function to use as boundary shape
	 * @throws Lib3MFException
	 */
	public void setFunction(Function theFunction) throws Lib3MFException {
		Pointer theFunctionHandle = null;
		if (theFunction != null) {
			theFunctionHandle = theFunction.getHandle();
		} else {
			throw new Lib3MFException(Lib3MFException.LIB3MF_ERROR_INVALIDPARAM, "TheFunction is a null value.");
		}
		mWrapper.checkError(this, mWrapper.lib3mf_levelset_setfunction.invokeInt(new java.lang.Object[]{mHandle, theFunctionHandle}));
	}

	/**
	 * Returns the transformation matrix into the coordinate system of the referenced Function.
	 *
	 * @return the transformation matrix
	 * @throws Lib3MFException
	 */
	public Transform getTransform() throws Lib3MFException {
		Pointer bufferTransform = new Memory(Transform.SIZE);
		mWrapper.checkError(this, mWrapper.lib3mf_levelset_gettransform.invokeInt(new java.lang.Object[]{mHandle, bufferTransform}));
		Transform transform = new Transform();
		transform.readFromPointer(bufferTransform, 0);
		return transform;
	}

	/**
	 * Sets the transformation matrix into the coordinate system of the referenced Function.
	 *
	 * @param transform new transformation matrix
	 * @throws Lib3MFException
	 */
	public void setTransform(Transform transform) throws Lib3MFException {
		Pointer bufferTransform = new Memory(Transform.SIZE);
		transform.writeToPointer(bufferTransform, 0);
		mWrapper.checkError(this, mWrapper.lib3mf_levelset_settransform.invokeInt(new java.lang.Object[]{mHandle, bufferTransform}));
	}

	/**
	 * Returns the name of the function output channel to use.
	 *
	 * @return the name of the function output channel
	 * @throws Lib3MFException
	 */
	public String getChannelName() throws Lib3MFException {
		Pointer bytesNeededChannelName = new Memory(4);
		mWrapper.checkError(this, mWrapper.lib3mf_levelset_getchannelname.invokeInt(new java.lang.Object[]{mHandle, 0, bytesNeededChannelName, null}));
		int sizeChannelName = bytesNeededChannelName.getInt(0);
		Pointer bufferChannelName = new Memory(sizeChannelName);
		mWrapper.checkError(this, mWrapper.lib3mf_levelset_getchannelname.invokeInt(new java.lang.Object[]{mHandle, sizeChannelName, bytesNeededChannelName, bufferChannelName}));
		return new String(bufferChannelName.getByteArray(0, sizeChannelName - 1), StandardCharsets.UTF_8);
	}

	/**
	 * Sets the name of the function output channel to use.
	 *
	 * @param channelName new name of the function output channel
	 * @throws Lib3MFException
	 */
	public void setChannelName(String channelName) throws Lib3MFException {
		byte[] bytesChannelName = channelName.getBytes(StandardCharsets.UTF_8);
		Memory bufferChannelName = new Memory(bytesChannelName.length + 1);
		bufferChannelName.write(0, bytesChannelName, 0, bytesChannelName.length);
		bufferChannelName.setByte(bytesChannelName.length, (byte)0);
		mWrapper.checkError(this, mWrapper.lib3mf_levelset_setchannelname.invokeInt(new java.lang.Object[]{mHandle, bufferChannelName}));
	}

	/**
	 * Sets the minimal feature size as a hint for the function evaluator
	 *
	 * @param minFeatureSize minimal feature size
	 * @throws Lib3MFException
	 */
	public void setMinFeatureSize(double minFeatureSize) throws Lib3MFException {
		mWrapper.checkError(this, mWrapper.lib3mf_levelset_setminfeaturesize.invokeInt(new java.lang.Object[]{mHandle, minFeatureSize}));
	}

	/**
	 * Returns the minimal feature size as a hint for the function evaluator
	 *
	 * @return minimal feature size
	 * @throws Lib3MFException
	 */
	public double getMinFeatureSize() throws Lib3MFException {
		Pointer bufferMinFeatureSize = new Memory(8);
		mWrapper.checkError(this, mWrapper.lib3mf_levelset_getminfeaturesize.invokeInt(new java.lang.Object[]{mHandle, bufferMinFeatureSize}));
		return bufferMinFeatureSize.getDouble(0);
	}

	/**
	 * Sets the fallback value to use if the function evaluation fails (e.g. evaluates to NaN or Inf).
	 *
	 * @param fallBackValue fallback value
	 * @throws Lib3MFException
	 */
	public void setFallBackValue(double fallBackValue) throws Lib3MFException {
		mWrapper.checkError(this, mWrapper.lib3mf_levelset_setfallbackvalue.invokeInt(new java.lang.Object[]{mHandle, fallBackValue}));
	}

	/**
	 * Returns the fallback value to use if the function evaluation fails (e.g. evaluates to NaN or Inf).
	 *
	 * @return fallback value
	 * @throws Lib3MFException
	 */
	public double getFallBackValue() throws Lib3MFException {
		Pointer bufferFallBackValue = new Memory(8);
		mWrapper.checkError(this, mWrapper.lib3mf_levelset_getfallbackvalue.invokeInt(new java.lang.Object[]{mHandle, bufferFallBackValue}));
		return bufferFallBackValue.getDouble(0);
	}

	/**
	 * If set only the bounding box of the mesh is intersected with the boundary
	 *
	 * @param meshBBoxOnly If set only the bounding box of the mesh is intersected with the boundary
	 * @throws Lib3MFException
	 */
	public void setMeshBBoxOnly(boolean meshBBoxOnly) throws Lib3MFException {
		mWrapper.checkError(this, mWrapper.lib3mf_levelset_setmeshbboxonly.invokeInt(new java.lang.Object[]{mHandle, meshBBoxOnly}));
	}

	/**
	 * If set only the bounding box of the mesh is intersected with the boundary
	 *
	 * @return If set only the bounding box of the mesh is intersected with the boundary
	 * @throws Lib3MFException
	 */
	public boolean getMeshBBoxOnly() throws Lib3MFException {
		Pointer bufferMeshBBoxOnly = new Memory(1);
		mWrapper.checkError(this, mWrapper.lib3mf_levelset_getmeshbboxonly.invokeInt(new java.lang.Object[]{mHandle, bufferMeshBBoxOnly}));
		return bufferMeshBBoxOnly.getByte(0) != 0;
	}

	/**
	 * Sets the mesh to use as evaluation domain
	 *
	 * @param theMesh The mesh
	 * @throws Lib3MFException
	 */
	public void setMesh(MeshObject theMesh) throws Lib3MFException {
		Pointer theMeshHandle = null;
		if (theMesh != null) {
			theMeshHandle = theMesh.getHandle();
		} else {
			throw new Lib3MFException(Lib3MFException.LIB3MF_ERROR_INVALIDPARAM, "TheMesh is a null value.");
		}
		mWrapper.checkError(this, mWrapper.lib3mf_levelset_setmesh.invokeInt(new java.lang.Object[]{mHandle, theMeshHandle}));
	}

	/**
	 * Returns the mesh that is used as evaluation domain
	 *
	 * @return The mesh
	 * @throws Lib3MFException
	 */
	public MeshObject getMesh() throws Lib3MFException {
		Pointer bufferTheMesh = new Memory(8);
		mWrapper.checkError(this, mWrapper.lib3mf_levelset_getmesh.invokeInt(new java.lang.Object[]{mHandle, bufferTheMesh}));
		Pointer valueTheMesh = bufferTheMesh.getPointer(0);
		MeshObject theMesh = null;
		if (valueTheMesh != Pointer.NULL) {
		  theMesh = mWrapper.PolymorphicFactory(valueTheMesh, MeshObject.class);
		}
		return theMesh;
	}

	/**
	 * Retrieves the VolumeData this Object.
	 *
	 * @return the VolumeData of this Object
	 * @throws Lib3MFException
	 */
	public VolumeData getVolumeData() throws Lib3MFException {
		Pointer bufferTheVolumeData = new Memory(8);
		mWrapper.checkError(this, mWrapper.lib3mf_levelset_getvolumedata.invokeInt(new java.lang.Object[]{mHandle, bufferTheVolumeData}));
		Pointer valueTheVolumeData = bufferTheVolumeData.getPointer(0);
		VolumeData theVolumeData = null;
		if (valueTheVolumeData != Pointer.NULL) {
		  theVolumeData = mWrapper.PolymorphicFactory(valueTheVolumeData, VolumeData.class);
		}
		return theVolumeData;
	}

	/**
	 * Sets the VolumeData of this LevelSet.
	 *
	 * @param theVolumeData the VolumeData of this MeshObject
	 * @throws Lib3MFException
	 */
	public void setVolumeData(VolumeData theVolumeData) throws Lib3MFException {
		Pointer theVolumeDataHandle = null;
		if (theVolumeData != null) {
			theVolumeDataHandle = theVolumeData.getHandle();
		} else {
			throw new Lib3MFException(Lib3MFException.LIB3MF_ERROR_INVALIDPARAM, "TheVolumeData is a null value.");
		}
		mWrapper.checkError(this, mWrapper.lib3mf_levelset_setvolumedata.invokeInt(new java.lang.Object[]{mHandle, theVolumeDataHandle}));
	}


}

