/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.psi;

import com.intellij.lang.ASTNode;
import com.intellij.navigation.ItemPresentation;
import com.intellij.navigation.ItemPresentationProviders;
import com.intellij.psi.PsiElement;
import com.intellij.psi.stubs.IStubElementType;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.KtStubBasedElementTypes;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.IfNotParsed;
import org.jetbrains.kotlin.psi.KtBlockExpression;
import org.jetbrains.kotlin.psi.KtClassBody;
import org.jetbrains.kotlin.psi.KtContextReceiver;
import org.jetbrains.kotlin.psi.KtContextReceiverList;
import org.jetbrains.kotlin.psi.KtContractEffectList;
import org.jetbrains.kotlin.psi.KtDeclarationWithInitializer;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtFunction;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtParameterList;
import org.jetbrains.kotlin.psi.KtScript;
import org.jetbrains.kotlin.psi.KtTypeParameterList;
import org.jetbrains.kotlin.psi.KtTypeParameterListOwnerStub;
import org.jetbrains.kotlin.psi.KtTypeReference;
import org.jetbrains.kotlin.psi.KtVisitor;
import org.jetbrains.kotlin.psi.psiUtil.KtPsiUtilKt;
import org.jetbrains.kotlin.psi.stubs.KotlinFunctionStub;
import org.jetbrains.kotlin.psi.stubs.KotlinStubWithFqName;
import org.jetbrains.kotlin.psi.typeRefHelpers.TypeRefHelpersKt;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000v\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0016\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u00012\u00020\u00032\u00020\u0004B\u0011\b\u0016\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bB\u0011\b\u0016\u0012\u0006\u0010\t\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0007\u0010\nJ5\u0010\u000b\u001a\u0002H\f\"\u0004\b\u0000\u0010\f\"\u0004\b\u0001\u0010\r2\u0012\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u0002H\f\u0012\u0004\u0012\u0002H\r0\u000f2\u0006\u0010\u0010\u001a\u0002H\rH\u0016\u00a2\u0006\u0002\u0010\u0011J\b\u0010\u0012\u001a\u00020\u0013H\u0016J\b\u0010\u0014\u001a\u00020\u0013H\u0016J\n\u0010\u0019\u001a\u0004\u0018\u00010\u0016H\u0016J\n\u0010\u001a\u001a\u0004\u0018\u00010\u001bH\u0016J\b\u0010\u001c\u001a\u00020\u0013H\u0016J\n\u0010\u001d\u001a\u0004\u0018\u00010\u001eH\u0016J\n\u0010\u001f\u001a\u0004\u0018\u00010 H\u0016J\u000e\u0010!\u001a\b\u0012\u0004\u0012\u00020#0\"H\u0016J\n\u0010$\u001a\u0004\u0018\u00010\u001bH\u0016J\n\u0010%\u001a\u0004\u0018\u00010&H\u0016J\b\u0010'\u001a\u00020\u0013H\u0016J\b\u0010(\u001a\u00020\u0013H\u0016J\n\u0010)\u001a\u0004\u0018\u00010*H\u0016J\u000e\u0010.\u001a\b\u0012\u0004\u0012\u00020/0\"H\u0016J\n\u00100\u001a\u0004\u0018\u00010*H\u0016J\u0014\u00101\u001a\u0004\u0018\u00010*2\b\u00102\u001a\u0004\u0018\u00010*H\u0016J\n\u00103\u001a\u0004\u0018\u00010\u0016H\u0016J\b\u00104\u001a\u00020\u0013H\u0016J\u0012\u00108\u001a\u00020\u00132\b\u00109\u001a\u0004\u0018\u00010\u0016H\u0016J\n\u0010:\u001a\u0004\u0018\u00010;H\u0016J\b\u0010<\u001a\u00020\u0013H\u0016J\u0010\u0010<\u001a\u00020\u00132\u0006\u0010=\u001a\u00020\u0013H\u0016R\u0016\u0010\u0015\u001a\u0004\u0018\u00010\u00168WX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0018R\u0016\u0010+\u001a\u0004\u0018\u00010*8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b,\u0010-R\u0014\u00105\u001a\u00020\u00138VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b5\u00106R\u0014\u00107\u001a\u00020\u00138VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b7\u00106\u00a8\u0006>"}, d2={"Lorg/jetbrains/kotlin/psi/KtNamedFunction;", "Lorg/jetbrains/kotlin/psi/KtTypeParameterListOwnerStub;", "Lorg/jetbrains/kotlin/psi/stubs/KotlinFunctionStub;", "Lorg/jetbrains/kotlin/psi/KtFunction;", "Lorg/jetbrains/kotlin/psi/KtDeclarationWithInitializer;", "node", "Lcom/intellij/lang/ASTNode;", "<init>", "(Lcom/intellij/lang/ASTNode;)V", "stub", "(Lorg/jetbrains/kotlin/psi/stubs/KotlinFunctionStub;)V", "accept", "R", "D", "visitor", "Lorg/jetbrains/kotlin/psi/KtVisitor;", "data", "(Lorg/jetbrains/kotlin/psi/KtVisitor;Ljava/lang/Object;)Ljava/lang/Object;", "hasTypeParameterListBeforeFunctionName", "", "hasBlockBody", "funKeyword", "Lcom/intellij/psi/PsiElement;", "getFunKeyword", "()Lcom/intellij/psi/PsiElement;", "getEqualsToken", "getInitializer", "Lorg/jetbrains/kotlin/psi/KtExpression;", "hasInitializer", "getPresentation", "Lcom/intellij/navigation/ItemPresentation;", "getValueParameterList", "Lorg/jetbrains/kotlin/psi/KtParameterList;", "getValueParameters", "", "Lorg/jetbrains/kotlin/psi/KtParameter;", "getBodyExpression", "getBodyBlockExpression", "Lorg/jetbrains/kotlin/psi/KtBlockExpression;", "hasBody", "hasDeclaredReturnType", "getReceiverTypeReference", "Lorg/jetbrains/kotlin/psi/KtTypeReference;", "receiverTypeRefByTree", "getReceiverTypeRefByTree", "()Lorg/jetbrains/kotlin/psi/KtTypeReference;", "getContextReceivers", "Lorg/jetbrains/kotlin/psi/KtContextReceiver;", "getTypeReference", "setTypeReference", "typeRef", "getColon", "isLocal", "isAnonymous", "()Z", "isTopLevel", "shouldChangeModificationCount", "place", "getContractDescription", "Lorg/jetbrains/kotlin/psi/KtContractEffectList;", "mayHaveContract", "isAllowedOnMembers", "psi-api"})
public class KtNamedFunction
extends KtTypeParameterListOwnerStub<KotlinFunctionStub>
implements KtDeclarationWithInitializer,
KtFunction {
    public KtNamedFunction(@NotNull ASTNode node) {
        Intrinsics.checkNotNullParameter(node, "node");
        super(node);
    }

    public KtNamedFunction(@NotNull KotlinFunctionStub stub) {
        Intrinsics.checkNotNullParameter(stub, "stub");
        super((KotlinStubWithFqName)stub, KtStubBasedElementTypes.FUNCTION);
    }

    @Override
    public <R, D> R accept(@NotNull KtVisitor<R, D> visitor2, D data) {
        Intrinsics.checkNotNullParameter(visitor2, "visitor");
        return visitor2.visitNamedFunction(this, data);
    }

    public boolean hasTypeParameterListBeforeFunctionName() {
        KotlinFunctionStub kotlinFunctionStub = (KotlinFunctionStub)this.getGreenStub();
        if (kotlinFunctionStub != null) {
            KotlinFunctionStub it = kotlinFunctionStub;
            boolean bl = false;
            return it.getHasTypeParameterListBeforeFunctionName();
        }
        KtTypeParameterList ktTypeParameterList = this.getTypeParameterList();
        if (ktTypeParameterList == null) {
            return false;
        }
        KtTypeParameterList typeParameterList = ktTypeParameterList;
        PsiElement psiElement = this.getNameIdentifier();
        if (psiElement == null) {
            return true;
        }
        PsiElement nameIdentifier = psiElement;
        return nameIdentifier.getTextOffset() > typeParameterList.getTextOffset();
    }

    @Override
    public boolean hasBlockBody() {
        KotlinFunctionStub kotlinFunctionStub = (KotlinFunctionStub)this.getGreenStub();
        if (kotlinFunctionStub != null) {
            KotlinFunctionStub it = kotlinFunctionStub;
            boolean bl = false;
            return it.getHasNoExpressionBody();
        }
        return this.getEqualsToken() == null;
    }

    @IfNotParsed
    @Nullable
    public PsiElement getFunKeyword() {
        return this.findChildByType(KtTokens.FUN_KEYWORD);
    }

    @Override
    @Nullable
    public PsiElement getEqualsToken() {
        return this.findChildByType(KtTokens.EQ);
    }

    @Override
    @Nullable
    public KtExpression getInitializer() {
        return PsiTreeUtil.getNextSiblingOfType(this.getEqualsToken(), KtExpression.class);
    }

    @Override
    public boolean hasInitializer() {
        return this.getInitializer() != null;
    }

    @Override
    @Nullable
    public ItemPresentation getPresentation() {
        return ItemPresentationProviders.getItemPresentation(this);
    }

    @Override
    @Nullable
    public KtParameterList getValueParameterList() {
        return (KtParameterList)this.getStubOrPsiChild((IStubElementType)KtStubBasedElementTypes.VALUE_PARAMETER_LIST);
    }

    @Override
    @NotNull
    public List<KtParameter> getValueParameters() {
        KtParameterList ktParameterList = this.getValueParameterList();
        List<KtParameter> list = ktParameterList != null ? ktParameterList.getParameters() : null;
        if (list == null) {
            list = CollectionsKt.emptyList();
        }
        return list;
    }

    @Override
    @Nullable
    public KtExpression getBodyExpression() {
        KotlinFunctionStub stub = (KotlinFunctionStub)this.getGreenStub();
        if (stub != null && !stub.getHasBody()) {
            return null;
        }
        return this.findChildByClass(KtExpression.class);
    }

    @Override
    @Nullable
    public KtBlockExpression getBodyBlockExpression() {
        KotlinFunctionStub stub = (KotlinFunctionStub)this.getGreenStub();
        if (!(stub == null || stub.getHasNoExpressionBody() && stub.getHasBody())) {
            return null;
        }
        KtExpression ktExpression = this.findChildByClass(KtExpression.class);
        return ktExpression instanceof KtBlockExpression ? (KtBlockExpression)ktExpression : null;
    }

    @Override
    public boolean hasBody() {
        KotlinFunctionStub kotlinFunctionStub = (KotlinFunctionStub)this.getGreenStub();
        if (kotlinFunctionStub != null) {
            KotlinFunctionStub it = kotlinFunctionStub;
            boolean bl = false;
            return it.getHasBody();
        }
        return this.getBodyExpression() != null;
    }

    @Override
    public boolean hasDeclaredReturnType() {
        return this.getTypeReference() != null;
    }

    @Override
    @Nullable
    public KtTypeReference getReceiverTypeReference() {
        KotlinFunctionStub kotlinFunctionStub = (KotlinFunctionStub)this.getGreenStub();
        if (kotlinFunctionStub == null) {
            return this.getReceiverTypeRefByTree();
        }
        KotlinFunctionStub stub = kotlinFunctionStub;
        if (!stub.isExtension()) {
            return null;
        }
        List<KtTypeReference> list = this.getStubOrPsiChildrenAsList(KtStubBasedElementTypes.TYPE_REFERENCE);
        Intrinsics.checkNotNullExpressionValue(list, "getStubOrPsiChildrenAsList(...)");
        return CollectionsKt.firstOrNull(list);
    }

    private final KtTypeReference getReceiverTypeRefByTree() {
        for (PsiElement child = this.getFirstChild(); child != null; child = child.getNextSibling()) {
            IElementType tt;
            Intrinsics.checkNotNullExpressionValue(child.getNode().getElementType(), "getElementType(...)");
            if (Intrinsics.areEqual(tt, KtTokens.LPAR) || Intrinsics.areEqual(tt, KtTokens.COLON)) break;
            if (!(child instanceof KtTypeReference)) continue;
            return (KtTypeReference)child;
        }
        return null;
    }

    @Override
    @NotNull
    public List<KtContextReceiver> getContextReceivers() {
        KtContextReceiverList ktContextReceiverList = this.getContextReceiverList();
        List<KtContextReceiver> list = ktContextReceiverList != null ? ktContextReceiverList.contextReceivers() : null;
        if (list == null) {
            list = CollectionsKt.emptyList();
        }
        return list;
    }

    @Override
    @Nullable
    public KtTypeReference getTypeReference() {
        KotlinFunctionStub kotlinFunctionStub = (KotlinFunctionStub)this.getGreenStub();
        if (kotlinFunctionStub == null) {
            return TypeRefHelpersKt.getTypeReference(this);
        }
        KotlinFunctionStub stub = kotlinFunctionStub;
        List<KtTypeReference> list = this.getStubOrPsiChildrenAsList(KtStubBasedElementTypes.TYPE_REFERENCE);
        Intrinsics.checkNotNullExpressionValue(list, "getStubOrPsiChildrenAsList(...)");
        List<KtTypeReference> typeReferences = list;
        int returnTypeIndex = stub.isExtension() ? 1 : 0;
        return returnTypeIndex < typeReferences.size() ? typeReferences.get(returnTypeIndex) : null;
    }

    @Override
    @Nullable
    public KtTypeReference setTypeReference(@Nullable KtTypeReference typeRef) {
        return TypeRefHelpersKt.setTypeReference(this, this.getValueParameterList(), typeRef);
    }

    @Override
    @Nullable
    public PsiElement getColon() {
        return this.findChildByType(KtTokens.COLON);
    }

    @Override
    public boolean isLocal() {
        PsiElement parent2 = this.getParent();
        return parent2 == null ? false : (KtPsiUtilKt.isKtFile(parent2) ? false : (parent2 instanceof KtClassBody ? false : !(parent2.getParent() instanceof KtScript)));
    }

    public boolean isAnonymous() {
        return this.getName() == null && this.isLocal();
    }

    public boolean isTopLevel() {
        KotlinFunctionStub kotlinFunctionStub = (KotlinFunctionStub)this.getGreenStub();
        if (kotlinFunctionStub != null) {
            KotlinFunctionStub it = kotlinFunctionStub;
            boolean bl = false;
            return it.isTopLevel();
        }
        return KtPsiUtilKt.isKtFile(this.getParent());
    }

    public boolean shouldChangeModificationCount(@Nullable PsiElement place) {
        return false;
    }

    @Override
    @Nullable
    public KtContractEffectList getContractDescription() {
        return (KtContractEffectList)this.getStubOrPsiChild((IStubElementType)KtStubBasedElementTypes.CONTRACT_EFFECT_LIST);
    }

    @Override
    public boolean mayHaveContract() {
        KotlinFunctionStub kotlinFunctionStub = (KotlinFunctionStub)this.getGreenStub();
        if (kotlinFunctionStub != null) {
            KotlinFunctionStub it = kotlinFunctionStub;
            boolean bl = false;
            return it.getMayHaveContract();
        }
        return KtPsiUtilKt.isLegacyContractPresentPsiCheck(this);
    }

    public boolean mayHaveContract(boolean isAllowedOnMembers) {
        KotlinFunctionStub kotlinFunctionStub = (KotlinFunctionStub)this.getGreenStub();
        if (kotlinFunctionStub != null) {
            KotlinFunctionStub it = kotlinFunctionStub;
            boolean bl = false;
            return it.getMayHaveContract();
        }
        return KtPsiUtilKt.isContractPresentPsiCheck(this, isAllowedOnMembers);
    }
}

