/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.objects.slice;

import com.oracle.graal.python.PythonLanguage;
import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.builtins.objects.PNone;
import com.oracle.graal.python.builtins.objects.object.PythonBuiltinObject;
import com.oracle.graal.python.nodes.ErrorMessages;
import com.oracle.graal.python.nodes.PRaiseNode;
import com.oracle.graal.python.runtime.exception.PythonErrorType;
import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.CompilerDirectives;
import java.util.Objects;

public abstract class PSlice
extends PythonBuiltinObject {
    private static final int ONE = 1;
    private static final int ZERO = 0;

    public PSlice(PythonLanguage lang) {
        super((Object)PythonBuiltinClassType.PSlice, PythonBuiltinClassType.PSlice.getInstanceShape(lang));
    }

    @Override
    public String toString() {
        CompilerAsserts.neverPartOfCompilation();
        StringBuilder str = new StringBuilder("slice(");
        str.append(this.getStart()).append(", ");
        str.append(this.getStop()).append(", ");
        str.append(this.getStep());
        return str.append(")").toString();
    }

    public abstract Object getStart();

    public abstract Object getStop();

    public abstract Object getStep();

    public boolean equals(Object obj) {
        CompilerAsserts.neverPartOfCompilation();
        if (!(obj instanceof PSlice)) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        PSlice other = (PSlice)obj;
        return this.getStart().equals(other.getStart()) && this.getStop().equals(other.getStop()) && this.getStep().equals(other.getStep());
    }

    public int hashCode() {
        CompilerAsserts.neverPartOfCompilation();
        return Objects.hash(this.getStart(), this.getStop(), this.getStep());
    }

    protected static void checkNegative(int length) {
        if (length < 0) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            throw PRaiseNode.raiseStatic(null, PythonErrorType.ValueError, ErrorMessages.LENGTH_SHOULD_NOT_BE_NEG);
        }
    }

    private static boolean pyLT(int left, int right) {
        return left < right;
    }

    private static boolean pyGT(int left, int right) {
        return left > right;
    }

    private static int pySign(int n) {
        return n == 0 ? 0 : (n < 0 ? -1 : 1);
    }

    public static SliceInfo computeIndices(Object startIn, Object stopIn, Object stepIn, int length) {
        int stop;
        int start;
        int upper;
        int lower;
        boolean stepIsNegative;
        int step;
        assert (length >= 0);
        if (stepIn == PNone.NONE) {
            step = 1;
            stepIsNegative = false;
        } else {
            step = (Integer)stepIn;
            boolean bl = stepIsNegative = PSlice.pySign(step) < 0;
            if (PSlice.pySign(step) == 0) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                throw PRaiseNode.raiseStatic(null, PythonErrorType.ValueError, ErrorMessages.SLICE_STEP_CANNOT_BE_ZERO);
            }
        }
        if (stepIsNegative) {
            lower = -1;
            upper = lower + length;
        } else {
            lower = 0;
            upper = length;
        }
        if (startIn == PNone.NONE) {
            start = stepIsNegative ? upper : lower;
        } else {
            start = (Integer)startIn;
            if (PSlice.pySign(start) < 0) {
                if (PSlice.pyLT(start += length, lower)) {
                    start = lower;
                }
            } else if (PSlice.pyGT(start, upper)) {
                start = upper;
            }
        }
        if (stopIn == PNone.NONE) {
            stop = stepIsNegative ? lower : upper;
        } else {
            stop = (Integer)stopIn;
            if (PSlice.pySign(stop) < 0) {
                if (PSlice.pyLT(stop += length, lower)) {
                    stop = lower;
                }
            } else if (PSlice.pyGT(stop, upper)) {
                stop = upper;
            }
        }
        return new SliceInfo(start, stop, step);
    }

    @CompilerDirectives.ValueType
    public static final class SliceInfo {
        public final int start;
        public final int stop;
        public final int step;
        public final int sliceLength;

        public SliceInfo(int start, int stop, int step, int length) {
            this.start = start;
            this.stop = stop;
            this.step = step;
            this.sliceLength = length;
        }

        public SliceInfo(int start, int stop, int step) {
            this(start, stop, step, -1);
        }
    }

    @CompilerDirectives.ValueType
    public record SliceInfoLong(long start, long stop, long step) {
    }
}

