/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.internal.opentelemetry.sdk.metrics.internal.state;

import net.snowflake.client.jdbc.internal.opentelemetry.sdk.metrics.View;
import net.snowflake.client.jdbc.internal.opentelemetry.sdk.metrics.data.ExemplarData;
import net.snowflake.client.jdbc.internal.opentelemetry.sdk.metrics.data.PointData;
import net.snowflake.client.jdbc.internal.opentelemetry.sdk.metrics.internal.aggregator.Aggregator;
import net.snowflake.client.jdbc.internal.opentelemetry.sdk.metrics.internal.aggregator.AggregatorFactory;
import net.snowflake.client.jdbc.internal.opentelemetry.sdk.metrics.internal.descriptor.InstrumentDescriptor;
import net.snowflake.client.jdbc.internal.opentelemetry.sdk.metrics.internal.descriptor.MetricDescriptor;
import net.snowflake.client.jdbc.internal.opentelemetry.sdk.metrics.internal.exemplar.ExemplarFilter;
import net.snowflake.client.jdbc.internal.opentelemetry.sdk.metrics.internal.export.RegisteredReader;
import net.snowflake.client.jdbc.internal.opentelemetry.sdk.metrics.internal.state.DefaultSynchronousMetricStorage;
import net.snowflake.client.jdbc.internal.opentelemetry.sdk.metrics.internal.state.EmptyMetricStorage;
import net.snowflake.client.jdbc.internal.opentelemetry.sdk.metrics.internal.state.MetricStorage;
import net.snowflake.client.jdbc.internal.opentelemetry.sdk.metrics.internal.state.WriteableMetricStorage;
import net.snowflake.client.jdbc.internal.opentelemetry.sdk.metrics.internal.view.RegisteredView;

public interface SynchronousMetricStorage
extends MetricStorage,
WriteableMetricStorage {
    public static SynchronousMetricStorage empty() {
        return EmptyMetricStorage.INSTANCE;
    }

    public static <T extends PointData, U extends ExemplarData> SynchronousMetricStorage create(RegisteredReader registeredReader, RegisteredView registeredView, InstrumentDescriptor instrumentDescriptor, ExemplarFilter exemplarFilter) {
        View view = registeredView.getView();
        MetricDescriptor metricDescriptor = MetricDescriptor.create(view, registeredView.getViewSourceInfo(), instrumentDescriptor);
        Aggregator aggregator = ((AggregatorFactory)((Object)view.getAggregation())).createAggregator(instrumentDescriptor, exemplarFilter, registeredReader.getReader().getMemoryMode());
        if (Aggregator.drop() == aggregator) {
            return SynchronousMetricStorage.empty();
        }
        return new DefaultSynchronousMetricStorage(registeredReader, metricDescriptor, aggregator, registeredView.getViewAttributesProcessor(), registeredView.getCardinalityLimit());
    }
}

