/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.internal.joda.time;

import java.io.Serializable;
import net.snowflake.client.jdbc.internal.joda.convert.FromString;
import net.snowflake.client.jdbc.internal.joda.time.Chronology;
import net.snowflake.client.jdbc.internal.joda.time.DateTime;
import net.snowflake.client.jdbc.internal.joda.time.DateTimeUtils;
import net.snowflake.client.jdbc.internal.joda.time.MutableDateTime;
import net.snowflake.client.jdbc.internal.joda.time.ReadableDuration;
import net.snowflake.client.jdbc.internal.joda.time.ReadableInstant;
import net.snowflake.client.jdbc.internal.joda.time.base.AbstractInstant;
import net.snowflake.client.jdbc.internal.joda.time.chrono.ISOChronology;
import net.snowflake.client.jdbc.internal.joda.time.convert.ConverterManager;
import net.snowflake.client.jdbc.internal.joda.time.convert.InstantConverter;
import net.snowflake.client.jdbc.internal.joda.time.field.FieldUtils;
import net.snowflake.client.jdbc.internal.joda.time.format.DateTimeFormatter;
import net.snowflake.client.jdbc.internal.joda.time.format.ISODateTimeFormat;

public final class Instant
extends AbstractInstant
implements ReadableInstant,
Serializable {
    public static final Instant EPOCH = new Instant(0L);
    private static final long serialVersionUID = 3299096530934209741L;
    private final long iMillis;

    public static Instant now() {
        return new Instant();
    }

    public static Instant ofEpochMilli(long l) {
        return new Instant(l);
    }

    public static Instant ofEpochSecond(long l) {
        return new Instant(FieldUtils.safeMultiply(l, 1000));
    }

    @FromString
    public static Instant parse(String string) {
        return Instant.parse(string, ISODateTimeFormat.dateTimeParser());
    }

    public static Instant parse(String string, DateTimeFormatter dateTimeFormatter) {
        return dateTimeFormatter.parseDateTime(string).toInstant();
    }

    public Instant() {
        this.iMillis = DateTimeUtils.currentTimeMillis();
    }

    public Instant(long l) {
        this.iMillis = l;
    }

    public Instant(Object object) {
        InstantConverter instantConverter = ConverterManager.getInstance().getInstantConverter(object);
        this.iMillis = instantConverter.getInstantMillis(object, ISOChronology.getInstanceUTC());
    }

    public Instant toInstant() {
        return this;
    }

    public Instant withMillis(long l) {
        return l == this.iMillis ? this : new Instant(l);
    }

    public Instant withDurationAdded(long l, int n) {
        if (l == 0L || n == 0) {
            return this;
        }
        long l2 = this.getChronology().add(this.getMillis(), l, n);
        return this.withMillis(l2);
    }

    public Instant withDurationAdded(ReadableDuration readableDuration, int n) {
        if (readableDuration == null || n == 0) {
            return this;
        }
        return this.withDurationAdded(readableDuration.getMillis(), n);
    }

    public Instant plus(long l) {
        return this.withDurationAdded(l, 1);
    }

    public Instant plus(ReadableDuration readableDuration) {
        return this.withDurationAdded(readableDuration, 1);
    }

    public Instant minus(long l) {
        return this.withDurationAdded(l, -1);
    }

    public Instant minus(ReadableDuration readableDuration) {
        return this.withDurationAdded(readableDuration, -1);
    }

    public long getMillis() {
        return this.iMillis;
    }

    public Chronology getChronology() {
        return ISOChronology.getInstanceUTC();
    }

    public DateTime toDateTime() {
        return new DateTime(this.getMillis(), (Chronology)ISOChronology.getInstance());
    }

    @Deprecated
    public DateTime toDateTimeISO() {
        return this.toDateTime();
    }

    public MutableDateTime toMutableDateTime() {
        return new MutableDateTime(this.getMillis(), (Chronology)ISOChronology.getInstance());
    }

    @Deprecated
    public MutableDateTime toMutableDateTimeISO() {
        return this.toMutableDateTime();
    }
}

