/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.internal.grpc.xds.internal.security.certprovider;

import java.io.IOException;
import java.security.cert.CertStoreException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.AbstractMap;
import java.util.Map;
import javax.net.ssl.X509TrustManager;
import net.snowflake.client.jdbc.internal.google.common.base.Preconditions;
import net.snowflake.client.jdbc.internal.grpc.netty.shaded.io.grpc.netty.GrpcSslContexts;
import net.snowflake.client.jdbc.internal.grpc.netty.shaded.io.netty.handler.ssl.SslContextBuilder;
import net.snowflake.client.jdbc.internal.grpc.xds.EnvoyServerProtoData;
import net.snowflake.client.jdbc.internal.grpc.xds.client.Bootstrapper;
import net.snowflake.client.jdbc.internal.grpc.xds.internal.security.certprovider.CertProviderSslContextProvider;
import net.snowflake.client.jdbc.internal.grpc.xds.internal.security.certprovider.CertificateProviderStore;
import net.snowflake.client.jdbc.internal.grpc.xds.internal.security.trust.XdsTrustManagerFactory;
import net.snowflake.client.jdbc.internal.grpc.xds.shaded.io.envoyproxy.envoy.config.core.v3.Node;
import net.snowflake.client.jdbc.internal.grpc.xds.shaded.io.envoyproxy.envoy.extensions.transport_sockets.tls.v3.CertificateValidationContext;
import net.snowflake.client.jdbc.internal.grpc.xds.shaded.io.envoyproxy.envoy.extensions.transport_sockets.tls.v3.CommonTlsContext;
import net.snowflake.client.jdbc.internal.javax.annotation.Nullable;

final class CertProviderServerSslContextProvider
extends CertProviderSslContextProvider {
    CertProviderServerSslContextProvider(Node node, @Nullable Map<String, Bootstrapper.CertificateProviderInfo> certProviders, CommonTlsContext.CertificateProviderInstance certInstance, CommonTlsContext.CertificateProviderInstance rootCertInstance, CertificateValidationContext staticCertValidationContext, EnvoyServerProtoData.DownstreamTlsContext downstreamTlsContext, CertificateProviderStore certificateProviderStore) {
        super(node, certProviders, Preconditions.checkNotNull(certInstance, "Server SSL requires certInstance"), rootCertInstance, staticCertValidationContext, downstreamTlsContext, certificateProviderStore);
    }

    @Override
    protected final AbstractMap.SimpleImmutableEntry<SslContextBuilder, X509TrustManager> getSslContextBuilderAndTrustManager(CertificateValidationContext certificateValidationContextdationContext) throws CertStoreException, CertificateException, IOException {
        SslContextBuilder sslContextBuilder = SslContextBuilder.forServer(this.savedKey, this.savedCertChain);
        XdsTrustManagerFactory trustManagerFactory = null;
        if (this.isMtls() && this.savedSpiffeTrustMap != null) {
            trustManagerFactory = new XdsTrustManagerFactory(this.savedSpiffeTrustMap, certificateValidationContextdationContext, false);
        } else if (this.isMtls()) {
            trustManagerFactory = new XdsTrustManagerFactory(this.savedTrustedRoots.toArray(new X509Certificate[0]), certificateValidationContextdationContext, false);
        }
        this.setClientAuthValues(sslContextBuilder, trustManagerFactory);
        sslContextBuilder = GrpcSslContexts.configure(sslContextBuilder);
        return new AbstractMap.SimpleImmutableEntry<SslContextBuilder, Object>(sslContextBuilder, null);
    }
}

