/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.internal.grpc.xds.internal.security;

import java.io.IOException;
import java.security.cert.CertStoreException;
import java.security.cert.CertificateException;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.List;
import javax.net.ssl.X509TrustManager;
import net.snowflake.client.jdbc.internal.google.common.base.Preconditions;
import net.snowflake.client.jdbc.internal.google.common.collect.ImmutableList;
import net.snowflake.client.jdbc.internal.google.protobuf.ProtocolStringList;
import net.snowflake.client.jdbc.internal.grpc.Internal;
import net.snowflake.client.jdbc.internal.grpc.Status;
import net.snowflake.client.jdbc.internal.grpc.netty.shaded.io.netty.handler.ssl.ApplicationProtocolConfig;
import net.snowflake.client.jdbc.internal.grpc.netty.shaded.io.netty.handler.ssl.SslContext;
import net.snowflake.client.jdbc.internal.grpc.netty.shaded.io.netty.handler.ssl.SslContextBuilder;
import net.snowflake.client.jdbc.internal.grpc.xds.EnvoyServerProtoData;
import net.snowflake.client.jdbc.internal.grpc.xds.internal.security.SslContextProvider;
import net.snowflake.client.jdbc.internal.grpc.xds.shaded.io.envoyproxy.envoy.extensions.transport_sockets.tls.v3.CertificateValidationContext;
import net.snowflake.client.jdbc.internal.grpc.xds.shaded.io.envoyproxy.envoy.extensions.transport_sockets.tls.v3.CommonTlsContext;
import net.snowflake.client.jdbc.internal.javax.annotation.Nullable;

@Internal
public abstract class DynamicSslContextProvider
extends SslContextProvider {
    protected final List<SslContextProvider.Callback> pendingCallbacks = new ArrayList<SslContextProvider.Callback>();
    @Nullable
    protected final CertificateValidationContext staticCertificateValidationContext;
    @Nullable
    protected AbstractMap.SimpleImmutableEntry<SslContext, X509TrustManager> sslContextAndTrustManager;
    protected boolean autoSniSanValidationDoesNotApply;

    protected DynamicSslContextProvider(EnvoyServerProtoData.BaseTlsContext tlsContext, CertificateValidationContext staticCertValidationContext) {
        super(tlsContext);
        this.staticCertificateValidationContext = staticCertValidationContext;
    }

    @Nullable
    public AbstractMap.SimpleImmutableEntry<SslContext, X509TrustManager> getSslContextAndTrustManager() {
        return this.sslContextAndTrustManager;
    }

    protected abstract CertificateValidationContext generateCertificateValidationContext();

    public void setAutoSniSanValidationDoesNotApply() {
        this.autoSniSanValidationDoesNotApply = true;
    }

    protected abstract AbstractMap.SimpleImmutableEntry<SslContextBuilder, X509TrustManager> getSslContextBuilderAndTrustManager(CertificateValidationContext var1) throws CertificateException, IOException, CertStoreException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void updateSslContext() {
        try {
            List<SslContextProvider.Callback> pendingCallbacksCopy;
            AbstractMap.SimpleImmutableEntry<SslContext, X509TrustManager> sslContextAndExtendedX09TrustManagerCopy;
            CertificateValidationContext localCertValidationContext = this.generateCertificateValidationContext();
            AbstractMap.SimpleImmutableEntry<SslContextBuilder, X509TrustManager> sslContextBuilderAndTm = this.getSslContextBuilderAndTrustManager(localCertValidationContext);
            CommonTlsContext commonTlsContext = this.getCommonTlsContext();
            if (commonTlsContext != null && commonTlsContext.getAlpnProtocolsCount() > 0) {
                ProtocolStringList alpnList = commonTlsContext.getAlpnProtocolsList();
                ApplicationProtocolConfig apn = new ApplicationProtocolConfig(ApplicationProtocolConfig.Protocol.ALPN, ApplicationProtocolConfig.SelectorFailureBehavior.NO_ADVERTISE, ApplicationProtocolConfig.SelectedListenerFailureBehavior.ACCEPT, alpnList);
                sslContextBuilderAndTm.getKey().applicationProtocolConfig(apn);
            }
            List<SslContextProvider.Callback> list = this.pendingCallbacks;
            synchronized (list) {
                sslContextAndExtendedX09TrustManagerCopy = this.sslContextAndTrustManager = new AbstractMap.SimpleImmutableEntry<SslContext, X509TrustManager>(sslContextBuilderAndTm.getKey().build(), sslContextBuilderAndTm.getValue());
                pendingCallbacksCopy = this.clonePendingCallbacksAndClear();
            }
            this.makePendingCallbacks(sslContextAndExtendedX09TrustManagerCopy, pendingCallbacksCopy);
        }
        catch (Exception e) {
            this.onError(Status.fromThrowable(e));
            throw new RuntimeException(e);
        }
    }

    protected final void callPerformCallback(SslContextProvider.Callback callback, final AbstractMap.SimpleImmutableEntry<SslContext, X509TrustManager> sslContextAndTmCopy) {
        this.performCallback(new SslContextProvider.SslContextGetter(){

            @Override
            public AbstractMap.SimpleImmutableEntry<SslContext, X509TrustManager> get() {
                return sslContextAndTmCopy;
            }
        }, callback);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void addCallback(SslContextProvider.Callback callback) {
        Preconditions.checkNotNull(callback, "callback");
        AbstractMap.SimpleImmutableEntry<SslContext, X509TrustManager> sslContextCopy = null;
        List<SslContextProvider.Callback> list = this.pendingCallbacks;
        synchronized (list) {
            if (this.sslContextAndTrustManager != null) {
                sslContextCopy = this.sslContextAndTrustManager;
            } else {
                this.pendingCallbacks.add(callback);
            }
        }
        if (sslContextCopy != null) {
            this.callPerformCallback(callback, sslContextCopy);
        }
    }

    private final void makePendingCallbacks(AbstractMap.SimpleImmutableEntry<SslContext, X509TrustManager> sslContextAndExtendedX509TrustManagerCopy, List<SslContextProvider.Callback> pendingCallbacksCopy) {
        for (SslContextProvider.Callback callback : pendingCallbacksCopy) {
            this.callPerformCallback(callback, sslContextAndExtendedX509TrustManagerCopy);
        }
    }

    public final void onError(Status error) {
        for (SslContextProvider.Callback callback : this.clonePendingCallbacksAndClear()) {
            callback.onException(error.asException());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<SslContextProvider.Callback> clonePendingCallbacksAndClear() {
        List<SslContextProvider.Callback> list = this.pendingCallbacks;
        synchronized (list) {
            ImmutableList<SslContextProvider.Callback> copy = ImmutableList.copyOf(this.pendingCallbacks);
            this.pendingCallbacks.clear();
            return copy;
        }
    }
}

