/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.internal.grpc.xds;

import java.net.InetSocketAddress;
import java.util.List;
import net.snowflake.client.jdbc.internal.google.auto.value.AutoValue;
import net.snowflake.client.jdbc.internal.google.common.annotations.VisibleForTesting;
import net.snowflake.client.jdbc.internal.google.common.base.Preconditions;
import net.snowflake.client.jdbc.internal.google.common.collect.ImmutableList;
import net.snowflake.client.jdbc.internal.google.common.collect.ImmutableMap;
import net.snowflake.client.jdbc.internal.google.common.net.InetAddresses;
import net.snowflake.client.jdbc.internal.grpc.EquivalentAddressGroup;
import net.snowflake.client.jdbc.internal.grpc.xds.AutoValue_Endpoints_DropOverload;
import net.snowflake.client.jdbc.internal.grpc.xds.AutoValue_Endpoints_LbEndpoint;
import net.snowflake.client.jdbc.internal.grpc.xds.AutoValue_Endpoints_LocalityLbEndpoints;

final class Endpoints {
    private Endpoints() {
    }

    @AutoValue
    static abstract class DropOverload {
        DropOverload() {
        }

        abstract String category();

        abstract int dropsPerMillion();

        static DropOverload create(String category, int dropsPerMillion) {
            return new AutoValue_Endpoints_DropOverload(category, dropsPerMillion);
        }
    }

    @AutoValue
    static abstract class LbEndpoint {
        LbEndpoint() {
        }

        abstract EquivalentAddressGroup eag();

        abstract int loadBalancingWeight();

        abstract boolean isHealthy();

        abstract String hostname();

        abstract ImmutableMap<String, Object> endpointMetadata();

        static LbEndpoint create(EquivalentAddressGroup eag, int loadBalancingWeight, boolean isHealthy, String hostname, ImmutableMap<String, Object> endpointMetadata) {
            return new AutoValue_Endpoints_LbEndpoint(eag, loadBalancingWeight, isHealthy, hostname, endpointMetadata);
        }

        @VisibleForTesting
        static LbEndpoint create(String address, int port, int loadBalancingWeight, boolean isHealthy, String hostname, ImmutableMap<String, Object> endpointMetadata) {
            return LbEndpoint.create(new EquivalentAddressGroup(new InetSocketAddress(InetAddresses.forString((String)address), port)), loadBalancingWeight, isHealthy, hostname, endpointMetadata);
        }
    }

    @AutoValue
    static abstract class LocalityLbEndpoints {
        LocalityLbEndpoints() {
        }

        abstract ImmutableList<LbEndpoint> endpoints();

        abstract int localityWeight();

        abstract int priority();

        abstract ImmutableMap<String, Object> localityMetadata();

        static LocalityLbEndpoints create(List<LbEndpoint> endpoints, int localityWeight, int priority, ImmutableMap<String, Object> localityMetadata) {
            Preconditions.checkArgument(localityWeight > 0, "localityWeight must be greater than 0");
            return new AutoValue_Endpoints_LocalityLbEndpoints(ImmutableList.copyOf(endpoints), localityWeight, priority, localityMetadata);
        }
    }
}

