/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.internal.grpc.internal;

import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.atomic.AtomicReference;
import net.snowflake.client.jdbc.internal.google.common.annotations.VisibleForTesting;
import net.snowflake.client.jdbc.internal.google.common.base.Preconditions;
import net.snowflake.client.jdbc.internal.grpc.CallOptions;
import net.snowflake.client.jdbc.internal.grpc.Channel;
import net.snowflake.client.jdbc.internal.grpc.ClientCall;
import net.snowflake.client.jdbc.internal.grpc.ClientStreamTracer;
import net.snowflake.client.jdbc.internal.grpc.Context;
import net.snowflake.client.jdbc.internal.grpc.InternalConfigSelector;
import net.snowflake.client.jdbc.internal.grpc.Metadata;
import net.snowflake.client.jdbc.internal.grpc.MethodDescriptor;
import net.snowflake.client.jdbc.internal.grpc.Status;
import net.snowflake.client.jdbc.internal.grpc.internal.CallTracer;
import net.snowflake.client.jdbc.internal.grpc.internal.ClientCallImpl;
import net.snowflake.client.jdbc.internal.grpc.internal.ClientStream;
import net.snowflake.client.jdbc.internal.grpc.internal.ClientStreamListener;
import net.snowflake.client.jdbc.internal.grpc.internal.ClientTransport;
import net.snowflake.client.jdbc.internal.grpc.internal.FailingClientTransport;
import net.snowflake.client.jdbc.internal.grpc.internal.GrpcUtil;
import net.snowflake.client.jdbc.internal.grpc.internal.InternalSubchannel;

final class SubchannelChannel
extends Channel {
    @VisibleForTesting
    static final Status NOT_READY_ERROR = Status.UNAVAILABLE.withDescription("Subchannel is NOT READY");
    @VisibleForTesting
    static final Status WAIT_FOR_READY_ERROR = Status.UNAVAILABLE.withDescription("wait-for-ready RPC is not supported on Subchannel.asChannel()");
    private static final FailingClientTransport notReadyTransport = new FailingClientTransport(NOT_READY_ERROR, ClientStreamListener.RpcProgress.MISCARRIED);
    private final InternalSubchannel subchannel;
    private final Executor executor;
    private final ScheduledExecutorService deadlineCancellationExecutor;
    private final CallTracer callsTracer;
    private final AtomicReference<InternalConfigSelector> configSelector;
    private final ClientCallImpl.ClientStreamProvider transportProvider = new ClientCallImpl.ClientStreamProvider(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public ClientStream newStream(MethodDescriptor<?, ?> method, CallOptions callOptions, Metadata headers, Context context) {
            ClientTransport transport = SubchannelChannel.this.subchannel.getTransport();
            if (transport == null) {
                transport = notReadyTransport;
            }
            ClientStreamTracer[] tracers = GrpcUtil.getClientStreamTracers(callOptions, headers, 0, false, false);
            Context origContext = context.attach();
            try {
                ClientStream clientStream = transport.newStream(method, headers, callOptions, tracers);
                return clientStream;
            }
            finally {
                context.detach(origContext);
            }
        }
    };

    SubchannelChannel(InternalSubchannel subchannel, Executor executor, ScheduledExecutorService deadlineCancellationExecutor, CallTracer callsTracer, AtomicReference<InternalConfigSelector> configSelector) {
        this.subchannel = Preconditions.checkNotNull(subchannel, "subchannel");
        this.executor = Preconditions.checkNotNull(executor, "executor");
        this.deadlineCancellationExecutor = Preconditions.checkNotNull(deadlineCancellationExecutor, "deadlineCancellationExecutor");
        this.callsTracer = Preconditions.checkNotNull(callsTracer, "callsTracer");
        this.configSelector = Preconditions.checkNotNull(configSelector, "configSelector");
    }

    @Override
    public <RequestT, ResponseT> ClientCall<RequestT, ResponseT> newCall(MethodDescriptor<RequestT, ResponseT> methodDescriptor, CallOptions callOptions) {
        Executor effectiveExecutor;
        Executor executor = effectiveExecutor = callOptions.getExecutor() == null ? this.executor : callOptions.getExecutor();
        if (callOptions.isWaitForReady()) {
            return new ClientCall<RequestT, ResponseT>(){

                @Override
                public void start(final ClientCall.Listener<ResponseT> listener, Metadata headers) {
                    effectiveExecutor.execute(new Runnable(){

                        @Override
                        public void run() {
                            listener.onClose(WAIT_FOR_READY_ERROR, new Metadata());
                        }
                    });
                }

                @Override
                public void request(int numMessages) {
                }

                @Override
                public void cancel(String message, Throwable cause) {
                }

                @Override
                public void halfClose() {
                }

                @Override
                public void sendMessage(RequestT message) {
                }
            };
        }
        return new ClientCallImpl<RequestT, ResponseT>(methodDescriptor, effectiveExecutor, callOptions.withOption(GrpcUtil.CALL_OPTIONS_RPC_OWNED_BY_BALANCER, Boolean.TRUE), this.transportProvider, this.deadlineCancellationExecutor, this.callsTracer, this.configSelector.get());
    }

    @Override
    public String authority() {
        return this.subchannel.getAuthority();
    }
}

