/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.internal.grpc.internal;

import java.util.concurrent.Executor;
import net.snowflake.client.jdbc.internal.google.common.annotations.VisibleForTesting;
import net.snowflake.client.jdbc.internal.google.common.base.Preconditions;
import net.snowflake.client.jdbc.internal.google.common.util.concurrent.ListenableFuture;
import net.snowflake.client.jdbc.internal.google.common.util.concurrent.SettableFuture;
import net.snowflake.client.jdbc.internal.grpc.CallOptions;
import net.snowflake.client.jdbc.internal.grpc.ClientStreamTracer;
import net.snowflake.client.jdbc.internal.grpc.InternalChannelz;
import net.snowflake.client.jdbc.internal.grpc.InternalLogId;
import net.snowflake.client.jdbc.internal.grpc.Metadata;
import net.snowflake.client.jdbc.internal.grpc.MethodDescriptor;
import net.snowflake.client.jdbc.internal.grpc.Status;
import net.snowflake.client.jdbc.internal.grpc.internal.ClientStream;
import net.snowflake.client.jdbc.internal.grpc.internal.ClientStreamListener;
import net.snowflake.client.jdbc.internal.grpc.internal.ClientTransport;
import net.snowflake.client.jdbc.internal.grpc.internal.FailingClientStream;

class FailingClientTransport
implements ClientTransport {
    @VisibleForTesting
    final Status error;
    private final ClientStreamListener.RpcProgress rpcProgress;

    FailingClientTransport(Status error, ClientStreamListener.RpcProgress rpcProgress) {
        Preconditions.checkArgument(!error.isOk(), "error must not be OK");
        this.error = error;
        this.rpcProgress = rpcProgress;
    }

    @Override
    public ClientStream newStream(MethodDescriptor<?, ?> method, Metadata headers, CallOptions callOptions, ClientStreamTracer[] tracers) {
        return new FailingClientStream(this.error, this.rpcProgress, tracers);
    }

    @Override
    public void ping(final ClientTransport.PingCallback callback, Executor executor) {
        executor.execute(new Runnable(){

            @Override
            public void run() {
                callback.onFailure(FailingClientTransport.this.error);
            }
        });
    }

    @Override
    public ListenableFuture<InternalChannelz.SocketStats> getStats() {
        SettableFuture<InternalChannelz.SocketStats> ret = SettableFuture.create();
        ret.set(null);
        return ret;
    }

    @Override
    public InternalLogId getLogId() {
        throw new UnsupportedOperationException("Not a real transport");
    }
}

