/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.internal.grpc.alts;

import java.net.InetSocketAddress;
import java.util.concurrent.TimeUnit;
import net.snowflake.client.jdbc.internal.grpc.CallOptions;
import net.snowflake.client.jdbc.internal.grpc.Channel;
import net.snowflake.client.jdbc.internal.grpc.ClientCall;
import net.snowflake.client.jdbc.internal.grpc.ManagedChannel;
import net.snowflake.client.jdbc.internal.grpc.MethodDescriptor;
import net.snowflake.client.jdbc.internal.grpc.internal.GrpcUtil;
import net.snowflake.client.jdbc.internal.grpc.internal.SharedResourceHolder;
import net.snowflake.client.jdbc.internal.grpc.netty.shaded.io.grpc.netty.NettyChannelBuilder;
import net.snowflake.client.jdbc.internal.grpc.netty.shaded.io.netty.channel.EventLoopGroup;
import net.snowflake.client.jdbc.internal.grpc.netty.shaded.io.netty.channel.nio.NioEventLoopGroup;
import net.snowflake.client.jdbc.internal.grpc.netty.shaded.io.netty.channel.socket.nio.NioSocketChannel;
import net.snowflake.client.jdbc.internal.grpc.netty.shaded.io.netty.util.concurrent.DefaultThreadFactory;

final class HandshakerServiceChannel {
    private static final int ALTS_PORT = 8080;
    private static final String DEFAULT_TARGET = "metadata.google.internal.:8080";
    static final SharedResourceHolder.Resource<Channel> SHARED_HANDSHAKER_CHANNEL = new ChannelResource(HandshakerServiceChannel.getHandshakerTarget(System.getenv("GCE_METADATA_HOST")));
    private static final boolean EXPERIMENTAL_ALTS_HANDSHAKER_KEEPALIVE_PARAMS = GrpcUtil.getFlag("GRPC_EXPERIMENTAL_ALTS_HANDSHAKER_KEEPALIVE_PARAMS", false);

    HandshakerServiceChannel() {
    }

    static String getHandshakerTarget(String envValue) {
        if (envValue == null || envValue.isEmpty()) {
            return DEFAULT_TARGET;
        }
        String host = envValue;
        int portIndex = host.lastIndexOf(58);
        if (portIndex != -1) {
            host = host.substring(0, portIndex);
        }
        return host + ":" + 8080;
    }

    static SharedResourceHolder.Resource<Channel> getHandshakerChannelForTesting(String handshakerAddress) {
        return new ChannelResource(handshakerAddress);
    }

    private static class EventLoopHoldingChannel
    extends ForwardingChannel {
        private final ManagedChannel delegate;
        private final EventLoopGroup eventLoopGroup;

        public EventLoopHoldingChannel(ManagedChannel delegate, EventLoopGroup eventLoopGroup) {
            this.delegate = delegate;
            this.eventLoopGroup = eventLoopGroup;
        }

        @Override
        protected Channel delegate() {
            return this.delegate;
        }

        public void close() {
            this.delegate.shutdownNow();
            boolean terminated = false;
            try {
                terminated = this.delegate.awaitTermination(2L, TimeUnit.SECONDS);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            long quietPeriodSeconds = terminated ? 0L : 1L;
            this.eventLoopGroup.shutdownGracefully(quietPeriodSeconds, 10L, TimeUnit.SECONDS);
        }
    }

    private static abstract class ForwardingChannel
    extends Channel {
        private ForwardingChannel() {
        }

        protected abstract Channel delegate();

        @Override
        public String authority() {
            return this.delegate().authority();
        }

        public <ReqT, RespT> ClientCall<ReqT, RespT> newCall(MethodDescriptor<ReqT, RespT> methodDescriptor, CallOptions options) {
            return this.delegate().newCall(methodDescriptor, options);
        }
    }

    private static class ChannelResource
    implements SharedResourceHolder.Resource<Channel> {
        private final String target;

        public ChannelResource(String target) {
            this.target = target;
        }

        @Override
        public Channel create() {
            NioEventLoopGroup eventGroup = new NioEventLoopGroup(1, new DefaultThreadFactory("handshaker pool", true));
            NettyChannelBuilder channelBuilder = ((NettyChannelBuilder)NettyChannelBuilder.forTarget(this.target).channelType(NioSocketChannel.class, InetSocketAddress.class).directExecutor()).eventLoopGroup(eventGroup).usePlaintext();
            if (EXPERIMENTAL_ALTS_HANDSHAKER_KEEPALIVE_PARAMS) {
                channelBuilder.keepAliveTime(10L, TimeUnit.MINUTES).keepAliveTimeout(10L, TimeUnit.SECONDS);
            }
            ManagedChannel channel = channelBuilder.build();
            return new EventLoopHoldingChannel(channel, eventGroup);
        }

        @Override
        public void close(Channel instanceChannel) {
            ((EventLoopHoldingChannel)instanceChannel).close();
        }

        public String toString() {
            return "net.snowflake.client.jdbc.internal.grpc-alts-handshaker-service-channel";
        }
    }
}

