/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.internal.google.cloud.storage;

import java.io.Closeable;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.List;
import net.snowflake.client.jdbc.internal.google.cloud.storage.Buffers;
import net.snowflake.client.jdbc.internal.google.cloud.storage.ReadCursor;
import net.snowflake.client.jdbc.internal.google.storage.v2.ReadObjectResponse;
import net.snowflake.client.jdbc.internal.org.checkerframework.checker.nullness.qual.Nullable;

final class ResponseContentLifecycleHandle
implements Closeable {
    private final @Nullable Closeable dispose;
    private final List<ByteBuffer> buffers;

    ResponseContentLifecycleHandle(ReadObjectResponse resp, @Nullable Closeable dispose) {
        this.dispose = dispose;
        this.buffers = resp.getChecksummedData().getContent().asReadOnlyByteBufferList();
    }

    void copy(ReadCursor c, ByteBuffer[] dsts, int offset, int length) {
        for (ByteBuffer b : this.buffers) {
            long copiedBytes = Buffers.copy(b, dsts, offset, length);
            c.advance(copiedBytes);
            if (!b.hasRemaining()) continue;
            break;
        }
    }

    boolean hasRemaining() {
        for (ByteBuffer b : this.buffers) {
            if (!b.hasRemaining()) continue;
            return true;
        }
        return false;
    }

    @Override
    public void close() throws IOException {
        if (this.dispose != null) {
            this.dispose.close();
        }
    }
}

