/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.internal.amazonaws.transform.rpcv2cbor;

import java.util.ArrayList;
import java.util.List;
import net.snowflake.client.jdbc.internal.amazonaws.transform.Unmarshaller;
import net.snowflake.client.jdbc.internal.amazonaws.transform.rpcv2cbor.RpcV2CborUnmarshallerContext;
import net.snowflake.client.jdbc.internal.fasterxml.jackson.core.JsonToken;

public class ListUnmarshaller<T>
implements Unmarshaller<List<T>, RpcV2CborUnmarshallerContext> {
    private final Unmarshaller<T, RpcV2CborUnmarshallerContext> itemUnmarshaller;

    public ListUnmarshaller(Unmarshaller<T, RpcV2CborUnmarshallerContext> itemUnmarshaller) {
        this.itemUnmarshaller = itemUnmarshaller;
    }

    @Override
    public List<T> unmarshall(RpcV2CborUnmarshallerContext context) throws Exception {
        if (context.isInsideResponseHeader()) {
            return this.unmarshallResponseHeaderToList(context);
        }
        return this.unmarshallRpcV2CborToList(context);
    }

    private List<T> unmarshallResponseHeaderToList(RpcV2CborUnmarshallerContext context) throws Exception {
        String[] headerValues;
        String headerValue = context.readText();
        ArrayList<T> list = new ArrayList<T>();
        for (final String headerVal : headerValues = headerValue.split("[,]")) {
            list.add(this.itemUnmarshaller.unmarshall(new RpcV2CborUnmarshallerContext(){

                @Override
                public String readText() {
                    return headerVal;
                }
            }));
        }
        return list;
    }

    private List<T> unmarshallRpcV2CborToList(RpcV2CborUnmarshallerContext context) throws Exception {
        ArrayList<T> list = new ArrayList<T>();
        if (context.getCurrentToken() == JsonToken.VALUE_NULL) {
            return null;
        }
        JsonToken token;
        while ((token = context.nextToken()) != null) {
            if (token == JsonToken.END_ARRAY) {
                return list;
            }
            list.add(this.itemUnmarshaller.unmarshall(context));
        }
        return list;
    }
}

