/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.internal.amazonaws.services.kms.model.transform;

import java.nio.ByteBuffer;
import java.util.List;
import net.snowflake.client.jdbc.internal.amazonaws.SdkClientException;
import net.snowflake.client.jdbc.internal.amazonaws.annotation.SdkInternalApi;
import net.snowflake.client.jdbc.internal.amazonaws.protocol.MarshallLocation;
import net.snowflake.client.jdbc.internal.amazonaws.protocol.MarshallingInfo;
import net.snowflake.client.jdbc.internal.amazonaws.protocol.MarshallingType;
import net.snowflake.client.jdbc.internal.amazonaws.protocol.ProtocolMarshaller;
import net.snowflake.client.jdbc.internal.amazonaws.protocol.StructuredPojo;
import net.snowflake.client.jdbc.internal.amazonaws.services.kms.model.DeriveSharedSecretRequest;

@SdkInternalApi
public class DeriveSharedSecretRequestMarshaller {
    private static final MarshallingInfo<String> KEYID_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("KeyId").build();
    private static final MarshallingInfo<String> KEYAGREEMENTALGORITHM_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("KeyAgreementAlgorithm").build();
    private static final MarshallingInfo<ByteBuffer> PUBLICKEY_BINDING = MarshallingInfo.builder(MarshallingType.BYTE_BUFFER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("PublicKey").build();
    private static final MarshallingInfo<List> GRANTTOKENS_BINDING = MarshallingInfo.builder(MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("GrantTokens").build();
    private static final MarshallingInfo<Boolean> DRYRUN_BINDING = MarshallingInfo.builder(MarshallingType.BOOLEAN).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("DryRun").build();
    private static final MarshallingInfo<StructuredPojo> RECIPIENT_BINDING = MarshallingInfo.builder(MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Recipient").build();
    private static final DeriveSharedSecretRequestMarshaller instance = new DeriveSharedSecretRequestMarshaller();

    public static DeriveSharedSecretRequestMarshaller getInstance() {
        return instance;
    }

    public void marshall(DeriveSharedSecretRequest deriveSharedSecretRequest, ProtocolMarshaller protocolMarshaller) {
        if (deriveSharedSecretRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall(deriveSharedSecretRequest.getKeyId(), KEYID_BINDING);
            protocolMarshaller.marshall(deriveSharedSecretRequest.getKeyAgreementAlgorithm(), KEYAGREEMENTALGORITHM_BINDING);
            protocolMarshaller.marshall(deriveSharedSecretRequest.getPublicKey(), PUBLICKEY_BINDING);
            protocolMarshaller.marshall(deriveSharedSecretRequest.getGrantTokens(), GRANTTOKENS_BINDING);
            protocolMarshaller.marshall(deriveSharedSecretRequest.getDryRun(), DRYRUN_BINDING);
            protocolMarshaller.marshall(deriveSharedSecretRequest.getRecipient(), RECIPIENT_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), e);
        }
    }
}

