/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.internal.amazonaws.endpoints.internal;

import net.snowflake.client.jdbc.internal.amazonaws.annotation.SdkInternalApi;
import net.snowflake.client.jdbc.internal.amazonaws.annotation.SdkTestInternalApi;
import net.snowflake.client.jdbc.internal.amazonaws.auth.profile.internal.BasicProfile;
import net.snowflake.client.jdbc.internal.amazonaws.auth.profile.internal.BasicProfileConfigFileLoader;
import net.snowflake.client.jdbc.internal.amazonaws.endpoints.AccountIdEndpointMode;

@SdkInternalApi
public class AccountIdEndpointModeResolver {
    private static final AccountIdEndpointMode SDK_DEFAULT_ACCOUNT_ID_ENDPOINT_MODE = AccountIdEndpointMode.PREFERRED;
    private static final String PROFILE_PROPERTY = "account_id_endpoint_mode";
    private final BasicProfileConfigFileLoader configFileLoader;
    private AccountIdEndpointMode accountIdEndpointMode;

    public AccountIdEndpointModeResolver() {
        this(BasicProfileConfigFileLoader.INSTANCE);
    }

    @SdkTestInternalApi
    AccountIdEndpointModeResolver(BasicProfileConfigFileLoader configFileLoader) {
        this.configFileLoader = configFileLoader;
        this.accountIdEndpointMode = this.resolveAccountIdEndpointMode();
    }

    public AccountIdEndpointMode accountIdEndpointMode() {
        return this.accountIdEndpointMode;
    }

    private AccountIdEndpointMode systemProperty() {
        return AccountIdEndpointMode.fromName(System.getProperty("net.snowflake.client.jdbc.internal.amazonaws.sdk.accountIdEndpointMode"));
    }

    private AccountIdEndpointMode envVar() {
        return AccountIdEndpointMode.fromName(System.getenv("AWS_ACCOUNT_ID_ENDPOINT_MODE"));
    }

    private AccountIdEndpointMode resolveAccountIdEndpointMode() {
        AccountIdEndpointMode mode = this.envVar();
        if (mode != null) {
            return mode;
        }
        mode = this.systemProperty();
        if (mode != null) {
            return mode;
        }
        mode = this.profile();
        if (mode != null) {
            return mode;
        }
        return SDK_DEFAULT_ACCOUNT_ID_ENDPOINT_MODE;
    }

    private AccountIdEndpointMode profile() {
        BasicProfile profile = this.configFileLoader.getProfile();
        if (profile == null) {
            return null;
        }
        String val = profile.getPropertyValue(PROFILE_PROPERTY);
        return AccountIdEndpointMode.fromName(val);
    }
}

