/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.internal.core.minicore;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.snowflake.client.core.Constants;
import net.snowflake.client.core.ObjectMapperFactory;
import net.snowflake.client.core.SnowflakeJdbcInternalApi;
import net.snowflake.client.internal.core.minicore.Minicore;
import net.snowflake.client.internal.core.minicore.MinicoreLoadError;
import net.snowflake.client.internal.core.minicore.MinicoreLoadResult;
import net.snowflake.client.jdbc.internal.fasterxml.jackson.databind.ObjectMapper;
import net.snowflake.client.jdbc.internal.fasterxml.jackson.databind.node.ArrayNode;
import net.snowflake.client.jdbc.internal.fasterxml.jackson.databind.node.ObjectNode;
import net.snowflake.client.util.SecretDetector;

@SnowflakeJdbcInternalApi
public class MinicoreTelemetry {
    private final String isa;
    private final String coreVersion;
    private final String coreFileName;
    private final MinicoreLoadError coreLoadError;
    private final List<String> coreLoadLogs;

    private MinicoreTelemetry(String isa, String coreVersion, String coreFileName, MinicoreLoadError coreLoadError, List<String> coreLoadLogs) {
        this.isa = isa;
        this.coreVersion = coreVersion;
        this.coreFileName = coreFileName;
        this.coreLoadError = coreLoadError;
        this.coreLoadLogs = coreLoadLogs != null ? coreLoadLogs : new ArrayList();
    }

    public static MinicoreTelemetry create() {
        String isa = Constants.getArchitecture().getIdentifier();
        if (Minicore.isDisabledViaEnvVar()) {
            return new MinicoreTelemetry(isa, null, null, MinicoreLoadError.DISABLED, null);
        }
        Minicore minicore = Minicore.getInstance();
        if (minicore == null) {
            return new MinicoreTelemetry(isa, null, null, MinicoreLoadError.STILL_LOADING, null);
        }
        MinicoreLoadResult result = minicore.getLoadResult();
        if (result == null) {
            return new MinicoreTelemetry(isa, null, null, MinicoreLoadError.STILL_LOADING, null);
        }
        return MinicoreTelemetry.fromLoadResult(result);
    }

    public static MinicoreTelemetry fromLoadResult(MinicoreLoadResult loadResult) {
        Throwable exception;
        String isa = Constants.getArchitecture().getIdentifier();
        String coreVersion = loadResult.getCoreVersion();
        String coreFileName = loadResult.getLibraryFileName();
        ArrayList<String> logs = new ArrayList<String>(loadResult.getLogs());
        if (loadResult.isSuccess()) {
            return new MinicoreTelemetry(isa, coreVersion, coreFileName, null, logs);
        }
        String detailedError = loadResult.getErrorMessage();
        if (detailedError != null && !detailedError.isEmpty()) {
            logs.add("Error: " + detailedError);
        }
        if ((exception = loadResult.getException()) != null) {
            logs.add("Exception: " + exception.getClass().getName() + ": " + exception.getMessage());
        }
        return new MinicoreTelemetry(isa, coreVersion, coreFileName, MinicoreLoadError.FAILED_TO_LOAD, logs);
    }

    public Map<String, Object> toClientEnvironmentTelemetryMap() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (this.isa != null) {
            map.put("ISA", SecretDetector.maskSecrets(this.isa));
        }
        if (this.coreVersion != null) {
            map.put("CORE_VERSION", SecretDetector.maskSecrets(this.coreVersion));
        }
        if (this.coreFileName != null) {
            map.put("CORE_FILE_NAME", SecretDetector.maskSecrets(this.coreFileName));
        }
        if (this.coreLoadError != null) {
            map.put("CORE_LOAD_ERROR", SecretDetector.maskSecrets(this.coreLoadError.getMessage()));
        }
        return map;
    }

    public ObjectNode toInBandTelemetryNode() {
        ObjectMapper mapper = ObjectMapperFactory.getObjectMapper();
        ObjectNode message = mapper.createObjectNode();
        message.put("type", "client_minicore_load");
        message.put("source", "JDBC");
        message.put("success", this.coreLoadError == null);
        if (this.coreFileName != null) {
            message.put("libraryFileName", SecretDetector.maskSecrets(this.coreFileName));
        }
        if (this.coreVersion != null) {
            message.put("coreVersion", SecretDetector.maskSecrets(this.coreVersion));
        }
        if (this.coreLoadError != null) {
            message.put("error", SecretDetector.maskSecrets(this.coreLoadError.getMessage()));
        }
        if (!this.coreLoadLogs.isEmpty()) {
            ArrayNode logsArray = message.putArray("loadLogs");
            this.coreLoadLogs.stream().map(SecretDetector::maskSecrets).forEach(logsArray::add);
        }
        return message;
    }

    public String toString() {
        return String.format("MinicoreTelemetry{isa='%s', coreVersion='%s', coreFileName='%s', coreLoadError='%s', logs=%d entries}", this.isa, this.coreVersion, this.coreFileName, this.coreLoadError != null ? this.coreLoadError.getMessage() : null, this.coreLoadLogs.size());
    }
}

