/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.core;

import java.io.File;
import net.snowflake.client.core.Constants;
import net.snowflake.client.core.FileUtil;
import net.snowflake.client.core.SnowflakeJdbcInternalApi;
import net.snowflake.client.jdbc.SnowflakeUtil;
import net.snowflake.client.log.SFLogger;
import net.snowflake.client.log.SFLoggerFactory;

@SnowflakeJdbcInternalApi
public class FileCacheUtil {
    private static final SFLogger logger = SFLoggerFactory.getLogger(FileCacheUtil.class);

    public static File getDefaultCacheDir() {
        String homeDir;
        if (Constants.getOS() == Constants.OS.LINUX) {
            String xdgCacheHome = FileCacheUtil.getDir(SnowflakeUtil.systemGetEnv("XDG_CACHE_HOME"));
            if (xdgCacheHome != null) {
                return new File(xdgCacheHome, "snowflake");
            }
            logger.debug("XDG cache home directory is not set or not writable.", new Object[0]);
        }
        if ((homeDir = FileCacheUtil.getDir(SnowflakeUtil.systemGetProperty("user.home"))) == null) {
            logger.debug("Home directory is not set or not writable, no cache dir is set.", new Object[0]);
            return null;
        }
        if (Constants.getOS() == Constants.OS.WINDOWS) {
            return new File(new File(new File(new File(homeDir, "AppData"), "Local"), "Snowflake"), "Caches");
        }
        if (Constants.getOS() == Constants.OS.MAC) {
            return new File(new File(new File(homeDir, "Library"), "Caches"), "Snowflake");
        }
        return new File(new File(homeDir, ".cache"), "snowflake");
    }

    private static String getDir(String dir) {
        if (dir != null && FileUtil.isWritable(dir)) {
            return dir;
        }
        return null;
    }
}

