/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.common.lower.coroutines;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.backend.common.CommonBackendContext;
import org.jetbrains.kotlin.backend.common.CommonIrAttributesKt;
import org.jetbrains.kotlin.backend.common.ir.IrInlineUtilsKt;
import org.jetbrains.kotlin.backend.common.lower.LowerUtilsKt;
import org.jetbrains.kotlin.backend.common.lower.VariableRemapper;
import org.jetbrains.kotlin.ir.IrBuiltIns;
import org.jetbrains.kotlin.ir.builders.ExpressionHelpersKt;
import org.jetbrains.kotlin.ir.builders.declarations.DeclarationBuildersKt;
import org.jetbrains.kotlin.ir.builders.declarations.IrDeclarationBuilder;
import org.jetbrains.kotlin.ir.builders.declarations.IrFunctionBuilder;
import org.jetbrains.kotlin.ir.builders.declarations.IrValueParameterBuilder;
import org.jetbrains.kotlin.ir.declarations.IrDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationOrigin;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationsKt;
import org.jetbrains.kotlin.ir.declarations.IrFactory;
import org.jetbrains.kotlin.ir.declarations.IrFunction;
import org.jetbrains.kotlin.ir.declarations.IrParameterKind;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.declarations.IrValueParameter;
import org.jetbrains.kotlin.ir.expressions.IrBlockBody;
import org.jetbrains.kotlin.ir.expressions.IrBody;
import org.jetbrains.kotlin.ir.expressions.IrExpressionBody;
import org.jetbrains.kotlin.ir.expressions.IrReturn;
import org.jetbrains.kotlin.ir.symbols.IrClassifierSymbol;
import org.jetbrains.kotlin.ir.symbols.IrSimpleFunctionSymbol;
import org.jetbrains.kotlin.ir.symbols.IrSymbol;
import org.jetbrains.kotlin.ir.symbols.IrTypeParameterSymbol;
import org.jetbrains.kotlin.ir.types.IrType;
import org.jetbrains.kotlin.ir.types.IrTypesKt;
import org.jetbrains.kotlin.ir.util.IrTypeUtilsKt;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.ir.visitors.IrTransformer;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.utils.MemoryOptimizedCollectionUtilKt;

@Metadata(mv={2, 3, 0}, k=2, xi=48, d1={"\u00000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u001a(\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\t\u001a\u0018\u0010\n\u001a\u00020\u00052\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0002\u001a\u0012\u0010\u000b\u001a\u00020\u0005*\u00020\u00052\u0006\u0010\u0002\u001a\u00020\u0003\u001a\u0014\u0010\f\u001a\u00020\u0005*\u00020\u00052\u0006\u0010\u0002\u001a\u00020\u0003H\u0002\u001a\u0014\u0010\r\u001a\u00020\t*\u00020\u000e2\u0006\u0010\u0002\u001a\u00020\u0003H\u0002\u001a\u0016\u0010\u000f\u001a\u00020\t2\u0006\u0010\u0004\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u0011\u00a8\u0006\u0012"}, d2={"addExplicitReturnUnitToSuspendFunctions", "", "context", "Lorg/jetbrains/kotlin/backend/common/CommonBackendContext;", "function", "Lorg/jetbrains/kotlin/ir/declarations/IrSimpleFunction;", "body", "Lorg/jetbrains/kotlin/ir/expressions/IrBody;", "returnType", "Lorg/jetbrains/kotlin/ir/types/IrType;", "transformSuspendFunction", "getOrCreateFunctionWithContinuationStub", "createSuspendFunctionStub", "continuationType", "Lorg/jetbrains/kotlin/ir/declarations/IrFunction;", "loweredSuspendFunctionReturnType", "irBuiltIns", "Lorg/jetbrains/kotlin/ir/IrBuiltIns;", "ir.backend.common"})
@SourceDebugExtension(value={"SMAP\nAddContinuationToFunctionsLowering.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AddContinuationToFunctionsLowering.kt\norg/jetbrains/kotlin/backend/common/lower/coroutines/AddContinuationToFunctionsLoweringKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 declarationBuilders.kt\norg/jetbrains/kotlin/ir/builders/declarations/DeclarationBuildersKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,153:1\n1#2:154\n269#3,4:155\n369#3,7:163\n1586#4:159\n1661#4,3:160\n*S KotlinDebug\n*F\n+ 1 AddContinuationToFunctionsLowering.kt\norg/jetbrains/kotlin/backend/common/lower/coroutines/AddContinuationToFunctionsLoweringKt\n*L\n114#1:155,4\n137#1:163,7\n131#1:159\n131#1:160,3\n*E\n"})
public final class AddContinuationToFunctionsLoweringKt {
    public static final void addExplicitReturnUnitToSuspendFunctions(@NotNull CommonBackendContext context2, @NotNull IrSimpleFunction function2, @Nullable IrBody body, @NotNull IrType returnType) {
        Intrinsics.checkNotNullParameter(context2, "context");
        Intrinsics.checkNotNullParameter(function2, "function");
        Intrinsics.checkNotNullParameter(returnType, "returnType");
        if (Intrinsics.areEqual(returnType, context2.getIrBuiltIns().getUnitType()) && body instanceof IrBlockBody && !(CollectionsKt.lastOrNull(((IrBlockBody)body).getStatements()) instanceof IrReturn)) {
            ((Collection)((IrBlockBody)body).getStatements()).add(ExpressionHelpersKt.irReturnUnit(LowerUtilsKt.createIrBuilder(context2, (IrSymbol)function2.getSymbol(), IrUtilsKt.getPreviousOffset(((IrBlockBody)body).getEndOffset()), IrUtilsKt.getPreviousOffset(((IrBlockBody)body).getEndOffset()))));
        }
    }

    private static final IrSimpleFunction transformSuspendFunction(CommonBackendContext context2, IrSimpleFunction function2) {
        IrSimpleFunction newFunctionWithContinuation = AddContinuationToFunctionsLoweringKt.getOrCreateFunctionWithContinuationStub(function2, context2);
        Map parameterMapping = MapsKt.toMap(CollectionsKt.zip((Iterable)function2.getParameters(), (Iterable)newFunctionWithContinuation.getParameters()));
        IrBody newBody = IrInlineUtilsKt.moveBodyTo(function2, newFunctionWithContinuation, parameterMapping);
        for (Map.Entry entry : parameterMapping.entrySet()) {
            IrValueParameter old = (IrValueParameter)entry.getKey();
            IrValueParameter irValueParameter = (IrValueParameter)entry.getValue();
            IrExpressionBody irExpressionBody = old.getDefaultValue();
            irValueParameter.setDefaultValue((IrExpressionBody)(irExpressionBody != null ? irExpressionBody.transform((IrTransformer)new VariableRemapper(parameterMapping), (Object)null) : null));
        }
        AddContinuationToFunctionsLoweringKt.addExplicitReturnUnitToSuspendFunctions(context2, newFunctionWithContinuation, newBody, function2.getReturnType());
        newFunctionWithContinuation.setBody(newBody);
        return newFunctionWithContinuation;
    }

    @NotNull
    public static final IrSimpleFunction getOrCreateFunctionWithContinuationStub(@NotNull IrSimpleFunction $this$getOrCreateFunctionWithContinuationStub, @NotNull CommonBackendContext context2) {
        Intrinsics.checkNotNullParameter($this$getOrCreateFunctionWithContinuationStub, "<this>");
        Intrinsics.checkNotNullParameter(context2, "context");
        IrSimpleFunction irSimpleFunction = CommonIrAttributesKt.getFunctionWithContinuations($this$getOrCreateFunctionWithContinuationStub);
        if (irSimpleFunction == null) {
            IrSimpleFunction irSimpleFunction2;
            IrSimpleFunction it = irSimpleFunction2 = AddContinuationToFunctionsLoweringKt.createSuspendFunctionStub($this$getOrCreateFunctionWithContinuationStub, context2);
            boolean bl = false;
            CommonIrAttributesKt.setFunctionWithContinuations($this$getOrCreateFunctionWithContinuationStub, it);
            CommonIrAttributesKt.setSuspendFunction(it, $this$getOrCreateFunctionWithContinuationStub);
            irSimpleFunction = irSimpleFunction2;
        }
        return irSimpleFunction;
    }

    /*
     * WARNING - void declaration
     */
    private static final IrSimpleFunction createSuspendFunctionStub(IrSimpleFunction $this$createSuspendFunctionStub, CommonBackendContext context2) {
        IrValueParameter irValueParameter;
        Collection<IrSimpleFunctionSymbol> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        IrSimpleFunction irSimpleFunction;
        if (!$this$createSuspendFunctionStub.isSuspend()) {
            boolean $i$a$-require-AddContinuationToFunctionsLoweringKt$createSuspendFunctionStub$22 = false;
            String $i$a$-require-AddContinuationToFunctionsLoweringKt$createSuspendFunctionStub$22 = IrUtilsKt.getFqNameWhenAvailable($this$createSuspendFunctionStub) + " should be a suspend function to create version with contunation";
            throw new IllegalArgumentException($i$a$-require-AddContinuationToFunctionsLoweringKt$createSuspendFunctionStub$22.toString());
        }
        IrFactory $this$buildFun$iv = $this$createSuspendFunctionStub.getFactory();
        boolean $i$f$buildFun = false;
        IrFunctionBuilder $this$buildFun_u24lambda_u240$iv = new IrFunctionBuilder();
        boolean bl = false;
        Object $this$createSuspendFunctionStub_u24lambda_u241 = $this$buildFun_u24lambda_u240$iv;
        boolean bl2 = false;
        ((IrFunctionBuilder)$this$createSuspendFunctionStub_u24lambda_u241).updateFrom($this$createSuspendFunctionStub);
        ((IrFunctionBuilder)$this$createSuspendFunctionStub_u24lambda_u241).setSuspend(false);
        ((IrDeclarationBuilder)$this$createSuspendFunctionStub_u24lambda_u241).setName($this$createSuspendFunctionStub.getName());
        ((IrDeclarationBuilder)$this$createSuspendFunctionStub_u24lambda_u241).setOrigin(IrDeclarationOrigin.Companion.getLOWERED_SUSPEND_FUNCTION());
        ((IrFunctionBuilder)$this$createSuspendFunctionStub_u24lambda_u241).setReturnType(AddContinuationToFunctionsLoweringKt.loweredSuspendFunctionReturnType($this$createSuspendFunctionStub, context2.getIrBuiltIns()));
        IrSimpleFunction function2 = irSimpleFunction = DeclarationBuildersKt.buildFunction($this$buildFun$iv, $this$buildFun_u24lambda_u240$iv);
        boolean bl3 = false;
        function2.setParent($this$createSuspendFunctionStub.getParent());
        function2.setMetadata($this$createSuspendFunctionStub.getMetadata());
        IrUtilsKt.copyAnnotationsFrom(function2, $this$createSuspendFunctionStub);
        IrDeclarationsKt.copyAttributes$default(function2, $this$createSuspendFunctionStub, false, 2, null);
        IrUtilsKt.copyTypeParametersFrom$default(function2, $this$createSuspendFunctionStub, null, null, 6, null);
        Map<IrTypeParameterSymbol, IrType> substitutionMap = IrUtilsKt.makeTypeParameterSubstitutionMap($this$createSuspendFunctionStub, function2);
        IrUtilsKt.copyParametersFrom(function2, $this$createSuspendFunctionStub, substitutionMap);
        $this$createSuspendFunctionStub_u24lambda_u241 = $this$createSuspendFunctionStub.getOverriddenSymbols();
        List<IrSimpleFunctionSymbol> list = function2.getOverriddenSymbols();
        IrSimpleFunction irSimpleFunction2 = function2;
        boolean $i$f$map = false;
        void var10_16 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            IrSimpleFunctionSymbol irSimpleFunctionSymbol = (IrSimpleFunctionSymbol)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl4 = false;
            collection.add($this$createSuspendFunctionStub.getFactory().getStageController().restrictTo((IrDeclaration)it.getOwner(), () -> AddContinuationToFunctionsLoweringKt.createSuspendFunctionStub$lambda$2$0$0((IrSimpleFunctionSymbol)it, context2)));
        }
        collection = (List)destination$iv$iv;
        irSimpleFunction2.setOverriddenSymbols((List<? extends IrSimpleFunctionSymbol>)MemoryOptimizedCollectionUtilKt.memoryOptimizedPlus(list, collection));
        IrFunction $this$addValueParameter$iv = function2;
        boolean $i$f$addValueParameter = false;
        IrValueParameterBuilder $this$addValueParameter_u24lambda_u240$iv = new IrValueParameterBuilder();
        boolean bl5 = false;
        IrValueParameterBuilder $this$createSuspendFunctionStub_u24lambda_u242_u241 = $this$addValueParameter_u24lambda_u240$iv;
        boolean bl6 = false;
        $this$createSuspendFunctionStub_u24lambda_u242_u241.setStartOffset(function2.getStartOffset());
        $this$createSuspendFunctionStub_u24lambda_u242_u241.setEndOffset(function2.getEndOffset());
        $this$createSuspendFunctionStub_u24lambda_u242_u241.setOrigin(IrDeclarationOrigin.Companion.getCONTINUATION());
        Name name2 = Name.identifier("$completion");
        Intrinsics.checkNotNullExpressionValue(name2, "identifier(...)");
        $this$createSuspendFunctionStub_u24lambda_u242_u241.setName(name2);
        $this$createSuspendFunctionStub_u24lambda_u242_u241.setType(IrTypeUtilsKt.substitute(AddContinuationToFunctionsLoweringKt.continuationType($this$createSuspendFunctionStub, context2), substitutionMap));
        $this$addValueParameter_u24lambda_u240$iv.setKind(IrParameterKind.Regular);
        IrValueParameter valueParameter$iv = irValueParameter = DeclarationBuildersKt.buildValueParameter($this$addValueParameter$iv.getFactory(), $this$addValueParameter_u24lambda_u240$iv, $this$addValueParameter$iv);
        boolean bl7 = false;
        $this$addValueParameter$iv.setParameters(CollectionsKt.plus((Collection)$this$addValueParameter$iv.getParameters(), valueParameter$iv));
        return irSimpleFunction;
    }

    private static final IrType continuationType(IrFunction $this$continuationType, CommonBackendContext context2) {
        IrType[] irTypeArray = new IrType[]{$this$continuationType.getReturnType()};
        return IrTypesKt.typeWith((IrClassifierSymbol)context2.getSymbols().getContinuationClass(), irTypeArray);
    }

    @NotNull
    public static final IrType loweredSuspendFunctionReturnType(@NotNull IrFunction function2, @NotNull IrBuiltIns irBuiltIns) {
        Intrinsics.checkNotNullParameter(function2, "function");
        Intrinsics.checkNotNullParameter(irBuiltIns, "irBuiltIns");
        return IrTypeUtilsKt.isNullable(function2.getReturnType()) ? irBuiltIns.getAnyNType() : irBuiltIns.getAnyType();
    }

    private static final IrSimpleFunctionSymbol createSuspendFunctionStub$lambda$2$0$0(IrSimpleFunctionSymbol $it, CommonBackendContext $context) {
        return AddContinuationToFunctionsLoweringKt.getOrCreateFunctionWithContinuationStub((IrSimpleFunction)$it.getOwner(), $context).getSymbol();
    }

    public static final /* synthetic */ IrSimpleFunction access$transformSuspendFunction(CommonBackendContext context2, IrSimpleFunction function2) {
        return AddContinuationToFunctionsLoweringKt.transformSuspendFunction(context2, function2);
    }
}

