//
// Automatically generated by ipdlc.
// Edit at your own risk
//

#ifndef CacheTypes_h
#define CacheTypes_h

#include "mozilla/Attributes.h"
#include "IPCMessageStart.h"
#include "mozilla/RefPtr.h"
#include "nsString.h"
#include "nsTArray.h"
#include "nsTHashtable.h"
#include "mozilla/MozPromise.h"
#include "mozilla/OperatorNewExtensions.h"
#include "mozilla/UniquePtr.h"
#include "mozilla/ipc/ByteBuf.h"
#include "mozilla/ipc/FileDescriptor.h"
#include "mozilla/ipc/IPCForwards.h"
#include "mozilla/ipc/Shmem.h"

// Headers for typedefs
#include "mozilla/dom/HeadersBinding.h"
#include "mozilla/dom/ReferrerPolicyBinding.h"
#include "mozilla/dom/RequestBinding.h"
#include "mozilla/dom/ResponseBinding.h"
#include "mozilla/dom/cache/Types.h"
#include "mozilla/ipc/IPCCore.h"
#include "mozilla/ipc/IPDLStructMember.h"
#include "mozilla/ipc/SideVariant.h"
#include "nsIContentPolicy.h"
#include "nsID.h"
#include "nsILoadInfo.h"
#include "nsITransportSecurityInfo.h"
#include "mozilla/ipc/IPCStream.h"
#include "mozilla/ipc/PBackgroundSharedTypes.h"


//-----------------------------------------------------------------------------
// Declaration of the IPDL type |struct CacheQueryParams|
//
namespace mozilla {
namespace dom {
namespace cache {
class CacheQueryParams final
{
private:
    typedef ::nsString nsString;

public:
#ifdef __clang__
#  pragma clang diagnostic push
#  if __has_warning("-Wdefaulted-function-deleted")
#    pragma clang diagnostic ignored "-Wdefaulted-function-deleted"
#  endif
#endif
    CacheQueryParams() = default;
#ifdef __clang__
#  pragma clang diagnostic pop
#endif

    MOZ_IMPLICIT CacheQueryParams(
            const bool& _ignoreSearch,
            const bool& _ignoreMethod,
            const bool& _ignoreVary,
            const bool& _cacheNameSet,
            const nsString& _cacheName) :
        ignoreSearch_(_ignoreSearch),
        ignoreMethod_(_ignoreMethod),
        ignoreVary_(_ignoreVary),
        cacheNameSet_(_cacheNameSet),
        cacheName_(_cacheName)
    {
    }

    MOZ_IMPLICIT CacheQueryParams(
            bool&& _ignoreSearch,
            bool&& _ignoreMethod,
            bool&& _ignoreVary,
            bool&& _cacheNameSet,
            nsString&& _cacheName) :
        ignoreSearch_(std::move(_ignoreSearch)),
        ignoreMethod_(std::move(_ignoreMethod)),
        ignoreVary_(std::move(_ignoreVary)),
        cacheNameSet_(std::move(_cacheNameSet)),
        cacheName_(std::move(_cacheName))
    {
    }

    bool&
    ignoreSearch()
    {
        return ignoreSearch_;
    }
    const bool&
    ignoreSearch() const
    {
        return ignoreSearch_;
    }

    bool&
    ignoreMethod()
    {
        return ignoreMethod_;
    }
    const bool&
    ignoreMethod() const
    {
        return ignoreMethod_;
    }

    bool&
    ignoreVary()
    {
        return ignoreVary_;
    }
    const bool&
    ignoreVary() const
    {
        return ignoreVary_;
    }

    bool&
    cacheNameSet()
    {
        return cacheNameSet_;
    }
    const bool&
    cacheNameSet() const
    {
        return cacheNameSet_;
    }

    nsString&
    cacheName()
    {
        return cacheName_;
    }
    const nsString&
    cacheName() const
    {
        return cacheName_;
    }

private:
    ::mozilla::ipc::IPDLStructMember<bool> ignoreSearch_;
    ::mozilla::ipc::IPDLStructMember<bool> ignoreMethod_;
    ::mozilla::ipc::IPDLStructMember<bool> ignoreVary_;
    ::mozilla::ipc::IPDLStructMember<bool> cacheNameSet_;
    ::mozilla::ipc::IPDLStructMember<nsString> cacheName_;
};
} // namespace cache
} // namespace dom
} // namespace mozilla

namespace IPC {
template<>
struct ParamTraits <::mozilla::dom::cache::CacheQueryParams>
{
    typedef ::mozilla::dom::cache::CacheQueryParams paramType;
    static void
    Write(
            IPC::MessageWriter* aWriter,
            const paramType& aVar);
    static IPC::ReadResult<paramType>
    Read(IPC::MessageReader* aReader);
};
} // namespace IPC

namespace mozilla {
namespace dom {
namespace cache {
class PCacheStreamControlParent;
} // namespace cache
} // namespace dom
} // namespace mozilla

namespace mozilla {
namespace dom {
namespace cache {
class PCacheStreamControlChild;
} // namespace cache
} // namespace dom
} // namespace mozilla


//-----------------------------------------------------------------------------
// Declaration of the IPDL type |struct CacheReadStream|
//
namespace mozilla {
namespace dom {
namespace cache {
class CacheReadStream final
{
private:
    typedef ::nsID nsID;
    typedef ::mozilla::dom::cache::PCacheStreamControlParent PCacheStreamControlParent;
    typedef ::mozilla::dom::cache::PCacheStreamControlChild PCacheStreamControlChild;
    typedef ::mozilla::ipc::IPCStream IPCStream;

public:
#ifdef __clang__
#  pragma clang diagnostic push
#  if __has_warning("-Wdefaulted-function-deleted")
#    pragma clang diagnostic ignored "-Wdefaulted-function-deleted"
#  endif
#endif
    CacheReadStream() = default;
#ifdef __clang__
#  pragma clang diagnostic pop
#endif

    MOZ_IMPLICIT CacheReadStream(
            const nsID& _id,
            ::mozilla::ipc::SideVariant<PCacheStreamControlParent*, PCacheStreamControlChild*> _control,
            const mozilla::Maybe<IPCStream>& _stream) :
        id_(_id),
        control_(_control),
        stream_(_stream)
    {
    }

    MOZ_IMPLICIT CacheReadStream(
            nsID&& _id,
            ::mozilla::ipc::SideVariant<PCacheStreamControlParent*, PCacheStreamControlChild*> _control,
            mozilla::Maybe<IPCStream>&& _stream) :
        id_(std::move(_id)),
        control_(_control),
        stream_(std::move(_stream))
    {
    }

    nsID&
    id()
    {
        return id_;
    }
    const nsID&
    id() const
    {
        return id_;
    }

    ::mozilla::ipc::SideVariant<PCacheStreamControlParent*, PCacheStreamControlChild*>&
    control()
    {
        return control_;
    }
    ::mozilla::ipc::SideVariant<PCacheStreamControlParent*, PCacheStreamControlChild*>
    control() const
    {
        return control_;
    }

    mozilla::Maybe<IPCStream>&
    stream()
    {
        return stream_;
    }
    const mozilla::Maybe<IPCStream>&
    stream() const
    {
        return stream_;
    }

private:
    ::mozilla::ipc::IPDLStructMember<nsID> id_;
    ::mozilla::ipc::IPDLStructMember<::mozilla::ipc::SideVariant<PCacheStreamControlParent*, PCacheStreamControlChild*>> control_;
    ::mozilla::ipc::IPDLStructMember<mozilla::Maybe<IPCStream>> stream_;
};
} // namespace cache
} // namespace dom
} // namespace mozilla

namespace IPC {
template<>
struct ParamTraits <::mozilla::dom::cache::CacheReadStream>
{
    typedef ::mozilla::dom::cache::CacheReadStream paramType;
    static void
    Write(
            IPC::MessageWriter* aWriter,
            const paramType& aVar);
    static IPC::ReadResult<paramType>
    Read(IPC::MessageReader* aReader);
};
} // namespace IPC


//-----------------------------------------------------------------------------
// Declaration of the IPDL type |struct HeadersEntry|
//
namespace mozilla {
namespace dom {
namespace cache {
class HeadersEntry final
{
private:
    typedef ::nsCString nsCString;

public:
#ifdef __clang__
#  pragma clang diagnostic push
#  if __has_warning("-Wdefaulted-function-deleted")
#    pragma clang diagnostic ignored "-Wdefaulted-function-deleted"
#  endif
#endif
    HeadersEntry() = default;
#ifdef __clang__
#  pragma clang diagnostic pop
#endif

    MOZ_IMPLICIT HeadersEntry(
            const nsCString& _name,
            const nsCString& _value) :
        name_(_name),
        value_(_value)
    {
    }

    MOZ_IMPLICIT HeadersEntry(
            nsCString&& _name,
            nsCString&& _value) :
        name_(std::move(_name)),
        value_(std::move(_value))
    {
    }

    nsCString&
    name()
    {
        return name_;
    }
    const nsCString&
    name() const
    {
        return name_;
    }

    nsCString&
    value()
    {
        return value_;
    }
    const nsCString&
    value() const
    {
        return value_;
    }

private:
    ::mozilla::ipc::IPDLStructMember<nsCString> name_;
    ::mozilla::ipc::IPDLStructMember<nsCString> value_;
};
} // namespace cache
} // namespace dom
} // namespace mozilla

namespace IPC {
template<>
struct ParamTraits <::mozilla::dom::cache::HeadersEntry>
{
    typedef ::mozilla::dom::cache::HeadersEntry paramType;
    static void
    Write(
            IPC::MessageWriter* aWriter,
            const paramType& aVar);
    static IPC::ReadResult<paramType>
    Read(IPC::MessageReader* aReader);
};
} // namespace IPC


//-----------------------------------------------------------------------------
// Declaration of the IPDL type |struct CacheRequest|
//
namespace mozilla {
namespace dom {
namespace cache {
class CacheRequest final
{
private:
    typedef ::nsCString nsCString;
    typedef ::mozilla::dom::cache::HeadersEntry HeadersEntry;
    typedef ::mozilla::dom::HeadersGuardEnum HeadersGuardEnum;
    typedef ::mozilla::dom::ReferrerPolicy ReferrerPolicy;
    typedef ::mozilla::dom::RequestMode RequestMode;
    typedef ::mozilla::dom::RequestCredentials RequestCredentials;
    typedef ::mozilla::dom::cache::CacheReadStream CacheReadStream;
    typedef ::int64_t int64_t;
    typedef ::nsContentPolicyType nsContentPolicyType;
    typedef ::mozilla::dom::RequestCache RequestCache;
    typedef ::mozilla::dom::RequestRedirect RequestRedirect;
    typedef ::nsString nsString;
    typedef ::nsILoadInfo::CrossOriginEmbedderPolicy CrossOriginEmbedderPolicy;
    typedef ::mozilla::ipc::PrincipalInfo PrincipalInfo;

public:
#ifdef __clang__
#  pragma clang diagnostic push
#  if __has_warning("-Wdefaulted-function-deleted")
#    pragma clang diagnostic ignored "-Wdefaulted-function-deleted"
#  endif
#endif
    CacheRequest() = default;
#ifdef __clang__
#  pragma clang diagnostic pop
#endif

    MOZ_IMPLICIT CacheRequest(
            const nsCString& _method,
            const nsCString& _urlWithoutQuery,
            const nsCString& _urlQuery,
            const nsCString& _urlFragment,
            const nsTArray<HeadersEntry>& _headers,
            const HeadersGuardEnum& _headersGuard,
            const nsCString& _referrer,
            const ReferrerPolicy& _referrerPolicy,
            const RequestMode& _mode,
            const RequestCredentials& _credentials,
            const mozilla::Maybe<CacheReadStream>& _body,
            const int64_t& _bodyDiskSize,
            const nsContentPolicyType& _contentPolicyType,
            const RequestCache& _requestCache,
            const RequestRedirect& _requestRedirect,
            const nsString& _integrity,
            const CrossOriginEmbedderPolicy& _loadingEmbedderPolicy,
            const mozilla::Maybe<PrincipalInfo>& _principalInfo) :
        method_(_method),
        urlWithoutQuery_(_urlWithoutQuery),
        urlQuery_(_urlQuery),
        urlFragment_(_urlFragment),
        headers_(_headers),
        headersGuard_(_headersGuard),
        referrer_(_referrer),
        referrerPolicy_(_referrerPolicy),
        mode_(_mode),
        credentials_(_credentials),
        body_(_body),
        contentPolicyType_(_contentPolicyType),
        requestCache_(_requestCache),
        requestRedirect_(_requestRedirect),
        integrity_(_integrity),
        loadingEmbedderPolicy_(_loadingEmbedderPolicy),
        principalInfo_(_principalInfo),
        bodyDiskSize_(_bodyDiskSize)
    {
    }

    MOZ_IMPLICIT CacheRequest(
            nsCString&& _method,
            nsCString&& _urlWithoutQuery,
            nsCString&& _urlQuery,
            nsCString&& _urlFragment,
            nsTArray<HeadersEntry>&& _headers,
            HeadersGuardEnum&& _headersGuard,
            nsCString&& _referrer,
            ReferrerPolicy&& _referrerPolicy,
            RequestMode&& _mode,
            RequestCredentials&& _credentials,
            mozilla::Maybe<CacheReadStream>&& _body,
            int64_t&& _bodyDiskSize,
            nsContentPolicyType&& _contentPolicyType,
            RequestCache&& _requestCache,
            RequestRedirect&& _requestRedirect,
            nsString&& _integrity,
            CrossOriginEmbedderPolicy&& _loadingEmbedderPolicy,
            mozilla::Maybe<PrincipalInfo>&& _principalInfo) :
        method_(std::move(_method)),
        urlWithoutQuery_(std::move(_urlWithoutQuery)),
        urlQuery_(std::move(_urlQuery)),
        urlFragment_(std::move(_urlFragment)),
        headers_(std::move(_headers)),
        headersGuard_(std::move(_headersGuard)),
        referrer_(std::move(_referrer)),
        referrerPolicy_(std::move(_referrerPolicy)),
        mode_(std::move(_mode)),
        credentials_(std::move(_credentials)),
        body_(std::move(_body)),
        contentPolicyType_(std::move(_contentPolicyType)),
        requestCache_(std::move(_requestCache)),
        requestRedirect_(std::move(_requestRedirect)),
        integrity_(std::move(_integrity)),
        loadingEmbedderPolicy_(std::move(_loadingEmbedderPolicy)),
        principalInfo_(std::move(_principalInfo)),
        bodyDiskSize_(std::move(_bodyDiskSize))
    {
    }

    nsCString&
    method()
    {
        return method_;
    }
    const nsCString&
    method() const
    {
        return method_;
    }

    nsCString&
    urlWithoutQuery()
    {
        return urlWithoutQuery_;
    }
    const nsCString&
    urlWithoutQuery() const
    {
        return urlWithoutQuery_;
    }

    nsCString&
    urlQuery()
    {
        return urlQuery_;
    }
    const nsCString&
    urlQuery() const
    {
        return urlQuery_;
    }

    nsCString&
    urlFragment()
    {
        return urlFragment_;
    }
    const nsCString&
    urlFragment() const
    {
        return urlFragment_;
    }

    nsTArray<HeadersEntry>&
    headers()
    {
        return headers_;
    }
    const nsTArray<HeadersEntry>&
    headers() const
    {
        return headers_;
    }

    HeadersGuardEnum&
    headersGuard()
    {
        return headersGuard_;
    }
    const HeadersGuardEnum&
    headersGuard() const
    {
        return headersGuard_;
    }

    nsCString&
    referrer()
    {
        return referrer_;
    }
    const nsCString&
    referrer() const
    {
        return referrer_;
    }

    ReferrerPolicy&
    referrerPolicy()
    {
        return referrerPolicy_;
    }
    const ReferrerPolicy&
    referrerPolicy() const
    {
        return referrerPolicy_;
    }

    RequestMode&
    mode()
    {
        return mode_;
    }
    const RequestMode&
    mode() const
    {
        return mode_;
    }

    RequestCredentials&
    credentials()
    {
        return credentials_;
    }
    const RequestCredentials&
    credentials() const
    {
        return credentials_;
    }

    mozilla::Maybe<CacheReadStream>&
    body()
    {
        return body_;
    }
    const mozilla::Maybe<CacheReadStream>&
    body() const
    {
        return body_;
    }

    int64_t&
    bodyDiskSize()
    {
        return bodyDiskSize_;
    }
    const int64_t&
    bodyDiskSize() const
    {
        return bodyDiskSize_;
    }

    nsContentPolicyType&
    contentPolicyType()
    {
        return contentPolicyType_;
    }
    const nsContentPolicyType&
    contentPolicyType() const
    {
        return contentPolicyType_;
    }

    RequestCache&
    requestCache()
    {
        return requestCache_;
    }
    const RequestCache&
    requestCache() const
    {
        return requestCache_;
    }

    RequestRedirect&
    requestRedirect()
    {
        return requestRedirect_;
    }
    const RequestRedirect&
    requestRedirect() const
    {
        return requestRedirect_;
    }

    nsString&
    integrity()
    {
        return integrity_;
    }
    const nsString&
    integrity() const
    {
        return integrity_;
    }

    CrossOriginEmbedderPolicy&
    loadingEmbedderPolicy()
    {
        return loadingEmbedderPolicy_;
    }
    const CrossOriginEmbedderPolicy&
    loadingEmbedderPolicy() const
    {
        return loadingEmbedderPolicy_;
    }

    mozilla::Maybe<PrincipalInfo>&
    principalInfo()
    {
        return principalInfo_;
    }
    const mozilla::Maybe<PrincipalInfo>&
    principalInfo() const
    {
        return principalInfo_;
    }

private:
    ::mozilla::ipc::IPDLStructMember<nsCString> method_;
    ::mozilla::ipc::IPDLStructMember<nsCString> urlWithoutQuery_;
    ::mozilla::ipc::IPDLStructMember<nsCString> urlQuery_;
    ::mozilla::ipc::IPDLStructMember<nsCString> urlFragment_;
    ::mozilla::ipc::IPDLStructMember<CopyableTArray<HeadersEntry>> headers_;
    ::mozilla::ipc::IPDLStructMember<HeadersGuardEnum> headersGuard_;
    ::mozilla::ipc::IPDLStructMember<nsCString> referrer_;
    ::mozilla::ipc::IPDLStructMember<ReferrerPolicy> referrerPolicy_;
    ::mozilla::ipc::IPDLStructMember<RequestMode> mode_;
    ::mozilla::ipc::IPDLStructMember<RequestCredentials> credentials_;
    ::mozilla::ipc::IPDLStructMember<mozilla::Maybe<CacheReadStream>> body_;
    ::mozilla::ipc::IPDLStructMember<nsContentPolicyType> contentPolicyType_;
    ::mozilla::ipc::IPDLStructMember<RequestCache> requestCache_;
    ::mozilla::ipc::IPDLStructMember<RequestRedirect> requestRedirect_;
    ::mozilla::ipc::IPDLStructMember<nsString> integrity_;
    ::mozilla::ipc::IPDLStructMember<CrossOriginEmbedderPolicy> loadingEmbedderPolicy_;
    ::mozilla::ipc::IPDLStructMember<mozilla::Maybe<PrincipalInfo>> principalInfo_;
    ::mozilla::ipc::IPDLStructMember<int64_t> bodyDiskSize_;
};
} // namespace cache
} // namespace dom
} // namespace mozilla

namespace IPC {
template<>
struct ParamTraits <::mozilla::dom::cache::CacheRequest>
{
    typedef ::mozilla::dom::cache::CacheRequest paramType;
    static void
    Write(
            IPC::MessageWriter* aWriter,
            const paramType& aVar);
    static IPC::ReadResult<paramType>
    Read(IPC::MessageReader* aReader);
};
} // namespace IPC


//-----------------------------------------------------------------------------
// Declaration of the IPDL type |struct CacheResponse|
//
namespace mozilla {
namespace dom {
namespace cache {
class CacheResponse final
{
private:
    typedef ::mozilla::dom::ResponseType ResponseType;
    typedef ::nsCString nsCString;
    typedef ::uint32_t uint32_t;
    typedef ::mozilla::dom::cache::HeadersEntry HeadersEntry;
    typedef ::mozilla::dom::HeadersGuardEnum HeadersGuardEnum;
    typedef ::mozilla::dom::cache::CacheReadStream CacheReadStream;
    typedef ::int64_t int64_t;
    typedef ::nsITransportSecurityInfo nsITransportSecurityInfo;
    typedef ::mozilla::ipc::PrincipalInfo PrincipalInfo;
    typedef ::mozilla::dom::RequestCredentials RequestCredentials;

public:
#ifdef __clang__
#  pragma clang diagnostic push
#  if __has_warning("-Wdefaulted-function-deleted")
#    pragma clang diagnostic ignored "-Wdefaulted-function-deleted"
#  endif
#endif
    CacheResponse() = default;
#ifdef __clang__
#  pragma clang diagnostic pop
#endif

    MOZ_IMPLICIT CacheResponse(
            const ResponseType& _type,
            const nsTArray<nsCString>& _urlList,
            const uint32_t& _status,
            const nsCString& _statusText,
            const nsTArray<HeadersEntry>& _headers,
            const HeadersGuardEnum& _headersGuard,
            const mozilla::Maybe<CacheReadStream>& _body,
            const int64_t& _bodyDiskSize,
            nsITransportSecurityInfo* _securityInfo,
            const mozilla::Maybe<PrincipalInfo>& _principalInfo,
            const uint32_t& _paddingInfo,
            const int64_t& _paddingSize,
            const RequestCredentials& _credentials) :
        type_(_type),
        urlList_(_urlList),
        statusText_(_statusText),
        headers_(_headers),
        headersGuard_(_headersGuard),
        body_(_body),
        securityInfo_(_securityInfo),
        principalInfo_(_principalInfo),
        credentials_(_credentials),
        bodyDiskSize_(_bodyDiskSize),
        paddingSize_(_paddingSize),
        status_(_status),
        paddingInfo_(_paddingInfo)
    {
    }

    MOZ_IMPLICIT CacheResponse(
            ResponseType&& _type,
            nsTArray<nsCString>&& _urlList,
            uint32_t&& _status,
            nsCString&& _statusText,
            nsTArray<HeadersEntry>&& _headers,
            HeadersGuardEnum&& _headersGuard,
            mozilla::Maybe<CacheReadStream>&& _body,
            int64_t&& _bodyDiskSize,
            RefPtr<nsITransportSecurityInfo>&& _securityInfo,
            mozilla::Maybe<PrincipalInfo>&& _principalInfo,
            uint32_t&& _paddingInfo,
            int64_t&& _paddingSize,
            RequestCredentials&& _credentials) :
        type_(std::move(_type)),
        urlList_(std::move(_urlList)),
        statusText_(std::move(_statusText)),
        headers_(std::move(_headers)),
        headersGuard_(std::move(_headersGuard)),
        body_(std::move(_body)),
        securityInfo_(std::move(_securityInfo)),
        principalInfo_(std::move(_principalInfo)),
        credentials_(std::move(_credentials)),
        bodyDiskSize_(std::move(_bodyDiskSize)),
        paddingSize_(std::move(_paddingSize)),
        status_(std::move(_status)),
        paddingInfo_(std::move(_paddingInfo))
    {
    }

    ResponseType&
    type()
    {
        return type_;
    }
    const ResponseType&
    type() const
    {
        return type_;
    }

    nsTArray<nsCString>&
    urlList()
    {
        return urlList_;
    }
    const nsTArray<nsCString>&
    urlList() const
    {
        return urlList_;
    }

    uint32_t&
    status()
    {
        return status_;
    }
    const uint32_t&
    status() const
    {
        return status_;
    }

    nsCString&
    statusText()
    {
        return statusText_;
    }
    const nsCString&
    statusText() const
    {
        return statusText_;
    }

    nsTArray<HeadersEntry>&
    headers()
    {
        return headers_;
    }
    const nsTArray<HeadersEntry>&
    headers() const
    {
        return headers_;
    }

    HeadersGuardEnum&
    headersGuard()
    {
        return headersGuard_;
    }
    const HeadersGuardEnum&
    headersGuard() const
    {
        return headersGuard_;
    }

    mozilla::Maybe<CacheReadStream>&
    body()
    {
        return body_;
    }
    const mozilla::Maybe<CacheReadStream>&
    body() const
    {
        return body_;
    }

    int64_t&
    bodyDiskSize()
    {
        return bodyDiskSize_;
    }
    const int64_t&
    bodyDiskSize() const
    {
        return bodyDiskSize_;
    }

    RefPtr<nsITransportSecurityInfo>&
    securityInfo()
    {
        return securityInfo_;
    }
    nsITransportSecurityInfo*
    securityInfo() const
    {
        return securityInfo_;
    }

    mozilla::Maybe<PrincipalInfo>&
    principalInfo()
    {
        return principalInfo_;
    }
    const mozilla::Maybe<PrincipalInfo>&
    principalInfo() const
    {
        return principalInfo_;
    }

    uint32_t&
    paddingInfo()
    {
        return paddingInfo_;
    }
    const uint32_t&
    paddingInfo() const
    {
        return paddingInfo_;
    }

    int64_t&
    paddingSize()
    {
        return paddingSize_;
    }
    const int64_t&
    paddingSize() const
    {
        return paddingSize_;
    }

    RequestCredentials&
    credentials()
    {
        return credentials_;
    }
    const RequestCredentials&
    credentials() const
    {
        return credentials_;
    }

private:
    void
    StaticAssertions() const;
    ::mozilla::ipc::IPDLStructMember<ResponseType> type_;
    ::mozilla::ipc::IPDLStructMember<CopyableTArray<nsCString>> urlList_;
    ::mozilla::ipc::IPDLStructMember<nsCString> statusText_;
    ::mozilla::ipc::IPDLStructMember<CopyableTArray<HeadersEntry>> headers_;
    ::mozilla::ipc::IPDLStructMember<HeadersGuardEnum> headersGuard_;
    ::mozilla::ipc::IPDLStructMember<mozilla::Maybe<CacheReadStream>> body_;
    ::mozilla::ipc::IPDLStructMember<RefPtr<nsITransportSecurityInfo>> securityInfo_;
    ::mozilla::ipc::IPDLStructMember<mozilla::Maybe<PrincipalInfo>> principalInfo_;
    ::mozilla::ipc::IPDLStructMember<RequestCredentials> credentials_;
    ::mozilla::ipc::IPDLStructMember<int64_t> bodyDiskSize_;
    ::mozilla::ipc::IPDLStructMember<int64_t> paddingSize_;
    ::mozilla::ipc::IPDLStructMember<uint32_t> status_;
    ::mozilla::ipc::IPDLStructMember<uint32_t> paddingInfo_;
};
} // namespace cache
} // namespace dom
} // namespace mozilla

namespace IPC {
template<>
struct ParamTraits <::mozilla::dom::cache::CacheResponse>
{
    typedef ::mozilla::dom::cache::CacheResponse paramType;
    static void
    Write(
            IPC::MessageWriter* aWriter,
            const paramType& aVar);
    static IPC::ReadResult<paramType>
    Read(IPC::MessageReader* aReader);
};
} // namespace IPC


//-----------------------------------------------------------------------------
// Declaration of the IPDL type |struct CacheRequestResponse|
//
namespace mozilla {
namespace dom {
namespace cache {
class CacheRequestResponse final
{
private:
    typedef ::mozilla::dom::cache::CacheRequest CacheRequest;
    typedef ::mozilla::dom::cache::CacheResponse CacheResponse;

public:
#ifdef __clang__
#  pragma clang diagnostic push
#  if __has_warning("-Wdefaulted-function-deleted")
#    pragma clang diagnostic ignored "-Wdefaulted-function-deleted"
#  endif
#endif
    CacheRequestResponse() = default;
#ifdef __clang__
#  pragma clang diagnostic pop
#endif

    MOZ_IMPLICIT CacheRequestResponse(
            const CacheRequest& _request,
            const CacheResponse& _response) :
        request_(_request),
        response_(_response)
    {
    }

    MOZ_IMPLICIT CacheRequestResponse(
            CacheRequest&& _request,
            CacheResponse&& _response) :
        request_(std::move(_request)),
        response_(std::move(_response))
    {
    }

    CacheRequest&
    request()
    {
        return request_;
    }
    const CacheRequest&
    request() const
    {
        return request_;
    }

    CacheResponse&
    response()
    {
        return response_;
    }
    const CacheResponse&
    response() const
    {
        return response_;
    }

private:
    ::mozilla::ipc::IPDLStructMember<CacheRequest> request_;
    ::mozilla::ipc::IPDLStructMember<CacheResponse> response_;
};
} // namespace cache
} // namespace dom
} // namespace mozilla

namespace IPC {
template<>
struct ParamTraits <::mozilla::dom::cache::CacheRequestResponse>
{
    typedef ::mozilla::dom::cache::CacheRequestResponse paramType;
    static void
    Write(
            IPC::MessageWriter* aWriter,
            const paramType& aVar);
    static IPC::ReadResult<paramType>
    Read(IPC::MessageReader* aReader);
};
} // namespace IPC


//-----------------------------------------------------------------------------
// Declaration of the IPDL type |struct CacheMatchArgs|
//
namespace mozilla {
namespace dom {
namespace cache {
class CacheMatchArgs final
{
private:
    typedef ::mozilla::dom::cache::CacheRequest CacheRequest;
    typedef ::mozilla::dom::cache::CacheQueryParams CacheQueryParams;
    typedef ::mozilla::dom::cache::OpenMode OpenMode;

public:
#ifdef __clang__
#  pragma clang diagnostic push
#  if __has_warning("-Wdefaulted-function-deleted")
#    pragma clang diagnostic ignored "-Wdefaulted-function-deleted"
#  endif
#endif
    CacheMatchArgs() = default;
#ifdef __clang__
#  pragma clang diagnostic pop
#endif

    MOZ_IMPLICIT CacheMatchArgs(
            const CacheRequest& _request,
            const CacheQueryParams& _params,
            const OpenMode& _openMode) :
        request_(_request),
        params_(_params),
        openMode_(_openMode)
    {
    }

    MOZ_IMPLICIT CacheMatchArgs(
            CacheRequest&& _request,
            CacheQueryParams&& _params,
            OpenMode&& _openMode) :
        request_(std::move(_request)),
        params_(std::move(_params)),
        openMode_(std::move(_openMode))
    {
    }

    CacheRequest&
    request()
    {
        return request_;
    }
    const CacheRequest&
    request() const
    {
        return request_;
    }

    CacheQueryParams&
    params()
    {
        return params_;
    }
    const CacheQueryParams&
    params() const
    {
        return params_;
    }

    OpenMode&
    openMode()
    {
        return openMode_;
    }
    const OpenMode&
    openMode() const
    {
        return openMode_;
    }

private:
    ::mozilla::ipc::IPDLStructMember<CacheRequest> request_;
    ::mozilla::ipc::IPDLStructMember<CacheQueryParams> params_;
    ::mozilla::ipc::IPDLStructMember<OpenMode> openMode_;
};
} // namespace cache
} // namespace dom
} // namespace mozilla

namespace IPC {
template<>
struct ParamTraits <::mozilla::dom::cache::CacheMatchArgs>
{
    typedef ::mozilla::dom::cache::CacheMatchArgs paramType;
    static void
    Write(
            IPC::MessageWriter* aWriter,
            const paramType& aVar);
    static IPC::ReadResult<paramType>
    Read(IPC::MessageReader* aReader);
};
} // namespace IPC


//-----------------------------------------------------------------------------
// Declaration of the IPDL type |struct CacheMatchAllArgs|
//
namespace mozilla {
namespace dom {
namespace cache {
class CacheMatchAllArgs final
{
private:
    typedef ::mozilla::dom::cache::CacheRequest CacheRequest;
    typedef ::mozilla::dom::cache::CacheQueryParams CacheQueryParams;
    typedef ::mozilla::dom::cache::OpenMode OpenMode;

public:
#ifdef __clang__
#  pragma clang diagnostic push
#  if __has_warning("-Wdefaulted-function-deleted")
#    pragma clang diagnostic ignored "-Wdefaulted-function-deleted"
#  endif
#endif
    CacheMatchAllArgs() = default;
#ifdef __clang__
#  pragma clang diagnostic pop
#endif

    MOZ_IMPLICIT CacheMatchAllArgs(
            const mozilla::Maybe<CacheRequest>& _maybeRequest,
            const CacheQueryParams& _params,
            const OpenMode& _openMode) :
        maybeRequest_(_maybeRequest),
        params_(_params),
        openMode_(_openMode)
    {
    }

    MOZ_IMPLICIT CacheMatchAllArgs(
            mozilla::Maybe<CacheRequest>&& _maybeRequest,
            CacheQueryParams&& _params,
            OpenMode&& _openMode) :
        maybeRequest_(std::move(_maybeRequest)),
        params_(std::move(_params)),
        openMode_(std::move(_openMode))
    {
    }

    mozilla::Maybe<CacheRequest>&
    maybeRequest()
    {
        return maybeRequest_;
    }
    const mozilla::Maybe<CacheRequest>&
    maybeRequest() const
    {
        return maybeRequest_;
    }

    CacheQueryParams&
    params()
    {
        return params_;
    }
    const CacheQueryParams&
    params() const
    {
        return params_;
    }

    OpenMode&
    openMode()
    {
        return openMode_;
    }
    const OpenMode&
    openMode() const
    {
        return openMode_;
    }

private:
    ::mozilla::ipc::IPDLStructMember<mozilla::Maybe<CacheRequest>> maybeRequest_;
    ::mozilla::ipc::IPDLStructMember<CacheQueryParams> params_;
    ::mozilla::ipc::IPDLStructMember<OpenMode> openMode_;
};
} // namespace cache
} // namespace dom
} // namespace mozilla

namespace IPC {
template<>
struct ParamTraits <::mozilla::dom::cache::CacheMatchAllArgs>
{
    typedef ::mozilla::dom::cache::CacheMatchAllArgs paramType;
    static void
    Write(
            IPC::MessageWriter* aWriter,
            const paramType& aVar);
    static IPC::ReadResult<paramType>
    Read(IPC::MessageReader* aReader);
};
} // namespace IPC


//-----------------------------------------------------------------------------
// Declaration of the IPDL type |struct CachePutAllArgs|
//
namespace mozilla {
namespace dom {
namespace cache {
class CachePutAllArgs final
{
private:
    typedef ::mozilla::dom::cache::CacheRequestResponse CacheRequestResponse;

public:
#ifdef __clang__
#  pragma clang diagnostic push
#  if __has_warning("-Wdefaulted-function-deleted")
#    pragma clang diagnostic ignored "-Wdefaulted-function-deleted"
#  endif
#endif
    CachePutAllArgs() = default;
#ifdef __clang__
#  pragma clang diagnostic pop
#endif

    MOZ_IMPLICIT CachePutAllArgs(const nsTArray<CacheRequestResponse>& _requestResponseList) :
        requestResponseList_(_requestResponseList)
    {
    }

    MOZ_IMPLICIT CachePutAllArgs(nsTArray<CacheRequestResponse>&& _requestResponseList) :
        requestResponseList_(std::move(_requestResponseList))
    {
    }

    nsTArray<CacheRequestResponse>&
    requestResponseList()
    {
        return requestResponseList_;
    }
    const nsTArray<CacheRequestResponse>&
    requestResponseList() const
    {
        return requestResponseList_;
    }

private:
    ::mozilla::ipc::IPDLStructMember<CopyableTArray<CacheRequestResponse>> requestResponseList_;
};
} // namespace cache
} // namespace dom
} // namespace mozilla

namespace IPC {
template<>
struct ParamTraits <::mozilla::dom::cache::CachePutAllArgs>
{
    typedef ::mozilla::dom::cache::CachePutAllArgs paramType;
    static void
    Write(
            IPC::MessageWriter* aWriter,
            const paramType& aVar);
    static IPC::ReadResult<paramType>
    Read(IPC::MessageReader* aReader);
};
} // namespace IPC


//-----------------------------------------------------------------------------
// Declaration of the IPDL type |struct CacheDeleteArgs|
//
namespace mozilla {
namespace dom {
namespace cache {
class CacheDeleteArgs final
{
private:
    typedef ::mozilla::dom::cache::CacheRequest CacheRequest;
    typedef ::mozilla::dom::cache::CacheQueryParams CacheQueryParams;

public:
#ifdef __clang__
#  pragma clang diagnostic push
#  if __has_warning("-Wdefaulted-function-deleted")
#    pragma clang diagnostic ignored "-Wdefaulted-function-deleted"
#  endif
#endif
    CacheDeleteArgs() = default;
#ifdef __clang__
#  pragma clang diagnostic pop
#endif

    MOZ_IMPLICIT CacheDeleteArgs(
            const CacheRequest& _request,
            const CacheQueryParams& _params) :
        request_(_request),
        params_(_params)
    {
    }

    MOZ_IMPLICIT CacheDeleteArgs(
            CacheRequest&& _request,
            CacheQueryParams&& _params) :
        request_(std::move(_request)),
        params_(std::move(_params))
    {
    }

    CacheRequest&
    request()
    {
        return request_;
    }
    const CacheRequest&
    request() const
    {
        return request_;
    }

    CacheQueryParams&
    params()
    {
        return params_;
    }
    const CacheQueryParams&
    params() const
    {
        return params_;
    }

private:
    ::mozilla::ipc::IPDLStructMember<CacheRequest> request_;
    ::mozilla::ipc::IPDLStructMember<CacheQueryParams> params_;
};
} // namespace cache
} // namespace dom
} // namespace mozilla

namespace IPC {
template<>
struct ParamTraits <::mozilla::dom::cache::CacheDeleteArgs>
{
    typedef ::mozilla::dom::cache::CacheDeleteArgs paramType;
    static void
    Write(
            IPC::MessageWriter* aWriter,
            const paramType& aVar);
    static IPC::ReadResult<paramType>
    Read(IPC::MessageReader* aReader);
};
} // namespace IPC


//-----------------------------------------------------------------------------
// Declaration of the IPDL type |struct CacheKeysArgs|
//
namespace mozilla {
namespace dom {
namespace cache {
class CacheKeysArgs final
{
private:
    typedef ::mozilla::dom::cache::CacheRequest CacheRequest;
    typedef ::mozilla::dom::cache::CacheQueryParams CacheQueryParams;
    typedef ::mozilla::dom::cache::OpenMode OpenMode;

public:
#ifdef __clang__
#  pragma clang diagnostic push
#  if __has_warning("-Wdefaulted-function-deleted")
#    pragma clang diagnostic ignored "-Wdefaulted-function-deleted"
#  endif
#endif
    CacheKeysArgs() = default;
#ifdef __clang__
#  pragma clang diagnostic pop
#endif

    MOZ_IMPLICIT CacheKeysArgs(
            const mozilla::Maybe<CacheRequest>& _maybeRequest,
            const CacheQueryParams& _params,
            const OpenMode& _openMode) :
        maybeRequest_(_maybeRequest),
        params_(_params),
        openMode_(_openMode)
    {
    }

    MOZ_IMPLICIT CacheKeysArgs(
            mozilla::Maybe<CacheRequest>&& _maybeRequest,
            CacheQueryParams&& _params,
            OpenMode&& _openMode) :
        maybeRequest_(std::move(_maybeRequest)),
        params_(std::move(_params)),
        openMode_(std::move(_openMode))
    {
    }

    mozilla::Maybe<CacheRequest>&
    maybeRequest()
    {
        return maybeRequest_;
    }
    const mozilla::Maybe<CacheRequest>&
    maybeRequest() const
    {
        return maybeRequest_;
    }

    CacheQueryParams&
    params()
    {
        return params_;
    }
    const CacheQueryParams&
    params() const
    {
        return params_;
    }

    OpenMode&
    openMode()
    {
        return openMode_;
    }
    const OpenMode&
    openMode() const
    {
        return openMode_;
    }

private:
    ::mozilla::ipc::IPDLStructMember<mozilla::Maybe<CacheRequest>> maybeRequest_;
    ::mozilla::ipc::IPDLStructMember<CacheQueryParams> params_;
    ::mozilla::ipc::IPDLStructMember<OpenMode> openMode_;
};
} // namespace cache
} // namespace dom
} // namespace mozilla

namespace IPC {
template<>
struct ParamTraits <::mozilla::dom::cache::CacheKeysArgs>
{
    typedef ::mozilla::dom::cache::CacheKeysArgs paramType;
    static void
    Write(
            IPC::MessageWriter* aWriter,
            const paramType& aVar);
    static IPC::ReadResult<paramType>
    Read(IPC::MessageReader* aReader);
};
} // namespace IPC


//-----------------------------------------------------------------------------
// Declaration of the IPDL type |struct StorageMatchArgs|
//
namespace mozilla {
namespace dom {
namespace cache {
class StorageMatchArgs final
{
private:
    typedef ::mozilla::dom::cache::CacheRequest CacheRequest;
    typedef ::mozilla::dom::cache::CacheQueryParams CacheQueryParams;
    typedef ::mozilla::dom::cache::OpenMode OpenMode;

public:
#ifdef __clang__
#  pragma clang diagnostic push
#  if __has_warning("-Wdefaulted-function-deleted")
#    pragma clang diagnostic ignored "-Wdefaulted-function-deleted"
#  endif
#endif
    StorageMatchArgs() = default;
#ifdef __clang__
#  pragma clang diagnostic pop
#endif

    MOZ_IMPLICIT StorageMatchArgs(
            const CacheRequest& _request,
            const CacheQueryParams& _params,
            const OpenMode& _openMode) :
        request_(_request),
        params_(_params),
        openMode_(_openMode)
    {
    }

    MOZ_IMPLICIT StorageMatchArgs(
            CacheRequest&& _request,
            CacheQueryParams&& _params,
            OpenMode&& _openMode) :
        request_(std::move(_request)),
        params_(std::move(_params)),
        openMode_(std::move(_openMode))
    {
    }

    CacheRequest&
    request()
    {
        return request_;
    }
    const CacheRequest&
    request() const
    {
        return request_;
    }

    CacheQueryParams&
    params()
    {
        return params_;
    }
    const CacheQueryParams&
    params() const
    {
        return params_;
    }

    OpenMode&
    openMode()
    {
        return openMode_;
    }
    const OpenMode&
    openMode() const
    {
        return openMode_;
    }

private:
    ::mozilla::ipc::IPDLStructMember<CacheRequest> request_;
    ::mozilla::ipc::IPDLStructMember<CacheQueryParams> params_;
    ::mozilla::ipc::IPDLStructMember<OpenMode> openMode_;
};
} // namespace cache
} // namespace dom
} // namespace mozilla

namespace IPC {
template<>
struct ParamTraits <::mozilla::dom::cache::StorageMatchArgs>
{
    typedef ::mozilla::dom::cache::StorageMatchArgs paramType;
    static void
    Write(
            IPC::MessageWriter* aWriter,
            const paramType& aVar);
    static IPC::ReadResult<paramType>
    Read(IPC::MessageReader* aReader);
};
} // namespace IPC


//-----------------------------------------------------------------------------
// Declaration of the IPDL type |struct StorageHasArgs|
//
namespace mozilla {
namespace dom {
namespace cache {
class StorageHasArgs final
{
private:
    typedef ::nsString nsString;

public:
#ifdef __clang__
#  pragma clang diagnostic push
#  if __has_warning("-Wdefaulted-function-deleted")
#    pragma clang diagnostic ignored "-Wdefaulted-function-deleted"
#  endif
#endif
    StorageHasArgs() = default;
#ifdef __clang__
#  pragma clang diagnostic pop
#endif

    MOZ_IMPLICIT StorageHasArgs(const nsString& _key) :
        key_(_key)
    {
    }

    MOZ_IMPLICIT StorageHasArgs(nsString&& _key) :
        key_(std::move(_key))
    {
    }

    nsString&
    key()
    {
        return key_;
    }
    const nsString&
    key() const
    {
        return key_;
    }

private:
    ::mozilla::ipc::IPDLStructMember<nsString> key_;
};
} // namespace cache
} // namespace dom
} // namespace mozilla

namespace IPC {
template<>
struct ParamTraits <::mozilla::dom::cache::StorageHasArgs>
{
    typedef ::mozilla::dom::cache::StorageHasArgs paramType;
    static void
    Write(
            IPC::MessageWriter* aWriter,
            const paramType& aVar);
    static IPC::ReadResult<paramType>
    Read(IPC::MessageReader* aReader);
};
} // namespace IPC


//-----------------------------------------------------------------------------
// Declaration of the IPDL type |struct StorageOpenArgs|
//
namespace mozilla {
namespace dom {
namespace cache {
class StorageOpenArgs final
{
private:
    typedef ::nsString nsString;

public:
#ifdef __clang__
#  pragma clang diagnostic push
#  if __has_warning("-Wdefaulted-function-deleted")
#    pragma clang diagnostic ignored "-Wdefaulted-function-deleted"
#  endif
#endif
    StorageOpenArgs() = default;
#ifdef __clang__
#  pragma clang diagnostic pop
#endif

    MOZ_IMPLICIT StorageOpenArgs(const nsString& _key) :
        key_(_key)
    {
    }

    MOZ_IMPLICIT StorageOpenArgs(nsString&& _key) :
        key_(std::move(_key))
    {
    }

    nsString&
    key()
    {
        return key_;
    }
    const nsString&
    key() const
    {
        return key_;
    }

private:
    ::mozilla::ipc::IPDLStructMember<nsString> key_;
};
} // namespace cache
} // namespace dom
} // namespace mozilla

namespace IPC {
template<>
struct ParamTraits <::mozilla::dom::cache::StorageOpenArgs>
{
    typedef ::mozilla::dom::cache::StorageOpenArgs paramType;
    static void
    Write(
            IPC::MessageWriter* aWriter,
            const paramType& aVar);
    static IPC::ReadResult<paramType>
    Read(IPC::MessageReader* aReader);
};
} // namespace IPC


//-----------------------------------------------------------------------------
// Declaration of the IPDL type |struct StorageDeleteArgs|
//
namespace mozilla {
namespace dom {
namespace cache {
class StorageDeleteArgs final
{
private:
    typedef ::nsString nsString;

public:
#ifdef __clang__
#  pragma clang diagnostic push
#  if __has_warning("-Wdefaulted-function-deleted")
#    pragma clang diagnostic ignored "-Wdefaulted-function-deleted"
#  endif
#endif
    StorageDeleteArgs() = default;
#ifdef __clang__
#  pragma clang diagnostic pop
#endif

    MOZ_IMPLICIT StorageDeleteArgs(const nsString& _key) :
        key_(_key)
    {
    }

    MOZ_IMPLICIT StorageDeleteArgs(nsString&& _key) :
        key_(std::move(_key))
    {
    }

    nsString&
    key()
    {
        return key_;
    }
    const nsString&
    key() const
    {
        return key_;
    }

private:
    ::mozilla::ipc::IPDLStructMember<nsString> key_;
};
} // namespace cache
} // namespace dom
} // namespace mozilla

namespace IPC {
template<>
struct ParamTraits <::mozilla::dom::cache::StorageDeleteArgs>
{
    typedef ::mozilla::dom::cache::StorageDeleteArgs paramType;
    static void
    Write(
            IPC::MessageWriter* aWriter,
            const paramType& aVar);
    static IPC::ReadResult<paramType>
    Read(IPC::MessageReader* aReader);
};
} // namespace IPC


//-----------------------------------------------------------------------------
// Declaration of the IPDL type |struct StorageKeysArgs|
//
namespace mozilla {
namespace dom {
namespace cache {
class StorageKeysArgs final
{
private:

public:
#ifdef __clang__
#  pragma clang diagnostic push
#  if __has_warning("-Wdefaulted-function-deleted")
#    pragma clang diagnostic ignored "-Wdefaulted-function-deleted"
#  endif
#endif
    StorageKeysArgs() = default;
#ifdef __clang__
#  pragma clang diagnostic pop
#endif

private:
};
} // namespace cache
} // namespace dom
} // namespace mozilla

namespace IPC {
template<>
struct ParamTraits <::mozilla::dom::cache::StorageKeysArgs>
{
    typedef ::mozilla::dom::cache::StorageKeysArgs paramType;
    static void
    Write(
            IPC::MessageWriter* aWriter,
            const paramType& aVar);
    static IPC::ReadResult<paramType>
    Read(IPC::MessageReader* aReader);
};
} // namespace IPC


//-----------------------------------------------------------------------------
// Declaration of the IPDL type |union CacheOpArgs|
//
namespace mozilla {
namespace dom {
namespace cache {
class CacheOpArgs final
{
public:
    enum Type {
        T__None,
        TCacheMatchArgs = 1,
        TCacheMatchAllArgs,
        TCachePutAllArgs,
        TCacheDeleteArgs,
        TCacheKeysArgs,
        TStorageMatchArgs,
        TStorageHasArgs,
        TStorageOpenArgs,
        TStorageDeleteArgs,
        TStorageKeysArgs,
        T__Last = TStorageKeysArgs
    };

private:
    typedef ::mozilla::dom::cache::CacheMatchArgs CacheMatchArgs;
    typedef ::mozilla::dom::cache::CacheMatchAllArgs CacheMatchAllArgs;
    typedef ::mozilla::dom::cache::CachePutAllArgs CachePutAllArgs;
    typedef ::mozilla::dom::cache::CacheDeleteArgs CacheDeleteArgs;
    typedef ::mozilla::dom::cache::CacheKeysArgs CacheKeysArgs;
    typedef ::mozilla::dom::cache::StorageMatchArgs StorageMatchArgs;
    typedef ::mozilla::dom::cache::StorageHasArgs StorageHasArgs;
    typedef ::mozilla::dom::cache::StorageOpenArgs StorageOpenArgs;
    typedef ::mozilla::dom::cache::StorageDeleteArgs StorageDeleteArgs;
    typedef ::mozilla::dom::cache::StorageKeysArgs StorageKeysArgs;
    typedef CacheMatchArgs CacheMatchArgs__tdef;
    typedef CacheMatchAllArgs CacheMatchAllArgs__tdef;
    typedef CachePutAllArgs CachePutAllArgs__tdef;
    typedef CacheDeleteArgs CacheDeleteArgs__tdef;
    typedef CacheKeysArgs CacheKeysArgs__tdef;
    typedef StorageMatchArgs StorageMatchArgs__tdef;
    typedef StorageHasArgs StorageHasArgs__tdef;
    typedef StorageOpenArgs StorageOpenArgs__tdef;
    typedef StorageDeleteArgs StorageDeleteArgs__tdef;
    typedef StorageKeysArgs StorageKeysArgs__tdef;

    CacheMatchArgs*
    ptr_CacheMatchArgs()
    {
        return (&(mVCacheMatchArgs));
    }
    const CacheMatchArgs*
    constptr_CacheMatchArgs() const
    {
        return (&(mVCacheMatchArgs));
    }
    CacheMatchAllArgs*
    ptr_CacheMatchAllArgs()
    {
        return (&(mVCacheMatchAllArgs));
    }
    const CacheMatchAllArgs*
    constptr_CacheMatchAllArgs() const
    {
        return (&(mVCacheMatchAllArgs));
    }
    CachePutAllArgs*
    ptr_CachePutAllArgs()
    {
        return (&(mVCachePutAllArgs));
    }
    const CachePutAllArgs*
    constptr_CachePutAllArgs() const
    {
        return (&(mVCachePutAllArgs));
    }
    CacheDeleteArgs*
    ptr_CacheDeleteArgs()
    {
        return (&(mVCacheDeleteArgs));
    }
    const CacheDeleteArgs*
    constptr_CacheDeleteArgs() const
    {
        return (&(mVCacheDeleteArgs));
    }
    CacheKeysArgs*
    ptr_CacheKeysArgs()
    {
        return (&(mVCacheKeysArgs));
    }
    const CacheKeysArgs*
    constptr_CacheKeysArgs() const
    {
        return (&(mVCacheKeysArgs));
    }
    StorageMatchArgs*
    ptr_StorageMatchArgs()
    {
        return (&(mVStorageMatchArgs));
    }
    const StorageMatchArgs*
    constptr_StorageMatchArgs() const
    {
        return (&(mVStorageMatchArgs));
    }
    StorageHasArgs*
    ptr_StorageHasArgs()
    {
        return (&(mVStorageHasArgs));
    }
    const StorageHasArgs*
    constptr_StorageHasArgs() const
    {
        return (&(mVStorageHasArgs));
    }
    StorageOpenArgs*
    ptr_StorageOpenArgs()
    {
        return (&(mVStorageOpenArgs));
    }
    const StorageOpenArgs*
    constptr_StorageOpenArgs() const
    {
        return (&(mVStorageOpenArgs));
    }
    StorageDeleteArgs*
    ptr_StorageDeleteArgs()
    {
        return (&(mVStorageDeleteArgs));
    }
    const StorageDeleteArgs*
    constptr_StorageDeleteArgs() const
    {
        return (&(mVStorageDeleteArgs));
    }
    StorageKeysArgs*
    ptr_StorageKeysArgs()
    {
        return (&(mVStorageKeysArgs));
    }
    const StorageKeysArgs*
    constptr_StorageKeysArgs() const
    {
        return (&(mVStorageKeysArgs));
    }

    void
    MaybeDestroy();

    void
    AssertSanity() const
    {
        MOZ_RELEASE_ASSERT((T__None) <= (mType), "invalid type tag");
        MOZ_RELEASE_ASSERT((mType) <= (T__Last), "invalid type tag");
    }
    void
    AssertSanity(Type aType) const
    {
        AssertSanity();
        MOZ_RELEASE_ASSERT((mType) == (aType), "unexpected type tag");
    }

public:
    MOZ_IMPLICIT CacheOpArgs() :
        mType(T__None)
    {
    }

    MOZ_IMPLICIT CacheOpArgs(const CacheMatchArgs& aOther);

    MOZ_IMPLICIT CacheOpArgs(CacheMatchArgs&& aOther);

    MOZ_IMPLICIT CacheOpArgs(const CacheMatchAllArgs& aOther);

    MOZ_IMPLICIT CacheOpArgs(CacheMatchAllArgs&& aOther);

    MOZ_IMPLICIT CacheOpArgs(const CachePutAllArgs& aOther);

    MOZ_IMPLICIT CacheOpArgs(CachePutAllArgs&& aOther);

    MOZ_IMPLICIT CacheOpArgs(const CacheDeleteArgs& aOther);

    MOZ_IMPLICIT CacheOpArgs(CacheDeleteArgs&& aOther);

    MOZ_IMPLICIT CacheOpArgs(const CacheKeysArgs& aOther);

    MOZ_IMPLICIT CacheOpArgs(CacheKeysArgs&& aOther);

    MOZ_IMPLICIT CacheOpArgs(const StorageMatchArgs& aOther);

    MOZ_IMPLICIT CacheOpArgs(StorageMatchArgs&& aOther);

    MOZ_IMPLICIT CacheOpArgs(const StorageHasArgs& aOther);

    MOZ_IMPLICIT CacheOpArgs(StorageHasArgs&& aOther);

    MOZ_IMPLICIT CacheOpArgs(const StorageOpenArgs& aOther);

    MOZ_IMPLICIT CacheOpArgs(StorageOpenArgs&& aOther);

    MOZ_IMPLICIT CacheOpArgs(const StorageDeleteArgs& aOther);

    MOZ_IMPLICIT CacheOpArgs(StorageDeleteArgs&& aOther);

    MOZ_IMPLICIT CacheOpArgs(const StorageKeysArgs& aOther);

    MOZ_IMPLICIT CacheOpArgs(StorageKeysArgs&& aOther);

    MOZ_IMPLICIT CacheOpArgs(const CacheOpArgs& aOther);

    MOZ_IMPLICIT CacheOpArgs(CacheOpArgs&& aOther);

    ~CacheOpArgs();

    Type
    type() const
    {
        return mType;
    }

    CacheOpArgs&
    operator=(const CacheMatchArgs& aRhs);

    CacheOpArgs&
    operator=(CacheMatchArgs&& aRhs);

    CacheOpArgs&
    operator=(const CacheMatchAllArgs& aRhs);

    CacheOpArgs&
    operator=(CacheMatchAllArgs&& aRhs);

    CacheOpArgs&
    operator=(const CachePutAllArgs& aRhs);

    CacheOpArgs&
    operator=(CachePutAllArgs&& aRhs);

    CacheOpArgs&
    operator=(const CacheDeleteArgs& aRhs);

    CacheOpArgs&
    operator=(CacheDeleteArgs&& aRhs);

    CacheOpArgs&
    operator=(const CacheKeysArgs& aRhs);

    CacheOpArgs&
    operator=(CacheKeysArgs&& aRhs);

    CacheOpArgs&
    operator=(const StorageMatchArgs& aRhs);

    CacheOpArgs&
    operator=(StorageMatchArgs&& aRhs);

    CacheOpArgs&
    operator=(const StorageHasArgs& aRhs);

    CacheOpArgs&
    operator=(StorageHasArgs&& aRhs);

    CacheOpArgs&
    operator=(const StorageOpenArgs& aRhs);

    CacheOpArgs&
    operator=(StorageOpenArgs&& aRhs);

    CacheOpArgs&
    operator=(const StorageDeleteArgs& aRhs);

    CacheOpArgs&
    operator=(StorageDeleteArgs&& aRhs);

    CacheOpArgs&
    operator=(const StorageKeysArgs& aRhs);

    CacheOpArgs&
    operator=(StorageKeysArgs&& aRhs);

    CacheOpArgs&
    operator=(const CacheOpArgs& aRhs);

    CacheOpArgs&
    operator=(CacheOpArgs&& aRhs);

    CacheMatchArgs&
    get_CacheMatchArgs()
    {
        AssertSanity(TCacheMatchArgs);
        return (*(ptr_CacheMatchArgs()));
    }
    const CacheMatchArgs&
    get_CacheMatchArgs() const
    {
        AssertSanity(TCacheMatchArgs);
        return (*(constptr_CacheMatchArgs()));
    }
    operator CacheMatchArgs&()
    {
        return get_CacheMatchArgs();
    }
    operator const CacheMatchArgs&() const
    {
        return get_CacheMatchArgs();
    }

    CacheMatchAllArgs&
    get_CacheMatchAllArgs()
    {
        AssertSanity(TCacheMatchAllArgs);
        return (*(ptr_CacheMatchAllArgs()));
    }
    const CacheMatchAllArgs&
    get_CacheMatchAllArgs() const
    {
        AssertSanity(TCacheMatchAllArgs);
        return (*(constptr_CacheMatchAllArgs()));
    }
    operator CacheMatchAllArgs&()
    {
        return get_CacheMatchAllArgs();
    }
    operator const CacheMatchAllArgs&() const
    {
        return get_CacheMatchAllArgs();
    }

    CachePutAllArgs&
    get_CachePutAllArgs()
    {
        AssertSanity(TCachePutAllArgs);
        return (*(ptr_CachePutAllArgs()));
    }
    const CachePutAllArgs&
    get_CachePutAllArgs() const
    {
        AssertSanity(TCachePutAllArgs);
        return (*(constptr_CachePutAllArgs()));
    }
    operator CachePutAllArgs&()
    {
        return get_CachePutAllArgs();
    }
    operator const CachePutAllArgs&() const
    {
        return get_CachePutAllArgs();
    }

    CacheDeleteArgs&
    get_CacheDeleteArgs()
    {
        AssertSanity(TCacheDeleteArgs);
        return (*(ptr_CacheDeleteArgs()));
    }
    const CacheDeleteArgs&
    get_CacheDeleteArgs() const
    {
        AssertSanity(TCacheDeleteArgs);
        return (*(constptr_CacheDeleteArgs()));
    }
    operator CacheDeleteArgs&()
    {
        return get_CacheDeleteArgs();
    }
    operator const CacheDeleteArgs&() const
    {
        return get_CacheDeleteArgs();
    }

    CacheKeysArgs&
    get_CacheKeysArgs()
    {
        AssertSanity(TCacheKeysArgs);
        return (*(ptr_CacheKeysArgs()));
    }
    const CacheKeysArgs&
    get_CacheKeysArgs() const
    {
        AssertSanity(TCacheKeysArgs);
        return (*(constptr_CacheKeysArgs()));
    }
    operator CacheKeysArgs&()
    {
        return get_CacheKeysArgs();
    }
    operator const CacheKeysArgs&() const
    {
        return get_CacheKeysArgs();
    }

    StorageMatchArgs&
    get_StorageMatchArgs()
    {
        AssertSanity(TStorageMatchArgs);
        return (*(ptr_StorageMatchArgs()));
    }
    const StorageMatchArgs&
    get_StorageMatchArgs() const
    {
        AssertSanity(TStorageMatchArgs);
        return (*(constptr_StorageMatchArgs()));
    }
    operator StorageMatchArgs&()
    {
        return get_StorageMatchArgs();
    }
    operator const StorageMatchArgs&() const
    {
        return get_StorageMatchArgs();
    }

    StorageHasArgs&
    get_StorageHasArgs()
    {
        AssertSanity(TStorageHasArgs);
        return (*(ptr_StorageHasArgs()));
    }
    const StorageHasArgs&
    get_StorageHasArgs() const
    {
        AssertSanity(TStorageHasArgs);
        return (*(constptr_StorageHasArgs()));
    }
    operator StorageHasArgs&()
    {
        return get_StorageHasArgs();
    }
    operator const StorageHasArgs&() const
    {
        return get_StorageHasArgs();
    }

    StorageOpenArgs&
    get_StorageOpenArgs()
    {
        AssertSanity(TStorageOpenArgs);
        return (*(ptr_StorageOpenArgs()));
    }
    const StorageOpenArgs&
    get_StorageOpenArgs() const
    {
        AssertSanity(TStorageOpenArgs);
        return (*(constptr_StorageOpenArgs()));
    }
    operator StorageOpenArgs&()
    {
        return get_StorageOpenArgs();
    }
    operator const StorageOpenArgs&() const
    {
        return get_StorageOpenArgs();
    }

    StorageDeleteArgs&
    get_StorageDeleteArgs()
    {
        AssertSanity(TStorageDeleteArgs);
        return (*(ptr_StorageDeleteArgs()));
    }
    const StorageDeleteArgs&
    get_StorageDeleteArgs() const
    {
        AssertSanity(TStorageDeleteArgs);
        return (*(constptr_StorageDeleteArgs()));
    }
    operator StorageDeleteArgs&()
    {
        return get_StorageDeleteArgs();
    }
    operator const StorageDeleteArgs&() const
    {
        return get_StorageDeleteArgs();
    }

    StorageKeysArgs&
    get_StorageKeysArgs()
    {
        AssertSanity(TStorageKeysArgs);
        return (*(ptr_StorageKeysArgs()));
    }
    const StorageKeysArgs&
    get_StorageKeysArgs() const
    {
        AssertSanity(TStorageKeysArgs);
        return (*(constptr_StorageKeysArgs()));
    }
    operator StorageKeysArgs&()
    {
        return get_StorageKeysArgs();
    }
    operator const StorageKeysArgs&() const
    {
        return get_StorageKeysArgs();
    }

private:
    union {
        CacheMatchArgs mVCacheMatchArgs;
        CacheMatchAllArgs mVCacheMatchAllArgs;
        CachePutAllArgs mVCachePutAllArgs;
        CacheDeleteArgs mVCacheDeleteArgs;
        CacheKeysArgs mVCacheKeysArgs;
        StorageMatchArgs mVStorageMatchArgs;
        StorageHasArgs mVStorageHasArgs;
        StorageOpenArgs mVStorageOpenArgs;
        StorageDeleteArgs mVStorageDeleteArgs;
        StorageKeysArgs mVStorageKeysArgs;
    };
    Type mType;
};
} // namespace cache
} // namespace dom
} // namespace mozilla

namespace IPC {
template<>
struct ParamTraits <::mozilla::dom::cache::CacheOpArgs>
{
    typedef ::mozilla::dom::cache::CacheOpArgs paramType;
    static void
    Write(
            IPC::MessageWriter* aWriter,
            const paramType& aVar);
    static IPC::ReadResult<paramType>
    Read(IPC::MessageReader* aReader);
};
} // namespace IPC


//-----------------------------------------------------------------------------
// Declaration of the IPDL type |struct CacheMatchResult|
//
namespace mozilla {
namespace dom {
namespace cache {
class CacheMatchResult final
{
private:
    typedef ::mozilla::dom::cache::CacheResponse CacheResponse;

public:
#ifdef __clang__
#  pragma clang diagnostic push
#  if __has_warning("-Wdefaulted-function-deleted")
#    pragma clang diagnostic ignored "-Wdefaulted-function-deleted"
#  endif
#endif
    CacheMatchResult() = default;
#ifdef __clang__
#  pragma clang diagnostic pop
#endif

    MOZ_IMPLICIT CacheMatchResult(const mozilla::Maybe<CacheResponse>& _maybeResponse) :
        maybeResponse_(_maybeResponse)
    {
    }

    MOZ_IMPLICIT CacheMatchResult(mozilla::Maybe<CacheResponse>&& _maybeResponse) :
        maybeResponse_(std::move(_maybeResponse))
    {
    }

    mozilla::Maybe<CacheResponse>&
    maybeResponse()
    {
        return maybeResponse_;
    }
    const mozilla::Maybe<CacheResponse>&
    maybeResponse() const
    {
        return maybeResponse_;
    }

private:
    ::mozilla::ipc::IPDLStructMember<mozilla::Maybe<CacheResponse>> maybeResponse_;
};
} // namespace cache
} // namespace dom
} // namespace mozilla

namespace IPC {
template<>
struct ParamTraits <::mozilla::dom::cache::CacheMatchResult>
{
    typedef ::mozilla::dom::cache::CacheMatchResult paramType;
    static void
    Write(
            IPC::MessageWriter* aWriter,
            const paramType& aVar);
    static IPC::ReadResult<paramType>
    Read(IPC::MessageReader* aReader);
};
} // namespace IPC


//-----------------------------------------------------------------------------
// Declaration of the IPDL type |struct CacheMatchAllResult|
//
namespace mozilla {
namespace dom {
namespace cache {
class CacheMatchAllResult final
{
private:
    typedef ::mozilla::dom::cache::CacheResponse CacheResponse;

public:
#ifdef __clang__
#  pragma clang diagnostic push
#  if __has_warning("-Wdefaulted-function-deleted")
#    pragma clang diagnostic ignored "-Wdefaulted-function-deleted"
#  endif
#endif
    CacheMatchAllResult() = default;
#ifdef __clang__
#  pragma clang diagnostic pop
#endif

    MOZ_IMPLICIT CacheMatchAllResult(const nsTArray<CacheResponse>& _responseList) :
        responseList_(_responseList)
    {
    }

    MOZ_IMPLICIT CacheMatchAllResult(nsTArray<CacheResponse>&& _responseList) :
        responseList_(std::move(_responseList))
    {
    }

    nsTArray<CacheResponse>&
    responseList()
    {
        return responseList_;
    }
    const nsTArray<CacheResponse>&
    responseList() const
    {
        return responseList_;
    }

private:
    ::mozilla::ipc::IPDLStructMember<CopyableTArray<CacheResponse>> responseList_;
};
} // namespace cache
} // namespace dom
} // namespace mozilla

namespace IPC {
template<>
struct ParamTraits <::mozilla::dom::cache::CacheMatchAllResult>
{
    typedef ::mozilla::dom::cache::CacheMatchAllResult paramType;
    static void
    Write(
            IPC::MessageWriter* aWriter,
            const paramType& aVar);
    static IPC::ReadResult<paramType>
    Read(IPC::MessageReader* aReader);
};
} // namespace IPC


//-----------------------------------------------------------------------------
// Declaration of the IPDL type |struct CachePutAllResult|
//
namespace mozilla {
namespace dom {
namespace cache {
class CachePutAllResult final
{
private:

public:
#ifdef __clang__
#  pragma clang diagnostic push
#  if __has_warning("-Wdefaulted-function-deleted")
#    pragma clang diagnostic ignored "-Wdefaulted-function-deleted"
#  endif
#endif
    CachePutAllResult() = default;
#ifdef __clang__
#  pragma clang diagnostic pop
#endif

private:
};
} // namespace cache
} // namespace dom
} // namespace mozilla

namespace IPC {
template<>
struct ParamTraits <::mozilla::dom::cache::CachePutAllResult>
{
    typedef ::mozilla::dom::cache::CachePutAllResult paramType;
    static void
    Write(
            IPC::MessageWriter* aWriter,
            const paramType& aVar);
    static IPC::ReadResult<paramType>
    Read(IPC::MessageReader* aReader);
};
} // namespace IPC


//-----------------------------------------------------------------------------
// Declaration of the IPDL type |struct CacheDeleteResult|
//
namespace mozilla {
namespace dom {
namespace cache {
class CacheDeleteResult final
{
private:

public:
#ifdef __clang__
#  pragma clang diagnostic push
#  if __has_warning("-Wdefaulted-function-deleted")
#    pragma clang diagnostic ignored "-Wdefaulted-function-deleted"
#  endif
#endif
    CacheDeleteResult() = default;
#ifdef __clang__
#  pragma clang diagnostic pop
#endif

    MOZ_IMPLICIT CacheDeleteResult(const bool& _success) :
        success_(_success)
    {
    }

    MOZ_IMPLICIT CacheDeleteResult(bool&& _success) :
        success_(std::move(_success))
    {
    }

    bool&
    success()
    {
        return success_;
    }
    const bool&
    success() const
    {
        return success_;
    }

private:
    ::mozilla::ipc::IPDLStructMember<bool> success_;
};
} // namespace cache
} // namespace dom
} // namespace mozilla

namespace IPC {
template<>
struct ParamTraits <::mozilla::dom::cache::CacheDeleteResult>
{
    typedef ::mozilla::dom::cache::CacheDeleteResult paramType;
    static void
    Write(
            IPC::MessageWriter* aWriter,
            const paramType& aVar);
    static IPC::ReadResult<paramType>
    Read(IPC::MessageReader* aReader);
};
} // namespace IPC


//-----------------------------------------------------------------------------
// Declaration of the IPDL type |struct CacheKeysResult|
//
namespace mozilla {
namespace dom {
namespace cache {
class CacheKeysResult final
{
private:
    typedef ::mozilla::dom::cache::CacheRequest CacheRequest;

public:
#ifdef __clang__
#  pragma clang diagnostic push
#  if __has_warning("-Wdefaulted-function-deleted")
#    pragma clang diagnostic ignored "-Wdefaulted-function-deleted"
#  endif
#endif
    CacheKeysResult() = default;
#ifdef __clang__
#  pragma clang diagnostic pop
#endif

    MOZ_IMPLICIT CacheKeysResult(const nsTArray<CacheRequest>& _requestList) :
        requestList_(_requestList)
    {
    }

    MOZ_IMPLICIT CacheKeysResult(nsTArray<CacheRequest>&& _requestList) :
        requestList_(std::move(_requestList))
    {
    }

    nsTArray<CacheRequest>&
    requestList()
    {
        return requestList_;
    }
    const nsTArray<CacheRequest>&
    requestList() const
    {
        return requestList_;
    }

private:
    ::mozilla::ipc::IPDLStructMember<CopyableTArray<CacheRequest>> requestList_;
};
} // namespace cache
} // namespace dom
} // namespace mozilla

namespace IPC {
template<>
struct ParamTraits <::mozilla::dom::cache::CacheKeysResult>
{
    typedef ::mozilla::dom::cache::CacheKeysResult paramType;
    static void
    Write(
            IPC::MessageWriter* aWriter,
            const paramType& aVar);
    static IPC::ReadResult<paramType>
    Read(IPC::MessageReader* aReader);
};
} // namespace IPC


//-----------------------------------------------------------------------------
// Declaration of the IPDL type |struct StorageMatchResult|
//
namespace mozilla {
namespace dom {
namespace cache {
class StorageMatchResult final
{
private:
    typedef ::mozilla::dom::cache::CacheResponse CacheResponse;

public:
#ifdef __clang__
#  pragma clang diagnostic push
#  if __has_warning("-Wdefaulted-function-deleted")
#    pragma clang diagnostic ignored "-Wdefaulted-function-deleted"
#  endif
#endif
    StorageMatchResult() = default;
#ifdef __clang__
#  pragma clang diagnostic pop
#endif

    MOZ_IMPLICIT StorageMatchResult(const mozilla::Maybe<CacheResponse>& _maybeResponse) :
        maybeResponse_(_maybeResponse)
    {
    }

    MOZ_IMPLICIT StorageMatchResult(mozilla::Maybe<CacheResponse>&& _maybeResponse) :
        maybeResponse_(std::move(_maybeResponse))
    {
    }

    mozilla::Maybe<CacheResponse>&
    maybeResponse()
    {
        return maybeResponse_;
    }
    const mozilla::Maybe<CacheResponse>&
    maybeResponse() const
    {
        return maybeResponse_;
    }

private:
    ::mozilla::ipc::IPDLStructMember<mozilla::Maybe<CacheResponse>> maybeResponse_;
};
} // namespace cache
} // namespace dom
} // namespace mozilla

namespace IPC {
template<>
struct ParamTraits <::mozilla::dom::cache::StorageMatchResult>
{
    typedef ::mozilla::dom::cache::StorageMatchResult paramType;
    static void
    Write(
            IPC::MessageWriter* aWriter,
            const paramType& aVar);
    static IPC::ReadResult<paramType>
    Read(IPC::MessageReader* aReader);
};
} // namespace IPC


//-----------------------------------------------------------------------------
// Declaration of the IPDL type |struct StorageHasResult|
//
namespace mozilla {
namespace dom {
namespace cache {
class StorageHasResult final
{
private:

public:
#ifdef __clang__
#  pragma clang diagnostic push
#  if __has_warning("-Wdefaulted-function-deleted")
#    pragma clang diagnostic ignored "-Wdefaulted-function-deleted"
#  endif
#endif
    StorageHasResult() = default;
#ifdef __clang__
#  pragma clang diagnostic pop
#endif

    MOZ_IMPLICIT StorageHasResult(const bool& _success) :
        success_(_success)
    {
    }

    MOZ_IMPLICIT StorageHasResult(bool&& _success) :
        success_(std::move(_success))
    {
    }

    bool&
    success()
    {
        return success_;
    }
    const bool&
    success() const
    {
        return success_;
    }

private:
    ::mozilla::ipc::IPDLStructMember<bool> success_;
};
} // namespace cache
} // namespace dom
} // namespace mozilla

namespace IPC {
template<>
struct ParamTraits <::mozilla::dom::cache::StorageHasResult>
{
    typedef ::mozilla::dom::cache::StorageHasResult paramType;
    static void
    Write(
            IPC::MessageWriter* aWriter,
            const paramType& aVar);
    static IPC::ReadResult<paramType>
    Read(IPC::MessageReader* aReader);
};
} // namespace IPC

namespace mozilla {
namespace dom {
namespace cache {
class PCacheParent;
} // namespace cache
} // namespace dom
} // namespace mozilla

namespace mozilla {
namespace dom {
namespace cache {
class PCacheChild;
} // namespace cache
} // namespace dom
} // namespace mozilla


//-----------------------------------------------------------------------------
// Declaration of the IPDL type |struct StorageOpenResult|
//
namespace mozilla {
namespace dom {
namespace cache {
class StorageOpenResult final
{
private:
    typedef ::mozilla::dom::cache::PCacheParent PCacheParent;
    typedef ::mozilla::dom::cache::PCacheChild PCacheChild;
    typedef ::mozilla::dom::cache::Namespace Namespace;

public:
#ifdef __clang__
#  pragma clang diagnostic push
#  if __has_warning("-Wdefaulted-function-deleted")
#    pragma clang diagnostic ignored "-Wdefaulted-function-deleted"
#  endif
#endif
    StorageOpenResult() = default;
#ifdef __clang__
#  pragma clang diagnostic pop
#endif

    MOZ_IMPLICIT StorageOpenResult(
            ::mozilla::ipc::SideVariant<PCacheParent*, PCacheChild*> _actor,
            const Namespace& _ns) :
        actor_(_actor),
        ns_(_ns)
    {
    }

    MOZ_IMPLICIT StorageOpenResult(
            ::mozilla::ipc::SideVariant<PCacheParent*, PCacheChild*> _actor,
            Namespace&& _ns) :
        actor_(_actor),
        ns_(std::move(_ns))
    {
    }

    ::mozilla::ipc::SideVariant<PCacheParent*, PCacheChild*>&
    actor()
    {
        return actor_;
    }
    ::mozilla::ipc::SideVariant<PCacheParent*, PCacheChild*>
    actor() const
    {
        return actor_;
    }

    Namespace&
    ns()
    {
        return ns_;
    }
    const Namespace&
    ns() const
    {
        return ns_;
    }

private:
    ::mozilla::ipc::IPDLStructMember<::mozilla::ipc::SideVariant<PCacheParent*, PCacheChild*>> actor_;
    ::mozilla::ipc::IPDLStructMember<Namespace> ns_;
};
} // namespace cache
} // namespace dom
} // namespace mozilla

namespace IPC {
template<>
struct ParamTraits <::mozilla::dom::cache::StorageOpenResult>
{
    typedef ::mozilla::dom::cache::StorageOpenResult paramType;
    static void
    Write(
            IPC::MessageWriter* aWriter,
            const paramType& aVar);
    static IPC::ReadResult<paramType>
    Read(IPC::MessageReader* aReader);
};
} // namespace IPC


//-----------------------------------------------------------------------------
// Declaration of the IPDL type |struct StorageDeleteResult|
//
namespace mozilla {
namespace dom {
namespace cache {
class StorageDeleteResult final
{
private:

public:
#ifdef __clang__
#  pragma clang diagnostic push
#  if __has_warning("-Wdefaulted-function-deleted")
#    pragma clang diagnostic ignored "-Wdefaulted-function-deleted"
#  endif
#endif
    StorageDeleteResult() = default;
#ifdef __clang__
#  pragma clang diagnostic pop
#endif

    MOZ_IMPLICIT StorageDeleteResult(const bool& _success) :
        success_(_success)
    {
    }

    MOZ_IMPLICIT StorageDeleteResult(bool&& _success) :
        success_(std::move(_success))
    {
    }

    bool&
    success()
    {
        return success_;
    }
    const bool&
    success() const
    {
        return success_;
    }

private:
    ::mozilla::ipc::IPDLStructMember<bool> success_;
};
} // namespace cache
} // namespace dom
} // namespace mozilla

namespace IPC {
template<>
struct ParamTraits <::mozilla::dom::cache::StorageDeleteResult>
{
    typedef ::mozilla::dom::cache::StorageDeleteResult paramType;
    static void
    Write(
            IPC::MessageWriter* aWriter,
            const paramType& aVar);
    static IPC::ReadResult<paramType>
    Read(IPC::MessageReader* aReader);
};
} // namespace IPC


//-----------------------------------------------------------------------------
// Declaration of the IPDL type |struct StorageKeysResult|
//
namespace mozilla {
namespace dom {
namespace cache {
class StorageKeysResult final
{
private:
    typedef ::nsString nsString;

public:
#ifdef __clang__
#  pragma clang diagnostic push
#  if __has_warning("-Wdefaulted-function-deleted")
#    pragma clang diagnostic ignored "-Wdefaulted-function-deleted"
#  endif
#endif
    StorageKeysResult() = default;
#ifdef __clang__
#  pragma clang diagnostic pop
#endif

    MOZ_IMPLICIT StorageKeysResult(const nsTArray<nsString>& _keyList) :
        keyList_(_keyList)
    {
    }

    MOZ_IMPLICIT StorageKeysResult(nsTArray<nsString>&& _keyList) :
        keyList_(std::move(_keyList))
    {
    }

    nsTArray<nsString>&
    keyList()
    {
        return keyList_;
    }
    const nsTArray<nsString>&
    keyList() const
    {
        return keyList_;
    }

private:
    ::mozilla::ipc::IPDLStructMember<CopyableTArray<nsString>> keyList_;
};
} // namespace cache
} // namespace dom
} // namespace mozilla

namespace IPC {
template<>
struct ParamTraits <::mozilla::dom::cache::StorageKeysResult>
{
    typedef ::mozilla::dom::cache::StorageKeysResult paramType;
    static void
    Write(
            IPC::MessageWriter* aWriter,
            const paramType& aVar);
    static IPC::ReadResult<paramType>
    Read(IPC::MessageReader* aReader);
};
} // namespace IPC


//-----------------------------------------------------------------------------
// Declaration of the IPDL type |union CacheOpResult|
//
namespace mozilla {
namespace dom {
namespace cache {
class CacheOpResult final
{
public:
    enum Type {
        T__None,
        Tvoid_t = 1,
        TCacheMatchResult,
        TCacheMatchAllResult,
        TCachePutAllResult,
        TCacheDeleteResult,
        TCacheKeysResult,
        TStorageMatchResult,
        TStorageHasResult,
        TStorageOpenResult,
        TStorageDeleteResult,
        TStorageKeysResult,
        T__Last = TStorageKeysResult
    };

private:
    typedef ::mozilla::void_t void_t;
    typedef ::mozilla::dom::cache::CacheMatchResult CacheMatchResult;
    typedef ::mozilla::dom::cache::CacheMatchAllResult CacheMatchAllResult;
    typedef ::mozilla::dom::cache::CachePutAllResult CachePutAllResult;
    typedef ::mozilla::dom::cache::CacheDeleteResult CacheDeleteResult;
    typedef ::mozilla::dom::cache::CacheKeysResult CacheKeysResult;
    typedef ::mozilla::dom::cache::StorageMatchResult StorageMatchResult;
    typedef ::mozilla::dom::cache::StorageHasResult StorageHasResult;
    typedef ::mozilla::dom::cache::StorageOpenResult StorageOpenResult;
    typedef ::mozilla::dom::cache::StorageDeleteResult StorageDeleteResult;
    typedef ::mozilla::dom::cache::StorageKeysResult StorageKeysResult;
    typedef void_t void_t__tdef;
    typedef CacheMatchResult CacheMatchResult__tdef;
    typedef CacheMatchAllResult CacheMatchAllResult__tdef;
    typedef CachePutAllResult CachePutAllResult__tdef;
    typedef CacheDeleteResult CacheDeleteResult__tdef;
    typedef CacheKeysResult CacheKeysResult__tdef;
    typedef StorageMatchResult StorageMatchResult__tdef;
    typedef StorageHasResult StorageHasResult__tdef;
    typedef StorageOpenResult StorageOpenResult__tdef;
    typedef StorageDeleteResult StorageDeleteResult__tdef;
    typedef StorageKeysResult StorageKeysResult__tdef;

    void_t*
    ptr_void_t()
    {
        return (&(mVvoid_t));
    }
    const void_t*
    constptr_void_t() const
    {
        return (&(mVvoid_t));
    }
    CacheMatchResult*
    ptr_CacheMatchResult()
    {
        return (&(mVCacheMatchResult));
    }
    const CacheMatchResult*
    constptr_CacheMatchResult() const
    {
        return (&(mVCacheMatchResult));
    }
    CacheMatchAllResult*
    ptr_CacheMatchAllResult()
    {
        return (&(mVCacheMatchAllResult));
    }
    const CacheMatchAllResult*
    constptr_CacheMatchAllResult() const
    {
        return (&(mVCacheMatchAllResult));
    }
    CachePutAllResult*
    ptr_CachePutAllResult()
    {
        return (&(mVCachePutAllResult));
    }
    const CachePutAllResult*
    constptr_CachePutAllResult() const
    {
        return (&(mVCachePutAllResult));
    }
    CacheDeleteResult*
    ptr_CacheDeleteResult()
    {
        return (&(mVCacheDeleteResult));
    }
    const CacheDeleteResult*
    constptr_CacheDeleteResult() const
    {
        return (&(mVCacheDeleteResult));
    }
    CacheKeysResult*
    ptr_CacheKeysResult()
    {
        return (&(mVCacheKeysResult));
    }
    const CacheKeysResult*
    constptr_CacheKeysResult() const
    {
        return (&(mVCacheKeysResult));
    }
    StorageMatchResult*
    ptr_StorageMatchResult()
    {
        return (&(mVStorageMatchResult));
    }
    const StorageMatchResult*
    constptr_StorageMatchResult() const
    {
        return (&(mVStorageMatchResult));
    }
    StorageHasResult*
    ptr_StorageHasResult()
    {
        return (&(mVStorageHasResult));
    }
    const StorageHasResult*
    constptr_StorageHasResult() const
    {
        return (&(mVStorageHasResult));
    }
    StorageOpenResult*
    ptr_StorageOpenResult()
    {
        return (&(mVStorageOpenResult));
    }
    const StorageOpenResult*
    constptr_StorageOpenResult() const
    {
        return (&(mVStorageOpenResult));
    }
    StorageDeleteResult*
    ptr_StorageDeleteResult()
    {
        return (&(mVStorageDeleteResult));
    }
    const StorageDeleteResult*
    constptr_StorageDeleteResult() const
    {
        return (&(mVStorageDeleteResult));
    }
    StorageKeysResult*
    ptr_StorageKeysResult()
    {
        return (&(mVStorageKeysResult));
    }
    const StorageKeysResult*
    constptr_StorageKeysResult() const
    {
        return (&(mVStorageKeysResult));
    }

    void
    MaybeDestroy();

    void
    AssertSanity() const
    {
        MOZ_RELEASE_ASSERT((T__None) <= (mType), "invalid type tag");
        MOZ_RELEASE_ASSERT((mType) <= (T__Last), "invalid type tag");
    }
    void
    AssertSanity(Type aType) const
    {
        AssertSanity();
        MOZ_RELEASE_ASSERT((mType) == (aType), "unexpected type tag");
    }

public:
    MOZ_IMPLICIT CacheOpResult() :
        mType(T__None)
    {
    }

    MOZ_IMPLICIT CacheOpResult(const void_t& aOther);

    MOZ_IMPLICIT CacheOpResult(void_t&& aOther);

    MOZ_IMPLICIT CacheOpResult(const CacheMatchResult& aOther);

    MOZ_IMPLICIT CacheOpResult(CacheMatchResult&& aOther);

    MOZ_IMPLICIT CacheOpResult(const CacheMatchAllResult& aOther);

    MOZ_IMPLICIT CacheOpResult(CacheMatchAllResult&& aOther);

    MOZ_IMPLICIT CacheOpResult(const CachePutAllResult& aOther);

    MOZ_IMPLICIT CacheOpResult(CachePutAllResult&& aOther);

    MOZ_IMPLICIT CacheOpResult(const CacheDeleteResult& aOther);

    MOZ_IMPLICIT CacheOpResult(CacheDeleteResult&& aOther);

    MOZ_IMPLICIT CacheOpResult(const CacheKeysResult& aOther);

    MOZ_IMPLICIT CacheOpResult(CacheKeysResult&& aOther);

    MOZ_IMPLICIT CacheOpResult(const StorageMatchResult& aOther);

    MOZ_IMPLICIT CacheOpResult(StorageMatchResult&& aOther);

    MOZ_IMPLICIT CacheOpResult(const StorageHasResult& aOther);

    MOZ_IMPLICIT CacheOpResult(StorageHasResult&& aOther);

    MOZ_IMPLICIT CacheOpResult(const StorageOpenResult& aOther);

    MOZ_IMPLICIT CacheOpResult(StorageOpenResult&& aOther);

    MOZ_IMPLICIT CacheOpResult(const StorageDeleteResult& aOther);

    MOZ_IMPLICIT CacheOpResult(StorageDeleteResult&& aOther);

    MOZ_IMPLICIT CacheOpResult(const StorageKeysResult& aOther);

    MOZ_IMPLICIT CacheOpResult(StorageKeysResult&& aOther);

    MOZ_IMPLICIT CacheOpResult(const CacheOpResult& aOther);

    MOZ_IMPLICIT CacheOpResult(CacheOpResult&& aOther);

    ~CacheOpResult();

    Type
    type() const
    {
        return mType;
    }

    CacheOpResult&
    operator=(const void_t& aRhs);

    CacheOpResult&
    operator=(void_t&& aRhs);

    CacheOpResult&
    operator=(const CacheMatchResult& aRhs);

    CacheOpResult&
    operator=(CacheMatchResult&& aRhs);

    CacheOpResult&
    operator=(const CacheMatchAllResult& aRhs);

    CacheOpResult&
    operator=(CacheMatchAllResult&& aRhs);

    CacheOpResult&
    operator=(const CachePutAllResult& aRhs);

    CacheOpResult&
    operator=(CachePutAllResult&& aRhs);

    CacheOpResult&
    operator=(const CacheDeleteResult& aRhs);

    CacheOpResult&
    operator=(CacheDeleteResult&& aRhs);

    CacheOpResult&
    operator=(const CacheKeysResult& aRhs);

    CacheOpResult&
    operator=(CacheKeysResult&& aRhs);

    CacheOpResult&
    operator=(const StorageMatchResult& aRhs);

    CacheOpResult&
    operator=(StorageMatchResult&& aRhs);

    CacheOpResult&
    operator=(const StorageHasResult& aRhs);

    CacheOpResult&
    operator=(StorageHasResult&& aRhs);

    CacheOpResult&
    operator=(const StorageOpenResult& aRhs);

    CacheOpResult&
    operator=(StorageOpenResult&& aRhs);

    CacheOpResult&
    operator=(const StorageDeleteResult& aRhs);

    CacheOpResult&
    operator=(StorageDeleteResult&& aRhs);

    CacheOpResult&
    operator=(const StorageKeysResult& aRhs);

    CacheOpResult&
    operator=(StorageKeysResult&& aRhs);

    CacheOpResult&
    operator=(const CacheOpResult& aRhs);

    CacheOpResult&
    operator=(CacheOpResult&& aRhs);

    void_t&
    get_void_t()
    {
        AssertSanity(Tvoid_t);
        return (*(ptr_void_t()));
    }
    const void_t&
    get_void_t() const
    {
        AssertSanity(Tvoid_t);
        return (*(constptr_void_t()));
    }
    operator void_t&()
    {
        return get_void_t();
    }
    operator const void_t&() const
    {
        return get_void_t();
    }

    CacheMatchResult&
    get_CacheMatchResult()
    {
        AssertSanity(TCacheMatchResult);
        return (*(ptr_CacheMatchResult()));
    }
    const CacheMatchResult&
    get_CacheMatchResult() const
    {
        AssertSanity(TCacheMatchResult);
        return (*(constptr_CacheMatchResult()));
    }
    operator CacheMatchResult&()
    {
        return get_CacheMatchResult();
    }
    operator const CacheMatchResult&() const
    {
        return get_CacheMatchResult();
    }

    CacheMatchAllResult&
    get_CacheMatchAllResult()
    {
        AssertSanity(TCacheMatchAllResult);
        return (*(ptr_CacheMatchAllResult()));
    }
    const CacheMatchAllResult&
    get_CacheMatchAllResult() const
    {
        AssertSanity(TCacheMatchAllResult);
        return (*(constptr_CacheMatchAllResult()));
    }
    operator CacheMatchAllResult&()
    {
        return get_CacheMatchAllResult();
    }
    operator const CacheMatchAllResult&() const
    {
        return get_CacheMatchAllResult();
    }

    CachePutAllResult&
    get_CachePutAllResult()
    {
        AssertSanity(TCachePutAllResult);
        return (*(ptr_CachePutAllResult()));
    }
    const CachePutAllResult&
    get_CachePutAllResult() const
    {
        AssertSanity(TCachePutAllResult);
        return (*(constptr_CachePutAllResult()));
    }
    operator CachePutAllResult&()
    {
        return get_CachePutAllResult();
    }
    operator const CachePutAllResult&() const
    {
        return get_CachePutAllResult();
    }

    CacheDeleteResult&
    get_CacheDeleteResult()
    {
        AssertSanity(TCacheDeleteResult);
        return (*(ptr_CacheDeleteResult()));
    }
    const CacheDeleteResult&
    get_CacheDeleteResult() const
    {
        AssertSanity(TCacheDeleteResult);
        return (*(constptr_CacheDeleteResult()));
    }
    operator CacheDeleteResult&()
    {
        return get_CacheDeleteResult();
    }
    operator const CacheDeleteResult&() const
    {
        return get_CacheDeleteResult();
    }

    CacheKeysResult&
    get_CacheKeysResult()
    {
        AssertSanity(TCacheKeysResult);
        return (*(ptr_CacheKeysResult()));
    }
    const CacheKeysResult&
    get_CacheKeysResult() const
    {
        AssertSanity(TCacheKeysResult);
        return (*(constptr_CacheKeysResult()));
    }
    operator CacheKeysResult&()
    {
        return get_CacheKeysResult();
    }
    operator const CacheKeysResult&() const
    {
        return get_CacheKeysResult();
    }

    StorageMatchResult&
    get_StorageMatchResult()
    {
        AssertSanity(TStorageMatchResult);
        return (*(ptr_StorageMatchResult()));
    }
    const StorageMatchResult&
    get_StorageMatchResult() const
    {
        AssertSanity(TStorageMatchResult);
        return (*(constptr_StorageMatchResult()));
    }
    operator StorageMatchResult&()
    {
        return get_StorageMatchResult();
    }
    operator const StorageMatchResult&() const
    {
        return get_StorageMatchResult();
    }

    StorageHasResult&
    get_StorageHasResult()
    {
        AssertSanity(TStorageHasResult);
        return (*(ptr_StorageHasResult()));
    }
    const StorageHasResult&
    get_StorageHasResult() const
    {
        AssertSanity(TStorageHasResult);
        return (*(constptr_StorageHasResult()));
    }
    operator StorageHasResult&()
    {
        return get_StorageHasResult();
    }
    operator const StorageHasResult&() const
    {
        return get_StorageHasResult();
    }

    StorageOpenResult&
    get_StorageOpenResult()
    {
        AssertSanity(TStorageOpenResult);
        return (*(ptr_StorageOpenResult()));
    }
    const StorageOpenResult&
    get_StorageOpenResult() const
    {
        AssertSanity(TStorageOpenResult);
        return (*(constptr_StorageOpenResult()));
    }
    operator StorageOpenResult&()
    {
        return get_StorageOpenResult();
    }
    operator const StorageOpenResult&() const
    {
        return get_StorageOpenResult();
    }

    StorageDeleteResult&
    get_StorageDeleteResult()
    {
        AssertSanity(TStorageDeleteResult);
        return (*(ptr_StorageDeleteResult()));
    }
    const StorageDeleteResult&
    get_StorageDeleteResult() const
    {
        AssertSanity(TStorageDeleteResult);
        return (*(constptr_StorageDeleteResult()));
    }
    operator StorageDeleteResult&()
    {
        return get_StorageDeleteResult();
    }
    operator const StorageDeleteResult&() const
    {
        return get_StorageDeleteResult();
    }

    StorageKeysResult&
    get_StorageKeysResult()
    {
        AssertSanity(TStorageKeysResult);
        return (*(ptr_StorageKeysResult()));
    }
    const StorageKeysResult&
    get_StorageKeysResult() const
    {
        AssertSanity(TStorageKeysResult);
        return (*(constptr_StorageKeysResult()));
    }
    operator StorageKeysResult&()
    {
        return get_StorageKeysResult();
    }
    operator const StorageKeysResult&() const
    {
        return get_StorageKeysResult();
    }

private:
    union {
        void_t mVvoid_t;
        CacheMatchResult mVCacheMatchResult;
        CacheMatchAllResult mVCacheMatchAllResult;
        CachePutAllResult mVCachePutAllResult;
        CacheDeleteResult mVCacheDeleteResult;
        CacheKeysResult mVCacheKeysResult;
        StorageMatchResult mVStorageMatchResult;
        StorageHasResult mVStorageHasResult;
        StorageOpenResult mVStorageOpenResult;
        StorageDeleteResult mVStorageDeleteResult;
        StorageKeysResult mVStorageKeysResult;
    };
    Type mType;
};
} // namespace cache
} // namespace dom
} // namespace mozilla

namespace IPC {
template<>
struct ParamTraits <::mozilla::dom::cache::CacheOpResult>
{
    typedef ::mozilla::dom::cache::CacheOpResult paramType;
    static void
    Write(
            IPC::MessageWriter* aWriter,
            const paramType& aVar);
    static IPC::ReadResult<paramType>
    Read(IPC::MessageReader* aReader);
};
} // namespace IPC

#endif // ifndef CacheTypes_h
