/* -*- Mode: C++; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* vim:set ts=2 sw=2 sts=2 et cindent: */
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/. */

/* THIS FILE IS AUTOGENERATED FROM XRInputSourcesChangeEvent.webidl BY Codegen.py - DO NOT EDIT */

#include "EventBinding.h"
#include "XRInputSourcesChangeEvent.h"
#include "XRInputSourcesChangeEventBinding.h"
#include "js/Array.h"
#include "js/ForOfIterator.h"
#include "js/GCAPI.h"
#include "mozilla/HoldDropJSObjects.h"
#include "mozilla/dom/BindingCallContext.h"
#include "mozilla/dom/Nullable.h"
#include "mozilla/dom/PrimitiveConversions.h"
#include "mozilla/dom/XRInputSource.h"
#include "mozilla/dom/XRInputSourcesChangeEvent.h"
#include "mozilla/dom/XRSession.h"

namespace mozilla::dom {


NS_IMPL_CYCLE_COLLECTION_CLASS(XRInputSourcesChangeEvent)

NS_IMPL_ADDREF_INHERITED(XRInputSourcesChangeEvent, Event)
NS_IMPL_RELEASE_INHERITED(XRInputSourcesChangeEvent, Event)

NS_IMPL_CYCLE_COLLECTION_TRAVERSE_BEGIN_INHERITED(XRInputSourcesChangeEvent, Event)
  NS_IMPL_CYCLE_COLLECTION_TRAVERSE(mSession)
  NS_IMPL_CYCLE_COLLECTION_TRAVERSE(mAdded)
  NS_IMPL_CYCLE_COLLECTION_TRAVERSE(mRemoved)
NS_IMPL_CYCLE_COLLECTION_TRAVERSE_END

NS_IMPL_CYCLE_COLLECTION_TRACE_BEGIN_INHERITED(XRInputSourcesChangeEvent, Event)
NS_IMPL_CYCLE_COLLECTION_TRACE_END

NS_IMPL_CYCLE_COLLECTION_UNLINK_BEGIN_INHERITED(XRInputSourcesChangeEvent, Event)
  NS_IMPL_CYCLE_COLLECTION_UNLINK(mSession)
  NS_IMPL_CYCLE_COLLECTION_UNLINK(mAdded)
  NS_IMPL_CYCLE_COLLECTION_UNLINK(mRemoved)
NS_IMPL_CYCLE_COLLECTION_UNLINK_END

NS_INTERFACE_MAP_BEGIN_CYCLE_COLLECTION(XRInputSourcesChangeEvent)
NS_INTERFACE_MAP_END_INHERITING(Event)

XRInputSourcesChangeEvent::XRInputSourcesChangeEvent(mozilla::dom::EventTarget* aOwner)
  : Event(aOwner, nullptr, nullptr)
{
}

XRInputSourcesChangeEvent::~XRInputSourcesChangeEvent()
{
}

XRInputSourcesChangeEvent*
XRInputSourcesChangeEvent::AsXRInputSourcesChangeEvent()
{
  return this;
}

JSObject*
XRInputSourcesChangeEvent::WrapObjectInternal(JSContext* aCx, JS::Handle<JSObject*> aGivenProto)
{
  return XRInputSourcesChangeEvent_Binding::Wrap(aCx, this, aGivenProto);
}

already_AddRefed<XRInputSourcesChangeEvent>
XRInputSourcesChangeEvent::Constructor(mozilla::dom::EventTarget* aOwner, const nsAString& aType, const XRInputSourcesChangeEventInit& aEventInitDict)
{
  RefPtr<XRInputSourcesChangeEvent> e = new XRInputSourcesChangeEvent(aOwner);
  bool trusted = e->Init(aOwner);
  e->InitEvent(aType, aEventInitDict.mBubbles, aEventInitDict.mCancelable);
  e->mSession = aEventInitDict.mSession;
  e->mAdded.AppendElements(aEventInitDict.mAdded);
  e->mRemoved.AppendElements(aEventInitDict.mRemoved);
  e->SetTrusted(trusted);
  e->SetComposed(aEventInitDict.mComposed);
  return e.forget();
}

already_AddRefed<XRInputSourcesChangeEvent>
XRInputSourcesChangeEvent::Constructor(const GlobalObject& aGlobal, const nsAString& aType, const XRInputSourcesChangeEventInit& aEventInitDict)
{
  nsCOMPtr<mozilla::dom::EventTarget> owner = do_QueryInterface(aGlobal.GetAsSupports());
  return Constructor(owner, aType, aEventInitDict);
}

XRSession*
XRInputSourcesChangeEvent::Session() const
{
  return mSession;
}

void
XRInputSourcesChangeEvent::GetAdded(nsTArray<RefPtr<XRInputSource>>& aRetVal) const
{
  aRetVal = mAdded.Clone();
}

void
XRInputSourcesChangeEvent::GetRemoved(nsTArray<RefPtr<XRInputSource>>& aRetVal) const
{
  aRetVal = mRemoved.Clone();
}


} // namespace mozilla::dom
