/* THIS FILE IS AUTOGENERATED FROM Sanitizer.webidl BY Codegen.py - DO NOT EDIT */

#include <type_traits>
#include "AtomList.h"
#include "MainThreadUtils.h"
#include "SanitizerBinding.h"
#include "WrapperFactory.h"
#include "js/Array.h"
#include "js/CallAndConstruct.h"
#include "js/Exception.h"
#include "js/ForOfIterator.h"
#include "js/MapAndSet.h"
#include "js/Object.h"
#include "js/PropertyAndElement.h"
#include "js/PropertyDescriptor.h"
#include "js/experimental/JitInfo.h"
#include "jsapi.h"
#include "mozilla/Atomics.h"
#include "mozilla/OwningNonNull.h"
#include "mozilla/ProfilerLabels.h"
#include "mozilla/StaticPrefs_dom.h"
#include "mozilla/dom/BindingCallContext.h"
#include "mozilla/dom/BindingUtils.h"
#include "mozilla/dom/DOMJSClass.h"
#include "mozilla/dom/NonRefcountedDOMObject.h"
#include "mozilla/dom/PrimitiveConversions.h"
#include "mozilla/dom/Sanitizer.h"
#include "mozilla/dom/ScriptSettings.h"
#include "mozilla/dom/SimpleGlobalObject.h"
#include "mozilla/dom/XrayExpandoClass.h"

namespace mozilla {

namespace dom {

namespace binding_detail {}; // Just to make sure it's known as a namespace
using namespace mozilla::dom::binding_detail;


namespace binding_detail {
constexpr nsLiteralCString EnumStrings<SanitizerPresets>::Values[1];
} // namespace binding_detail

bool
ToJSValue(JSContext* aCx, SanitizerPresets aArgument, JS::MutableHandle<JS::Value> aValue)
{
  MOZ_ASSERT(uint32_t(aArgument) < std::size(binding_detail::EnumStrings<SanitizerPresets>::Values));
  JSString* resultStr =
    JS_NewStringCopyN(aCx, binding_detail::EnumStrings<SanitizerPresets>::Values[uint32_t(aArgument)].BeginReading(),
                      binding_detail::EnumStrings<SanitizerPresets>::Values[uint32_t(aArgument)].Length());
  if (!resultStr) {
    return false;
  }
  aValue.setString(resultStr);
  return true;
}


void
ImplCycleCollectionTraverse(nsCycleCollectionTraversalCallback& aCallback, OwningSanitizerOrSanitizerConfigOrSanitizerPresets& aUnion, const char* aName, uint32_t aFlags)
{
  if (aUnion.IsSanitizer()) {
    ImplCycleCollectionTraverse(aCallback, aUnion.GetAsSanitizer(), "mSanitizer", aFlags);
  }
}


void
ImplCycleCollectionUnlink(OwningSanitizerOrSanitizerConfigOrSanitizerPresets& aUnion)
{
  aUnion.Uninit();
}



SanitizerAttributeNamespace::SanitizerAttributeNamespace()
{
  // Safe to pass a null context if we pass a null value
  Init(nullptr, JS::NullHandleValue);
}




bool
SanitizerAttributeNamespace::InitIds(JSContext* cx, SanitizerAttributeNamespaceAtoms* atomsCache)
{
  MOZ_ASSERT(reinterpret_cast<jsid*>(atomsCache)->isVoid());

  // Initialize these in reverse order so that any failure leaves the first one
  // uninitialized.
  if (!atomsCache->namespace_id.init(cx, "namespace") ||
      !atomsCache->name_id.init(cx, "name")) {
    return false;
  }
  return true;
}

bool
SanitizerAttributeNamespace::Init(BindingCallContext& cx, JS::Handle<JS::Value> val, const char* sourceDescription, bool passedToJSImpl)
{
  // Passing a null JSContext is OK only if we're initing from null,
  // Since in that case we will not have to do any property gets
  // Also evaluate isNullOrUndefined in order to avoid false-positive
  // checkers by static analysis tools
  MOZ_ASSERT_IF(!cx, val.isNull() && val.isNullOrUndefined());
  SanitizerAttributeNamespaceAtoms* atomsCache = nullptr;
  if (cx) {
    atomsCache = GetAtomCache<SanitizerAttributeNamespaceAtoms>(cx);
    if (reinterpret_cast<jsid*>(atomsCache)->isVoid() &&
        !InitIds(cx, atomsCache)) {
      return false;
    }
  }

  if (!IsConvertibleToDictionary(val)) {
    return cx.ThrowErrorMessage<MSG_CONVERSION_ERROR>(sourceDescription, "dictionary");
  }

  bool isNull = val.isNullOrUndefined();
  // We only need these if !isNull, in which case we have |cx|.
  Maybe<JS::Rooted<JSObject *> > object;
  Maybe<JS::Rooted<JS::Value> > temp;
  if (!isNull) {
    MOZ_ASSERT(cx);
    object.emplace(cx, &val.toObject());
    temp.emplace(cx);
  }
  if (!isNull) {
    if (!JS_GetPropertyById(cx, *object, atomsCache->name_id, temp.ptr())) {
      return false;
    }
  }
  if (!isNull && !temp->isUndefined()) {
    if (!ConvertJSValueToString(cx, temp.ref(), eStringify, eStringify, mName)) {
      return false;
    }
    mIsAnyMemberPresent = true;
  } else if (cx) {
    // Don't error out if we have no cx.  In that
    // situation the caller is default-constructing us and we'll
    // just assume they know what they're doing.
    return cx.ThrowErrorMessage<MSG_MISSING_REQUIRED_DICTIONARY_MEMBER>("'name' member of SanitizerAttributeNamespace");
  }

  if (!isNull) {
    if (!JS_GetPropertyById(cx, *object, atomsCache->namespace_id, temp.ptr())) {
      return false;
    }
  }
  if (!isNull && !temp->isUndefined()) {
    if (!ConvertJSValueToString(cx, temp.ref(), eNull, eNull, mNamespace)) {
      return false;
    }
  } else {
    mNamespace.SetIsVoid(true);
  }
  mIsAnyMemberPresent = true;
  return true;
}

bool
SanitizerAttributeNamespace::Init(JSContext* cx_, JS::Handle<JS::Value> val, const char* sourceDescription, bool passedToJSImpl)
{
  // We don't want to use sourceDescription for our context here;
  // that's not really what it's formatted for.
  BindingCallContext cx(cx_, nullptr);
  return Init(cx, val, sourceDescription, passedToJSImpl);
}

bool
SanitizerAttributeNamespace::ToObjectInternal(JSContext* cx, JS::MutableHandle<JS::Value> rval) const
{
  SanitizerAttributeNamespaceAtoms* atomsCache = GetAtomCache<SanitizerAttributeNamespaceAtoms>(cx);
  if (reinterpret_cast<jsid*>(atomsCache)->isVoid() &&
      !InitIds(cx, atomsCache)) {
    return false;
  }

  JS::Rooted<JSObject*> obj(cx, JS_NewPlainObject(cx));
  if (!obj) {
    return false;
  }
  rval.set(JS::ObjectValue(*obj));

  do {
    // block for our 'break' successCode and scope for 'temp' and 'currentValue'
    JS::Rooted<JS::Value> temp(cx);
    nsString const & currentValue = mName;
    if (!xpc::NonVoidStringToJsval(cx, currentValue, &temp)) {
      return false;
    }
    if (!JS_DefinePropertyById(cx, obj, atomsCache->name_id, temp, JSPROP_ENUMERATE)) {
      return false;
    }
    break;
  } while(false);

  do {
    // block for our 'break' successCode and scope for 'temp' and 'currentValue'
    JS::Rooted<JS::Value> temp(cx);
    nsString const & currentValue = mNamespace;
    if (!xpc::StringToJsval(cx, currentValue, &temp)) {
      return false;
    }
    if (!JS_DefinePropertyById(cx, obj, atomsCache->namespace_id, temp, JSPROP_ENUMERATE)) {
      return false;
    }
    break;
  } while(false);

  return true;
}

void
SanitizerAttributeNamespace::TraceDictionary(JSTracer* trc)
{
}

SanitizerAttributeNamespace&
SanitizerAttributeNamespace::operator=(const SanitizerAttributeNamespace& aOther)
{
  DictionaryBase::operator=(aOther);
  mName = aOther.mName;
  mNamespace = aOther.mNamespace;
  return *this;
}



SanitizerElementNamespace::SanitizerElementNamespace()
{
  // Safe to pass a null context if we pass a null value
  Init(nullptr, JS::NullHandleValue);
}




bool
SanitizerElementNamespace::InitIds(JSContext* cx, SanitizerElementNamespaceAtoms* atomsCache)
{
  MOZ_ASSERT(reinterpret_cast<jsid*>(atomsCache)->isVoid());

  // Initialize these in reverse order so that any failure leaves the first one
  // uninitialized.
  if (!atomsCache->namespace_id.init(cx, "namespace") ||
      !atomsCache->name_id.init(cx, "name")) {
    return false;
  }
  return true;
}

bool
SanitizerElementNamespace::Init(BindingCallContext& cx, JS::Handle<JS::Value> val, const char* sourceDescription, bool passedToJSImpl)
{
  // Passing a null JSContext is OK only if we're initing from null,
  // Since in that case we will not have to do any property gets
  // Also evaluate isNullOrUndefined in order to avoid false-positive
  // checkers by static analysis tools
  MOZ_ASSERT_IF(!cx, val.isNull() && val.isNullOrUndefined());
  SanitizerElementNamespaceAtoms* atomsCache = nullptr;
  if (cx) {
    atomsCache = GetAtomCache<SanitizerElementNamespaceAtoms>(cx);
    if (reinterpret_cast<jsid*>(atomsCache)->isVoid() &&
        !InitIds(cx, atomsCache)) {
      return false;
    }
  }

  if (!IsConvertibleToDictionary(val)) {
    return cx.ThrowErrorMessage<MSG_CONVERSION_ERROR>(sourceDescription, "dictionary");
  }

  bool isNull = val.isNullOrUndefined();
  // We only need these if !isNull, in which case we have |cx|.
  Maybe<JS::Rooted<JSObject *> > object;
  Maybe<JS::Rooted<JS::Value> > temp;
  if (!isNull) {
    MOZ_ASSERT(cx);
    object.emplace(cx, &val.toObject());
    temp.emplace(cx);
  }
  if (!isNull) {
    if (!JS_GetPropertyById(cx, *object, atomsCache->name_id, temp.ptr())) {
      return false;
    }
  }
  if (!isNull && !temp->isUndefined()) {
    if (!ConvertJSValueToString(cx, temp.ref(), eStringify, eStringify, mName)) {
      return false;
    }
    mIsAnyMemberPresent = true;
  } else if (cx) {
    // Don't error out if we have no cx.  In that
    // situation the caller is default-constructing us and we'll
    // just assume they know what they're doing.
    return cx.ThrowErrorMessage<MSG_MISSING_REQUIRED_DICTIONARY_MEMBER>("'name' member of SanitizerElementNamespace");
  }

  if (!isNull) {
    if (!JS_GetPropertyById(cx, *object, atomsCache->namespace_id, temp.ptr())) {
      return false;
    }
  }
  if (!isNull && !temp->isUndefined()) {
    if (!ConvertJSValueToString(cx, temp.ref(), eNull, eNull, mNamespace)) {
      return false;
    }
  } else {
    mNamespace.AssignLiteral(u"http://www.w3.org/1999/xhtml");
  }
  mIsAnyMemberPresent = true;
  return true;
}

bool
SanitizerElementNamespace::Init(JSContext* cx_, JS::Handle<JS::Value> val, const char* sourceDescription, bool passedToJSImpl)
{
  // We don't want to use sourceDescription for our context here;
  // that's not really what it's formatted for.
  BindingCallContext cx(cx_, nullptr);
  return Init(cx, val, sourceDescription, passedToJSImpl);
}

bool
SanitizerElementNamespace::ToObjectInternal(JSContext* cx, JS::MutableHandle<JS::Value> rval) const
{
  SanitizerElementNamespaceAtoms* atomsCache = GetAtomCache<SanitizerElementNamespaceAtoms>(cx);
  if (reinterpret_cast<jsid*>(atomsCache)->isVoid() &&
      !InitIds(cx, atomsCache)) {
    return false;
  }

  JS::Rooted<JSObject*> obj(cx, JS_NewPlainObject(cx));
  if (!obj) {
    return false;
  }
  rval.set(JS::ObjectValue(*obj));

  do {
    // block for our 'break' successCode and scope for 'temp' and 'currentValue'
    JS::Rooted<JS::Value> temp(cx);
    nsString const & currentValue = mName;
    if (!xpc::NonVoidStringToJsval(cx, currentValue, &temp)) {
      return false;
    }
    if (!JS_DefinePropertyById(cx, obj, atomsCache->name_id, temp, JSPROP_ENUMERATE)) {
      return false;
    }
    break;
  } while(false);

  do {
    // block for our 'break' successCode and scope for 'temp' and 'currentValue'
    JS::Rooted<JS::Value> temp(cx);
    nsString const & currentValue = mNamespace;
    if (!xpc::StringToJsval(cx, currentValue, &temp)) {
      return false;
    }
    if (!JS_DefinePropertyById(cx, obj, atomsCache->namespace_id, temp, JSPROP_ENUMERATE)) {
      return false;
    }
    break;
  } while(false);

  return true;
}

void
SanitizerElementNamespace::TraceDictionary(JSTracer* trc)
{
}

SanitizerElementNamespace&
SanitizerElementNamespace::operator=(const SanitizerElementNamespace& aOther)
{
  DictionaryBase::operator=(aOther);
  mName = aOther.mName;
  mNamespace = aOther.mNamespace;
  return *this;
}


bool
StringOrSanitizerAttributeNamespace::TrySetToString(JSContext* cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl)
{
  tryNext = false;
  { // scope for memberSlot
    binding_detail::FakeString<char16_t>& memberSlot = RawSetAsString();
    if (!ConvertJSValueToString(cx, value, eStringify, eStringify, memberSlot)) {
      return false;
    }
  }
  return true;
}








bool
StringOrSanitizerAttributeNamespace::TrySetToSanitizerAttributeNamespace(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl)
{
  tryNext = false;
  { // scope for memberSlot
    binding_detail::FastSanitizerAttributeNamespace& memberSlot = RawSetAsSanitizerAttributeNamespace();
    if (!IsConvertibleToDictionary(value)) {
      DestroySanitizerAttributeNamespace();
      tryNext = true;
      return true;
    }
    if (!memberSlot.Init(cx, value, "SanitizerAttributeNamespace branch of (DOMString or SanitizerAttributeNamespace)", passedToJSImpl)) {
      return false;
    }
  }
  return true;
}

bool
StringOrSanitizerAttributeNamespace::TrySetToSanitizerAttributeNamespace(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl)
{
  BindingCallContext cx(cx_, nullptr);
  return TrySetToSanitizerAttributeNamespace(cx, value, tryNext, passedToJSImpl);
}







bool
StringOrSanitizerAttributeNamespace::Init(BindingCallContext& cx, JS::Handle<JS::Value> value, const char* sourceDescription, bool passedToJSImpl)
{
  MOZ_ASSERT(mType == eUninitialized);

  bool done = false, failed = false, tryNext;
  if (!done) {
    done = (failed = !TrySetToSanitizerAttributeNamespace(cx, value, tryNext, passedToJSImpl)) || !tryNext;
  }
  if (!done) {
    do {
      done = (failed = !TrySetToString(cx, value, tryNext)) || !tryNext;
      break;
    } while (false);
  }
  if (failed) {
    return false;
  }
  if (!done) {
    cx.ThrowErrorMessage<MSG_NOT_IN_UNION>(sourceDescription, "SanitizerAttributeNamespace");
    return false;
  }
  return true;
}

bool
StringOrSanitizerAttributeNamespace::Init(JSContext* cx_, JS::Handle<JS::Value> value, const char* sourceDescription, bool passedToJSImpl)
{
  BindingCallContext cx(cx_, nullptr);
  return Init(cx, value, sourceDescription, passedToJSImpl);
}


bool
StringOrSanitizerAttributeNamespace::ToJSVal(JSContext* cx, JS::Handle<JSObject*> scopeObj, JS::MutableHandle<JS::Value> rval) const
{
  switch (mType) {
    case eUninitialized: {
      return false;
    }
    case eString: {
      if (!xpc::NonVoidStringToJsval(cx, mValue.mString.Value(), rval)) {
        return false;
      }
      return true;
    }
    case eSanitizerAttributeNamespace: {
      if (!mValue.mSanitizerAttributeNamespace.Value().ToObjectInternal(cx, rval)) {
        return false;
      }
      return true;
    }
    default: {
      return false;
    }
  }
}



OwningStringOrSanitizerAttributeNamespace::OwningStringOrSanitizerAttributeNamespace(OwningStringOrSanitizerAttributeNamespace&& aOther)
  : mType(eUninitialized)
{
  switch (aOther.mType) {
    case eUninitialized: {
      MOZ_ASSERT(mType == eUninitialized,
                 "We need to destroy ourselves?");
      break;
    }
    case eString: {
      mType = eString;
      mValue.mString.SetValue(std::move(aOther.mValue.mString.Value()));
      break;
    }
    case eSanitizerAttributeNamespace: {
      mType = eSanitizerAttributeNamespace;
      mValue.mSanitizerAttributeNamespace.SetValue(std::move(aOther.mValue.mSanitizerAttributeNamespace.Value()));
      break;
    }
  }
}



bool
OwningStringOrSanitizerAttributeNamespace::TrySetToString(JSContext* cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl)
{
  tryNext = false;
  { // scope for memberSlot
    nsString& memberSlot = RawSetAsString();
    if (!ConvertJSValueToString(cx, value, eStringify, eStringify, memberSlot)) {
      return false;
    }
  }
  return true;
}

[[nodiscard]] nsString&
OwningStringOrSanitizerAttributeNamespace::RawSetAsString()
{
  if (mType == eString) {
    return mValue.mString.Value();
  }
  MOZ_ASSERT(mType == eUninitialized);
  mType = eString;
  return mValue.mString.SetValue();
}

[[nodiscard]] nsString&
OwningStringOrSanitizerAttributeNamespace::SetAsString()
{
  if (mType == eString) {
    return mValue.mString.Value();
  }
  Uninit();
  mType = eString;
  return mValue.mString.SetValue();
}



void
OwningStringOrSanitizerAttributeNamespace::DestroyString()
{
  MOZ_RELEASE_ASSERT(IsString(), "Wrong type!");
  mValue.mString.Destroy();
  mType = eUninitialized;
}



bool
OwningStringOrSanitizerAttributeNamespace::TrySetToSanitizerAttributeNamespace(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl)
{
  tryNext = false;
  { // scope for memberSlot
    SanitizerAttributeNamespace& memberSlot = RawSetAsSanitizerAttributeNamespace();
    if (!IsConvertibleToDictionary(value)) {
      DestroySanitizerAttributeNamespace();
      tryNext = true;
      return true;
    }
    if (!memberSlot.Init(cx, value, "SanitizerAttributeNamespace branch of (DOMString or SanitizerAttributeNamespace)", passedToJSImpl)) {
      return false;
    }
  }
  return true;
}

bool
OwningStringOrSanitizerAttributeNamespace::TrySetToSanitizerAttributeNamespace(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl)
{
  BindingCallContext cx(cx_, nullptr);
  return TrySetToSanitizerAttributeNamespace(cx, value, tryNext, passedToJSImpl);
}

[[nodiscard]] SanitizerAttributeNamespace&
OwningStringOrSanitizerAttributeNamespace::RawSetAsSanitizerAttributeNamespace()
{
  if (mType == eSanitizerAttributeNamespace) {
    return mValue.mSanitizerAttributeNamespace.Value();
  }
  MOZ_ASSERT(mType == eUninitialized);
  mType = eSanitizerAttributeNamespace;
  return mValue.mSanitizerAttributeNamespace.SetValue();
}

[[nodiscard]] SanitizerAttributeNamespace&
OwningStringOrSanitizerAttributeNamespace::SetAsSanitizerAttributeNamespace()
{
  if (mType == eSanitizerAttributeNamespace) {
    return mValue.mSanitizerAttributeNamespace.Value();
  }
  Uninit();
  mType = eSanitizerAttributeNamespace;
  return mValue.mSanitizerAttributeNamespace.SetValue();
}


void
OwningStringOrSanitizerAttributeNamespace::DestroySanitizerAttributeNamespace()
{
  MOZ_RELEASE_ASSERT(IsSanitizerAttributeNamespace(), "Wrong type!");
  mValue.mSanitizerAttributeNamespace.Destroy();
  mType = eUninitialized;
}



bool
OwningStringOrSanitizerAttributeNamespace::Init(BindingCallContext& cx, JS::Handle<JS::Value> value, const char* sourceDescription, bool passedToJSImpl)
{
  MOZ_ASSERT(mType == eUninitialized);

  bool done = false, failed = false, tryNext;
  if (!done) {
    done = (failed = !TrySetToSanitizerAttributeNamespace(cx, value, tryNext, passedToJSImpl)) || !tryNext;
  }
  if (!done) {
    do {
      done = (failed = !TrySetToString(cx, value, tryNext)) || !tryNext;
      break;
    } while (false);
  }
  if (failed) {
    return false;
  }
  if (!done) {
    cx.ThrowErrorMessage<MSG_NOT_IN_UNION>(sourceDescription, "SanitizerAttributeNamespace");
    return false;
  }
  return true;
}

bool
OwningStringOrSanitizerAttributeNamespace::Init(JSContext* cx_, JS::Handle<JS::Value> value, const char* sourceDescription, bool passedToJSImpl)
{
  BindingCallContext cx(cx_, nullptr);
  return Init(cx, value, sourceDescription, passedToJSImpl);
}

void
OwningStringOrSanitizerAttributeNamespace::Uninit()
{
  switch (mType) {
    case eUninitialized: {
      break;
    }
    case eString: {
      DestroyString();
      break;
    }
    case eSanitizerAttributeNamespace: {
      DestroySanitizerAttributeNamespace();
      break;
    }
  }
}

bool
OwningStringOrSanitizerAttributeNamespace::ToJSVal(JSContext* cx, JS::Handle<JSObject*> scopeObj, JS::MutableHandle<JS::Value> rval) const
{
  switch (mType) {
    case eUninitialized: {
      return false;
    }
    case eString: {
      if (!xpc::NonVoidStringToJsval(cx, mValue.mString.Value(), rval)) {
        return false;
      }
      return true;
    }
    case eSanitizerAttributeNamespace: {
      if (!mValue.mSanitizerAttributeNamespace.Value().ToObjectInternal(cx, rval)) {
        return false;
      }
      return true;
    }
    default: {
      return false;
    }
  }
}

OwningStringOrSanitizerAttributeNamespace&
OwningStringOrSanitizerAttributeNamespace::operator=(OwningStringOrSanitizerAttributeNamespace&& aOther)
{
  this->~OwningStringOrSanitizerAttributeNamespace();
  new (this) OwningStringOrSanitizerAttributeNamespace (std::move(aOther));
  return *this;
}


OwningStringOrSanitizerAttributeNamespace&
OwningStringOrSanitizerAttributeNamespace::operator=(const OwningStringOrSanitizerAttributeNamespace& aOther)
{
  switch (aOther.mType) {
    case eUninitialized: {
      MOZ_ASSERT(mType == eUninitialized,
                 "We need to destroy ourselves?");
      break;
    }
    case eString: {
      SetAsString() = aOther.GetAsString();
      break;
    }
    case eSanitizerAttributeNamespace: {
      SetAsSanitizerAttributeNamespace() = aOther.GetAsSanitizerAttributeNamespace();
      break;
    }
  }
  return *this;
}


bool
StringOrSanitizerElementNamespace::TrySetToString(JSContext* cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl)
{
  tryNext = false;
  { // scope for memberSlot
    binding_detail::FakeString<char16_t>& memberSlot = RawSetAsString();
    if (!ConvertJSValueToString(cx, value, eStringify, eStringify, memberSlot)) {
      return false;
    }
  }
  return true;
}








bool
StringOrSanitizerElementNamespace::TrySetToSanitizerElementNamespace(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl)
{
  tryNext = false;
  { // scope for memberSlot
    binding_detail::FastSanitizerElementNamespace& memberSlot = RawSetAsSanitizerElementNamespace();
    if (!IsConvertibleToDictionary(value)) {
      DestroySanitizerElementNamespace();
      tryNext = true;
      return true;
    }
    if (!memberSlot.Init(cx, value, "SanitizerElementNamespace branch of (DOMString or SanitizerElementNamespace)", passedToJSImpl)) {
      return false;
    }
  }
  return true;
}

bool
StringOrSanitizerElementNamespace::TrySetToSanitizerElementNamespace(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl)
{
  BindingCallContext cx(cx_, nullptr);
  return TrySetToSanitizerElementNamespace(cx, value, tryNext, passedToJSImpl);
}







bool
StringOrSanitizerElementNamespace::Init(BindingCallContext& cx, JS::Handle<JS::Value> value, const char* sourceDescription, bool passedToJSImpl)
{
  MOZ_ASSERT(mType == eUninitialized);

  bool done = false, failed = false, tryNext;
  if (!done) {
    done = (failed = !TrySetToSanitizerElementNamespace(cx, value, tryNext, passedToJSImpl)) || !tryNext;
  }
  if (!done) {
    do {
      done = (failed = !TrySetToString(cx, value, tryNext)) || !tryNext;
      break;
    } while (false);
  }
  if (failed) {
    return false;
  }
  if (!done) {
    cx.ThrowErrorMessage<MSG_NOT_IN_UNION>(sourceDescription, "SanitizerElementNamespace");
    return false;
  }
  return true;
}

bool
StringOrSanitizerElementNamespace::Init(JSContext* cx_, JS::Handle<JS::Value> value, const char* sourceDescription, bool passedToJSImpl)
{
  BindingCallContext cx(cx_, nullptr);
  return Init(cx, value, sourceDescription, passedToJSImpl);
}


bool
StringOrSanitizerElementNamespace::ToJSVal(JSContext* cx, JS::Handle<JSObject*> scopeObj, JS::MutableHandle<JS::Value> rval) const
{
  switch (mType) {
    case eUninitialized: {
      return false;
    }
    case eString: {
      if (!xpc::NonVoidStringToJsval(cx, mValue.mString.Value(), rval)) {
        return false;
      }
      return true;
    }
    case eSanitizerElementNamespace: {
      if (!mValue.mSanitizerElementNamespace.Value().ToObjectInternal(cx, rval)) {
        return false;
      }
      return true;
    }
    default: {
      return false;
    }
  }
}



OwningStringOrSanitizerElementNamespace::OwningStringOrSanitizerElementNamespace(OwningStringOrSanitizerElementNamespace&& aOther)
  : mType(eUninitialized)
{
  switch (aOther.mType) {
    case eUninitialized: {
      MOZ_ASSERT(mType == eUninitialized,
                 "We need to destroy ourselves?");
      break;
    }
    case eString: {
      mType = eString;
      mValue.mString.SetValue(std::move(aOther.mValue.mString.Value()));
      break;
    }
    case eSanitizerElementNamespace: {
      mType = eSanitizerElementNamespace;
      mValue.mSanitizerElementNamespace.SetValue(std::move(aOther.mValue.mSanitizerElementNamespace.Value()));
      break;
    }
  }
}



bool
OwningStringOrSanitizerElementNamespace::TrySetToString(JSContext* cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl)
{
  tryNext = false;
  { // scope for memberSlot
    nsString& memberSlot = RawSetAsString();
    if (!ConvertJSValueToString(cx, value, eStringify, eStringify, memberSlot)) {
      return false;
    }
  }
  return true;
}

[[nodiscard]] nsString&
OwningStringOrSanitizerElementNamespace::RawSetAsString()
{
  if (mType == eString) {
    return mValue.mString.Value();
  }
  MOZ_ASSERT(mType == eUninitialized);
  mType = eString;
  return mValue.mString.SetValue();
}

[[nodiscard]] nsString&
OwningStringOrSanitizerElementNamespace::SetAsString()
{
  if (mType == eString) {
    return mValue.mString.Value();
  }
  Uninit();
  mType = eString;
  return mValue.mString.SetValue();
}



void
OwningStringOrSanitizerElementNamespace::DestroyString()
{
  MOZ_RELEASE_ASSERT(IsString(), "Wrong type!");
  mValue.mString.Destroy();
  mType = eUninitialized;
}



bool
OwningStringOrSanitizerElementNamespace::TrySetToSanitizerElementNamespace(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl)
{
  tryNext = false;
  { // scope for memberSlot
    SanitizerElementNamespace& memberSlot = RawSetAsSanitizerElementNamespace();
    if (!IsConvertibleToDictionary(value)) {
      DestroySanitizerElementNamespace();
      tryNext = true;
      return true;
    }
    if (!memberSlot.Init(cx, value, "SanitizerElementNamespace branch of (DOMString or SanitizerElementNamespace)", passedToJSImpl)) {
      return false;
    }
  }
  return true;
}

bool
OwningStringOrSanitizerElementNamespace::TrySetToSanitizerElementNamespace(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl)
{
  BindingCallContext cx(cx_, nullptr);
  return TrySetToSanitizerElementNamespace(cx, value, tryNext, passedToJSImpl);
}

[[nodiscard]] SanitizerElementNamespace&
OwningStringOrSanitizerElementNamespace::RawSetAsSanitizerElementNamespace()
{
  if (mType == eSanitizerElementNamespace) {
    return mValue.mSanitizerElementNamespace.Value();
  }
  MOZ_ASSERT(mType == eUninitialized);
  mType = eSanitizerElementNamespace;
  return mValue.mSanitizerElementNamespace.SetValue();
}

[[nodiscard]] SanitizerElementNamespace&
OwningStringOrSanitizerElementNamespace::SetAsSanitizerElementNamespace()
{
  if (mType == eSanitizerElementNamespace) {
    return mValue.mSanitizerElementNamespace.Value();
  }
  Uninit();
  mType = eSanitizerElementNamespace;
  return mValue.mSanitizerElementNamespace.SetValue();
}


void
OwningStringOrSanitizerElementNamespace::DestroySanitizerElementNamespace()
{
  MOZ_RELEASE_ASSERT(IsSanitizerElementNamespace(), "Wrong type!");
  mValue.mSanitizerElementNamespace.Destroy();
  mType = eUninitialized;
}



bool
OwningStringOrSanitizerElementNamespace::Init(BindingCallContext& cx, JS::Handle<JS::Value> value, const char* sourceDescription, bool passedToJSImpl)
{
  MOZ_ASSERT(mType == eUninitialized);

  bool done = false, failed = false, tryNext;
  if (!done) {
    done = (failed = !TrySetToSanitizerElementNamespace(cx, value, tryNext, passedToJSImpl)) || !tryNext;
  }
  if (!done) {
    do {
      done = (failed = !TrySetToString(cx, value, tryNext)) || !tryNext;
      break;
    } while (false);
  }
  if (failed) {
    return false;
  }
  if (!done) {
    cx.ThrowErrorMessage<MSG_NOT_IN_UNION>(sourceDescription, "SanitizerElementNamespace");
    return false;
  }
  return true;
}

bool
OwningStringOrSanitizerElementNamespace::Init(JSContext* cx_, JS::Handle<JS::Value> value, const char* sourceDescription, bool passedToJSImpl)
{
  BindingCallContext cx(cx_, nullptr);
  return Init(cx, value, sourceDescription, passedToJSImpl);
}

void
OwningStringOrSanitizerElementNamespace::Uninit()
{
  switch (mType) {
    case eUninitialized: {
      break;
    }
    case eString: {
      DestroyString();
      break;
    }
    case eSanitizerElementNamespace: {
      DestroySanitizerElementNamespace();
      break;
    }
  }
}

bool
OwningStringOrSanitizerElementNamespace::ToJSVal(JSContext* cx, JS::Handle<JSObject*> scopeObj, JS::MutableHandle<JS::Value> rval) const
{
  switch (mType) {
    case eUninitialized: {
      return false;
    }
    case eString: {
      if (!xpc::NonVoidStringToJsval(cx, mValue.mString.Value(), rval)) {
        return false;
      }
      return true;
    }
    case eSanitizerElementNamespace: {
      if (!mValue.mSanitizerElementNamespace.Value().ToObjectInternal(cx, rval)) {
        return false;
      }
      return true;
    }
    default: {
      return false;
    }
  }
}

OwningStringOrSanitizerElementNamespace&
OwningStringOrSanitizerElementNamespace::operator=(OwningStringOrSanitizerElementNamespace&& aOther)
{
  this->~OwningStringOrSanitizerElementNamespace();
  new (this) OwningStringOrSanitizerElementNamespace (std::move(aOther));
  return *this;
}


OwningStringOrSanitizerElementNamespace&
OwningStringOrSanitizerElementNamespace::operator=(const OwningStringOrSanitizerElementNamespace& aOther)
{
  switch (aOther.mType) {
    case eUninitialized: {
      MOZ_ASSERT(mType == eUninitialized,
                 "We need to destroy ourselves?");
      break;
    }
    case eString: {
      SetAsString() = aOther.GetAsString();
      break;
    }
    case eSanitizerElementNamespace: {
      SetAsSanitizerElementNamespace() = aOther.GetAsSanitizerElementNamespace();
      break;
    }
  }
  return *this;
}



SanitizerElementNamespaceWithAttributes::SanitizerElementNamespaceWithAttributes()
  : SanitizerElementNamespace(FastDictionaryInitializer())
{
  // Safe to pass a null context if we pass a null value
  Init(nullptr, JS::NullHandleValue);
}




bool
SanitizerElementNamespaceWithAttributes::InitIds(JSContext* cx, SanitizerElementNamespaceWithAttributesAtoms* atomsCache)
{
  MOZ_ASSERT(reinterpret_cast<jsid*>(atomsCache)->isVoid());

  // Initialize these in reverse order so that any failure leaves the first one
  // uninitialized.
  if (!atomsCache->removeAttributes_id.init(cx, "removeAttributes") ||
      !atomsCache->attributes_id.init(cx, "attributes")) {
    return false;
  }
  return true;
}

bool
SanitizerElementNamespaceWithAttributes::Init(BindingCallContext& cx, JS::Handle<JS::Value> val, const char* sourceDescription, bool passedToJSImpl)
{
  // Passing a null JSContext is OK only if we're initing from null,
  // Since in that case we will not have to do any property gets
  // Also evaluate isNullOrUndefined in order to avoid false-positive
  // checkers by static analysis tools
  MOZ_ASSERT_IF(!cx, val.isNull() && val.isNullOrUndefined());
  SanitizerElementNamespaceWithAttributesAtoms* atomsCache = nullptr;
  if (cx) {
    atomsCache = GetAtomCache<SanitizerElementNamespaceWithAttributesAtoms>(cx);
    if (reinterpret_cast<jsid*>(atomsCache)->isVoid() &&
        !InitIds(cx, atomsCache)) {
      return false;
    }
  }

  // Per spec, we init the parent's members first
  if (!SanitizerElementNamespace::Init(cx, val)) {
    return false;
  }

  bool isNull = val.isNullOrUndefined();
  // We only need these if !isNull, in which case we have |cx|.
  Maybe<JS::Rooted<JSObject *> > object;
  Maybe<JS::Rooted<JS::Value> > temp;
  if (!isNull) {
    MOZ_ASSERT(cx);
    object.emplace(cx, &val.toObject());
    temp.emplace(cx);
  }
  if (!isNull) {
    if (!JS_GetPropertyById(cx, *object, atomsCache->attributes_id, temp.ptr())) {
      return false;
    }
  }
  if (!isNull && !temp->isUndefined()) {
    mAttributes.Construct();
    if (temp.ref().isObject()) {
      JS::ForOfIterator iter(cx);
      if (!iter.init(temp.ref(), JS::ForOfIterator::AllowNonIterable)) {
        return false;
      }
      if (!iter.valueIsIterable()) {
        cx.ThrowErrorMessage<MSG_CONVERSION_ERROR>("'attributes' member of SanitizerElementNamespaceWithAttributes", "sequence");
        return false;
      }
      Sequence<OwningStringOrSanitizerAttributeNamespace> &arr = (mAttributes.Value());
      JS::Rooted<JS::Value> temp(cx);
      while (true) {
        bool done;
        if (!iter.next(&temp, &done)) {
          return false;
        }
        if (done) {
          break;
        }
        OwningStringOrSanitizerAttributeNamespace* slotPtr = arr.AppendElement(mozilla::fallible);
        if (!slotPtr) {
          JS_ReportOutOfMemory(cx);
          return false;
        }
        OwningStringOrSanitizerAttributeNamespace& slot = *slotPtr;
        if (!slot.Init(cx, temp, "Element of 'attributes' member of SanitizerElementNamespaceWithAttributes", passedToJSImpl)) {
          return false;
        }
      }
    } else {
      cx.ThrowErrorMessage<MSG_CONVERSION_ERROR>("'attributes' member of SanitizerElementNamespaceWithAttributes", "sequence");
      return false;
    }
    mIsAnyMemberPresent = true;
  }

  if (!isNull) {
    if (!JS_GetPropertyById(cx, *object, atomsCache->removeAttributes_id, temp.ptr())) {
      return false;
    }
  }
  if (!isNull && !temp->isUndefined()) {
    mRemoveAttributes.Construct();
    if (temp.ref().isObject()) {
      JS::ForOfIterator iter(cx);
      if (!iter.init(temp.ref(), JS::ForOfIterator::AllowNonIterable)) {
        return false;
      }
      if (!iter.valueIsIterable()) {
        cx.ThrowErrorMessage<MSG_CONVERSION_ERROR>("'removeAttributes' member of SanitizerElementNamespaceWithAttributes", "sequence");
        return false;
      }
      Sequence<OwningStringOrSanitizerAttributeNamespace> &arr = (mRemoveAttributes.Value());
      JS::Rooted<JS::Value> temp(cx);
      while (true) {
        bool done;
        if (!iter.next(&temp, &done)) {
          return false;
        }
        if (done) {
          break;
        }
        OwningStringOrSanitizerAttributeNamespace* slotPtr = arr.AppendElement(mozilla::fallible);
        if (!slotPtr) {
          JS_ReportOutOfMemory(cx);
          return false;
        }
        OwningStringOrSanitizerAttributeNamespace& slot = *slotPtr;
        if (!slot.Init(cx, temp, "Element of 'removeAttributes' member of SanitizerElementNamespaceWithAttributes", passedToJSImpl)) {
          return false;
        }
      }
    } else {
      cx.ThrowErrorMessage<MSG_CONVERSION_ERROR>("'removeAttributes' member of SanitizerElementNamespaceWithAttributes", "sequence");
      return false;
    }
    mIsAnyMemberPresent = true;
  }
  return true;
}

bool
SanitizerElementNamespaceWithAttributes::Init(JSContext* cx_, JS::Handle<JS::Value> val, const char* sourceDescription, bool passedToJSImpl)
{
  // We don't want to use sourceDescription for our context here;
  // that's not really what it's formatted for.
  BindingCallContext cx(cx_, nullptr);
  return Init(cx, val, sourceDescription, passedToJSImpl);
}

bool
SanitizerElementNamespaceWithAttributes::ToObjectInternal(JSContext* cx, JS::MutableHandle<JS::Value> rval) const
{
  SanitizerElementNamespaceWithAttributesAtoms* atomsCache = GetAtomCache<SanitizerElementNamespaceWithAttributesAtoms>(cx);
  if (reinterpret_cast<jsid*>(atomsCache)->isVoid() &&
      !InitIds(cx, atomsCache)) {
    return false;
  }

  // Per spec, we define the parent's members first
  if (!SanitizerElementNamespace::ToObjectInternal(cx, rval)) {
    return false;
  }
  JS::Rooted<JSObject*> obj(cx, &rval.toObject());

  if (mAttributes.WasPassed()) {
    do {
      // block for our 'break' successCode and scope for 'temp' and 'currentValue'
      JS::Rooted<JS::Value> temp(cx);
      Sequence<OwningStringOrSanitizerAttributeNamespace> const & currentValue = mAttributes.InternalValue();

      uint32_t length = currentValue.Length();
      JS::Rooted<JSObject*> returnArray(cx, JS::NewArrayObject(cx, length));
      if (!returnArray) {
        return false;
      }
      // Scope for 'tmp'
      {
        JS::Rooted<JS::Value> tmp(cx);
        for (uint32_t sequenceIdx0 = 0; sequenceIdx0 < length; ++sequenceIdx0) {
          // Control block to let us common up the JS_DefineElement calls when there
          // are different ways to succeed at wrapping the object.
          do {
            if (!currentValue[sequenceIdx0].ToJSVal(cx, returnArray, &tmp)) {
              return false;
            }
            break;
          } while (false);
          if (!JS_DefineElement(cx, returnArray, sequenceIdx0, tmp,
                                JSPROP_ENUMERATE)) {
            return false;
          }
        }
      }
      temp.setObject(*returnArray);
      if (!JS_DefinePropertyById(cx, obj, atomsCache->attributes_id, temp, JSPROP_ENUMERATE)) {
        return false;
      }
      break;
    } while(false);
  }

  if (mRemoveAttributes.WasPassed()) {
    do {
      // block for our 'break' successCode and scope for 'temp' and 'currentValue'
      JS::Rooted<JS::Value> temp(cx);
      Sequence<OwningStringOrSanitizerAttributeNamespace> const & currentValue = mRemoveAttributes.InternalValue();

      uint32_t length = currentValue.Length();
      JS::Rooted<JSObject*> returnArray(cx, JS::NewArrayObject(cx, length));
      if (!returnArray) {
        return false;
      }
      // Scope for 'tmp'
      {
        JS::Rooted<JS::Value> tmp(cx);
        for (uint32_t sequenceIdx0 = 0; sequenceIdx0 < length; ++sequenceIdx0) {
          // Control block to let us common up the JS_DefineElement calls when there
          // are different ways to succeed at wrapping the object.
          do {
            if (!currentValue[sequenceIdx0].ToJSVal(cx, returnArray, &tmp)) {
              return false;
            }
            break;
          } while (false);
          if (!JS_DefineElement(cx, returnArray, sequenceIdx0, tmp,
                                JSPROP_ENUMERATE)) {
            return false;
          }
        }
      }
      temp.setObject(*returnArray);
      if (!JS_DefinePropertyById(cx, obj, atomsCache->removeAttributes_id, temp, JSPROP_ENUMERATE)) {
        return false;
      }
      break;
    } while(false);
  }

  return true;
}

void
SanitizerElementNamespaceWithAttributes::TraceDictionary(JSTracer* trc)
{
  SanitizerElementNamespace::TraceDictionary(trc);
}

SanitizerElementNamespaceWithAttributes&
SanitizerElementNamespaceWithAttributes::operator=(const SanitizerElementNamespaceWithAttributes& aOther)
{
  SanitizerElementNamespace::operator=(aOther);
  mAttributes.Reset();
  if (aOther.mAttributes.WasPassed()) {
    mAttributes.Construct(aOther.mAttributes.Value());
  }
  mRemoveAttributes.Reset();
  if (aOther.mRemoveAttributes.WasPassed()) {
    mRemoveAttributes.Construct(aOther.mRemoveAttributes.Value());
  }
  return *this;
}


bool
StringOrSanitizerElementNamespaceWithAttributes::TrySetToString(JSContext* cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl)
{
  tryNext = false;
  { // scope for memberSlot
    binding_detail::FakeString<char16_t>& memberSlot = RawSetAsString();
    if (!ConvertJSValueToString(cx, value, eStringify, eStringify, memberSlot)) {
      return false;
    }
  }
  return true;
}








bool
StringOrSanitizerElementNamespaceWithAttributes::TrySetToSanitizerElementNamespaceWithAttributes(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl)
{
  tryNext = false;
  { // scope for memberSlot
    binding_detail::FastSanitizerElementNamespaceWithAttributes& memberSlot = RawSetAsSanitizerElementNamespaceWithAttributes();
    if (!IsConvertibleToDictionary(value)) {
      DestroySanitizerElementNamespaceWithAttributes();
      tryNext = true;
      return true;
    }
    if (!memberSlot.Init(cx, value, "SanitizerElementNamespaceWithAttributes branch of (DOMString or SanitizerElementNamespaceWithAttributes)", passedToJSImpl)) {
      return false;
    }
  }
  return true;
}

bool
StringOrSanitizerElementNamespaceWithAttributes::TrySetToSanitizerElementNamespaceWithAttributes(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl)
{
  BindingCallContext cx(cx_, nullptr);
  return TrySetToSanitizerElementNamespaceWithAttributes(cx, value, tryNext, passedToJSImpl);
}







bool
StringOrSanitizerElementNamespaceWithAttributes::Init(BindingCallContext& cx, JS::Handle<JS::Value> value, const char* sourceDescription, bool passedToJSImpl)
{
  MOZ_ASSERT(mType == eUninitialized);

  bool done = false, failed = false, tryNext;
  if (!done) {
    done = (failed = !TrySetToSanitizerElementNamespaceWithAttributes(cx, value, tryNext, passedToJSImpl)) || !tryNext;
  }
  if (!done) {
    do {
      done = (failed = !TrySetToString(cx, value, tryNext)) || !tryNext;
      break;
    } while (false);
  }
  if (failed) {
    return false;
  }
  if (!done) {
    cx.ThrowErrorMessage<MSG_NOT_IN_UNION>(sourceDescription, "SanitizerElementNamespaceWithAttributes");
    return false;
  }
  return true;
}

bool
StringOrSanitizerElementNamespaceWithAttributes::Init(JSContext* cx_, JS::Handle<JS::Value> value, const char* sourceDescription, bool passedToJSImpl)
{
  BindingCallContext cx(cx_, nullptr);
  return Init(cx, value, sourceDescription, passedToJSImpl);
}


bool
StringOrSanitizerElementNamespaceWithAttributes::ToJSVal(JSContext* cx, JS::Handle<JSObject*> scopeObj, JS::MutableHandle<JS::Value> rval) const
{
  switch (mType) {
    case eUninitialized: {
      return false;
    }
    case eString: {
      if (!xpc::NonVoidStringToJsval(cx, mValue.mString.Value(), rval)) {
        return false;
      }
      return true;
    }
    case eSanitizerElementNamespaceWithAttributes: {
      if (!mValue.mSanitizerElementNamespaceWithAttributes.Value().ToObjectInternal(cx, rval)) {
        return false;
      }
      return true;
    }
    default: {
      return false;
    }
  }
}



OwningStringOrSanitizerElementNamespaceWithAttributes::OwningStringOrSanitizerElementNamespaceWithAttributes(OwningStringOrSanitizerElementNamespaceWithAttributes&& aOther)
  : mType(eUninitialized)
{
  switch (aOther.mType) {
    case eUninitialized: {
      MOZ_ASSERT(mType == eUninitialized,
                 "We need to destroy ourselves?");
      break;
    }
    case eString: {
      mType = eString;
      mValue.mString.SetValue(std::move(aOther.mValue.mString.Value()));
      break;
    }
    case eSanitizerElementNamespaceWithAttributes: {
      mType = eSanitizerElementNamespaceWithAttributes;
      mValue.mSanitizerElementNamespaceWithAttributes.SetValue(std::move(aOther.mValue.mSanitizerElementNamespaceWithAttributes.Value()));
      break;
    }
  }
}



bool
OwningStringOrSanitizerElementNamespaceWithAttributes::TrySetToString(JSContext* cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl)
{
  tryNext = false;
  { // scope for memberSlot
    nsString& memberSlot = RawSetAsString();
    if (!ConvertJSValueToString(cx, value, eStringify, eStringify, memberSlot)) {
      return false;
    }
  }
  return true;
}

[[nodiscard]] nsString&
OwningStringOrSanitizerElementNamespaceWithAttributes::RawSetAsString()
{
  if (mType == eString) {
    return mValue.mString.Value();
  }
  MOZ_ASSERT(mType == eUninitialized);
  mType = eString;
  return mValue.mString.SetValue();
}

[[nodiscard]] nsString&
OwningStringOrSanitizerElementNamespaceWithAttributes::SetAsString()
{
  if (mType == eString) {
    return mValue.mString.Value();
  }
  Uninit();
  mType = eString;
  return mValue.mString.SetValue();
}



void
OwningStringOrSanitizerElementNamespaceWithAttributes::DestroyString()
{
  MOZ_RELEASE_ASSERT(IsString(), "Wrong type!");
  mValue.mString.Destroy();
  mType = eUninitialized;
}



bool
OwningStringOrSanitizerElementNamespaceWithAttributes::TrySetToSanitizerElementNamespaceWithAttributes(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl)
{
  tryNext = false;
  { // scope for memberSlot
    SanitizerElementNamespaceWithAttributes& memberSlot = RawSetAsSanitizerElementNamespaceWithAttributes();
    if (!IsConvertibleToDictionary(value)) {
      DestroySanitizerElementNamespaceWithAttributes();
      tryNext = true;
      return true;
    }
    if (!memberSlot.Init(cx, value, "SanitizerElementNamespaceWithAttributes branch of (DOMString or SanitizerElementNamespaceWithAttributes)", passedToJSImpl)) {
      return false;
    }
  }
  return true;
}

bool
OwningStringOrSanitizerElementNamespaceWithAttributes::TrySetToSanitizerElementNamespaceWithAttributes(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl)
{
  BindingCallContext cx(cx_, nullptr);
  return TrySetToSanitizerElementNamespaceWithAttributes(cx, value, tryNext, passedToJSImpl);
}

[[nodiscard]] SanitizerElementNamespaceWithAttributes&
OwningStringOrSanitizerElementNamespaceWithAttributes::RawSetAsSanitizerElementNamespaceWithAttributes()
{
  if (mType == eSanitizerElementNamespaceWithAttributes) {
    return mValue.mSanitizerElementNamespaceWithAttributes.Value();
  }
  MOZ_ASSERT(mType == eUninitialized);
  mType = eSanitizerElementNamespaceWithAttributes;
  return mValue.mSanitizerElementNamespaceWithAttributes.SetValue();
}

[[nodiscard]] SanitizerElementNamespaceWithAttributes&
OwningStringOrSanitizerElementNamespaceWithAttributes::SetAsSanitizerElementNamespaceWithAttributes()
{
  if (mType == eSanitizerElementNamespaceWithAttributes) {
    return mValue.mSanitizerElementNamespaceWithAttributes.Value();
  }
  Uninit();
  mType = eSanitizerElementNamespaceWithAttributes;
  return mValue.mSanitizerElementNamespaceWithAttributes.SetValue();
}


void
OwningStringOrSanitizerElementNamespaceWithAttributes::DestroySanitizerElementNamespaceWithAttributes()
{
  MOZ_RELEASE_ASSERT(IsSanitizerElementNamespaceWithAttributes(), "Wrong type!");
  mValue.mSanitizerElementNamespaceWithAttributes.Destroy();
  mType = eUninitialized;
}



bool
OwningStringOrSanitizerElementNamespaceWithAttributes::Init(BindingCallContext& cx, JS::Handle<JS::Value> value, const char* sourceDescription, bool passedToJSImpl)
{
  MOZ_ASSERT(mType == eUninitialized);

  bool done = false, failed = false, tryNext;
  if (!done) {
    done = (failed = !TrySetToSanitizerElementNamespaceWithAttributes(cx, value, tryNext, passedToJSImpl)) || !tryNext;
  }
  if (!done) {
    do {
      done = (failed = !TrySetToString(cx, value, tryNext)) || !tryNext;
      break;
    } while (false);
  }
  if (failed) {
    return false;
  }
  if (!done) {
    cx.ThrowErrorMessage<MSG_NOT_IN_UNION>(sourceDescription, "SanitizerElementNamespaceWithAttributes");
    return false;
  }
  return true;
}

bool
OwningStringOrSanitizerElementNamespaceWithAttributes::Init(JSContext* cx_, JS::Handle<JS::Value> value, const char* sourceDescription, bool passedToJSImpl)
{
  BindingCallContext cx(cx_, nullptr);
  return Init(cx, value, sourceDescription, passedToJSImpl);
}

void
OwningStringOrSanitizerElementNamespaceWithAttributes::Uninit()
{
  switch (mType) {
    case eUninitialized: {
      break;
    }
    case eString: {
      DestroyString();
      break;
    }
    case eSanitizerElementNamespaceWithAttributes: {
      DestroySanitizerElementNamespaceWithAttributes();
      break;
    }
  }
}

bool
OwningStringOrSanitizerElementNamespaceWithAttributes::ToJSVal(JSContext* cx, JS::Handle<JSObject*> scopeObj, JS::MutableHandle<JS::Value> rval) const
{
  switch (mType) {
    case eUninitialized: {
      return false;
    }
    case eString: {
      if (!xpc::NonVoidStringToJsval(cx, mValue.mString.Value(), rval)) {
        return false;
      }
      return true;
    }
    case eSanitizerElementNamespaceWithAttributes: {
      if (!mValue.mSanitizerElementNamespaceWithAttributes.Value().ToObjectInternal(cx, rval)) {
        return false;
      }
      return true;
    }
    default: {
      return false;
    }
  }
}

OwningStringOrSanitizerElementNamespaceWithAttributes&
OwningStringOrSanitizerElementNamespaceWithAttributes::operator=(OwningStringOrSanitizerElementNamespaceWithAttributes&& aOther)
{
  this->~OwningStringOrSanitizerElementNamespaceWithAttributes();
  new (this) OwningStringOrSanitizerElementNamespaceWithAttributes (std::move(aOther));
  return *this;
}


OwningStringOrSanitizerElementNamespaceWithAttributes&
OwningStringOrSanitizerElementNamespaceWithAttributes::operator=(const OwningStringOrSanitizerElementNamespaceWithAttributes& aOther)
{
  switch (aOther.mType) {
    case eUninitialized: {
      MOZ_ASSERT(mType == eUninitialized,
                 "We need to destroy ourselves?");
      break;
    }
    case eString: {
      SetAsString() = aOther.GetAsString();
      break;
    }
    case eSanitizerElementNamespaceWithAttributes: {
      SetAsSanitizerElementNamespaceWithAttributes() = aOther.GetAsSanitizerElementNamespaceWithAttributes();
      break;
    }
  }
  return *this;
}



SanitizerConfig::SanitizerConfig()
{
  // Safe to pass a null context if we pass a null value
  Init(nullptr, JS::NullHandleValue);
}




bool
SanitizerConfig::InitIds(JSContext* cx, SanitizerConfigAtoms* atomsCache)
{
  MOZ_ASSERT(reinterpret_cast<jsid*>(atomsCache)->isVoid());

  // Initialize these in reverse order so that any failure leaves the first one
  // uninitialized.
  if (!atomsCache->replaceWithChildrenElements_id.init(cx, "replaceWithChildrenElements") ||
      !atomsCache->removeElements_id.init(cx, "removeElements") ||
      !atomsCache->removeAttributes_id.init(cx, "removeAttributes") ||
      !atomsCache->elements_id.init(cx, "elements") ||
      !atomsCache->dataAttributes_id.init(cx, "dataAttributes") ||
      !atomsCache->comments_id.init(cx, "comments") ||
      !atomsCache->attributes_id.init(cx, "attributes")) {
    return false;
  }
  return true;
}

bool
SanitizerConfig::Init(BindingCallContext& cx, JS::Handle<JS::Value> val, const char* sourceDescription, bool passedToJSImpl)
{
  // Passing a null JSContext is OK only if we're initing from null,
  // Since in that case we will not have to do any property gets
  // Also evaluate isNullOrUndefined in order to avoid false-positive
  // checkers by static analysis tools
  MOZ_ASSERT_IF(!cx, val.isNull() && val.isNullOrUndefined());
  SanitizerConfigAtoms* atomsCache = nullptr;
  if (cx) {
    atomsCache = GetAtomCache<SanitizerConfigAtoms>(cx);
    if (reinterpret_cast<jsid*>(atomsCache)->isVoid() &&
        !InitIds(cx, atomsCache)) {
      return false;
    }
  }

  if (!IsConvertibleToDictionary(val)) {
    return cx.ThrowErrorMessage<MSG_CONVERSION_ERROR>(sourceDescription, "dictionary");
  }

  bool isNull = val.isNullOrUndefined();
  // We only need these if !isNull, in which case we have |cx|.
  Maybe<JS::Rooted<JSObject *> > object;
  Maybe<JS::Rooted<JS::Value> > temp;
  if (!isNull) {
    MOZ_ASSERT(cx);
    object.emplace(cx, &val.toObject());
    temp.emplace(cx);
  }
  if (!isNull) {
    if (!JS_GetPropertyById(cx, *object, atomsCache->attributes_id, temp.ptr())) {
      return false;
    }
  }
  if (!isNull && !temp->isUndefined()) {
    mAttributes.Construct();
    if (temp.ref().isObject()) {
      JS::ForOfIterator iter(cx);
      if (!iter.init(temp.ref(), JS::ForOfIterator::AllowNonIterable)) {
        return false;
      }
      if (!iter.valueIsIterable()) {
        cx.ThrowErrorMessage<MSG_CONVERSION_ERROR>("'attributes' member of SanitizerConfig", "sequence");
        return false;
      }
      Sequence<OwningStringOrSanitizerAttributeNamespace> &arr = (mAttributes.Value());
      JS::Rooted<JS::Value> temp(cx);
      while (true) {
        bool done;
        if (!iter.next(&temp, &done)) {
          return false;
        }
        if (done) {
          break;
        }
        OwningStringOrSanitizerAttributeNamespace* slotPtr = arr.AppendElement(mozilla::fallible);
        if (!slotPtr) {
          JS_ReportOutOfMemory(cx);
          return false;
        }
        OwningStringOrSanitizerAttributeNamespace& slot = *slotPtr;
        if (!slot.Init(cx, temp, "Element of 'attributes' member of SanitizerConfig", passedToJSImpl)) {
          return false;
        }
      }
    } else {
      cx.ThrowErrorMessage<MSG_CONVERSION_ERROR>("'attributes' member of SanitizerConfig", "sequence");
      return false;
    }
    mIsAnyMemberPresent = true;
  }

  if (!isNull) {
    if (!JS_GetPropertyById(cx, *object, atomsCache->comments_id, temp.ptr())) {
      return false;
    }
  }
  if (!isNull && !temp->isUndefined()) {
    mComments.Construct();
    if (!ValueToPrimitive<bool, eDefault>(cx, temp.ref(), "'comments' member of SanitizerConfig", &(mComments.Value()))) {
      return false;
    }
    mIsAnyMemberPresent = true;
  }

  if (!isNull) {
    if (!JS_GetPropertyById(cx, *object, atomsCache->dataAttributes_id, temp.ptr())) {
      return false;
    }
  }
  if (!isNull && !temp->isUndefined()) {
    mDataAttributes.Construct();
    if (!ValueToPrimitive<bool, eDefault>(cx, temp.ref(), "'dataAttributes' member of SanitizerConfig", &(mDataAttributes.Value()))) {
      return false;
    }
    mIsAnyMemberPresent = true;
  }

  if (!isNull) {
    if (!JS_GetPropertyById(cx, *object, atomsCache->elements_id, temp.ptr())) {
      return false;
    }
  }
  if (!isNull && !temp->isUndefined()) {
    mElements.Construct();
    if (temp.ref().isObject()) {
      JS::ForOfIterator iter(cx);
      if (!iter.init(temp.ref(), JS::ForOfIterator::AllowNonIterable)) {
        return false;
      }
      if (!iter.valueIsIterable()) {
        cx.ThrowErrorMessage<MSG_CONVERSION_ERROR>("'elements' member of SanitizerConfig", "sequence");
        return false;
      }
      Sequence<OwningStringOrSanitizerElementNamespaceWithAttributes> &arr = (mElements.Value());
      JS::Rooted<JS::Value> temp(cx);
      while (true) {
        bool done;
        if (!iter.next(&temp, &done)) {
          return false;
        }
        if (done) {
          break;
        }
        OwningStringOrSanitizerElementNamespaceWithAttributes* slotPtr = arr.AppendElement(mozilla::fallible);
        if (!slotPtr) {
          JS_ReportOutOfMemory(cx);
          return false;
        }
        OwningStringOrSanitizerElementNamespaceWithAttributes& slot = *slotPtr;
        if (!slot.Init(cx, temp, "Element of 'elements' member of SanitizerConfig", passedToJSImpl)) {
          return false;
        }
      }
    } else {
      cx.ThrowErrorMessage<MSG_CONVERSION_ERROR>("'elements' member of SanitizerConfig", "sequence");
      return false;
    }
    mIsAnyMemberPresent = true;
  }

  if (!isNull) {
    if (!JS_GetPropertyById(cx, *object, atomsCache->removeAttributes_id, temp.ptr())) {
      return false;
    }
  }
  if (!isNull && !temp->isUndefined()) {
    mRemoveAttributes.Construct();
    if (temp.ref().isObject()) {
      JS::ForOfIterator iter(cx);
      if (!iter.init(temp.ref(), JS::ForOfIterator::AllowNonIterable)) {
        return false;
      }
      if (!iter.valueIsIterable()) {
        cx.ThrowErrorMessage<MSG_CONVERSION_ERROR>("'removeAttributes' member of SanitizerConfig", "sequence");
        return false;
      }
      Sequence<OwningStringOrSanitizerAttributeNamespace> &arr = (mRemoveAttributes.Value());
      JS::Rooted<JS::Value> temp(cx);
      while (true) {
        bool done;
        if (!iter.next(&temp, &done)) {
          return false;
        }
        if (done) {
          break;
        }
        OwningStringOrSanitizerAttributeNamespace* slotPtr = arr.AppendElement(mozilla::fallible);
        if (!slotPtr) {
          JS_ReportOutOfMemory(cx);
          return false;
        }
        OwningStringOrSanitizerAttributeNamespace& slot = *slotPtr;
        if (!slot.Init(cx, temp, "Element of 'removeAttributes' member of SanitizerConfig", passedToJSImpl)) {
          return false;
        }
      }
    } else {
      cx.ThrowErrorMessage<MSG_CONVERSION_ERROR>("'removeAttributes' member of SanitizerConfig", "sequence");
      return false;
    }
    mIsAnyMemberPresent = true;
  }

  if (!isNull) {
    if (!JS_GetPropertyById(cx, *object, atomsCache->removeElements_id, temp.ptr())) {
      return false;
    }
  }
  if (!isNull && !temp->isUndefined()) {
    mRemoveElements.Construct();
    if (temp.ref().isObject()) {
      JS::ForOfIterator iter(cx);
      if (!iter.init(temp.ref(), JS::ForOfIterator::AllowNonIterable)) {
        return false;
      }
      if (!iter.valueIsIterable()) {
        cx.ThrowErrorMessage<MSG_CONVERSION_ERROR>("'removeElements' member of SanitizerConfig", "sequence");
        return false;
      }
      Sequence<OwningStringOrSanitizerElementNamespace> &arr = (mRemoveElements.Value());
      JS::Rooted<JS::Value> temp(cx);
      while (true) {
        bool done;
        if (!iter.next(&temp, &done)) {
          return false;
        }
        if (done) {
          break;
        }
        OwningStringOrSanitizerElementNamespace* slotPtr = arr.AppendElement(mozilla::fallible);
        if (!slotPtr) {
          JS_ReportOutOfMemory(cx);
          return false;
        }
        OwningStringOrSanitizerElementNamespace& slot = *slotPtr;
        if (!slot.Init(cx, temp, "Element of 'removeElements' member of SanitizerConfig", passedToJSImpl)) {
          return false;
        }
      }
    } else {
      cx.ThrowErrorMessage<MSG_CONVERSION_ERROR>("'removeElements' member of SanitizerConfig", "sequence");
      return false;
    }
    mIsAnyMemberPresent = true;
  }

  if (!isNull) {
    if (!JS_GetPropertyById(cx, *object, atomsCache->replaceWithChildrenElements_id, temp.ptr())) {
      return false;
    }
  }
  if (!isNull && !temp->isUndefined()) {
    mReplaceWithChildrenElements.Construct();
    if (temp.ref().isObject()) {
      JS::ForOfIterator iter(cx);
      if (!iter.init(temp.ref(), JS::ForOfIterator::AllowNonIterable)) {
        return false;
      }
      if (!iter.valueIsIterable()) {
        cx.ThrowErrorMessage<MSG_CONVERSION_ERROR>("'replaceWithChildrenElements' member of SanitizerConfig", "sequence");
        return false;
      }
      Sequence<OwningStringOrSanitizerElementNamespace> &arr = (mReplaceWithChildrenElements.Value());
      JS::Rooted<JS::Value> temp(cx);
      while (true) {
        bool done;
        if (!iter.next(&temp, &done)) {
          return false;
        }
        if (done) {
          break;
        }
        OwningStringOrSanitizerElementNamespace* slotPtr = arr.AppendElement(mozilla::fallible);
        if (!slotPtr) {
          JS_ReportOutOfMemory(cx);
          return false;
        }
        OwningStringOrSanitizerElementNamespace& slot = *slotPtr;
        if (!slot.Init(cx, temp, "Element of 'replaceWithChildrenElements' member of SanitizerConfig", passedToJSImpl)) {
          return false;
        }
      }
    } else {
      cx.ThrowErrorMessage<MSG_CONVERSION_ERROR>("'replaceWithChildrenElements' member of SanitizerConfig", "sequence");
      return false;
    }
    mIsAnyMemberPresent = true;
  }
  return true;
}

bool
SanitizerConfig::Init(JSContext* cx_, JS::Handle<JS::Value> val, const char* sourceDescription, bool passedToJSImpl)
{
  // We don't want to use sourceDescription for our context here;
  // that's not really what it's formatted for.
  BindingCallContext cx(cx_, nullptr);
  return Init(cx, val, sourceDescription, passedToJSImpl);
}

bool
SanitizerConfig::ToObjectInternal(JSContext* cx, JS::MutableHandle<JS::Value> rval) const
{
  SanitizerConfigAtoms* atomsCache = GetAtomCache<SanitizerConfigAtoms>(cx);
  if (reinterpret_cast<jsid*>(atomsCache)->isVoid() &&
      !InitIds(cx, atomsCache)) {
    return false;
  }

  JS::Rooted<JSObject*> obj(cx, JS_NewPlainObject(cx));
  if (!obj) {
    return false;
  }
  rval.set(JS::ObjectValue(*obj));

  if (mAttributes.WasPassed()) {
    do {
      // block for our 'break' successCode and scope for 'temp' and 'currentValue'
      JS::Rooted<JS::Value> temp(cx);
      Sequence<OwningStringOrSanitizerAttributeNamespace> const & currentValue = mAttributes.InternalValue();

      uint32_t length = currentValue.Length();
      JS::Rooted<JSObject*> returnArray(cx, JS::NewArrayObject(cx, length));
      if (!returnArray) {
        return false;
      }
      // Scope for 'tmp'
      {
        JS::Rooted<JS::Value> tmp(cx);
        for (uint32_t sequenceIdx0 = 0; sequenceIdx0 < length; ++sequenceIdx0) {
          // Control block to let us common up the JS_DefineElement calls when there
          // are different ways to succeed at wrapping the object.
          do {
            if (!currentValue[sequenceIdx0].ToJSVal(cx, returnArray, &tmp)) {
              return false;
            }
            break;
          } while (false);
          if (!JS_DefineElement(cx, returnArray, sequenceIdx0, tmp,
                                JSPROP_ENUMERATE)) {
            return false;
          }
        }
      }
      temp.setObject(*returnArray);
      if (!JS_DefinePropertyById(cx, obj, atomsCache->attributes_id, temp, JSPROP_ENUMERATE)) {
        return false;
      }
      break;
    } while(false);
  }

  if (mComments.WasPassed()) {
    do {
      // block for our 'break' successCode and scope for 'temp' and 'currentValue'
      JS::Rooted<JS::Value> temp(cx);
      bool const & currentValue = mComments.InternalValue();
      temp.setBoolean(currentValue);
      if (!JS_DefinePropertyById(cx, obj, atomsCache->comments_id, temp, JSPROP_ENUMERATE)) {
        return false;
      }
      break;
    } while(false);
  }

  if (mDataAttributes.WasPassed()) {
    do {
      // block for our 'break' successCode and scope for 'temp' and 'currentValue'
      JS::Rooted<JS::Value> temp(cx);
      bool const & currentValue = mDataAttributes.InternalValue();
      temp.setBoolean(currentValue);
      if (!JS_DefinePropertyById(cx, obj, atomsCache->dataAttributes_id, temp, JSPROP_ENUMERATE)) {
        return false;
      }
      break;
    } while(false);
  }

  if (mElements.WasPassed()) {
    do {
      // block for our 'break' successCode and scope for 'temp' and 'currentValue'
      JS::Rooted<JS::Value> temp(cx);
      Sequence<OwningStringOrSanitizerElementNamespaceWithAttributes> const & currentValue = mElements.InternalValue();

      uint32_t length = currentValue.Length();
      JS::Rooted<JSObject*> returnArray(cx, JS::NewArrayObject(cx, length));
      if (!returnArray) {
        return false;
      }
      // Scope for 'tmp'
      {
        JS::Rooted<JS::Value> tmp(cx);
        for (uint32_t sequenceIdx0 = 0; sequenceIdx0 < length; ++sequenceIdx0) {
          // Control block to let us common up the JS_DefineElement calls when there
          // are different ways to succeed at wrapping the object.
          do {
            if (!currentValue[sequenceIdx0].ToJSVal(cx, returnArray, &tmp)) {
              return false;
            }
            break;
          } while (false);
          if (!JS_DefineElement(cx, returnArray, sequenceIdx0, tmp,
                                JSPROP_ENUMERATE)) {
            return false;
          }
        }
      }
      temp.setObject(*returnArray);
      if (!JS_DefinePropertyById(cx, obj, atomsCache->elements_id, temp, JSPROP_ENUMERATE)) {
        return false;
      }
      break;
    } while(false);
  }

  if (mRemoveAttributes.WasPassed()) {
    do {
      // block for our 'break' successCode and scope for 'temp' and 'currentValue'
      JS::Rooted<JS::Value> temp(cx);
      Sequence<OwningStringOrSanitizerAttributeNamespace> const & currentValue = mRemoveAttributes.InternalValue();

      uint32_t length = currentValue.Length();
      JS::Rooted<JSObject*> returnArray(cx, JS::NewArrayObject(cx, length));
      if (!returnArray) {
        return false;
      }
      // Scope for 'tmp'
      {
        JS::Rooted<JS::Value> tmp(cx);
        for (uint32_t sequenceIdx0 = 0; sequenceIdx0 < length; ++sequenceIdx0) {
          // Control block to let us common up the JS_DefineElement calls when there
          // are different ways to succeed at wrapping the object.
          do {
            if (!currentValue[sequenceIdx0].ToJSVal(cx, returnArray, &tmp)) {
              return false;
            }
            break;
          } while (false);
          if (!JS_DefineElement(cx, returnArray, sequenceIdx0, tmp,
                                JSPROP_ENUMERATE)) {
            return false;
          }
        }
      }
      temp.setObject(*returnArray);
      if (!JS_DefinePropertyById(cx, obj, atomsCache->removeAttributes_id, temp, JSPROP_ENUMERATE)) {
        return false;
      }
      break;
    } while(false);
  }

  if (mRemoveElements.WasPassed()) {
    do {
      // block for our 'break' successCode and scope for 'temp' and 'currentValue'
      JS::Rooted<JS::Value> temp(cx);
      Sequence<OwningStringOrSanitizerElementNamespace> const & currentValue = mRemoveElements.InternalValue();

      uint32_t length = currentValue.Length();
      JS::Rooted<JSObject*> returnArray(cx, JS::NewArrayObject(cx, length));
      if (!returnArray) {
        return false;
      }
      // Scope for 'tmp'
      {
        JS::Rooted<JS::Value> tmp(cx);
        for (uint32_t sequenceIdx0 = 0; sequenceIdx0 < length; ++sequenceIdx0) {
          // Control block to let us common up the JS_DefineElement calls when there
          // are different ways to succeed at wrapping the object.
          do {
            if (!currentValue[sequenceIdx0].ToJSVal(cx, returnArray, &tmp)) {
              return false;
            }
            break;
          } while (false);
          if (!JS_DefineElement(cx, returnArray, sequenceIdx0, tmp,
                                JSPROP_ENUMERATE)) {
            return false;
          }
        }
      }
      temp.setObject(*returnArray);
      if (!JS_DefinePropertyById(cx, obj, atomsCache->removeElements_id, temp, JSPROP_ENUMERATE)) {
        return false;
      }
      break;
    } while(false);
  }

  if (mReplaceWithChildrenElements.WasPassed()) {
    do {
      // block for our 'break' successCode and scope for 'temp' and 'currentValue'
      JS::Rooted<JS::Value> temp(cx);
      Sequence<OwningStringOrSanitizerElementNamespace> const & currentValue = mReplaceWithChildrenElements.InternalValue();

      uint32_t length = currentValue.Length();
      JS::Rooted<JSObject*> returnArray(cx, JS::NewArrayObject(cx, length));
      if (!returnArray) {
        return false;
      }
      // Scope for 'tmp'
      {
        JS::Rooted<JS::Value> tmp(cx);
        for (uint32_t sequenceIdx0 = 0; sequenceIdx0 < length; ++sequenceIdx0) {
          // Control block to let us common up the JS_DefineElement calls when there
          // are different ways to succeed at wrapping the object.
          do {
            if (!currentValue[sequenceIdx0].ToJSVal(cx, returnArray, &tmp)) {
              return false;
            }
            break;
          } while (false);
          if (!JS_DefineElement(cx, returnArray, sequenceIdx0, tmp,
                                JSPROP_ENUMERATE)) {
            return false;
          }
        }
      }
      temp.setObject(*returnArray);
      if (!JS_DefinePropertyById(cx, obj, atomsCache->replaceWithChildrenElements_id, temp, JSPROP_ENUMERATE)) {
        return false;
      }
      break;
    } while(false);
  }

  return true;
}

void
SanitizerConfig::TraceDictionary(JSTracer* trc)
{
}

SanitizerConfig&
SanitizerConfig::operator=(const SanitizerConfig& aOther)
{
  DictionaryBase::operator=(aOther);
  mAttributes.Reset();
  if (aOther.mAttributes.WasPassed()) {
    mAttributes.Construct(aOther.mAttributes.Value());
  }
  mComments.Reset();
  if (aOther.mComments.WasPassed()) {
    mComments.Construct(aOther.mComments.Value());
  }
  mDataAttributes.Reset();
  if (aOther.mDataAttributes.WasPassed()) {
    mDataAttributes.Construct(aOther.mDataAttributes.Value());
  }
  mElements.Reset();
  if (aOther.mElements.WasPassed()) {
    mElements.Construct(aOther.mElements.Value());
  }
  mRemoveAttributes.Reset();
  if (aOther.mRemoveAttributes.WasPassed()) {
    mRemoveAttributes.Construct(aOther.mRemoveAttributes.Value());
  }
  mRemoveElements.Reset();
  if (aOther.mRemoveElements.WasPassed()) {
    mRemoveElements.Construct(aOther.mRemoveElements.Value());
  }
  mReplaceWithChildrenElements.Reset();
  if (aOther.mReplaceWithChildrenElements.WasPassed()) {
    mReplaceWithChildrenElements.Construct(aOther.mReplaceWithChildrenElements.Value());
  }
  return *this;
}


bool
SanitizerConfigOrSanitizerPresets::TrySetToSanitizerConfig(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl)
{
  tryNext = false;
  { // scope for memberSlot
    binding_detail::FastSanitizerConfig& memberSlot = RawSetAsSanitizerConfig();
    if (!IsConvertibleToDictionary(value)) {
      DestroySanitizerConfig();
      tryNext = true;
      return true;
    }
    if (!memberSlot.Init(cx, value, "SanitizerConfig branch of (SanitizerConfig or SanitizerPresets)", passedToJSImpl)) {
      return false;
    }
  }
  return true;
}

bool
SanitizerConfigOrSanitizerPresets::TrySetToSanitizerConfig(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl)
{
  BindingCallContext cx(cx_, nullptr);
  return TrySetToSanitizerConfig(cx, value, tryNext, passedToJSImpl);
}







bool
SanitizerConfigOrSanitizerPresets::TrySetToSanitizerPresets(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl)
{
  tryNext = false;
  { // scope for memberSlot
    SanitizerPresets& memberSlot = RawSetAsSanitizerPresets();
    {
      int index;
      if (!binding_detail::FindEnumStringIndex<true>(cx, value,
                                                                         binding_detail::EnumStrings<SanitizerPresets>::Values,
                                                                         "SanitizerPresets", "SanitizerPresets branch of (SanitizerConfig or SanitizerPresets)",
                                                                         &index)) {
        return false;
      }
      MOZ_ASSERT(index >= 0);
      memberSlot = static_cast<SanitizerPresets>(index);
    }
  }
  return true;
}

bool
SanitizerConfigOrSanitizerPresets::TrySetToSanitizerPresets(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl)
{
  BindingCallContext cx(cx_, nullptr);
  return TrySetToSanitizerPresets(cx, value, tryNext, passedToJSImpl);
}







bool
SanitizerConfigOrSanitizerPresets::Init(BindingCallContext& cx, JS::Handle<JS::Value> value, const char* sourceDescription, bool passedToJSImpl)
{
  MOZ_ASSERT(mType == eUninitialized);

  bool done = false, failed = false, tryNext;
  if (!done) {
    done = (failed = !TrySetToSanitizerConfig(cx, value, tryNext, passedToJSImpl)) || !tryNext;
  }
  if (!done) {
    do {
      done = (failed = !TrySetToSanitizerPresets(cx, value, tryNext)) || !tryNext;
      break;
    } while (false);
  }
  if (failed) {
    return false;
  }
  if (!done) {
    cx.ThrowErrorMessage<MSG_NOT_IN_UNION>(sourceDescription, "SanitizerConfig");
    return false;
  }
  return true;
}

bool
SanitizerConfigOrSanitizerPresets::Init(JSContext* cx_, JS::Handle<JS::Value> value, const char* sourceDescription, bool passedToJSImpl)
{
  BindingCallContext cx(cx_, nullptr);
  return Init(cx, value, sourceDescription, passedToJSImpl);
}


bool
SanitizerConfigOrSanitizerPresets::ToJSVal(JSContext* cx, JS::Handle<JSObject*> scopeObj, JS::MutableHandle<JS::Value> rval) const
{
  switch (mType) {
    case eUninitialized: {
      return false;
    }
    case eSanitizerConfig: {
      if (!mValue.mSanitizerConfig.Value().ToObjectInternal(cx, rval)) {
        return false;
      }
      return true;
    }
    case eSanitizerPresets: {
      if (!ToJSValue(cx, mValue.mSanitizerPresets.Value(), rval)) {
        return false;
      }
      return true;
    }
    default: {
      return false;
    }
  }
}



OwningSanitizerConfigOrSanitizerPresets::OwningSanitizerConfigOrSanitizerPresets(OwningSanitizerConfigOrSanitizerPresets&& aOther)
  : mType(eUninitialized)
{
  switch (aOther.mType) {
    case eUninitialized: {
      MOZ_ASSERT(mType == eUninitialized,
                 "We need to destroy ourselves?");
      break;
    }
    case eSanitizerConfig: {
      mType = eSanitizerConfig;
      mValue.mSanitizerConfig.SetValue(std::move(aOther.mValue.mSanitizerConfig.Value()));
      break;
    }
    case eSanitizerPresets: {
      mType = eSanitizerPresets;
      mValue.mSanitizerPresets.SetValue(std::move(aOther.mValue.mSanitizerPresets.Value()));
      break;
    }
  }
}



bool
OwningSanitizerConfigOrSanitizerPresets::TrySetToSanitizerConfig(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl)
{
  tryNext = false;
  { // scope for memberSlot
    SanitizerConfig& memberSlot = RawSetAsSanitizerConfig();
    if (!IsConvertibleToDictionary(value)) {
      DestroySanitizerConfig();
      tryNext = true;
      return true;
    }
    if (!memberSlot.Init(cx, value, "SanitizerConfig branch of (SanitizerConfig or SanitizerPresets)", passedToJSImpl)) {
      return false;
    }
  }
  return true;
}

bool
OwningSanitizerConfigOrSanitizerPresets::TrySetToSanitizerConfig(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl)
{
  BindingCallContext cx(cx_, nullptr);
  return TrySetToSanitizerConfig(cx, value, tryNext, passedToJSImpl);
}

[[nodiscard]] SanitizerConfig&
OwningSanitizerConfigOrSanitizerPresets::RawSetAsSanitizerConfig()
{
  if (mType == eSanitizerConfig) {
    return mValue.mSanitizerConfig.Value();
  }
  MOZ_ASSERT(mType == eUninitialized);
  mType = eSanitizerConfig;
  return mValue.mSanitizerConfig.SetValue();
}

[[nodiscard]] SanitizerConfig&
OwningSanitizerConfigOrSanitizerPresets::SetAsSanitizerConfig()
{
  if (mType == eSanitizerConfig) {
    return mValue.mSanitizerConfig.Value();
  }
  Uninit();
  mType = eSanitizerConfig;
  return mValue.mSanitizerConfig.SetValue();
}


void
OwningSanitizerConfigOrSanitizerPresets::DestroySanitizerConfig()
{
  MOZ_RELEASE_ASSERT(IsSanitizerConfig(), "Wrong type!");
  mValue.mSanitizerConfig.Destroy();
  mType = eUninitialized;
}



bool
OwningSanitizerConfigOrSanitizerPresets::TrySetToSanitizerPresets(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl)
{
  tryNext = false;
  { // scope for memberSlot
    SanitizerPresets& memberSlot = RawSetAsSanitizerPresets();
    {
      int index;
      if (!binding_detail::FindEnumStringIndex<true>(cx, value,
                                                                         binding_detail::EnumStrings<SanitizerPresets>::Values,
                                                                         "SanitizerPresets", "SanitizerPresets branch of (SanitizerConfig or SanitizerPresets)",
                                                                         &index)) {
        return false;
      }
      MOZ_ASSERT(index >= 0);
      memberSlot = static_cast<SanitizerPresets>(index);
    }
  }
  return true;
}

bool
OwningSanitizerConfigOrSanitizerPresets::TrySetToSanitizerPresets(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl)
{
  BindingCallContext cx(cx_, nullptr);
  return TrySetToSanitizerPresets(cx, value, tryNext, passedToJSImpl);
}

[[nodiscard]] SanitizerPresets&
OwningSanitizerConfigOrSanitizerPresets::RawSetAsSanitizerPresets()
{
  if (mType == eSanitizerPresets) {
    return mValue.mSanitizerPresets.Value();
  }
  MOZ_ASSERT(mType == eUninitialized);
  mType = eSanitizerPresets;
  return mValue.mSanitizerPresets.SetValue();
}

[[nodiscard]] SanitizerPresets&
OwningSanitizerConfigOrSanitizerPresets::SetAsSanitizerPresets()
{
  if (mType == eSanitizerPresets) {
    return mValue.mSanitizerPresets.Value();
  }
  Uninit();
  mType = eSanitizerPresets;
  return mValue.mSanitizerPresets.SetValue();
}


void
OwningSanitizerConfigOrSanitizerPresets::DestroySanitizerPresets()
{
  MOZ_RELEASE_ASSERT(IsSanitizerPresets(), "Wrong type!");
  mValue.mSanitizerPresets.Destroy();
  mType = eUninitialized;
}



bool
OwningSanitizerConfigOrSanitizerPresets::Init(BindingCallContext& cx, JS::Handle<JS::Value> value, const char* sourceDescription, bool passedToJSImpl)
{
  MOZ_ASSERT(mType == eUninitialized);

  bool done = false, failed = false, tryNext;
  if (!done) {
    done = (failed = !TrySetToSanitizerConfig(cx, value, tryNext, passedToJSImpl)) || !tryNext;
  }
  if (!done) {
    do {
      done = (failed = !TrySetToSanitizerPresets(cx, value, tryNext)) || !tryNext;
      break;
    } while (false);
  }
  if (failed) {
    return false;
  }
  if (!done) {
    cx.ThrowErrorMessage<MSG_NOT_IN_UNION>(sourceDescription, "SanitizerConfig");
    return false;
  }
  return true;
}

bool
OwningSanitizerConfigOrSanitizerPresets::Init(JSContext* cx_, JS::Handle<JS::Value> value, const char* sourceDescription, bool passedToJSImpl)
{
  BindingCallContext cx(cx_, nullptr);
  return Init(cx, value, sourceDescription, passedToJSImpl);
}

void
OwningSanitizerConfigOrSanitizerPresets::Uninit()
{
  switch (mType) {
    case eUninitialized: {
      break;
    }
    case eSanitizerConfig: {
      DestroySanitizerConfig();
      break;
    }
    case eSanitizerPresets: {
      DestroySanitizerPresets();
      break;
    }
  }
}

bool
OwningSanitizerConfigOrSanitizerPresets::ToJSVal(JSContext* cx, JS::Handle<JSObject*> scopeObj, JS::MutableHandle<JS::Value> rval) const
{
  switch (mType) {
    case eUninitialized: {
      return false;
    }
    case eSanitizerConfig: {
      if (!mValue.mSanitizerConfig.Value().ToObjectInternal(cx, rval)) {
        return false;
      }
      return true;
    }
    case eSanitizerPresets: {
      if (!ToJSValue(cx, mValue.mSanitizerPresets.Value(), rval)) {
        return false;
      }
      return true;
    }
    default: {
      return false;
    }
  }
}

OwningSanitizerConfigOrSanitizerPresets&
OwningSanitizerConfigOrSanitizerPresets::operator=(OwningSanitizerConfigOrSanitizerPresets&& aOther)
{
  this->~OwningSanitizerConfigOrSanitizerPresets();
  new (this) OwningSanitizerConfigOrSanitizerPresets (std::move(aOther));
  return *this;
}


OwningSanitizerConfigOrSanitizerPresets&
OwningSanitizerConfigOrSanitizerPresets::operator=(const OwningSanitizerConfigOrSanitizerPresets& aOther)
{
  switch (aOther.mType) {
    case eUninitialized: {
      MOZ_ASSERT(mType == eUninitialized,
                 "We need to destroy ourselves?");
      break;
    }
    case eSanitizerConfig: {
      SetAsSanitizerConfig() = aOther.GetAsSanitizerConfig();
      break;
    }
    case eSanitizerPresets: {
      SetAsSanitizerPresets() = aOther.GetAsSanitizerPresets();
      break;
    }
  }
  return *this;
}


bool
SanitizerOrSanitizerConfigOrSanitizerPresets::TrySetToSanitizer(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl)
{
  tryNext = false;
  { // scope for memberSlot
    NonNull<mozilla::dom::Sanitizer>& memberSlot = RawSetAsSanitizer();
    {
      // Our JSContext should be in the right global to do unwrapping in.
      nsresult rv = UnwrapObject<prototypes::id::Sanitizer, mozilla::dom::Sanitizer>(value, memberSlot, cx);
      if (NS_FAILED(rv)) {
        DestroySanitizer();
        tryNext = true;
        return true;
      }
    }
  }
  return true;
}

bool
SanitizerOrSanitizerConfigOrSanitizerPresets::TrySetToSanitizer(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl)
{
  BindingCallContext cx(cx_, nullptr);
  return TrySetToSanitizer(cx, value, tryNext, passedToJSImpl);
}







bool
SanitizerOrSanitizerConfigOrSanitizerPresets::TrySetToSanitizerConfig(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl)
{
  tryNext = false;
  { // scope for memberSlot
    binding_detail::FastSanitizerConfig& memberSlot = RawSetAsSanitizerConfig();
    if (!IsConvertibleToDictionary(value)) {
      DestroySanitizerConfig();
      tryNext = true;
      return true;
    }
    if (!memberSlot.Init(cx, value, "SanitizerConfig branch of (Sanitizer or SanitizerConfig or SanitizerPresets)", passedToJSImpl)) {
      return false;
    }
  }
  return true;
}

bool
SanitizerOrSanitizerConfigOrSanitizerPresets::TrySetToSanitizerConfig(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl)
{
  BindingCallContext cx(cx_, nullptr);
  return TrySetToSanitizerConfig(cx, value, tryNext, passedToJSImpl);
}







bool
SanitizerOrSanitizerConfigOrSanitizerPresets::TrySetToSanitizerPresets(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl)
{
  tryNext = false;
  { // scope for memberSlot
    SanitizerPresets& memberSlot = RawSetAsSanitizerPresets();
    {
      int index;
      if (!binding_detail::FindEnumStringIndex<true>(cx, value,
                                                                         binding_detail::EnumStrings<SanitizerPresets>::Values,
                                                                         "SanitizerPresets", "SanitizerPresets branch of (Sanitizer or SanitizerConfig or SanitizerPresets)",
                                                                         &index)) {
        return false;
      }
      MOZ_ASSERT(index >= 0);
      memberSlot = static_cast<SanitizerPresets>(index);
    }
  }
  return true;
}

bool
SanitizerOrSanitizerConfigOrSanitizerPresets::TrySetToSanitizerPresets(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl)
{
  BindingCallContext cx(cx_, nullptr);
  return TrySetToSanitizerPresets(cx, value, tryNext, passedToJSImpl);
}







bool
SanitizerOrSanitizerConfigOrSanitizerPresets::Init(BindingCallContext& cx, JS::Handle<JS::Value> value, const char* sourceDescription, bool passedToJSImpl)
{
  MOZ_ASSERT(mType == eUninitialized);

  bool done = false, failed = false, tryNext;
  if (value.isObject()) {
    done = (failed = !TrySetToSanitizer(cx, value, tryNext, passedToJSImpl)) || !tryNext;
  }
  if (!done) {
    done = (failed = !TrySetToSanitizerConfig(cx, value, tryNext, passedToJSImpl)) || !tryNext;
  }
  if (!done) {
    do {
      done = (failed = !TrySetToSanitizerPresets(cx, value, tryNext)) || !tryNext;
      break;
    } while (false);
  }
  if (failed) {
    return false;
  }
  if (!done) {
    cx.ThrowErrorMessage<MSG_NOT_IN_UNION>(sourceDescription, "Sanitizer, SanitizerConfig");
    return false;
  }
  return true;
}

bool
SanitizerOrSanitizerConfigOrSanitizerPresets::Init(JSContext* cx_, JS::Handle<JS::Value> value, const char* sourceDescription, bool passedToJSImpl)
{
  BindingCallContext cx(cx_, nullptr);
  return Init(cx, value, sourceDescription, passedToJSImpl);
}


bool
SanitizerOrSanitizerConfigOrSanitizerPresets::ToJSVal(JSContext* cx, JS::Handle<JSObject*> scopeObj, JS::MutableHandle<JS::Value> rval) const
{
  switch (mType) {
    case eUninitialized: {
      return false;
    }
    case eSanitizer: {
      if (!GetOrCreateDOMReflector(cx, mValue.mSanitizer.Value(), rval)) {
        MOZ_ASSERT(JS_IsExceptionPending(cx));
        return false;
      }
      return true;
    }
    case eSanitizerConfig: {
      if (!mValue.mSanitizerConfig.Value().ToObjectInternal(cx, rval)) {
        return false;
      }
      return true;
    }
    case eSanitizerPresets: {
      if (!ToJSValue(cx, mValue.mSanitizerPresets.Value(), rval)) {
        return false;
      }
      return true;
    }
    default: {
      return false;
    }
  }
}



OwningSanitizerOrSanitizerConfigOrSanitizerPresets::OwningSanitizerOrSanitizerConfigOrSanitizerPresets(OwningSanitizerOrSanitizerConfigOrSanitizerPresets&& aOther)
  : mType(eUninitialized)
{
  switch (aOther.mType) {
    case eUninitialized: {
      MOZ_ASSERT(mType == eUninitialized,
                 "We need to destroy ourselves?");
      break;
    }
    case eSanitizer: {
      mType = eSanitizer;
      mValue.mSanitizer.SetValue(std::move(aOther.mValue.mSanitizer.Value()));
      break;
    }
    case eSanitizerConfig: {
      mType = eSanitizerConfig;
      mValue.mSanitizerConfig.SetValue(std::move(aOther.mValue.mSanitizerConfig.Value()));
      break;
    }
    case eSanitizerPresets: {
      mType = eSanitizerPresets;
      mValue.mSanitizerPresets.SetValue(std::move(aOther.mValue.mSanitizerPresets.Value()));
      break;
    }
  }
}



bool
OwningSanitizerOrSanitizerConfigOrSanitizerPresets::TrySetToSanitizer(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl)
{
  tryNext = false;
  { // scope for memberSlot
    OwningNonNull<mozilla::dom::Sanitizer>& memberSlot = RawSetAsSanitizer();
    static_assert(IsRefcounted<mozilla::dom::Sanitizer>::value, "We can only store refcounted classes.");
    {
      // Our JSContext should be in the right global to do unwrapping in.
      nsresult rv = UnwrapObject<prototypes::id::Sanitizer, mozilla::dom::Sanitizer>(value, memberSlot, cx);
      if (NS_FAILED(rv)) {
        DestroySanitizer();
        tryNext = true;
        return true;
      }
    }
  }
  return true;
}

bool
OwningSanitizerOrSanitizerConfigOrSanitizerPresets::TrySetToSanitizer(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl)
{
  BindingCallContext cx(cx_, nullptr);
  return TrySetToSanitizer(cx, value, tryNext, passedToJSImpl);
}

[[nodiscard]] OwningNonNull<mozilla::dom::Sanitizer>&
OwningSanitizerOrSanitizerConfigOrSanitizerPresets::RawSetAsSanitizer()
{
  if (mType == eSanitizer) {
    return mValue.mSanitizer.Value();
  }
  MOZ_ASSERT(mType == eUninitialized);
  mType = eSanitizer;
  return mValue.mSanitizer.SetValue();
}

[[nodiscard]] OwningNonNull<mozilla::dom::Sanitizer>&
OwningSanitizerOrSanitizerConfigOrSanitizerPresets::SetAsSanitizer()
{
  if (mType == eSanitizer) {
    return mValue.mSanitizer.Value();
  }
  Uninit();
  mType = eSanitizer;
  return mValue.mSanitizer.SetValue();
}


void
OwningSanitizerOrSanitizerConfigOrSanitizerPresets::DestroySanitizer()
{
  MOZ_RELEASE_ASSERT(IsSanitizer(), "Wrong type!");
  mValue.mSanitizer.Destroy();
  mType = eUninitialized;
}



bool
OwningSanitizerOrSanitizerConfigOrSanitizerPresets::TrySetToSanitizerConfig(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl)
{
  tryNext = false;
  { // scope for memberSlot
    SanitizerConfig& memberSlot = RawSetAsSanitizerConfig();
    if (!IsConvertibleToDictionary(value)) {
      DestroySanitizerConfig();
      tryNext = true;
      return true;
    }
    if (!memberSlot.Init(cx, value, "SanitizerConfig branch of (Sanitizer or SanitizerConfig or SanitizerPresets)", passedToJSImpl)) {
      return false;
    }
  }
  return true;
}

bool
OwningSanitizerOrSanitizerConfigOrSanitizerPresets::TrySetToSanitizerConfig(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl)
{
  BindingCallContext cx(cx_, nullptr);
  return TrySetToSanitizerConfig(cx, value, tryNext, passedToJSImpl);
}

[[nodiscard]] SanitizerConfig&
OwningSanitizerOrSanitizerConfigOrSanitizerPresets::RawSetAsSanitizerConfig()
{
  if (mType == eSanitizerConfig) {
    return mValue.mSanitizerConfig.Value();
  }
  MOZ_ASSERT(mType == eUninitialized);
  mType = eSanitizerConfig;
  return mValue.mSanitizerConfig.SetValue();
}

[[nodiscard]] SanitizerConfig&
OwningSanitizerOrSanitizerConfigOrSanitizerPresets::SetAsSanitizerConfig()
{
  if (mType == eSanitizerConfig) {
    return mValue.mSanitizerConfig.Value();
  }
  Uninit();
  mType = eSanitizerConfig;
  return mValue.mSanitizerConfig.SetValue();
}


void
OwningSanitizerOrSanitizerConfigOrSanitizerPresets::DestroySanitizerConfig()
{
  MOZ_RELEASE_ASSERT(IsSanitizerConfig(), "Wrong type!");
  mValue.mSanitizerConfig.Destroy();
  mType = eUninitialized;
}



bool
OwningSanitizerOrSanitizerConfigOrSanitizerPresets::TrySetToSanitizerPresets(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl)
{
  tryNext = false;
  { // scope for memberSlot
    SanitizerPresets& memberSlot = RawSetAsSanitizerPresets();
    {
      int index;
      if (!binding_detail::FindEnumStringIndex<true>(cx, value,
                                                                         binding_detail::EnumStrings<SanitizerPresets>::Values,
                                                                         "SanitizerPresets", "SanitizerPresets branch of (Sanitizer or SanitizerConfig or SanitizerPresets)",
                                                                         &index)) {
        return false;
      }
      MOZ_ASSERT(index >= 0);
      memberSlot = static_cast<SanitizerPresets>(index);
    }
  }
  return true;
}

bool
OwningSanitizerOrSanitizerConfigOrSanitizerPresets::TrySetToSanitizerPresets(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl)
{
  BindingCallContext cx(cx_, nullptr);
  return TrySetToSanitizerPresets(cx, value, tryNext, passedToJSImpl);
}

[[nodiscard]] SanitizerPresets&
OwningSanitizerOrSanitizerConfigOrSanitizerPresets::RawSetAsSanitizerPresets()
{
  if (mType == eSanitizerPresets) {
    return mValue.mSanitizerPresets.Value();
  }
  MOZ_ASSERT(mType == eUninitialized);
  mType = eSanitizerPresets;
  return mValue.mSanitizerPresets.SetValue();
}

[[nodiscard]] SanitizerPresets&
OwningSanitizerOrSanitizerConfigOrSanitizerPresets::SetAsSanitizerPresets()
{
  if (mType == eSanitizerPresets) {
    return mValue.mSanitizerPresets.Value();
  }
  Uninit();
  mType = eSanitizerPresets;
  return mValue.mSanitizerPresets.SetValue();
}


void
OwningSanitizerOrSanitizerConfigOrSanitizerPresets::DestroySanitizerPresets()
{
  MOZ_RELEASE_ASSERT(IsSanitizerPresets(), "Wrong type!");
  mValue.mSanitizerPresets.Destroy();
  mType = eUninitialized;
}



bool
OwningSanitizerOrSanitizerConfigOrSanitizerPresets::Init(BindingCallContext& cx, JS::Handle<JS::Value> value, const char* sourceDescription, bool passedToJSImpl)
{
  MOZ_ASSERT(mType == eUninitialized);

  bool done = false, failed = false, tryNext;
  if (value.isObject()) {
    done = (failed = !TrySetToSanitizer(cx, value, tryNext, passedToJSImpl)) || !tryNext;
  }
  if (!done) {
    done = (failed = !TrySetToSanitizerConfig(cx, value, tryNext, passedToJSImpl)) || !tryNext;
  }
  if (!done) {
    do {
      done = (failed = !TrySetToSanitizerPresets(cx, value, tryNext)) || !tryNext;
      break;
    } while (false);
  }
  if (failed) {
    return false;
  }
  if (!done) {
    cx.ThrowErrorMessage<MSG_NOT_IN_UNION>(sourceDescription, "Sanitizer, SanitizerConfig");
    return false;
  }
  return true;
}

bool
OwningSanitizerOrSanitizerConfigOrSanitizerPresets::Init(JSContext* cx_, JS::Handle<JS::Value> value, const char* sourceDescription, bool passedToJSImpl)
{
  BindingCallContext cx(cx_, nullptr);
  return Init(cx, value, sourceDescription, passedToJSImpl);
}

void
OwningSanitizerOrSanitizerConfigOrSanitizerPresets::Uninit()
{
  switch (mType) {
    case eUninitialized: {
      break;
    }
    case eSanitizer: {
      DestroySanitizer();
      break;
    }
    case eSanitizerConfig: {
      DestroySanitizerConfig();
      break;
    }
    case eSanitizerPresets: {
      DestroySanitizerPresets();
      break;
    }
  }
}

bool
OwningSanitizerOrSanitizerConfigOrSanitizerPresets::ToJSVal(JSContext* cx, JS::Handle<JSObject*> scopeObj, JS::MutableHandle<JS::Value> rval) const
{
  switch (mType) {
    case eUninitialized: {
      return false;
    }
    case eSanitizer: {
      if (!GetOrCreateDOMReflector(cx, mValue.mSanitizer.Value(), rval)) {
        MOZ_ASSERT(JS_IsExceptionPending(cx));
        return false;
      }
      return true;
    }
    case eSanitizerConfig: {
      if (!mValue.mSanitizerConfig.Value().ToObjectInternal(cx, rval)) {
        return false;
      }
      return true;
    }
    case eSanitizerPresets: {
      if (!ToJSValue(cx, mValue.mSanitizerPresets.Value(), rval)) {
        return false;
      }
      return true;
    }
    default: {
      return false;
    }
  }
}

OwningSanitizerOrSanitizerConfigOrSanitizerPresets&
OwningSanitizerOrSanitizerConfigOrSanitizerPresets::operator=(OwningSanitizerOrSanitizerConfigOrSanitizerPresets&& aOther)
{
  this->~OwningSanitizerOrSanitizerConfigOrSanitizerPresets();
  new (this) OwningSanitizerOrSanitizerConfigOrSanitizerPresets (std::move(aOther));
  return *this;
}


OwningSanitizerOrSanitizerConfigOrSanitizerPresets&
OwningSanitizerOrSanitizerConfigOrSanitizerPresets::operator=(const OwningSanitizerOrSanitizerConfigOrSanitizerPresets& aOther)
{
  switch (aOther.mType) {
    case eUninitialized: {
      MOZ_ASSERT(mType == eUninitialized,
                 "We need to destroy ourselves?");
      break;
    }
    case eSanitizer: {
      SetAsSanitizer() = aOther.GetAsSanitizer();
      break;
    }
    case eSanitizerConfig: {
      SetAsSanitizerConfig() = aOther.GetAsSanitizerConfig();
      break;
    }
    case eSanitizerPresets: {
      SetAsSanitizerPresets() = aOther.GetAsSanitizerPresets();
      break;
    }
  }
  return *this;
}



SetHTMLOptions::SetHTMLOptions()
{
  // Safe to pass a null context if we pass a null value
  Init(nullptr, JS::NullHandleValue);
}




bool
SetHTMLOptions::InitIds(JSContext* cx, SetHTMLOptionsAtoms* atomsCache)
{
  MOZ_ASSERT(reinterpret_cast<jsid*>(atomsCache)->isVoid());

  // Initialize these in reverse order so that any failure leaves the first one
  // uninitialized.
  if (!atomsCache->sanitizer_id.init(cx, "sanitizer")) {
    return false;
  }
  return true;
}

bool
SetHTMLOptions::Init(BindingCallContext& cx, JS::Handle<JS::Value> val, const char* sourceDescription, bool passedToJSImpl)
{
  // Passing a null JSContext is OK only if we're initing from null,
  // Since in that case we will not have to do any property gets
  // Also evaluate isNullOrUndefined in order to avoid false-positive
  // checkers by static analysis tools
  MOZ_ASSERT_IF(!cx, val.isNull() && val.isNullOrUndefined());
  SetHTMLOptionsAtoms* atomsCache = nullptr;
  if (cx) {
    atomsCache = GetAtomCache<SetHTMLOptionsAtoms>(cx);
    if (reinterpret_cast<jsid*>(atomsCache)->isVoid() &&
        !InitIds(cx, atomsCache)) {
      return false;
    }
  }

  if (!IsConvertibleToDictionary(val)) {
    return cx.ThrowErrorMessage<MSG_CONVERSION_ERROR>(sourceDescription, "dictionary");
  }

  bool isNull = val.isNullOrUndefined();
  // We only need these if !isNull, in which case we have |cx|.
  Maybe<JS::Rooted<JSObject *> > object;
  Maybe<JS::Rooted<JS::Value> > temp;
  if (!isNull) {
    MOZ_ASSERT(cx);
    object.emplace(cx, &val.toObject());
    temp.emplace(cx);
  }
  if (!isNull) {
    if (!JS_GetPropertyById(cx, *object, atomsCache->sanitizer_id, temp.ptr())) {
      return false;
    }
  }
  mSanitizer.Uninit();
  if (!(!isNull && !temp->isUndefined())) {
    mSanitizer.RawSetAsSanitizerPresets() = SanitizerPresets::Default;
  } else {
    if (!mSanitizer.Init(cx, temp.ref(), "'sanitizer' member of SetHTMLOptions", passedToJSImpl)) {
      return false;
    }
  }
  mIsAnyMemberPresent = true;
  return true;
}

bool
SetHTMLOptions::Init(JSContext* cx_, JS::Handle<JS::Value> val, const char* sourceDescription, bool passedToJSImpl)
{
  // We don't want to use sourceDescription for our context here;
  // that's not really what it's formatted for.
  BindingCallContext cx(cx_, nullptr);
  return Init(cx, val, sourceDescription, passedToJSImpl);
}

void
SetHTMLOptions::TraceDictionary(JSTracer* trc)
{
}



SetHTMLOptions&
SetHTMLOptions::operator=(const SetHTMLOptions& aOther)
{
  DictionaryBase::operator=(aOther);
  mSanitizer = aOther.mSanitizer;
  return *this;
}



SetHTMLUnsafeOptions::SetHTMLUnsafeOptions()
{
  // Safe to pass a null context if we pass a null value
  Init(nullptr, JS::NullHandleValue);
}




bool
SetHTMLUnsafeOptions::InitIds(JSContext* cx, SetHTMLUnsafeOptionsAtoms* atomsCache)
{
  MOZ_ASSERT(reinterpret_cast<jsid*>(atomsCache)->isVoid());

  // Initialize these in reverse order so that any failure leaves the first one
  // uninitialized.
  if (!atomsCache->sanitizer_id.init(cx, "sanitizer")) {
    return false;
  }
  return true;
}

bool
SetHTMLUnsafeOptions::Init(BindingCallContext& cx, JS::Handle<JS::Value> val, const char* sourceDescription, bool passedToJSImpl)
{
  // Passing a null JSContext is OK only if we're initing from null,
  // Since in that case we will not have to do any property gets
  // Also evaluate isNullOrUndefined in order to avoid false-positive
  // checkers by static analysis tools
  MOZ_ASSERT_IF(!cx, val.isNull() && val.isNullOrUndefined());
  SetHTMLUnsafeOptionsAtoms* atomsCache = nullptr;
  if (cx) {
    atomsCache = GetAtomCache<SetHTMLUnsafeOptionsAtoms>(cx);
    if (reinterpret_cast<jsid*>(atomsCache)->isVoid() &&
        !InitIds(cx, atomsCache)) {
      return false;
    }
  }

  if (!IsConvertibleToDictionary(val)) {
    return cx.ThrowErrorMessage<MSG_CONVERSION_ERROR>(sourceDescription, "dictionary");
  }

  bool isNull = val.isNullOrUndefined();
  // We only need these if !isNull, in which case we have |cx|.
  Maybe<JS::Rooted<JSObject *> > object;
  Maybe<JS::Rooted<JS::Value> > temp;
  if (!isNull) {
    MOZ_ASSERT(cx);
    object.emplace(cx, &val.toObject());
    temp.emplace(cx);
  }
  if (!isNull) {
    if (StaticPrefs::dom_security_sanitizer_enabled()) {
      if (!JS_GetPropertyById(cx, *object, atomsCache->sanitizer_id, temp.ptr())) {
        return false;
      }
    } else {
      temp->setUndefined();
    }
  }
  if (!isNull && !temp->isUndefined()) {
    mSanitizer.Construct();
    if (!(mSanitizer.Value()).Init(cx, temp.ref(), "'sanitizer' member of SetHTMLUnsafeOptions", passedToJSImpl)) {
      return false;
    }
    mIsAnyMemberPresent = true;
  }
  return true;
}

bool
SetHTMLUnsafeOptions::Init(JSContext* cx_, JS::Handle<JS::Value> val, const char* sourceDescription, bool passedToJSImpl)
{
  // We don't want to use sourceDescription for our context here;
  // that's not really what it's formatted for.
  BindingCallContext cx(cx_, nullptr);
  return Init(cx, val, sourceDescription, passedToJSImpl);
}

void
SetHTMLUnsafeOptions::TraceDictionary(JSTracer* trc)
{
}



SetHTMLUnsafeOptions&
SetHTMLUnsafeOptions::operator=(const SetHTMLUnsafeOptions& aOther)
{
  DictionaryBase::operator=(aOther);
  mSanitizer.Reset();
  if (aOther.mSanitizer.WasPassed()) {
    mSanitizer.Construct(aOther.mSanitizer.Value());
  }
  return *this;
}


namespace Sanitizer_Binding {

MOZ_CAN_RUN_SCRIPT static bool
get(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, const JSJitMethodCallArgs& args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "Sanitizer", "get", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::dom::Sanitizer*>(void_self);
  SanitizerConfig result;
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->Get(result))>, "Should be returning void here");
  MOZ_KnownLive(self)->Get(result);
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  if (!result.ToObjectInternal(cx, args.rval())) {
    return false;
  }
  return true;
}

static const JSJitInfo get_methodinfo = {
  { (JSJitGetterOp)get },
  { prototypes::id::Sanitizer },
  { PrototypeTraits<prototypes::id::Sanitizer>::Depth },
  JSJitInfo::Method,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_OBJECT,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
allowElement(JSContext* cx_, JS::Handle<JSObject*> obj, void* void_self, const JSJitMethodCallArgs& args)
{
  BindingCallContext cx(cx_, "Sanitizer.allowElement");
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "Sanitizer", "allowElement", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::dom::Sanitizer*>(void_self);
  if (!args.requireAtLeast(cx, "Sanitizer.allowElement", 1)) {
    return false;
  }
  StringOrSanitizerElementNamespaceWithAttributes arg0;
  if (!arg0.Init(cx, args[0], "Argument 1", false)) {
    return false;
  }
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->AllowElement(Constify(arg0)))>, "Should be returning void here");
  MOZ_KnownLive(self)->AllowElement(Constify(arg0));
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  args.rval().setUndefined();
  return true;
}

static const JSJitInfo allowElement_methodinfo = {
  { (JSJitGetterOp)allowElement },
  { prototypes::id::Sanitizer },
  { PrototypeTraits<prototypes::id::Sanitizer>::Depth },
  JSJitInfo::Method,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
removeElement(JSContext* cx_, JS::Handle<JSObject*> obj, void* void_self, const JSJitMethodCallArgs& args)
{
  BindingCallContext cx(cx_, "Sanitizer.removeElement");
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "Sanitizer", "removeElement", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::dom::Sanitizer*>(void_self);
  if (!args.requireAtLeast(cx, "Sanitizer.removeElement", 1)) {
    return false;
  }
  StringOrSanitizerElementNamespace arg0;
  if (!arg0.Init(cx, args[0], "Argument 1", false)) {
    return false;
  }
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->RemoveElement(Constify(arg0)))>, "Should be returning void here");
  MOZ_KnownLive(self)->RemoveElement(Constify(arg0));
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  args.rval().setUndefined();
  return true;
}

static const JSJitInfo removeElement_methodinfo = {
  { (JSJitGetterOp)removeElement },
  { prototypes::id::Sanitizer },
  { PrototypeTraits<prototypes::id::Sanitizer>::Depth },
  JSJitInfo::Method,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
replaceElementWithChildren(JSContext* cx_, JS::Handle<JSObject*> obj, void* void_self, const JSJitMethodCallArgs& args)
{
  BindingCallContext cx(cx_, "Sanitizer.replaceElementWithChildren");
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "Sanitizer", "replaceElementWithChildren", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::dom::Sanitizer*>(void_self);
  if (!args.requireAtLeast(cx, "Sanitizer.replaceElementWithChildren", 1)) {
    return false;
  }
  StringOrSanitizerElementNamespace arg0;
  if (!arg0.Init(cx, args[0], "Argument 1", false)) {
    return false;
  }
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->ReplaceElementWithChildren(Constify(arg0)))>, "Should be returning void here");
  MOZ_KnownLive(self)->ReplaceElementWithChildren(Constify(arg0));
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  args.rval().setUndefined();
  return true;
}

static const JSJitInfo replaceElementWithChildren_methodinfo = {
  { (JSJitGetterOp)replaceElementWithChildren },
  { prototypes::id::Sanitizer },
  { PrototypeTraits<prototypes::id::Sanitizer>::Depth },
  JSJitInfo::Method,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
allowAttribute(JSContext* cx_, JS::Handle<JSObject*> obj, void* void_self, const JSJitMethodCallArgs& args)
{
  BindingCallContext cx(cx_, "Sanitizer.allowAttribute");
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "Sanitizer", "allowAttribute", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::dom::Sanitizer*>(void_self);
  if (!args.requireAtLeast(cx, "Sanitizer.allowAttribute", 1)) {
    return false;
  }
  StringOrSanitizerAttributeNamespace arg0;
  if (!arg0.Init(cx, args[0], "Argument 1", false)) {
    return false;
  }
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->AllowAttribute(Constify(arg0)))>, "Should be returning void here");
  MOZ_KnownLive(self)->AllowAttribute(Constify(arg0));
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  args.rval().setUndefined();
  return true;
}

static const JSJitInfo allowAttribute_methodinfo = {
  { (JSJitGetterOp)allowAttribute },
  { prototypes::id::Sanitizer },
  { PrototypeTraits<prototypes::id::Sanitizer>::Depth },
  JSJitInfo::Method,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
removeAttribute(JSContext* cx_, JS::Handle<JSObject*> obj, void* void_self, const JSJitMethodCallArgs& args)
{
  BindingCallContext cx(cx_, "Sanitizer.removeAttribute");
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "Sanitizer", "removeAttribute", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::dom::Sanitizer*>(void_self);
  if (!args.requireAtLeast(cx, "Sanitizer.removeAttribute", 1)) {
    return false;
  }
  StringOrSanitizerAttributeNamespace arg0;
  if (!arg0.Init(cx, args[0], "Argument 1", false)) {
    return false;
  }
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->RemoveAttribute(Constify(arg0)))>, "Should be returning void here");
  MOZ_KnownLive(self)->RemoveAttribute(Constify(arg0));
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  args.rval().setUndefined();
  return true;
}

static const JSJitInfo removeAttribute_methodinfo = {
  { (JSJitGetterOp)removeAttribute },
  { prototypes::id::Sanitizer },
  { PrototypeTraits<prototypes::id::Sanitizer>::Depth },
  JSJitInfo::Method,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
setComments(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, const JSJitMethodCallArgs& args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "Sanitizer", "setComments", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::dom::Sanitizer*>(void_self);
  if (!args.requireAtLeast(cx, "Sanitizer.setComments", 1)) {
    return false;
  }
  bool arg0;
  if (!ValueToPrimitive<bool, eDefault>(cx, args[0], "Argument 1", &arg0)) {
    return false;
  }
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->SetComments(arg0))>, "Should be returning void here");
  MOZ_KnownLive(self)->SetComments(arg0);
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  args.rval().setUndefined();
  return true;
}

static const JSJitInfo setComments_methodinfo = {
  { (JSJitGetterOp)setComments },
  { prototypes::id::Sanitizer },
  { PrototypeTraits<prototypes::id::Sanitizer>::Depth },
  JSJitInfo::Method,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
setDataAttributes(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, const JSJitMethodCallArgs& args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "Sanitizer", "setDataAttributes", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::dom::Sanitizer*>(void_self);
  if (!args.requireAtLeast(cx, "Sanitizer.setDataAttributes", 1)) {
    return false;
  }
  bool arg0;
  if (!ValueToPrimitive<bool, eDefault>(cx, args[0], "Argument 1", &arg0)) {
    return false;
  }
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->SetDataAttributes(arg0))>, "Should be returning void here");
  MOZ_KnownLive(self)->SetDataAttributes(arg0);
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  args.rval().setUndefined();
  return true;
}

static const JSJitInfo setDataAttributes_methodinfo = {
  { (JSJitGetterOp)setDataAttributes },
  { prototypes::id::Sanitizer },
  { PrototypeTraits<prototypes::id::Sanitizer>::Depth },
  JSJitInfo::Method,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
removeUnsafe(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, const JSJitMethodCallArgs& args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "Sanitizer", "removeUnsafe", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::dom::Sanitizer*>(void_self);
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->RemoveUnsafe())>, "Should be returning void here");
  MOZ_KnownLive(self)->RemoveUnsafe();
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  args.rval().setUndefined();
  return true;
}

static const JSJitInfo removeUnsafe_methodinfo = {
  { (JSJitGetterOp)removeUnsafe },
  { prototypes::id::Sanitizer },
  { PrototypeTraits<prototypes::id::Sanitizer>::Depth },
  JSJitInfo::Method,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  true,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

static void
_finalize(JS::GCContext* gcx, JSObject* obj)
{
  mozilla::dom::Sanitizer* self = UnwrapPossiblyNotInitializedDOMObject<mozilla::dom::Sanitizer>(obj);
  if (self) {
    JS::SetReservedSlot(obj, DOM_OBJECT_SLOT, JS::UndefinedValue());
    ClearWrapper(self, self, obj);
    if (size_t mallocBytes = BindingJSObjectMallocBytes(self)) {
      JS::RemoveAssociatedMemory(obj, mallocBytes,
                                 JS::MemoryUse::DOMBinding);
    }
    AddForDeferredFinalization<mozilla::dom::Sanitizer>(self);
  }
}

MOZ_GLOBINIT static const JSFunctionSpec sMethods_specs[] = {
  JS_FNSPEC("get", (GenericMethod<NormalThisPolicy, ThrowExceptions>), reinterpret_cast<const JSJitInfo*>(&get_methodinfo), 0, JSPROP_ENUMERATE, nullptr),
  JS_FNSPEC("allowElement", (GenericMethod<NormalThisPolicy, ThrowExceptions>), reinterpret_cast<const JSJitInfo*>(&allowElement_methodinfo), 1, JSPROP_ENUMERATE, nullptr),
  JS_FNSPEC("removeElement", (GenericMethod<NormalThisPolicy, ThrowExceptions>), reinterpret_cast<const JSJitInfo*>(&removeElement_methodinfo), 1, JSPROP_ENUMERATE, nullptr),
  JS_FNSPEC("replaceElementWithChildren", (GenericMethod<NormalThisPolicy, ThrowExceptions>), reinterpret_cast<const JSJitInfo*>(&replaceElementWithChildren_methodinfo), 1, JSPROP_ENUMERATE, nullptr),
  JS_FNSPEC("allowAttribute", (GenericMethod<NormalThisPolicy, ThrowExceptions>), reinterpret_cast<const JSJitInfo*>(&allowAttribute_methodinfo), 1, JSPROP_ENUMERATE, nullptr),
  JS_FNSPEC("removeAttribute", (GenericMethod<NormalThisPolicy, ThrowExceptions>), reinterpret_cast<const JSJitInfo*>(&removeAttribute_methodinfo), 1, JSPROP_ENUMERATE, nullptr),
  JS_FNSPEC("setComments", (GenericMethod<NormalThisPolicy, ThrowExceptions>), reinterpret_cast<const JSJitInfo*>(&setComments_methodinfo), 1, JSPROP_ENUMERATE, nullptr),
  JS_FNSPEC("setDataAttributes", (GenericMethod<NormalThisPolicy, ThrowExceptions>), reinterpret_cast<const JSJitInfo*>(&setDataAttributes_methodinfo), 1, JSPROP_ENUMERATE, nullptr),
  JS_FNSPEC("removeUnsafe", (GenericMethod<NormalThisPolicy, ThrowExceptions>), reinterpret_cast<const JSJitInfo*>(&removeUnsafe_methodinfo), 0, JSPROP_ENUMERATE, nullptr),
  JS_FS_END
};


static const Prefable<const JSFunctionSpec> sMethods[] = {
  { nullptr, &sMethods_specs[0] },
  { nullptr, nullptr }
};

static_assert(1 <= 1ull << NUM_BITS_PROPERTY_INFO_PREF_INDEX,
    "We have a prefable index that is >= (1 << NUM_BITS_PROPERTY_INFO_PREF_INDEX)");
static_assert(9 <= 1ull << NUM_BITS_PROPERTY_INFO_SPEC_INDEX,
    "We have a spec index that is >= (1 << NUM_BITS_PROPERTY_INFO_SPEC_INDEX)");


static uint16_t sNativeProperties_sortedPropertyIndices[9];
static PropertyInfo sNativeProperties_propertyInfos[9];

static const NativePropertiesN<1> sNativeProperties = {
  false, 0,
  false, 0,
  true,  0 /* sMethods */,
  false, 0,
  false, 0,
  false, 0,
  false, 0,
  -1,
  9,
  sNativeProperties_sortedPropertyIndices,
  {
    { sMethods, &sNativeProperties_propertyInfos[0] }
  }
};
static_assert(9 < 1ull << (CHAR_BIT * sizeof(sNativeProperties.propertyInfoCount)),
    "We have a property info count that is oversized");

bool sNativePropertiesInited = false;
const NativePropertyHooks sNativePropertyHooks = {
  nullptr,
  { sNativeProperties.Upcast(), nullptr, &sNativePropertiesInited },
  prototypes::id::Sanitizer,
  constructors::id::Sanitizer,
  &DefaultXrayExpandoObjectClass
};

static bool
_constructor(JSContext* cx_, unsigned argc, JS::Value* vp)
{
  BindingCallContext cx(cx_, "Sanitizer constructor");
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "Sanitizer", "constructor", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  JS::CallArgs args = JS::CallArgsFromVp(argc, vp);
  JS::Rooted<JSObject*> obj(cx, &args.callee());
  if (!args.isConstructing()) {
    return ThrowConstructorWithoutNew(cx, "Sanitizer");
  }

  JS::Rooted<JSObject*> desiredProto(cx);
  if (!GetDesiredProto(cx, args,
                       prototypes::id::Sanitizer,
                       CreateInterfaceObjects,
                       &desiredProto)) {
    return false;
  }

  GlobalObject global(cx, obj);
  if (global.Failed()) {
    return false;
  }

  bool objIsXray = xpc::WrapperFactory::IsXrayWrapper(obj);
  SanitizerConfigOrSanitizerPresets arg0;
  if (!(args.hasDefined(0))) {
    arg0.RawSetAsSanitizerPresets() = SanitizerPresets::Default;
  } else {
    if (!arg0.Init(cx, args[0], "Argument 1", false)) {
      return false;
    }
  }
  Maybe<JSAutoRealm> ar;
  if (objIsXray) {
    // Since our object is an Xray, we can just CheckedUnwrapStatic:
    // we know Xrays have no dynamic unwrap behavior.
    obj = js::CheckedUnwrapStatic(obj);
    if (!obj) {
      return false;
    }
    ar.emplace(cx, obj);
    if (!JS_WrapObject(cx, &desiredProto)) {
      return false;
    }
  }
  FastErrorResult rv;
  auto result(StrongOrRawPtr<mozilla::dom::Sanitizer>(mozilla::dom::Sanitizer::Constructor(global, Constify(arg0), rv)));
  if (MOZ_UNLIKELY(rv.MaybeSetPendingException(cx, "Sanitizer constructor"))) {
    return false;
  }
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  SetUseCounter(obj, eUseCounter_Sanitizer_constructor);
  static_assert(!std::is_pointer_v<decltype(result)>,
                "NewObject implies that we need to keep the object alive with a strong reference.");
  if (!GetOrCreateDOMReflector(cx, result, args.rval(), desiredProto)) {
    MOZ_ASSERT(JS_IsExceptionPending(cx));
    return false;
  }
  return true;
}

static const DOMInterfaceInfo sInterfaceObjectInfo = {
  { _constructor, &sNativePropertyHooks },
  JS::GetRealmFunctionPrototypeHandle,
  PrototypeTraits<prototypes::id::Sanitizer>::Depth,
  prototypes::id::Sanitizer,
  true,
  0,
  "Sanitizer",
};

static const DOMIfaceAndProtoJSClass sPrototypeClass = {
  {
    "SanitizerPrototype",
    JSCLASS_IS_DOMIFACEANDPROTOJSCLASS | JSCLASS_HAS_RESERVED_SLOTS(DOM_INTERFACE_PROTO_SLOTS_BASE),
    JS_NULL_CLASS_OPS,
    JS_NULL_CLASS_SPEC,
    JS_NULL_CLASS_EXT,
    JS_NULL_OBJECT_OPS
  },
  eInterfacePrototype,
  prototypes::id::Sanitizer,
  PrototypeTraits<prototypes::id::Sanitizer>::Depth,
  &sNativePropertyHooks,
  JS::GetRealmObjectPrototype
};

bool
ConstructorEnabled(JSContext* aCx, JS::Handle<JSObject*> aObj)
{
  return StaticPrefs::dom_security_sanitizer_enabled();
}

static JS::Handle<JSObject*>
GetProtoObjectHandle(JSContext* aCx);

static const JSClassOps sClassOps = {
  nullptr,               /* addProperty */
  nullptr,               /* delProperty */
  nullptr,               /* enumerate */
  nullptr, /* newEnumerate */
  nullptr, /* resolve */
  nullptr, /* mayResolve */
  _finalize, /* finalize */
  nullptr, /* call */
  nullptr,               /* construct */
  nullptr, /* trace */
};

static const DOMJSClass sClass = {
  { "Sanitizer",
    JSCLASS_IS_DOMJSCLASS | JSCLASS_FOREGROUND_FINALIZE | JSCLASS_HAS_RESERVED_SLOTS(1) | JSCLASS_PRESERVES_WRAPPER,
    &sClassOps,
    JS_NULL_CLASS_SPEC,
    &NativeTypeHelpers<mozilla::dom::Sanitizer>::sClassExtension,
    JS_NULL_OBJECT_OPS
  },
  { prototypes::id::Sanitizer, prototypes::id::_ID_Count, prototypes::id::_ID_Count, prototypes::id::_ID_Count, prototypes::id::_ID_Count, prototypes::id::_ID_Count, prototypes::id::_ID_Count, prototypes::id::_ID_Count },
  std::is_base_of_v<nsISupports, mozilla::dom::Sanitizer>,
  &sNativePropertyHooks,
  FindAssociatedGlobalForNative<mozilla::dom::Sanitizer>::Get,
  GetProtoObjectHandle,
  GetCCParticipant<mozilla::dom::Sanitizer>::Get(),
  nullptr,
  NativeTypeHelpers<mozilla::dom::Sanitizer>::GetWrapperCache
};
static_assert(1 == DOM_INSTANCE_RESERVED_SLOTS,
              "Must have the right minimal number of reserved slots.");
static_assert(1 >= 1,
              "Must have enough reserved slots.");

bool
Wrap(JSContext* aCx, mozilla::dom::Sanitizer* aObject, nsWrapperCache* aCache, JS::Handle<JSObject*> aGivenProto, JS::MutableHandle<JSObject*> aReflector)
{
  static_assert(!std::is_base_of_v<NonRefcountedDOMObject, mozilla::dom::Sanitizer>,
                "Shouldn't have wrappercached things that are not refcounted.");
  static_assert(std::is_same_v<decltype(aObject), mozilla::dom::Sanitizer*>);
  MOZ_ASSERT(ToSupportsIsCorrect(aObject));
  MOZ_ASSERT_IF(aGivenProto, js::IsObjectInContextCompartment(aGivenProto, aCx));
  MOZ_ASSERT(!aCache->GetWrapper(),
             "You should probably not be using Wrap() directly; use "
             "GetOrCreateDOMReflector instead");

  MOZ_ASSERT(ToSupportsIsOnPrimaryInheritanceChain(aObject, aCache),
             "nsISupports must be on our primary inheritance chain");

  // If the wrapper cache contains a dead reflector then finalize that
  // now, ensuring that the finalizer for the old reflector always
  // runs before the new reflector is created and attached. This
  // avoids the awkward situation where there are multiple reflector
  // objects that contain pointers to the same native.

  if (JSObject* oldReflector = aCache->GetWrapperMaybeDead()) {
    _finalize(nullptr /* unused */, oldReflector);
    MOZ_ASSERT(!aCache->GetWrapperMaybeDead());
  }

  JS::Rooted<JSObject*> global(aCx, FindAssociatedGlobal(aCx, aObject->GetParentObject()));
  if (!global) {
    return false;
  }
  MOZ_ASSERT(JS_IsGlobalObject(global));
  JS::AssertObjectIsNotGray(global);

  // That might have ended up wrapping us already, due to the wonders
  // of XBL.  Check for that, and bail out as needed.
  aReflector.set(aCache->GetWrapper());
  if (aReflector) {
#ifdef DEBUG
    AssertReflectorHasGivenProto(aCx, aReflector, aGivenProto);
#endif // DEBUG
    return true;
  }

  JSAutoRealm ar(aCx, global);
  JS::Handle<JSObject*> canonicalProto = GetProtoObjectHandle(aCx);
  if (!canonicalProto) {
    return false;
  }
  JS::Rooted<JSObject*> proto(aCx);
  if (aGivenProto) {
    proto = aGivenProto;
    // Unfortunately, while aGivenProto was in the compartment of aCx
    // coming in, we changed compartments to that of "parent" so may need
    // to wrap the proto here.
    if (js::GetContextCompartment(aCx) != JS::GetCompartment(proto)) {
      if (!JS_WrapObject(aCx, &proto)) {
        return false;
      }
    }
  } else {
    proto = canonicalProto;
  }

  BindingJSObjectCreator<mozilla::dom::Sanitizer> creator(aCx);
  creator.CreateObject(aCx, sClass.ToJSClass(), proto, aObject, aReflector);
  if (!aReflector) {
    return false;
  }

  aCache->SetWrapper(aReflector);
  creator.InitializationSucceeded();

  MOZ_ASSERT(aCache->GetWrapperPreserveColor() &&
             aCache->GetWrapperPreserveColor() == aReflector);
  // If proto != canonicalProto, we have to preserve our wrapper;
  // otherwise we won't be able to properly recreate it later, since
  // we won't know what proto to use.  Note that we don't check
  // aGivenProto here, since it's entirely possible (and even
  // somewhat common) to have a non-null aGivenProto which is the
  // same as canonicalProto.
  if (proto != canonicalProto) {
    PreserveWrapper(aObject);
  }

  return true;
}

void
CreateInterfaceObjects(JSContext* aCx, JS::Handle<JSObject*> aGlobal, ProtoAndIfaceCache& aProtoAndIfaceCache, DefineInterfaceProperty aDefineOnGlobal)
{
  JS::Heap<JSObject*>* protoCache = &aProtoAndIfaceCache.EntrySlotOrCreate(prototypes::id::Sanitizer);
  JS::Heap<JSObject*>* interfaceCache = &aProtoAndIfaceCache.EntrySlotOrCreate(constructors::id::Sanitizer);

  JS::Handle<JSObject*> parentProto(JS::GetRealmObjectPrototypeHandle(aCx));
  if (!parentProto) {
    return;
  }

  JS::Handle<JSObject*> constructorProto(JS::GetRealmFunctionPrototypeHandle(aCx));
  if (!constructorProto) {
    return;
  }

  dom::CreateInterfaceObjects(aCx, aGlobal, parentProto,
                              &sPrototypeClass, protoCache,
                              constructorProto, &sInterfaceObjectInfo, 0, false, Span<const LegacyFactoryFunction, 0>{},
                              interfaceCache,
                              sNativeProperties.Upcast(),
                              nullptr,
                              "Sanitizer",
                              ShouldExpose<Sanitizer_Binding::ConstructorEnabled>(aCx, aGlobal, aDefineOnGlobal),
                              nullptr,
                              false,
                              nullptr);
}

static JS::Handle<JSObject*>
GetProtoObjectHandle(JSContext* aCx)
{
  /* Get the interface prototype object for this class.  This will create the
     object as needed. */
  return GetPerInterfaceObjectHandle(aCx, prototypes::id::Sanitizer,
                                     &CreateInterfaceObjects,
                                     DefineInterfaceProperty::CheckExposure);

}

JS::Handle<JSObject*>
GetConstructorObjectHandle(JSContext* aCx)
{
  /* Get the interface object for this class.  This will create the object as
     needed. */

  return GetPerInterfaceObjectHandle(aCx, constructors::id::Sanitizer,
                                     &CreateInterfaceObjects,
                                     DefineInterfaceProperty::CheckExposure);
}

} // namespace Sanitizer_Binding



} // namespace dom


} // namespace mozilla
