load ../lib/import

@test "import keyrings" {
	echo PKGPOOL='pool/parabola' >>"${TMP}/config.local"
	mkdir -p "${TMP}/ftp/pool/parabola"

	__releaseImportedPackage archlinux32-keyring  i686   "$TMP/rsyncd/archlinux32/i686/core/core.db.tar.gz"    "$TMP/rsyncd/archlinux32/pool"
	__releaseImportedPackage archlinuxarm-keyring armv7h "$TMP/rsyncd/archlinuxarm/armv7h/core/core.db.tar.gz"

	db-import-keyring

	bsdtar tf "$TMP/ftp/libre/os/x86_64/libre.db.tar.gz" archlinux32-keyring-1-1/desc
	bsdtar tf "$TMP/ftp/libre/os/i686/libre.db.tar.gz"   archlinux32-keyring-1-1/desc
	bsdtar tf "$TMP/ftp/libre/os/armv7h/libre.db.tar.gz" archlinux32-keyring-1-1/desc

	bsdtar tf "$TMP/ftp/libre/os/x86_64/libre.db.tar.gz" archlinuxarm-keyring-1-1/desc
	bsdtar tf "$TMP/ftp/libre/os/i686/libre.db.tar.gz"   archlinuxarm-keyring-1-1/desc
	bsdtar tf "$TMP/ftp/libre/os/armv7h/libre.db.tar.gz" archlinuxarm-keyring-1-1/desc

	__isLinkTo "$TMP/ftp/libre/os/x86_64/archlinux32-keyring-1-1-any.pkg.tar.xz" "$TMP/ftp/pool/parabola/archlinux32-keyring-1-1-any.pkg.tar.xz"
	__isLinkTo "$TMP/ftp/libre/os/i686/archlinux32-keyring-1-1-any.pkg.tar.xz"   "$TMP/ftp/pool/parabola/archlinux32-keyring-1-1-any.pkg.tar.xz"
	__isLinkTo "$TMP/ftp/libre/os/armv7h/archlinux32-keyring-1-1-any.pkg.tar.xz" "$TMP/ftp/pool/parabola/archlinux32-keyring-1-1-any.pkg.tar.xz"

	__isLinkTo "$TMP/ftp/libre/os/x86_64/archlinuxarm-keyring-1-1-any.pkg.tar.xz" "$TMP/ftp/pool/parabola/archlinuxarm-keyring-1-1-any.pkg.tar.xz"
	__isLinkTo "$TMP/ftp/libre/os/i686/archlinuxarm-keyring-1-1-any.pkg.tar.xz"   "$TMP/ftp/pool/parabola/archlinuxarm-keyring-1-1-any.pkg.tar.xz"
	__isLinkTo "$TMP/ftp/libre/os/armv7h/archlinuxarm-keyring-1-1-any.pkg.tar.xz" "$TMP/ftp/pool/parabola/archlinuxarm-keyring-1-1-any.pkg.tar.xz"

}

@test "import keyrings succeeds if there's nothing to do" {
	echo PKGPOOL='pool/parabola' >>"${TMP}/config.local"
	mkdir -p "${TMP}/ftp/pool/parabola"

	__releaseImportedPackage archlinux32-keyring  i686   "$TMP/rsyncd/archlinux32/i686/core/core.db.tar.gz"    "$TMP/rsyncd/archlinux32/pool"
	__releaseImportedPackage archlinuxarm-keyring armv7h "$TMP/rsyncd/archlinuxarm/armv7h/core/core.db.tar.gz"

	# This run will do the work
	db-import-keyring

	# And this run is a no-op
	db-import-keyring
}
