/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ml.action.agents;

import java.time.Instant;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.OpenSearchException;
import org.opensearch.action.ActionRequest;
import org.opensearch.action.index.IndexResponse;
import org.opensearch.action.support.ActionFilters;
import org.opensearch.action.support.HandledTransportAction;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.inject.Inject;
import org.opensearch.common.util.concurrent.ThreadContext;
import org.opensearch.commons.authuser.User;
import org.opensearch.core.action.ActionListener;
import org.opensearch.core.xcontent.ToXContentObject;
import org.opensearch.ml.common.MLAgentType;
import org.opensearch.ml.common.agent.MLAgent;
import org.opensearch.ml.common.agent.MLToolSpec;
import org.opensearch.ml.common.settings.MLCommonsSettings;
import org.opensearch.ml.common.settings.MLFeatureEnabledSetting;
import org.opensearch.ml.common.transport.agent.MLRegisterAgentRequest;
import org.opensearch.ml.common.transport.agent.MLRegisterAgentResponse;
import org.opensearch.ml.engine.function_calling.FunctionCallingFactory;
import org.opensearch.ml.engine.indices.MLIndicesHandler;
import org.opensearch.ml.utils.RestActionUtils;
import org.opensearch.ml.utils.TenantAwareHelper;
import org.opensearch.remote.metadata.client.PutDataObjectRequest;
import org.opensearch.remote.metadata.client.SdkClient;
import org.opensearch.remote.metadata.common.SdkClientUtils;
import org.opensearch.tasks.Task;
import org.opensearch.transport.TransportService;
import org.opensearch.transport.client.Client;

public class TransportRegisterAgentAction
extends HandledTransportAction<ActionRequest, MLRegisterAgentResponse> {
    @Generated
    private static final Logger log = LogManager.getLogger(TransportRegisterAgentAction.class);
    MLIndicesHandler mlIndicesHandler;
    Client client;
    SdkClient sdkClient;
    ClusterService clusterService;
    private final MLFeatureEnabledSetting mlFeatureEnabledSetting;

    @Inject
    public TransportRegisterAgentAction(TransportService transportService, ActionFilters actionFilters, Client client, SdkClient sdkClient, MLIndicesHandler mlIndicesHandler, ClusterService clusterService, MLFeatureEnabledSetting mlFeatureEnabledSetting) {
        super("cluster:admin/opensearch/ml/agents/register", transportService, actionFilters, MLRegisterAgentRequest::new);
        this.client = client;
        this.sdkClient = sdkClient;
        this.mlIndicesHandler = mlIndicesHandler;
        this.clusterService = clusterService;
        this.mlFeatureEnabledSetting = mlFeatureEnabledSetting;
    }

    protected void doExecute(Task task, ActionRequest request, ActionListener<MLRegisterAgentResponse> listener) {
        User user = RestActionUtils.getUserContext(this.client);
        MLRegisterAgentRequest registerAgentRequest = MLRegisterAgentRequest.fromActionRequest((ActionRequest)request);
        MLAgent mlAgent = registerAgentRequest.getMlAgent();
        this.registerAgent(mlAgent, listener);
    }

    private void registerAgent(MLAgent agent, ActionListener<MLRegisterAgentResponse> listener) {
        String llmInterface;
        String mcpConnectorConfigJSON;
        String string = mcpConnectorConfigJSON = agent.getParameters() != null ? (String)agent.getParameters().get("mcp_connectors") : null;
        if (mcpConnectorConfigJSON != null && !this.mlFeatureEnabledSetting.isMcpConnectorEnabled()) {
            listener.onFailure((Exception)new OpenSearchException(MLCommonsSettings.ML_COMMONS_MCP_CONNECTOR_DISABLED_MESSAGE, new Object[0]));
            return;
        }
        List<MLToolSpec> updatedTools = this.processQueryPlannerTools(agent);
        String string2 = llmInterface = agent.getParameters() != null ? (String)agent.getParameters().get("_llm_interface") : null;
        if (llmInterface != null) {
            if (llmInterface.trim().isEmpty()) {
                listener.onFailure((Exception)new IllegalArgumentException("_llm_interface cannot be blank or empty"));
                return;
            }
            try {
                FunctionCallingFactory.create((String)llmInterface);
            }
            catch (Exception e) {
                listener.onFailure((Exception)new IllegalArgumentException("Invalid _llm_interface: " + llmInterface));
                return;
            }
        }
        Instant now = Instant.now();
        boolean isHiddenAgent = RestActionUtils.isSuperAdminUser(this.clusterService, this.client);
        MLAgent mlAgent = agent.toBuilder().tools(updatedTools).createdTime(now).lastUpdateTime(now).isHidden(Boolean.valueOf(isHiddenAgent)).build();
        String tenantId = agent.getTenantId();
        if (!TenantAwareHelper.validateTenantId(this.mlFeatureEnabledSetting, tenantId, listener)) {
            return;
        }
        if (MLAgentType.from((String)mlAgent.getType()) == MLAgentType.PLAN_EXECUTE_AND_REFLECT && !mlAgent.getParameters().containsKey("executor_agent_id")) {
            this.createConversationAgent(mlAgent, tenantId, (ActionListener<String>)ActionListener.wrap(conversationAgentId -> {
                HashMap<String, String> parameters = new HashMap<String, String>(mlAgent.getParameters());
                parameters.put("executor_agent_id", (String)conversationAgentId);
                MLAgent updatedAgent = mlAgent.toBuilder().parameters(parameters).build();
                this.registerAgentToIndex(updatedAgent, tenantId, listener);
            }, arg_0 -> listener.onFailure(arg_0)));
        } else {
            this.registerAgentToIndex(mlAgent, tenantId, listener);
        }
    }

    private List<MLToolSpec> processQueryPlannerTools(MLAgent agent) {
        List tools;
        List updatedTools = tools = agent.getTools();
        if (tools != null && agent.getLlm() != null && agent.getLlm().getModelId() != null && !agent.getLlm().getModelId().isBlank()) {
            updatedTools = tools.stream().map(tool -> {
                if (tool.getType().equals("QueryPlanningTool")) {
                    HashMap<String, String> params = tool.getParameters() != null ? new HashMap<String, String>(tool.getParameters()) : new HashMap();
                    params.putIfAbsent("model_id", agent.getLlm().getModelId());
                    return tool.toBuilder().parameters(params).build();
                }
                return tool;
            }).collect(Collectors.toList());
        }
        return updatedTools;
    }

    private void createConversationAgent(MLAgent planExecuteReflectAgent, String tenantId, ActionListener<String> listener) {
        Instant now = Instant.now();
        boolean isHiddenAgent = RestActionUtils.isSuperAdminUser(this.clusterService, this.client);
        MLAgent conversationAgent = planExecuteReflectAgent.toBuilder().name(planExecuteReflectAgent.getName() + " (ReAct)").type(MLAgentType.CONVERSATIONAL.name()).description("Execution Agent for Plan Execute Reflect - " + planExecuteReflectAgent.getName()).createdTime(now).lastUpdateTime(now).isHidden(Boolean.valueOf(isHiddenAgent)).build();
        this.registerAgentToIndex(conversationAgent, tenantId, (ActionListener<MLRegisterAgentResponse>)ActionListener.wrap(response -> listener.onResponse((Object)response.getAgentId()), arg_0 -> listener.onFailure(arg_0)));
    }

    private void registerAgentToIndex(MLAgent mlAgent, String tenantId, ActionListener<MLRegisterAgentResponse> listener) {
        this.mlIndicesHandler.initMLAgentIndex(ActionListener.wrap(result -> {
            if (result.booleanValue()) {
                try (ThreadContext.StoredContext context = this.client.threadPool().getThreadContext().stashContext();){
                    this.sdkClient.putDataObjectAsync(((PutDataObjectRequest.Builder)((PutDataObjectRequest.Builder)PutDataObjectRequest.builder().index(".plugins-ml-agent")).tenantId(tenantId)).dataObject((ToXContentObject)mlAgent).build()).whenComplete((r, throwable) -> {
                        context.restore();
                        if (throwable != null) {
                            Exception cause = SdkClientUtils.unwrapAndConvertToException((Throwable)throwable, (Class[])new Class[0]);
                            log.error("Failed to index ML agent", (Throwable)cause);
                            listener.onFailure(cause);
                        } else {
                            try {
                                IndexResponse indexResponse = r.indexResponse();
                                log.info("Agent creation result: {}, Agent id: {}", (Object)indexResponse.getResult(), (Object)indexResponse.getId());
                                MLRegisterAgentResponse response = new MLRegisterAgentResponse(r.id());
                                listener.onResponse((Object)response);
                            }
                            catch (Exception e) {
                                listener.onFailure(e);
                            }
                        }
                    });
                }
                catch (Exception e) {
                    log.error("Failed to index ML agent", (Throwable)e);
                    listener.onFailure(e);
                }
            } else {
                log.error("Failed to create ML agent index");
                listener.onFailure((Exception)new OpenSearchException("Failed to create ML agent index", new Object[0]));
            }
        }, e -> {
            log.error("Failed to create ML agent index", (Throwable)e);
            listener.onFailure(e);
        }));
    }
}

