/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.history.integration;

import com.intellij.history.core.LocalHistoryFacade;
import com.intellij.history.core.changes.ChangeSet;
import com.intellij.history.core.changes.ChangeVisitor;
import com.intellij.history.integration.LocalHistoryImpl;
import com.intellij.history.integration.ValidateHistoryAction;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.util.ExceptionUtil;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\b\u0010\b\u001a\u00020\tH\u0016J\u0010\u0010\n\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\u000b"}, d2={"Lcom/intellij/history/integration/ValidateHistoryAction;", "Lcom/intellij/openapi/actionSystem/AnAction;", "<init>", "()V", "update", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "actionPerformed", "intellij.platform.lvcs.impl"})
public final class ValidateHistoryAction
extends AnAction {
    public void update(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        e.getPresentation().setEnabledAndVisible(ApplicationManager.getApplication().isInternal());
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        return ActionUpdateThread.BGT;
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Project project = e.getProject();
        new Task.Modal(e, project){
            final /* synthetic */ AnActionEvent $e;
            {
                this.$e = $e;
                super($super_call_param$1, "Checking local history storage", true);
            }

            public void run(ProgressIndicator indicator) {
                Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
                long t = System.currentTimeMillis();
                try {
                    LocalHistoryFacade localHistoryFacade = LocalHistoryImpl.Companion.getInstanceImpl().getFacade();
                    if (localHistoryFacade != null) {
                        localHistoryFacade.accept(new ChangeVisitor(indicator, t, this.$e){
                            private int count;
                            final /* synthetic */ ProgressIndicator $indicator;
                            final /* synthetic */ long $t;
                            final /* synthetic */ AnActionEvent $e;
                            {
                                this.$indicator = $indicator;
                                this.$t = $t;
                                this.$e = $e;
                            }

                            public void end(ChangeSet c) {
                                Intrinsics.checkNotNullParameter((Object)c, (String)"c");
                                this.$indicator.checkCanceled();
                                ++this.count;
                                if (this.count % 10 == 0) {
                                    this.$indicator.setText(this.count + " records checked");
                                }
                            }

                            public void finished() {
                                String message = "Local history storage seems to be OK (checked " + this.count + " records in " + (System.currentTimeMillis() - this.$t) + " ms)";
                                ApplicationManager.getApplication().invokeLater(() -> actionPerformed.run.1.finished$lambda$0(this.$e, message));
                            }

                            private static final void finished$lambda$0(AnActionEvent $e, String $message) {
                                Messages.showInfoMessage((Project)$e.getProject(), (String)$message, (String)"Local History Validation");
                            }
                        });
                    }
                }
                catch (ProcessCanceledException ex) {
                    throw ex;
                }
                catch (Exception ex) {
                    Messages.showErrorDialog((Project)this.$e.getProject(), (String)ExceptionUtil.getThrowableText((Throwable)ex), (String)"Local History Validation Error");
                }
            }
        }.queue();
    }
}

