/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.inspections.interpreter;

import com.intellij.codeInsight.intention.preview.IntentionPreviewInfo;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.util.IntentionFamilyName;
import com.intellij.codeInspection.util.IntentionName;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.python.sdkConfigurator.common.PublicApiKt;
import com.jetbrains.python.PyPsiBundle;
import com.jetbrains.python.sdk.configuration.CreateSdkInfo;
import com.jetbrains.python.sdk.configuration.PyProjectSdkConfiguration;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\b\u001a\u00020\tH\u0017J\b\u0010\n\u001a\u00020\tH\u0017J\u0018\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0018\u0010\u0011\u001a\u00020\u00122\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0013\u001a\u00020\u0010H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/jetbrains/python/inspections/interpreter/UseProvidedInterpreterFix;", "Lcom/intellij/codeInspection/LocalQuickFix;", "myModule", "Lcom/intellij/openapi/module/Module;", "myCreateSdkInfo", "Lcom/jetbrains/python/sdk/configuration/CreateSdkInfo;", "<init>", "(Lcom/intellij/openapi/module/Module;Lcom/jetbrains/python/sdk/configuration/CreateSdkInfo;)V", "getFamilyName", "", "getName", "applyFix", "", "project", "Lcom/intellij/openapi/project/Project;", "descriptor", "Lcom/intellij/codeInspection/ProblemDescriptor;", "generatePreview", "Lcom/intellij/codeInsight/intention/preview/IntentionPreviewInfo;", "previewDescriptor", "intellij.python.community.impl"})
final class UseProvidedInterpreterFix
implements LocalQuickFix {
    @NotNull
    private final Module myModule;
    @NotNull
    private final CreateSdkInfo myCreateSdkInfo;

    public UseProvidedInterpreterFix(@NotNull Module myModule, @NotNull CreateSdkInfo myCreateSdkInfo) {
        Intrinsics.checkNotNullParameter((Object)myModule, (String)"myModule");
        Intrinsics.checkNotNullParameter((Object)myCreateSdkInfo, (String)"myCreateSdkInfo");
        this.myModule = myModule;
        this.myCreateSdkInfo = myCreateSdkInfo;
    }

    @IntentionFamilyName
    @NotNull
    public String getFamilyName() {
        String string = PyPsiBundle.message((String)"INSP.interpreter.use.suggested.interpreter", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        return string;
    }

    @IntentionName
    @NotNull
    public String getName() {
        return this.myCreateSdkInfo.getIntentionName();
    }

    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        if (!PublicApiKt.getEnableSDKAutoConfigurator()) {
            PyProjectSdkConfiguration.INSTANCE.configureSdkUsingCreateSdkInfo(this.myModule, this.myCreateSdkInfo);
            return;
        }
        PublicApiKt.detectSdkForModulesIn((Project)project);
    }

    @NotNull
    public IntentionPreviewInfo generatePreview(@NotNull Project project, @NotNull ProblemDescriptor previewDescriptor) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)previewDescriptor, (String)"previewDescriptor");
        IntentionPreviewInfo intentionPreviewInfo = IntentionPreviewInfo.EMPTY;
        Intrinsics.checkNotNullExpressionValue((Object)intentionPreviewInfo, (String)"EMPTY");
        return intentionPreviewInfo;
    }
}

