/*
 * Decompiled with CFR 0.152.
 */
package org.ldaptive.pool;

import org.ldaptive.Connection;
import org.ldaptive.ReturnAttributes;
import org.ldaptive.SearchFilter;
import org.ldaptive.SearchOperation;
import org.ldaptive.SearchRequest;
import org.ldaptive.SearchResult;
import org.ldaptive.SearchScope;
import org.ldaptive.pool.Validator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SearchValidator
implements Validator<Connection> {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private SearchRequest searchRequest;

    public SearchValidator() {
        this.searchRequest = new SearchRequest();
        this.searchRequest.setBaseDn("");
        this.searchRequest.setSearchFilter(new SearchFilter("(objectClass=*)"));
        this.searchRequest.setReturnAttributes(ReturnAttributes.NONE.value());
        this.searchRequest.setSearchScope(SearchScope.OBJECT);
        this.searchRequest.setSizeLimit(1L);
    }

    public SearchValidator(SearchRequest sr) {
        this.searchRequest = sr;
    }

    public SearchRequest getSearchRequest() {
        return this.searchRequest;
    }

    public void setSearchRequest(SearchRequest sr) {
        this.searchRequest = sr;
    }

    @Override
    public boolean validate(Connection c) {
        boolean success = false;
        if (c != null) {
            try {
                SearchOperation search = new SearchOperation(c);
                SearchResult result = (SearchResult)search.execute(this.searchRequest).getResult();
                success = result.size() > 0;
            }
            catch (Exception e) {
                this.logger.debug("validation failed for search request {}", (Object)this.searchRequest, (Object)e);
            }
        }
        return success;
    }

    public String toString() {
        return String.format("[%s@%d::searchRequest=%s]", this.getClass().getName(), this.hashCode(), this.searchRequest);
    }
}

