/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.security.dlic.rest.api.ssl;

import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.opensearch.Version;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.common.io.stream.Writeable;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.security.dlic.rest.api.ssl.CertificateInfo;

public class CertificatesInfo
implements Writeable,
ToXContent {
    private final Map<String, List<CertificateInfo>> certificates;

    public CertificatesInfo(Map<String, List<CertificateInfo>> certificates) {
        this.certificates = certificates;
    }

    public CertificatesInfo(StreamInput in) throws IOException {
        if (in.getVersion().before(Version.V_3_0_0)) {
            Map compatMap = in.readMap(keyIn -> (CertificateType_2_19)keyIn.readEnum(CertificateType_2_19.class), listIn -> listIn.readList(CertificateInfo::new));
            this.certificates = new HashMap<String, List<CertificateInfo>>();
            for (Map.Entry entry : compatMap.entrySet()) {
                this.certificates.put(((CertificateType_2_19)((Object)entry.getKey())).value(), (List)entry.getValue());
            }
        } else {
            this.certificates = in.readMap(StreamInput::readString, listIn -> listIn.readList(CertificateInfo::new));
        }
    }

    public void writeTo(StreamOutput out) throws IOException {
        if (out.getVersion().before(Version.V_3_0_0)) {
            HashMap<CertificateType_2_19, List<CertificateInfo>> compatMap = new HashMap<CertificateType_2_19, List<CertificateInfo>>();
            for (Map.Entry<String, List<CertificateInfo>> entry : this.certificates.entrySet()) {
                if (!Set.of("http", "transport").contains(entry.getKey().toLowerCase(Locale.ROOT))) continue;
                compatMap.put(CertificateType_2_19.from(entry.getKey()), entry.getValue());
            }
            out.writeMap(compatMap, StreamOutput::writeEnum, StreamOutput::writeList);
        } else {
            out.writeMap(this.certificates, StreamOutput::writeString, StreamOutput::writeList);
        }
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject("certificates");
        for (Map.Entry<String, List<CertificateInfo>> entry : this.certificates.entrySet()) {
            builder.field(entry.getKey(), (Iterable)this.certificates.get(entry.getKey()));
        }
        return builder.endObject();
    }

    public static enum CertificateType_2_19 {
        HTTP("http"),
        TRANSPORT("transport"),
        ALL("all");

        private final String value;

        private CertificateType_2_19(String value) {
            this.value = value;
        }

        public static boolean isHttp(CertificateType_2_19 certificateType) {
            return certificateType == HTTP || certificateType == ALL;
        }

        public static boolean isTransport(CertificateType_2_19 certificateType) {
            return certificateType == TRANSPORT || certificateType == ALL;
        }

        public String value() {
            return this.value.toLowerCase(Locale.ROOT);
        }

        public static CertificateType_2_19 from(String certType) {
            if (certType == null) {
                return ALL;
            }
            for (CertificateType_2_19 t : CertificateType_2_19.values()) {
                if (!t.value.equalsIgnoreCase(certType)) continue;
                return t;
            }
            throw new IllegalArgumentException("Invalid certificate type: " + certType);
        }
    }
}

