/*
 * Decompiled with CFR 0.152.
 */
package ai.djl.training.dataset;

import ai.djl.training.dataset.RandomAccessDataset;
import ai.djl.training.dataset.Sampler;
import ai.djl.util.RandomUtils;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.stream.LongStream;

public class RandomSampler
implements Sampler.SubSampler {
    private static void swap(long[] arr, int i, int j) {
        long tmp = arr[i];
        arr[i] = arr[j];
        arr[j] = tmp;
    }

    @Override
    public Iterator<Long> sample(RandomAccessDataset dataset) {
        return new Iterate(dataset);
    }

    static class Iterate
    implements Iterator<Long> {
        private long[] indices;
        private long current;

        Iterate(RandomAccessDataset dataset) {
            long size = dataset.size();
            this.current = 0L;
            this.indices = LongStream.range(0L, size).toArray();
            for (int i = Math.toIntExact(size) - 1; i > 0; --i) {
                RandomSampler.swap(this.indices, i, RandomUtils.nextInt(i));
            }
        }

        @Override
        public boolean hasNext() {
            return this.current < (long)this.indices.length;
        }

        @Override
        public Long next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            return this.indices[Math.toIntExact(this.current++)];
        }
    }
}

