/*
 * Decompiled with CFR 0.152.
 */
package ai.djl.repository;

import ai.djl.Application;
import ai.djl.repository.Artifact;
import ai.djl.repository.Metadata;
import ai.djl.repository.Repository;
import ai.djl.repository.VersionRange;
import ai.djl.util.Progress;
import java.io.IOException;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class MRL {
    private static final Logger logger = LoggerFactory.getLogger(MRL.class);
    private String type;
    private Application application;
    private String groupId;
    private String artifactId;
    private String version;
    private String artifactName;
    private Repository repository;
    private Metadata metadata;

    private MRL(Repository repository, String type, Application application, String groupId, String artifactId, String version, String artifactName) {
        this.repository = repository;
        this.type = type;
        this.application = application;
        this.groupId = groupId;
        this.artifactId = artifactId;
        this.version = version;
        this.artifactName = artifactName;
    }

    public static MRL model(Repository repository, Application application, String groupId, String artifactId, String version, String artifactName) {
        return new MRL(repository, "model", application, groupId, artifactId, version, artifactName);
    }

    public static MRL dataset(Repository repository, Application application, String groupId, String artifactId, String version) {
        return new MRL(repository, "dataset", application, groupId, artifactId, version, null);
    }

    public static MRL undefined(Repository repository, String groupId, String artifactId) {
        return new MRL(repository, "", Application.UNDEFINED, groupId, artifactId, null, null);
    }

    public URI toURI() {
        StringBuilder sb = new StringBuilder();
        if (!this.type.isEmpty()) {
            sb.append(this.type).append('/');
        }
        sb.append(this.application.getPath()).append('/').append(this.groupId.replace('.', '/')).append('/').append(this.artifactId).append('/');
        return URI.create(sb.toString());
    }

    public Repository getRepository() {
        return this.repository;
    }

    public Application getApplication() {
        return this.application;
    }

    public String getGroupId() {
        return this.groupId;
    }

    public String getArtifactId() {
        return this.artifactId;
    }

    public String getVersion() {
        return this.version;
    }

    public Artifact getDefaultArtifact() throws IOException {
        return this.repository.resolve(this, null);
    }

    public Artifact match(Map<String, String> criteria) throws IOException {
        List<Artifact> list = this.search(criteria);
        if (list.isEmpty()) {
            return null;
        }
        if (this.artifactName != null) {
            for (Artifact artifact : list) {
                if (!this.artifactName.equals(artifact.getName())) continue;
                return artifact;
            }
            return null;
        }
        return list.get(0);
    }

    public List<Artifact> listArtifacts() throws IOException {
        return this.getMetadata().getArtifacts();
    }

    public boolean isPrepared(Artifact artifact) throws IOException {
        return Files.exists(this.repository.getResourceDirectory(artifact), new LinkOption[0]);
    }

    public void prepare(Artifact artifact) throws IOException {
        this.prepare(artifact, null);
    }

    public void prepare(Artifact artifact, Progress progress) throws IOException {
        if (artifact != null) {
            logger.debug("Preparing artifact: {}, {}", (Object)this.repository.getName(), (Object)artifact);
            this.repository.prepare(artifact, progress);
        }
    }

    private List<Artifact> search(Map<String, String> criteria) throws IOException {
        return this.getMetadata().search(VersionRange.parse(this.version), criteria);
    }

    private Metadata getMetadata() throws IOException {
        if (this.metadata == null) {
            this.metadata = this.repository.locate(this);
            if (this.metadata == null) {
                throw new IOException(this + " resource not found.");
            }
        }
        return this.metadata;
    }

    public String toString() {
        return this.toURI().toString();
    }
}

