/*
 * Decompiled with CFR 0.152.
 */
package net.rubygrapefruit.platform.prompts;

import net.rubygrapefruit.platform.prompts.AbstractListener;
import net.rubygrapefruit.platform.prompts.TextView;
import net.rubygrapefruit.platform.terminal.TerminalInputListener;

class TextEntryListener
extends AbstractListener {
    private final TextView view;
    private final String defaultValue;
    private String entered;
    private boolean finished;

    TextEntryListener(TextView view, String defaultValue) {
        this.view = view;
        this.defaultValue = defaultValue;
    }

    @Override
    boolean isFinished() {
        return this.finished;
    }

    String getEntered() {
        return this.entered;
    }

    @Override
    public void character(char ch) {
        this.view.insert(ch);
    }

    @Override
    public void controlKey(TerminalInputListener.Key key) {
        if (key == TerminalInputListener.Key.Enter) {
            this.entered = !this.view.hasValue() ? this.defaultValue : this.view.getValue();
            this.finished = true;
        } else if (key == TerminalInputListener.Key.EraseBack) {
            this.view.eraseBack();
        } else if (key == TerminalInputListener.Key.EraseForward) {
            this.view.eraseForward();
        } else if (key == TerminalInputListener.Key.LeftArrow) {
            this.view.cursorLeft();
        } else if (key == TerminalInputListener.Key.RightArrow) {
            this.view.cursorRight();
        } else if (key == TerminalInputListener.Key.Home) {
            this.view.cursorStart();
        } else if (key == TerminalInputListener.Key.End) {
            this.view.cursorEnd();
        }
    }

    @Override
    public void endInput() {
        this.finished = true;
    }
}

