/*

MIT License

Copyright (c) 2024 PCSX-Redux authors

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in all
copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
SOFTWARE.

*/

// These are the color presets for the torus demo. They are stored in a
// separate file to keep the main source file clean, but the fact this is
// a header file is an implementation detail and isn't reusable.

// Each preset is a 256-entry lookup table of RGB colors. The colors are
// going to be used as vertex colors, and the vertex colors are going to
// be interpolated across the triangles that make up the torus using
// gouraud shading. The exact selected color for each vertex will depend
// on the rotated z-value of the vertex normal.

// metallic gold
static constexpr psyqo::Color m_lut1[256] = {
    {{.r = 39, .g = 42, .b = 4}},     {{.r = 42, .g = 44, .b = 4}},     {{.r = 43, .g = 45, .b = 5}},
    {{.r = 46, .g = 47, .b = 5}},     {{.r = 48, .g = 49, .b = 5}},     {{.r = 51, .g = 51, .b = 6}},
    {{.r = 53, .g = 52, .b = 7}},     {{.r = 56, .g = 53, .b = 7}},     {{.r = 59, .g = 56, .b = 8}},
    {{.r = 62, .g = 57, .b = 8}},     {{.r = 64, .g = 59, .b = 9}},     {{.r = 66, .g = 61, .b = 9}},
    {{.r = 69, .g = 63, .b = 9}},     {{.r = 72, .g = 64, .b = 9}},     {{.r = 74, .g = 66, .b = 11}},
    {{.r = 77, .g = 67, .b = 11}},    {{.r = 78, .g = 68, .b = 11}},    {{.r = 81, .g = 70, .b = 12}},
    {{.r = 84, .g = 72, .b = 12}},    {{.r = 86, .g = 74, .b = 12}},    {{.r = 89, .g = 75, .b = 13}},
    {{.r = 91, .g = 76, .b = 14}},    {{.r = 93, .g = 78, .b = 14}},    {{.r = 95, .g = 80, .b = 14}},
    {{.r = 98, .g = 81, .b = 14}},    {{.r = 100, .g = 83, .b = 15}},   {{.r = 103, .g = 84, .b = 16}},
    {{.r = 105, .g = 86, .b = 16}},   {{.r = 107, .g = 87, .b = 17}},   {{.r = 110, .g = 89, .b = 17}},
    {{.r = 113, .g = 91, .b = 18}},   {{.r = 114, .g = 93, .b = 18}},   {{.r = 117, .g = 94, .b = 19}},
    {{.r = 120, .g = 95, .b = 19}},   {{.r = 122, .g = 96, .b = 20}},   {{.r = 124, .g = 98, .b = 20}},
    {{.r = 127, .g = 100, .b = 20}},  {{.r = 129, .g = 101, .b = 21}},  {{.r = 131, .g = 103, .b = 21}},
    {{.r = 134, .g = 105, .b = 21}},  {{.r = 136, .g = 106, .b = 22}},  {{.r = 138, .g = 109, .b = 23}},
    {{.r = 140, .g = 111, .b = 24}},  {{.r = 142, .g = 113, .b = 26}},  {{.r = 144, .g = 115, .b = 28}},
    {{.r = 146, .g = 117, .b = 29}},  {{.r = 148, .g = 119, .b = 29}},  {{.r = 150, .g = 122, .b = 31}},
    {{.r = 152, .g = 124, .b = 32}},  {{.r = 154, .g = 126, .b = 33}},  {{.r = 156, .g = 129, .b = 34}},
    {{.r = 158, .g = 130, .b = 36}},  {{.r = 159, .g = 132, .b = 37}},  {{.r = 161, .g = 135, .b = 38}},
    {{.r = 164, .g = 137, .b = 39}},  {{.r = 165, .g = 139, .b = 40}},  {{.r = 167, .g = 142, .b = 42}},
    {{.r = 170, .g = 145, .b = 45}},  {{.r = 172, .g = 148, .b = 46}},  {{.r = 174, .g = 150, .b = 48}},
    {{.r = 177, .g = 152, .b = 51}},  {{.r = 180, .g = 155, .b = 53}},  {{.r = 182, .g = 157, .b = 55}},
    {{.r = 185, .g = 160, .b = 57}},  {{.r = 187, .g = 163, .b = 60}},  {{.r = 190, .g = 166, .b = 62}},
    {{.r = 192, .g = 169, .b = 64}},  {{.r = 194, .g = 171, .b = 66}},  {{.r = 197, .g = 173, .b = 68}},
    {{.r = 200, .g = 176, .b = 70}},  {{.r = 202, .g = 179, .b = 72}},  {{.r = 205, .g = 182, .b = 74}},
    {{.r = 207, .g = 184, .b = 76}},  {{.r = 209, .g = 186, .b = 78}},  {{.r = 210, .g = 189, .b = 80}},
    {{.r = 213, .g = 192, .b = 82}},  {{.r = 215, .g = 194, .b = 84}},  {{.r = 216, .g = 196, .b = 85}},
    {{.r = 218, .g = 199, .b = 88}},  {{.r = 220, .g = 202, .b = 89}},  {{.r = 222, .g = 204, .b = 91}},
    {{.r = 225, .g = 207, .b = 93}},  {{.r = 226, .g = 208, .b = 94}},  {{.r = 228, .g = 211, .b = 96}},
    {{.r = 230, .g = 214, .b = 98}},  {{.r = 233, .g = 216, .b = 100}}, {{.r = 234, .g = 218, .b = 102}},
    {{.r = 235, .g = 219, .b = 102}}, {{.r = 235, .g = 221, .b = 103}}, {{.r = 236, .g = 221, .b = 104}},
    {{.r = 237, .g = 223, .b = 104}}, {{.r = 237, .g = 223, .b = 105}}, {{.r = 238, .g = 224, .b = 105}},
    {{.r = 238, .g = 225, .b = 106}}, {{.r = 238, .g = 226, .b = 106}}, {{.r = 239, .g = 227, .b = 107}},
    {{.r = 240, .g = 228, .b = 108}}, {{.r = 241, .g = 229, .b = 108}}, {{.r = 242, .g = 230, .b = 109}},
    {{.r = 242, .g = 231, .b = 109}}, {{.r = 243, .g = 232, .b = 110}}, {{.r = 243, .g = 233, .b = 111}},
    {{.r = 243, .g = 235, .b = 111}}, {{.r = 245, .g = 235, .b = 112}}, {{.r = 244, .g = 235, .b = 111}},
    {{.r = 243, .g = 234, .b = 110}}, {{.r = 241, .g = 232, .b = 109}}, {{.r = 240, .g = 230, .b = 108}},
    {{.r = 238, .g = 229, .b = 106}}, {{.r = 238, .g = 227, .b = 105}}, {{.r = 237, .g = 225, .b = 103}},
    {{.r = 235, .g = 223, .b = 102}}, {{.r = 233, .g = 221, .b = 100}}, {{.r = 232, .g = 220, .b = 100}},
    {{.r = 231, .g = 218, .b = 98}},  {{.r = 230, .g = 217, .b = 97}},  {{.r = 228, .g = 214, .b = 96}},
    {{.r = 227, .g = 213, .b = 94}},  {{.r = 226, .g = 211, .b = 93}},  {{.r = 224, .g = 210, .b = 91}},
    {{.r = 223, .g = 208, .b = 90}},  {{.r = 221, .g = 206, .b = 88}},  {{.r = 220, .g = 203, .b = 87}},
    {{.r = 218, .g = 202, .b = 85}},  {{.r = 217, .g = 200, .b = 85}},  {{.r = 215, .g = 198, .b = 82}},
    {{.r = 214, .g = 197, .b = 81}},  {{.r = 213, .g = 195, .b = 80}},  {{.r = 211, .g = 193, .b = 79}},
    {{.r = 210, .g = 191, .b = 76}},  {{.r = 208, .g = 189, .b = 76}},  {{.r = 206, .g = 186, .b = 73}},
    {{.r = 205, .g = 183, .b = 72}},  {{.r = 203, .g = 181, .b = 70}},  {{.r = 202, .g = 179, .b = 67}},
    {{.r = 200, .g = 176, .b = 65}},  {{.r = 198, .g = 173, .b = 63}},  {{.r = 196, .g = 171, .b = 62}},
    {{.r = 195, .g = 169, .b = 60}},  {{.r = 194, .g = 167, .b = 59}},  {{.r = 192, .g = 164, .b = 57}},
    {{.r = 191, .g = 162, .b = 55}},  {{.r = 190, .g = 160, .b = 53}},  {{.r = 188, .g = 158, .b = 52}},
    {{.r = 187, .g = 156, .b = 51}},  {{.r = 186, .g = 155, .b = 50}},  {{.r = 184, .g = 154, .b = 49}},
    {{.r = 183, .g = 153, .b = 50}},  {{.r = 182, .g = 152, .b = 48}},  {{.r = 181, .g = 151, .b = 48}},
    {{.r = 179, .g = 151, .b = 47}},  {{.r = 178, .g = 150, .b = 47}},  {{.r = 176, .g = 149, .b = 46}},
    {{.r = 176, .g = 147, .b = 45}},  {{.r = 175, .g = 147, .b = 45}},  {{.r = 173, .g = 146, .b = 44}},
    {{.r = 172, .g = 145, .b = 44}},  {{.r = 170, .g = 144, .b = 43}},  {{.r = 170, .g = 143, .b = 43}},
    {{.r = 168, .g = 142, .b = 42}},  {{.r = 169, .g = 144, .b = 43}},  {{.r = 172, .g = 146, .b = 45}},
    {{.r = 174, .g = 148, .b = 47}},  {{.r = 177, .g = 150, .b = 48}},  {{.r = 178, .g = 152, .b = 50}},
    {{.r = 181, .g = 154, .b = 52}},  {{.r = 183, .g = 156, .b = 53}},  {{.r = 186, .g = 158, .b = 55}},
    {{.r = 187, .g = 160, .b = 56}},  {{.r = 189, .g = 162, .b = 58}},  {{.r = 191, .g = 163, .b = 60}},
    {{.r = 192, .g = 165, .b = 61}},  {{.r = 195, .g = 167, .b = 63}},  {{.r = 197, .g = 169, .b = 64}},
    {{.r = 198, .g = 170, .b = 65}},  {{.r = 200, .g = 173, .b = 67}},  {{.r = 202, .g = 175, .b = 68}},
    {{.r = 203, .g = 176, .b = 70}},  {{.r = 205, .g = 178, .b = 71}},  {{.r = 205, .g = 180, .b = 71}},
    {{.r = 207, .g = 182, .b = 72}},  {{.r = 208, .g = 184, .b = 74}},  {{.r = 209, .g = 186, .b = 76}},
    {{.r = 210, .g = 187, .b = 76}},  {{.r = 211, .g = 190, .b = 78}},  {{.r = 212, .g = 192, .b = 79}},
    {{.r = 213, .g = 193, .b = 80}},  {{.r = 214, .g = 195, .b = 81}},  {{.r = 216, .g = 197, .b = 82}},
    {{.r = 216, .g = 199, .b = 83}},  {{.r = 217, .g = 201, .b = 85}},  {{.r = 217, .g = 202, .b = 86}},
    {{.r = 217, .g = 201, .b = 85}},  {{.r = 217, .g = 200, .b = 84}},  {{.r = 216, .g = 199, .b = 83}},
    {{.r = 216, .g = 198, .b = 82}},  {{.r = 214, .g = 197, .b = 81}},  {{.r = 214, .g = 196, .b = 80}},
    {{.r = 213, .g = 195, .b = 80}},  {{.r = 212, .g = 194, .b = 79}},  {{.r = 212, .g = 193, .b = 78}},
    {{.r = 212, .g = 192, .b = 77}},  {{.r = 210, .g = 191, .b = 76}},  {{.r = 210, .g = 190, .b = 76}},
    {{.r = 209, .g = 189, .b = 75}},  {{.r = 209, .g = 188, .b = 74}},  {{.r = 208, .g = 187, .b = 73}},
    {{.r = 207, .g = 185, .b = 72}},  {{.r = 205, .g = 183, .b = 70}},  {{.r = 204, .g = 181, .b = 69}},
    {{.r = 202, .g = 179, .b = 67}},  {{.r = 202, .g = 177, .b = 66}},  {{.r = 200, .g = 175, .b = 65}},
    {{.r = 199, .g = 173, .b = 63}},  {{.r = 197, .g = 171, .b = 61}},  {{.r = 196, .g = 169, .b = 60}},
    {{.r = 195, .g = 167, .b = 59}},  {{.r = 193, .g = 165, .b = 57}},  {{.r = 192, .g = 163, .b = 56}},
    {{.r = 190, .g = 161, .b = 54}},  {{.r = 189, .g = 159, .b = 53}},  {{.r = 188, .g = 157, .b = 52}},
    {{.r = 185, .g = 154, .b = 50}},  {{.r = 182, .g = 151, .b = 48}},  {{.r = 178, .g = 148, .b = 46}},
    {{.r = 175, .g = 144, .b = 45}},  {{.r = 171, .g = 141, .b = 43}},  {{.r = 168, .g = 138, .b = 42}},
    {{.r = 164, .g = 134, .b = 39}},  {{.r = 161, .g = 131, .b = 37}},  {{.r = 158, .g = 128, .b = 36}},
    {{.r = 154, .g = 124, .b = 34}},  {{.r = 151, .g = 121, .b = 33}},  {{.r = 147, .g = 117, .b = 31}},
    {{.r = 144, .g = 115, .b = 29}},  {{.r = 141, .g = 111, .b = 27}},  {{.r = 137, .g = 109, .b = 26}},
    {{.r = 144, .g = 116, .b = 39}},  {{.r = 149, .g = 124, .b = 50}},  {{.r = 155, .g = 132, .b = 62}},
    {{.r = 161, .g = 138, .b = 73}},  {{.r = 168, .g = 146, .b = 86}},  {{.r = 174, .g = 153, .b = 97}},
    {{.r = 180, .g = 162, .b = 109}}, {{.r = 186, .g = 168, .b = 121}}, {{.r = 192, .g = 176, .b = 132}},
    {{.r = 198, .g = 185, .b = 146}}, {{.r = 207, .g = 195, .b = 163}}, {{.r = 216, .g = 206, .b = 179}},
    {{.r = 225, .g = 217, .b = 196}}, {{.r = 234, .g = 228, .b = 213}}, {{.r = 242, .g = 238, .b = 230}},
    {{.r = 250, .g = 250, .b = 246}}, {{.r = 255, .g = 255, .b = 255}}, {{.r = 255, .g = 255, .b = 255}},
    {{.r = 255, .g = 255, .b = 255}},
};
// purple chrome
static constexpr psyqo::Color m_lut2[256] = {
    {{.r = 77, .g = 28, .b = 70}},    {{.r = 79, .g = 30, .b = 74}},    {{.r = 81, .g = 31, .b = 78}},
    {{.r = 83, .g = 32, .b = 81}},    {{.r = 84, .g = 34, .b = 86}},    {{.r = 87, .g = 36, .b = 89}},
    {{.r = 88, .g = 36, .b = 93}},    {{.r = 90, .g = 38, .b = 98}},    {{.r = 92, .g = 40, .b = 102}},
    {{.r = 94, .g = 42, .b = 106}},   {{.r = 96, .g = 43, .b = 111}},   {{.r = 98, .g = 45, .b = 114}},
    {{.r = 99, .g = 46, .b = 118}},   {{.r = 101, .g = 48, .b = 123}},  {{.r = 103, .g = 49, .b = 126}},
    {{.r = 105, .g = 50, .b = 131}},  {{.r = 108, .g = 53, .b = 137}},  {{.r = 110, .g = 55, .b = 142}},
    {{.r = 113, .g = 57, .b = 148}},  {{.r = 115, .g = 59, .b = 153}},  {{.r = 118, .g = 61, .b = 159}},
    {{.r = 121, .g = 63, .b = 165}},  {{.r = 123, .g = 65, .b = 170}},  {{.r = 126, .g = 67, .b = 176}},
    {{.r = 128, .g = 69, .b = 182}},  {{.r = 131, .g = 71, .b = 187}},  {{.r = 132, .g = 71, .b = 187}},
    {{.r = 133, .g = 72, .b = 187}},  {{.r = 133, .g = 72, .b = 186}},  {{.r = 133, .g = 73, .b = 186}},
    {{.r = 134, .g = 73, .b = 185}},  {{.r = 134, .g = 73, .b = 185}},  {{.r = 135, .g = 74, .b = 184}},
    {{.r = 135, .g = 74, .b = 183}},  {{.r = 136, .g = 74, .b = 182}},  {{.r = 136, .g = 74, .b = 182}},
    {{.r = 137, .g = 75, .b = 182}},  {{.r = 138, .g = 76, .b = 181}},  {{.r = 138, .g = 76, .b = 181}},
    {{.r = 139, .g = 76, .b = 179}},  {{.r = 140, .g = 77, .b = 179}},  {{.r = 140, .g = 76, .b = 179}},
    {{.r = 141, .g = 77, .b = 178}},  {{.r = 142, .g = 77, .b = 178}},  {{.r = 142, .g = 77, .b = 177}},
    {{.r = 143, .g = 78, .b = 177}},  {{.r = 143, .g = 78, .b = 176}},  {{.r = 145, .g = 78, .b = 175}},
    {{.r = 145, .g = 79, .b = 174}},  {{.r = 146, .g = 80, .b = 173}},  {{.r = 147, .g = 80, .b = 173}},
    {{.r = 148, .g = 80, .b = 172}},  {{.r = 148, .g = 81, .b = 171}},  {{.r = 149, .g = 82, .b = 170}},
    {{.r = 151, .g = 82, .b = 170}},  {{.r = 152, .g = 82, .b = 169}},  {{.r = 152, .g = 83, .b = 168}},
    {{.r = 153, .g = 84, .b = 167}},  {{.r = 154, .g = 85, .b = 166}},  {{.r = 154, .g = 84, .b = 165}},
    {{.r = 152, .g = 84, .b = 165}},  {{.r = 150, .g = 83, .b = 163}},  {{.r = 149, .g = 82, .b = 162}},
    {{.r = 147, .g = 81, .b = 161}},  {{.r = 145, .g = 81, .b = 160}},  {{.r = 143, .g = 80, .b = 158}},
    {{.r = 141, .g = 80, .b = 158}},  {{.r = 140, .g = 79, .b = 156}},  {{.r = 138, .g = 78, .b = 155}},
    {{.r = 136, .g = 78, .b = 154}},  {{.r = 135, .g = 77, .b = 153}},  {{.r = 133, .g = 76, .b = 153}},
    {{.r = 131, .g = 76, .b = 151}},  {{.r = 130, .g = 75, .b = 151}},  {{.r = 127, .g = 74, .b = 150}},
    {{.r = 126, .g = 73, .b = 148}},  {{.r = 125, .g = 72, .b = 147}},  {{.r = 123, .g = 72, .b = 146}},
    {{.r = 121, .g = 71, .b = 144}},  {{.r = 119, .g = 71, .b = 144}},  {{.r = 117, .g = 70, .b = 142}},
    {{.r = 116, .g = 69, .b = 142}},  {{.r = 115, .g = 68, .b = 140}},  {{.r = 113, .g = 68, .b = 139}},
    {{.r = 111, .g = 67, .b = 139}},  {{.r = 109, .g = 67, .b = 138}},  {{.r = 107, .g = 66, .b = 136}},
    {{.r = 106, .g = 65, .b = 135}},  {{.r = 104, .g = 64, .b = 134}},  {{.r = 102, .g = 64, .b = 133}},
    {{.r = 99, .g = 63, .b = 131}},   {{.r = 95, .g = 60, .b = 128}},   {{.r = 91, .g = 60, .b = 126}},
    {{.r = 88, .g = 58, .b = 124}},   {{.r = 84, .g = 57, .b = 121}},   {{.r = 81, .g = 54, .b = 119}},
    {{.r = 77, .g = 54, .b = 117}},   {{.r = 73, .g = 52, .b = 114}},   {{.r = 70, .g = 50, .b = 112}},
    {{.r = 66, .g = 49, .b = 110}},   {{.r = 63, .g = 48, .b = 107}},   {{.r = 59, .g = 46, .b = 105}},
    {{.r = 55, .g = 45, .b = 104}},   {{.r = 52, .g = 43, .b = 101}},   {{.r = 53, .g = 44, .b = 101}},
    {{.r = 54, .g = 45, .b = 102}},   {{.r = 57, .g = 46, .b = 103}},   {{.r = 59, .g = 47, .b = 104}},
    {{.r = 61, .g = 48, .b = 105}},   {{.r = 62, .g = 49, .b = 106}},   {{.r = 64, .g = 50, .b = 106}},
    {{.r = 67, .g = 51, .b = 107}},   {{.r = 68, .g = 52, .b = 108}},   {{.r = 70, .g = 53, .b = 110}},
    {{.r = 72, .g = 54, .b = 110}},   {{.r = 74, .g = 55, .b = 110}},   {{.r = 76, .g = 56, .b = 112}},
    {{.r = 78, .g = 56, .b = 113}},   {{.r = 80, .g = 58, .b = 113}},   {{.r = 81, .g = 59, .b = 115}},
    {{.r = 84, .g = 60, .b = 115}},   {{.r = 85, .g = 61, .b = 116}},   {{.r = 87, .g = 62, .b = 117}},
    {{.r = 90, .g = 63, .b = 118}},   {{.r = 92, .g = 64, .b = 119}},   {{.r = 94, .g = 65, .b = 120}},
    {{.r = 97, .g = 67, .b = 121}},   {{.r = 99, .g = 67, .b = 122}},   {{.r = 101, .g = 69, .b = 123}},
    {{.r = 104, .g = 70, .b = 125}},  {{.r = 106, .g = 71, .b = 126}},  {{.r = 108, .g = 72, .b = 127}},
    {{.r = 111, .g = 74, .b = 128}},  {{.r = 113, .g = 75, .b = 129}},  {{.r = 116, .g = 76, .b = 130}},
    {{.r = 117, .g = 77, .b = 131}},  {{.r = 120, .g = 79, .b = 132}},  {{.r = 123, .g = 80, .b = 133}},
    {{.r = 125, .g = 81, .b = 134}},  {{.r = 127, .g = 82, .b = 135}},  {{.r = 128, .g = 83, .b = 136}},
    {{.r = 129, .g = 84, .b = 137}},  {{.r = 129, .g = 84, .b = 138}},  {{.r = 130, .g = 85, .b = 138}},
    {{.r = 131, .g = 86, .b = 139}},  {{.r = 131, .g = 87, .b = 140}},  {{.r = 132, .g = 87, .b = 141}},
    {{.r = 132, .g = 88, .b = 142}},  {{.r = 133, .g = 88, .b = 143}},  {{.r = 134, .g = 89, .b = 144}},
    {{.r = 134, .g = 90, .b = 144}},  {{.r = 134, .g = 91, .b = 146}},  {{.r = 135, .g = 92, .b = 146}},
    {{.r = 136, .g = 93, .b = 147}},  {{.r = 137, .g = 94, .b = 148}},  {{.r = 137, .g = 94, .b = 149}},
    {{.r = 137, .g = 94, .b = 150}},  {{.r = 138, .g = 95, .b = 151}},  {{.r = 138, .g = 96, .b = 152}},
    {{.r = 139, .g = 97, .b = 153}},  {{.r = 139, .g = 97, .b = 154}},  {{.r = 140, .g = 98, .b = 155}},
    {{.r = 141, .g = 99, .b = 155}},  {{.r = 142, .g = 100, .b = 157}}, {{.r = 143, .g = 100, .b = 157}},
    {{.r = 143, .g = 101, .b = 158}}, {{.r = 144, .g = 101, .b = 159}}, {{.r = 143, .g = 103, .b = 160}},
    {{.r = 144, .g = 103, .b = 161}}, {{.r = 145, .g = 104, .b = 162}}, {{.r = 146, .g = 104, .b = 163}},
    {{.r = 146, .g = 106, .b = 164}}, {{.r = 147, .g = 106, .b = 164}}, {{.r = 148, .g = 106, .b = 166}},
    {{.r = 148, .g = 107, .b = 166}}, {{.r = 149, .g = 108, .b = 167}}, {{.r = 149, .g = 109, .b = 168}},
    {{.r = 150, .g = 110, .b = 168}}, {{.r = 151, .g = 110, .b = 170}}, {{.r = 151, .g = 112, .b = 171}},
    {{.r = 151, .g = 112, .b = 171}}, {{.r = 152, .g = 112, .b = 173}}, {{.r = 152, .g = 113, .b = 173}},
    {{.r = 154, .g = 115, .b = 175}}, {{.r = 155, .g = 116, .b = 176}}, {{.r = 155, .g = 117, .b = 178}},
    {{.r = 157, .g = 118, .b = 179}}, {{.r = 157, .g = 119, .b = 180}}, {{.r = 158, .g = 120, .b = 182}},
    {{.r = 159, .g = 121, .b = 183}}, {{.r = 160, .g = 122, .b = 185}}, {{.r = 161, .g = 123, .b = 186}},
    {{.r = 162, .g = 124, .b = 188}}, {{.r = 163, .g = 126, .b = 189}}, {{.r = 165, .g = 127, .b = 190}},
    {{.r = 165, .g = 128, .b = 192}}, {{.r = 165, .g = 129, .b = 193}}, {{.r = 167, .g = 130, .b = 195}},
    {{.r = 167, .g = 131, .b = 196}}, {{.r = 169, .g = 132, .b = 198}}, {{.r = 170, .g = 134, .b = 199}},
    {{.r = 171, .g = 135, .b = 201}}, {{.r = 171, .g = 136, .b = 201}}, {{.r = 172, .g = 137, .b = 203}},
    {{.r = 173, .g = 139, .b = 205}}, {{.r = 175, .g = 140, .b = 206}}, {{.r = 175, .g = 141, .b = 208}},
    {{.r = 176, .g = 141, .b = 209}}, {{.r = 177, .g = 143, .b = 210}}, {{.r = 178, .g = 144, .b = 212}},
    {{.r = 178, .g = 144, .b = 212}}, {{.r = 176, .g = 142, .b = 209}}, {{.r = 173, .g = 140, .b = 206}},
    {{.r = 171, .g = 138, .b = 203}}, {{.r = 169, .g = 137, .b = 200}}, {{.r = 166, .g = 135, .b = 198}},
    {{.r = 164, .g = 133, .b = 195}}, {{.r = 161, .g = 131, .b = 192}}, {{.r = 159, .g = 129, .b = 190}},
    {{.r = 157, .g = 127, .b = 187}}, {{.r = 155, .g = 126, .b = 184}}, {{.r = 152, .g = 123, .b = 180}},
    {{.r = 150, .g = 121, .b = 178}}, {{.r = 147, .g = 119, .b = 175}}, {{.r = 145, .g = 118, .b = 172}},
    {{.r = 143, .g = 116, .b = 169}}, {{.r = 140, .g = 114, .b = 167}}, {{.r = 138, .g = 112, .b = 164}},
    {{.r = 136, .g = 110, .b = 161}}, {{.r = 133, .g = 108, .b = 159}}, {{.r = 131, .g = 106, .b = 155}},
    {{.r = 129, .g = 104, .b = 153}}, {{.r = 126, .g = 102, .b = 150}}, {{.r = 123, .g = 100, .b = 147}},
    {{.r = 121, .g = 98, .b = 145}},  {{.r = 119, .g = 96, .b = 142}},  {{.r = 117, .g = 94, .b = 139}},
    {{.r = 114, .g = 92, .b = 136}},  {{.r = 111, .g = 90, .b = 132}},  {{.r = 108, .g = 87, .b = 128}},
    {{.r = 104, .g = 85, .b = 124}},  {{.r = 100, .g = 82, .b = 120}},  {{.r = 97, .g = 79, .b = 116}},
    {{.r = 94, .g = 76, .b = 112}},   {{.r = 90, .g = 73, .b = 107}},   {{.r = 86, .g = 70, .b = 102}},
    {{.r = 83, .g = 68, .b = 98}},    {{.r = 79, .g = 64, .b = 95}},    {{.r = 75, .g = 62, .b = 90}},
    {{.r = 72, .g = 58, .b = 85}},    {{.r = 68, .g = 55, .b = 82}},    {{.r = 65, .g = 53, .b = 77}},
    {{.r = 61, .g = 50, .b = 73}},    {{.r = 57, .g = 47, .b = 69}},    {{.r = 54, .g = 44, .b = 64}},
    {{.r = 51, .g = 41, .b = 60}},
};
// skyline
static constexpr psyqo::Color m_lut3[256]{
    {{.r = 255, .g = 255, .b = 255}}, {{.r = 254, .g = 255, .b = 253}}, {{.r = 254, .g = 255, .b = 253}},
    {{.r = 254, .g = 254, .b = 252}}, {{.r = 254, .g = 254, .b = 250}}, {{.r = 254, .g = 254, .b = 250}},
    {{.r = 253, .g = 254, .b = 249}}, {{.r = 253, .g = 254, .b = 248}}, {{.r = 253, .g = 254, .b = 247}},
    {{.r = 253, .g = 253, .b = 247}}, {{.r = 252, .g = 254, .b = 245}}, {{.r = 252, .g = 253, .b = 244}},
    {{.r = 252, .g = 253, .b = 244}}, {{.r = 252, .g = 253, .b = 243}}, {{.r = 251, .g = 253, .b = 242}},
    {{.r = 251, .g = 252, .b = 240}}, {{.r = 251, .g = 252, .b = 239}}, {{.r = 250, .g = 253, .b = 239}},
    {{.r = 251, .g = 253, .b = 238}}, {{.r = 250, .g = 252, .b = 237}}, {{.r = 250, .g = 252, .b = 236}},
    {{.r = 249, .g = 252, .b = 235}}, {{.r = 249, .g = 251, .b = 234}}, {{.r = 249, .g = 251, .b = 233}},
    {{.r = 249, .g = 252, .b = 232}}, {{.r = 248, .g = 251, .b = 232}}, {{.r = 249, .g = 251, .b = 231}},
    {{.r = 248, .g = 251, .b = 229}}, {{.r = 248, .g = 251, .b = 229}}, {{.r = 248, .g = 251, .b = 228}},
    {{.r = 247, .g = 250, .b = 227}}, {{.r = 247, .g = 251, .b = 226}}, {{.r = 246, .g = 251, .b = 225}},
    {{.r = 246, .g = 250, .b = 224}}, {{.r = 246, .g = 250, .b = 223}}, {{.r = 246, .g = 249, .b = 222}},
    {{.r = 245, .g = 249, .b = 222}}, {{.r = 246, .g = 250, .b = 220}}, {{.r = 245, .g = 249, .b = 220}},
    {{.r = 245, .g = 249, .b = 218}}, {{.r = 245, .g = 249, .b = 218}}, {{.r = 244, .g = 249, .b = 217}},
    {{.r = 244, .g = 249, .b = 215}}, {{.r = 244, .g = 249, .b = 215}}, {{.r = 243, .g = 249, .b = 214}},
    {{.r = 244, .g = 248, .b = 213}}, {{.r = 243, .g = 248, .b = 212}}, {{.r = 243, .g = 248, .b = 211}},
    {{.r = 242, .g = 248, .b = 210}}, {{.r = 242, .g = 247, .b = 210}}, {{.r = 242, .g = 248, .b = 208}},
    {{.r = 242, .g = 247, .b = 207}}, {{.r = 242, .g = 247, .b = 206}}, {{.r = 242, .g = 246, .b = 205}},
    {{.r = 242, .g = 244, .b = 203}}, {{.r = 242, .g = 243, .b = 201}}, {{.r = 242, .g = 242, .b = 200}},
    {{.r = 243, .g = 240, .b = 199}}, {{.r = 243, .g = 240, .b = 197}}, {{.r = 243, .g = 239, .b = 195}},
    {{.r = 243, .g = 237, .b = 194}}, {{.r = 243, .g = 236, .b = 193}}, {{.r = 243, .g = 235, .b = 191}},
    {{.r = 244, .g = 234, .b = 190}}, {{.r = 244, .g = 232, .b = 188}}, {{.r = 243, .g = 231, .b = 186}},
    {{.r = 244, .g = 230, .b = 185}}, {{.r = 244, .g = 229, .b = 183}}, {{.r = 244, .g = 227, .b = 181}},
    {{.r = 245, .g = 227, .b = 180}}, {{.r = 245, .g = 225, .b = 179}}, {{.r = 244, .g = 224, .b = 176}},
    {{.r = 245, .g = 222, .b = 175}}, {{.r = 245, .g = 222, .b = 174}}, {{.r = 245, .g = 220, .b = 172}},
    {{.r = 245, .g = 219, .b = 170}}, {{.r = 245, .g = 218, .b = 169}}, {{.r = 245, .g = 216, .b = 168}},
    {{.r = 246, .g = 215, .b = 166}}, {{.r = 246, .g = 215, .b = 164}}, {{.r = 246, .g = 213, .b = 163}},
    {{.r = 246, .g = 212, .b = 162}}, {{.r = 246, .g = 211, .b = 160}}, {{.r = 247, .g = 210, .b = 158}},
    {{.r = 246, .g = 209, .b = 156}}, {{.r = 246, .g = 207, .b = 155}}, {{.r = 247, .g = 206, .b = 153}},
    {{.r = 247, .g = 204, .b = 152}}, {{.r = 247, .g = 204, .b = 150}}, {{.r = 247, .g = 203, .b = 149}},
    {{.r = 248, .g = 201, .b = 147}}, {{.r = 247, .g = 201, .b = 146}}, {{.r = 248, .g = 199, .b = 144}},
    {{.r = 248, .g = 198, .b = 143}}, {{.r = 248, .g = 196, .b = 141}}, {{.r = 248, .g = 195, .b = 140}},
    {{.r = 248, .g = 194, .b = 138}}, {{.r = 249, .g = 192, .b = 136}}, {{.r = 248, .g = 190, .b = 134}},
    {{.r = 249, .g = 188, .b = 130}}, {{.r = 249, .g = 187, .b = 128}}, {{.r = 250, .g = 185, .b = 126}},
    {{.r = 249, .g = 182, .b = 123}}, {{.r = 250, .g = 181, .b = 120}}, {{.r = 250, .g = 179, .b = 118}},
    {{.r = 250, .g = 177, .b = 116}}, {{.r = 251, .g = 175, .b = 113}}, {{.r = 251, .g = 173, .b = 111}},
    {{.r = 251, .g = 171, .b = 108}}, {{.r = 252, .g = 169, .b = 105}}, {{.r = 252, .g = 167, .b = 103}},
    {{.r = 252, .g = 165, .b = 100}}, {{.r = 253, .g = 163, .b = 98}},  {{.r = 253, .g = 162, .b = 95}},
    {{.r = 252, .g = 160, .b = 93}},  {{.r = 253, .g = 157, .b = 90}},  {{.r = 253, .g = 156, .b = 88}},
    {{.r = 254, .g = 153, .b = 85}},  {{.r = 254, .g = 152, .b = 83}},  {{.r = 254, .g = 150, .b = 81}},
    {{.r = 254, .g = 148, .b = 78}},  {{.r = 254, .g = 146, .b = 75}},  {{.r = 255, .g = 144, .b = 73}},
    {{.r = 255, .g = 142, .b = 70}},  {{.r = 251, .g = 136, .b = 68}},  {{.r = 238, .g = 122, .b = 65}},
    {{.r = 225, .g = 108, .b = 62}},  {{.r = 212, .g = 94, .b = 58}},   {{.r = 202, .g = 83, .b = 56}},
    {{.r = 194, .g = 74, .b = 54}},   {{.r = 185, .g = 65, .b = 53}},   {{.r = 178, .g = 56, .b = 50}},
    {{.r = 170, .g = 47, .b = 48}},   {{.r = 161, .g = 39, .b = 46}},   {{.r = 152, .g = 30, .b = 45}},
    {{.r = 144, .g = 26, .b = 41}},   {{.r = 135, .g = 27, .b = 38}},   {{.r = 126, .g = 29, .b = 34}},
    {{.r = 116, .g = 31, .b = 30}},   {{.r = 108, .g = 33, .b = 26}},   {{.r = 99, .g = 34, .b = 23}},
    {{.r = 91, .g = 36, .b = 20}},    {{.r = 83, .g = 38, .b = 16}},    {{.r = 74, .g = 40, .b = 13}},
    {{.r = 74, .g = 42, .b = 20}},    {{.r = 74, .g = 45, .b = 28}},    {{.r = 75, .g = 48, .b = 37}},
    {{.r = 76, .g = 51, .b = 44}},    {{.r = 76, .g = 54, .b = 52}},    {{.r = 76, .g = 57, .b = 60}},
    {{.r = 77, .g = 60, .b = 68}},    {{.r = 77, .g = 63, .b = 77}},    {{.r = 78, .g = 65, .b = 84}},
    {{.r = 79, .g = 68, .b = 92}},    {{.r = 79, .g = 71, .b = 100}},   {{.r = 79, .g = 74, .b = 108}},
    {{.r = 80, .g = 76, .b = 113}},   {{.r = 80, .g = 77, .b = 117}},   {{.r = 80, .g = 79, .b = 122}},
    {{.r = 80, .g = 80, .b = 125}},   {{.r = 81, .g = 82, .b = 130}},   {{.r = 81, .g = 83, .b = 134}},
    {{.r = 81, .g = 85, .b = 138}},   {{.r = 81, .g = 86, .b = 142}},   {{.r = 82, .g = 88, .b = 147}},
    {{.r = 82, .g = 89, .b = 151}},   {{.r = 83, .g = 91, .b = 155}},   {{.r = 83, .g = 93, .b = 160}},
    {{.r = 83, .g = 94, .b = 164}},   {{.r = 84, .g = 96, .b = 168}},   {{.r = 84, .g = 97, .b = 172}},
    {{.r = 84, .g = 98, .b = 176}},   {{.r = 84, .g = 101, .b = 180}},  {{.r = 85, .g = 102, .b = 185}},
    {{.r = 84, .g = 103, .b = 190}},  {{.r = 85, .g = 105, .b = 194}},  {{.r = 85, .g = 106, .b = 197}},
    {{.r = 86, .g = 108, .b = 202}},  {{.r = 87, .g = 109, .b = 205}},  {{.r = 89, .g = 112, .b = 205}},
    {{.r = 90, .g = 113, .b = 206}},  {{.r = 92, .g = 115, .b = 206}},  {{.r = 93, .g = 117, .b = 207}},
    {{.r = 95, .g = 119, .b = 208}},  {{.r = 97, .g = 121, .b = 209}},  {{.r = 99, .g = 123, .b = 209}},
    {{.r = 101, .g = 125, .b = 210}}, {{.r = 102, .g = 127, .b = 211}}, {{.r = 104, .g = 128, .b = 211}},
    {{.r = 106, .g = 130, .b = 212}}, {{.r = 108, .g = 132, .b = 212}}, {{.r = 109, .g = 134, .b = 213}},
    {{.r = 111, .g = 136, .b = 214}}, {{.r = 113, .g = 138, .b = 215}}, {{.r = 115, .g = 140, .b = 215}},
    {{.r = 116, .g = 142, .b = 216}}, {{.r = 119, .g = 143, .b = 217}}, {{.r = 120, .g = 146, .b = 217}},
    {{.r = 121, .g = 148, .b = 218}}, {{.r = 123, .g = 150, .b = 219}}, {{.r = 125, .g = 151, .b = 219}},
    {{.r = 127, .g = 153, .b = 220}}, {{.r = 129, .g = 155, .b = 221}}, {{.r = 130, .g = 157, .b = 221}},
    {{.r = 133, .g = 159, .b = 222}}, {{.r = 134, .g = 161, .b = 223}}, {{.r = 135, .g = 163, .b = 223}},
    {{.r = 137, .g = 165, .b = 224}}, {{.r = 139, .g = 167, .b = 225}}, {{.r = 141, .g = 168, .b = 225}},
    {{.r = 143, .g = 170, .b = 226}}, {{.r = 144, .g = 173, .b = 227}}, {{.r = 147, .g = 174, .b = 227}},
    {{.r = 148, .g = 176, .b = 228}}, {{.r = 149, .g = 178, .b = 228}}, {{.r = 152, .g = 180, .b = 229}},
    {{.r = 153, .g = 182, .b = 230}}, {{.r = 155, .g = 183, .b = 230}}, {{.r = 156, .g = 185, .b = 231}},
    {{.r = 159, .g = 187, .b = 232}}, {{.r = 160, .g = 189, .b = 233}}, {{.r = 161, .g = 191, .b = 234}},
    {{.r = 164, .g = 193, .b = 234}}, {{.r = 165, .g = 194, .b = 235}}, {{.r = 167, .g = 197, .b = 235}},
    {{.r = 168, .g = 198, .b = 236}}, {{.r = 170, .g = 200, .b = 236}}, {{.r = 171, .g = 201, .b = 237}},
    {{.r = 173, .g = 204, .b = 238}}, {{.r = 175, .g = 205, .b = 239}}, {{.r = 176, .g = 207, .b = 239}},
    {{.r = 178, .g = 209, .b = 240}}, {{.r = 180, .g = 211, .b = 241}}, {{.r = 181, .g = 213, .b = 241}},
    {{.r = 183, .g = 214, .b = 242}}, {{.r = 185, .g = 216, .b = 242}}, {{.r = 187, .g = 218, .b = 243}},
    {{.r = 188, .g = 220, .b = 244}}, {{.r = 190, .g = 222, .b = 245}}, {{.r = 191, .g = 224, .b = 245}},
    {{.r = 193, .g = 225, .b = 245}}, {{.r = 195, .g = 227, .b = 246}}, {{.r = 197, .g = 229, .b = 247}},
    {{.r = 198, .g = 230, .b = 247}}, {{.r = 200, .g = 232, .b = 248}}, {{.r = 202, .g = 235, .b = 249}},
    {{.r = 203, .g = 236, .b = 250}}, {{.r = 205, .g = 238, .b = 250}}, {{.r = 207, .g = 240, .b = 251}},
    {{.r = 208, .g = 242, .b = 251}}, {{.r = 210, .g = 244, .b = 252}}, {{.r = 211, .g = 245, .b = 253}},
    {{.r = 213, .g = 247, .b = 254}}, {{.r = 214, .g = 249, .b = 254}}, {{.r = 216, .g = 251, .b = 255}},
    {{.r = 217, .g = 251, .b = 255}},
};
